package webshell

import (
	_ "embed"
	"fmt"
)

var (
	//go:embed jsp/webshell.jsp
	GetKeyed string
	//go:embed jsp/webshell_min.jsp
	GetKeyedMinimal string
)

// GetKeyed generates a JSP webshell that uses key as the basic authorization for a webshell. This
// webshell will return all output information.
func (jsp *JSPWebshell) GetKeyed(key string) string {
	return fmt.Sprintf(GetKeyed, key, key)
}

// GetKeyedMinimal generates a JSP webshell that uses key for basic GET authentication. Unlike
// GetKeyed, this payload does not return any information directly and is more useful for staging
// other implants or reverse shell payloads.
func (jsp *JSPWebshell) GetKeyedMinimal(key string) string {
	return fmt.Sprintf(GetKeyedMinimal, key)
}
