// Package filesystem provides the Chrome DevTools Protocol
// commands, types, and events for the FileSystem domain.
//
// Generated by the cdproto-gen command.
package filesystem

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// GetDirectoryParams [no description].
type GetDirectoryParams struct {
	BucketFileSystemLocator *BucketFileSystemLocator `json:"bucketFileSystemLocator"`
}

// GetDirectory [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/FileSystem#method-getDirectory
//
// parameters:
//
//	bucketFileSystemLocator
func GetDirectory(bucketFileSystemLocator *BucketFileSystemLocator) *GetDirectoryParams {
	return &GetDirectoryParams{
		BucketFileSystemLocator: bucketFileSystemLocator,
	}
}

// GetDirectoryReturns return values.
type GetDirectoryReturns struct {
	Directory *Directory `json:"directory,omitempty,omitzero"` // Returns the directory object at the path.
}

// Do executes FileSystem.getDirectory against the provided context.
//
// returns:
//
//	directory - Returns the directory object at the path.
func (p *GetDirectoryParams) Do(ctx context.Context) (directory *Directory, err error) {
	// execute
	var res GetDirectoryReturns
	err = cdp.Execute(ctx, CommandGetDirectory, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Directory, nil
}

// Command names.
const (
	CommandGetDirectory = "FileSystem.getDirectory"
)
