// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

type Oracle struct {
	// The version declared by the service when it accepts the handshake, if applicable.
	AcceptVersion *int `json:"accept_version,omitempty"`
	// The first set of ConnectFlags returned in the Accept packet.
	ConnectFlags0 map[string]bool `json:"connect_flags0,omitempty"`
	// The second set of ConnectFlags returned in the Accept packet.
	ConnectFlags1 map[string]bool `json:"connect_flags1,omitempty"`
	// Whether the server requested that the scanner resend its initial connection packet.
	DidResend *bool `json:"did_resend,omitempty"`
	// Set of flags that the server returns in the Accept packet.
	GlobalServiceOptions map[string]bool `json:"global_service_options,omitempty"`
	// A map from the native Service Negotation service names to the ReleaseVersion (in dotted-decimal format) in that service packet.
	NsnServiceVersions map[string]string `json:"nsn_service_versions,omitempty"`
	// The version string in the root of the native service negotiation packet, if applicable.
	NsnVersion *string `json:"nsn_version,omitempty"`
	// The parsed descriptor returned by the server in the Refuse packet; it is empty if the server does not return a Refuse packet. The keys are strings like 'DESCRIPTION.ERROR_STACK.ERROR.CODE
	RefuseError []OracleDescriptor `json:"refuse_error,omitempty"`
	// The unparsed error received when the initial handshake is refused.
	RefuseErrorRaw *string `json:"refuse_error_raw,omitempty"`
	// The 'AppReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string.
	RefuseReasonApp *string `json:"refuse_reason_app,omitempty"`
	// The 'SysReason' returned by the server in the RefusePacket, as an 8-bit unsigned hex string.
	RefuseReasonSys *string `json:"refuse_reason_sys,omitempty"`
	// The version declared by the service when it refuses the handshake, if applicable.
	RefuseVersion *string `json:"refuse_version,omitempty"`
}

func (o *Oracle) GetAcceptVersion() *int {
	if o == nil {
		return nil
	}
	return o.AcceptVersion
}

func (o *Oracle) GetConnectFlags0() map[string]bool {
	if o == nil {
		return nil
	}
	return o.ConnectFlags0
}

func (o *Oracle) GetConnectFlags1() map[string]bool {
	if o == nil {
		return nil
	}
	return o.ConnectFlags1
}

func (o *Oracle) GetDidResend() *bool {
	if o == nil {
		return nil
	}
	return o.DidResend
}

func (o *Oracle) GetGlobalServiceOptions() map[string]bool {
	if o == nil {
		return nil
	}
	return o.GlobalServiceOptions
}

func (o *Oracle) GetNsnServiceVersions() map[string]string {
	if o == nil {
		return nil
	}
	return o.NsnServiceVersions
}

func (o *Oracle) GetNsnVersion() *string {
	if o == nil {
		return nil
	}
	return o.NsnVersion
}

func (o *Oracle) GetRefuseError() []OracleDescriptor {
	if o == nil {
		return nil
	}
	return o.RefuseError
}

func (o *Oracle) GetRefuseErrorRaw() *string {
	if o == nil {
		return nil
	}
	return o.RefuseErrorRaw
}

func (o *Oracle) GetRefuseReasonApp() *string {
	if o == nil {
		return nil
	}
	return o.RefuseReasonApp
}

func (o *Oracle) GetRefuseReasonSys() *string {
	if o == nil {
		return nil
	}
	return o.RefuseReasonSys
}

func (o *Oracle) GetRefuseVersion() *string {
	if o == nil {
		return nil
	}
	return o.RefuseVersion
}
