/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.dtd;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.input.CommentTrimmer;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.xml.dtd.om.AttributeDefault;
import com.thaiopensource.xml.dtd.om.AttributeGroup;
import com.thaiopensource.xml.dtd.om.AttributeGroupMember;
import com.thaiopensource.xml.dtd.om.AttributeGroupVisitor;
import com.thaiopensource.xml.dtd.om.Datatype;
import com.thaiopensource.xml.dtd.om.DatatypeVisitor;
import com.thaiopensource.xml.dtd.om.Def;
import com.thaiopensource.xml.dtd.om.Dtd;
import com.thaiopensource.xml.dtd.om.EnumGroup;
import com.thaiopensource.xml.dtd.om.EnumGroupVisitor;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.ModelGroup;
import com.thaiopensource.xml.dtd.om.ModelGroupVisitor;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.TokenizedDatatype;
import com.thaiopensource.xml.dtd.om.TopLevel;
import com.thaiopensource.xml.dtd.om.TopLevelVisitor;
import com.thaiopensource.xml.em.ExternalId;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Converter {
    private final Dtd dtd;
    private final ErrorReporter er;
    private final SchemaCollection sc = new SchemaCollection();
    private final Options options;
    private boolean hadAny = false;
    private boolean hadDefaultValue = false;
    private final Map<String, Integer> elementNameTable = new HashMap<String, Integer>();
    private final Map<String, List<AttributeGroup>> attlistDeclTable = new HashMap<String, List<AttributeGroup>>();
    private final Set<String> definedNames = new HashSet<String>();
    private final Map<String, String> prefixTable = new HashMap<String, String>();
    private final Map<String, Set<String>> attributeNamesTable = new HashMap<String, Set<String>>();
    private Set<String> attributeNames = null;
    private String defaultNamespace = null;
    private String annotationPrefix = null;
    private String colonReplacement = null;
    private String elementDeclPattern = null;
    private String attlistDeclPattern = null;
    private String anyName = null;
    private static final int ELEMENT_DECL = 1;
    private static final int ATTLIST_DECL = 2;
    private static final int ELEMENT_REF = 4;
    private static final String SEPARATORS = ".-_";
    private static final String DEFAULT_PATTERN = "#.%";
    private final String[] ELEMENT_KEYWORDS = new String[]{"element", "elem", "e"};
    private final String[] ATTLIST_KEYWORDS = new String[]{"attlist", "attributes", "attribs", "atts", "a"};
    private final String[] ANY_KEYWORDS = new String[]{"any", "ANY", "anyElement"};

    public Converter(Dtd dtd, ErrorReporter errorReporter, Options options) {
        this.dtd = dtd;
        this.er = errorReporter;
        this.options = options;
    }

    public SchemaCollection convert() {
        try {
            this.dtd.accept(new Analyzer());
            this.chooseNames();
            GrammarPattern grammarPattern = new GrammarPattern();
            this.sc.setMainUri(this.dtd.getUri());
            this.sc.getSchemaDocumentMap().put(this.dtd.getUri(), new SchemaDocument(grammarPattern, this.dtd.getEncoding()));
            ComponentOutput componentOutput = new ComponentOutput(grammarPattern);
            this.dtd.accept(componentOutput);
            this.outputUndefinedElements(grammarPattern.getComponents());
            if (this.options.generateStart) {
                this.outputStart(grammarPattern.getComponents());
            }
            this.outputAny(grammarPattern.getComponents());
            componentOutput.finish();
            return this.sc;
        }
        catch (Exception exception) {
            throw (RuntimeException)exception;
        }
    }

    private void chooseNames() {
        this.chooseAny();
        this.chooseColonReplacement();
        this.chooseDeclPatterns();
        this.choosePrefixes();
        this.chooseAnnotationPrefix();
    }

    private void chooseAny() {
        if (!this.hadAny) {
            return;
        }
        if (this.options.anyName != null) {
            if (!this.definedNames.contains(this.options.anyName)) {
                this.anyName = this.options.anyName;
                this.definedNames.add(this.anyName);
                return;
            }
            this.warning("cannot_use_any_name");
        }
        int n = 0;
        while (true) {
            for (int i = 0; i < this.ANY_KEYWORDS.length; ++i) {
                this.anyName = Converter.repeatChar('_', n) + this.ANY_KEYWORDS[i];
                if (this.definedNames.contains(this.anyName)) continue;
                this.definedNames.add(this.anyName);
                return;
            }
            ++n;
        }
    }

    private void choosePrefixes() {
        if (this.options.defaultNamespace != null) {
            if (this.defaultNamespace != null && !this.defaultNamespace.equals(this.options.defaultNamespace)) {
                this.warning("default_namespace_conflict");
            }
            this.defaultNamespace = this.options.defaultNamespace;
        } else if (this.defaultNamespace == null) {
            this.defaultNamespace = NameClass.INHERIT_NS;
        }
        for (Map.Entry<String, String> entry : this.options.prefixMap.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = this.prefixTable.get(string);
            if (string3 == null) {
                this.warning("irrelevant_prefix", string);
                continue;
            }
            if (!string3.equals("") && !string3.equals(string2)) {
                this.warning("prefix_conflict", string);
            }
            this.prefixTable.put(string, string2);
        }
    }

    private void chooseAnnotationPrefix() {
        if (!this.hadDefaultValue) {
            return;
        }
        if (this.options.annotationPrefix != null) {
            if (this.prefixTable.get(this.options.annotationPrefix) == null) {
                this.annotationPrefix = this.options.annotationPrefix;
                return;
            }
            this.warning("cannot_use_annotation_prefix");
        }
        int n = 0;
        while (true) {
            this.annotationPrefix = Converter.repeatChar('_', n) + "a";
            if (this.prefixTable.get(this.annotationPrefix) == null) {
                return;
            }
            ++n;
        }
    }

    private void chooseColonReplacement() {
        if (this.options.colonReplacement != null) {
            this.colonReplacement = this.options.colonReplacement;
            if (this.colonReplacementOk()) {
                return;
            }
            this.warning("cannot_use_colon_replacement");
            this.colonReplacement = null;
        }
        if (this.colonReplacementOk()) {
            return;
        }
        int n = 1;
        while (true) {
            for (int i = 0; i < SEPARATORS.length(); ++i) {
                this.colonReplacement = Converter.repeatChar(SEPARATORS.charAt(i), n);
                if (!this.colonReplacementOk()) continue;
                return;
            }
            ++n;
        }
    }

    private boolean colonReplacementOk() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.elementNameTable.keySet()) {
            String string2 = this.mungeQName(string);
            if (hashSet.contains(string2)) {
                return false;
            }
            hashSet.add(string2);
        }
        return true;
    }

    private void chooseDeclPatterns() {
        if (this.options.elementDeclPattern != null) {
            if (this.patternOk(this.options.elementDeclPattern, null)) {
                this.elementDeclPattern = this.options.elementDeclPattern;
            } else {
                this.warning("cannot_use_element_decl_pattern");
            }
        }
        if (this.options.attlistDeclPattern != null) {
            if (this.patternOk(this.options.attlistDeclPattern, this.elementDeclPattern)) {
                this.attlistDeclPattern = this.options.attlistDeclPattern;
            } else {
                this.warning("cannot_use_attlist_decl_pattern");
            }
        }
        if (this.elementDeclPattern != null && this.attlistDeclPattern != null) {
            return;
        }
        String string = this.namingPattern();
        if (this.elementDeclPattern == null) {
            this.elementDeclPattern = this.patternOk("%", this.attlistDeclPattern) ? "%" : this.choosePattern(string, this.ELEMENT_KEYWORDS, this.attlistDeclPattern);
        }
        if (this.attlistDeclPattern == null) {
            this.attlistDeclPattern = this.choosePattern(string, this.ATTLIST_KEYWORDS, this.elementDeclPattern);
        }
    }

    private String choosePattern(String string, String[] stringArray, String string2) {
        while (true) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = Converter.substitute(string, '#', stringArray[i]);
                if (!this.patternOk(string3, string2)) continue;
                return string3;
            }
            string = string.substring(0, 1) + string.substring(1, 2) + string.substring(1, 2) + string.substring(2);
        }
    }

    private String namingPattern() {
        int n;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string : this.definedNames) {
            for (int i = 0; i < SEPARATORS.length(); ++i) {
                char c = SEPARATORS.charAt(i);
                n = string.indexOf(c);
                if (n > 0) {
                    Converter.inc(hashMap, string.substring(0, n + 1) + "%");
                }
                if ((n = string.lastIndexOf(c)) < 0 || n >= string.length() - 1) continue;
                Converter.inc(hashMap, "%" + string.substring(n));
            }
        }
        Object object = null;
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            n = (Integer)entry.getValue();
            if (object != null && n <= n2) continue;
            n2 = n;
            object = (String)entry.getKey();
        }
        if (object == null) {
            return DEFAULT_PATTERN;
        }
        if (((String)object).charAt(0) == '%') {
            return ((String)object).substring(0, 2) + "#";
        }
        return "#" + ((String)object).substring(((String)object).length() - 2);
    }

    private static void inc(Map<String, Integer> map, String string) {
        Integer n = map.get(string);
        if (n == null) {
            map.put(string, 1);
        } else {
            map.put(string, n + 1);
        }
    }

    private boolean patternOk(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : this.elementNameTable.keySet()) {
            String string4 = this.mungeQName(string3);
            String string5 = Converter.substitute(string, '%', string4);
            if (this.definedNames.contains(string5)) {
                return false;
            }
            if (string2 == null) continue;
            String string6 = Converter.substitute(string2, '%', string4);
            if (hashSet.contains(string5) || hashSet.contains(string6) || string5.equals(string6)) {
                return false;
            }
            hashSet.add(string5);
            hashSet.add(string6);
        }
        return true;
    }

    private void noteDef(String string) {
        this.definedNames.add(string);
    }

    private void noteElementName(String string, int n) {
        Integer n2 = this.elementNameTable.get(string);
        if (n2 != null) {
            if (n2 == (n |= n2.intValue())) {
                return;
            }
        } else {
            this.noteNamePrefix(string);
        }
        this.elementNameTable.put(string, n);
    }

    private void noteAttlist(String string, AttributeGroup attributeGroup) {
        List<AttributeGroup> list = this.attlistDeclTable.get(string);
        if (list == null) {
            list = new Vector<AttributeGroup>();
            this.attlistDeclTable.put(string, list);
        }
        list.add(attributeGroup);
    }

    private void noteAttribute(String string, String string2) {
        if (string.equals("xmlns")) {
            if (string2 != null) {
                if (this.defaultNamespace != null && !this.defaultNamespace.equals(string2)) {
                    this.error("INCONSISTENT_DEFAULT_NAMESPACE");
                } else {
                    this.defaultNamespace = string2;
                }
            }
        } else if (string.startsWith("xmlns:")) {
            if (string2 != null) {
                String string3 = string.substring(6);
                String string4 = this.prefixTable.get(string3);
                if (string4 != null && !string4.equals("") && !string4.equals(string2)) {
                    this.error("INCONSISTENT_PREFIX", string3);
                } else if (!string3.equals("xml")) {
                    this.prefixTable.put(string3, string2);
                }
            }
        } else {
            if (string2 != null) {
                this.hadDefaultValue = true;
            }
            this.noteNamePrefix(string);
        }
    }

    private void noteNamePrefix(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        if (this.prefixTable.get(string2) == null && !string2.equals("xml")) {
            this.prefixTable.put(string2, "");
        }
    }

    private int nameFlags(String string) {
        Integer n = this.elementNameTable.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private String elementDeclName(String string) {
        return Converter.substitute(this.elementDeclPattern, '%', this.mungeQName(string));
    }

    private String attlistDeclName(String string) {
        return Converter.substitute(this.attlistDeclPattern, '%', this.mungeQName(string));
    }

    private String mungeQName(String string) {
        if (this.colonReplacement == null) {
            int n = string.indexOf(58);
            if (n < 0) {
                return string;
            }
            return string.substring(n + 1);
        }
        return Converter.substitute(string, ':', this.colonReplacement);
    }

    private static String repeatChar(char c, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
        return new String(cArray);
    }

    private static String substitute(String string, char c, String string2) {
        int n = string.indexOf(c);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(n + 1));
        return stringBuffer.toString();
    }

    private void outputStart(List<Component> list) {
        ChoicePattern choicePattern = new ChoicePattern();
        int n = 5;
        while (true) {
            boolean bl = false;
            for (Map.Entry<String, Integer> entry : this.elementNameTable.entrySet()) {
                if ((entry.getValue() & n) != 1) continue;
                bl = true;
                choicePattern.getChildren().add(Converter.ref(this.elementDeclName(entry.getKey())));
            }
            if (bl) break;
            if (n == 1) {
                return;
            }
            n = 1;
        }
        list.add(new DefineComponent(DefineComponent.START, choicePattern));
    }

    private void outputAny(List<Component> list) {
        if (!this.hadAny) {
            return;
        }
        if (this.options.strictAny) {
            DefineComponent defineComponent = new DefineComponent(this.anyName, new TextPattern());
            defineComponent.setCombine(Combine.CHOICE);
            list.add(defineComponent);
        } else {
            GroupPattern groupPattern = new GroupPattern();
            groupPattern.getChildren().add(new ZeroOrMorePattern(new AttributePattern(new AnyNameNameClass(), new TextPattern())));
            groupPattern.getChildren().add(Converter.ref(this.anyName));
            ChoicePattern choicePattern = new ChoicePattern();
            choicePattern.getChildren().add(new ElementPattern(new AnyNameNameClass(), groupPattern));
            choicePattern.getChildren().add(new TextPattern());
            list.add(new DefineComponent(this.anyName, new ZeroOrMorePattern(choicePattern)));
        }
    }

    private void outputUndefinedElements(List<Component> list) {
        Vector<String> vector = new Vector<String>();
        vector.addAll(this.elementNameTable.keySet());
        Collections.sort(vector);
        for (String string : vector) {
            if ((this.elementNameTable.get(string) & 1) != 0) continue;
            DefineComponent defineComponent = new DefineComponent(this.elementDeclName(string), new NotAllowedPattern());
            defineComponent.setCombine(Combine.CHOICE);
            list.add(defineComponent);
        }
    }

    private static Pattern ref(String string) {
        return new RefPattern(string);
    }

    private void error(String string) {
        this.er.error(string, null);
    }

    private void error(String string, String string2) {
        this.er.error(string, string2, null);
    }

    private void warning(String string) {
        this.er.warning(string, null);
    }

    private void warning(String string, String string2) {
        this.er.warning(string, string2, null);
    }

    private static String[] valueType(Datatype datatype) {
        datatype = datatype.deref();
        switch (datatype.getType()) {
            case 0: {
                return new String[]{"", "string"};
            }
            case 1: {
                return new String[]{"http://www.w3.org/2001/XMLSchema-datatypes", ((TokenizedDatatype)datatype).getTypeName()};
            }
        }
        return new String[]{"", "token"};
    }

    private Pattern convert(ModelGroup modelGroup) throws Exception {
        ModelGroupOutput modelGroupOutput = new ModelGroupOutput();
        modelGroup.accept(modelGroupOutput);
        return modelGroupOutput.pattern;
    }

    private Pattern convert(Datatype datatype) throws Exception {
        DatatypeOutput datatypeOutput = new DatatypeOutput();
        datatype.accept(datatypeOutput);
        return datatypeOutput.pattern;
    }

    private Pattern convert(AttributeGroup attributeGroup) throws Exception {
        GroupPattern groupPattern = new GroupPattern();
        attributeGroup.accept(new AttributeGroupOutput(groupPattern));
        switch (groupPattern.getChildren().size()) {
            case 0: {
                return new EmptyPattern();
            }
            case 1: {
                return groupPattern.getChildren().get(0);
            }
        }
        return groupPattern;
    }

    private NameClass convertQName(String string, boolean bl) {
        String string2;
        int n = string.indexOf(58);
        if (n < 0) {
            return new NameNameClass(bl ? this.defaultNamespace : "", string);
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (string3.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else {
            string2 = this.prefixTable.get(string3);
            if (string2.equals("")) {
                this.error("UNDECLARED_PREFIX", string3);
                string2 = "##" + string3;
                this.prefixTable.put(string3, string2);
            }
        }
        NameNameClass nameNameClass = new NameNameClass(string2, string4);
        nameNameClass.setPrefix(string3);
        return nameNameClass;
    }

    static class Options {
        boolean inlineAttlistDecls;
        boolean generateStart = true;
        boolean strictAny;
        String elementDeclPattern;
        String attlistDeclPattern;
        String colonReplacement;
        String anyName;
        String annotationPrefix;
        String defaultNamespace;
        final Map<String, String> prefixMap = new HashMap<String, String>();

        Options() {
        }
    }

    private class Analyzer
    extends VisitorBase
    implements ModelGroupVisitor,
    AttributeGroupVisitor {
        private Analyzer() {
        }

        @Override
        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            Converter.this.noteElementName(nameSpec.getValue(), 1);
            modelGroup.accept(this);
        }

        @Override
        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            Converter.this.noteElementName(nameSpec.getValue(), 2);
            Converter.this.noteAttlist(nameSpec.getValue(), attributeGroup);
            attributeGroup.accept(this);
        }

        @Override
        public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
            Converter.this.noteDef(string);
            modelGroup.accept(this);
        }

        @Override
        public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
            Converter.this.noteDef(string);
            attributeGroup.accept(this);
        }

        @Override
        public void enumGroupDef(String string, EnumGroup enumGroup) {
            Converter.this.noteDef(string);
        }

        @Override
        public void datatypeDef(String string, Datatype datatype) {
            Converter.this.noteDef(string);
        }

        @Override
        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            for (int i = 0; i < modelGroupArray.length; ++i) {
                modelGroupArray[i].accept(this);
            }
        }

        @Override
        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            for (int i = 0; i < modelGroupArray.length; ++i) {
                modelGroupArray[i].accept(this);
            }
        }

        @Override
        public void oneOrMore(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        @Override
        public void zeroOrMore(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        @Override
        public void optional(ModelGroup modelGroup) throws Exception {
            modelGroup.accept(this);
        }

        @Override
        public void modelGroupRef(String string, ModelGroup modelGroup) {
        }

        @Override
        public void elementRef(NameSpec nameSpec) {
            Converter.this.noteElementName(nameSpec.getValue(), 4);
        }

        @Override
        public void pcdata() {
        }

        @Override
        public void any() {
            Converter.this.hadAny = true;
        }

        @Override
        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            Converter.this.noteAttribute(nameSpec.getValue(), attributeDefault.getDefaultValue());
        }

        @Override
        public void attributeGroupRef(String string, AttributeGroup attributeGroup) {
        }
    }

    private class ComponentOutput
    extends VisitorBase {
        private final List<Component> components;
        private final Annotated grammar;
        private List<Comment> comments;

        ComponentOutput(GrammarPattern grammarPattern) {
            this.comments = null;
            this.components = grammarPattern.getComponents();
            this.grammar = grammarPattern;
        }

        void finish() {
            if (this.comments != null) {
                this.grammar.getFollowingElementAnnotations().addAll(this.comments);
            }
        }

        private void addComponent(Component component) {
            if (this.comments != null) {
                if (this.components.isEmpty()) {
                    this.grammar.getLeadingComments().addAll(this.comments);
                } else {
                    component.getLeadingComments().addAll(this.comments);
                }
                this.comments = null;
            }
            this.components.add(component);
        }

        @Override
        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            Object object;
            Object object2;
            GroupPattern groupPattern = new GroupPattern();
            if (((Converter)Converter.this).options.inlineAttlistDecls) {
                object2 = (List)Converter.this.attlistDeclTable.get(nameSpec.getValue());
                if (object2 != null) {
                    Converter.this.attributeNames = new HashSet();
                    object = new AttributeGroupOutput(groupPattern);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        AttributeGroup attributeGroup = (AttributeGroup)iterator.next();
                        attributeGroup.accept((AttributeGroupVisitor)object);
                    }
                }
            } else {
                groupPattern.getChildren().add(Converter.ref(Converter.this.attlistDeclName(nameSpec.getValue())));
            }
            object2 = Converter.this.convert(modelGroup);
            if (groupPattern.getChildren().size() > 0) {
                if (object2 instanceof GroupPattern) {
                    groupPattern.getChildren().addAll(((GroupPattern)object2).getChildren());
                } else {
                    groupPattern.getChildren().add((Pattern)object2);
                }
                object2 = groupPattern;
            }
            this.addComponent(new DefineComponent(Converter.this.elementDeclName(nameSpec.getValue()), new ElementPattern(Converter.this.convertQName(nameSpec.getValue(), true), (Pattern)object2)));
            if (!((Converter)Converter.this).options.inlineAttlistDecls && (Converter.this.nameFlags(nameSpec.getValue()) & 2) == 0) {
                object = new DefineComponent(Converter.this.attlistDeclName(nameSpec.getValue()), new EmptyPattern());
                ((DefineComponent)object).setCombine(Combine.INTERLEAVE);
                this.addComponent((Component)object);
            }
            if (Converter.this.anyName != null && ((Converter)Converter.this).options.strictAny) {
                object = new DefineComponent(Converter.this.anyName, Converter.ref(Converter.this.elementDeclName(nameSpec.getValue())));
                ((DefineComponent)object).setCombine(Combine.CHOICE);
                this.addComponent((Component)object);
            }
        }

        @Override
        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            Object object;
            Pattern pattern;
            if (((Converter)Converter.this).options.inlineAttlistDecls) {
                return;
            }
            String string = nameSpec.getValue();
            Converter.this.attributeNames = (Set)Converter.this.attributeNamesTable.get(string);
            if (Converter.this.attributeNames == null) {
                Converter.this.attributeNames = new HashSet();
                Converter.this.attributeNamesTable.put(string, Converter.this.attributeNames);
            }
            if ((pattern = Converter.this.convert(attributeGroup)) instanceof EmptyPattern) {
                object = (List)Converter.this.attlistDeclTable.get(string);
                if (object.get(0) != attributeGroup) {
                    return;
                }
                Converter.this.attributeNames = new HashSet();
                int n = object.size();
                for (int i = 1; i < n; ++i) {
                    if (Converter.this.convert((AttributeGroup)object.get(i)) instanceof EmptyPattern) continue;
                    return;
                }
            }
            object = new DefineComponent(Converter.this.attlistDeclName(string), pattern);
            ((DefineComponent)object).setCombine(Combine.INTERLEAVE);
            this.addComponent((Component)object);
        }

        @Override
        public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
            this.addComponent(new DefineComponent(string, Converter.this.convert(modelGroup)));
        }

        @Override
        public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
            Pattern pattern;
            Converter.this.attributeNames = new HashSet();
            AttributeGroupMember[] attributeGroupMemberArray = attributeGroup.getMembers();
            GroupPattern groupPattern = new GroupPattern();
            AttributeGroupOutput attributeGroupOutput = new AttributeGroupOutput(groupPattern);
            for (int i = 0; i < attributeGroupMemberArray.length; ++i) {
                attributeGroupMemberArray[i].accept(attributeGroupOutput);
            }
            switch (groupPattern.getChildren().size()) {
                case 0: {
                    pattern = new EmptyPattern();
                    break;
                }
                case 1: {
                    pattern = groupPattern.getChildren().get(0);
                    break;
                }
                default: {
                    pattern = groupPattern;
                }
            }
            this.addComponent(new DefineComponent(string, pattern));
        }

        @Override
        public void enumGroupDef(String string, EnumGroup enumGroup) throws Exception {
            Pattern pattern;
            ChoicePattern choicePattern = new ChoicePattern();
            enumGroup.accept(new EnumGroupOutput(choicePattern));
            switch (choicePattern.getChildren().size()) {
                case 0: {
                    pattern = new NotAllowedPattern();
                    break;
                }
                case 1: {
                    pattern = choicePattern.getChildren().get(0);
                    break;
                }
                default: {
                    pattern = choicePattern;
                }
            }
            this.addComponent(new DefineComponent(string, pattern));
        }

        @Override
        public void datatypeDef(String string, Datatype datatype) throws Exception {
            this.addComponent(new DefineComponent(string, Converter.this.convert(datatype)));
        }

        @Override
        public void comment(String string) {
            if (this.comments == null) {
                this.comments = new Vector<Comment>();
            }
            this.comments.add(new Comment(CommentTrimmer.trimComment(string)));
        }

        @Override
        public void externalIdRef(String string, ExternalId externalId, String string2, String string3, TopLevel[] topLevelArray) throws Exception {
            if (string2 == null) {
                super.externalIdRef(string, externalId, string2, string3, topLevelArray);
                return;
            }
            SignificanceDetector significanceDetector = new SignificanceDetector();
            try {
                significanceDetector.externalIdRef(string, externalId, string2, string3, topLevelArray);
                if (!significanceDetector.significant) {
                    return;
                }
            }
            catch (Exception exception) {
                throw (RuntimeException)exception;
            }
            if (Converter.this.sc.getSchemaDocumentMap().get(string2) != null) {
                super.externalIdRef(string, externalId, string2, string3, topLevelArray);
                return;
            }
            IncludeComponent includeComponent = new IncludeComponent(string2);
            includeComponent.setNs(Converter.this.defaultNamespace);
            this.addComponent(includeComponent);
            GrammarPattern grammarPattern = new GrammarPattern();
            ComponentOutput componentOutput = new ComponentOutput(grammarPattern);
            for (int i = 0; i < topLevelArray.length; ++i) {
                topLevelArray[i].accept(componentOutput);
            }
            componentOutput.finish();
            Converter.this.sc.getSchemaDocumentMap().put(string2, new SchemaDocument(grammarPattern, string3));
        }
    }

    private class ModelGroupOutput
    implements ModelGroupVisitor {
        private Pattern pattern;

        private ModelGroupOutput() {
        }

        @Override
        public void choice(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                this.pattern = new NotAllowedPattern();
            } else if (modelGroupArray.length == 1) {
                modelGroupArray[0].accept(this);
            } else {
                ChoicePattern choicePattern = new ChoicePattern();
                this.pattern = choicePattern;
                List<Pattern> list = choicePattern.getChildren();
                for (int i = 0; i < modelGroupArray.length; ++i) {
                    list.add(Converter.this.convert(modelGroupArray[i]));
                }
            }
        }

        @Override
        public void sequence(ModelGroup[] modelGroupArray) throws Exception {
            if (modelGroupArray.length == 0) {
                this.pattern = new EmptyPattern();
            } else if (modelGroupArray.length == 1) {
                modelGroupArray[0].accept(this);
            } else {
                GroupPattern groupPattern = new GroupPattern();
                this.pattern = groupPattern;
                List<Pattern> list = groupPattern.getChildren();
                for (int i = 0; i < modelGroupArray.length; ++i) {
                    list.add(Converter.this.convert(modelGroupArray[i]));
                }
            }
        }

        @Override
        public void oneOrMore(ModelGroup modelGroup) throws Exception {
            this.pattern = new OneOrMorePattern(Converter.this.convert(modelGroup));
        }

        @Override
        public void zeroOrMore(ModelGroup modelGroup) throws Exception {
            this.pattern = new ZeroOrMorePattern(Converter.this.convert(modelGroup));
        }

        @Override
        public void optional(ModelGroup modelGroup) throws Exception {
            this.pattern = new OptionalPattern(Converter.this.convert(modelGroup));
        }

        @Override
        public void modelGroupRef(String string, ModelGroup modelGroup) {
            this.pattern = Converter.ref(string);
        }

        @Override
        public void elementRef(NameSpec nameSpec) {
            this.pattern = Converter.ref(Converter.this.elementDeclName(nameSpec.getValue()));
        }

        @Override
        public void pcdata() {
            this.pattern = new TextPattern();
        }

        @Override
        public void any() {
            this.pattern = Converter.ref(Converter.this.anyName);
            if (((Converter)Converter.this).options.strictAny) {
                this.pattern = new ZeroOrMorePattern(this.pattern);
            }
        }
    }

    private class DatatypeOutput
    implements DatatypeVisitor {
        Pattern pattern;

        private DatatypeOutput() {
        }

        @Override
        public void cdataDatatype() {
            this.pattern = new DataPattern("", "string");
        }

        @Override
        public void tokenizedDatatype(String string) {
            this.pattern = new DataPattern("http://www.w3.org/2001/XMLSchema-datatypes", string);
        }

        @Override
        public void enumDatatype(EnumGroup enumGroup) throws Exception {
            if (enumGroup.getMembers().length == 0) {
                this.pattern = new NotAllowedPattern();
            } else {
                ChoicePattern choicePattern = new ChoicePattern();
                this.pattern = choicePattern;
                enumGroup.accept(new EnumGroupOutput(choicePattern));
            }
        }

        @Override
        public void notationDatatype(EnumGroup enumGroup) throws Exception {
            this.enumDatatype(enumGroup);
        }

        @Override
        public void datatypeRef(String string, Datatype datatype) {
            this.pattern = Converter.ref(string);
        }
    }

    private class AttributeGroupOutput
    implements AttributeGroupVisitor {
        final List<Pattern> group;

        AttributeGroupOutput(GroupPattern groupPattern) {
            this.group = groupPattern.getChildren();
        }

        @Override
        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) throws Exception {
            Pattern pattern;
            Object object;
            String string = nameSpec.getValue();
            if (Converter.this.attributeNames.contains(string)) {
                return;
            }
            Converter.this.attributeNames.add(string);
            if (string.equals("xmlns") || string.startsWith("xmlns:")) {
                return;
            }
            String string2 = attributeDefault.getDefaultValue();
            String string3 = attributeDefault.getFixedValue();
            if (string3 != null) {
                object = Converter.valueType(datatype);
                pattern = new ValuePattern(object[0], object[1], string3);
            } else {
                pattern = datatype.getType() != 0 ? Converter.this.convert(datatype) : new TextPattern();
            }
            object = new AttributePattern(Converter.this.convertQName(string, false), pattern);
            if (string2 != null) {
                AttributeAnnotation attributeAnnotation = new AttributeAnnotation("http://relaxng.org/ns/compatibility/annotations/1.0", "defaultValue", string2);
                attributeAnnotation.setPrefix(Converter.this.annotationPrefix);
                ((Annotated)object).getAttributeAnnotations().add(attributeAnnotation);
            }
            if (!attributeDefault.isRequired()) {
                this.group.add(new OptionalPattern((Pattern)object));
            } else {
                this.group.add((Pattern)object);
            }
        }

        @Override
        public void attributeGroupRef(String string, AttributeGroup attributeGroup) throws Exception {
            DuplicateAttributeDetector duplicateAttributeDetector = new DuplicateAttributeDetector();
            attributeGroup.accept(duplicateAttributeDetector);
            if (duplicateAttributeDetector.containsDuplicate) {
                attributeGroup.accept(this);
            } else {
                this.group.add(Converter.ref(string));
                Converter.this.attributeNames.addAll(duplicateAttributeDetector.names);
            }
        }
    }

    private class SignificanceDetector
    extends VisitorBase {
        boolean significant;

        private SignificanceDetector() {
            this.significant = false;
        }

        @Override
        public void elementDecl(NameSpec nameSpec, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        @Override
        public void attlistDecl(NameSpec nameSpec, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        @Override
        public void modelGroupDef(String string, ModelGroup modelGroup) throws Exception {
            this.significant = true;
        }

        @Override
        public void attributeGroupDef(String string, AttributeGroup attributeGroup) throws Exception {
            this.significant = true;
        }

        @Override
        public void enumGroupDef(String string, EnumGroup enumGroup) {
            this.significant = true;
        }

        @Override
        public void datatypeDef(String string, Datatype datatype) {
            this.significant = true;
        }
    }

    private class DuplicateAttributeDetector
    implements AttributeGroupVisitor {
        private boolean containsDuplicate = false;
        private final List<String> names = new Vector<String>();

        private DuplicateAttributeDetector() {
        }

        @Override
        public void attribute(NameSpec nameSpec, Datatype datatype, AttributeDefault attributeDefault) {
            String string = nameSpec.getValue();
            if (Converter.this.attributeNames.contains(string)) {
                this.containsDuplicate = true;
            }
            this.names.add(string);
        }

        @Override
        public void attributeGroupRef(String string, AttributeGroup attributeGroup) throws Exception {
            attributeGroup.accept(this);
        }
    }

    private class EnumGroupOutput
    implements EnumGroupVisitor {
        private final List<Pattern> list;

        EnumGroupOutput(ChoicePattern choicePattern) {
            this.list = choicePattern.getChildren();
        }

        @Override
        public void enumValue(String string) {
            this.list.add(new ValuePattern("", "token", string));
        }

        @Override
        public void enumGroupRef(String string, EnumGroup enumGroup) {
            this.list.add(Converter.ref(string));
        }
    }

    private static abstract class VisitorBase
    implements TopLevelVisitor {
        private VisitorBase() {
        }

        @Override
        public void processingInstruction(String string, String string2) throws Exception {
        }

        @Override
        public void comment(String string) throws Exception {
        }

        @Override
        public void flagDef(String string, Flag flag) throws Exception {
        }

        @Override
        public void includedSection(Flag flag, TopLevel[] topLevelArray) throws Exception {
            for (int i = 0; i < topLevelArray.length; ++i) {
                topLevelArray[i].accept(this);
            }
        }

        @Override
        public void ignoredSection(Flag flag, String string) throws Exception {
        }

        @Override
        public void internalEntityDecl(String string, String string2) throws Exception {
        }

        @Override
        public void externalEntityDecl(String string, ExternalId externalId) throws Exception {
        }

        @Override
        public void notationDecl(String string, ExternalId externalId) throws Exception {
        }

        @Override
        public void nameSpecDef(String string, NameSpec nameSpec) throws Exception {
        }

        @Override
        public void overriddenDef(Def def, boolean bl) throws Exception {
        }

        @Override
        public void externalIdDef(String string, ExternalId externalId) throws Exception {
        }

        @Override
        public void externalIdRef(String string, ExternalId externalId, String string2, String string3, TopLevel[] topLevelArray) throws Exception {
            for (int i = 0; i < topLevelArray.length; ++i) {
                topLevelArray[i].accept(this);
            }
        }

        @Override
        public void paramDef(String string, String string2) throws Exception {
        }

        @Override
        public void attributeDefaultDef(String string, AttributeDefault attributeDefault) throws Exception {
        }
    }
}

