// Copyright 2016 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/genomics/v1alpha2/pipelines.proto

package genomics

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	code "google.golang.org/genproto/googleapis/rpc/code"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The types of disks that may be attached to VMs.
type PipelineResources_Disk_Type int32

const (
	// Default disk type. Use one of the other options below.
	PipelineResources_Disk_TYPE_UNSPECIFIED PipelineResources_Disk_Type = 0
	// Specifies a Google Compute Engine persistent hard disk. See
	// https://cloud.google.com/compute/docs/disks/#pdspecs for details.
	PipelineResources_Disk_PERSISTENT_HDD PipelineResources_Disk_Type = 1
	// Specifies a Google Compute Engine persistent solid-state disk. See
	// https://cloud.google.com/compute/docs/disks/#pdspecs for details.
	PipelineResources_Disk_PERSISTENT_SSD PipelineResources_Disk_Type = 2
	// Specifies a Google Compute Engine local SSD.
	// See https://cloud.google.com/compute/docs/disks/local-ssd for details.
	PipelineResources_Disk_LOCAL_SSD PipelineResources_Disk_Type = 3
)

// Enum value maps for PipelineResources_Disk_Type.
var (
	PipelineResources_Disk_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PERSISTENT_HDD",
		2: "PERSISTENT_SSD",
		3: "LOCAL_SSD",
	}
	PipelineResources_Disk_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PERSISTENT_HDD":   1,
		"PERSISTENT_SSD":   2,
		"LOCAL_SSD":        3,
	}
)

func (x PipelineResources_Disk_Type) Enum() *PipelineResources_Disk_Type {
	p := new(PipelineResources_Disk_Type)
	*p = x
	return p
}

func (x PipelineResources_Disk_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PipelineResources_Disk_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1alpha2_pipelines_proto_enumTypes[0].Descriptor()
}

func (PipelineResources_Disk_Type) Type() protoreflect.EnumType {
	return &file_google_genomics_v1alpha2_pipelines_proto_enumTypes[0]
}

func (x PipelineResources_Disk_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PipelineResources_Disk_Type.Descriptor instead.
func (PipelineResources_Disk_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{16, 0, 0}
}

// Describes a Compute Engine resource that is being managed by a running
// [pipeline][google.genomics.v1alpha2.Pipeline].
type ComputeEngine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance on which the operation is running.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The availability zone in which the instance resides.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The machine type of the instance.
	MachineType string `protobuf:"bytes,3,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// The names of the disks that were created for this pipeline.
	DiskNames []string `protobuf:"bytes,4,rep,name=disk_names,json=diskNames,proto3" json:"disk_names,omitempty"`
}

func (x *ComputeEngine) Reset() {
	*x = ComputeEngine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeEngine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngine) ProtoMessage() {}

func (x *ComputeEngine) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngine.ProtoReflect.Descriptor instead.
func (*ComputeEngine) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeEngine) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *ComputeEngine) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ComputeEngine) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeEngine) GetDiskNames() []string {
	if x != nil {
		return x.DiskNames
	}
	return nil
}

// Runtime metadata that will be populated in the
// [runtimeMetadata][google.genomics.v1.OperationMetadata.runtime_metadata]
// field of the Operation associated with a RunPipeline execution.
type RuntimeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Execution information specific to Google Compute Engine.
	ComputeEngine *ComputeEngine `protobuf:"bytes,1,opt,name=compute_engine,json=computeEngine,proto3" json:"compute_engine,omitempty"`
}

func (x *RuntimeMetadata) Reset() {
	*x = RuntimeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeMetadata) ProtoMessage() {}

func (x *RuntimeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeMetadata.ProtoReflect.Descriptor instead.
func (*RuntimeMetadata) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{1}
}

func (x *RuntimeMetadata) GetComputeEngine() *ComputeEngine {
	if x != nil {
		return x.ComputeEngine
	}
	return nil
}

// The pipeline object. Represents a transformation from a set of input
// parameters to a set of output parameters. The transformation is defined
// as a docker image and command to run within that image. Each pipeline
// is run on a Google Compute Engine VM. A pipeline can be created with the
// `create` method and then later run with the `run` method, or a pipeline can
// be defined and run all at once with the `run` method.
type Pipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which to create the pipeline. The caller must have
	// WRITE access.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. A user specified pipeline name that does not have to be unique.
	// This name can be used for filtering Pipelines in ListPipelines.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// User-specified description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Input parameters of the pipeline.
	InputParameters []*PipelineParameter `protobuf:"bytes,8,rep,name=input_parameters,json=inputParameters,proto3" json:"input_parameters,omitempty"`
	// Output parameters of the pipeline.
	OutputParameters []*PipelineParameter `protobuf:"bytes,9,rep,name=output_parameters,json=outputParameters,proto3" json:"output_parameters,omitempty"`
	// Required. The executor indicates in which environment the pipeline runs.
	//
	// Types that are assignable to Executor:
	//	*Pipeline_Docker
	Executor isPipeline_Executor `protobuf_oneof:"executor"`
	// Required. Specifies resource requirements for the pipeline run.
	// Required fields:
	//
	// *
	// [minimumCpuCores][google.genomics.v1alpha2.PipelineResources.minimum_cpu_cores]
	//
	// *
	// [minimumRamGb][google.genomics.v1alpha2.PipelineResources.minimum_ram_gb]
	Resources *PipelineResources `protobuf:"bytes,6,opt,name=resources,proto3" json:"resources,omitempty"`
	// Unique pipeline id that is generated by the service when CreatePipeline
	// is called. Cannot be specified in the Pipeline used in the
	// CreatePipelineRequest, and will be populated in the response to
	// CreatePipeline and all subsequent Get and List calls. Indicates that the
	// service has registered this pipeline.
	PipelineId string `protobuf:"bytes,7,opt,name=pipeline_id,json=pipelineId,proto3" json:"pipeline_id,omitempty"`
}

func (x *Pipeline) Reset() {
	*x = Pipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline) ProtoMessage() {}

func (x *Pipeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline.ProtoReflect.Descriptor instead.
func (*Pipeline) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{2}
}

func (x *Pipeline) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Pipeline) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Pipeline) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Pipeline) GetInputParameters() []*PipelineParameter {
	if x != nil {
		return x.InputParameters
	}
	return nil
}

func (x *Pipeline) GetOutputParameters() []*PipelineParameter {
	if x != nil {
		return x.OutputParameters
	}
	return nil
}

func (m *Pipeline) GetExecutor() isPipeline_Executor {
	if m != nil {
		return m.Executor
	}
	return nil
}

func (x *Pipeline) GetDocker() *DockerExecutor {
	if x, ok := x.GetExecutor().(*Pipeline_Docker); ok {
		return x.Docker
	}
	return nil
}

func (x *Pipeline) GetResources() *PipelineResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Pipeline) GetPipelineId() string {
	if x != nil {
		return x.PipelineId
	}
	return ""
}

type isPipeline_Executor interface {
	isPipeline_Executor()
}

type Pipeline_Docker struct {
	// Specifies the docker run information.
	Docker *DockerExecutor `protobuf:"bytes,5,opt,name=docker,proto3,oneof"`
}

func (*Pipeline_Docker) isPipeline_Executor() {}

// The request to create a pipeline. The pipeline field here should not have
// `pipelineId` populated, as that will be populated by the server.
type CreatePipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The pipeline to create. Should not have `pipelineId` populated.
	Pipeline *Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
}

func (x *CreatePipelineRequest) Reset() {
	*x = CreatePipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePipelineRequest) ProtoMessage() {}

func (x *CreatePipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePipelineRequest.ProtoReflect.Descriptor instead.
func (*CreatePipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{3}
}

func (x *CreatePipelineRequest) GetPipeline() *Pipeline {
	if x != nil {
		return x.Pipeline
	}
	return nil
}

// The pipeline run arguments.
type RunPipelineArgs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which to run the pipeline. The caller must have
	// WRITER access to all Google Cloud services and resources (e.g. Google
	// Compute Engine) will be used.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Pipeline input arguments; keys are defined in the pipeline documentation.
	// All input parameters that do not have default values  must be specified.
	// If parameters with defaults are specified here, the defaults will be
	// overridden.
	Inputs map[string]string `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Pipeline output arguments; keys are defined in the pipeline
	// documentation.  All output parameters of without default values
	// must be specified.  If parameters with defaults are specified
	// here, the defaults will be overridden.
	Outputs map[string]string `protobuf:"bytes,3,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The Google Cloud Service Account that will be used to access data and
	// services. By default, the compute service account associated with
	// `projectId` is used.
	ServiceAccount *ServiceAccount `protobuf:"bytes,4,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// This field is deprecated. Use `labels` instead. Client-specified pipeline
	// operation identifier.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Specifies resource requirements/overrides for the pipeline run.
	Resources *PipelineResources `protobuf:"bytes,6,opt,name=resources,proto3" json:"resources,omitempty"`
	// Required. Logging options. Used by the service to communicate results
	// to the user.
	Logging *LoggingOptions `protobuf:"bytes,7,opt,name=logging,proto3" json:"logging,omitempty"`
	// How long to keep the VM up after a failure (for example docker command
	// failed, copying input or output files failed, etc). While the VM is up, one
	// can ssh into the VM to debug. Default is 0; maximum allowed value is 1 day.
	KeepVmAliveOnFailureDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=keep_vm_alive_on_failure_duration,json=keepVmAliveOnFailureDuration,proto3" json:"keep_vm_alive_on_failure_duration,omitempty"`
	// Labels to apply to this pipeline run. Labels will also be applied to
	// compute resources (VM, disks) created by this pipeline run. When listing
	// operations, operations can [filtered by labels]
	// [google.longrunning.ListOperationsRequest.filter].
	// Label keys may not be empty; label values may be empty. Non-empty labels
	// must be 1-63 characters long, and comply with [RFC1035]
	// (https://www.ietf.org/rfc/rfc1035.txt).
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
	// character must be a lowercase letter, and all following characters must be
	// a dash, lowercase letter, or digit, except the last character, which cannot
	// be a dash.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RunPipelineArgs) Reset() {
	*x = RunPipelineArgs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPipelineArgs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPipelineArgs) ProtoMessage() {}

func (x *RunPipelineArgs) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPipelineArgs.ProtoReflect.Descriptor instead.
func (*RunPipelineArgs) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{4}
}

func (x *RunPipelineArgs) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RunPipelineArgs) GetInputs() map[string]string {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *RunPipelineArgs) GetOutputs() map[string]string {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *RunPipelineArgs) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *RunPipelineArgs) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *RunPipelineArgs) GetResources() *PipelineResources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *RunPipelineArgs) GetLogging() *LoggingOptions {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *RunPipelineArgs) GetKeepVmAliveOnFailureDuration() *durationpb.Duration {
	if x != nil {
		return x.KeepVmAliveOnFailureDuration
	}
	return nil
}

func (x *RunPipelineArgs) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// The request to run a pipeline. If `pipelineId` is specified, it
// refers to a saved pipeline created with CreatePipeline and set as
// the `pipelineId` of the returned Pipeline object. If
// `ephemeralPipeline` is specified, that pipeline is run once
// with the given args and not saved. It is an error to specify both
// `pipelineId` and `ephemeralPipeline`. `pipelineArgs`
// must be specified.
type RunPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Pipeline:
	//	*RunPipelineRequest_PipelineId
	//	*RunPipelineRequest_EphemeralPipeline
	Pipeline isRunPipelineRequest_Pipeline `protobuf_oneof:"pipeline"`
	// The arguments to use when running this pipeline.
	PipelineArgs *RunPipelineArgs `protobuf:"bytes,3,opt,name=pipeline_args,json=pipelineArgs,proto3" json:"pipeline_args,omitempty"`
}

func (x *RunPipelineRequest) Reset() {
	*x = RunPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPipelineRequest) ProtoMessage() {}

func (x *RunPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPipelineRequest.ProtoReflect.Descriptor instead.
func (*RunPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{5}
}

func (m *RunPipelineRequest) GetPipeline() isRunPipelineRequest_Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (x *RunPipelineRequest) GetPipelineId() string {
	if x, ok := x.GetPipeline().(*RunPipelineRequest_PipelineId); ok {
		return x.PipelineId
	}
	return ""
}

func (x *RunPipelineRequest) GetEphemeralPipeline() *Pipeline {
	if x, ok := x.GetPipeline().(*RunPipelineRequest_EphemeralPipeline); ok {
		return x.EphemeralPipeline
	}
	return nil
}

func (x *RunPipelineRequest) GetPipelineArgs() *RunPipelineArgs {
	if x != nil {
		return x.PipelineArgs
	}
	return nil
}

type isRunPipelineRequest_Pipeline interface {
	isRunPipelineRequest_Pipeline()
}

type RunPipelineRequest_PipelineId struct {
	// The already created pipeline to run.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId,proto3,oneof"`
}

type RunPipelineRequest_EphemeralPipeline struct {
	// A new pipeline object to run once and then delete.
	EphemeralPipeline *Pipeline `protobuf:"bytes,2,opt,name=ephemeral_pipeline,json=ephemeralPipeline,proto3,oneof"`
}

func (*RunPipelineRequest_PipelineId) isRunPipelineRequest_Pipeline() {}

func (*RunPipelineRequest_EphemeralPipeline) isRunPipelineRequest_Pipeline() {}

// A request to get a saved pipeline by id.
type GetPipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Caller must have READ access to the project in which this pipeline
	// is defined.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId,proto3" json:"pipeline_id,omitempty"`
}

func (x *GetPipelineRequest) Reset() {
	*x = GetPipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPipelineRequest) ProtoMessage() {}

func (x *GetPipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPipelineRequest.ProtoReflect.Descriptor instead.
func (*GetPipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{6}
}

func (x *GetPipelineRequest) GetPipelineId() string {
	if x != nil {
		return x.PipelineId
	}
	return ""
}

// A request to list pipelines in a given project. Pipelines can be
// filtered by name using `namePrefix`: all pipelines with names that
// begin with `namePrefix` will be returned. Uses standard pagination:
// `pageSize` indicates how many pipelines to return, and
// `pageToken` comes from a previous ListPipelinesResponse to
// indicate offset.
type ListPipelinesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project to search for pipelines. Caller
	// must have READ access to this project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Pipelines with names that match this prefix should be
	// returned.  If unspecified, all pipelines in the project, up to
	// `pageSize`, will be returned.
	NamePrefix string `protobuf:"bytes,2,opt,name=name_prefix,json=namePrefix,proto3" json:"name_prefix,omitempty"`
	// Number of pipelines to return at once. Defaults to 256, and max
	// is 2048.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to use to indicate where to start getting results.
	// If unspecified, returns the first page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPipelinesRequest) Reset() {
	*x = ListPipelinesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPipelinesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPipelinesRequest) ProtoMessage() {}

func (x *ListPipelinesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPipelinesRequest.ProtoReflect.Descriptor instead.
func (*ListPipelinesRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{7}
}

func (x *ListPipelinesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListPipelinesRequest) GetNamePrefix() string {
	if x != nil {
		return x.NamePrefix
	}
	return ""
}

func (x *ListPipelinesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPipelinesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response of ListPipelines. Contains at most `pageSize`
// pipelines. If it contains `pageSize` pipelines, and more pipelines
// exist, then `nextPageToken` will be populated and should be
// used as the `pageToken` argument to a subsequent ListPipelines
// request.
type ListPipelinesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The matched pipelines.
	Pipelines []*Pipeline `protobuf:"bytes,1,rep,name=pipelines,proto3" json:"pipelines,omitempty"`
	// The token to use to get the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPipelinesResponse) Reset() {
	*x = ListPipelinesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPipelinesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPipelinesResponse) ProtoMessage() {}

func (x *ListPipelinesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPipelinesResponse.ProtoReflect.Descriptor instead.
func (*ListPipelinesResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{8}
}

func (x *ListPipelinesResponse) GetPipelines() []*Pipeline {
	if x != nil {
		return x.Pipelines
	}
	return nil
}

func (x *ListPipelinesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request to delete a saved pipeline by ID.
type DeletePipelineRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Caller must have WRITE access to the project in which this pipeline
	// is defined.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId,proto3" json:"pipeline_id,omitempty"`
}

func (x *DeletePipelineRequest) Reset() {
	*x = DeletePipelineRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePipelineRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePipelineRequest) ProtoMessage() {}

func (x *DeletePipelineRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePipelineRequest.ProtoReflect.Descriptor instead.
func (*DeletePipelineRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{9}
}

func (x *DeletePipelineRequest) GetPipelineId() string {
	if x != nil {
		return x.PipelineId
	}
	return ""
}

// Request to get controller configuation.  Should only be used
// by VMs created by the Pipelines Service and not by end users.
type GetControllerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation to retrieve controller configuration for.
	OperationId     string `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	ValidationToken uint64 `protobuf:"varint,2,opt,name=validation_token,json=validationToken,proto3" json:"validation_token,omitempty"`
}

func (x *GetControllerConfigRequest) Reset() {
	*x = GetControllerConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetControllerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetControllerConfigRequest) ProtoMessage() {}

func (x *GetControllerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetControllerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetControllerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{10}
}

func (x *GetControllerConfigRequest) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *GetControllerConfigRequest) GetValidationToken() uint64 {
	if x != nil {
		return x.ValidationToken
	}
	return 0
}

// Stores the information that the controller will fetch from the
// server in order to run. Should only be used by VMs created by the
// Pipelines Service and not by end users.
type ControllerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Image       string                                      `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	Cmd         string                                      `protobuf:"bytes,2,opt,name=cmd,proto3" json:"cmd,omitempty"`
	GcsLogPath  string                                      `protobuf:"bytes,3,opt,name=gcs_log_path,json=gcsLogPath,proto3" json:"gcs_log_path,omitempty"`
	MachineType string                                      `protobuf:"bytes,4,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	Vars        map[string]string                           `protobuf:"bytes,5,rep,name=vars,proto3" json:"vars,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Disks       map[string]string                           `protobuf:"bytes,6,rep,name=disks,proto3" json:"disks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	GcsSources  map[string]*ControllerConfig_RepeatedString `protobuf:"bytes,7,rep,name=gcs_sources,json=gcsSources,proto3" json:"gcs_sources,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	GcsSinks    map[string]*ControllerConfig_RepeatedString `protobuf:"bytes,8,rep,name=gcs_sinks,json=gcsSinks,proto3" json:"gcs_sinks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ControllerConfig) Reset() {
	*x = ControllerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ControllerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControllerConfig) ProtoMessage() {}

func (x *ControllerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControllerConfig.ProtoReflect.Descriptor instead.
func (*ControllerConfig) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{11}
}

func (x *ControllerConfig) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *ControllerConfig) GetCmd() string {
	if x != nil {
		return x.Cmd
	}
	return ""
}

func (x *ControllerConfig) GetGcsLogPath() string {
	if x != nil {
		return x.GcsLogPath
	}
	return ""
}

func (x *ControllerConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ControllerConfig) GetVars() map[string]string {
	if x != nil {
		return x.Vars
	}
	return nil
}

func (x *ControllerConfig) GetDisks() map[string]string {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *ControllerConfig) GetGcsSources() map[string]*ControllerConfig_RepeatedString {
	if x != nil {
		return x.GcsSources
	}
	return nil
}

func (x *ControllerConfig) GetGcsSinks() map[string]*ControllerConfig_RepeatedString {
	if x != nil {
		return x.GcsSinks
	}
	return nil
}

// Stores the list of events and times they occured for major events in job
// execution.
type TimestampEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String indicating the type of event
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The time this event occured.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *TimestampEvent) Reset() {
	*x = TimestampEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampEvent) ProtoMessage() {}

func (x *TimestampEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampEvent.ProtoReflect.Descriptor instead.
func (*TimestampEvent) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{12}
}

func (x *TimestampEvent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TimestampEvent) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

// Request to set operation status. Should only be used by VMs
// created by the Pipelines Service and not by end users.
type SetOperationStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OperationId     string            `protobuf:"bytes,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	TimestampEvents []*TimestampEvent `protobuf:"bytes,2,rep,name=timestamp_events,json=timestampEvents,proto3" json:"timestamp_events,omitempty"`
	ErrorCode       code.Code         `protobuf:"varint,3,opt,name=error_code,json=errorCode,proto3,enum=google.rpc.Code" json:"error_code,omitempty"`
	ErrorMessage    string            `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	ValidationToken uint64            `protobuf:"varint,5,opt,name=validation_token,json=validationToken,proto3" json:"validation_token,omitempty"`
}

func (x *SetOperationStatusRequest) Reset() {
	*x = SetOperationStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetOperationStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetOperationStatusRequest) ProtoMessage() {}

func (x *SetOperationStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetOperationStatusRequest.ProtoReflect.Descriptor instead.
func (*SetOperationStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{13}
}

func (x *SetOperationStatusRequest) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *SetOperationStatusRequest) GetTimestampEvents() []*TimestampEvent {
	if x != nil {
		return x.TimestampEvents
	}
	return nil
}

func (x *SetOperationStatusRequest) GetErrorCode() code.Code {
	if x != nil {
		return x.ErrorCode
	}
	return code.Code_OK
}

func (x *SetOperationStatusRequest) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *SetOperationStatusRequest) GetValidationToken() uint64 {
	if x != nil {
		return x.ValidationToken
	}
	return 0
}

// A Google Cloud Service Account.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of the service account. Defaults to `default`,
	// which uses the compute service account associated with the project.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// List of scopes to be enabled for this service account on the VM.
	// The following scopes are automatically included:
	//
	// * https://www.googleapis.com/auth/compute
	// * https://www.googleapis.com/auth/devstorage.full_control
	// * https://www.googleapis.com/auth/genomics
	// * https://www.googleapis.com/auth/logging.write
	// * https://www.googleapis.com/auth/monitoring.write
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{14}
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceAccount) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// The logging options for the pipeline run.
type LoggingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location in Google Cloud Storage to which the pipeline logs
	// will be copied. Can be specified as a fully qualified directory
	// path, in which case logs will be output with a unique identifier
	// as the filename in that directory, or as a fully specified path,
	// which must end in `.log`, in which case that path will be
	// used, and the user must ensure that logs are not
	// overwritten. Stdout and stderr logs from the run are also
	// generated and output as `-stdout.log` and `-stderr.log`.
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath,proto3" json:"gcs_path,omitempty"`
}

func (x *LoggingOptions) Reset() {
	*x = LoggingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingOptions) ProtoMessage() {}

func (x *LoggingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingOptions.ProtoReflect.Descriptor instead.
func (*LoggingOptions) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{15}
}

func (x *LoggingOptions) GetGcsPath() string {
	if x != nil {
		return x.GcsPath
	}
	return ""
}

// The system resources for the pipeline run.
type PipelineResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum number of cores to use. Defaults to 1.
	MinimumCpuCores int32 `protobuf:"varint,1,opt,name=minimum_cpu_cores,json=minimumCpuCores,proto3" json:"minimum_cpu_cores,omitempty"`
	// Whether to use preemptible VMs. Defaults to `false`. In order to use this,
	// must be true for both create time and run time. Cannot be true at run time
	// if false at create time.
	Preemptible bool `protobuf:"varint,2,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// The minimum amount of RAM to use. Defaults to 3.75 (GB)
	MinimumRamGb float64 `protobuf:"fixed64,3,opt,name=minimum_ram_gb,json=minimumRamGb,proto3" json:"minimum_ram_gb,omitempty"`
	// Disks to attach.
	Disks []*PipelineResources_Disk `protobuf:"bytes,4,rep,name=disks,proto3" json:"disks,omitempty"`
	// List of Google Compute Engine availability zones to which resource
	// creation will restricted. If empty, any zone may be chosen.
	Zones []string `protobuf:"bytes,5,rep,name=zones,proto3" json:"zones,omitempty"`
	// The size of the boot disk. Defaults to 10 (GB).
	BootDiskSizeGb int32 `protobuf:"varint,6,opt,name=boot_disk_size_gb,json=bootDiskSizeGb,proto3" json:"boot_disk_size_gb,omitempty"`
	// Whether to assign an external IP to the instance. This is an experimental
	// feature that may go away. Defaults to false.
	// Corresponds to `--no_address` flag for [gcloud compute instances create]
	// (https://cloud.google.com/sdk/gcloud/reference/compute/instances/create).
	// In order to use this, must be true for both create time and run time.
	// Cannot be true at run time if false at create time. If you need to ssh into
	// a private IP VM for debugging, you can ssh to a public VM and then ssh into
	// the private VM's Internal IP.  If noAddress is set, this pipeline run may
	// only load docker images from Google Container Registry and not Docker Hub.
	// ** Note: To use this option, your project must be in Google Access for
	// Private IPs Early Access Program.**
	NoAddress bool `protobuf:"varint,7,opt,name=no_address,json=noAddress,proto3" json:"no_address,omitempty"`
}

func (x *PipelineResources) Reset() {
	*x = PipelineResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineResources) ProtoMessage() {}

func (x *PipelineResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineResources.ProtoReflect.Descriptor instead.
func (*PipelineResources) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{16}
}

func (x *PipelineResources) GetMinimumCpuCores() int32 {
	if x != nil {
		return x.MinimumCpuCores
	}
	return 0
}

func (x *PipelineResources) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *PipelineResources) GetMinimumRamGb() float64 {
	if x != nil {
		return x.MinimumRamGb
	}
	return 0
}

func (x *PipelineResources) GetDisks() []*PipelineResources_Disk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *PipelineResources) GetZones() []string {
	if x != nil {
		return x.Zones
	}
	return nil
}

func (x *PipelineResources) GetBootDiskSizeGb() int32 {
	if x != nil {
		return x.BootDiskSizeGb
	}
	return 0
}

func (x *PipelineResources) GetNoAddress() bool {
	if x != nil {
		return x.NoAddress
	}
	return false
}

// Parameters facilitate setting and delivering data into the
// pipeline's execution environment. They are defined at create time,
// with optional defaults, and can be overridden at run time.
//
// If `localCopy` is unset, then the parameter specifies a string that
// is passed as-is into the pipeline, as the value of the environment
// variable with the given name.  A default value can be optionally
// specified at create time. The default can be overridden at run time
// using the inputs map. If no default is given, a value must be
// supplied at runtime.
//
// If `localCopy` is defined, then the parameter specifies a data
// source or sink, both in Google Cloud Storage and on the Docker container
// where the pipeline computation is run. The [service account associated with
// the Pipeline][google.genomics.v1alpha2.RunPipelineArgs.service_account] (by
// default the project's Compute Engine service account) must have access to the
// Google Cloud Storage paths.
//
// At run time, the Google Cloud Storage paths can be overridden if a default
// was provided at create time, or must be set otherwise. The pipeline runner
// should add a key/value pair to either the inputs or outputs map. The
// indicated data copies will be carried out before/after pipeline execution,
// just as if the corresponding arguments were provided to `gsutil cp`.
//
// For example: Given the following `PipelineParameter`, specified
// in the `inputParameters` list:
//
// ```
// {name: "input_file", localCopy: {path: "file.txt", disk: "pd1"}}
// ```
//
// where `disk` is defined in the `PipelineResources` object as:
//
// ```
// {name: "pd1", mountPoint: "/mnt/disk/"}
// ```
//
// We create a disk named `pd1`, mount it on the host VM, and map
// `/mnt/pd1` to `/mnt/disk` in the docker container.  At
// runtime, an entry for `input_file` would be required in the inputs
// map, such as:
//
// ```
//   inputs["input_file"] = "gs://my-bucket/bar.txt"
// ```
//
// This would generate the following gsutil call:
//
// ```
//   gsutil cp gs://my-bucket/bar.txt /mnt/pd1/file.txt
// ```
//
// The file `/mnt/pd1/file.txt` maps to `/mnt/disk/file.txt` in the
// Docker container. Acceptable paths are:
//
// <table>
//   <thead>
//     <tr><th>Google Cloud storage path</th><th>Local path</th></tr>
//   </thead>
//   <tbody>
//     <tr><td>file</td><td>file</td></tr>
//     <tr><td>glob</td><td>directory</td></tr>
//   </tbody>
// </table>
//
// For outputs, the direction of the copy is reversed:
//
// ```
//   gsutil cp /mnt/disk/file.txt gs://my-bucket/bar.txt
// ```
//
// Acceptable paths are:
//
// <table>
//   <thead>
//     <tr><th>Local path</th><th>Google Cloud Storage path</th></tr>
//   </thead>
//   <tbody>
//     <tr><td>file</td><td>file</td></tr>
//     <tr>
//       <td>file</td>
//       <td>directory - directory must already exist</td>
//     </tr>
//     <tr>
//       <td>glob</td>
//       <td>directory - directory will be created if it doesn't exist</td></tr>
//   </tbody>
// </table>
//
// One restriction due to docker limitations, is that for outputs that are found
// on the boot disk, the local path cannot be a glob and must be a file.
type PipelineParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parameter - the pipeline runner uses this string
	// as the key to the input and output maps in RunPipeline.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable description.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The default value for this parameter. Can be overridden at runtime.
	// If `localCopy` is present, then this must be a Google Cloud Storage path
	// beginning with `gs://`.
	DefaultValue string `protobuf:"bytes,5,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// If present, this parameter is marked for copying to and from the VM.
	// `LocalCopy` indicates where on the VM the file should be. The value
	// given to this parameter (either at runtime or using `defaultValue`)
	// must be the remote path where the file should be.
	LocalCopy *PipelineParameter_LocalCopy `protobuf:"bytes,6,opt,name=local_copy,json=localCopy,proto3" json:"local_copy,omitempty"`
}

func (x *PipelineParameter) Reset() {
	*x = PipelineParameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineParameter) ProtoMessage() {}

func (x *PipelineParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineParameter.ProtoReflect.Descriptor instead.
func (*PipelineParameter) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{17}
}

func (x *PipelineParameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PipelineParameter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PipelineParameter) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *PipelineParameter) GetLocalCopy() *PipelineParameter_LocalCopy {
	if x != nil {
		return x.LocalCopy
	}
	return nil
}

// The Docker execuctor specification.
type DockerExecutor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Image name from either Docker Hub or Google Container Registry.
	// Users that run pipelines must have READ access to the image.
	ImageName string `protobuf:"bytes,1,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	// Required. The command or newline delimited script to run. The command
	// string will be executed within a bash shell.
	//
	// If the command exits with a non-zero exit code, output parameter
	// de-localization will be skipped and the pipeline operation's
	// [`error`][google.longrunning.Operation.error] field will be populated.
	//
	// Maximum command string length is 16384.
	Cmd string `protobuf:"bytes,2,opt,name=cmd,proto3" json:"cmd,omitempty"`
}

func (x *DockerExecutor) Reset() {
	*x = DockerExecutor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DockerExecutor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DockerExecutor) ProtoMessage() {}

func (x *DockerExecutor) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DockerExecutor.ProtoReflect.Descriptor instead.
func (*DockerExecutor) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{18}
}

func (x *DockerExecutor) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *DockerExecutor) GetCmd() string {
	if x != nil {
		return x.Cmd
	}
	return ""
}

type ControllerConfig_RepeatedString struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ControllerConfig_RepeatedString) Reset() {
	*x = ControllerConfig_RepeatedString{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ControllerConfig_RepeatedString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControllerConfig_RepeatedString) ProtoMessage() {}

func (x *ControllerConfig_RepeatedString) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControllerConfig_RepeatedString.ProtoReflect.Descriptor instead.
func (*ControllerConfig_RepeatedString) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{11, 0}
}

func (x *ControllerConfig_RepeatedString) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A Google Compute Engine disk resource specification.
type PipelineResources_Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the disk that can be used in the pipeline
	// parameters. Must be 1 - 63 characters.
	// The name "boot" is reserved for system use.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The type of the disk to create.
	Type PipelineResources_Disk_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.genomics.v1alpha2.PipelineResources_Disk_Type" json:"type,omitempty"`
	// The size of the disk. Defaults to 500 (GB).
	// This field is not applicable for local SSD.
	SizeGb int32 `protobuf:"varint,3,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// The full or partial URL of the persistent disk to attach. See
	// https://cloud.google.com/compute/docs/reference/latest/instances#resource
	// and
	// https://cloud.google.com/compute/docs/disks/persistent-disks#snapshots
	// for more details.
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// Deprecated. Disks created by the Pipelines API will be deleted at the end
	// of the pipeline run, regardless of what this field is set to.
	AutoDelete bool `protobuf:"varint,6,opt,name=auto_delete,json=autoDelete,proto3" json:"auto_delete,omitempty"`
	// Required at create time and cannot be overridden at run time.
	// Specifies the path in the docker container where files on
	// this disk should be located. For example, if `mountPoint`
	// is `/mnt/disk`, and the parameter has `localPath`
	// `inputs/file.txt`, the docker container can access the data at
	// `/mnt/disk/inputs/file.txt`.
	MountPoint string `protobuf:"bytes,8,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
}

func (x *PipelineResources_Disk) Reset() {
	*x = PipelineResources_Disk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineResources_Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineResources_Disk) ProtoMessage() {}

func (x *PipelineResources_Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineResources_Disk.ProtoReflect.Descriptor instead.
func (*PipelineResources_Disk) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{16, 0}
}

func (x *PipelineResources_Disk) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PipelineResources_Disk) GetType() PipelineResources_Disk_Type {
	if x != nil {
		return x.Type
	}
	return PipelineResources_Disk_TYPE_UNSPECIFIED
}

func (x *PipelineResources_Disk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *PipelineResources_Disk) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *PipelineResources_Disk) GetAutoDelete() bool {
	if x != nil {
		return x.AutoDelete
	}
	return false
}

func (x *PipelineResources_Disk) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

// LocalCopy defines how a remote file should be copied to and from the VM.
type PipelineParameter_LocalCopy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The path within the user's docker container where
	// this input should be localized to and from, relative to the specified
	// disk's mount point. For example: file.txt,
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Required. The name of the disk where this parameter is
	// located. Can be the name of one of the disks specified in the
	// Resources field, or "boot", which represents the Docker
	// instance's boot disk and has a mount point of `/`.
	Disk string `protobuf:"bytes,2,opt,name=disk,proto3" json:"disk,omitempty"`
}

func (x *PipelineParameter_LocalCopy) Reset() {
	*x = PipelineParameter_LocalCopy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineParameter_LocalCopy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineParameter_LocalCopy) ProtoMessage() {}

func (x *PipelineParameter_LocalCopy) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1alpha2_pipelines_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineParameter_LocalCopy.ProtoReflect.Descriptor instead.
func (*PipelineParameter_LocalCopy) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP(), []int{17, 0}
}

func (x *PipelineParameter_LocalCopy) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *PipelineParameter_LocalCopy) GetDisk() string {
	if x != nil {
		return x.Disk
	}
	return ""
}

var File_google_genomics_v1alpha2_pipelines_proto protoreflect.FileDescriptor

var file_google_genomics_v1alpha2_pipelines_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x01, 0x0a,
	0x0d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09,
	0x64, 0x69, 0x73, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x61, 0x0a, 0x0f, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x0e,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52, 0x0d, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0xcd, 0x03, 0x0a,
	0x08, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x56,
	0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x10,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x42, 0x0a, 0x06, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x6b,
	0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x06, 0x64, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x12, 0x49, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x64,
	0x42, 0x0a, 0x0a, 0x08, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x22, 0x57, 0x0a, 0x15,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x08, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x08, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0xb5, 0x06, 0x0a, 0x0f, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x72, 0x67, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x41,
	0x72, 0x67, 0x73, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x41,
	0x72, 0x67, 0x73, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x49, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x62, 0x0a, 0x21, 0x6b, 0x65, 0x65, 0x70,
	0x5f, 0x76, 0x6d, 0x5f, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1c,
	0x6b, 0x65, 0x65, 0x70, 0x56, 0x6d, 0x41, 0x6c, 0x69, 0x76, 0x65, 0x4f, 0x6e, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x41, 0x72, 0x67, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3a, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xe8, 0x01,
	0x0a, 0x12, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x12, 0x65, 0x70, 0x68, 0x65, 0x6d,
	0x65, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x11, 0x65, 0x70, 0x68, 0x65, 0x6d,
	0x65, 0x72, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x4e, 0x0a, 0x0d,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52,
	0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x72, 0x67, 0x73, 0x52, 0x0c,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x72, 0x67, 0x73, 0x42, 0x0a, 0x0a, 0x08,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x35, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x49, 0x64, 0x22,
	0x92, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x61,
	0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40,
	0x0a, 0x09, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x09, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x38, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x49, 0x64, 0x22, 0x6a, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd9,
	0x06, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x6d, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x6d, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x67,
	0x63, 0x73, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x67, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x50, 0x61, 0x74, 0x68, 0x12, 0x21, 0x0a,
	0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x48, 0x0a, 0x04, 0x76, 0x61, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x61, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x76, 0x61, 0x72, 0x73, 0x12, 0x4b, 0x0a, 0x05, 0x64, 0x69,
	0x73, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x5b, 0x0a, 0x0b, 0x67, 0x63, 0x73, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x09, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x69, 0x6e, 0x6b, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x08, 0x67, 0x63, 0x73, 0x53, 0x69, 0x6e, 0x6b, 0x73, 0x1a, 0x28, 0x0a, 0x0e, 0x52,
	0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x16, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x37, 0x0a, 0x09, 0x56, 0x61, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x38,
	0x0a, 0x0a, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x78, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x76, 0x0a, 0x0d, 0x47, 0x63, 0x73, 0x53, 0x69, 0x6e, 0x6b, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x52, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6c, 0x0a, 0x0e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x94, 0x02, 0x0a, 0x19, 0x53, 0x65, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x10, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2f,
	0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x43, 0x6f, 0x64, 0x65, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x3e, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x22,
	0x2b, 0x0a, 0x0e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x22, 0xdf, 0x04, 0x0a,
	0x11, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x63, 0x70,
	0x75, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6d,
	0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x43, 0x70, 0x75, 0x43, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x20,
	0x0a, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x61, 0x6d, 0x5f,
	0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75,
	0x6d, 0x52, 0x61, 0x6d, 0x47, 0x62, 0x12, 0x46, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x14,
	0x0a, 0x05, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x7a,
	0x6f, 0x6e, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12,
	0x1d, 0x0a, 0x0a, 0x6e, 0x6f, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x09, 0x6e, 0x6f, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x1a, 0xad,
	0x02, 0x0a, 0x04, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67,
	0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x53, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x52, 0x53, 0x49,
	0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x48, 0x44, 0x44, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x03, 0x22, 0xf9,
	0x01, 0x0a, 0x11, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x54, 0x0a, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x70, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x70, 0x79, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x43, 0x6f, 0x70, 0x79, 0x1a, 0x33, 0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6f,
	0x70, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x69, 0x73, 0x6b, 0x22, 0x41, 0x0a, 0x0e, 0x44, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x63,
	0x6d, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x6d, 0x64, 0x32, 0x88, 0x08,
	0x0a, 0x11, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x56, 0x31, 0x41, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x12, 0x8c, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x25, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1f, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x3a, 0x08, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x7e, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x75, 0x6e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x22,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x22, 0x17, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x3a, 0x72, 0x75, 0x6e, 0x3a,
	0x01, 0x2a, 0x12, 0x8a, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x7b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12,
	0x8d, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x1b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x15, 0x12, 0x13, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12,
	0x84, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x29, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x3a, 0x67, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x94, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x1a, 0x26, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x3a, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x3a, 0x01, 0x2a, 0x42, 0x70, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x42, 0x0e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x3b, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_genomics_v1alpha2_pipelines_proto_rawDescOnce sync.Once
	file_google_genomics_v1alpha2_pipelines_proto_rawDescData = file_google_genomics_v1alpha2_pipelines_proto_rawDesc
)

func file_google_genomics_v1alpha2_pipelines_proto_rawDescGZIP() []byte {
	file_google_genomics_v1alpha2_pipelines_proto_rawDescOnce.Do(func() {
		file_google_genomics_v1alpha2_pipelines_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_genomics_v1alpha2_pipelines_proto_rawDescData)
	})
	return file_google_genomics_v1alpha2_pipelines_proto_rawDescData
}

var file_google_genomics_v1alpha2_pipelines_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_genomics_v1alpha2_pipelines_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_google_genomics_v1alpha2_pipelines_proto_goTypes = []interface{}{
	(PipelineResources_Disk_Type)(0),        // 0: google.genomics.v1alpha2.PipelineResources.Disk.Type
	(*ComputeEngine)(nil),                   // 1: google.genomics.v1alpha2.ComputeEngine
	(*RuntimeMetadata)(nil),                 // 2: google.genomics.v1alpha2.RuntimeMetadata
	(*Pipeline)(nil),                        // 3: google.genomics.v1alpha2.Pipeline
	(*CreatePipelineRequest)(nil),           // 4: google.genomics.v1alpha2.CreatePipelineRequest
	(*RunPipelineArgs)(nil),                 // 5: google.genomics.v1alpha2.RunPipelineArgs
	(*RunPipelineRequest)(nil),              // 6: google.genomics.v1alpha2.RunPipelineRequest
	(*GetPipelineRequest)(nil),              // 7: google.genomics.v1alpha2.GetPipelineRequest
	(*ListPipelinesRequest)(nil),            // 8: google.genomics.v1alpha2.ListPipelinesRequest
	(*ListPipelinesResponse)(nil),           // 9: google.genomics.v1alpha2.ListPipelinesResponse
	(*DeletePipelineRequest)(nil),           // 10: google.genomics.v1alpha2.DeletePipelineRequest
	(*GetControllerConfigRequest)(nil),      // 11: google.genomics.v1alpha2.GetControllerConfigRequest
	(*ControllerConfig)(nil),                // 12: google.genomics.v1alpha2.ControllerConfig
	(*TimestampEvent)(nil),                  // 13: google.genomics.v1alpha2.TimestampEvent
	(*SetOperationStatusRequest)(nil),       // 14: google.genomics.v1alpha2.SetOperationStatusRequest
	(*ServiceAccount)(nil),                  // 15: google.genomics.v1alpha2.ServiceAccount
	(*LoggingOptions)(nil),                  // 16: google.genomics.v1alpha2.LoggingOptions
	(*PipelineResources)(nil),               // 17: google.genomics.v1alpha2.PipelineResources
	(*PipelineParameter)(nil),               // 18: google.genomics.v1alpha2.PipelineParameter
	(*DockerExecutor)(nil),                  // 19: google.genomics.v1alpha2.DockerExecutor
	nil,                                     // 20: google.genomics.v1alpha2.RunPipelineArgs.InputsEntry
	nil,                                     // 21: google.genomics.v1alpha2.RunPipelineArgs.OutputsEntry
	nil,                                     // 22: google.genomics.v1alpha2.RunPipelineArgs.LabelsEntry
	(*ControllerConfig_RepeatedString)(nil), // 23: google.genomics.v1alpha2.ControllerConfig.RepeatedString
	nil,                                     // 24: google.genomics.v1alpha2.ControllerConfig.VarsEntry
	nil,                                     // 25: google.genomics.v1alpha2.ControllerConfig.DisksEntry
	nil,                                     // 26: google.genomics.v1alpha2.ControllerConfig.GcsSourcesEntry
	nil,                                     // 27: google.genomics.v1alpha2.ControllerConfig.GcsSinksEntry
	(*PipelineResources_Disk)(nil),          // 28: google.genomics.v1alpha2.PipelineResources.Disk
	(*PipelineParameter_LocalCopy)(nil),     // 29: google.genomics.v1alpha2.PipelineParameter.LocalCopy
	(*durationpb.Duration)(nil),             // 30: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),           // 31: google.protobuf.Timestamp
	(code.Code)(0),                          // 32: google.rpc.Code
	(*longrunning.Operation)(nil),           // 33: google.longrunning.Operation
	(*emptypb.Empty)(nil),                   // 34: google.protobuf.Empty
}
var file_google_genomics_v1alpha2_pipelines_proto_depIdxs = []int32{
	1,  // 0: google.genomics.v1alpha2.RuntimeMetadata.compute_engine:type_name -> google.genomics.v1alpha2.ComputeEngine
	18, // 1: google.genomics.v1alpha2.Pipeline.input_parameters:type_name -> google.genomics.v1alpha2.PipelineParameter
	18, // 2: google.genomics.v1alpha2.Pipeline.output_parameters:type_name -> google.genomics.v1alpha2.PipelineParameter
	19, // 3: google.genomics.v1alpha2.Pipeline.docker:type_name -> google.genomics.v1alpha2.DockerExecutor
	17, // 4: google.genomics.v1alpha2.Pipeline.resources:type_name -> google.genomics.v1alpha2.PipelineResources
	3,  // 5: google.genomics.v1alpha2.CreatePipelineRequest.pipeline:type_name -> google.genomics.v1alpha2.Pipeline
	20, // 6: google.genomics.v1alpha2.RunPipelineArgs.inputs:type_name -> google.genomics.v1alpha2.RunPipelineArgs.InputsEntry
	21, // 7: google.genomics.v1alpha2.RunPipelineArgs.outputs:type_name -> google.genomics.v1alpha2.RunPipelineArgs.OutputsEntry
	15, // 8: google.genomics.v1alpha2.RunPipelineArgs.service_account:type_name -> google.genomics.v1alpha2.ServiceAccount
	17, // 9: google.genomics.v1alpha2.RunPipelineArgs.resources:type_name -> google.genomics.v1alpha2.PipelineResources
	16, // 10: google.genomics.v1alpha2.RunPipelineArgs.logging:type_name -> google.genomics.v1alpha2.LoggingOptions
	30, // 11: google.genomics.v1alpha2.RunPipelineArgs.keep_vm_alive_on_failure_duration:type_name -> google.protobuf.Duration
	22, // 12: google.genomics.v1alpha2.RunPipelineArgs.labels:type_name -> google.genomics.v1alpha2.RunPipelineArgs.LabelsEntry
	3,  // 13: google.genomics.v1alpha2.RunPipelineRequest.ephemeral_pipeline:type_name -> google.genomics.v1alpha2.Pipeline
	5,  // 14: google.genomics.v1alpha2.RunPipelineRequest.pipeline_args:type_name -> google.genomics.v1alpha2.RunPipelineArgs
	3,  // 15: google.genomics.v1alpha2.ListPipelinesResponse.pipelines:type_name -> google.genomics.v1alpha2.Pipeline
	24, // 16: google.genomics.v1alpha2.ControllerConfig.vars:type_name -> google.genomics.v1alpha2.ControllerConfig.VarsEntry
	25, // 17: google.genomics.v1alpha2.ControllerConfig.disks:type_name -> google.genomics.v1alpha2.ControllerConfig.DisksEntry
	26, // 18: google.genomics.v1alpha2.ControllerConfig.gcs_sources:type_name -> google.genomics.v1alpha2.ControllerConfig.GcsSourcesEntry
	27, // 19: google.genomics.v1alpha2.ControllerConfig.gcs_sinks:type_name -> google.genomics.v1alpha2.ControllerConfig.GcsSinksEntry
	31, // 20: google.genomics.v1alpha2.TimestampEvent.timestamp:type_name -> google.protobuf.Timestamp
	13, // 21: google.genomics.v1alpha2.SetOperationStatusRequest.timestamp_events:type_name -> google.genomics.v1alpha2.TimestampEvent
	32, // 22: google.genomics.v1alpha2.SetOperationStatusRequest.error_code:type_name -> google.rpc.Code
	28, // 23: google.genomics.v1alpha2.PipelineResources.disks:type_name -> google.genomics.v1alpha2.PipelineResources.Disk
	29, // 24: google.genomics.v1alpha2.PipelineParameter.local_copy:type_name -> google.genomics.v1alpha2.PipelineParameter.LocalCopy
	23, // 25: google.genomics.v1alpha2.ControllerConfig.GcsSourcesEntry.value:type_name -> google.genomics.v1alpha2.ControllerConfig.RepeatedString
	23, // 26: google.genomics.v1alpha2.ControllerConfig.GcsSinksEntry.value:type_name -> google.genomics.v1alpha2.ControllerConfig.RepeatedString
	0,  // 27: google.genomics.v1alpha2.PipelineResources.Disk.type:type_name -> google.genomics.v1alpha2.PipelineResources.Disk.Type
	4,  // 28: google.genomics.v1alpha2.PipelinesV1Alpha2.CreatePipeline:input_type -> google.genomics.v1alpha2.CreatePipelineRequest
	6,  // 29: google.genomics.v1alpha2.PipelinesV1Alpha2.RunPipeline:input_type -> google.genomics.v1alpha2.RunPipelineRequest
	7,  // 30: google.genomics.v1alpha2.PipelinesV1Alpha2.GetPipeline:input_type -> google.genomics.v1alpha2.GetPipelineRequest
	8,  // 31: google.genomics.v1alpha2.PipelinesV1Alpha2.ListPipelines:input_type -> google.genomics.v1alpha2.ListPipelinesRequest
	10, // 32: google.genomics.v1alpha2.PipelinesV1Alpha2.DeletePipeline:input_type -> google.genomics.v1alpha2.DeletePipelineRequest
	11, // 33: google.genomics.v1alpha2.PipelinesV1Alpha2.GetControllerConfig:input_type -> google.genomics.v1alpha2.GetControllerConfigRequest
	14, // 34: google.genomics.v1alpha2.PipelinesV1Alpha2.SetOperationStatus:input_type -> google.genomics.v1alpha2.SetOperationStatusRequest
	3,  // 35: google.genomics.v1alpha2.PipelinesV1Alpha2.CreatePipeline:output_type -> google.genomics.v1alpha2.Pipeline
	33, // 36: google.genomics.v1alpha2.PipelinesV1Alpha2.RunPipeline:output_type -> google.longrunning.Operation
	3,  // 37: google.genomics.v1alpha2.PipelinesV1Alpha2.GetPipeline:output_type -> google.genomics.v1alpha2.Pipeline
	9,  // 38: google.genomics.v1alpha2.PipelinesV1Alpha2.ListPipelines:output_type -> google.genomics.v1alpha2.ListPipelinesResponse
	34, // 39: google.genomics.v1alpha2.PipelinesV1Alpha2.DeletePipeline:output_type -> google.protobuf.Empty
	12, // 40: google.genomics.v1alpha2.PipelinesV1Alpha2.GetControllerConfig:output_type -> google.genomics.v1alpha2.ControllerConfig
	34, // 41: google.genomics.v1alpha2.PipelinesV1Alpha2.SetOperationStatus:output_type -> google.protobuf.Empty
	35, // [35:42] is the sub-list for method output_type
	28, // [28:35] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_genomics_v1alpha2_pipelines_proto_init() }
func file_google_genomics_v1alpha2_pipelines_proto_init() {
	if File_google_genomics_v1alpha2_pipelines_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeEngine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPipelineArgs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPipelinesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPipelinesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePipelineRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetControllerConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ControllerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetOperationStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineParameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DockerExecutor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ControllerConfig_RepeatedString); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineResources_Disk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1alpha2_pipelines_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineParameter_LocalCopy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_genomics_v1alpha2_pipelines_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Pipeline_Docker)(nil),
	}
	file_google_genomics_v1alpha2_pipelines_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*RunPipelineRequest_PipelineId)(nil),
		(*RunPipelineRequest_EphemeralPipeline)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_genomics_v1alpha2_pipelines_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_genomics_v1alpha2_pipelines_proto_goTypes,
		DependencyIndexes: file_google_genomics_v1alpha2_pipelines_proto_depIdxs,
		EnumInfos:         file_google_genomics_v1alpha2_pipelines_proto_enumTypes,
		MessageInfos:      file_google_genomics_v1alpha2_pipelines_proto_msgTypes,
	}.Build()
	File_google_genomics_v1alpha2_pipelines_proto = out.File
	file_google_genomics_v1alpha2_pipelines_proto_rawDesc = nil
	file_google_genomics_v1alpha2_pipelines_proto_goTypes = nil
	file_google_genomics_v1alpha2_pipelines_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PipelinesV1Alpha2Client is the client API for PipelinesV1Alpha2 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PipelinesV1Alpha2Client interface {
	// Creates a pipeline that can be run later. Create takes a Pipeline that
	// has all fields other than `pipelineId` populated, and then returns
	// the same pipeline with `pipelineId` populated. This id can be used
	// to run the pipeline.
	//
	// Caller must have WRITE permission to the project.
	CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// Runs a pipeline. If `pipelineId` is specified in the request, then
	// run a saved pipeline. If `ephemeralPipeline` is specified, then run
	// that pipeline once without saving a copy.
	//
	// The caller must have READ permission to the project where the pipeline
	// is stored and WRITE permission to the project where the pipeline will be
	// run, as VMs will be created and storage will be used.
	RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Retrieves a pipeline based on ID.
	//
	// Caller must have READ permission to the project.
	GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// Lists pipelines.
	//
	// Caller must have READ permission to the project.
	ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error)
	// Deletes a pipeline based on ID.
	//
	// Caller must have WRITE permission to the project.
	DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets controller configuration information. Should only be called
	// by VMs created by the Pipelines Service and not by end users.
	GetControllerConfig(ctx context.Context, in *GetControllerConfigRequest, opts ...grpc.CallOption) (*ControllerConfig, error)
	// Sets status of a given operation. Any new timestamps (as determined by
	// description) are appended to TimestampEvents. Should only be called by VMs
	// created by the Pipelines Service and not by end users.
	SetOperationStatus(ctx context.Context, in *SetOperationStatusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type pipelinesV1Alpha2Client struct {
	cc grpc.ClientConnInterface
}

func NewPipelinesV1Alpha2Client(cc grpc.ClientConnInterface) PipelinesV1Alpha2Client {
	return &pipelinesV1Alpha2Client{cc}
}

func (c *pipelinesV1Alpha2Client) CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/CreatePipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/RunPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error) {
	out := new(ListPipelinesResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/ListPipelines", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/DeletePipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) GetControllerConfig(ctx context.Context, in *GetControllerConfigRequest, opts ...grpc.CallOption) (*ControllerConfig, error) {
	out := new(ControllerConfig)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetControllerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) SetOperationStatus(ctx context.Context, in *SetOperationStatusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/SetOperationStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PipelinesV1Alpha2Server is the server API for PipelinesV1Alpha2 service.
type PipelinesV1Alpha2Server interface {
	// Creates a pipeline that can be run later. Create takes a Pipeline that
	// has all fields other than `pipelineId` populated, and then returns
	// the same pipeline with `pipelineId` populated. This id can be used
	// to run the pipeline.
	//
	// Caller must have WRITE permission to the project.
	CreatePipeline(context.Context, *CreatePipelineRequest) (*Pipeline, error)
	// Runs a pipeline. If `pipelineId` is specified in the request, then
	// run a saved pipeline. If `ephemeralPipeline` is specified, then run
	// that pipeline once without saving a copy.
	//
	// The caller must have READ permission to the project where the pipeline
	// is stored and WRITE permission to the project where the pipeline will be
	// run, as VMs will be created and storage will be used.
	RunPipeline(context.Context, *RunPipelineRequest) (*longrunning.Operation, error)
	// Retrieves a pipeline based on ID.
	//
	// Caller must have READ permission to the project.
	GetPipeline(context.Context, *GetPipelineRequest) (*Pipeline, error)
	// Lists pipelines.
	//
	// Caller must have READ permission to the project.
	ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error)
	// Deletes a pipeline based on ID.
	//
	// Caller must have WRITE permission to the project.
	DeletePipeline(context.Context, *DeletePipelineRequest) (*emptypb.Empty, error)
	// Gets controller configuration information. Should only be called
	// by VMs created by the Pipelines Service and not by end users.
	GetControllerConfig(context.Context, *GetControllerConfigRequest) (*ControllerConfig, error)
	// Sets status of a given operation. Any new timestamps (as determined by
	// description) are appended to TimestampEvents. Should only be called by VMs
	// created by the Pipelines Service and not by end users.
	SetOperationStatus(context.Context, *SetOperationStatusRequest) (*emptypb.Empty, error)
}

// UnimplementedPipelinesV1Alpha2Server can be embedded to have forward compatible implementations.
type UnimplementedPipelinesV1Alpha2Server struct {
}

func (*UnimplementedPipelinesV1Alpha2Server) CreatePipeline(context.Context, *CreatePipelineRequest) (*Pipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePipeline not implemented")
}
func (*UnimplementedPipelinesV1Alpha2Server) RunPipeline(context.Context, *RunPipelineRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunPipeline not implemented")
}
func (*UnimplementedPipelinesV1Alpha2Server) GetPipeline(context.Context, *GetPipelineRequest) (*Pipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipeline not implemented")
}
func (*UnimplementedPipelinesV1Alpha2Server) ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPipelines not implemented")
}
func (*UnimplementedPipelinesV1Alpha2Server) DeletePipeline(context.Context, *DeletePipelineRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePipeline not implemented")
}
func (*UnimplementedPipelinesV1Alpha2Server) GetControllerConfig(context.Context, *GetControllerConfigRequest) (*ControllerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetControllerConfig not implemented")
}
func (*UnimplementedPipelinesV1Alpha2Server) SetOperationStatus(context.Context, *SetOperationStatusRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetOperationStatus not implemented")
}

func RegisterPipelinesV1Alpha2Server(s *grpc.Server, srv PipelinesV1Alpha2Server) {
	s.RegisterService(&_PipelinesV1Alpha2_serviceDesc, srv)
}

func _PipelinesV1Alpha2_CreatePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).CreatePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/CreatePipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).CreatePipeline(ctx, req.(*CreatePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_RunPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).RunPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/RunPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).RunPipeline(ctx, req.(*RunPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).GetPipeline(ctx, req.(*GetPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_ListPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).ListPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/ListPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).ListPipelines(ctx, req.(*ListPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_DeletePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).DeletePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/DeletePipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).DeletePipeline(ctx, req.(*DeletePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_GetControllerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetControllerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).GetControllerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetControllerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).GetControllerConfig(ctx, req.(*GetControllerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_SetOperationStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetOperationStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).SetOperationStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/SetOperationStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).SetOperationStatus(ctx, req.(*SetOperationStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PipelinesV1Alpha2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1alpha2.PipelinesV1Alpha2",
	HandlerType: (*PipelinesV1Alpha2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePipeline",
			Handler:    _PipelinesV1Alpha2_CreatePipeline_Handler,
		},
		{
			MethodName: "RunPipeline",
			Handler:    _PipelinesV1Alpha2_RunPipeline_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _PipelinesV1Alpha2_GetPipeline_Handler,
		},
		{
			MethodName: "ListPipelines",
			Handler:    _PipelinesV1Alpha2_ListPipelines_Handler,
		},
		{
			MethodName: "DeletePipeline",
			Handler:    _PipelinesV1Alpha2_DeletePipeline_Handler,
		},
		{
			MethodName: "GetControllerConfig",
			Handler:    _PipelinesV1Alpha2_GetControllerConfig_Handler,
		},
		{
			MethodName: "SetOperationStatus",
			Handler:    _PipelinesV1Alpha2_SetOperationStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1alpha2/pipelines.proto",
}
