// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package dataproc aliases all exported identifiers in package
// "cloud.google.com/go/dataproc/v2/apiv1/dataprocpb".
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package dataproc

import (
	src "cloud.google.com/go/dataproc/v2/apiv1/dataprocpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
const (
	BatchOperationMetadata_BATCH                            = src.BatchOperationMetadata_BATCH
	BatchOperationMetadata_BATCH_OPERATION_TYPE_UNSPECIFIED = src.BatchOperationMetadata_BATCH_OPERATION_TYPE_UNSPECIFIED
	Batch_CANCELLED                                         = src.Batch_CANCELLED
	Batch_CANCELLING                                        = src.Batch_CANCELLING
	Batch_FAILED                                            = src.Batch_FAILED
	Batch_PENDING                                           = src.Batch_PENDING
	Batch_RUNNING                                           = src.Batch_RUNNING
	Batch_STATE_UNSPECIFIED                                 = src.Batch_STATE_UNSPECIFIED
	Batch_SUCCEEDED                                         = src.Batch_SUCCEEDED
	ClusterOperationStatus_DONE                             = src.ClusterOperationStatus_DONE
	ClusterOperationStatus_PENDING                          = src.ClusterOperationStatus_PENDING
	ClusterOperationStatus_RUNNING                          = src.ClusterOperationStatus_RUNNING
	ClusterOperationStatus_UNKNOWN                          = src.ClusterOperationStatus_UNKNOWN
	ClusterStatus_CREATING                                  = src.ClusterStatus_CREATING
	ClusterStatus_DELETING                                  = src.ClusterStatus_DELETING
	ClusterStatus_ERROR                                     = src.ClusterStatus_ERROR
	ClusterStatus_ERROR_DUE_TO_UPDATE                       = src.ClusterStatus_ERROR_DUE_TO_UPDATE
	ClusterStatus_RUNNING                                   = src.ClusterStatus_RUNNING
	ClusterStatus_STALE_STATUS                              = src.ClusterStatus_STALE_STATUS
	ClusterStatus_STARTING                                  = src.ClusterStatus_STARTING
	ClusterStatus_STOPPED                                   = src.ClusterStatus_STOPPED
	ClusterStatus_STOPPING                                  = src.ClusterStatus_STOPPING
	ClusterStatus_UNHEALTHY                                 = src.ClusterStatus_UNHEALTHY
	ClusterStatus_UNKNOWN                                   = src.ClusterStatus_UNKNOWN
	ClusterStatus_UNSPECIFIED                               = src.ClusterStatus_UNSPECIFIED
	ClusterStatus_UPDATING                                  = src.ClusterStatus_UPDATING
	Component_ANACONDA                                      = src.Component_ANACONDA
	Component_COMPONENT_UNSPECIFIED                         = src.Component_COMPONENT_UNSPECIFIED
	Component_DOCKER                                        = src.Component_DOCKER
	Component_DRUID                                         = src.Component_DRUID
	Component_FLINK                                         = src.Component_FLINK
	Component_HBASE                                         = src.Component_HBASE
	Component_HIVE_WEBHCAT                                  = src.Component_HIVE_WEBHCAT
	Component_JUPYTER                                       = src.Component_JUPYTER
	Component_PRESTO                                        = src.Component_PRESTO
	Component_RANGER                                        = src.Component_RANGER
	Component_SOLR                                          = src.Component_SOLR
	Component_ZEPPELIN                                      = src.Component_ZEPPELIN
	Component_ZOOKEEPER                                     = src.Component_ZOOKEEPER
	DataprocMetricConfig_HDFS                               = src.DataprocMetricConfig_HDFS
	DataprocMetricConfig_HIVESERVER2                        = src.DataprocMetricConfig_HIVESERVER2
	DataprocMetricConfig_METRIC_SOURCE_UNSPECIFIED          = src.DataprocMetricConfig_METRIC_SOURCE_UNSPECIFIED
	DataprocMetricConfig_MONITORING_AGENT_DEFAULTS          = src.DataprocMetricConfig_MONITORING_AGENT_DEFAULTS
	DataprocMetricConfig_SPARK                              = src.DataprocMetricConfig_SPARK
	DataprocMetricConfig_SPARK_HISTORY_SERVER               = src.DataprocMetricConfig_SPARK_HISTORY_SERVER
	DataprocMetricConfig_YARN                               = src.DataprocMetricConfig_YARN
	FailureAction_DELETE                                    = src.FailureAction_DELETE
	FailureAction_FAILURE_ACTION_UNSPECIFIED                = src.FailureAction_FAILURE_ACTION_UNSPECIFIED
	FailureAction_NO_ACTION                                 = src.FailureAction_NO_ACTION
	GceClusterConfig_BIDIRECTIONAL                          = src.GceClusterConfig_BIDIRECTIONAL
	GceClusterConfig_INHERIT_FROM_SUBNETWORK                = src.GceClusterConfig_INHERIT_FROM_SUBNETWORK
	GceClusterConfig_OUTBOUND                               = src.GceClusterConfig_OUTBOUND
	GceClusterConfig_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = src.GceClusterConfig_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
	GkeNodePoolTarget_CONTROLLER                            = src.GkeNodePoolTarget_CONTROLLER
	GkeNodePoolTarget_DEFAULT                               = src.GkeNodePoolTarget_DEFAULT
	GkeNodePoolTarget_ROLE_UNSPECIFIED                      = src.GkeNodePoolTarget_ROLE_UNSPECIFIED
	GkeNodePoolTarget_SPARK_DRIVER                          = src.GkeNodePoolTarget_SPARK_DRIVER
	GkeNodePoolTarget_SPARK_EXECUTOR                        = src.GkeNodePoolTarget_SPARK_EXECUTOR
	InstanceGroupConfig_NON_PREEMPTIBLE                     = src.InstanceGroupConfig_NON_PREEMPTIBLE
	InstanceGroupConfig_PREEMPTIBILITY_UNSPECIFIED          = src.InstanceGroupConfig_PREEMPTIBILITY_UNSPECIFIED
	InstanceGroupConfig_PREEMPTIBLE                         = src.InstanceGroupConfig_PREEMPTIBLE
	JobStatus_ATTEMPT_FAILURE                               = src.JobStatus_ATTEMPT_FAILURE
	JobStatus_CANCELLED                                     = src.JobStatus_CANCELLED
	JobStatus_CANCEL_PENDING                                = src.JobStatus_CANCEL_PENDING
	JobStatus_CANCEL_STARTED                                = src.JobStatus_CANCEL_STARTED
	JobStatus_DONE                                          = src.JobStatus_DONE
	JobStatus_ERROR                                         = src.JobStatus_ERROR
	JobStatus_PENDING                                       = src.JobStatus_PENDING
	JobStatus_QUEUED                                        = src.JobStatus_QUEUED
	JobStatus_RUNNING                                       = src.JobStatus_RUNNING
	JobStatus_SETUP_DONE                                    = src.JobStatus_SETUP_DONE
	JobStatus_STALE_STATUS                                  = src.JobStatus_STALE_STATUS
	JobStatus_STATE_UNSPECIFIED                             = src.JobStatus_STATE_UNSPECIFIED
	JobStatus_SUBMITTED                                     = src.JobStatus_SUBMITTED
	JobStatus_UNSPECIFIED                                   = src.JobStatus_UNSPECIFIED
	ListJobsRequest_ACTIVE                                  = src.ListJobsRequest_ACTIVE
	ListJobsRequest_ALL                                     = src.ListJobsRequest_ALL
	ListJobsRequest_NON_ACTIVE                              = src.ListJobsRequest_NON_ACTIVE
	LoggingConfig_ALL                                       = src.LoggingConfig_ALL
	LoggingConfig_DEBUG                                     = src.LoggingConfig_DEBUG
	LoggingConfig_ERROR                                     = src.LoggingConfig_ERROR
	LoggingConfig_FATAL                                     = src.LoggingConfig_FATAL
	LoggingConfig_INFO                                      = src.LoggingConfig_INFO
	LoggingConfig_LEVEL_UNSPECIFIED                         = src.LoggingConfig_LEVEL_UNSPECIFIED
	LoggingConfig_OFF                                       = src.LoggingConfig_OFF
	LoggingConfig_TRACE                                     = src.LoggingConfig_TRACE
	LoggingConfig_WARN                                      = src.LoggingConfig_WARN
	ReservationAffinity_ANY_RESERVATION                     = src.ReservationAffinity_ANY_RESERVATION
	ReservationAffinity_NO_RESERVATION                      = src.ReservationAffinity_NO_RESERVATION
	ReservationAffinity_SPECIFIC_RESERVATION                = src.ReservationAffinity_SPECIFIC_RESERVATION
	ReservationAffinity_TYPE_UNSPECIFIED                    = src.ReservationAffinity_TYPE_UNSPECIFIED
	WorkflowMetadata_DONE                                   = src.WorkflowMetadata_DONE
	WorkflowMetadata_PENDING                                = src.WorkflowMetadata_PENDING
	WorkflowMetadata_RUNNING                                = src.WorkflowMetadata_RUNNING
	WorkflowMetadata_UNKNOWN                                = src.WorkflowMetadata_UNKNOWN
	WorkflowNode_BLOCKED                                    = src.WorkflowNode_BLOCKED
	WorkflowNode_COMPLETED                                  = src.WorkflowNode_COMPLETED
	WorkflowNode_FAILED                                     = src.WorkflowNode_FAILED
	WorkflowNode_NODE_STATE_UNSPECIFIED                     = src.WorkflowNode_NODE_STATE_UNSPECIFIED
	WorkflowNode_RUNNABLE                                   = src.WorkflowNode_RUNNABLE
	WorkflowNode_RUNNING                                    = src.WorkflowNode_RUNNING
	YarnApplication_ACCEPTED                                = src.YarnApplication_ACCEPTED
	YarnApplication_FAILED                                  = src.YarnApplication_FAILED
	YarnApplication_FINISHED                                = src.YarnApplication_FINISHED
	YarnApplication_KILLED                                  = src.YarnApplication_KILLED
	YarnApplication_NEW                                     = src.YarnApplication_NEW
	YarnApplication_NEW_SAVING                              = src.YarnApplication_NEW_SAVING
	YarnApplication_RUNNING                                 = src.YarnApplication_RUNNING
	YarnApplication_STATE_UNSPECIFIED                       = src.YarnApplication_STATE_UNSPECIFIED
	YarnApplication_SUBMITTED                               = src.YarnApplication_SUBMITTED
)

// Deprecated: Please use vars in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
var (
	BatchOperationMetadata_BatchOperationType_name           = src.BatchOperationMetadata_BatchOperationType_name
	BatchOperationMetadata_BatchOperationType_value          = src.BatchOperationMetadata_BatchOperationType_value
	Batch_State_name                                         = src.Batch_State_name
	Batch_State_value                                        = src.Batch_State_value
	ClusterOperationStatus_State_name                        = src.ClusterOperationStatus_State_name
	ClusterOperationStatus_State_value                       = src.ClusterOperationStatus_State_value
	ClusterStatus_State_name                                 = src.ClusterStatus_State_name
	ClusterStatus_State_value                                = src.ClusterStatus_State_value
	ClusterStatus_Substate_name                              = src.ClusterStatus_Substate_name
	ClusterStatus_Substate_value                             = src.ClusterStatus_Substate_value
	Component_name                                           = src.Component_name
	Component_value                                          = src.Component_value
	DataprocMetricConfig_MetricSource_name                   = src.DataprocMetricConfig_MetricSource_name
	DataprocMetricConfig_MetricSource_value                  = src.DataprocMetricConfig_MetricSource_value
	FailureAction_name                                       = src.FailureAction_name
	FailureAction_value                                      = src.FailureAction_value
	File_google_cloud_dataproc_v1_autoscaling_policies_proto = src.File_google_cloud_dataproc_v1_autoscaling_policies_proto
	File_google_cloud_dataproc_v1_batches_proto              = src.File_google_cloud_dataproc_v1_batches_proto
	File_google_cloud_dataproc_v1_clusters_proto             = src.File_google_cloud_dataproc_v1_clusters_proto
	File_google_cloud_dataproc_v1_jobs_proto                 = src.File_google_cloud_dataproc_v1_jobs_proto
	File_google_cloud_dataproc_v1_operations_proto           = src.File_google_cloud_dataproc_v1_operations_proto
	File_google_cloud_dataproc_v1_shared_proto               = src.File_google_cloud_dataproc_v1_shared_proto
	File_google_cloud_dataproc_v1_workflow_templates_proto   = src.File_google_cloud_dataproc_v1_workflow_templates_proto
	GceClusterConfig_PrivateIpv6GoogleAccess_name            = src.GceClusterConfig_PrivateIpv6GoogleAccess_name
	GceClusterConfig_PrivateIpv6GoogleAccess_value           = src.GceClusterConfig_PrivateIpv6GoogleAccess_value
	GkeNodePoolTarget_Role_name                              = src.GkeNodePoolTarget_Role_name
	GkeNodePoolTarget_Role_value                             = src.GkeNodePoolTarget_Role_value
	InstanceGroupConfig_Preemptibility_name                  = src.InstanceGroupConfig_Preemptibility_name
	InstanceGroupConfig_Preemptibility_value                 = src.InstanceGroupConfig_Preemptibility_value
	JobStatus_State_name                                     = src.JobStatus_State_name
	JobStatus_State_value                                    = src.JobStatus_State_value
	JobStatus_Substate_name                                  = src.JobStatus_Substate_name
	JobStatus_Substate_value                                 = src.JobStatus_Substate_value
	ListJobsRequest_JobStateMatcher_name                     = src.ListJobsRequest_JobStateMatcher_name
	ListJobsRequest_JobStateMatcher_value                    = src.ListJobsRequest_JobStateMatcher_value
	LoggingConfig_Level_name                                 = src.LoggingConfig_Level_name
	LoggingConfig_Level_value                                = src.LoggingConfig_Level_value
	ReservationAffinity_Type_name                            = src.ReservationAffinity_Type_name
	ReservationAffinity_Type_value                           = src.ReservationAffinity_Type_value
	WorkflowMetadata_State_name                              = src.WorkflowMetadata_State_name
	WorkflowMetadata_State_value                             = src.WorkflowMetadata_State_value
	WorkflowNode_NodeState_name                              = src.WorkflowNode_NodeState_name
	WorkflowNode_NodeState_value                             = src.WorkflowNode_NodeState_value
	YarnApplication_State_name                               = src.YarnApplication_State_name
	YarnApplication_State_value                              = src.YarnApplication_State_value
)

// Specifies the type and number of accelerator cards attached to the
// instances of an instance. See [GPUs on Compute
// Engine](https://cloud.google.com/compute/docs/gpus/).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type AcceleratorConfig = src.AcceleratorConfig

// Autoscaling Policy config associated with the cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type AutoscalingConfig = src.AutoscalingConfig

// Describes an autoscaling policy for Dataproc cluster autoscaler.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type AutoscalingPolicy = src.AutoscalingPolicy

// AutoscalingPolicyServiceClient is the client API for
// AutoscalingPolicyService service. For semantics around ctx use and
// closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type AutoscalingPolicyServiceClient = src.AutoscalingPolicyServiceClient

// AutoscalingPolicyServiceServer is the server API for
// AutoscalingPolicyService service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type AutoscalingPolicyServiceServer = src.AutoscalingPolicyServiceServer
type AutoscalingPolicy_BasicAlgorithm = src.AutoscalingPolicy_BasicAlgorithm

// Auxiliary services configuration for a Cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type AuxiliaryServicesConfig = src.AuxiliaryServicesConfig

// Basic algorithm for autoscaling.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type BasicAutoscalingAlgorithm = src.BasicAutoscalingAlgorithm
type BasicAutoscalingAlgorithm_YarnConfig = src.BasicAutoscalingAlgorithm_YarnConfig

// Basic autoscaling configurations for YARN.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type BasicYarnAutoscalingConfig = src.BasicYarnAutoscalingConfig

// A representation of a batch workload in the service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type Batch = src.Batch

// BatchControllerClient is the client API for BatchController service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type BatchControllerClient = src.BatchControllerClient

// BatchControllerServer is the server API for BatchController service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type BatchControllerServer = src.BatchControllerServer

// Metadata describing the Batch operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type BatchOperationMetadata = src.BatchOperationMetadata

// Operation type for Batch resources
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type BatchOperationMetadata_BatchOperationType = src.BatchOperationMetadata_BatchOperationType
type Batch_PysparkBatch = src.Batch_PysparkBatch
type Batch_SparkBatch = src.Batch_SparkBatch
type Batch_SparkRBatch = src.Batch_SparkRBatch
type Batch_SparkSqlBatch = src.Batch_SparkSqlBatch

// The batch state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type Batch_State = src.Batch_State

// Historical state information.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type Batch_StateHistory = src.Batch_StateHistory

// A request to cancel a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type CancelJobRequest = src.CancelJobRequest

// Describes the identifying information, config, and status of a Dataproc
// cluster
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type Cluster = src.Cluster

// The cluster config.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterConfig = src.ClusterConfig

// ClusterControllerClient is the client API for ClusterController service.
// For semantics around ctx use and closing/ending streaming RPCs, please refer
// to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterControllerClient = src.ClusterControllerClient

// ClusterControllerServer is the server API for ClusterController service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterControllerServer = src.ClusterControllerServer

// Contains cluster daemon metrics, such as HDFS and YARN stats. **Beta
// Feature**: This report is available for testing purposes only. It may be
// changed before final release.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterMetrics = src.ClusterMetrics

// The cluster operation triggered by a workflow.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterOperation = src.ClusterOperation

// Metadata describing the operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterOperationMetadata = src.ClusterOperationMetadata

// The status of the operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterOperationStatus = src.ClusterOperationStatus

// The operation state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterOperationStatus_State = src.ClusterOperationStatus_State

// A selector that chooses target cluster for jobs based on metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterSelector = src.ClusterSelector

// The status of a cluster and its instances.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterStatus = src.ClusterStatus

// The cluster state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterStatus_State = src.ClusterStatus_State

// The cluster substate.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ClusterStatus_Substate = src.ClusterStatus_Substate

// Cluster components that can be activated.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type Component = src.Component

// Confidential Instance Config for clusters using [Confidential
// VMs](https://cloud.google.com/compute/confidential-vm/docs)
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ConfidentialInstanceConfig = src.ConfidentialInstanceConfig

// A request to create an autoscaling policy.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type CreateAutoscalingPolicyRequest = src.CreateAutoscalingPolicyRequest

// A request to create a batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type CreateBatchRequest = src.CreateBatchRequest

// A request to create a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type CreateClusterRequest = src.CreateClusterRequest

// A request to create a workflow template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type CreateWorkflowTemplateRequest = src.CreateWorkflowTemplateRequest

// Dataproc metric config.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DataprocMetricConfig = src.DataprocMetricConfig

// A Dataproc OSS metric.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DataprocMetricConfig_Metric = src.DataprocMetricConfig_Metric

// A source for the collection of Dataproc OSS metrics (see [available OSS
// metrics]
// (https://cloud.google.com//dataproc/docs/guides/monitoring#available_oss_metrics)).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DataprocMetricConfig_MetricSource = src.DataprocMetricConfig_MetricSource

// A request to delete an autoscaling policy. Autoscaling policies in use by
// one or more clusters will not be deleted.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DeleteAutoscalingPolicyRequest = src.DeleteAutoscalingPolicyRequest

// A request to delete a batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DeleteBatchRequest = src.DeleteBatchRequest

// A request to delete a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DeleteClusterRequest = src.DeleteClusterRequest

// A request to delete a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DeleteJobRequest = src.DeleteJobRequest

// A request to delete a workflow template. Currently started workflows will
// remain running.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DeleteWorkflowTemplateRequest = src.DeleteWorkflowTemplateRequest

// A request to collect cluster diagnostic information.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DiagnoseClusterRequest = src.DiagnoseClusterRequest

// The location of diagnostic output.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DiagnoseClusterResults = src.DiagnoseClusterResults

// Specifies the config of disk options for a group of VM instances.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type DiskConfig = src.DiskConfig

// Encryption settings for the cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type EncryptionConfig = src.EncryptionConfig

// Endpoint config for this cluster
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type EndpointConfig = src.EndpointConfig

// Environment configuration for a workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type EnvironmentConfig = src.EnvironmentConfig

// Execution configuration for a workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ExecutionConfig = src.ExecutionConfig
type ExecutionConfig_NetworkUri = src.ExecutionConfig_NetworkUri
type ExecutionConfig_SubnetworkUri = src.ExecutionConfig_SubnetworkUri

// Actions in response to failure of a resource associated with a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type FailureAction = src.FailureAction

// Common config settings for resources of Compute Engine cluster instances,
// applicable to all instances in the cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GceClusterConfig = src.GceClusterConfig

// `PrivateIpv6GoogleAccess` controls whether and how Dataproc cluster nodes
// can communicate with Google Services through gRPC over IPv6. These values
// are directly mapped to corresponding values in the [Compute Engine Instance
// fields](https://cloud.google.com/compute/docs/reference/rest/v1/instances).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GceClusterConfig_PrivateIpv6GoogleAccess = src.GceClusterConfig_PrivateIpv6GoogleAccess

// A request to fetch an autoscaling policy.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GetAutoscalingPolicyRequest = src.GetAutoscalingPolicyRequest

// A request to get the resource representation for a batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GetBatchRequest = src.GetBatchRequest

// Request to get the resource representation for a cluster in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GetClusterRequest = src.GetClusterRequest

// A request to get the resource representation for a job in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GetJobRequest = src.GetJobRequest

// A request to fetch a workflow template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GetWorkflowTemplateRequest = src.GetWorkflowTemplateRequest

// The cluster's GKE config.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeClusterConfig = src.GkeClusterConfig

// The configuration of a GKE NodePool used by a [Dataproc-on-GKE
// cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeNodePoolConfig = src.GkeNodePoolConfig

// Parameters that describe cluster nodes.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeNodePoolConfig_GkeNodeConfig = src.GkeNodePoolConfig_GkeNodeConfig

// A GkeNodeConfigAcceleratorConfig represents a Hardware Accelerator request
// for a NodePool.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeNodePoolConfig_GkeNodePoolAcceleratorConfig = src.GkeNodePoolConfig_GkeNodePoolAcceleratorConfig

// GkeNodePoolAutoscaling contains information the cluster autoscaler needs to
// adjust the size of the node pool to the current cluster usage.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeNodePoolConfig_GkeNodePoolAutoscalingConfig = src.GkeNodePoolConfig_GkeNodePoolAutoscalingConfig

// GKE NodePools that Dataproc workloads run on.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeNodePoolTarget = src.GkeNodePoolTarget

// `Role` specifies whose tasks will run on the NodePool. The roles can be
// specific to workloads. Exactly one GkeNodePoolTarget within the
// VirtualCluster must have 'default' role, which is used to run all workloads
// that are not associated with a NodePool.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type GkeNodePoolTarget_Role = src.GkeNodePoolTarget_Role

// A Dataproc job for running [Apache Hadoop
// MapReduce](https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html)
// jobs on [Apache Hadoop
// YARN](https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type HadoopJob = src.HadoopJob
type HadoopJob_MainClass = src.HadoopJob_MainClass
type HadoopJob_MainJarFileUri = src.HadoopJob_MainJarFileUri

// A Dataproc job for running [Apache Hive](https://hive.apache.org/) queries
// on YARN.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type HiveJob = src.HiveJob
type HiveJob_QueryFileUri = src.HiveJob_QueryFileUri
type HiveJob_QueryList = src.HiveJob_QueryList

// Identity related configuration, including service account based secure
// multi-tenancy user mappings.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type IdentityConfig = src.IdentityConfig

// Configuration for the size bounds of an instance group, including its
// proportional size to other groups.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type InstanceGroupAutoscalingPolicyConfig = src.InstanceGroupAutoscalingPolicyConfig

// The config settings for Compute Engine resources in an instance group, such
// as a master or worker group.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type InstanceGroupConfig = src.InstanceGroupConfig

// Controls the use of [preemptible instances]
// (https://cloud.google.com/compute/docs/instances/preemptible) within the
// group.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type InstanceGroupConfig_Preemptibility = src.InstanceGroupConfig_Preemptibility

// A request to instantiate an inline workflow template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type InstantiateInlineWorkflowTemplateRequest = src.InstantiateInlineWorkflowTemplateRequest

// A request to instantiate a workflow template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type InstantiateWorkflowTemplateRequest = src.InstantiateWorkflowTemplateRequest

// A Dataproc job resource.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type Job = src.Job

// JobControllerClient is the client API for JobController service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobControllerClient = src.JobControllerClient

// JobControllerServer is the server API for JobController service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobControllerServer = src.JobControllerServer

// Job Operation metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobMetadata = src.JobMetadata

// Dataproc job config.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobPlacement = src.JobPlacement

// Encapsulates the full scoping used to reference a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobReference = src.JobReference

// Job scheduling options.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobScheduling = src.JobScheduling

// Dataproc job status.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobStatus = src.JobStatus

// The job state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobStatus_State = src.JobStatus_State

// The job substate.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type JobStatus_Substate = src.JobStatus_Substate
type Job_HadoopJob = src.Job_HadoopJob
type Job_HiveJob = src.Job_HiveJob
type Job_PigJob = src.Job_PigJob
type Job_PrestoJob = src.Job_PrestoJob
type Job_PysparkJob = src.Job_PysparkJob
type Job_SparkJob = src.Job_SparkJob
type Job_SparkRJob = src.Job_SparkRJob
type Job_SparkSqlJob = src.Job_SparkSqlJob

// Specifies Kerberos related configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type KerberosConfig = src.KerberosConfig

// The configuration for running the Dataproc cluster on Kubernetes.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type KubernetesClusterConfig = src.KubernetesClusterConfig
type KubernetesClusterConfig_GkeClusterConfig = src.KubernetesClusterConfig_GkeClusterConfig

// The software configuration for this Dataproc cluster running on Kubernetes.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type KubernetesSoftwareConfig = src.KubernetesSoftwareConfig

// Specifies the cluster auto-delete schedule configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type LifecycleConfig = src.LifecycleConfig
type LifecycleConfig_AutoDeleteTime = src.LifecycleConfig_AutoDeleteTime
type LifecycleConfig_AutoDeleteTtl = src.LifecycleConfig_AutoDeleteTtl

// A request to list autoscaling policies in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListAutoscalingPoliciesRequest = src.ListAutoscalingPoliciesRequest

// A response to a request to list autoscaling policies in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListAutoscalingPoliciesResponse = src.ListAutoscalingPoliciesResponse

// A request to list batch workloads in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListBatchesRequest = src.ListBatchesRequest

// A list of batch workloads.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListBatchesResponse = src.ListBatchesResponse

// A request to list the clusters in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListClustersRequest = src.ListClustersRequest

// The list of all clusters in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListClustersResponse = src.ListClustersResponse

// A request to list jobs in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListJobsRequest = src.ListJobsRequest

// A matcher that specifies categories of job states.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListJobsRequest_JobStateMatcher = src.ListJobsRequest_JobStateMatcher

// A list of jobs in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListJobsResponse = src.ListJobsResponse

// A request to list workflow templates in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListWorkflowTemplatesRequest = src.ListWorkflowTemplatesRequest

// A response to a request to list workflow templates in a project.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ListWorkflowTemplatesResponse = src.ListWorkflowTemplatesResponse

// The runtime logging config of the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type LoggingConfig = src.LoggingConfig

// The Log4j level for job execution. When running an [Apache
// Hive](https://hive.apache.org/) job, Cloud Dataproc configures the Hive
// client to an equivalent verbosity level.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type LoggingConfig_Level = src.LoggingConfig_Level

// Cluster that is managed by the workflow.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ManagedCluster = src.ManagedCluster

// Specifies the resources used to actively manage an instance group.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ManagedGroupConfig = src.ManagedGroupConfig

// Specifies a Metastore configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type MetastoreConfig = src.MetastoreConfig

// Node Group Affinity for clusters using sole-tenant node groups.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type NodeGroupAffinity = src.NodeGroupAffinity

// Specifies an executable to run on a fully configured node and a timeout
// period for executable completion.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type NodeInitializationAction = src.NodeInitializationAction

// A job executed by the workflow.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type OrderedJob = src.OrderedJob
type OrderedJob_HadoopJob = src.OrderedJob_HadoopJob
type OrderedJob_HiveJob = src.OrderedJob_HiveJob
type OrderedJob_PigJob = src.OrderedJob_PigJob
type OrderedJob_PrestoJob = src.OrderedJob_PrestoJob
type OrderedJob_PysparkJob = src.OrderedJob_PysparkJob
type OrderedJob_SparkJob = src.OrderedJob_SparkJob
type OrderedJob_SparkRJob = src.OrderedJob_SparkRJob
type OrderedJob_SparkSqlJob = src.OrderedJob_SparkSqlJob

// Configuration for parameter validation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ParameterValidation = src.ParameterValidation
type ParameterValidation_Regex = src.ParameterValidation_Regex
type ParameterValidation_Values = src.ParameterValidation_Values

// Auxiliary services configuration for a workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type PeripheralsConfig = src.PeripheralsConfig

// A Dataproc job for running [Apache Pig](https://pig.apache.org/) queries on
// YARN.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type PigJob = src.PigJob
type PigJob_QueryFileUri = src.PigJob_QueryFileUri
type PigJob_QueryList = src.PigJob_QueryList

// A Dataproc job for running [Presto](https://prestosql.io/) queries.
// **IMPORTANT**: The [Dataproc Presto Optional
// Component](https://cloud.google.com/dataproc/docs/concepts/components/presto)
// must be enabled when the cluster is created to submit a Presto job to the
// cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type PrestoJob = src.PrestoJob
type PrestoJob_QueryFileUri = src.PrestoJob_QueryFileUri
type PrestoJob_QueryList = src.PrestoJob_QueryList

// A configuration for running an [Apache
// PySpark](https://spark.apache.org/docs/latest/api/python/getting_started/quickstart.html)
// batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type PySparkBatch = src.PySparkBatch

// A Dataproc job for running [Apache
// PySpark](https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
// applications on YARN.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type PySparkJob = src.PySparkJob

// A list of queries to run on a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type QueryList = src.QueryList

// Validation based on regular expressions.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type RegexValidation = src.RegexValidation

// Reservation Affinity for consuming Zonal reservation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ReservationAffinity = src.ReservationAffinity

// Indicates whether to consume capacity from an reservation or not.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ReservationAffinity_Type = src.ReservationAffinity_Type

// Runtime configuration for a workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type RuntimeConfig = src.RuntimeConfig

// Runtime information about workload execution.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type RuntimeInfo = src.RuntimeInfo

// Security related configuration, including encryption, Kerberos, etc.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SecurityConfig = src.SecurityConfig

// Shielded Instance Config for clusters using [Compute Engine Shielded
// VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ShieldedInstanceConfig = src.ShieldedInstanceConfig

// Specifies the selection and config of software inside the cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SoftwareConfig = src.SoftwareConfig

// A configuration for running an [Apache Spark](http://spark.apache.org/)
// batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkBatch = src.SparkBatch
type SparkBatch_MainClass = src.SparkBatch_MainClass
type SparkBatch_MainJarFileUri = src.SparkBatch_MainJarFileUri

// Spark History Server configuration for the workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkHistoryServerConfig = src.SparkHistoryServerConfig

// A Dataproc job for running [Apache Spark](http://spark.apache.org/)
// applications on YARN.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkJob = src.SparkJob
type SparkJob_MainClass = src.SparkJob_MainClass
type SparkJob_MainJarFileUri = src.SparkJob_MainJarFileUri

// A configuration for running an [Apache
// SparkR](https://spark.apache.org/docs/latest/sparkr.html) batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkRBatch = src.SparkRBatch

// A Dataproc job for running [Apache
// SparkR](https://spark.apache.org/docs/latest/sparkr.html) applications on
// YARN.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkRJob = src.SparkRJob

// A configuration for running [Apache Spark
// SQL](http://spark.apache.org/sql/) queries as a batch workload.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkSqlBatch = src.SparkSqlBatch

// A Dataproc job for running [Apache Spark SQL](http://spark.apache.org/sql/)
// queries.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SparkSqlJob = src.SparkSqlJob
type SparkSqlJob_QueryFileUri = src.SparkSqlJob_QueryFileUri
type SparkSqlJob_QueryList = src.SparkSqlJob_QueryList

// A request to start a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type StartClusterRequest = src.StartClusterRequest

// A request to stop a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type StopClusterRequest = src.StopClusterRequest

// A request to submit a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type SubmitJobRequest = src.SubmitJobRequest

// A configurable parameter that replaces one or more fields in the template.
// Parameterizable fields: - Labels - File uris - Job properties - Job
// arguments - Script variables - Main class (in HadoopJob and SparkJob) - Zone
// (in ClusterSelector)
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type TemplateParameter = src.TemplateParameter

// UnimplementedAutoscalingPolicyServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UnimplementedAutoscalingPolicyServiceServer = src.UnimplementedAutoscalingPolicyServiceServer

// UnimplementedBatchControllerServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UnimplementedBatchControllerServer = src.UnimplementedBatchControllerServer

// UnimplementedClusterControllerServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UnimplementedClusterControllerServer = src.UnimplementedClusterControllerServer

// UnimplementedJobControllerServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UnimplementedJobControllerServer = src.UnimplementedJobControllerServer

// UnimplementedWorkflowTemplateServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UnimplementedWorkflowTemplateServiceServer = src.UnimplementedWorkflowTemplateServiceServer

// A request to update an autoscaling policy.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UpdateAutoscalingPolicyRequest = src.UpdateAutoscalingPolicyRequest

// A request to update a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UpdateClusterRequest = src.UpdateClusterRequest

// A request to update a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UpdateJobRequest = src.UpdateJobRequest

// A request to update a workflow template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type UpdateWorkflowTemplateRequest = src.UpdateWorkflowTemplateRequest

// Validation based on a list of allowed values.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type ValueValidation = src.ValueValidation

// Dataproc cluster config for a cluster that does not directly control the
// underlying compute resources, such as a [Dataproc-on-GKE
// cluster](https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type VirtualClusterConfig = src.VirtualClusterConfig
type VirtualClusterConfig_KubernetesClusterConfig = src.VirtualClusterConfig_KubernetesClusterConfig

// The workflow graph.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowGraph = src.WorkflowGraph

// A Dataproc workflow template resource.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowMetadata = src.WorkflowMetadata

// The operation state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowMetadata_State = src.WorkflowMetadata_State

// The workflow node.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowNode = src.WorkflowNode

// The workflow node state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowNode_NodeState = src.WorkflowNode_NodeState

// A Dataproc workflow template resource.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowTemplate = src.WorkflowTemplate

// Specifies workflow execution target. Either `managed_cluster` or
// `cluster_selector` is required.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowTemplatePlacement = src.WorkflowTemplatePlacement
type WorkflowTemplatePlacement_ClusterSelector = src.WorkflowTemplatePlacement_ClusterSelector
type WorkflowTemplatePlacement_ManagedCluster = src.WorkflowTemplatePlacement_ManagedCluster

// WorkflowTemplateServiceClient is the client API for WorkflowTemplateService
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowTemplateServiceClient = src.WorkflowTemplateServiceClient

// WorkflowTemplateServiceServer is the server API for WorkflowTemplateService
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type WorkflowTemplateServiceServer = src.WorkflowTemplateServiceServer

// A YARN application created by a job. Application information is a subset of
// <code>org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto</code>.
// **Beta Feature**: This report is available for testing purposes only. It may
// be changed before final release.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type YarnApplication = src.YarnApplication

// The application state, corresponding to
// <code>YarnProtos.YarnApplicationStateProto</code>.
//
// Deprecated: Please use types in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
type YarnApplication_State = src.YarnApplication_State

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func NewAutoscalingPolicyServiceClient(cc grpc.ClientConnInterface) AutoscalingPolicyServiceClient {
	return src.NewAutoscalingPolicyServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func NewBatchControllerClient(cc grpc.ClientConnInterface) BatchControllerClient {
	return src.NewBatchControllerClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func NewClusterControllerClient(cc grpc.ClientConnInterface) ClusterControllerClient {
	return src.NewClusterControllerClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func NewJobControllerClient(cc grpc.ClientConnInterface) JobControllerClient {
	return src.NewJobControllerClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func NewWorkflowTemplateServiceClient(cc grpc.ClientConnInterface) WorkflowTemplateServiceClient {
	return src.NewWorkflowTemplateServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func RegisterAutoscalingPolicyServiceServer(s *grpc.Server, srv AutoscalingPolicyServiceServer) {
	src.RegisterAutoscalingPolicyServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func RegisterBatchControllerServer(s *grpc.Server, srv BatchControllerServer) {
	src.RegisterBatchControllerServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	src.RegisterClusterControllerServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func RegisterJobControllerServer(s *grpc.Server, srv JobControllerServer) {
	src.RegisterJobControllerServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataproc/v2/apiv1/dataprocpb
func RegisterWorkflowTemplateServiceServer(s *grpc.Server, srv WorkflowTemplateServiceServer) {
	src.RegisterWorkflowTemplateServiceServer(s, srv)
}
