// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package dataflow aliases all exported identifiers in package
// "cloud.google.com/go/dataflow/apiv1beta3/dataflowpb".
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package dataflow

import (
	src "cloud.google.com/go/dataflow/apiv1beta3/dataflowpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
const (
	AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_BASIC    = src.AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_BASIC
	AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_NONE     = src.AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_NONE
	AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_UNKNOWN  = src.AutoscalingAlgorithm_AUTOSCALING_ALGORITHM_UNKNOWN
	AutoscalingEvent_ACTUATION_FAILURE                  = src.AutoscalingEvent_ACTUATION_FAILURE
	AutoscalingEvent_CURRENT_NUM_WORKERS_CHANGED        = src.AutoscalingEvent_CURRENT_NUM_WORKERS_CHANGED
	AutoscalingEvent_NO_CHANGE                          = src.AutoscalingEvent_NO_CHANGE
	AutoscalingEvent_TARGET_NUM_WORKERS_CHANGED         = src.AutoscalingEvent_TARGET_NUM_WORKERS_CHANGED
	AutoscalingEvent_TYPE_UNKNOWN                       = src.AutoscalingEvent_TYPE_UNKNOWN
	DefaultPackageSet_DEFAULT_PACKAGE_SET_JAVA          = src.DefaultPackageSet_DEFAULT_PACKAGE_SET_JAVA
	DefaultPackageSet_DEFAULT_PACKAGE_SET_NONE          = src.DefaultPackageSet_DEFAULT_PACKAGE_SET_NONE
	DefaultPackageSet_DEFAULT_PACKAGE_SET_PYTHON        = src.DefaultPackageSet_DEFAULT_PACKAGE_SET_PYTHON
	DefaultPackageSet_DEFAULT_PACKAGE_SET_UNKNOWN       = src.DefaultPackageSet_DEFAULT_PACKAGE_SET_UNKNOWN
	ExecutionState_EXECUTION_STATE_CANCELLED            = src.ExecutionState_EXECUTION_STATE_CANCELLED
	ExecutionState_EXECUTION_STATE_FAILED               = src.ExecutionState_EXECUTION_STATE_FAILED
	ExecutionState_EXECUTION_STATE_NOT_STARTED          = src.ExecutionState_EXECUTION_STATE_NOT_STARTED
	ExecutionState_EXECUTION_STATE_RUNNING              = src.ExecutionState_EXECUTION_STATE_RUNNING
	ExecutionState_EXECUTION_STATE_SUCCEEDED            = src.ExecutionState_EXECUTION_STATE_SUCCEEDED
	ExecutionState_EXECUTION_STATE_UNKNOWN              = src.ExecutionState_EXECUTION_STATE_UNKNOWN
	FlexResourceSchedulingGoal_FLEXRS_COST_OPTIMIZED    = src.FlexResourceSchedulingGoal_FLEXRS_COST_OPTIMIZED
	FlexResourceSchedulingGoal_FLEXRS_SPEED_OPTIMIZED   = src.FlexResourceSchedulingGoal_FLEXRS_SPEED_OPTIMIZED
	FlexResourceSchedulingGoal_FLEXRS_UNSPECIFIED       = src.FlexResourceSchedulingGoal_FLEXRS_UNSPECIFIED
	GetTemplateRequest_METADATA_ONLY                    = src.GetTemplateRequest_METADATA_ONLY
	GetTemplateResponse_FLEX                            = src.GetTemplateResponse_FLEX
	GetTemplateResponse_LEGACY                          = src.GetTemplateResponse_LEGACY
	GetTemplateResponse_UNKNOWN                         = src.GetTemplateResponse_UNKNOWN
	JobMessageImportance_JOB_MESSAGE_BASIC              = src.JobMessageImportance_JOB_MESSAGE_BASIC
	JobMessageImportance_JOB_MESSAGE_DEBUG              = src.JobMessageImportance_JOB_MESSAGE_DEBUG
	JobMessageImportance_JOB_MESSAGE_DETAILED           = src.JobMessageImportance_JOB_MESSAGE_DETAILED
	JobMessageImportance_JOB_MESSAGE_ERROR              = src.JobMessageImportance_JOB_MESSAGE_ERROR
	JobMessageImportance_JOB_MESSAGE_IMPORTANCE_UNKNOWN = src.JobMessageImportance_JOB_MESSAGE_IMPORTANCE_UNKNOWN
	JobMessageImportance_JOB_MESSAGE_WARNING            = src.JobMessageImportance_JOB_MESSAGE_WARNING
	JobState_JOB_STATE_CANCELLED                        = src.JobState_JOB_STATE_CANCELLED
	JobState_JOB_STATE_CANCELLING                       = src.JobState_JOB_STATE_CANCELLING
	JobState_JOB_STATE_DONE                             = src.JobState_JOB_STATE_DONE
	JobState_JOB_STATE_DRAINED                          = src.JobState_JOB_STATE_DRAINED
	JobState_JOB_STATE_DRAINING                         = src.JobState_JOB_STATE_DRAINING
	JobState_JOB_STATE_FAILED                           = src.JobState_JOB_STATE_FAILED
	JobState_JOB_STATE_PENDING                          = src.JobState_JOB_STATE_PENDING
	JobState_JOB_STATE_QUEUED                           = src.JobState_JOB_STATE_QUEUED
	JobState_JOB_STATE_RESOURCE_CLEANING_UP             = src.JobState_JOB_STATE_RESOURCE_CLEANING_UP
	JobState_JOB_STATE_RUNNING                          = src.JobState_JOB_STATE_RUNNING
	JobState_JOB_STATE_STOPPED                          = src.JobState_JOB_STATE_STOPPED
	JobState_JOB_STATE_UNKNOWN                          = src.JobState_JOB_STATE_UNKNOWN
	JobState_JOB_STATE_UPDATED                          = src.JobState_JOB_STATE_UPDATED
	JobType_JOB_TYPE_BATCH                              = src.JobType_JOB_TYPE_BATCH
	JobType_JOB_TYPE_STREAMING                          = src.JobType_JOB_TYPE_STREAMING
	JobType_JOB_TYPE_UNKNOWN                            = src.JobType_JOB_TYPE_UNKNOWN
	JobView_JOB_VIEW_ALL                                = src.JobView_JOB_VIEW_ALL
	JobView_JOB_VIEW_DESCRIPTION                        = src.JobView_JOB_VIEW_DESCRIPTION
	JobView_JOB_VIEW_SUMMARY                            = src.JobView_JOB_VIEW_SUMMARY
	JobView_JOB_VIEW_UNKNOWN                            = src.JobView_JOB_VIEW_UNKNOWN
	KindType_CONSTANT_KIND                              = src.KindType_CONSTANT_KIND
	KindType_FLATTEN_KIND                               = src.KindType_FLATTEN_KIND
	KindType_GROUP_BY_KEY_KIND                          = src.KindType_GROUP_BY_KEY_KIND
	KindType_PAR_DO_KIND                                = src.KindType_PAR_DO_KIND
	KindType_READ_KIND                                  = src.KindType_READ_KIND
	KindType_SHUFFLE_KIND                               = src.KindType_SHUFFLE_KIND
	KindType_SINGLETON_KIND                             = src.KindType_SINGLETON_KIND
	KindType_UNKNOWN_KIND                               = src.KindType_UNKNOWN_KIND
	KindType_WRITE_KIND                                 = src.KindType_WRITE_KIND
	ListJobsRequest_ACTIVE                              = src.ListJobsRequest_ACTIVE
	ListJobsRequest_ALL                                 = src.ListJobsRequest_ALL
	ListJobsRequest_TERMINATED                          = src.ListJobsRequest_TERMINATED
	ListJobsRequest_UNKNOWN                             = src.ListJobsRequest_UNKNOWN
	ParameterType_DEFAULT                               = src.ParameterType_DEFAULT
	ParameterType_GCS_READ_BUCKET                       = src.ParameterType_GCS_READ_BUCKET
	ParameterType_GCS_READ_FILE                         = src.ParameterType_GCS_READ_FILE
	ParameterType_GCS_READ_FOLDER                       = src.ParameterType_GCS_READ_FOLDER
	ParameterType_GCS_WRITE_BUCKET                      = src.ParameterType_GCS_WRITE_BUCKET
	ParameterType_GCS_WRITE_FILE                        = src.ParameterType_GCS_WRITE_FILE
	ParameterType_GCS_WRITE_FOLDER                      = src.ParameterType_GCS_WRITE_FOLDER
	ParameterType_PUBSUB_SUBSCRIPTION                   = src.ParameterType_PUBSUB_SUBSCRIPTION
	ParameterType_PUBSUB_TOPIC                          = src.ParameterType_PUBSUB_TOPIC
	ParameterType_TEXT                                  = src.ParameterType_TEXT
	SDKInfo_JAVA                                        = src.SDKInfo_JAVA
	SDKInfo_PYTHON                                      = src.SDKInfo_PYTHON
	SDKInfo_UNKNOWN                                     = src.SDKInfo_UNKNOWN
	SdkVersion_DEPRECATED                               = src.SdkVersion_DEPRECATED
	SdkVersion_STALE                                    = src.SdkVersion_STALE
	SdkVersion_SUPPORTED                                = src.SdkVersion_SUPPORTED
	SdkVersion_UNKNOWN                                  = src.SdkVersion_UNKNOWN
	SdkVersion_UNSUPPORTED                              = src.SdkVersion_UNSUPPORTED
	ShuffleMode_SERVICE_BASED                           = src.ShuffleMode_SERVICE_BASED
	ShuffleMode_SHUFFLE_MODE_UNSPECIFIED                = src.ShuffleMode_SHUFFLE_MODE_UNSPECIFIED
	ShuffleMode_VM_BASED                                = src.ShuffleMode_VM_BASED
	SnapshotState_DELETED                               = src.SnapshotState_DELETED
	SnapshotState_FAILED                                = src.SnapshotState_FAILED
	SnapshotState_PENDING                               = src.SnapshotState_PENDING
	SnapshotState_READY                                 = src.SnapshotState_READY
	SnapshotState_RUNNING                               = src.SnapshotState_RUNNING
	SnapshotState_UNKNOWN_SNAPSHOT_STATE                = src.SnapshotState_UNKNOWN_SNAPSHOT_STATE
	TeardownPolicy_TEARDOWN_ALWAYS                      = src.TeardownPolicy_TEARDOWN_ALWAYS
	TeardownPolicy_TEARDOWN_NEVER                       = src.TeardownPolicy_TEARDOWN_NEVER
	TeardownPolicy_TEARDOWN_ON_SUCCESS                  = src.TeardownPolicy_TEARDOWN_ON_SUCCESS
	TeardownPolicy_TEARDOWN_POLICY_UNKNOWN              = src.TeardownPolicy_TEARDOWN_POLICY_UNKNOWN
	WorkerIPAddressConfiguration_WORKER_IP_PRIVATE      = src.WorkerIPAddressConfiguration_WORKER_IP_PRIVATE
	WorkerIPAddressConfiguration_WORKER_IP_PUBLIC       = src.WorkerIPAddressConfiguration_WORKER_IP_PUBLIC
	WorkerIPAddressConfiguration_WORKER_IP_UNSPECIFIED  = src.WorkerIPAddressConfiguration_WORKER_IP_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
var (
	AutoscalingAlgorithm_name                      = src.AutoscalingAlgorithm_name
	AutoscalingAlgorithm_value                     = src.AutoscalingAlgorithm_value
	AutoscalingEvent_AutoscalingEventType_name     = src.AutoscalingEvent_AutoscalingEventType_name
	AutoscalingEvent_AutoscalingEventType_value    = src.AutoscalingEvent_AutoscalingEventType_value
	DefaultPackageSet_name                         = src.DefaultPackageSet_name
	DefaultPackageSet_value                        = src.DefaultPackageSet_value
	ExecutionState_name                            = src.ExecutionState_name
	ExecutionState_value                           = src.ExecutionState_value
	File_google_dataflow_v1beta3_environment_proto = src.File_google_dataflow_v1beta3_environment_proto
	File_google_dataflow_v1beta3_jobs_proto        = src.File_google_dataflow_v1beta3_jobs_proto
	File_google_dataflow_v1beta3_messages_proto    = src.File_google_dataflow_v1beta3_messages_proto
	File_google_dataflow_v1beta3_metrics_proto     = src.File_google_dataflow_v1beta3_metrics_proto
	File_google_dataflow_v1beta3_snapshots_proto   = src.File_google_dataflow_v1beta3_snapshots_proto
	File_google_dataflow_v1beta3_streaming_proto   = src.File_google_dataflow_v1beta3_streaming_proto
	File_google_dataflow_v1beta3_templates_proto   = src.File_google_dataflow_v1beta3_templates_proto
	FlexResourceSchedulingGoal_name                = src.FlexResourceSchedulingGoal_name
	FlexResourceSchedulingGoal_value               = src.FlexResourceSchedulingGoal_value
	GetTemplateRequest_TemplateView_name           = src.GetTemplateRequest_TemplateView_name
	GetTemplateRequest_TemplateView_value          = src.GetTemplateRequest_TemplateView_value
	GetTemplateResponse_TemplateType_name          = src.GetTemplateResponse_TemplateType_name
	GetTemplateResponse_TemplateType_value         = src.GetTemplateResponse_TemplateType_value
	JobMessageImportance_name                      = src.JobMessageImportance_name
	JobMessageImportance_value                     = src.JobMessageImportance_value
	JobState_name                                  = src.JobState_name
	JobState_value                                 = src.JobState_value
	JobType_name                                   = src.JobType_name
	JobType_value                                  = src.JobType_value
	JobView_name                                   = src.JobView_name
	JobView_value                                  = src.JobView_value
	KindType_name                                  = src.KindType_name
	KindType_value                                 = src.KindType_value
	ListJobsRequest_Filter_name                    = src.ListJobsRequest_Filter_name
	ListJobsRequest_Filter_value                   = src.ListJobsRequest_Filter_value
	ParameterType_name                             = src.ParameterType_name
	ParameterType_value                            = src.ParameterType_value
	SDKInfo_Language_name                          = src.SDKInfo_Language_name
	SDKInfo_Language_value                         = src.SDKInfo_Language_value
	SdkVersion_SdkSupportStatus_name               = src.SdkVersion_SdkSupportStatus_name
	SdkVersion_SdkSupportStatus_value              = src.SdkVersion_SdkSupportStatus_value
	ShuffleMode_name                               = src.ShuffleMode_name
	ShuffleMode_value                              = src.ShuffleMode_value
	SnapshotState_name                             = src.SnapshotState_name
	SnapshotState_value                            = src.SnapshotState_value
	TeardownPolicy_name                            = src.TeardownPolicy_name
	TeardownPolicy_value                           = src.TeardownPolicy_value
	WorkerIPAddressConfiguration_name              = src.WorkerIPAddressConfiguration_name
	WorkerIPAddressConfiguration_value             = src.WorkerIPAddressConfiguration_value
)

// Specifies the algorithm used to determine the number of worker processes to
// run at any given point in time, based on the amount of data left to process,
// the number of workers, and how quickly existing workers are processing data.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type AutoscalingAlgorithm = src.AutoscalingAlgorithm

// A structured message reporting an autoscaling decision made by the Dataflow
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type AutoscalingEvent = src.AutoscalingEvent

// Indicates the type of autoscaling event.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type AutoscalingEvent_AutoscalingEventType = src.AutoscalingEvent_AutoscalingEventType

// Settings for WorkerPool autoscaling.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type AutoscalingSettings = src.AutoscalingSettings

// Metadata for a BigQuery connector used by the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type BigQueryIODetails = src.BigQueryIODetails

// Metadata for a Cloud Bigtable connector used by the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type BigTableIODetails = src.BigTableIODetails

// Request to check is active jobs exists for a project
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type CheckActiveJobsRequest = src.CheckActiveJobsRequest

// Response for CheckActiveJobsRequest.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type CheckActiveJobsResponse = src.CheckActiveJobsResponse

// All configuration data for a particular Computation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ComputationTopology = src.ComputationTopology

// Container Spec.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ContainerSpec = src.ContainerSpec

// A request to create a Cloud Dataflow job from a template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type CreateJobFromTemplateRequest = src.CreateJobFromTemplateRequest
type CreateJobFromTemplateRequest_GcsPath = src.CreateJobFromTemplateRequest_GcsPath

// Request to create a Cloud Dataflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type CreateJobRequest = src.CreateJobRequest

// Identifies the location of a custom souce.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type CustomSourceLocation = src.CustomSourceLocation

// Data disk assignment for a given VM instance.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DataDiskAssignment = src.DataDiskAssignment

// Metadata for a Datastore connector used by the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DatastoreIODetails = src.DatastoreIODetails

// Describes any options that have an effect on the debugging of pipelines.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DebugOptions = src.DebugOptions

// The default set of packages to be staged on a pool of workers.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DefaultPackageSet = src.DefaultPackageSet

// Request to delete a snapshot.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DeleteSnapshotRequest = src.DeleteSnapshotRequest

// Response from deleting a snapshot.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DeleteSnapshotResponse = src.DeleteSnapshotResponse

// Describes the data disk used by a workflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type Disk = src.Disk

// Data provided with a pipeline or transform to provide descriptive info.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DisplayData = src.DisplayData
type DisplayData_BoolValue = src.DisplayData_BoolValue
type DisplayData_DurationValue = src.DisplayData_DurationValue
type DisplayData_FloatValue = src.DisplayData_FloatValue
type DisplayData_Int64Value = src.DisplayData_Int64Value
type DisplayData_JavaClassValue = src.DisplayData_JavaClassValue
type DisplayData_StrValue = src.DisplayData_StrValue
type DisplayData_TimestampValue = src.DisplayData_TimestampValue

// Params which should be passed when launching a dynamic template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type DynamicTemplateLaunchParams = src.DynamicTemplateLaunchParams

// Describes the environment in which a Dataflow Job runs.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type Environment = src.Environment

// A message describing the state of a particular execution stage.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ExecutionStageState = src.ExecutionStageState

// Description of the composing transforms, names/ids, and input/outputs of a
// stage of execution. Some composing transforms and sources may have been
// generated by the Dataflow service during execution planning.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ExecutionStageSummary = src.ExecutionStageSummary

// Description of an interstitial value between transforms in an execution
// stage.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ExecutionStageSummary_ComponentSource = src.ExecutionStageSummary_ComponentSource

// Description of a transform executed as part of an execution stage.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ExecutionStageSummary_ComponentTransform = src.ExecutionStageSummary_ComponentTransform

// Description of an input or output of an execution stage.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ExecutionStageSummary_StageSource = src.ExecutionStageSummary_StageSource

// The state of some component of job execution.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ExecutionState = src.ExecutionState

// Indicates which [regional endpoint]
// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) failed
// to respond to a request for data.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type FailedLocation = src.FailedLocation

// Metadata for a File connector used by the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type FileIODetails = src.FileIODetails

// Specifies the resource to optimize for in Flexible Resource Scheduling.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type FlexResourceSchedulingGoal = src.FlexResourceSchedulingGoal

// The environment values to be set at runtime for flex template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type FlexTemplateRuntimeEnvironment = src.FlexTemplateRuntimeEnvironment

// FlexTemplatesServiceClient is the client API for FlexTemplatesService
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type FlexTemplatesServiceClient = src.FlexTemplatesServiceClient

// FlexTemplatesServiceServer is the server API for FlexTemplatesService
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type FlexTemplatesServiceServer = src.FlexTemplatesServiceServer

// Request to get job execution details.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetJobExecutionDetailsRequest = src.GetJobExecutionDetailsRequest

// Request to get job metrics.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetJobMetricsRequest = src.GetJobMetricsRequest

// Request to get the state of a Cloud Dataflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetJobRequest = src.GetJobRequest

// Request to get information about a snapshot
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetSnapshotRequest = src.GetSnapshotRequest

// Request to get information about a particular execution stage of a job.
// Currently only tracked for Batch jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetStageExecutionDetailsRequest = src.GetStageExecutionDetailsRequest

// A request to retrieve a Cloud Dataflow job template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetTemplateRequest = src.GetTemplateRequest
type GetTemplateRequest_GcsPath = src.GetTemplateRequest_GcsPath

// The various views of a template that may be retrieved.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetTemplateRequest_TemplateView = src.GetTemplateRequest_TemplateView

// The response to a GetTemplate request.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetTemplateResponse = src.GetTemplateResponse

// Template Type.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type GetTemplateResponse_TemplateType = src.GetTemplateResponse_TemplateType

// Used in the error_details field of a google.rpc.Status message, this
// indicates problems with the template parameter.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type InvalidTemplateParameters = src.InvalidTemplateParameters

// A specific template-parameter violation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type InvalidTemplateParameters_ParameterViolation = src.InvalidTemplateParameters_ParameterViolation

// Defines a job to be run by the Cloud Dataflow service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type Job = src.Job

// Information about the execution of a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobExecutionDetails = src.JobExecutionDetails

// Additional information about how a Cloud Dataflow job will be executed that
// isn't contained in the submitted job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobExecutionInfo = src.JobExecutionInfo

// Contains information about how a particular
// [google.dataflow.v1beta3.Step][google.dataflow.v1beta3.Step] will be
// executed.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobExecutionStageInfo = src.JobExecutionStageInfo

// A particular message pertaining to a Dataflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobMessage = src.JobMessage

// Indicates the importance of the message.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobMessageImportance = src.JobMessageImportance

// Metadata available primarily for filtering jobs. Will be included in the
// ListJob response and Job SUMMARY view.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobMetadata = src.JobMetadata

// JobMetrics contains a collection of metrics describing the detailed
// progress of a Dataflow job. Metrics correspond to user-defined and
// system-defined metrics in the job. This resource captures only the most
// recent values of each metric; time-series data can be queried for them
// (under the same metric names) from Cloud Monitoring.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobMetrics = src.JobMetrics

// Describes the overall state of a
// [google.dataflow.v1beta3.Job][google.dataflow.v1beta3.Job].
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobState = src.JobState

// Specifies the processing model used by a [google.dataflow.v1beta3.Job],
// which determines the way the Job is managed by the Cloud Dataflow service
// (how workers are scheduled, how inputs are sharded, etc).
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobType = src.JobType

// Selector for how much information is returned in Job responses.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobView = src.JobView

// JobsV1Beta3Client is the client API for JobsV1Beta3 service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobsV1Beta3Client = src.JobsV1Beta3Client

// JobsV1Beta3Server is the server API for JobsV1Beta3 service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type JobsV1Beta3Server = src.JobsV1Beta3Server

// Data disk assignment information for a specific key-range of a sharded
// computation. Currently we only support UTF-8 character splits to simplify
// encoding into JSON.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type KeyRangeDataDiskAssignment = src.KeyRangeDataDiskAssignment

// Location information for a specific key-range of a sharded computation.
// Currently we only support UTF-8 character splits to simplify encoding into
// JSON.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type KeyRangeLocation = src.KeyRangeLocation

// Type of transform or stage operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type KindType = src.KindType

// Launch FlexTemplate Parameter.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type LaunchFlexTemplateParameter = src.LaunchFlexTemplateParameter
type LaunchFlexTemplateParameter_ContainerSpec = src.LaunchFlexTemplateParameter_ContainerSpec
type LaunchFlexTemplateParameter_ContainerSpecGcsPath = src.LaunchFlexTemplateParameter_ContainerSpecGcsPath

// A request to launch a Cloud Dataflow job from a FlexTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type LaunchFlexTemplateRequest = src.LaunchFlexTemplateRequest

// Response to the request to launch a job from Flex Template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type LaunchFlexTemplateResponse = src.LaunchFlexTemplateResponse

// Parameters to provide to the template being launched.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type LaunchTemplateParameters = src.LaunchTemplateParameters

// A request to launch a template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type LaunchTemplateRequest = src.LaunchTemplateRequest
type LaunchTemplateRequest_DynamicTemplate = src.LaunchTemplateRequest_DynamicTemplate
type LaunchTemplateRequest_GcsPath = src.LaunchTemplateRequest_GcsPath

// Response to the request to launch a template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type LaunchTemplateResponse = src.LaunchTemplateResponse

// Request to list job messages. Up to max_results messages will be returned
// in the time range specified starting with the oldest messages first. If no
// time range is specified the results with start with the oldest message.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListJobMessagesRequest = src.ListJobMessagesRequest

// Response to a request to list job messages.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListJobMessagesResponse = src.ListJobMessagesResponse

// Request to list Cloud Dataflow jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListJobsRequest = src.ListJobsRequest

// This field filters out and returns jobs in the specified job state. The
// order of data returned is determined by the filter used, and is subject to
// change.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListJobsRequest_Filter = src.ListJobsRequest_Filter

// Response to a request to list Cloud Dataflow jobs in a project. This might
// be a partial response, depending on the page size in the ListJobsRequest.
// However, if the project does not have any jobs, an instance of
// ListJobsResponse is not returned and the requests's response body is empty
// {}.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListJobsResponse = src.ListJobsResponse

// Request to list snapshots.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListSnapshotsRequest = src.ListSnapshotsRequest

// List of snapshots.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ListSnapshotsResponse = src.ListSnapshotsResponse

// MessagesV1Beta3Client is the client API for MessagesV1Beta3 service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MessagesV1Beta3Client = src.MessagesV1Beta3Client

// MessagesV1Beta3Server is the server API for MessagesV1Beta3 service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MessagesV1Beta3Server = src.MessagesV1Beta3Server

// Identifies a metric, by describing the source which generated the metric.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MetricStructuredName = src.MetricStructuredName

// Describes the state of a metric.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MetricUpdate = src.MetricUpdate

// MetricsV1Beta3Client is the client API for MetricsV1Beta3 service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MetricsV1Beta3Client = src.MetricsV1Beta3Client

// MetricsV1Beta3Server is the server API for MetricsV1Beta3 service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MetricsV1Beta3Server = src.MetricsV1Beta3Server

// Describes mounted data disk.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type MountedDataDisk = src.MountedDataDisk

// The packages that must be installed in order for a worker to run the steps
// of the Cloud Dataflow job that will be assigned to its worker pool. This is
// the mechanism by which the Cloud Dataflow SDK causes code to be loaded onto
// the workers. For example, the Cloud Dataflow Java SDK might use this to
// install jars containing the user's code and all of the various dependencies
// (libraries, data files, etc.) required in order for that code to run.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type Package = src.Package

// Metadata for a specific parameter.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ParameterMetadata = src.ParameterMetadata

// ParameterType specifies what kind of input we need for this parameter.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ParameterType = src.ParameterType

// A descriptive representation of submitted pipeline as well as the executed
// form. This data is provided by the Dataflow service for ease of visualizing
// the pipeline and interpreting Dataflow provided metrics.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type PipelineDescription = src.PipelineDescription

// Information about the progress of some component of job execution.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ProgressTimeseries = src.ProgressTimeseries

// A point in the timeseries.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ProgressTimeseries_Point = src.ProgressTimeseries_Point

// Metadata for a Pub/Sub connector used by the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type PubSubIODetails = src.PubSubIODetails

// Identifies a pubsub location to use for transferring data into or out of a
// streaming Dataflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type PubsubLocation = src.PubsubLocation

// Represents a Pubsub snapshot.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type PubsubSnapshotMetadata = src.PubsubSnapshotMetadata

// The environment values to set at runtime.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type RuntimeEnvironment = src.RuntimeEnvironment

// RuntimeMetadata describing a runtime environment.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type RuntimeMetadata = src.RuntimeMetadata

// SDK Information.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SDKInfo = src.SDKInfo

// SDK Language.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SDKInfo_Language = src.SDKInfo_Language

// Defines a SDK harness container for executing Dataflow pipelines.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SdkHarnessContainerImage = src.SdkHarnessContainerImage

// The version of the SDK used to run the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SdkVersion = src.SdkVersion

// The support status of the SDK used to run the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SdkVersion_SdkSupportStatus = src.SdkVersion_SdkSupportStatus

// Specifies the shuffle mode used by a [google.dataflow.v1beta3.Job], which
// determines the approach data is shuffled during processing. More details in:
// https://cloud.google.com/dataflow/docs/guides/deploying-a-pipeline#dataflow-shuffle
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type ShuffleMode = src.ShuffleMode

// Represents a snapshot of a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type Snapshot = src.Snapshot

// Request to create a snapshot of a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SnapshotJobRequest = src.SnapshotJobRequest

// Snapshot state.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SnapshotState = src.SnapshotState

// SnapshotsV1Beta3Client is the client API for SnapshotsV1Beta3 service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SnapshotsV1Beta3Client = src.SnapshotsV1Beta3Client

// SnapshotsV1Beta3Server is the server API for SnapshotsV1Beta3 service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SnapshotsV1Beta3Server = src.SnapshotsV1Beta3Server

// Metadata for a Spanner connector used by the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type SpannerIODetails = src.SpannerIODetails

// Information about the workers and work items within a stage.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StageExecutionDetails = src.StageExecutionDetails

// Information about a particular execution stage of a job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StageSummary = src.StageSummary

// State family configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StateFamilyConfig = src.StateFamilyConfig

// Defines a particular step within a Cloud Dataflow job. A job consists of
// multiple steps, each of which performs some specific operation as part of
// the overall job. Data is typically passed from one step to another as part
// of the job. Here's an example of a sequence of steps which together
// implement a Map-Reduce job: - Read a collection of data from some source,
// parsing the collection's elements. - Validate the elements. - Apply a
// user-defined function to map each element to some value and extract an
// element-specific key value. - Group elements with the same key into a single
// element with that key, transforming a multiply-keyed collection into a
// uniquely-keyed collection. - Write the elements out to some data sink. Note
// that the Cloud Dataflow service may be used to run many different types of
// jobs, not just Map-Reduce.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type Step = src.Step

// Describes a stream of data, either as input to be processed or as output of
// a streaming Dataflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StreamLocation = src.StreamLocation
type StreamLocation_CustomSourceLocation = src.StreamLocation_CustomSourceLocation
type StreamLocation_PubsubLocation = src.StreamLocation_PubsubLocation
type StreamLocation_SideInputLocation = src.StreamLocation_SideInputLocation
type StreamLocation_StreamingStageLocation = src.StreamLocation_StreamingStageLocation

// Streaming appliance snapshot configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StreamingApplianceSnapshotConfig = src.StreamingApplianceSnapshotConfig

// Describes full or partial data disk assignment information of the
// computation ranges.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StreamingComputationRanges = src.StreamingComputationRanges

// Identifies the location of a streaming side input.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StreamingSideInputLocation = src.StreamingSideInputLocation

// Identifies the location of a streaming computation stage, for
// stage-to-stage communication.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StreamingStageLocation = src.StreamingStageLocation

// A rich message format, including a human readable string, a key for
// identifying the message, and structured data associated with the message for
// programmatic consumption.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StructuredMessage = src.StructuredMessage

// Structured data associated with this message.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type StructuredMessage_Parameter = src.StructuredMessage_Parameter

// Taskrunner configuration settings.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TaskRunnerSettings = src.TaskRunnerSettings

// Specifies what happens to a resource when a Cloud Dataflow
// [google.dataflow.v1beta3.Job][google.dataflow.v1beta3.Job] has completed.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TeardownPolicy = src.TeardownPolicy

// Metadata describing a template.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TemplateMetadata = src.TemplateMetadata

// TemplatesServiceClient is the client API for TemplatesService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TemplatesServiceClient = src.TemplatesServiceClient

// TemplatesServiceServer is the server API for TemplatesService service.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TemplatesServiceServer = src.TemplatesServiceServer

// Global topology of the streaming Dataflow job, including all computations
// and their sharded locations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TopologyConfig = src.TopologyConfig

// Description of the type, names/ids, and input/outputs for a transform.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type TransformSummary = src.TransformSummary

// UnimplementedFlexTemplatesServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UnimplementedFlexTemplatesServiceServer = src.UnimplementedFlexTemplatesServiceServer

// UnimplementedJobsV1Beta3Server can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UnimplementedJobsV1Beta3Server = src.UnimplementedJobsV1Beta3Server

// UnimplementedMessagesV1Beta3Server can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UnimplementedMessagesV1Beta3Server = src.UnimplementedMessagesV1Beta3Server

// UnimplementedMetricsV1Beta3Server can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UnimplementedMetricsV1Beta3Server = src.UnimplementedMetricsV1Beta3Server

// UnimplementedSnapshotsV1Beta3Server can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UnimplementedSnapshotsV1Beta3Server = src.UnimplementedSnapshotsV1Beta3Server

// UnimplementedTemplatesServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UnimplementedTemplatesServiceServer = src.UnimplementedTemplatesServiceServer

// Request to update a Cloud Dataflow job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type UpdateJobRequest = src.UpdateJobRequest

// Information about an individual work item execution.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type WorkItemDetails = src.WorkItemDetails

// Information about a worker
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type WorkerDetails = src.WorkerDetails

// Specifies how IP addresses should be allocated to the worker machines.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type WorkerIPAddressConfiguration = src.WorkerIPAddressConfiguration

// Describes one particular pool of Cloud Dataflow workers to be instantiated
// by the Cloud Dataflow service in order to perform the computations required
// by a job. Note that a workflow job may use multiple pools, in order to match
// the various computational requirements of the various stages of the job.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type WorkerPool = src.WorkerPool

// Provides data to pass through to the worker harness.
//
// Deprecated: Please use types in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
type WorkerSettings = src.WorkerSettings

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func NewFlexTemplatesServiceClient(cc grpc.ClientConnInterface) FlexTemplatesServiceClient {
	return src.NewFlexTemplatesServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func NewJobsV1Beta3Client(cc grpc.ClientConnInterface) JobsV1Beta3Client {
	return src.NewJobsV1Beta3Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func NewMessagesV1Beta3Client(cc grpc.ClientConnInterface) MessagesV1Beta3Client {
	return src.NewMessagesV1Beta3Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func NewMetricsV1Beta3Client(cc grpc.ClientConnInterface) MetricsV1Beta3Client {
	return src.NewMetricsV1Beta3Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func NewSnapshotsV1Beta3Client(cc grpc.ClientConnInterface) SnapshotsV1Beta3Client {
	return src.NewSnapshotsV1Beta3Client(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func NewTemplatesServiceClient(cc grpc.ClientConnInterface) TemplatesServiceClient {
	return src.NewTemplatesServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func RegisterFlexTemplatesServiceServer(s *grpc.Server, srv FlexTemplatesServiceServer) {
	src.RegisterFlexTemplatesServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func RegisterJobsV1Beta3Server(s *grpc.Server, srv JobsV1Beta3Server) {
	src.RegisterJobsV1Beta3Server(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func RegisterMessagesV1Beta3Server(s *grpc.Server, srv MessagesV1Beta3Server) {
	src.RegisterMessagesV1Beta3Server(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func RegisterMetricsV1Beta3Server(s *grpc.Server, srv MetricsV1Beta3Server) {
	src.RegisterMetricsV1Beta3Server(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func RegisterSnapshotsV1Beta3Server(s *grpc.Server, srv SnapshotsV1Beta3Server) {
	src.RegisterSnapshotsV1Beta3Server(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dataflow/apiv1beta3/dataflowpb
func RegisterTemplatesServiceServer(s *grpc.Server, srv TemplatesServiceServer) {
	src.RegisterTemplatesServiceServer(s, srv)
}
