// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package policytroubleshooter provides access to the Policy Troubleshooter API.
//
// For product documentation, see: https://cloud.google.com/iam/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/policytroubleshooter/v3beta"
//	...
//	ctx := context.Background()
//	policytroubleshooterService, err := policytroubleshooter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	policytroubleshooterService, err := policytroubleshooter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	policytroubleshooterService, err := policytroubleshooter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package policytroubleshooter // import "google.golang.org/api/policytroubleshooter/v3beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "policytroubleshooter:v3beta"
const apiName = "policytroubleshooter"
const apiVersion = "v3beta"
const basePath = "https://policytroubleshooter.googleapis.com/"
const basePathTemplate = "https://policytroubleshooter.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://policytroubleshooter.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Iam = NewIamService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Iam *IamService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewIamService(s *Service) *IamService {
	rs := &IamService{s: s}
	return rs
}

type IamService struct {
	s *Service
}

// GoogleCloudPolicytroubleshooterIamV3betaAccessTuple: Information about the
// principal, resource, and permission to check.
type GoogleCloudPolicytroubleshooterIamV3betaAccessTuple struct {
	// ConditionContext: Optional. Additional context for the request, such as the
	// request time or IP address. This context allows Policy Troubleshooter to
	// troubleshoot conditional role bindings and deny rules.
	ConditionContext *GoogleCloudPolicytroubleshooterIamV3betaConditionContext `json:"conditionContext,omitempty"`
	// FullResourceName: Required. The full resource name that identifies the
	// resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/m
	// y-instance`. For examples of full resource names for Google Cloud services,
	// see https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// Permission: Required. The IAM permission to check for, either in the `v1`
	// permission format or the `v2` permission format. For a complete list of IAM
	// permissions in the `v1` format, see
	// https://cloud.google.com/iam/help/permissions/reference. For a list of IAM
	// permissions in the `v2` format, see
	// https://cloud.google.com/iam/help/deny/supported-permissions. For a complete
	// list of predefined IAM roles and the permissions in each role, see
	// https://cloud.google.com/iam/help/roles/reference.
	Permission string `json:"permission,omitempty"`
	// PermissionFqdn: Output only. The permission that Policy Troubleshooter
	// checked for, in the `v2` format.
	PermissionFqdn string `json:"permissionFqdn,omitempty"`
	// Principal: Required. The email address of the principal whose access you
	// want to check. For example, `alice@example.com` or
	// `my-service-account@my-project.iam.gserviceaccount.com`. The principal must
	// be a Google Account or a service account. Other types of principals are not
	// supported.
	Principal string `json:"principal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionContext") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaAccessTuple) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaAccessTuple
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanation: Details
// about how a role binding in an allow policy affects a principal's ability to
// use a permission.
type GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanation struct {
	// AllowAccessState: Required. Indicates whether _this role binding_ gives the
	// specified permission to the specified principal on the specified resource.
	// This field does _not_ indicate whether the principal actually has the
	// permission on the resource. There might be another role binding that
	// overrides this role binding. To determine whether the principal actually has
	// the permission, use the `overall_access_state` field in the
	// TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "ALLOW_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "ALLOW_ACCESS_STATE_GRANTED" - The allow policy gives the principal the
	// permission.
	//   "ALLOW_ACCESS_STATE_NOT_GRANTED" - The allow policy doesn't give the
	// principal the permission.
	//   "ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The allow policy gives the
	// principal the permission if a condition expression evaluate to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "ALLOW_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request doesn't have
	// access to all of the allow policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	AllowAccessState string `json:"allowAccessState,omitempty"`
	// CombinedMembership: The combined result of all memberships. Indicates if the
	// principal is included in any role binding, either directly or indirectly.
	CombinedMembership *GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanationAnnotatedAllowMembership `json:"combinedMembership,omitempty"`
	// Condition: A condition expression that specifies when the role binding
	// grants access. To learn about IAM Conditions, see
	// https://cloud.google.com/iam/help/conditions/overview.
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// ConditionExplanation: Condition evaluation state for this role binding.
	ConditionExplanation *GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation `json:"conditionExplanation,omitempty"`
	// Memberships: Indicates whether each role binding includes the principal
	// specified in the request, either directly or indirectly. Each key identifies
	// a principal in the role binding, and each value indicates whether the
	// principal in the role binding includes the principal in the request. For
	// example, suppose that a role binding includes the following principals: *
	// `user:alice@example.com` * `group:product-eng@example.com` You want to
	// troubleshoot access for `user:bob@example.com`. This user is a member of the
	// group `group:product-eng@example.com`. For the first principal in the role
	// binding, the key is `user:alice@example.com`, and the `membership` field in
	// the value is set to `NOT_INCLUDED`. For the second principal in the role
	// binding, the key is `group:product-eng@example.com`, and the `membership`
	// field in the value is set to `INCLUDED`.
	Memberships map[string]GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanationAnnotatedAllowMembership `json:"memberships,omitempty"`
	// Relevance: The relevance of this role binding to the overall determination
	// for the entire policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// Role: The role that this role binding grants. For example,
	// `roles/compute.admin`. For a complete list of predefined IAM roles, as well
	// as the permissions in each role, see
	// https://cloud.google.com/iam/help/roles/reference.
	Role string `json:"role,omitempty"`
	// RolePermission: Indicates whether the role granted by this role binding
	// contains the specified permission.
	//
	// Possible values:
	//   "ROLE_PERMISSION_INCLUSION_STATE_UNSPECIFIED" - Not specified.
	//   "ROLE_PERMISSION_INCLUDED" - The permission is included in the role.
	//   "ROLE_PERMISSION_NOT_INCLUDED" - The permission is not included in the
	// role.
	//   "ROLE_PERMISSION_UNKNOWN_INFO" - The sender of the request is not allowed
	// to access the role definition.
	RolePermission string `json:"rolePermission,omitempty"`
	// RolePermissionRelevance: The relevance of the permission's existence, or
	// nonexistence, in the role to the overall determination for the entire
	// policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	RolePermissionRelevance string `json:"rolePermissionRelevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAccessState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanationAnnotatedAllow
// Membership: Details about whether the role binding includes the principal.
type GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanationAnnotatedAllowMembership struct {
	// Membership: Indicates whether the role binding includes the principal.
	//
	// Possible values:
	//   "MEMBERSHIP_MATCHING_STATE_UNSPECIFIED" - Not specified.
	//   "MEMBERSHIP_MATCHED" - The principal in the request matches the principal
	// in the policy. The principal can be included directly or indirectly: * A
	// principal is included directly if that principal is listed in the role
	// binding. * A principal is included indirectly if that principal is in a
	// Google group, Google Workspace account, or Cloud Identity domain that is
	// listed in the policy.
	//   "MEMBERSHIP_NOT_MATCHED" - The principal in the request doesn't match the
	// principal in the policy.
	//   "MEMBERSHIP_UNKNOWN_INFO" - The principal in the policy is a group or
	// domain, and the sender of the request doesn't have permission to view
	// whether the principal in the request is a member of the group or domain.
	//   "MEMBERSHIP_UNKNOWN_UNSUPPORTED" - The principal is an unsupported type.
	Membership string `json:"membership,omitempty"`
	// Relevance: The relevance of the principal's status to the overall
	// determination for the role binding.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanationAnnotatedAllowMembership) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanationAnnotatedAllowMembership
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaAllowPolicyExplanation: Details
// about how the relevant IAM allow policies affect the final access state.
type GoogleCloudPolicytroubleshooterIamV3betaAllowPolicyExplanation struct {
	// AllowAccessState: Indicates whether the principal has the specified
	// permission for the specified resource, based on evaluating all applicable
	// IAM allow policies.
	//
	// Possible values:
	//   "ALLOW_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "ALLOW_ACCESS_STATE_GRANTED" - The allow policy gives the principal the
	// permission.
	//   "ALLOW_ACCESS_STATE_NOT_GRANTED" - The allow policy doesn't give the
	// principal the permission.
	//   "ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The allow policy gives the
	// principal the permission if a condition expression evaluate to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "ALLOW_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request doesn't have
	// access to all of the allow policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	AllowAccessState string `json:"allowAccessState,omitempty"`
	// ExplainedPolicies: List of IAM allow policies that were evaluated to check
	// the principal's permissions, with annotations to indicate how each policy
	// contributed to the final result. The list of policies includes the policy
	// for the resource itself, as well as allow policies that are inherited from
	// higher levels of the resource hierarchy, including the organization, the
	// folder, and the project. To learn more about the resource hierarchy, see
	// https://cloud.google.com/iam/help/resource-hierarchy.
	ExplainedPolicies []*GoogleCloudPolicytroubleshooterIamV3betaExplainedAllowPolicy `json:"explainedPolicies,omitempty"`
	// Relevance: The relevance of the allow policy type to the overall access
	// state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAccessState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaAllowPolicyExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaAllowPolicyExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionContext: Additional context
// for troubleshooting conditional role bindings and deny rules.
type GoogleCloudPolicytroubleshooterIamV3betaConditionContext struct {
	// Destination: The destination of a network activity, such as accepting a TCP
	// connection. In a multi-hop network activity, the destination represents the
	// receiver of the last hop.
	Destination *GoogleCloudPolicytroubleshooterIamV3betaConditionContextPeer `json:"destination,omitempty"`
	// EffectiveTags: Output only. The effective tags on the resource. The
	// effective tags are fetched during troubleshooting.
	EffectiveTags []*GoogleCloudPolicytroubleshooterIamV3betaConditionContextEffectiveTag `json:"effectiveTags,omitempty"`
	// Request: Represents a network request, such as an HTTP request.
	Request *GoogleCloudPolicytroubleshooterIamV3betaConditionContextRequest `json:"request,omitempty"`
	// Resource: Represents a target resource that is involved with a network
	// activity. If multiple resources are involved with an activity, this must be
	// the primary one.
	Resource *GoogleCloudPolicytroubleshooterIamV3betaConditionContextResource `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionContextEffectiveTag: A tag
// that applies to a resource during policy evaluation. Tags can be either
// directly bound to a resource or inherited from its ancestor. `EffectiveTag`
// contains the `name` and `namespaced_name` of the tag value and tag key, with
// additional fields of `inherited` to indicate the inheritance status of the
// effective tag.
type GoogleCloudPolicytroubleshooterIamV3betaConditionContextEffectiveTag struct {
	// Inherited: Output only. Indicates the inheritance status of a tag value
	// attached to the given resource. If the tag value is inherited from one of
	// the resource's ancestors, inherited will be true. If false, then the tag
	// value is directly attached to the resource, inherited will be false.
	Inherited bool `json:"inherited,omitempty"`
	// NamespacedTagKey: Output only. The namespaced name of the TagKey. Can be in
	// the form `{organization_id}/{tag_key_short_name}` or
	// `{project_id}/{tag_key_short_name}` or
	// `{project_number}/{tag_key_short_name}`.
	NamespacedTagKey string `json:"namespacedTagKey,omitempty"`
	// NamespacedTagValue: Output only. The namespaced name of the TagValue. Can be
	// in the form `{organization_id}/{tag_key_short_name}/{tag_value_short_name}`
	// or `{project_id}/{tag_key_short_name}/{tag_value_short_name}` or
	// `{project_number}/{tag_key_short_name}/{tag_value_short_name}`.
	NamespacedTagValue string `json:"namespacedTagValue,omitempty"`
	// TagKey: Output only. The name of the TagKey, in the format `tagKeys/{id}`,
	// such as `tagKeys/123`.
	TagKey string `json:"tagKey,omitempty"`
	// TagKeyParentName: The parent name of the tag key. Must be in the format
	// `organizations/{organization_id}` or `projects/{project_number}`
	TagKeyParentName string `json:"tagKeyParentName,omitempty"`
	// TagValue: Output only. Resource name for TagValue in the format
	// `tagValues/456`.
	TagValue string `json:"tagValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inherited") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inherited") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionContextEffectiveTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionContextEffectiveTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionContextPeer: This message
// defines attributes for a node that handles a network request. The node can
// be either a service or an application that sends, forwards, or receives the
// request. Service peers should fill in `principal` and `labels` as
// appropriate.
type GoogleCloudPolicytroubleshooterIamV3betaConditionContextPeer struct {
	// Ip: The IPv4 or IPv6 address of the peer.
	Ip string `json:"ip,omitempty"`
	// Port: The network port of the peer.
	Port int64 `json:"port,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Ip") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ip") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionContextPeer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionContextPeer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionContextRequest: This
// message defines attributes for an HTTP request. If the actual request is not
// an HTTP request, the runtime system should try to map the actual request to
// an equivalent HTTP request.
type GoogleCloudPolicytroubleshooterIamV3betaConditionContextRequest struct {
	// ReceiveTime: Optional. The timestamp when the destination service receives
	// the first byte of the request.
	ReceiveTime string `json:"receiveTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReceiveTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReceiveTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionContextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionContextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionContextResource: Core
// attributes for a resource. A resource is an addressable (named) entity
// provided by the destination service. For example, a Compute Engine instance.
type GoogleCloudPolicytroubleshooterIamV3betaConditionContextResource struct {
	// Name: The stable identifier (name) of a resource on the `service`. A
	// resource can be logically identified as
	// `//{resource.service}/{resource.name}`. Unlike the resource URI, the
	// resource name doesn't contain any protocol and version information. For a
	// list of full resource name formats, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names
	Name string `json:"name,omitempty"`
	// Service: The name of the service that this resource belongs to, such as
	// `compute.googleapis.com`. The service name might not match the DNS hostname
	// that actually serves the request. For a full list of resource service
	// values, see https://cloud.google.com/iam/help/conditions/resource-services
	Service string `json:"service,omitempty"`
	// Type: The type of the resource, in the format `{service}/{kind}`. For a full
	// list of resource type values, see
	// https://cloud.google.com/iam/help/conditions/resource-types
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionContextResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionContextResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation: Explanation
// for how a condition affects a principal's access
type GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation struct {
	// Errors: Any errors that prevented complete evaluation of the condition
	// expression.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// EvaluationStates: The value of each statement of the condition expression.
	// The value can be `true`, `false`, or `null`. The value is `null` if the
	// statement can't be evaluated.
	EvaluationStates []*GoogleCloudPolicytroubleshooterIamV3betaConditionExplanationEvaluationState `json:"evaluationStates,omitempty"`
	// Value: Value of the condition.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaConditionExplanationEvaluationState:
// Evaluated state of a condition expression.
type GoogleCloudPolicytroubleshooterIamV3betaConditionExplanationEvaluationState struct {
	// End: End position of an expression in the condition, by character, end
	// included, for example: the end position of the first part of `a==b || c==d`
	// would be 4.
	End int64 `json:"end,omitempty"`
	// Errors: Any errors that prevented complete evaluation of the condition
	// expression.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// Start: Start position of an expression in the condition, by character.
	Start int64 `json:"start,omitempty"`
	// Value: Value of this expression.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaConditionExplanationEvaluationState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaConditionExplanationEvaluationState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaDenyPolicyExplanation: Details about
// how the relevant IAM deny policies affect the final access state.
type GoogleCloudPolicytroubleshooterIamV3betaDenyPolicyExplanation struct {
	// DenyAccessState: Indicates whether the principal is denied the specified
	// permission for the specified resource, based on evaluating all applicable
	// IAM deny policies.
	//
	// Possible values:
	//   "DENY_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "DENY_ACCESS_STATE_DENIED" - The deny policy denies the principal the
	// permission.
	//   "DENY_ACCESS_STATE_NOT_DENIED" - The deny policy doesn't deny the
	// principal the permission.
	//   "DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The deny policy denies the
	// principal the permission if a condition expression evaluates to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "DENY_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to all of the deny policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	DenyAccessState string `json:"denyAccessState,omitempty"`
	// ExplainedResources: List of resources with IAM deny policies that were
	// evaluated to check the principal's denied permissions, with annotations to
	// indicate how each policy contributed to the final result. The list of
	// resources includes the policy for the resource itself, as well as policies
	// that are inherited from higher levels of the resource hierarchy, including
	// the organization, the folder, and the project. The order of the resources
	// starts from the resource and climbs up the resource hierarchy. To learn more
	// about the resource hierarchy, see
	// https://cloud.google.com/iam/help/resource-hierarchy.
	ExplainedResources []*GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyResource `json:"explainedResources,omitempty"`
	// PermissionDeniable: Indicates whether the permission to troubleshoot is
	// supported in deny policies.
	PermissionDeniable bool `json:"permissionDeniable,omitempty"`
	// Relevance: The relevance of the deny policy result to the overall access
	// state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenyAccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenyAccessState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaDenyPolicyExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaDenyPolicyExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanation: Details about
// how a deny rule in a deny policy affects a principal's ability to use a
// permission.
type GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanation struct {
	// CombinedDeniedPermission: Indicates whether the permission in the request is
	// listed as a denied permission in the deny rule.
	CombinedDeniedPermission *GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching `json:"combinedDeniedPermission,omitempty"`
	// CombinedDeniedPrincipal: Indicates whether the principal is listed as a
	// denied principal in the deny rule, either directly or through membership in
	// a principal set.
	CombinedDeniedPrincipal *GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching `json:"combinedDeniedPrincipal,omitempty"`
	// CombinedExceptionPermission: Indicates whether the permission in the request
	// is listed as an exception permission in the deny rule.
	CombinedExceptionPermission *GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching `json:"combinedExceptionPermission,omitempty"`
	// CombinedExceptionPrincipal: Indicates whether the principal is listed as an
	// exception principal in the deny rule, either directly or through membership
	// in a principal set.
	CombinedExceptionPrincipal *GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching `json:"combinedExceptionPrincipal,omitempty"`
	// Condition: A condition expression that specifies when the deny rule denies
	// the principal access. To learn about IAM Conditions, see
	// https://cloud.google.com/iam/help/conditions/overview.
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// ConditionExplanation: Condition evaluation state for this role binding.
	ConditionExplanation *GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation `json:"conditionExplanation,omitempty"`
	// DeniedPermissions: Lists all denied permissions in the deny rule and
	// indicates whether each permission matches the permission in the request.
	// Each key identifies a denied permission in the rule, and each value
	// indicates whether the denied permission matches the permission in the
	// request.
	DeniedPermissions map[string]GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching `json:"deniedPermissions,omitempty"`
	// DeniedPrincipals: Lists all denied principals in the deny rule and indicates
	// whether each principal matches the principal in the request, either directly
	// or through membership in a principal set. Each key identifies a denied
	// principal in the rule, and each value indicates whether the denied principal
	// matches the principal in the request.
	DeniedPrincipals map[string]GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching `json:"deniedPrincipals,omitempty"`
	// DenyAccessState: Required. Indicates whether _this rule_ denies the
	// specified permission to the specified principal for the specified resource.
	// This field does _not_ indicate whether the principal is actually denied on
	// the permission for the resource. There might be another rule that overrides
	// this rule. To determine whether the principal actually has the permission,
	// use the `overall_access_state` field in the TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "DENY_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "DENY_ACCESS_STATE_DENIED" - The deny policy denies the principal the
	// permission.
	//   "DENY_ACCESS_STATE_NOT_DENIED" - The deny policy doesn't deny the
	// principal the permission.
	//   "DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The deny policy denies the
	// principal the permission if a condition expression evaluates to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "DENY_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to all of the deny policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	DenyAccessState string `json:"denyAccessState,omitempty"`
	// ExceptionPermissions: Lists all exception permissions in the deny rule and
	// indicates whether each permission matches the permission in the request.
	// Each key identifies a exception permission in the rule, and each value
	// indicates whether the exception permission matches the permission in the
	// request.
	ExceptionPermissions map[string]GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching `json:"exceptionPermissions,omitempty"`
	// ExceptionPrincipals: Lists all exception principals in the deny rule and
	// indicates whether each principal matches the principal in the request,
	// either directly or through membership in a principal set. Each key
	// identifies a exception principal in the rule, and each value indicates
	// whether the exception principal matches the principal in the request.
	ExceptionPrincipals map[string]GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching `json:"exceptionPrincipals,omitempty"`
	// Relevance: The relevance of this role binding to the overall determination
	// for the entire policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CombinedDeniedPermission")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CombinedDeniedPermission") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrinc
// ipalMatching: Details about whether the principal in the request is listed
// as a denied principal in the deny rule, either directly or through
// membership in a principal set.
type GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching struct {
	// Membership: Indicates whether the principal is listed as a denied principal
	// in the deny rule, either directly or through membership in a principal set.
	//
	// Possible values:
	//   "MEMBERSHIP_MATCHING_STATE_UNSPECIFIED" - Not specified.
	//   "MEMBERSHIP_MATCHED" - The principal in the request matches the principal
	// in the policy. The principal can be included directly or indirectly: * A
	// principal is included directly if that principal is listed in the role
	// binding. * A principal is included indirectly if that principal is in a
	// Google group, Google Workspace account, or Cloud Identity domain that is
	// listed in the policy.
	//   "MEMBERSHIP_NOT_MATCHED" - The principal in the request doesn't match the
	// principal in the policy.
	//   "MEMBERSHIP_UNKNOWN_INFO" - The principal in the policy is a group or
	// domain, and the sender of the request doesn't have permission to view
	// whether the principal in the request is a member of the group or domain.
	//   "MEMBERSHIP_UNKNOWN_UNSUPPORTED" - The principal is an unsupported type.
	Membership string `json:"membership,omitempty"`
	// Relevance: The relevance of the principal's status to the overall
	// determination for the role binding.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedDenyPrincipalMatching
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissio
// nMatching: Details about whether the permission in the request is denied by
// the deny rule.
type GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching struct {
	// PermissionMatchingState: Indicates whether the permission in the request is
	// denied by the deny rule.
	//
	// Possible values:
	//   "PERMISSION_PATTERN_MATCHING_STATE_UNSPECIFIED" - Not specified.
	//   "PERMISSION_PATTERN_MATCHED" - The permission in the request matches the
	// permission in the policy.
	//   "PERMISSION_PATTERN_NOT_MATCHED" - The permission in the request matches
	// the permission in the policy.
	PermissionMatchingState string `json:"permissionMatchingState,omitempty"`
	// Relevance: The relevance of the permission status to the overall
	// determination for the rule.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PermissionMatchingState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PermissionMatchingState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanationAnnotatedPermissionMatching
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedAllowPolicy: Details about
// how a specific IAM allow policy contributed to the final access state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedAllowPolicy struct {
	// AllowAccessState: Required. Indicates whether _this policy_ provides the
	// specified permission to the specified principal for the specified resource.
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another policy that overrides
	// this policy. To determine whether the principal actually has the permission,
	// use the `overall_access_state` field in the TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "ALLOW_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "ALLOW_ACCESS_STATE_GRANTED" - The allow policy gives the principal the
	// permission.
	//   "ALLOW_ACCESS_STATE_NOT_GRANTED" - The allow policy doesn't give the
	// principal the permission.
	//   "ALLOW_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The allow policy gives the
	// principal the permission if a condition expression evaluate to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "ALLOW_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request doesn't have
	// access to all of the allow policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	AllowAccessState string `json:"allowAccessState,omitempty"`
	// BindingExplanations: Details about how each role binding in the policy
	// affects the principal's ability, or inability, to use the permission for the
	// resource. The order of the role bindings matches the role binding order in
	// the policy. If the sender of the request does not have access to the policy,
	// this field is omitted.
	BindingExplanations []*GoogleCloudPolicytroubleshooterIamV3betaAllowBindingExplanation `json:"bindingExplanations,omitempty"`
	// FullResourceName: The full resource name that identifies the resource. For
	// example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/m
	// y-instance`. If the sender of the request does not have access to the
	// policy, this field is omitted. For examples of full resource names for
	// Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// Policy: The IAM allow policy attached to the resource. If the sender of the
	// request does not have access to the policy, this field is empty.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// Relevance: The relevance of this policy to the overall access state in the
	// TroubleshootIamPolicyResponse. If the sender of the request does not have
	// access to the policy, this field is omitted.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAccessState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedAllowPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedAllowPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyPolicy: Details about
// how a specific IAM deny policy Policy contributed to the access check.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyPolicy struct {
	// DenyAccessState: Required. Indicates whether _this policy_ denies the
	// specified permission to the specified principal for the specified resource.
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another policy that overrides
	// this policy. To determine whether the principal actually has the permission,
	// use the `overall_access_state` field in the TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "DENY_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "DENY_ACCESS_STATE_DENIED" - The deny policy denies the principal the
	// permission.
	//   "DENY_ACCESS_STATE_NOT_DENIED" - The deny policy doesn't deny the
	// principal the permission.
	//   "DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The deny policy denies the
	// principal the permission if a condition expression evaluates to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "DENY_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to all of the deny policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	DenyAccessState string `json:"denyAccessState,omitempty"`
	// Policy: The IAM deny policy attached to the resource. If the sender of the
	// request does not have access to the policy, this field is omitted.
	Policy *GoogleIamV2Policy `json:"policy,omitempty"`
	// Relevance: The relevance of this policy to the overall access state in the
	// TroubleshootIamPolicyResponse. If the sender of the request does not have
	// access to the policy, this field is omitted.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// RuleExplanations: Details about how each rule in the policy affects the
	// principal's inability to use the permission for the resource. The order of
	// the deny rule matches the order of the rules in the deny policy. If the
	// sender of the request does not have access to the policy, this field is
	// omitted.
	RuleExplanations []*GoogleCloudPolicytroubleshooterIamV3betaDenyRuleExplanation `json:"ruleExplanations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenyAccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenyAccessState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyResource: Details about
// how a specific resource contributed to the deny policy evaluation.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyResource struct {
	// DenyAccessState: Required. Indicates whether any policies attached to _this
	// resource_ deny the specific permission to the specified principal for the
	// specified resource. This field does _not_ indicate whether the principal
	// actually has the permission for the resource. There might be another policy
	// that overrides this policy. To determine whether the principal actually has
	// the permission, use the `overall_access_state` field in the
	// TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "DENY_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "DENY_ACCESS_STATE_DENIED" - The deny policy denies the principal the
	// permission.
	//   "DENY_ACCESS_STATE_NOT_DENIED" - The deny policy doesn't deny the
	// principal the permission.
	//   "DENY_ACCESS_STATE_UNKNOWN_CONDITIONAL" - The deny policy denies the
	// principal the permission if a condition expression evaluates to `true`.
	// However, the sender of the request didn't provide enough context for Policy
	// Troubleshooter to evaluate the condition expression.
	//   "DENY_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to all of the deny policies that Policy Troubleshooter needs to
	// evaluate the principal's access.
	DenyAccessState string `json:"denyAccessState,omitempty"`
	// ExplainedPolicies: List of IAM deny policies that were evaluated to check
	// the principal's denied permissions, with annotations to indicate how each
	// policy contributed to the final result.
	ExplainedPolicies []*GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyPolicy `json:"explainedPolicies,omitempty"`
	// FullResourceName: The full resource name that identifies the resource. For
	// example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/m
	// y-instance`. If the sender of the request does not have access to the
	// policy, this field is omitted. For examples of full resource names for
	// Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// Relevance: The relevance of this policy to the overall access state in the
	// TroubleshootIamPolicyResponse. If the sender of the request does not have
	// access to the policy, this field is omitted.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenyAccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenyAccessState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedDenyResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedPABBindingAndPolicy:
// Details about how a principal access boundary binding and policy contributes
// to the principal access boundary explanation, with annotations to indicate
// how the binding and policy contribute to the overall access state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedPABBindingAndPolicy struct {
	// BindingAndPolicyAccessState: Output only. Indicates whether the principal is
	// allowed to access the specified resource based on evaluating the binding and
	// policy.
	//
	// Possible values:
	//   "PAB_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "PAB_ACCESS_STATE_ALLOWED" - The PAB component allows the principal's
	// access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ALLOWED" - The PAB component doesn't allow the
	// principal's access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ENFORCED" - The PAB component is not enforced on the
	// principal, or the specified resource. This state refers to the following
	// scenarios: - IAM doesn't enforce the specified permission at the PAB
	// policy's [enforcement
	// version](https://cloud.google.com/iam/help/pab/enforcement-versions), so the
	// PAB policy can't block access. - The binding doesn't apply to the principal,
	// so the policy is not enforced. - The PAB policy doesn't have any rules
	//   "PAB_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to the PAB component, or the relevant data to explain the PAB
	// component.
	BindingAndPolicyAccessState string `json:"bindingAndPolicyAccessState,omitempty"`
	// ExplainedPolicy: Optional. Details about how this policy contributes to the
	// principal access boundary explanation, with annotations to indicate how the
	// policy contributes to the overall access state. If the caller doesn't have
	// permission to view the policy in the binding, this field is omitted.
	ExplainedPolicy *GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicy `json:"explainedPolicy,omitempty"`
	// ExplainedPolicyBinding: Details about how this binding contributes to the
	// principal access boundary explanation, with annotations to indicate how the
	// binding contributes to the overall access state.
	ExplainedPolicyBinding *GoogleCloudPolicytroubleshooterIamV3betaExplainedPolicyBinding `json:"explainedPolicyBinding,omitempty"`
	// Relevance: The relevance of this principal access boundary binding and
	// policy to the overall access state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BindingAndPolicyAccessState") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BindingAndPolicyAccessState") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedPABBindingAndPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedPABBindingAndPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicy: Details about
// how a principal access boundary policy contributes to the explanation, with
// annotations to indicate how the policy contributes to the overall access
// state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicy struct {
	// ExplainedRules: List of principal access boundary rules that were explained
	// to check the principal's access to specified resource, with annotations to
	// indicate how each rule contributes to the overall access state.
	ExplainedRules []*GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRule `json:"explainedRules,omitempty"`
	// Policy: The policy that is explained.
	Policy *GoogleIamV3PrincipalAccessBoundaryPolicy `json:"policy,omitempty"`
	// PolicyAccessState: Output only. Indicates whether the policy allows access
	// to the specified resource.
	//
	// Possible values:
	//   "PAB_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "PAB_ACCESS_STATE_ALLOWED" - The PAB component allows the principal's
	// access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ALLOWED" - The PAB component doesn't allow the
	// principal's access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ENFORCED" - The PAB component is not enforced on the
	// principal, or the specified resource. This state refers to the following
	// scenarios: - IAM doesn't enforce the specified permission at the PAB
	// policy's [enforcement
	// version](https://cloud.google.com/iam/help/pab/enforcement-versions), so the
	// PAB policy can't block access. - The binding doesn't apply to the principal,
	// so the policy is not enforced. - The PAB policy doesn't have any rules
	//   "PAB_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to the PAB component, or the relevant data to explain the PAB
	// component.
	PolicyAccessState string `json:"policyAccessState,omitempty"`
	// PolicyVersion: Output only. Explanation of the principal access boundary
	// policy's version.
	PolicyVersion *GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicyVersion `json:"policyVersion,omitempty"`
	// Relevance: The relevance of this policy to the overall access state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplainedRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplainedRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicyVersion: Details
// about how a principal access boundary policy's version contributes to the
// policy's enforcement state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicyVersion struct {
	// EnforcementState: Output only. Indicates whether the policy is enforced
	// based on its version.
	//
	// Possible values:
	//   "PAB_POLICY_ENFORCEMENT_STATE_UNSPECIFIED" - An error occurred when
	// checking whether a principal access boundary policy is enforced based on its
	// version.
	//   "PAB_POLICY_ENFORCEMENT_STATE_ENFORCED" - The principal access boundary
	// policy is enforced based on its version.
	//   "PAB_POLICY_ENFORCEMENT_STATE_NOT_ENFORCED" - The principal access
	// boundary policy is not enforced based on its version.
	EnforcementState string `json:"enforcementState,omitempty"`
	// Version: Output only. The actual version of the policy. - If the policy uses
	// static version, this field is the chosen static version. - If the policy
	// uses dynamic version, this field is the effective latest version.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnforcementState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnforcementState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicyVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedPABPolicyVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRule: Details about how
// a principal access boundary rule contributes to the explanation, with
// annotations to indicate how the rule contributes to the overall access
// state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRule struct {
	// CombinedResourceInclusionState: Output only. Indicates whether any resource
	// of the rule is the specified resource or includes the specified resource.
	//
	// Possible values:
	//   "RESOURCE_INCLUSION_STATE_UNSPECIFIED" - An error occurred when checking
	// whether the resource includes the specified resource.
	//   "RESOURCE_INCLUSION_STATE_INCLUDED" - The resource includes the specified
	// resource.
	//   "RESOURCE_INCLUSION_STATE_NOT_INCLUDED" - The resource doesn't include the
	// specified resource.
	//   "RESOURCE_INCLUSION_STATE_UNKNOWN_INFO" - The sender of the request does
	// not have access to the relevant data to check whether the resource includes
	// the specified resource.
	//   "RESOURCE_INCLUSION_STATE_UNKNOWN_UNSUPPORTED" - The resource is of an
	// unsupported type, such as non-CRM resources.
	CombinedResourceInclusionState string `json:"combinedResourceInclusionState,omitempty"`
	// Effect: Required. The effect of the rule which describes the access
	// relationship.
	//
	// Possible values:
	//   "EFFECT_UNSPECIFIED" - Effect unspecified.
	//   "ALLOW" - Allows access to the resources in this rule.
	Effect string `json:"effect,omitempty"`
	// ExplainedResources: List of resources that were explained to check the
	// principal's access to specified resource, with annotations to indicate how
	// each resource contributes to the overall access state.
	ExplainedResources []*GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRuleExplainedResource `json:"explainedResources,omitempty"`
	// Relevance: The relevance of this rule to the overall access state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// RuleAccessState: Output only. Indicates whether the rule allows access to
	// the specified resource.
	//
	// Possible values:
	//   "PAB_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "PAB_ACCESS_STATE_ALLOWED" - The PAB component allows the principal's
	// access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ALLOWED" - The PAB component doesn't allow the
	// principal's access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ENFORCED" - The PAB component is not enforced on the
	// principal, or the specified resource. This state refers to the following
	// scenarios: - IAM doesn't enforce the specified permission at the PAB
	// policy's [enforcement
	// version](https://cloud.google.com/iam/help/pab/enforcement-versions), so the
	// PAB policy can't block access. - The binding doesn't apply to the principal,
	// so the policy is not enforced. - The PAB policy doesn't have any rules
	//   "PAB_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to the PAB component, or the relevant data to explain the PAB
	// component.
	RuleAccessState string `json:"ruleAccessState,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CombinedResourceInclusionState") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CombinedResourceInclusionState")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRuleExplainedResource:
// Details about how a resource contributes to the explanation, with
// annotations to indicate how the resource contributes to the overall access
// state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRuleExplainedResource struct {
	// Relevance: The relevance of this resource to the overall access state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// Resource: The full resource name
	// (https://cloud.google.com/iam/docs/full-resource-names) that identifies the
	// resource that is explained. This can only be a project, a folder, or an
	// organization which is what a PAB rule accepts.
	Resource string `json:"resource,omitempty"`
	// ResourceInclusionState: Output only. Indicates whether the resource is the
	// specified resource or includes the specified resource.
	//
	// Possible values:
	//   "RESOURCE_INCLUSION_STATE_UNSPECIFIED" - An error occurred when checking
	// whether the resource includes the specified resource.
	//   "RESOURCE_INCLUSION_STATE_INCLUDED" - The resource includes the specified
	// resource.
	//   "RESOURCE_INCLUSION_STATE_NOT_INCLUDED" - The resource doesn't include the
	// specified resource.
	//   "RESOURCE_INCLUSION_STATE_UNKNOWN_INFO" - The sender of the request does
	// not have access to the relevant data to check whether the resource includes
	// the specified resource.
	//   "RESOURCE_INCLUSION_STATE_UNKNOWN_UNSUPPORTED" - The resource is of an
	// unsupported type, such as non-CRM resources.
	ResourceInclusionState string `json:"resourceInclusionState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Relevance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Relevance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRuleExplainedResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedPABRuleExplainedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaExplainedPolicyBinding: Details
// about how a policy binding contributes to the policy explanation, with
// annotations to indicate how the policy binding contributes to the overall
// access state.
type GoogleCloudPolicytroubleshooterIamV3betaExplainedPolicyBinding struct {
	// ConditionExplanation: Optional. Explanation of the condition in the policy
	// binding. If the policy binding doesn't have a condition, this field is
	// omitted.
	ConditionExplanation *GoogleCloudPolicytroubleshooterIamV3betaConditionExplanation `json:"conditionExplanation,omitempty"`
	// PolicyBinding: The policy binding that is explained.
	PolicyBinding *GoogleIamV3PolicyBinding `json:"policyBinding,omitempty"`
	// PolicyBindingState: Output only. Indicates whether the policy binding takes
	// effect.
	//
	// Possible values:
	//   "POLICY_BINDING_STATE_UNSPECIFIED" - An error occurred when checking
	// whether the policy binding is enforced.
	//   "POLICY_BINDING_STATE_ENFORCED" - The policy binding is enforced.
	//   "POLICY_BINDING_STATE_NOT_ENFORCED" - The policy binding is not enforced.
	PolicyBindingState string `json:"policyBindingState,omitempty"`
	// Relevance: The relevance of this policy binding to the overall access state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionExplanation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionExplanation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaExplainedPolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaExplainedPolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaPABPolicyExplanation: Details about
// how the relevant principal access boundary policies affect the overall
// access state.
type GoogleCloudPolicytroubleshooterIamV3betaPABPolicyExplanation struct {
	// ExplainedBindingsAndPolicies: List of principal access boundary policies and
	// bindings that are applicable to the principal's access state, with
	// annotations to indicate how each binding and policy contributes to the
	// overall access state.
	ExplainedBindingsAndPolicies []*GoogleCloudPolicytroubleshooterIamV3betaExplainedPABBindingAndPolicy `json:"explainedBindingsAndPolicies,omitempty"`
	// PrincipalAccessBoundaryAccessState: Output only. Indicates whether the
	// principal is allowed to access specified resource, based on evaluating all
	// applicable principal access boundary bindings and policies.
	//
	// Possible values:
	//   "PAB_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "PAB_ACCESS_STATE_ALLOWED" - The PAB component allows the principal's
	// access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ALLOWED" - The PAB component doesn't allow the
	// principal's access to the specified resource.
	//   "PAB_ACCESS_STATE_NOT_ENFORCED" - The PAB component is not enforced on the
	// principal, or the specified resource. This state refers to the following
	// scenarios: - IAM doesn't enforce the specified permission at the PAB
	// policy's [enforcement
	// version](https://cloud.google.com/iam/help/pab/enforcement-versions), so the
	// PAB policy can't block access. - The binding doesn't apply to the principal,
	// so the policy is not enforced. - The PAB policy doesn't have any rules
	//   "PAB_ACCESS_STATE_UNKNOWN_INFO" - The sender of the request does not have
	// access to the PAB component, or the relevant data to explain the PAB
	// component.
	PrincipalAccessBoundaryAccessState string `json:"principalAccessBoundaryAccessState,omitempty"`
	// Relevance: The relevance of the principal access boundary access state to
	// the overall access state.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Not specified.
	//   "HEURISTIC_RELEVANCE_NORMAL" - The data point has a limited effect on the
	// result. Changing the data point is unlikely to affect the overall
	// determination.
	//   "HEURISTIC_RELEVANCE_HIGH" - The data point has a strong effect on the
	// result. Changing the data point is likely to affect the overall
	// determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ExplainedBindingsAndPolicies") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplainedBindingsAndPolicies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaPABPolicyExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaPABPolicyExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyRequest:
// Request for TroubleshootIamPolicy.
type GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyRequest struct {
	// AccessTuple: The information to use for checking whether a principal has a
	// permission for a resource.
	AccessTuple *GoogleCloudPolicytroubleshooterIamV3betaAccessTuple `json:"accessTuple,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessTuple") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessTuple") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse:
// Response for TroubleshootIamPolicy.
type GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse struct {
	// AccessTuple: The access tuple from the request, including any provided
	// context used to evaluate the condition.
	AccessTuple *GoogleCloudPolicytroubleshooterIamV3betaAccessTuple `json:"accessTuple,omitempty"`
	// AllowPolicyExplanation: An explanation of how the applicable IAM allow
	// policies affect the final access state.
	AllowPolicyExplanation *GoogleCloudPolicytroubleshooterIamV3betaAllowPolicyExplanation `json:"allowPolicyExplanation,omitempty"`
	// DenyPolicyExplanation: An explanation of how the applicable IAM deny
	// policies affect the final access state.
	DenyPolicyExplanation *GoogleCloudPolicytroubleshooterIamV3betaDenyPolicyExplanation `json:"denyPolicyExplanation,omitempty"`
	// OverallAccessState: Indicates whether the principal has the specified
	// permission for the specified resource, based on evaluating all types of the
	// applicable IAM policies.
	//
	// Possible values:
	//   "OVERALL_ACCESS_STATE_UNSPECIFIED" - Not specified.
	//   "CAN_ACCESS" - The principal has the permission.
	//   "CANNOT_ACCESS" - The principal doesn't have the permission.
	//   "UNKNOWN_INFO" - The principal might have the permission, but the sender
	// can't access all of the information needed to fully evaluate the principal's
	// access.
	//   "UNKNOWN_CONDITIONAL" - The principal might have the permission, but
	// Policy Troubleshooter can't fully evaluate the principal's access because
	// the sender didn't provide the required context to evaluate the condition.
	OverallAccessState string `json:"overallAccessState,omitempty"`
	// PabPolicyExplanation: An explanation of how the applicable principal access
	// boundary policies affect the final access state.
	PabPolicyExplanation *GoogleCloudPolicytroubleshooterIamV3betaPABPolicyExplanation `json:"pabPolicyExplanation,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessTuple") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessTuple") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts, service
// accounts, Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical expression that
// allows access to a resource only if the expression evaluates to `true`. A
// condition can add constraints based on attributes of the request, the
// resource, or both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV2DenyRule: A deny rule in an IAM deny policy.
type GoogleIamV2DenyRule struct {
	// DenialCondition: The condition that determines whether this deny rule
	// applies to a request. If the condition expression evaluates to `true`, then
	// the deny rule is applied; otherwise, the deny rule is not applied. Each deny
	// rule is evaluated independently. If this deny rule does not apply to a
	// request, other deny rules might still apply. The condition can use CEL
	// functions that evaluate resource tags
	// (https://cloud.google.com/iam/help/conditions/resource-tags). Other
	// functions and operators are not supported.
	DenialCondition *GoogleTypeExpr `json:"denialCondition,omitempty"`
	// DeniedPermissions: The permissions that are explicitly denied by this rule.
	// Each permission uses the format `{service_fqdn}/{resource}.{verb}`, where
	// `{service_fqdn}` is the fully qualified domain name for the service. For
	// example, `iam.googleapis.com/roles.list`.
	DeniedPermissions []string `json:"deniedPermissions,omitempty"`
	// DeniedPrincipals:  The identities that are prevented from using one or more
	// permissions on Google Cloud resources. This field can contain the following
	// values: * `principal://goog/subject/{email_id}`: A specific Google Account.
	// Includes Gmail, Cloud Identity, and Google Workspace user accounts. For
	// example, `principal://goog/subject/alice@example.com`. *
	// `principal://iam.googleapis.com/projects/-/serviceAccounts/{service_account_i
	// d}`: A Google Cloud service account. For example,
	// `principal://iam.googleapis.com/projects/-/serviceAccounts/my-service-account
	// @iam.gserviceaccount.com`. * `principalSet://goog/group/{group_id}`: A
	// Google group. For example, `principalSet://goog/group/admins@example.com`. *
	// `principalSet://goog/public:all`: A special identifier that represents any
	// principal that is on the internet, even if they do not have a Google Account
	// or are not logged in. *
	// `principalSet://goog/cloudIdentityCustomerId/{customer_id}`: All of the
	// principals associated with the specified Google Workspace or Cloud Identity
	// customer ID. For example,
	// `principalSet://goog/cloudIdentityCustomerId/C01Abc35`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. *
	// `principalSet://cloudresourcemanager.googleapis.com/[projects|folders|organiz
	// ations]/{project_number|folder_number|org_number}/type/ServiceAccount`: All
	// service accounts grouped under a resource (project, folder, or
	// organization). *
	// `principalSet://cloudresourcemanager.googleapis.com/[projects|folders|organiz
	// ations]/{project_number|folder_number|org_number}/type/ServiceAgent`: All
	// service agents grouped under a resource (project, folder, or organization).
	// * `deleted:principal://goog/subject/{email_id}?uid={uid}`: A specific Google
	// Account that was deleted recently. For example,
	// `deleted:principal://goog/subject/alice@example.com?uid=1234567890`. If the
	// Google Account is recovered, this identifier reverts to the standard
	// identifier for a Google Account. *
	// `deleted:principalSet://goog/group/{group_id}?uid={uid}`: A Google group
	// that was deleted recently. For example,
	// `deleted:principalSet://goog/group/admins@example.com?uid=1234567890`. If
	// the Google group is restored, this identifier reverts to the standard
	// identifier for a Google group. *
	// `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/{service_a
	// ccount_id}?uid={uid}`: A Google Cloud service account that was deleted
	// recently. For example,
	// `deleted:principal://iam.googleapis.com/projects/-/serviceAccounts/my-service
	// -account@iam.gserviceaccount.com?uid=1234567890`. If the service account is
	// undeleted, this identifier reverts to the standard identifier for a service
	// account. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	DeniedPrincipals []string `json:"deniedPrincipals,omitempty"`
	// ExceptionPermissions: Specifies the permissions that this rule excludes from
	// the set of denied permissions given by `denied_permissions`. If a permission
	// appears in `denied_permissions` _and_ in `exception_permissions` then it
	// will _not_ be denied. The excluded permissions can be specified using the
	// same syntax as `denied_permissions`.
	ExceptionPermissions []string `json:"exceptionPermissions,omitempty"`
	// ExceptionPrincipals: The identities that are excluded from the deny rule,
	// even if they are listed in the `denied_principals`. For example, you could
	// add a Google group to the `denied_principals`, then exclude specific users
	// who belong to that group. This field can contain the same values as the
	// `denied_principals` field, excluding `principalSet://goog/public:all`, which
	// represents all users on the internet.
	ExceptionPrincipals []string `json:"exceptionPrincipals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenialCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenialCondition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV2DenyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV2DenyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV2Policy: Data for an IAM policy.
type GoogleIamV2Policy struct {
	// Annotations: A key-value map to store arbitrary metadata for the `Policy`.
	// Keys can be up to 63 characters. Values can be up to 255 characters.
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. The time when the `Policy` was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. The time when the `Policy` was deleted. Empty if
	// the policy is not deleted.
	DeleteTime string `json:"deleteTime,omitempty"`
	// DisplayName: A user-specified description of the `Policy`. This value can be
	// up to 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An opaque tag that identifies the current version of the `Policy`. IAM
	// uses this value to help manage concurrent updates, so they do not cause one
	// update to be overwritten by another. If this field is present in a
	// CreatePolicyRequest, the value is ignored.
	Etag string `json:"etag,omitempty"`
	// Kind: Output only. The kind of the `Policy`. Always contains the value
	// `DenyPolicy`.
	Kind string `json:"kind,omitempty"`
	// Name: Immutable. The resource name of the `Policy`, which must be unique.
	// Format: `policies/{attachment_point}/denypolicies/{policy_id}` The
	// attachment point is identified by its URL-encoded full resource name, which
	// means that the forward-slash character, `/`, must be written as `%2F`. For
	// example,
	// `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypol
	// icies/my-deny-policy`. For organizations and folders, use the numeric ID in
	// the full resource name. For projects, requests can use the alphanumeric or
	// the numeric ID. Responses always contain the numeric ID.
	Name string `json:"name,omitempty"`
	// Rules: A list of rules that specify the behavior of the `Policy`. All of the
	// rules should be of the `kind` specified in the `Policy`.
	Rules []*GoogleIamV2PolicyRule `json:"rules,omitempty"`
	// Uid: Immutable. The globally unique ID of the `Policy`. Assigned
	// automatically when the `Policy` is created.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The time when the `Policy` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV2Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV2Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV2PolicyRule: A single rule in a `Policy`.
type GoogleIamV2PolicyRule struct {
	// DenyRule: A rule for a deny policy.
	DenyRule *GoogleIamV2DenyRule `json:"denyRule,omitempty"`
	// Description: A user-specified description of the rule. This value can be up
	// to 256 characters.
	Description string `json:"description,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenyRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenyRule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV2PolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV2PolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV3PolicyBinding: IAM policy binding resource.
type GoogleIamV3PolicyBinding struct {
	// Annotations: Optional. User-defined annotations. See
	// https://google.aip.dev/148#annotations for more details such as format and
	// size limitations
	Annotations map[string]string `json:"annotations,omitempty"`
	// Condition: Optional. The condition to apply to the policy binding. When set,
	// the `expression` field in the `Expr` must include from 1 to 10
	// subexpressions, joined by the "||"(Logical OR), "&&"(Logical AND) or
	// "!"(Logical NOT) operators and cannot contain more than 250 characters. The
	// condition is currently only supported when bound to policies of kind
	// principal access boundary. When the bound policy is a principal access
	// boundary policy, the only supported attributes in any subexpression are
	// `principal.type` and `principal.subject`. An example expression is:
	// "principal.type == 'iam.googleapis.com/ServiceAccount'" or
	// "principal.subject == 'bob@example.com'". Allowed operations for
	// `principal.subject`: - `principal.subject == ` - `principal.subject != ` -
	// `principal.subject in []` - `principal.subject.startsWith()` -
	// `principal.subject.endsWith()` Allowed operations for `principal.type`: -
	// `principal.type == ` - `principal.type != ` - `principal.type in []`
	// Supported principal types are Workspace, Workforce Pool, Workload Pool and
	// Service Account. Allowed string must be one of: -
	// iam.googleapis.com/WorkspaceIdentity -
	// iam.googleapis.com/WorkforcePoolIdentity -
	// iam.googleapis.com/WorkloadPoolIdentity - iam.googleapis.com/ServiceAccount
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// CreateTime: Output only. The time when the policy binding was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. The description of the policy binding. Must be less
	// than or equal to 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Optional. The etag for the policy binding. If this is provided on
	// update, it must match the server's etag.
	Etag string `json:"etag,omitempty"`
	// Name: Identifier. The name of the policy binding, in the format
	// `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`.
	// The binding parent is the closest Resource Manager resource (project,
	// folder, or organization) to the binding target. Format: *
	// `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id
	// }` *
	// `projects/{project_number}/locations/{location}/policyBindings/{policy_bindin
	// g_id}` *
	// `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
	//  *
	// `organizations/{organization_id}/locations/{location}/policyBindings/{policy_
	// binding_id}`
	Name string `json:"name,omitempty"`
	// Policy: Required. Immutable. The resource name of the policy to be bound.
	// The binding parent and policy must belong to the same organization.
	Policy string `json:"policy,omitempty"`
	// PolicyKind: Immutable. The kind of the policy to attach in this binding.
	// This field must be one of the following: - Left empty (will be automatically
	// set to the policy kind) - The input policy kind
	//
	// Possible values:
	//   "POLICY_KIND_UNSPECIFIED" - Unspecified policy kind; Not a valid state
	//   "PRINCIPAL_ACCESS_BOUNDARY" - Principal access boundary policy kind
	//   "ACCESS" - Access policy kind.
	PolicyKind string `json:"policyKind,omitempty"`
	// PolicyUid: Output only. The globally unique ID of the policy to be bound.
	PolicyUid string `json:"policyUid,omitempty"`
	// Target: Required. Immutable. The full resource name of the resource to which
	// the policy will be bound. Immutable once set.
	Target *GoogleIamV3PolicyBindingTarget `json:"target,omitempty"`
	// Uid: Output only. The globally unique ID of the policy binding. Assigned
	// when the policy binding is created.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The time when the policy binding was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV3PolicyBinding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV3PolicyBinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV3PolicyBindingTarget: The full resource name of the resource to
// which the policy will be bound. Immutable once set.
type GoogleIamV3PolicyBindingTarget struct {
	// PrincipalSet: Immutable. The full resource name that's used for principal
	// access boundary policy bindings. The principal set must be directly parented
	// by the policy binding's parent or same as the parent if the target is a
	// project, folder, or organization. Examples: * For bindings parented by an
	// organization: * Organization:
	// `//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID` *
	// Workforce Identity:
	// `//iam.googleapis.com/locations/global/workforcePools/WORKFORCE_POOL_ID` *
	// Workspace Identity:
	// `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID` * For
	// bindings parented by a folder: * Folder:
	// `//cloudresourcemanager.googleapis.com/folders/FOLDER_ID` * For bindings
	// parented by a project: * Project: *
	// `//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER` *
	// `//cloudresourcemanager.googleapis.com/projects/PROJECT_ID` * Workload
	// Identity Pool:
	// `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/LOCATION/workloadIden
	// tityPools/WORKLOAD_POOL_ID`
	PrincipalSet string `json:"principalSet,omitempty"`
	// Resource: Immutable. The full resource name that's used for access policy
	// bindings. Examples: * Organization:
	// `//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID` *
	// Folder: `//cloudresourcemanager.googleapis.com/folders/FOLDER_ID` * Project:
	// * `//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER` *
	// `//cloudresourcemanager.googleapis.com/projects/PROJECT_ID`
	Resource string `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrincipalSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrincipalSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV3PolicyBindingTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV3PolicyBindingTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV3PrincipalAccessBoundaryPolicy: An IAM principal access boundary
// policy resource.
type GoogleIamV3PrincipalAccessBoundaryPolicy struct {
	// Annotations: Optional. User defined annotations. See
	// https://google.aip.dev/148#annotations for more details such as format and
	// size limitations
	Annotations map[string]string `json:"annotations,omitempty"`
	// CreateTime: Output only. The time when the principal access boundary policy
	// was created.
	CreateTime string `json:"createTime,omitempty"`
	// Details: Optional. The details for the principal access boundary policy.
	Details *GoogleIamV3PrincipalAccessBoundaryPolicyDetails `json:"details,omitempty"`
	// DisplayName: Optional. The description of the principal access boundary
	// policy. Must be less than or equal to 63 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Optional. The etag for the principal access boundary. If this is
	// provided on update, it must match the server's etag.
	Etag string `json:"etag,omitempty"`
	// Name: Identifier. The resource name of the principal access boundary policy.
	// The following format is supported:
	// `organizations/{organization_id}/locations/{location}/principalAccessBoundary
	// Policies/{policy_id}`
	Name string `json:"name,omitempty"`
	// Uid: Output only. The globally unique ID of the principal access boundary
	// policy.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The time when the principal access boundary policy
	// was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV3PrincipalAccessBoundaryPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV3PrincipalAccessBoundaryPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV3PrincipalAccessBoundaryPolicyDetails: Principal access boundary
// policy details
type GoogleIamV3PrincipalAccessBoundaryPolicyDetails struct {
	// EnforcementVersion: Optional. The version number (for example, `1` or
	// `latest`) that indicates which permissions are able to be blocked by the
	// policy. If empty, the PAB policy version will be set to the most recent
	// version number at the time of the policy's creation.
	EnforcementVersion string `json:"enforcementVersion,omitempty"`
	// Rules: Required. A list of principal access boundary policy rules. The
	// number of rules in a policy is limited to 500.
	Rules []*GoogleIamV3PrincipalAccessBoundaryPolicyRule `json:"rules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnforcementVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnforcementVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV3PrincipalAccessBoundaryPolicyDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV3PrincipalAccessBoundaryPolicyDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV3PrincipalAccessBoundaryPolicyRule: Principal access boundary
// policy rule that defines the resource boundary.
type GoogleIamV3PrincipalAccessBoundaryPolicyRule struct {
	// Description: Optional. The description of the principal access boundary
	// policy rule. Must be less than or equal to 256 characters.
	Description string `json:"description,omitempty"`
	// Effect: Required. The access relationship of principals to the resources in
	// this rule.
	//
	// Possible values:
	//   "EFFECT_UNSPECIFIED" - Effect unspecified.
	//   "ALLOW" - Allows access to the resources in this rule.
	Effect string `json:"effect,omitempty"`
	// Resources: Required. A list of Resource Manager resources. If a resource is
	// listed in the rule, then the rule applies for that resource and its
	// descendants. The number of resources in a policy is limited to 500 across
	// all rules in the policy. The following resource types are supported: *
	// Organizations, such as
	// `//cloudresourcemanager.googleapis.com/organizations/123`. * Folders, such
	// as `//cloudresourcemanager.googleapis.com/folders/123`. * Projects, such as
	// `//cloudresourcemanager.googleapis.com/projects/123` or
	// `//cloudresourcemanager.googleapis.com/projects/my-project-id`.
	Resources []string `json:"resources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV3PrincipalAccessBoundaryPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV3PrincipalAccessBoundaryPolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The syntax and
// semantics of CEL are documented at https://github.com/google/cel-spec.
// Example (Comparison): title: "Summary size limit" description: "Determines
// if a summary is less than 100 chars" expression: "document.summary.size() <
// 100" Example (Equality): title: "Requestor is owner" description:
// "Determines if requestor is the document owner" expression: "document.owner
// == request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type IamTroubleshootCall struct {
	s                                                                    *Service
	googlecloudpolicytroubleshooteriamv3betatroubleshootiampolicyrequest *GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyRequest
	urlParams_                                                           gensupport.URLParams
	ctx_                                                                 context.Context
	header_                                                              http.Header
}

// Troubleshoot: Checks whether a principal has a specific permission for a
// specific resource, and explains why the principal does or doesn't have that
// permission.
func (r *IamService) Troubleshoot(googlecloudpolicytroubleshooteriamv3betatroubleshootiampolicyrequest *GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyRequest) *IamTroubleshootCall {
	c := &IamTroubleshootCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudpolicytroubleshooteriamv3betatroubleshootiampolicyrequest = googlecloudpolicytroubleshooteriamv3betatroubleshootiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *IamTroubleshootCall) Fields(s ...googleapi.Field) *IamTroubleshootCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *IamTroubleshootCall) Context(ctx context.Context) *IamTroubleshootCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *IamTroubleshootCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IamTroubleshootCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudpolicytroubleshooteriamv3betatroubleshootiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3beta/iam:troubleshoot")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policytroubleshooter.iam.troubleshoot", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policytroubleshooter.iam.troubleshoot" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *IamTroubleshootCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicytroubleshooterIamV3betaTroubleshootIamPolicyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policytroubleshooter.iam.troubleshoot", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
