// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contactcenteraiplatform provides access to the Contact Center AI Platform API.
//
// For product documentation, see: https://cloud.google.com/solutions/contact-center-ai-platform
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contactcenteraiplatform/v1alpha1"
//	...
//	ctx := context.Background()
//	contactcenteraiplatformService, err := contactcenteraiplatform.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contactcenteraiplatformService, err := contactcenteraiplatform.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contactcenteraiplatformService, err := contactcenteraiplatform.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package contactcenteraiplatform // import "google.golang.org/api/contactcenteraiplatform/v1alpha1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "contactcenteraiplatform:v1alpha1"
const apiName = "contactcenteraiplatform"
const apiVersion = "v1alpha1"
const basePath = "https://contactcenteraiplatform.googleapis.com/"
const basePathTemplate = "https://contactcenteraiplatform.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://contactcenteraiplatform.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.ContactCenters = NewProjectsLocationsContactCentersService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	ContactCenters *ProjectsLocationsContactCentersService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsContactCentersService(s *Service) *ProjectsLocationsContactCentersService {
	rs := &ProjectsLocationsContactCentersService{s: s}
	return rs
}

type ProjectsLocationsContactCentersService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// AdminUser: Message storing info about the first admin user. Next ID: 3
type AdminUser struct {
	// FamilyName: Optional. Last/family name of the first admin user.
	FamilyName string `json:"familyName,omitempty"`
	// GivenName: Optional. First/given name of the first admin user.
	GivenName string `json:"givenName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FamilyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FamilyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdminUser) MarshalJSON() ([]byte, error) {
	type NoMethod AdminUser
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// Component: Defines a logical CCAIP component that e.g. “EMAIL”, "CRM".
// For more information see go/ccaip-private-path-v2. Each logical component is
// associated with a list of service attachments.
type Component struct {
	// Name: Name of the component.
	Name string `json:"name,omitempty"`
	// ServiceAttachmentNames: Associated service attachments. The service
	// attachment names that will be used for sending private traffic to the CCAIP
	// tenant project. Example service attachment name:
	// "projects/${TENANT_PROJECT_ID}/regions/${REGION}/serviceAttachments/ingress-d
	// efault".
	ServiceAttachmentNames []string `json:"serviceAttachmentNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Component) MarshalJSON() ([]byte, error) {
	type NoMethod Component
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContactCenter: Message describing ContactCenter object
type ContactCenter struct {
	// AdminUser: Optional. Info about the first admin user, such as given name and
	// family name.
	AdminUser *AdminUser `json:"adminUser,omitempty"`
	// AdvancedReportingEnabled: Optional. Whether the advanced reporting feature
	// is enabled.
	AdvancedReportingEnabled bool `json:"advancedReportingEnabled,omitempty"`
	// CcaipManagedUsers: Optional. Whether to enable users to be created in the
	// CCAIP-instance concurrently to having users in Cloud identity
	CcaipManagedUsers bool `json:"ccaipManagedUsers,omitempty"`
	// CreateTime: Output only. [Output only] Create time stamp
	CreateTime string `json:"createTime,omitempty"`
	// Critical: Optional. Critical release channel.
	Critical *Critical `json:"critical,omitempty"`
	// CustomerDomainPrefix: Required. Immutable. At least 2 and max 16 char long,
	// must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).
	CustomerDomainPrefix string `json:"customerDomainPrefix,omitempty"`
	// DisplayName: Required. A user friendly name for the ContactCenter.
	DisplayName string `json:"displayName,omitempty"`
	// Early: Optional. Early release channel.
	Early *Early `json:"early,omitempty"`
	// FeatureConfig: Optional. Feature configuration to populate the feature
	// flags.
	FeatureConfig *FeatureConfig `json:"featureConfig,omitempty"`
	// InstanceConfig: The configuration of this instance, it is currently
	// immutable once created.
	InstanceConfig *InstanceConfig `json:"instanceConfig,omitempty"`
	// KmsKey: Immutable. The KMS key name to encrypt the user input
	// (`ContactCenter`).
	KmsKey string `json:"kmsKey,omitempty"`
	// Labels: Labels as key value pairs
	Labels map[string]string `json:"labels,omitempty"`
	// Name: name of resource
	Name string `json:"name,omitempty"`
	// Normal: Optional. Normal release channel.
	Normal *Normal `json:"normal,omitempty"`
	// PrivateAccess: Optional. VPC-SC related networking configuration.
	PrivateAccess *PrivateAccess `json:"privateAccess,omitempty"`
	// PrivateComponents: Output only. TODO(b/283407860) Deprecate this field.
	PrivateComponents []string `json:"privateComponents,omitempty"`
	// ReleaseVersion: Output only. UJET release version, unique for each new
	// release.
	ReleaseVersion string `json:"releaseVersion,omitempty"`
	// SamlParams: Optional. Params that sets up Google as IdP.
	SamlParams *SAMLParams `json:"samlParams,omitempty"`
	// State: Output only. The state of this contact center.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "STATE_DEPLOYING" - State DEPLOYING
	//   "STATE_DEPLOYED" - State DEPLOYED
	//   "STATE_TERMINATING" - State TERMINATING
	//   "STATE_FAILED" - State FAILED
	//   "STATE_TERMINATING_FAILED" - State TERMINATING_FAILED
	//   "STATE_TERMINATED" - State TERMINATED
	//   "STATE_IN_GRACE_PERIOD" - State IN_GRACE_PERIOD
	//   "STATE_FAILING_OVER" - State in STATE_FAILING_OVER. This State must ONLY
	// be used by Multiregional Instances when a failover was triggered. Customers
	// are not able to update instances in this state.
	//   "STATE_DEGRADED" - State DEGRADED. This State must ONLY be used by
	// Multiregional Instances after a failover was executed successfully.
	// Customers are not able to update instances in this state.
	//   "STATE_REPAIRING" - State REPAIRING. This State must ONLY be used by
	// Multiregional Instances after a fallback was triggered. Customers are not
	// able to update instancs in this state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. [Output only] Update time stamp
	UpdateTime string `json:"updateTime,omitempty"`
	// Uris: Output only. URIs to access the deployed ContactCenters.
	Uris *URIs `json:"uris,omitempty"`
	// UserEmail: Optional. Email address of the first admin user.
	UserEmail string `json:"userEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdminUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContactCenter) MarshalJSON() ([]byte, error) {
	type NoMethod ContactCenter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContactCenterQuota: Represents a quota for contact centers.
type ContactCenterQuota struct {
	// ContactCenterCountLimit: Deprecated: Use the Quota fields instead. Reflects
	// the count limit of contact centers on a billing account.
	ContactCenterCountLimit int64 `json:"contactCenterCountLimit,omitempty"`
	// ContactCenterCountSum: Deprecated: Use the Quota fields instead. Reflects
	// the count sum of contact centers on a billing account.
	ContactCenterCountSum int64 `json:"contactCenterCountSum,omitempty"`
	// Quotas: Quota details per contact center instance type.
	Quotas []*Quota `json:"quotas,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContactCenterCountLimit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContactCenterCountLimit") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContactCenterQuota) MarshalJSON() ([]byte, error) {
	type NoMethod ContactCenterQuota
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Critical: Instances in this Channel will receive updates after all instances
// in `Normal` were updated. They also will only be updated outside of their
// peak hours.
type Critical struct {
	// PeakHours: Required. Hours during which the instance should not be updated.
	PeakHours []*WeeklySchedule `json:"peakHours,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PeakHours") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PeakHours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Critical) MarshalJSON() ([]byte, error) {
	type NoMethod Critical
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateList: List of dates.
type DateList struct {
	// Values: Optional. Values in the list.
	Values []*Date `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateList) MarshalJSON() ([]byte, error) {
	type NoMethod DateList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DateTime: Represents civil time (or occasionally physical time). This type
// can represent a civil time in one of a few possible ways: * When utc_offset
// is set and time_zone is unset: a civil time on a calendar day with a
// particular offset from UTC. * When time_zone is set and utc_offset is unset:
// a civil time on a calendar day in a particular time zone. * When neither
// time_zone nor utc_offset is set: a civil time on a calendar day in local
// time. The date is relative to the Proleptic Gregorian Calendar. If year,
// month, or day are 0, the DateTime is considered not to have a specific year,
// month, or day respectively. This type may also be used to represent a
// physical time if all the date and time fields are set and either case of the
// `time_offset` oneof is set. Consider using `Timestamp` message for physical
// time instead. If your use case also would like to store the user's timezone,
// that can be done in another field. This type is more flexible than some
// applications may want. Make sure to document and validate your application's
// limitations.
type DateTime struct {
	// Day: Optional. Day of month. Must be from 1 to 31 and valid for the year and
	// month, or 0 if specifying a datetime without a day.
	Day int64 `json:"day,omitempty"`
	// Hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23,
	// defaults to 0 (midnight). An API may choose to allow the value "24:00:00"
	// for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to
	// 0.
	Minutes int64 `json:"minutes,omitempty"`
	// Month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a
	// datetime without a month.
	Month int64 `json:"month,omitempty"`
	// Nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999, defaults to 0.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Optional. Seconds of minutes of the time. Must normally be from 0
	// to 59, defaults to 0. An API may allow the value 60 if it allows
	// leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// TimeZone: Time zone.
	TimeZone *TimeZone `json:"timeZone,omitempty"`
	// UtcOffset: UTC offset. Must be whole seconds, between -18 hours and +18
	// hours. For example, a UTC offset of -4:00 would be represented as { seconds:
	// -14400 }.
	UtcOffset string `json:"utcOffset,omitempty"`
	// Year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DateTime) MarshalJSON() ([]byte, error) {
	type NoMethod DateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Early: LINT.IfChange First Channel to receive the updates. Meant to dev/test
// instances
type Early struct {
}

// EmployeeInfo: Information about a particular employee for planning purposes.
type EmployeeInfo struct {
	// Id: Required. Unique ID of this employee.
	Id string `json:"id,omitempty"`
	// UnwantedEventIntervals: Optional. A list of unwanted event intervals for
	// this employee. The start time of the interval must be in the planning
	// horizon.
	UnwantedEventIntervals []*UnwantedEventInterval `json:"unwantedEventIntervals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmployeeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod EmployeeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EventTemplate: Template specifying rules for generating a single event that
// occurs during a shift. An event may represent a meeting, break, lunch, etc.
type EventTemplate struct {
	// DurationMinutes: Required. Fixed duration in minutes of this event.
	DurationMinutes int64 `json:"durationMinutes,omitempty"`
	// Id: Required. Unique ID of this template.
	Id string `json:"id,omitempty"`
	// MaximumMinutesAfterShiftStart: Optional. Maximum number of minutes after the
	// beginning of a shift that this event can start.
	MaximumMinutesAfterShiftStart int64 `json:"maximumMinutesAfterShiftStart,omitempty"`
	// MinimumMinutesAfterShiftStart: Optional. Minimum number of minutes after the
	// beginning of a shift that this event can start.
	MinimumMinutesAfterShiftStart int64 `json:"minimumMinutesAfterShiftStart,omitempty"`
	// StartTimeIncrementMinutes: Required. The time increment (in minutes) used to
	// generate the set of possible event start times between
	// `minimum_minutes_after_shift_start` and `maximum_minutes_after_shift_start`.
	// For example, if the minimum minutes after shift start are 30, maximum
	// minutes after shift start are 45, and the start time increment is 5 minutes,
	// the event can take place 30, 35, 40, or 45 minutes after the start of the
	// shift.
	StartTimeIncrementMinutes int64 `json:"startTimeIncrementMinutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DurationMinutes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DurationMinutes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EventTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod EventTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FeatureConfig struct {
	// AgentDesktopEnabled: Optional. If true - enables the agent desktop feature.
	// Default is false.
	AgentDesktopEnabled bool `json:"agentDesktopEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDesktopEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDesktopEnabled") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateShiftsRequest: Request with constraints for generating shifts. The
// shifts generated must adhere to these constraints.
type GenerateShiftsRequest struct {
	// EmployeeInfo: Optional. Employee information that should be considered when
	// generating shifts.
	EmployeeInfo []*EmployeeInfo `json:"employeeInfo,omitempty"`
	// PlanningHorizon: Required. The solver will generate the maximum number of
	// shifts per shift template.
	PlanningHorizon *PlanningHorizon `json:"planningHorizon,omitempty"`
	// ShiftTemplates: Required. Set of shift templates specifying rules for
	// generating shifts. A shift template can be used for generating multiple
	// shifts.
	ShiftTemplates []*ShiftTemplate `json:"shiftTemplates,omitempty"`
	// SolverConfig: Optional. Parameters for the solver.
	SolverConfig *SolverConfig `json:"solverConfig,omitempty"`
	// WorkforceDemands: Required. All the workforce demands that the generated
	// shifts need to cover. The planning horizon is defined between the earliest
	// start time and the latest end time across all the entries. This field cannot
	// be empty.
	WorkforceDemands *WorkforceDemandList `json:"workforceDemands,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmployeeInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmployeeInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateShiftsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateShiftsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudCommonOperationMetadata: Represents the metadata of the
// long-running operation.
type GoogleCloudCommonOperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CancelRequested: Output only. Identifies whether the user has requested
	// cancellation of the operation. Operations that have been cancelled
	// successfully have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
	CancelRequested bool `json:"cancelRequested,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// StatusDetail: Output only. Human-readable status of the operation, if any.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudCommonOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudCommonOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceConfig: Message storing the instance configuration.
type InstanceConfig struct {
	// InstanceSize: The instance size of this the instance configuration.
	//
	// Possible values:
	//   "INSTANCE_SIZE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "STANDARD_SMALL" - Instance Size STANDARD_SMALL.
	//   "STANDARD_MEDIUM" - Instance Size STANDARD_MEDIUM.
	//   "STANDARD_LARGE" - Instance Size STANDARD_LARGE.
	//   "STANDARD_XLARGE" - Instance Size STANDARD_XLARGE.
	//   "STANDARD_2XLARGE" - Instance Size STANDARD_2XLARGE.
	//   "STANDARD_3XLARGE" - Instance Size STANDARD_3XLARGE.
	//   "MULTIREGION_SMALL" - Instance Size MULTIREGION_SMALL
	//   "MULTIREGION_MEDIUM" - Instance Size MULTIREGION_MEDIUM
	//   "MULTIREGION_LARGE" - Instance Size MULTIREGION_LARGE
	//   "MULTIREGION_XLARGE" - Instance Size MULTIREGION_XLARGE
	//   "MULTIREGION_2XLARGE" - Instance Size MULTIREGION_2XLARGE.
	//   "MULTIREGION_3XLARGE" - Instance Size MULTIREGION_3XLARGE.
	//   "DEV_SMALL" - Instance Size DEV_SMALL
	//   "SANDBOX_SMALL" - Instance Size SANDBOX_SMALL
	//   "TRIAL_SMALL" - Instance Size TRIAL_SMALL
	//   "TIME_LIMITED_TRIAL_SMALL" - Instance Size TIME_LIMITED_TRIAL_SMALL
	InstanceSize string `json:"instanceSize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListContactCentersResponse: Message for response to listing ContactCenters
type ListContactCentersResponse struct {
	// ContactCenters: The list of ContactCenter
	ContactCenters []*ContactCenter `json:"contactCenters,omitempty"`
	// NextPageToken: A token identifying a page of results the server should
	// return.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContactCenters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContactCenters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListContactCentersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListContactCentersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Normal: Instances in this Channel will receive updates after all instances
// in `Early` were updated + 2 days.
type Normal struct {
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// ContactCenter: Contact center information for this request
	ContactCenter *ContactCenter `json:"contactCenter,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have been cancelled
	// successfully have Operation.error value with a google.rpc.Status.code of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`
	// StatusMessage: Output only. Human-readable status of the operation, if any.
	StatusMessage string `json:"statusMessage,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlanningHorizon: Specifies the time interval during which the solver should
// generate shifts. The start time must be before the end time.
type PlanningHorizon struct {
	// EndTime: Required. End of the time interval for the given demand
	// (exclusive). These values are read down to the minute; seconds and all
	// smaller units are ignored.
	EndTime *DateTime `json:"endTime,omitempty"`
	// StartTime: Required. Start of the time interval for the given demand
	// (inclusive). These values are read down to the minute; seconds and all
	// smaller units are ignored.
	StartTime *DateTime `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlanningHorizon) MarshalJSON() ([]byte, error) {
	type NoMethod PlanningHorizon
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrivateAccess: Defines ingress and egress private traffic settings for CCAIP
// instances.
type PrivateAccess struct {
	// EgressSettings: List of egress components that should not be accessed via
	// the Internet. For more information see go/ccaip-private-path-v2.
	EgressSettings []*Component `json:"egressSettings,omitempty"`
	// IngressSettings: List of ingress components that should not be accessed via
	// the Internet. For more information see go/ccaip-private-path-v2.
	IngressSettings []*Component `json:"ingressSettings,omitempty"`
	// PscSetting: Private service connect settings.
	PscSetting *PscSetting `json:"pscSetting,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EgressSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EgressSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrivateAccess) MarshalJSON() ([]byte, error) {
	type NoMethod PrivateAccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PscSetting: Private service connect settings.
type PscSetting struct {
	// AllowedConsumerProjectIds: The list of project ids that are allowed to send
	// traffic to the service attachment. This field should be filled only for the
	// ingress components.
	AllowedConsumerProjectIds []string `json:"allowedConsumerProjectIds,omitempty"`
	// ProducerProjectIds: Output only. The CCAIP tenant project ids.
	ProducerProjectIds []string `json:"producerProjectIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedConsumerProjectIds")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedConsumerProjectIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PscSetting) MarshalJSON() ([]byte, error) {
	type NoMethod PscSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Quota: Quota details.
type Quota struct {
	// ContactCenterCountLimit: Reflects the count limit of contact centers on a
	// billing account.
	ContactCenterCountLimit int64 `json:"contactCenterCountLimit,omitempty"`
	// ContactCenterCountSum: Reflects the count sum of contact centers on a
	// billing account.
	ContactCenterCountSum int64 `json:"contactCenterCountSum,omitempty"`
	// ContactCenterInstanceSize: Contact center instance type.
	//
	// Possible values:
	//   "INSTANCE_SIZE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "STANDARD_SMALL" - Instance Size STANDARD_SMALL.
	//   "STANDARD_MEDIUM" - Instance Size STANDARD_MEDIUM.
	//   "STANDARD_LARGE" - Instance Size STANDARD_LARGE.
	//   "STANDARD_XLARGE" - Instance Size STANDARD_XLARGE.
	//   "STANDARD_2XLARGE" - Instance Size STANDARD_2XLARGE.
	//   "STANDARD_3XLARGE" - Instance Size STANDARD_3XLARGE.
	//   "MULTIREGION_SMALL" - Instance Size MULTIREGION_SMALL
	//   "MULTIREGION_MEDIUM" - Instance Size MULTIREGION_MEDIUM
	//   "MULTIREGION_LARGE" - Instance Size MULTIREGION_LARGE
	//   "MULTIREGION_XLARGE" - Instance Size MULTIREGION_XLARGE
	//   "MULTIREGION_2XLARGE" - Instance Size MULTIREGION_2XLARGE.
	//   "MULTIREGION_3XLARGE" - Instance Size MULTIREGION_3XLARGE.
	//   "DEV_SMALL" - Instance Size DEV_SMALL
	//   "SANDBOX_SMALL" - Instance Size SANDBOX_SMALL
	//   "TRIAL_SMALL" - Instance Size TRIAL_SMALL
	//   "TIME_LIMITED_TRIAL_SMALL" - Instance Size TIME_LIMITED_TRIAL_SMALL
	ContactCenterInstanceSize string `json:"contactCenterInstanceSize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContactCenterCountLimit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContactCenterCountLimit") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Quota) MarshalJSON() ([]byte, error) {
	type NoMethod Quota
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SAMLParams: Message storing SAML params to enable Google as IDP.
type SAMLParams struct {
	// AuthenticationContexts: Additional contexts used for authentication.
	//
	// Possible values:
	//   "AUTHENTICATION_CONTEXT_UNSPECIFIED" - The Unspecified class indicates
	// that the authentication was performed by unspecified means.
	//   "INTERNET_PROTOCOL" - The Internet Protocol class is applicable when a
	// principal is authenticated through the use of a provided IP address.
	//   "INTERNET_PROTOCOL_PASSWORD" - The Internet Protocol Password class is
	// applicable when a principal is authenticated through the use of a provided
	// IP address, in addition to a username/password.
	//   "KERBEROS" - This class is applicable when the principal has authenticated
	// using a password to a local authentication authority, in order to acquire a
	// Kerberos ticket. That Kerberos ticket is then used for subsequent network
	// authentication.
	//   "MOBILE_ONE_FACTOR_UNREGISTERED" - Reflects no mobile customer
	// registration procedures and an authentication of the mobile device without
	// requiring explicit end-user interaction. This context class authenticates
	// only the device and never the user; it is useful when services other than
	// the mobile operator want to add a secure device authentication to their
	// authentication process.
	//   "MOBILE_TWO_FACTOR_UNREGISTERED" - Reflects no mobile customer
	// registration procedures and a two-factor based authentication, such as
	// secure device and user PIN. This context class is useful when a service
	// other than the mobile operator wants to link their customer ID to a mobile
	// supplied two-factor authentication service by capturing mobile phone data at
	// enrollment.
	//   "MOBILE_ONE_FACTOR_CONTRACT" - Reflects mobile contract customer
	// registration procedures and a single factor authentication. For example, a
	// digital signing device with tamper resistant memory for key storage, such as
	// the mobile MSISDN, but no required PIN or biometric for real-time user
	// authentication.
	//   "MOBILE_TWO_FACTOR_CONTRACT" - Reflects mobile contract customer
	// registration procedures and a two-factor based authentication. For example,
	// a digital signing device with tamper resistant memory for key storage, such
	// as a GSM SIM, that requires explicit proof of user identity and intent, such
	// as a PIN or biometric.
	//   "PASSWORD" - The Password class is applicable when a principal
	// authenticates to an authentication authority through the presentation of a
	// password over an unprotected HTTP session.
	//   "PASSWORD_PROTECTED_TRANSPORT" - The PasswordProtectedTransport class is
	// applicable when a principal authenticates to an authentication authority
	// through the presentation of a password over a protected session.
	//   "PREVIOUS_SESSION" - The PreviousSession class is applicable when a
	// principal had authenticated to an authentication authority at some point in
	// the past using any authentication context supported by that authentication
	// authority
	//   "PUBLIC_KEY_X509" - The X509 context class indicates that the principal
	// authenticated by means of a digital signature where the key was validated as
	// part of an X.509 Public Key Infrastructure.
	//   "PUBLIC_KEY_PGP" - The PGP context class indicates that the principal
	// authenticated by means of a digital signature where the key was validated as
	// part of a PGP Public Key Infrastructure.
	//   "PUBLIC_KEY_SPKI" - The SPKI context class indicates that the principal
	// authenticated by means of a digital signature where the key was validated
	// via an SPKI Infrastructure.
	//   "PUBLIC_KEY_XML_DIGITAL_SIGNATURE" - This context class indicates that the
	// principal authenticated by means of a digital signature according to the
	// processing rules specified in the XML Digital Signature specification
	// [XMLSig].
	//   "SMARTCARD" - The Smartcard class is identified when a principal
	// authenticates to an authentication authority using a smartcard.
	//   "SMARTCARD_PKI" - The SmartcardPKI class is applicable when a principal
	// authenticates to an authentication authority through a two-factor
	// authentication mechanism using a smartcard with enclosed private key and a
	// PIN.
	//   "SOFTWARE_PKI" - The Software-PKI class is applicable when a principal
	// uses an X.509 certificate stored in software to authenticate to the
	// authentication authority.
	//   "TELEPHONY" - This class is used to indicate that the principal
	// authenticated via the provision of a fixed-line telephone number,
	// transported via a telephony protocol such as ADSL.
	//   "TELEPHONY_NOMADIC" - Indicates that the principal is "roaming" (perhaps
	// using a phone card) and authenticates via the means of the line number, a
	// user suffix, and a password element.
	//   "TELEPHONY_PERSONALIZED" - This class is used to indicate that the
	// principal authenticated via the provision of a fixed-line telephone number
	// and a user suffix, transported via a telephony protocol such as ADSL.
	//   "TELEPHONY_AUTHENTICATED" - Indicates that the principal authenticated via
	// the means of the line number, a user suffix, and a password element.
	//   "SECURE_REMOTE_PASSWORD" - The Secure Remote Password class is applicable
	// when the authentication was performed by means of Secure Remote Password as
	// specified in [RFC 2945].
	//   "SSL_TLS_CERTIFICATE_BASED" - This class indicates that the principal
	// authenticated by means of a client certificate, secured with the SSL/TLS
	// transport.
	//   "TIME_SYNC_TOKEN" - The TimeSyncToken class is applicable when a principal
	// authenticates through a time synchronization token.
	AuthenticationContexts []string `json:"authenticationContexts,omitempty"`
	// Certificate: SAML certificate
	Certificate string `json:"certificate,omitempty"`
	// EmailMapping: IdP field that maps to the user’s email address
	EmailMapping string `json:"emailMapping,omitempty"`
	// EntityId: Entity id URL
	EntityId string `json:"entityId,omitempty"`
	// SsoUri: Single sign-on URL
	SsoUri string `json:"ssoUri,omitempty"`
	// UserEmail: Email address of the first admin users.
	UserEmail string `json:"userEmail,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthenticationContexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthenticationContexts") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SAMLParams) MarshalJSON() ([]byte, error) {
	type NoMethod SAMLParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShiftTemplate: Template specifying rules for generating shifts. A shift is a
// unit of work that specifies a start time, end time, and may contain events
// (e.g. lunch, breaks etc.). Shifts will be assigned to specific dates in the
// response.
type ShiftTemplate struct {
	// AssignableEmployeeIds: Optional. A list of specific employee IDs that can be
	// assigned to shifts generated by this template. If this field is present,
	// there will be `EmployeeSchedule`s in the response for which the
	// `EmployeeSchedule.employee_id` field is set to one of the IDs in this list.
	// The number of employee schedules with an assigned employee ID will be
	// between `minimum_employee_count` and `maximum_employee_count`. If this field
	// is empty, between `minimum_employee_count` and `maximum_employee_count`
	// employees can be assigned to shifts generated by this template and the
	// employee schedules won't have an assigned employee ID. Currently, only one
	// assignable employee ID is supported.
	AssignableEmployeeIds []string `json:"assignableEmployeeIds,omitempty"`
	// DaysOffCountPerWeek: Optional. Fixed number of days off per week. An
	// employee has a given day off if they are not assigned to a shift that starts
	// on that day. A week is 7 days and begins on Sunday.
	DaysOffCountPerWeek int64 `json:"daysOffCountPerWeek,omitempty"`
	// DaysOffDates: Optional. Fixed dates when shifts from this template should
	// not be generated.
	DaysOffDates *DateList `json:"daysOffDates,omitempty"`
	// DurationMinutes: Required. Fixed duration of a shift generated by this
	// template.
	DurationMinutes int64 `json:"durationMinutes,omitempty"`
	// EarliestStartTime: Required. Earliest time in the day that a shift can
	// start. This value is specified with hours and minutes; seconds and nanos are
	// ignored.
	EarliestStartTime *TimeOfDay `json:"earliestStartTime,omitempty"`
	// EventTemplates: Optional. Rules for generating events for each shift.
	// Exactly one event will be included in each shift for each `EventTemplate`
	// specified.
	EventTemplates []*EventTemplate `json:"eventTemplates,omitempty"`
	// Id: Required. Unique ID of this template.
	Id string `json:"id,omitempty"`
	// LatestStartTime: Required. Latest time in the day that a shift can start.
	// This value is specified with hours and minutes; seconds and nanos are
	// ignored. If this value is less than the `earliest_start_time`, it may imply
	// an overnight shift.
	LatestStartTime *TimeOfDay `json:"latestStartTime,omitempty"`
	// MaximumEmployeeCount: Required. Maximum number of employees that can be
	// assigned to all shifts generated by this template on working days.
	MaximumEmployeeCount int64 `json:"maximumEmployeeCount,omitempty"`
	// MinimumEmployeeCount: Optional. Minimum number of employees that can be
	// assigned to all shifts generated by this template on working days.
	MinimumEmployeeCount int64 `json:"minimumEmployeeCount,omitempty"`
	// MinimumIntereventGapMinutes: Optional. Minimum minutes between the end of
	// one event and the start of the next.
	MinimumIntereventGapMinutes int64 `json:"minimumIntereventGapMinutes,omitempty"`
	// StartTimeIncrementMinutes: Optional. The time increment (in minutes) used to
	// generate the set of possible start times between `earliest_start_time` and
	// `latest_start_time`. For example, if the earliest start time is 8:00, the
	// latest start time is 8:30, and the start time increment is 10 minutes, then
	// all possible start times for this shift template are: 8:00, 8:10, 8:20, and
	// 8:30.
	StartTimeIncrementMinutes int64 `json:"startTimeIncrementMinutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AssignableEmployeeIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssignableEmployeeIds") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShiftTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod ShiftTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SolverConfig: Specifies additional parameters for the solver generating
// shifts.
type SolverConfig struct {
	// MaximumProcessingDuration: Optional. Maximum time the solver should spend on
	// the problem. If not set, defaults to 1 minute. The choice of a time limit
	// should depend on the size of the problem. To give an example, when solving a
	// 7-day instance with 2 `ShiftTemplates`, each with ~20 possible start times
	// and holding 2 events with ~30 possible start times, and two days off per
	// week, recommended values are: <10s for fast solutions (and likely
	// suboptimal), (10s, 300s) for good quality solutions, and >300s for an
	// exhaustive search. Larger instances may require longer time limits. This
	// value is not a hard limit and it does not account for the communication
	// overhead. The expected latency to solve the problem may slightly exceed this
	// value.
	MaximumProcessingDuration string `json:"maximumProcessingDuration,omitempty"`
	// ScheduleType: Required. Specifies the type of schedule to generate.
	//
	// Possible values:
	//   "SCHEDULE_TYPE_UNSPECIFIED" - Unspecified schedule type. Should not be
	// used.
	//   "SINGLE_SHIFT" - Each `EmployeeSchedule` will include exactly one shift.
	//   "WEEKLY_WITH_FIXED_EVENTS" - `EmployeeSchedule`s will include several
	// shifts to generate a week-long schedule. The start and end time of events in
	// a particular `EmployeeSchedule` will be identical. All the shifts have the
	// same start and end time.
	//   "WEEKLY_WITH_VARIABLE_EVENTS" - `EmployeeSchedule`s will include several
	// shifts to generate a week-long schedule. The start and end time of events in
	// a particular `EmployeeSchedule` can vary. All the shifts have the same start
	// and end time. This option may result in longer solve times.
	ScheduleType string `json:"scheduleType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaximumProcessingDuration")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaximumProcessingDuration") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SolverConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SolverConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeZone: Represents a time zone from the IANA Time Zone Database
// (https://www.iana.org/time-zones).
type TimeZone struct {
	// Id: IANA Time Zone Database time zone. For example "America/New_York".
	Id string `json:"id,omitempty"`
	// Version: Optional. IANA Time Zone Database version number. For example
	// "2019a".
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod TimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// URIs: Message storing the URIs of the ContactCenter.
type URIs struct {
	// ChatBotUri: Chat Bot Uri of the ContactCenter
	ChatBotUri string `json:"chatBotUri,omitempty"`
	// MediaUri: Media Uri of the ContactCenter.
	MediaUri string `json:"mediaUri,omitempty"`
	// RootUri: Root Uri of the ContactCenter.
	RootUri string `json:"rootUri,omitempty"`
	// VirtualAgentStreamingServiceUri: Virtual Agent Streaming Service Uri of the
	// ContactCenter.
	VirtualAgentStreamingServiceUri string `json:"virtualAgentStreamingServiceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChatBotUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChatBotUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s URIs) MarshalJSON() ([]byte, error) {
	type NoMethod URIs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UnwantedEventInterval: Specifies a time interval during which the overlap
// with events (generated from event templates) should be minimal.
type UnwantedEventInterval struct {
	// DurationMinutes: Required. Duration of the event.
	DurationMinutes int64 `json:"durationMinutes,omitempty"`
	// StartTime: Required. Start time of the event.
	StartTime *DateTime `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DurationMinutes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DurationMinutes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UnwantedEventInterval) MarshalJSON() ([]byte, error) {
	type NoMethod UnwantedEventInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WeeklySchedule: Message representing a weekly schedule.
type WeeklySchedule struct {
	// Days: Required. Days of the week this schedule applies to.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	Days []string `json:"days,omitempty"`
	// Duration: Optional. Duration of the schedule.
	Duration string `json:"duration,omitempty"`
	// EndTime: Optional. Daily end time of the schedule. If `end_time` is before
	// `start_time`, the schedule will be considered as ending on the next day.
	EndTime *TimeOfDay `json:"endTime,omitempty"`
	// StartTime: Required. Daily start time of the schedule.
	StartTime *TimeOfDay `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Days") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Days") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WeeklySchedule) MarshalJSON() ([]byte, error) {
	type NoMethod WeeklySchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkforceDemand: Specifies the number of employees required to cover the
// demand in the given time interval. The length of the interval must be
// strictly positive.
type WorkforceDemand struct {
	// EmployeeCount: Optional. Number of employees needed to cover the demand for
	// this interval.
	EmployeeCount int64 `json:"employeeCount,omitempty"`
	// EndTime: Required. End of the time interval for the given demand
	// (exclusive). These values are read down to the minute; seconds and all
	// smaller units are ignored.
	EndTime *DateTime `json:"endTime,omitempty"`
	// StartTime: Required. Start of the time interval for the given demand
	// (inclusive). These values are read down to the minute; seconds and all
	// smaller units are ignored.
	StartTime *DateTime `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EmployeeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EmployeeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkforceDemand) MarshalJSON() ([]byte, error) {
	type NoMethod WorkforceDemand
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkforceDemandList: List of workforce demands.
type WorkforceDemandList struct {
	// Values: Optional. Values in the list.
	Values []*WorkforceDemand `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkforceDemandList) MarshalJSON() ([]byte, error) {
	type NoMethod WorkforceDemandList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsGenerateShiftsCall struct {
	s                     *Service
	parent                string
	generateshiftsrequest *GenerateShiftsRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// GenerateShifts: Generates shifts constrained by various parameters.
//
//   - parent: Name of the parent resource associated with the request. Format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsService) GenerateShifts(parent string, generateshiftsrequest *GenerateShiftsRequest) *ProjectsLocationsGenerateShiftsCall {
	c := &ProjectsLocationsGenerateShiftsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.generateshiftsrequest = generateshiftsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGenerateShiftsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGenerateShiftsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGenerateShiftsCall) Context(ctx context.Context) *ProjectsLocationsGenerateShiftsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGenerateShiftsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGenerateShiftsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.generateshiftsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}:generateShifts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.generateShifts", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.generateShifts" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGenerateShiftsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.generateShifts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsQueryContactCenterQuotaCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// QueryContactCenterQuota: Queries the contact center quota, an aggregation
// over all the projects, that belongs to the billing account, which the input
// project belongs to.
//
// - parent: Parent project resource id.
func (r *ProjectsLocationsService) QueryContactCenterQuota(parent string) *ProjectsLocationsQueryContactCenterQuotaCall {
	c := &ProjectsLocationsQueryContactCenterQuotaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQueryContactCenterQuotaCall) Fields(s ...googleapi.Field) *ProjectsLocationsQueryContactCenterQuotaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsQueryContactCenterQuotaCall) IfNoneMatch(entityTag string) *ProjectsLocationsQueryContactCenterQuotaCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQueryContactCenterQuotaCall) Context(ctx context.Context) *ProjectsLocationsQueryContactCenterQuotaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQueryContactCenterQuotaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQueryContactCenterQuotaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}:queryContactCenterQuota")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.queryContactCenterQuota", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.queryContactCenterQuota" call.
// Any non-2xx status code is an error. Response headers are in either
// *ContactCenterQuota.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsQueryContactCenterQuotaCall) Do(opts ...googleapi.CallOption) (*ContactCenterQuota, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ContactCenterQuota{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.queryContactCenterQuota", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsContactCentersCreateCall struct {
	s             *Service
	parent        string
	contactcenter *ContactCenter
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Creates a new ContactCenter in a given project and location.
//
// - parent: Value for parent.
func (r *ProjectsLocationsContactCentersService) Create(parent string, contactcenter *ContactCenter) *ProjectsLocationsContactCentersCreateCall {
	c := &ProjectsLocationsContactCentersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.contactcenter = contactcenter
	return c
}

// ContactCenterId sets the optional parameter "contactCenterId": Required. Id
// of the requesting object If auto-generating Id server-side, remove this
// field and contact_center_id from the method_signature of Create RPC
func (c *ProjectsLocationsContactCentersCreateCall) ContactCenterId(contactCenterId string) *ProjectsLocationsContactCentersCreateCall {
	c.urlParams_.Set("contactCenterId", contactCenterId)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsContactCentersCreateCall) RequestId(requestId string) *ProjectsLocationsContactCentersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsContactCentersCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsContactCentersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsContactCentersCreateCall) Context(ctx context.Context) *ProjectsLocationsContactCentersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsContactCentersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsContactCentersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.contactcenter)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}/contactCenters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.contactCenters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsContactCentersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsContactCentersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a single ContactCenter.
//
// - name: Name of the resource.
func (r *ProjectsLocationsContactCentersService) Delete(name string) *ProjectsLocationsContactCentersDeleteCall {
	c := &ProjectsLocationsContactCentersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes after
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsContactCentersDeleteCall) RequestId(requestId string) *ProjectsLocationsContactCentersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsContactCentersDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsContactCentersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsContactCentersDeleteCall) Context(ctx context.Context) *ProjectsLocationsContactCentersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsContactCentersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsContactCentersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.contactCenters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsContactCentersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsContactCentersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details of a single ContactCenter.
//
// - name: Name of the resource.
func (r *ProjectsLocationsContactCentersService) Get(name string) *ProjectsLocationsContactCentersGetCall {
	c := &ProjectsLocationsContactCentersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsContactCentersGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsContactCentersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsContactCentersGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsContactCentersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsContactCentersGetCall) Context(ctx context.Context) *ProjectsLocationsContactCentersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsContactCentersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsContactCentersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.contactCenters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ContactCenter.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsContactCentersGetCall) Do(opts ...googleapi.CallOption) (*ContactCenter, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ContactCenter{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsContactCentersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ContactCenters in a given project and location.
//
// - parent: Parent value for ListContactCentersRequest.
func (r *ProjectsLocationsContactCentersService) List(parent string) *ProjectsLocationsContactCentersListCall {
	c := &ProjectsLocationsContactCentersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filtering results
func (c *ProjectsLocationsContactCentersListCall) Filter(filter string) *ProjectsLocationsContactCentersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Hint for how to order the
// results
func (c *ProjectsLocationsContactCentersListCall) OrderBy(orderBy string) *ProjectsLocationsContactCentersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. Server
// may return fewer items than requested. If unspecified, server will pick an
// appropriate default.
func (c *ProjectsLocationsContactCentersListCall) PageSize(pageSize int64) *ProjectsLocationsContactCentersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return.
func (c *ProjectsLocationsContactCentersListCall) PageToken(pageToken string) *ProjectsLocationsContactCentersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsContactCentersListCall) Fields(s ...googleapi.Field) *ProjectsLocationsContactCentersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsContactCentersListCall) IfNoneMatch(entityTag string) *ProjectsLocationsContactCentersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsContactCentersListCall) Context(ctx context.Context) *ProjectsLocationsContactCentersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsContactCentersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsContactCentersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+parent}/contactCenters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.contactCenters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListContactCentersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsContactCentersListCall) Do(opts ...googleapi.CallOption) (*ListContactCentersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListContactCentersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsContactCentersListCall) Pages(ctx context.Context, f func(*ListContactCentersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsContactCentersPatchCall struct {
	s             *Service
	name          string
	contactcenter *ContactCenter
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Updates the parameters of a single ContactCenter.
//
// - name: name of resource.
func (r *ProjectsLocationsContactCentersService) Patch(name string, contactcenter *ContactCenter) *ProjectsLocationsContactCentersPatchCall {
	c := &ProjectsLocationsContactCentersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.contactcenter = contactcenter
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so that if you must retry
// your request, the server will know to ignore the request if it has already
// been completed. The server will guarantee that for at least 60 minutes since
// the first request. For example, consider a situation where you make an
// initial request and the request times out. If you make the request again
// with the same request ID, the server can check if original operation with
// the same request ID was received, and if so, will ignore the second request.
// This prevents clients from accidentally creating duplicate commitments. The
// request ID must be a valid UUID with the exception that zero UUID is not
// supported (00000000-0000-0000-0000-000000000000).
func (c *ProjectsLocationsContactCentersPatchCall) RequestId(requestId string) *ProjectsLocationsContactCentersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask is
// used to specify the fields to be overwritten in the ContactCenter resource
// by the update. The fields specified in the update_mask are relative to the
// resource, not the full request. A field will be overwritten if it is in the
// mask. If the user does not provide a mask then all fields will be
// overwritten.
func (c *ProjectsLocationsContactCentersPatchCall) UpdateMask(updateMask string) *ProjectsLocationsContactCentersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsContactCentersPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsContactCentersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsContactCentersPatchCall) Context(ctx context.Context) *ProjectsLocationsContactCentersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsContactCentersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsContactCentersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.contactcenter)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.contactCenters.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsContactCentersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.contactCenters.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenteraiplatform.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenteraiplatform.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
