// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

package compute

import (
	"context"
	"fmt"
	"net/http"

	internallog "github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
)

type RegionDiskTypesGetCall struct {
	s            *Service
	project      string
	region       string
	diskType     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the specified regional disk type.
//
// - diskType: Name of the disk type to return.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDiskTypesService) Get(project string, region string, diskType string) *RegionDiskTypesGetCall {
	c := &RegionDiskTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.diskType = diskType
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDiskTypesGetCall) Fields(s ...googleapi.Field) *RegionDiskTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionDiskTypesGetCall) IfNoneMatch(entityTag string) *RegionDiskTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDiskTypesGetCall) Context(ctx context.Context) *RegionDiskTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDiskTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDiskTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/diskTypes/{diskType}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"diskType": c.diskType,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDiskTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDiskTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DiskType.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDiskTypesGetCall) Do(opts ...googleapi.CallOption) (*DiskType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DiskType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDiskTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDiskTypesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of regional disk types available to the specified
// project.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDiskTypesService) List(project string, region string) *RegionDiskTypesListCall {
	c := &RegionDiskTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionDiskTypesListCall) Filter(filter string) *RegionDiskTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionDiskTypesListCall) MaxResults(maxResults int64) *RegionDiskTypesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionDiskTypesListCall) OrderBy(orderBy string) *RegionDiskTypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionDiskTypesListCall) PageToken(pageToken string) *RegionDiskTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionDiskTypesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionDiskTypesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDiskTypesListCall) Fields(s ...googleapi.Field) *RegionDiskTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionDiskTypesListCall) IfNoneMatch(entityTag string) *RegionDiskTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDiskTypesListCall) Context(ctx context.Context) *RegionDiskTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDiskTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDiskTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/diskTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDiskTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDiskTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionDiskTypeList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionDiskTypesListCall) Do(opts ...googleapi.CallOption) (*RegionDiskTypeList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionDiskTypeList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDiskTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionDiskTypesListCall) Pages(ctx context.Context, f func(*RegionDiskTypeList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionDisksAddResourcePoliciesCall struct {
	s                                     *Service
	project                               string
	region                                string
	disk                                  string
	regiondisksaddresourcepoliciesrequest *RegionDisksAddResourcePoliciesRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// AddResourcePolicies: Adds existing resource policies to a regional disk. You
// can only add one
// policy which will be applied to this disk for scheduling snapshot
// creation.
//
// - disk: The disk name for this request.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) AddResourcePolicies(project string, region string, disk string, regiondisksaddresourcepoliciesrequest *RegionDisksAddResourcePoliciesRequest) *RegionDisksAddResourcePoliciesCall {
	c := &RegionDisksAddResourcePoliciesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.regiondisksaddresourcepoliciesrequest = regiondisksaddresourcepoliciesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksAddResourcePoliciesCall) RequestId(requestId string) *RegionDisksAddResourcePoliciesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksAddResourcePoliciesCall) Fields(s ...googleapi.Field) *RegionDisksAddResourcePoliciesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksAddResourcePoliciesCall) Context(ctx context.Context) *RegionDisksAddResourcePoliciesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksAddResourcePoliciesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksAddResourcePoliciesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regiondisksaddresourcepoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/addResourcePolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.addResourcePolicies", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.addResourcePolicies" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksAddResourcePoliciesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.addResourcePolicies", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksBulkInsertCall struct {
	s                      *Service
	project                string
	region                 string
	bulkinsertdiskresource *BulkInsertDiskResource
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// BulkInsert: Bulk create a set of disks.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) BulkInsert(project string, region string, bulkinsertdiskresource *BulkInsertDiskResource) *RegionDisksBulkInsertCall {
	c := &RegionDisksBulkInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.bulkinsertdiskresource = bulkinsertdiskresource
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksBulkInsertCall) RequestId(requestId string) *RegionDisksBulkInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksBulkInsertCall) Fields(s ...googleapi.Field) *RegionDisksBulkInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksBulkInsertCall) Context(ctx context.Context) *RegionDisksBulkInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksBulkInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksBulkInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.bulkinsertdiskresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/bulkInsert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.bulkInsert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.bulkInsert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksBulkInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.bulkInsert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksCreateSnapshotCall struct {
	s          *Service
	project    string
	region     string
	disk       string
	snapshot   *Snapshot
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// CreateSnapshot: Creates a snapshot of a specified persistent disk. For
// regular snapshot
// creation, consider using snapshots.insert
// instead, as that method supports more features, such as creating
// snapshots
// in a project different from the source disk project.
//
// - disk: Name of the regional persistent disk to snapshot.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionDisksService) CreateSnapshot(project string, region string, disk string, snapshot *Snapshot) *RegionDisksCreateSnapshotCall {
	c := &RegionDisksCreateSnapshotCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.snapshot = snapshot
	return c
}

// GuestFlush sets the optional parameter "guestFlush": [Input Only] Specifies
// to create an application consistent snapshot by
// informing the OS to prepare for the snapshot process.
func (c *RegionDisksCreateSnapshotCall) GuestFlush(guestFlush bool) *RegionDisksCreateSnapshotCall {
	c.urlParams_.Set("guestFlush", fmt.Sprint(guestFlush))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksCreateSnapshotCall) RequestId(requestId string) *RegionDisksCreateSnapshotCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksCreateSnapshotCall) Fields(s ...googleapi.Field) *RegionDisksCreateSnapshotCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksCreateSnapshotCall) Context(ctx context.Context) *RegionDisksCreateSnapshotCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksCreateSnapshotCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksCreateSnapshotCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.snapshot)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/createSnapshot")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.createSnapshot", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.createSnapshot" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksCreateSnapshotCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.createSnapshot", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksDeleteCall struct {
	s          *Service
	project    string
	region     string
	disk       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified regional persistent disk. Deleting a regional
// disk
// removes all the replicas of its data permanently and is
// irreversible.
// However, deleting a disk does not delete anysnapshots
// previously made from the disk. You must separatelydelete
// snapshots.
//
// - disk: Name of the regional persistent disk to delete.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionDisksService) Delete(project string, region string, disk string) *RegionDisksDeleteCall {
	c := &RegionDisksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksDeleteCall) RequestId(requestId string) *RegionDisksDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksDeleteCall) Fields(s ...googleapi.Field) *RegionDisksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksDeleteCall) Context(ctx context.Context) *RegionDisksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksGetCall struct {
	s            *Service
	project      string
	region       string
	disk         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a specified regional persistent disk.
//
// - disk: Name of the regional persistent disk to return.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionDisksService) Get(project string, region string, disk string) *RegionDisksGetCall {
	c := &RegionDisksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksGetCall) Fields(s ...googleapi.Field) *RegionDisksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionDisksGetCall) IfNoneMatch(entityTag string) *RegionDisksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksGetCall) Context(ctx context.Context) *RegionDisksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Disk.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksGetCall) Do(opts ...googleapi.CallOption) (*Disk, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Disk{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksGetAsyncReplicationStatusCall struct {
	s            *Service
	project      string
	region       string
	disk         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAsyncReplicationStatus: Gets the status of current async replication for
// a given device.
//
//   - disk: Name of the Disk resource whose Async replication details are
//     requested.
//
// Name should conform to RFC1035 or be an unsigned long integer.
// - project: Project ID for this request.
// - region: The name of the zone for this request.
func (r *RegionDisksService) GetAsyncReplicationStatus(project string, region string, disk string) *RegionDisksGetAsyncReplicationStatusCall {
	c := &RegionDisksGetAsyncReplicationStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksGetAsyncReplicationStatusCall) Fields(s ...googleapi.Field) *RegionDisksGetAsyncReplicationStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionDisksGetAsyncReplicationStatusCall) IfNoneMatch(entityTag string) *RegionDisksGetAsyncReplicationStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksGetAsyncReplicationStatusCall) Context(ctx context.Context) *RegionDisksGetAsyncReplicationStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksGetAsyncReplicationStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksGetAsyncReplicationStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/getAsyncReplicationStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.getAsyncReplicationStatus", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.getAsyncReplicationStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetAsyncReplicationStatusResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionDisksGetAsyncReplicationStatusCall) Do(opts ...googleapi.CallOption) (*GetAsyncReplicationStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetAsyncReplicationStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.getAsyncReplicationStatus", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksGetIamPolicyCall struct {
	s            *Service
	project      string
	region       string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May be empty if
// no such
// policy or resource exists.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionDisksService) GetIamPolicy(project string, region string, resource string) *RegionDisksGetIamPolicyCall {
	c := &RegionDisksGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "optionsRequestedPolicyVersion": Requested IAM Policy version.
func (c *RegionDisksGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *RegionDisksGetIamPolicyCall {
	c.urlParams_.Set("optionsRequestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksGetIamPolicyCall) Fields(s ...googleapi.Field) *RegionDisksGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionDisksGetIamPolicyCall) IfNoneMatch(entityTag string) *RegionDisksGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksGetIamPolicyCall) Context(ctx context.Context) *RegionDisksGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{resource}/getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksInsertCall struct {
	s          *Service
	project    string
	region     string
	disk       *Disk
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a persistent regional disk in the specified project using
// the data
// included in the request.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionDisksService) Insert(project string, region string, disk *Disk) *RegionDisksInsertCall {
	c := &RegionDisksInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksInsertCall) RequestId(requestId string) *RegionDisksInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SourceImage sets the optional parameter "sourceImage": Source image to
// restore onto a disk. This field is optional.
func (c *RegionDisksInsertCall) SourceImage(sourceImage string) *RegionDisksInsertCall {
	c.urlParams_.Set("sourceImage", sourceImage)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksInsertCall) Fields(s ...googleapi.Field) *RegionDisksInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksInsertCall) Context(ctx context.Context) *RegionDisksInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.disk)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of persistent disks contained within
// the specified region.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionDisksService) List(project string, region string) *RegionDisksListCall {
	c := &RegionDisksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionDisksListCall) Filter(filter string) *RegionDisksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionDisksListCall) MaxResults(maxResults int64) *RegionDisksListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionDisksListCall) OrderBy(orderBy string) *RegionDisksListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionDisksListCall) PageToken(pageToken string) *RegionDisksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionDisksListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionDisksListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksListCall) Fields(s ...googleapi.Field) *RegionDisksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionDisksListCall) IfNoneMatch(entityTag string) *RegionDisksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksListCall) Context(ctx context.Context) *RegionDisksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DiskList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksListCall) Do(opts ...googleapi.CallOption) (*DiskList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DiskList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionDisksListCall) Pages(ctx context.Context, f func(*DiskList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionDisksRemoveResourcePoliciesCall struct {
	s                                        *Service
	project                                  string
	region                                   string
	disk                                     string
	regiondisksremoveresourcepoliciesrequest *RegionDisksRemoveResourcePoliciesRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// RemoveResourcePolicies: Removes resource policies from a regional disk.
//
// - disk: The disk name for this request.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) RemoveResourcePolicies(project string, region string, disk string, regiondisksremoveresourcepoliciesrequest *RegionDisksRemoveResourcePoliciesRequest) *RegionDisksRemoveResourcePoliciesCall {
	c := &RegionDisksRemoveResourcePoliciesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.regiondisksremoveresourcepoliciesrequest = regiondisksremoveresourcepoliciesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksRemoveResourcePoliciesCall) RequestId(requestId string) *RegionDisksRemoveResourcePoliciesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksRemoveResourcePoliciesCall) Fields(s ...googleapi.Field) *RegionDisksRemoveResourcePoliciesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksRemoveResourcePoliciesCall) Context(ctx context.Context) *RegionDisksRemoveResourcePoliciesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksRemoveResourcePoliciesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksRemoveResourcePoliciesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regiondisksremoveresourcepoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/removeResourcePolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.removeResourcePolicies", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.removeResourcePolicies" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksRemoveResourcePoliciesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.removeResourcePolicies", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksResizeCall struct {
	s                        *Service
	project                  string
	region                   string
	disk                     string
	regiondisksresizerequest *RegionDisksResizeRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Resize: Resizes the specified regional persistent disk.
//
// - disk: Name of the regional persistent disk.
// - project: The project ID for this request.
// - region: Name of the region for this request.
func (r *RegionDisksService) Resize(project string, region string, disk string, regiondisksresizerequest *RegionDisksResizeRequest) *RegionDisksResizeCall {
	c := &RegionDisksResizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.regiondisksresizerequest = regiondisksresizerequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksResizeCall) RequestId(requestId string) *RegionDisksResizeCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksResizeCall) Fields(s ...googleapi.Field) *RegionDisksResizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksResizeCall) Context(ctx context.Context) *RegionDisksResizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksResizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksResizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regiondisksresizerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/resize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.resize", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.resize" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksResizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.resize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksSetIamPolicyCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetpolicyrequest *RegionSetPolicyRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource.
// Replaces any existing policy.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionDisksService) SetIamPolicy(project string, region string, resource string, regionsetpolicyrequest *RegionSetPolicyRequest) *RegionDisksSetIamPolicyCall {
	c := &RegionDisksSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetpolicyrequest = regionsetpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksSetIamPolicyCall) Fields(s ...googleapi.Field) *RegionDisksSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksSetIamPolicyCall) Context(ctx context.Context) *RegionDisksSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{resource}/setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksSetLabelsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetlabelsrequest *RegionSetLabelsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetLabels: Sets the labels on the target regional disk.
//
// - project: Project ID for this request.
// - region: The region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionDisksService) SetLabels(project string, region string, resource string, regionsetlabelsrequest *RegionSetLabelsRequest) *RegionDisksSetLabelsCall {
	c := &RegionDisksSetLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetlabelsrequest = regionsetlabelsrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksSetLabelsCall) RequestId(requestId string) *RegionDisksSetLabelsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksSetLabelsCall) Fields(s ...googleapi.Field) *RegionDisksSetLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksSetLabelsCall) Context(ctx context.Context) *RegionDisksSetLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksSetLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksSetLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetlabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{resource}/setLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.setLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.setLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksSetLabelsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.setLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksStartAsyncReplicationCall struct {
	s                                       *Service
	project                                 string
	region                                  string
	disk                                    string
	regiondisksstartasyncreplicationrequest *RegionDisksStartAsyncReplicationRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// StartAsyncReplication: Starts asynchronous replication.
// Must be invoked on the primary disk.
//
// - disk: The name of the persistent disk.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) StartAsyncReplication(project string, region string, disk string, regiondisksstartasyncreplicationrequest *RegionDisksStartAsyncReplicationRequest) *RegionDisksStartAsyncReplicationCall {
	c := &RegionDisksStartAsyncReplicationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.regiondisksstartasyncreplicationrequest = regiondisksstartasyncreplicationrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksStartAsyncReplicationCall) RequestId(requestId string) *RegionDisksStartAsyncReplicationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksStartAsyncReplicationCall) Fields(s ...googleapi.Field) *RegionDisksStartAsyncReplicationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksStartAsyncReplicationCall) Context(ctx context.Context) *RegionDisksStartAsyncReplicationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksStartAsyncReplicationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksStartAsyncReplicationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regiondisksstartasyncreplicationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/startAsyncReplication")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.startAsyncReplication", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.startAsyncReplication" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksStartAsyncReplicationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.startAsyncReplication", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksStopAsyncReplicationCall struct {
	s          *Service
	project    string
	region     string
	disk       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// StopAsyncReplication: Stops asynchronous replication.
// Can be invoked either on the primary or on the secondary disk.
//
// - disk: The name of the persistent disk.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) StopAsyncReplication(project string, region string, disk string) *RegionDisksStopAsyncReplicationCall {
	c := &RegionDisksStopAsyncReplicationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksStopAsyncReplicationCall) RequestId(requestId string) *RegionDisksStopAsyncReplicationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksStopAsyncReplicationCall) Fields(s ...googleapi.Field) *RegionDisksStopAsyncReplicationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksStopAsyncReplicationCall) Context(ctx context.Context) *RegionDisksStopAsyncReplicationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksStopAsyncReplicationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksStopAsyncReplicationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/stopAsyncReplication")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.stopAsyncReplication", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.stopAsyncReplication" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksStopAsyncReplicationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.stopAsyncReplication", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksStopGroupAsyncReplicationCall struct {
	s                                      *Service
	project                                string
	region                                 string
	disksstopgroupasyncreplicationresource *DisksStopGroupAsyncReplicationResource
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// StopGroupAsyncReplication: Stops asynchronous replication for a consistency
// group of disks.
// Can be invoked either in the primary or secondary scope.
//
//   - project: Project ID for this request.
//   - region: The name of the region for this request. This must be the region
//     of the
//
// primary or secondary disks in the consistency group.
func (r *RegionDisksService) StopGroupAsyncReplication(project string, region string, disksstopgroupasyncreplicationresource *DisksStopGroupAsyncReplicationResource) *RegionDisksStopGroupAsyncReplicationCall {
	c := &RegionDisksStopGroupAsyncReplicationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disksstopgroupasyncreplicationresource = disksstopgroupasyncreplicationresource
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksStopGroupAsyncReplicationCall) RequestId(requestId string) *RegionDisksStopGroupAsyncReplicationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksStopGroupAsyncReplicationCall) Fields(s ...googleapi.Field) *RegionDisksStopGroupAsyncReplicationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksStopGroupAsyncReplicationCall) Context(ctx context.Context) *RegionDisksStopGroupAsyncReplicationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksStopGroupAsyncReplicationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksStopGroupAsyncReplicationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.disksstopgroupasyncreplicationresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/stopGroupAsyncReplication")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.stopGroupAsyncReplication", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.stopGroupAsyncReplication" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksStopGroupAsyncReplicationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.stopGroupAsyncReplication", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionDisksService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionDisksTestIamPermissionsCall {
	c := &RegionDisksTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionDisksTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksTestIamPermissionsCall) Context(ctx context.Context) *RegionDisksTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionDisksTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksUpdateCall struct {
	s          *Service
	project    string
	region     string
	disk       string
	disk2      *Disk
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Update the specified disk with the data included in the request.
// Update is
// performed only on selected fields included as part of update-mask. Only
// the
// following fields can be modified: user_license.
//
// - disk: The disk name for this request.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) Update(project string, region string, disk string, disk2 *Disk) *RegionDisksUpdateCall {
	c := &RegionDisksUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.disk2 = disk2
	return c
}

// Paths sets the optional parameter "paths":
func (c *RegionDisksUpdateCall) Paths(paths ...string) *RegionDisksUpdateCall {
	c.urlParams_.SetMulti("paths", append([]string{}, paths...))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksUpdateCall) RequestId(requestId string) *RegionDisksUpdateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": update_mask indicates
// fields to be updated as part of this request.
func (c *RegionDisksUpdateCall) UpdateMask(updateMask string) *RegionDisksUpdateCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksUpdateCall) Fields(s ...googleapi.Field) *RegionDisksUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksUpdateCall) Context(ctx context.Context) *RegionDisksUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.disk2)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksUpdateKmsKeyCall struct {
	s          *Service
	project    string
	region     string
	disk       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateKmsKey: Rotates the customer-managed
// encryption key to the latest version for the specified persistent disk.
//
// - disk: Name of the Disk resource, should conform to RFC1035.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionDisksService) UpdateKmsKey(project string, region string, disk string) *RegionDisksUpdateKmsKeyCall {
	c := &RegionDisksUpdateKmsKeyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksUpdateKmsKeyCall) RequestId(requestId string) *RegionDisksUpdateKmsKeyCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksUpdateKmsKeyCall) Fields(s ...googleapi.Field) *RegionDisksUpdateKmsKeyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksUpdateKmsKeyCall) Context(ctx context.Context) *RegionDisksUpdateKmsKeyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksUpdateKmsKeyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksUpdateKmsKeyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/updateKmsKey")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.updateKmsKey", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.updateKmsKey" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksUpdateKmsKeyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.updateKmsKey", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionDisksWaitForReplicationCatchUpCall struct {
	s                                      *Service
	project                                string
	region                                 string
	disk                                   string
	regionwaitforreplicationcatchuprequest *RegionWaitForReplicationCatchUpRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// WaitForReplicationCatchUp: Wait for replication to catch up on the secondary
// disk.
//
//   - disk: The name of the persistent disk.
//     Name should conform to RFC1035 or be an unsigned long integer.
//   - project: Project ID for this request.
//   - region: Name of the region for this request.
func (r *RegionDisksService) WaitForReplicationCatchUp(project string, region string, disk string, regionwaitforreplicationcatchuprequest *RegionWaitForReplicationCatchUpRequest) *RegionDisksWaitForReplicationCatchUpCall {
	c := &RegionDisksWaitForReplicationCatchUpCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.disk = disk
	c.regionwaitforreplicationcatchuprequest = regionwaitforreplicationcatchuprequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionDisksWaitForReplicationCatchUpCall) RequestId(requestId string) *RegionDisksWaitForReplicationCatchUpCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionDisksWaitForReplicationCatchUpCall) Fields(s ...googleapi.Field) *RegionDisksWaitForReplicationCatchUpCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionDisksWaitForReplicationCatchUpCall) Context(ctx context.Context) *RegionDisksWaitForReplicationCatchUpCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionDisksWaitForReplicationCatchUpCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionDisksWaitForReplicationCatchUpCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionwaitforreplicationcatchuprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/disks/{disk}/waitForReplicationCatchUp")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"disk":    c.disk,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionDisks.waitForReplicationCatchUp", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionDisks.waitForReplicationCatchUp" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionDisksWaitForReplicationCatchUpCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionDisks.waitForReplicationCatchUp", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthAggregationPoliciesAggregatedListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AggregatedList: Retrieves the list of all HealthAggregationPolicy
// resources,
// regional and global, available to the specified project.
//
// To prevent failure, it is recommended that you set
// the
// `returnPartialSuccess` parameter to `true`.
//
// - project: Name of the project scoping this request.
func (r *RegionHealthAggregationPoliciesService) AggregatedList(project string) *RegionHealthAggregationPoliciesAggregatedListCall {
	c := &RegionHealthAggregationPoliciesAggregatedListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) Filter(filter string) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IncludeAllScopes sets the optional parameter "includeAllScopes": Indicates
// whether every visible scope for each scope type (zone, region,
// global) should be included in the response. For new resource types
// added
// after this field, the flag has no effect as new resource types will
// always
// include every visible scope for each scope type in response. For
// resource
// types which predate this field, if this flag is omitted or false,
// only
// scopes of the scope types where the resource type is expected to be
// found
// will be included.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) IncludeAllScopes(includeAllScopes bool) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("includeAllScopes", fmt.Sprint(includeAllScopes))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthAggregationPoliciesAggregatedListCall) MaxResults(maxResults int64) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) OrderBy(orderBy string) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) PageToken(pageToken string) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// ServiceProjectNumber sets the optional parameter "serviceProjectNumber": The
// Shared VPC service project id or service project number for which
// aggregated list request is invoked for subnetworks list-usable api.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) ServiceProjectNumber(serviceProjectNumber int64) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("serviceProjectNumber", fmt.Sprint(serviceProjectNumber))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) IfNoneMatch(entityTag string) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesAggregatedListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesAggregatedListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/aggregated/healthAggregationPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.aggregatedList", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.aggregatedList" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthAggregationPolicyAggregatedList.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) Do(opts ...googleapi.CallOption) (*HealthAggregationPolicyAggregatedList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthAggregationPolicyAggregatedList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.aggregatedList", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthAggregationPoliciesAggregatedListCall) Pages(ctx context.Context, f func(*HealthAggregationPolicyAggregatedList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthAggregationPoliciesDeleteCall struct {
	s                       *Service
	project                 string
	region                  string
	healthAggregationPolicy string
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Delete: Deletes the specified HealthAggregationPolicy in the given region.
//
//   - healthAggregationPolicy: Name of the HealthAggregationPolicy resource to
//     delete.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
func (r *RegionHealthAggregationPoliciesService) Delete(project string, region string, healthAggregationPolicy string) *RegionHealthAggregationPoliciesDeleteCall {
	c := &RegionHealthAggregationPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthAggregationPolicy = healthAggregationPolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthAggregationPoliciesDeleteCall) RequestId(requestId string) *RegionHealthAggregationPoliciesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesDeleteCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesDeleteCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthAggregationPolicies/{healthAggregationPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":                 c.project,
		"region":                  c.region,
		"healthAggregationPolicy": c.healthAggregationPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthAggregationPoliciesGetCall struct {
	s                       *Service
	project                 string
	region                  string
	healthAggregationPolicy string
	urlParams_              gensupport.URLParams
	ifNoneMatch_            string
	ctx_                    context.Context
	header_                 http.Header
}

// Get: Returns the specified HealthAggregationPolicy resource in the given
// region.
//
//   - healthAggregationPolicy: Name of the HealthAggregationPolicy resource to
//     return.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
func (r *RegionHealthAggregationPoliciesService) Get(project string, region string, healthAggregationPolicy string) *RegionHealthAggregationPoliciesGetCall {
	c := &RegionHealthAggregationPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthAggregationPolicy = healthAggregationPolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesGetCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthAggregationPoliciesGetCall) IfNoneMatch(entityTag string) *RegionHealthAggregationPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesGetCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthAggregationPolicies/{healthAggregationPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":                 c.project,
		"region":                  c.region,
		"healthAggregationPolicy": c.healthAggregationPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthAggregationPolicy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesGetCall) Do(opts ...googleapi.CallOption) (*HealthAggregationPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthAggregationPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthAggregationPoliciesInsertCall struct {
	s                       *Service
	project                 string
	region                  string
	healthaggregationpolicy *HealthAggregationPolicy
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Insert: Create a HealthAggregationPolicy in the specified project in the
// given
// region using the parameters that are included in the request.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthAggregationPoliciesService) Insert(project string, region string, healthaggregationpolicy *HealthAggregationPolicy) *RegionHealthAggregationPoliciesInsertCall {
	c := &RegionHealthAggregationPoliciesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthaggregationpolicy = healthaggregationpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthAggregationPoliciesInsertCall) RequestId(requestId string) *RegionHealthAggregationPoliciesInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesInsertCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesInsertCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthaggregationpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthAggregationPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthAggregationPoliciesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the HealthAggregationPolicies for a project in the given region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthAggregationPoliciesService) List(project string, region string) *RegionHealthAggregationPoliciesListCall {
	c := &RegionHealthAggregationPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthAggregationPoliciesListCall) Filter(filter string) *RegionHealthAggregationPoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthAggregationPoliciesListCall) MaxResults(maxResults int64) *RegionHealthAggregationPoliciesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthAggregationPoliciesListCall) OrderBy(orderBy string) *RegionHealthAggregationPoliciesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthAggregationPoliciesListCall) PageToken(pageToken string) *RegionHealthAggregationPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthAggregationPoliciesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthAggregationPoliciesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesListCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthAggregationPoliciesListCall) IfNoneMatch(entityTag string) *RegionHealthAggregationPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesListCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthAggregationPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthAggregationPolicyList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesListCall) Do(opts ...googleapi.CallOption) (*HealthAggregationPolicyList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthAggregationPolicyList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthAggregationPoliciesListCall) Pages(ctx context.Context, f func(*HealthAggregationPolicyList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthAggregationPoliciesPatchCall struct {
	s                       *Service
	project                 string
	region                  string
	healthAggregationPolicy string
	healthaggregationpolicy *HealthAggregationPolicy
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Patch: Updates the specified regional HealthAggregationPolicy
// resource with the data included in the request. This method
// supportsPATCH
// semantics and uses theJSON merge
// patch format and processing rules.
//
//   - healthAggregationPolicy: Name of the HealthAggregationPolicy to update.
//     The name
//
// must be 1-63 characters long, and comply with RFC1035.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthAggregationPoliciesService) Patch(project string, region string, healthAggregationPolicy string, healthaggregationpolicy *HealthAggregationPolicy) *RegionHealthAggregationPoliciesPatchCall {
	c := &RegionHealthAggregationPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthAggregationPolicy = healthAggregationPolicy
	c.healthaggregationpolicy = healthaggregationpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthAggregationPoliciesPatchCall) RequestId(requestId string) *RegionHealthAggregationPoliciesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesPatchCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesPatchCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthaggregationpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthAggregationPolicies/{healthAggregationPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":                 c.project,
		"region":                  c.region,
		"healthAggregationPolicy": c.healthAggregationPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthAggregationPoliciesTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionHealthAggregationPoliciesService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionHealthAggregationPoliciesTestIamPermissionsCall {
	c := &RegionHealthAggregationPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthAggregationPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionHealthAggregationPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthAggregationPoliciesTestIamPermissionsCall) Context(ctx context.Context) *RegionHealthAggregationPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthAggregationPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthAggregationPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthAggregationPolicies/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthAggregationPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthAggregationPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthAggregationPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthCheckServicesAggregatedListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AggregatedList: Retrieves the list of all HealthCheckService
// resources,
// regional and global, available to the specified project.
//
// To prevent failure, it is recommended that you set
// the
// `returnPartialSuccess` parameter to `true`.
//
// - project: Name of the project scoping this request.
func (r *RegionHealthCheckServicesService) AggregatedList(project string) *RegionHealthCheckServicesAggregatedListCall {
	c := &RegionHealthCheckServicesAggregatedListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthCheckServicesAggregatedListCall) Filter(filter string) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IncludeAllScopes sets the optional parameter "includeAllScopes": Indicates
// whether every visible scope for each scope type (zone, region,
// global) should be included in the response. For new resource types
// added
// after this field, the flag has no effect as new resource types will
// always
// include every visible scope for each scope type in response. For
// resource
// types which predate this field, if this flag is omitted or false,
// only
// scopes of the scope types where the resource type is expected to be
// found
// will be included.
func (c *RegionHealthCheckServicesAggregatedListCall) IncludeAllScopes(includeAllScopes bool) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("includeAllScopes", fmt.Sprint(includeAllScopes))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthCheckServicesAggregatedListCall) MaxResults(maxResults int64) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthCheckServicesAggregatedListCall) OrderBy(orderBy string) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthCheckServicesAggregatedListCall) PageToken(pageToken string) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthCheckServicesAggregatedListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// ServiceProjectNumber sets the optional parameter "serviceProjectNumber": The
// Shared VPC service project id or service project number for which
// aggregated list request is invoked for subnetworks list-usable api.
func (c *RegionHealthCheckServicesAggregatedListCall) ServiceProjectNumber(serviceProjectNumber int64) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("serviceProjectNumber", fmt.Sprint(serviceProjectNumber))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesAggregatedListCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesAggregatedListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthCheckServicesAggregatedListCall) IfNoneMatch(entityTag string) *RegionHealthCheckServicesAggregatedListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesAggregatedListCall) Context(ctx context.Context) *RegionHealthCheckServicesAggregatedListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesAggregatedListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesAggregatedListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/aggregated/healthCheckServices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.aggregatedList", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.aggregatedList" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthCheckServiceAggregatedList.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthCheckServicesAggregatedListCall) Do(opts ...googleapi.CallOption) (*HealthCheckServiceAggregatedList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthCheckServiceAggregatedList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.aggregatedList", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthCheckServicesAggregatedListCall) Pages(ctx context.Context, f func(*HealthCheckServiceAggregatedList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthCheckServicesDeleteCall struct {
	s                  *Service
	project            string
	region             string
	healthCheckService string
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Delete: Deletes the specified regional HealthCheckService.
//
//   - healthCheckService: Name of the HealthCheckService to delete. The
//     name
//
// must be 1-63 characters long, and comply with RFC1035.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthCheckServicesService) Delete(project string, region string, healthCheckService string) *RegionHealthCheckServicesDeleteCall {
	c := &RegionHealthCheckServicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheckService = healthCheckService
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthCheckServicesDeleteCall) RequestId(requestId string) *RegionHealthCheckServicesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesDeleteCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesDeleteCall) Context(ctx context.Context) *RegionHealthCheckServicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":            c.project,
		"region":             c.region,
		"healthCheckService": c.healthCheckService,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthCheckServicesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthCheckServicesGetCall struct {
	s                  *Service
	project            string
	region             string
	healthCheckService string
	urlParams_         gensupport.URLParams
	ifNoneMatch_       string
	ctx_               context.Context
	header_            http.Header
}

// Get: Returns the specified regional HealthCheckService resource.
//
//   - healthCheckService: Name of the HealthCheckService to update. The
//     name
//
// must be 1-63 characters long, and comply with RFC1035.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthCheckServicesService) Get(project string, region string, healthCheckService string) *RegionHealthCheckServicesGetCall {
	c := &RegionHealthCheckServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheckService = healthCheckService
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesGetCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthCheckServicesGetCall) IfNoneMatch(entityTag string) *RegionHealthCheckServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesGetCall) Context(ctx context.Context) *RegionHealthCheckServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":            c.project,
		"region":             c.region,
		"healthCheckService": c.healthCheckService,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthCheckService.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionHealthCheckServicesGetCall) Do(opts ...googleapi.CallOption) (*HealthCheckService, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthCheckService{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthCheckServicesInsertCall struct {
	s                  *Service
	project            string
	region             string
	healthcheckservice *HealthCheckService
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Insert: Creates a regional HealthCheckService resource in the
// specified project and region using the data included in the request.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthCheckServicesService) Insert(project string, region string, healthcheckservice *HealthCheckService) *RegionHealthCheckServicesInsertCall {
	c := &RegionHealthCheckServicesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthcheckservice = healthcheckservice
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthCheckServicesInsertCall) RequestId(requestId string) *RegionHealthCheckServicesInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesInsertCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesInsertCall) Context(ctx context.Context) *RegionHealthCheckServicesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthcheckservice)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthCheckServices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthCheckServicesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthCheckServicesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the HealthCheckService resources that have been
// configured for the specified project in the given region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthCheckServicesService) List(project string, region string) *RegionHealthCheckServicesListCall {
	c := &RegionHealthCheckServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthCheckServicesListCall) Filter(filter string) *RegionHealthCheckServicesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthCheckServicesListCall) MaxResults(maxResults int64) *RegionHealthCheckServicesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthCheckServicesListCall) OrderBy(orderBy string) *RegionHealthCheckServicesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthCheckServicesListCall) PageToken(pageToken string) *RegionHealthCheckServicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthCheckServicesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthCheckServicesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesListCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthCheckServicesListCall) IfNoneMatch(entityTag string) *RegionHealthCheckServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesListCall) Context(ctx context.Context) *RegionHealthCheckServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthCheckServices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthCheckServicesList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthCheckServicesListCall) Do(opts ...googleapi.CallOption) (*HealthCheckServicesList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthCheckServicesList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthCheckServicesListCall) Pages(ctx context.Context, f func(*HealthCheckServicesList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthCheckServicesPatchCall struct {
	s                  *Service
	project            string
	region             string
	healthCheckService string
	healthcheckservice *HealthCheckService
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Patch: Updates the specified regional HealthCheckService resource
// with the data included in the request.  This method supportsPATCH
// semantics and uses theJSON merge
// patch format and processing rules.
//
//   - healthCheckService: Name of the HealthCheckService to update. The
//     name
//
// must be 1-63 characters long, and comply with RFC1035.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthCheckServicesService) Patch(project string, region string, healthCheckService string, healthcheckservice *HealthCheckService) *RegionHealthCheckServicesPatchCall {
	c := &RegionHealthCheckServicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheckService = healthCheckService
	c.healthcheckservice = healthcheckservice
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthCheckServicesPatchCall) RequestId(requestId string) *RegionHealthCheckServicesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesPatchCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesPatchCall) Context(ctx context.Context) *RegionHealthCheckServicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthcheckservice)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":            c.project,
		"region":             c.region,
		"healthCheckService": c.healthCheckService,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthCheckServicesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthCheckServicesTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionHealthCheckServicesService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionHealthCheckServicesTestIamPermissionsCall {
	c := &RegionHealthCheckServicesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthCheckServicesTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionHealthCheckServicesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthCheckServicesTestIamPermissionsCall) Context(ctx context.Context) *RegionHealthCheckServicesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthCheckServicesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthCheckServicesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthCheckServices/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthCheckServices.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthCheckServicesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthCheckServices.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthChecksDeleteCall struct {
	s           *Service
	project     string
	region      string
	healthCheck string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes the specified HealthCheck resource.
//
// - healthCheck: Name of the HealthCheck resource to delete.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthChecksService) Delete(project string, region string, healthCheck string) *RegionHealthChecksDeleteCall {
	c := &RegionHealthChecksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheck = healthCheck
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthChecksDeleteCall) RequestId(requestId string) *RegionHealthChecksDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksDeleteCall) Fields(s ...googleapi.Field) *RegionHealthChecksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksDeleteCall) Context(ctx context.Context) *RegionHealthChecksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks/{healthCheck}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":     c.project,
		"region":      c.region,
		"healthCheck": c.healthCheck,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthChecksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthChecksGetCall struct {
	s            *Service
	project      string
	region       string
	healthCheck  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the specified HealthCheck resource.
//
// - healthCheck: Name of the HealthCheck resource to return.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthChecksService) Get(project string, region string, healthCheck string) *RegionHealthChecksGetCall {
	c := &RegionHealthChecksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheck = healthCheck
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksGetCall) Fields(s ...googleapi.Field) *RegionHealthChecksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthChecksGetCall) IfNoneMatch(entityTag string) *RegionHealthChecksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksGetCall) Context(ctx context.Context) *RegionHealthChecksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks/{healthCheck}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":     c.project,
		"region":      c.region,
		"healthCheck": c.healthCheck,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthCheck.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthChecksGetCall) Do(opts ...googleapi.CallOption) (*HealthCheck, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthCheck{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthChecksInsertCall struct {
	s           *Service
	project     string
	region      string
	healthcheck *HealthCheck
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Insert: Creates a HealthCheck resource in the specified project using the
// data
// included in the request.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthChecksService) Insert(project string, region string, healthcheck *HealthCheck) *RegionHealthChecksInsertCall {
	c := &RegionHealthChecksInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthcheck = healthcheck
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthChecksInsertCall) RequestId(requestId string) *RegionHealthChecksInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksInsertCall) Fields(s ...googleapi.Field) *RegionHealthChecksInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksInsertCall) Context(ctx context.Context) *RegionHealthChecksInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthcheck)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthChecksInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthChecksListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of HealthCheck resources available to the
// specified
// project.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthChecksService) List(project string, region string) *RegionHealthChecksListCall {
	c := &RegionHealthChecksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthChecksListCall) Filter(filter string) *RegionHealthChecksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthChecksListCall) MaxResults(maxResults int64) *RegionHealthChecksListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthChecksListCall) OrderBy(orderBy string) *RegionHealthChecksListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthChecksListCall) PageToken(pageToken string) *RegionHealthChecksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthChecksListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthChecksListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksListCall) Fields(s ...googleapi.Field) *RegionHealthChecksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthChecksListCall) IfNoneMatch(entityTag string) *RegionHealthChecksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksListCall) Context(ctx context.Context) *RegionHealthChecksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthCheckList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionHealthChecksListCall) Do(opts ...googleapi.CallOption) (*HealthCheckList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthCheckList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthChecksListCall) Pages(ctx context.Context, f func(*HealthCheckList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthChecksPatchCall struct {
	s           *Service
	project     string
	region      string
	healthCheck string
	healthcheck *HealthCheck
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates a HealthCheck resource in the specified project using the
// data
// included in the request. This method supportsPATCH
// semantics and uses theJSON merge
// patch format and processing rules.
//
// - healthCheck: Name of the HealthCheck resource to patch.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthChecksService) Patch(project string, region string, healthCheck string, healthcheck *HealthCheck) *RegionHealthChecksPatchCall {
	c := &RegionHealthChecksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheck = healthCheck
	c.healthcheck = healthcheck
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthChecksPatchCall) RequestId(requestId string) *RegionHealthChecksPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksPatchCall) Fields(s ...googleapi.Field) *RegionHealthChecksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksPatchCall) Context(ctx context.Context) *RegionHealthChecksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthcheck)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks/{healthCheck}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":     c.project,
		"region":      c.region,
		"healthCheck": c.healthCheck,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthChecksPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthChecksTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionHealthChecksService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionHealthChecksTestIamPermissionsCall {
	c := &RegionHealthChecksTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionHealthChecksTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksTestIamPermissionsCall) Context(ctx context.Context) *RegionHealthChecksTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthChecksTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthChecksUpdateCall struct {
	s           *Service
	project     string
	region      string
	healthCheck string
	healthcheck *HealthCheck
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Update: Updates a HealthCheck resource in the specified project using the
// data
// included in the request.
//
// - healthCheck: Name of the HealthCheck resource to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthChecksService) Update(project string, region string, healthCheck string, healthcheck *HealthCheck) *RegionHealthChecksUpdateCall {
	c := &RegionHealthChecksUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthCheck = healthCheck
	c.healthcheck = healthcheck
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthChecksUpdateCall) RequestId(requestId string) *RegionHealthChecksUpdateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthChecksUpdateCall) Fields(s ...googleapi.Field) *RegionHealthChecksUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthChecksUpdateCall) Context(ctx context.Context) *RegionHealthChecksUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthChecksUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthChecksUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthcheck)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthChecks/{healthCheck}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":     c.project,
		"region":      c.region,
		"healthCheck": c.healthCheck,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthChecks.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthChecksUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthChecks.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthSourcesAggregatedListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AggregatedList: Retrieves the list of all HealthSource resources
// (all
// regional) available to the specified project.
//
// To prevent failure, Google recommends that you set
// the
// `returnPartialSuccess` parameter to `true`.
//
// - project: Name of the project scoping this request.
func (r *RegionHealthSourcesService) AggregatedList(project string) *RegionHealthSourcesAggregatedListCall {
	c := &RegionHealthSourcesAggregatedListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthSourcesAggregatedListCall) Filter(filter string) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IncludeAllScopes sets the optional parameter "includeAllScopes": Indicates
// whether every visible scope for each scope type (zone, region,
// global) should be included in the response. For new resource types
// added
// after this field, the flag has no effect as new resource types will
// always
// include every visible scope for each scope type in response. For
// resource
// types which predate this field, if this flag is omitted or false,
// only
// scopes of the scope types where the resource type is expected to be
// found
// will be included.
func (c *RegionHealthSourcesAggregatedListCall) IncludeAllScopes(includeAllScopes bool) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("includeAllScopes", fmt.Sprint(includeAllScopes))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthSourcesAggregatedListCall) MaxResults(maxResults int64) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthSourcesAggregatedListCall) OrderBy(orderBy string) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthSourcesAggregatedListCall) PageToken(pageToken string) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthSourcesAggregatedListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// ServiceProjectNumber sets the optional parameter "serviceProjectNumber": The
// Shared VPC service project id or service project number for which
// aggregated list request is invoked for subnetworks list-usable api.
func (c *RegionHealthSourcesAggregatedListCall) ServiceProjectNumber(serviceProjectNumber int64) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("serviceProjectNumber", fmt.Sprint(serviceProjectNumber))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesAggregatedListCall) Fields(s ...googleapi.Field) *RegionHealthSourcesAggregatedListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthSourcesAggregatedListCall) IfNoneMatch(entityTag string) *RegionHealthSourcesAggregatedListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesAggregatedListCall) Context(ctx context.Context) *RegionHealthSourcesAggregatedListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesAggregatedListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesAggregatedListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/aggregated/healthSources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.aggregatedList", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.aggregatedList" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthSourceAggregatedList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthSourcesAggregatedListCall) Do(opts ...googleapi.CallOption) (*HealthSourceAggregatedList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthSourceAggregatedList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.aggregatedList", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthSourcesAggregatedListCall) Pages(ctx context.Context, f func(*HealthSourceAggregatedList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthSourcesDeleteCall struct {
	s            *Service
	project      string
	region       string
	healthSource string
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Delete: Deletes the specified HealthSource in the given region
//
// - healthSource: Name of the HealthSource resource to delete.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthSourcesService) Delete(project string, region string, healthSource string) *RegionHealthSourcesDeleteCall {
	c := &RegionHealthSourcesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthSource = healthSource
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthSourcesDeleteCall) RequestId(requestId string) *RegionHealthSourcesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesDeleteCall) Fields(s ...googleapi.Field) *RegionHealthSourcesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesDeleteCall) Context(ctx context.Context) *RegionHealthSourcesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthSources/{healthSource}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"region":       c.region,
		"healthSource": c.healthSource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthSourcesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthSourcesGetCall struct {
	s            *Service
	project      string
	region       string
	healthSource string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the specified HealthSource resource in the given region.
//
// - healthSource: Name of the HealthSource resource to return.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthSourcesService) Get(project string, region string, healthSource string) *RegionHealthSourcesGetCall {
	c := &RegionHealthSourcesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthSource = healthSource
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesGetCall) Fields(s ...googleapi.Field) *RegionHealthSourcesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthSourcesGetCall) IfNoneMatch(entityTag string) *RegionHealthSourcesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesGetCall) Context(ctx context.Context) *RegionHealthSourcesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthSources/{healthSource}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"region":       c.region,
		"healthSource": c.healthSource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthSource.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthSourcesGetCall) Do(opts ...googleapi.CallOption) (*HealthSource, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthSource{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthSourcesInsertCall struct {
	s            *Service
	project      string
	region       string
	healthsource *HealthSource
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Insert: Create a HealthSource in the specified project in the given
// region
// using the parameters that are included in the request.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthSourcesService) Insert(project string, region string, healthsource *HealthSource) *RegionHealthSourcesInsertCall {
	c := &RegionHealthSourcesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthsource = healthsource
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthSourcesInsertCall) RequestId(requestId string) *RegionHealthSourcesInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesInsertCall) Fields(s ...googleapi.Field) *RegionHealthSourcesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesInsertCall) Context(ctx context.Context) *RegionHealthSourcesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthsource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthSources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthSourcesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthSourcesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the HealthSources for a project in the given region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionHealthSourcesService) List(project string, region string) *RegionHealthSourcesListCall {
	c := &RegionHealthSourcesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionHealthSourcesListCall) Filter(filter string) *RegionHealthSourcesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionHealthSourcesListCall) MaxResults(maxResults int64) *RegionHealthSourcesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionHealthSourcesListCall) OrderBy(orderBy string) *RegionHealthSourcesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionHealthSourcesListCall) PageToken(pageToken string) *RegionHealthSourcesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionHealthSourcesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionHealthSourcesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesListCall) Fields(s ...googleapi.Field) *RegionHealthSourcesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionHealthSourcesListCall) IfNoneMatch(entityTag string) *RegionHealthSourcesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesListCall) Context(ctx context.Context) *RegionHealthSourcesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthSources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *HealthSourceList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionHealthSourcesListCall) Do(opts ...googleapi.CallOption) (*HealthSourceList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &HealthSourceList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionHealthSourcesListCall) Pages(ctx context.Context, f func(*HealthSourceList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionHealthSourcesPatchCall struct {
	s            *Service
	project      string
	region       string
	healthSource string
	healthsource *HealthSource
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Updates the specified regional HealthSource resource
// with the data included in the request.  This method supportsPATCH
// semantics and uses theJSON merge
// patch format and processing rules.
//
//   - healthSource: Name of the HealthSource to update. The name
//     must be 1-63 characters long, and comply with RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
func (r *RegionHealthSourcesService) Patch(project string, region string, healthSource string, healthsource *HealthSource) *RegionHealthSourcesPatchCall {
	c := &RegionHealthSourcesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.healthSource = healthSource
	c.healthsource = healthsource
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionHealthSourcesPatchCall) RequestId(requestId string) *RegionHealthSourcesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesPatchCall) Fields(s ...googleapi.Field) *RegionHealthSourcesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesPatchCall) Context(ctx context.Context) *RegionHealthSourcesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.healthsource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthSources/{healthSource}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":      c.project,
		"region":       c.region,
		"healthSource": c.healthSource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionHealthSourcesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionHealthSourcesTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionHealthSourcesService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionHealthSourcesTestIamPermissionsCall {
	c := &RegionHealthSourcesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionHealthSourcesTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionHealthSourcesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionHealthSourcesTestIamPermissionsCall) Context(ctx context.Context) *RegionHealthSourcesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionHealthSourcesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionHealthSourcesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/healthSources/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionHealthSources.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionHealthSources.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionHealthSourcesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionHealthSources.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagerResizeRequestsCancelCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	resizeRequest        string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Cancel: Cancels the specified resize request.
// Cancelled resize request no longer waits for the resources to
// be
// provisioned. Cancel is only possible for requests that are in
// accepted
// state.
//
//   - instanceGroupManager: The name of the managed instance group.
//     Name should conform to RFC1035 or be a resource ID.
//   - project: Project ID for this request.
//   - region: The name of the region
//     scoping this request. Name should conform to RFC1035.
//   - resizeRequest: The name of the resize request to cancel.
//     Name should conform to RFC1035 or be a resource ID.
func (r *RegionInstanceGroupManagerResizeRequestsService) Cancel(project string, region string, instanceGroupManager string, resizeRequest string) *RegionInstanceGroupManagerResizeRequestsCancelCall {
	c := &RegionInstanceGroupManagerResizeRequestsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.resizeRequest = resizeRequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagerResizeRequestsCancelCall) RequestId(requestId string) *RegionInstanceGroupManagerResizeRequestsCancelCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagerResizeRequestsCancelCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagerResizeRequestsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagerResizeRequestsCancelCall) Context(ctx context.Context) *RegionInstanceGroupManagerResizeRequestsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagerResizeRequestsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagerResizeRequestsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}/cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
		"resizeRequest":        c.resizeRequest,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagerResizeRequests.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagerResizeRequestsCancelCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagerResizeRequestsDeleteCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	resizeRequest        string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Delete: Deletes the specified, inactive resize request. Requests that are
// still
// active cannot be deleted. Deleting request does not delete instances
// that
// were provisioned previously.
//
//   - instanceGroupManager: The name of the managed instance group.
//     Name should conform to RFC1035 or be a resource ID.
//   - project: Project ID for this request.
//   - region: The name of the region
//     scoping this request. Name should conform to RFC1035.
//   - resizeRequest: The name of the resize request to delete.
//     Name should conform to RFC1035 or be a resource ID.
func (r *RegionInstanceGroupManagerResizeRequestsService) Delete(project string, region string, instanceGroupManager string, resizeRequest string) *RegionInstanceGroupManagerResizeRequestsDeleteCall {
	c := &RegionInstanceGroupManagerResizeRequestsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.resizeRequest = resizeRequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagerResizeRequestsDeleteCall) RequestId(requestId string) *RegionInstanceGroupManagerResizeRequestsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagerResizeRequestsDeleteCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagerResizeRequestsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagerResizeRequestsDeleteCall) Context(ctx context.Context) *RegionInstanceGroupManagerResizeRequestsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagerResizeRequestsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagerResizeRequestsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
		"resizeRequest":        c.resizeRequest,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagerResizeRequests.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagerResizeRequestsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagerResizeRequestsGetCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	resizeRequest        string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// Get: Returns all of the details about the specified resize request.
//
//   - instanceGroupManager: The name of the managed instance group.
//     Name should conform to RFC1035 or be a resource ID.
//   - project: Project ID for this request.
//   - region: The name of the region
//     scoping this request. Name should conform to RFC1035.
//   - resizeRequest: The name of the resize request.
//     Name should conform to RFC1035 or be a resource ID.
func (r *RegionInstanceGroupManagerResizeRequestsService) Get(project string, region string, instanceGroupManager string, resizeRequest string) *RegionInstanceGroupManagerResizeRequestsGetCall {
	c := &RegionInstanceGroupManagerResizeRequestsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.resizeRequest = resizeRequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagerResizeRequestsGetCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagerResizeRequestsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupManagerResizeRequestsGetCall) IfNoneMatch(entityTag string) *RegionInstanceGroupManagerResizeRequestsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagerResizeRequestsGetCall) Context(ctx context.Context) *RegionInstanceGroupManagerResizeRequestsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagerResizeRequestsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagerResizeRequestsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
		"resizeRequest":        c.resizeRequest,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagerResizeRequests.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstanceGroupManagerResizeRequest.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagerResizeRequestsGetCall) Do(opts ...googleapi.CallOption) (*InstanceGroupManagerResizeRequest, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstanceGroupManagerResizeRequest{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagerResizeRequestsInsertCall struct {
	s                                 *Service
	project                           string
	region                            string
	instanceGroupManager              string
	instancegroupmanagerresizerequest *InstanceGroupManagerResizeRequest
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Insert: Creates a new Resize Request that starts provisioning VMs
// immediately
// or queues VM creation.
//
//   - instanceGroupManager: Name of the managed instance group to which the
//     resize request is scoped.
//     Name should conform to RFC1035 or be a resource ID.
//   - project: Project ID for this request.
//   - region: Name of the region
//     scoping this request. Name should conform to RFC1035.
func (r *RegionInstanceGroupManagerResizeRequestsService) Insert(project string, region string, instanceGroupManager string, instancegroupmanagerresizerequest *InstanceGroupManagerResizeRequest) *RegionInstanceGroupManagerResizeRequestsInsertCall {
	c := &RegionInstanceGroupManagerResizeRequestsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.instancegroupmanagerresizerequest = instancegroupmanagerresizerequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagerResizeRequestsInsertCall) RequestId(requestId string) *RegionInstanceGroupManagerResizeRequestsInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagerResizeRequestsInsertCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagerResizeRequestsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagerResizeRequestsInsertCall) Context(ctx context.Context) *RegionInstanceGroupManagerResizeRequestsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagerResizeRequestsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagerResizeRequestsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancegroupmanagerresizerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagerResizeRequests.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagerResizeRequestsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagerResizeRequestsListCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// List: Retrieves a list of Resize Requests that are contained in the
// managed instance group.
//
//   - instanceGroupManager: The name of the managed instance group. The name
//     should conform to RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region
//     scoping this request. Name should conform to RFC1035.
func (r *RegionInstanceGroupManagerResizeRequestsService) List(project string, region string, instanceGroupManager string) *RegionInstanceGroupManagerResizeRequestsListCall {
	c := &RegionInstanceGroupManagerResizeRequestsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) Filter(filter string) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupManagerResizeRequestsListCall) MaxResults(maxResults int64) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) OrderBy(orderBy string) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) PageToken(pageToken string) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) IfNoneMatch(entityTag string) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) Context(ctx context.Context) *RegionInstanceGroupManagerResizeRequestsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagerResizeRequestsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeRequests")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagerResizeRequests.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupManagerResizeRequestsListResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupManagerResizeRequestsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupManagerResizeRequestsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagerResizeRequests.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupManagerResizeRequestsListCall) Pages(ctx context.Context, f func(*RegionInstanceGroupManagerResizeRequestsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupManagersAbandonInstancesCall struct {
	s                                                  *Service
	project                                            string
	region                                             string
	instanceGroupManager                               string
	regioninstancegroupmanagersabandoninstancesrequest *RegionInstanceGroupManagersAbandonInstancesRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// AbandonInstances: Flags the specified instances to be immediately removed
// from the managed
// instance group. Abandoning an instance does not delete the
// instance, but it does remove the instance from any target pools that
// are
// applied by the managed instance group. This method reduces thetargetSize of
// the managed instance group by the
// number of instances that you abandon. This operation is marked asDONE when
// the action is scheduled even if the instances have
// not yet been removed from the group. You must separately verify the
// status of the abandoning action with thelistmanagedinstances
// method.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is removed or
// deleted.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) AbandonInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersabandoninstancesrequest *RegionInstanceGroupManagersAbandonInstancesRequest) *RegionInstanceGroupManagersAbandonInstancesCall {
	c := &RegionInstanceGroupManagersAbandonInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersabandoninstancesrequest = regioninstancegroupmanagersabandoninstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersAbandonInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersAbandonInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersAbandonInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersAbandonInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersAbandonInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersAbandonInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersAbandonInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersAbandonInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersabandoninstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/abandonInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.abandonInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.abandonInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersAbandonInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.abandonInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersAdoptInstancesCall struct {
	s                                                *Service
	project                                          string
	region                                           string
	instanceGroupManager                             string
	regioninstancegroupmanagersadoptinstancesrequest *RegionInstanceGroupManagersAdoptInstancesRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// AdoptInstances: Flags the specified instances to be adopted to the managed
// instance
// group. Adopting an instance does not change the instance status, but it
// adds the instance to any target pools that are applied by the
// managed
// instance group. This method increases the targetSize of the managed
// instance group by the number of instances that you adopt. This operation
// is marked as DONE when the action is scheduled even if the instances
// have
// not been adopted to the group yet. You must separately verify the status
// of the adopting action with the listManagedInstances method.
//
//   - instanceGroupManager: Name of the managed instance group. It should
//     conform to RFC1035 or be a
//
// resource ID.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request. It should conform to
//     RFC1035.
func (r *RegionInstanceGroupManagersService) AdoptInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersadoptinstancesrequest *RegionInstanceGroupManagersAdoptInstancesRequest) *RegionInstanceGroupManagersAdoptInstancesCall {
	c := &RegionInstanceGroupManagersAdoptInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersadoptinstancesrequest = regioninstancegroupmanagersadoptinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersAdoptInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersAdoptInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersAdoptInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersAdoptInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersAdoptInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersAdoptInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersAdoptInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersAdoptInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersadoptinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/adoptInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.adoptInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.adoptInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersAdoptInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.adoptInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersApplyUpdatesToInstancesCall struct {
	s                                              *Service
	project                                        string
	region                                         string
	instanceGroupManager                           string
	regioninstancegroupmanagersapplyupdatesrequest *RegionInstanceGroupManagersApplyUpdatesRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// ApplyUpdatesToInstances: Apply updates to selected instances the managed
// instance group.
//
//   - instanceGroupManager: The name of the managed instance group, should
//     conform to RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request, should conform to
//     RFC1035.
func (r *RegionInstanceGroupManagersService) ApplyUpdatesToInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersapplyupdatesrequest *RegionInstanceGroupManagersApplyUpdatesRequest) *RegionInstanceGroupManagersApplyUpdatesToInstancesCall {
	c := &RegionInstanceGroupManagersApplyUpdatesToInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersapplyupdatesrequest = regioninstancegroupmanagersapplyupdatesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersApplyUpdatesToInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersApplyUpdatesToInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersApplyUpdatesToInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersApplyUpdatesToInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersApplyUpdatesToInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersApplyUpdatesToInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersapplyupdatesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.applyUpdatesToInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.applyUpdatesToInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersApplyUpdatesToInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.applyUpdatesToInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersCreateInstancesCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	instanceGroupManager                              string
	regioninstancegroupmanagerscreateinstancesrequest *RegionInstanceGroupManagersCreateInstancesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// CreateInstances: Creates instances with per-instance configurations in this
// regional managed
// instance group. Instances are created using the current instance
// template.
// The create instances operation is marked DONE if
// the createInstances request is successful. The underlying
// actions take additional time. You must separately verify the status of
// thecreating or actions with the listmanagedinstances
// method.
//
//   - instanceGroupManager: The name of the managed instance group.
//     It should conform to RFC1035.
//   - project: Project ID for this request.
//   - region: The name of theregion
//     where the managed instance group is located.
//
// It should conform to RFC1035.
func (r *RegionInstanceGroupManagersService) CreateInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagerscreateinstancesrequest *RegionInstanceGroupManagersCreateInstancesRequest) *RegionInstanceGroupManagersCreateInstancesCall {
	c := &RegionInstanceGroupManagersCreateInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerscreateinstancesrequest = regioninstancegroupmanagerscreateinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersCreateInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersCreateInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersCreateInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersCreateInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersCreateInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersCreateInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersCreateInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersCreateInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerscreateinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/createInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.createInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.createInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersCreateInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.createInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersDeleteCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Delete: Deletes the specified managed instance group and all of the
// instances
// in that group.
//
// - instanceGroupManager: Name of the managed instance group to delete.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) Delete(project string, region string, instanceGroupManager string) *RegionInstanceGroupManagersDeleteCall {
	c := &RegionInstanceGroupManagersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersDeleteCall) RequestId(requestId string) *RegionInstanceGroupManagersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersDeleteCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersDeleteCall) Context(ctx context.Context) *RegionInstanceGroupManagersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersDeleteInstancesCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	instanceGroupManager                              string
	regioninstancegroupmanagersdeleteinstancesrequest *RegionInstanceGroupManagersDeleteInstancesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// DeleteInstances: Flags the specified instances in the managed instance group
// to be
// immediately deleted. The instances are also removed from any target
// pools of which they were a member. This method reduces thetargetSize of the
// managed instance group by the number of
// instances that you delete.
// The deleteInstances operation is marked DONE if
// the deleteInstances request is successful. The underlying
// actions take additional time. You must separately verify the status of
// thedeleting action with thelistmanagedinstances
// method.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is removed or
// deleted.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) DeleteInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersdeleteinstancesrequest *RegionInstanceGroupManagersDeleteInstancesRequest) *RegionInstanceGroupManagersDeleteInstancesCall {
	c := &RegionInstanceGroupManagersDeleteInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersdeleteinstancesrequest = regioninstancegroupmanagersdeleteinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersDeleteInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersDeleteInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersDeleteInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersDeleteInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersDeleteInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersDeleteInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersDeleteInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersDeleteInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersdeleteinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deleteInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.deleteInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.deleteInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersDeleteInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.deleteInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersDeletePerInstanceConfigsCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	instanceGroupManager                              string
	regioninstancegroupmanagerdeleteinstanceconfigreq *RegionInstanceGroupManagerDeleteInstanceConfigReq
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// DeletePerInstanceConfigs: Deletes selected per-instance configurations for
// the managed instance
// group.
//
//   - instanceGroupManager: The name of the managed instance group. It should
//     conform to RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request, should conform to
//     RFC1035.
func (r *RegionInstanceGroupManagersService) DeletePerInstanceConfigs(project string, region string, instanceGroupManager string, regioninstancegroupmanagerdeleteinstanceconfigreq *RegionInstanceGroupManagerDeleteInstanceConfigReq) *RegionInstanceGroupManagersDeletePerInstanceConfigsCall {
	c := &RegionInstanceGroupManagersDeletePerInstanceConfigsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerdeleteinstanceconfigreq = regioninstancegroupmanagerdeleteinstanceconfigreq
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersDeletePerInstanceConfigsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersDeletePerInstanceConfigsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersDeletePerInstanceConfigsCall) Context(ctx context.Context) *RegionInstanceGroupManagersDeletePerInstanceConfigsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersDeletePerInstanceConfigsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersDeletePerInstanceConfigsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerdeleteinstanceconfigreq)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deletePerInstanceConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.deletePerInstanceConfigs", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.deletePerInstanceConfigs" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersDeletePerInstanceConfigsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.deletePerInstanceConfigs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersGetCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// Get: Returns all of the details about the specified managed instance group.
//
// - instanceGroupManager: Name of the managed instance group to return.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) Get(project string, region string, instanceGroupManager string) *RegionInstanceGroupManagersGetCall {
	c := &RegionInstanceGroupManagersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersGetCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupManagersGetCall) IfNoneMatch(entityTag string) *RegionInstanceGroupManagersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersGetCall) Context(ctx context.Context) *RegionInstanceGroupManagersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstanceGroupManager.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionInstanceGroupManagersGetCall) Do(opts ...googleapi.CallOption) (*InstanceGroupManager, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstanceGroupManager{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersInsertCall struct {
	s                    *Service
	project              string
	region               string
	instancegroupmanager *InstanceGroupManager
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Insert: Creates a managed instance group using the information that you
// specify
// in the request. After the group is created, instances in the group
// are
// created using the specified instance template.
// This operation is marked as DONE when the group is created
// even if the instances in the group have not yet been created. You
// must
// separately verify the status of the individual instances with
// thelistmanagedinstances
// method.
//
// A regional managed instance group can contain up to 2000 instances.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) Insert(project string, region string, instancegroupmanager *InstanceGroupManager) *RegionInstanceGroupManagersInsertCall {
	c := &RegionInstanceGroupManagersInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instancegroupmanager = instancegroupmanager
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersInsertCall) RequestId(requestId string) *RegionInstanceGroupManagersInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersInsertCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersInsertCall) Context(ctx context.Context) *RegionInstanceGroupManagersInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancegroupmanager)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of managed instance groups that are
// contained
// within the specified region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) List(project string, region string) *RegionInstanceGroupManagersListCall {
	c := &RegionInstanceGroupManagersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupManagersListCall) Filter(filter string) *RegionInstanceGroupManagersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupManagersListCall) MaxResults(maxResults int64) *RegionInstanceGroupManagersListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupManagersListCall) OrderBy(orderBy string) *RegionInstanceGroupManagersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupManagersListCall) PageToken(pageToken string) *RegionInstanceGroupManagersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupManagersListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupManagersListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersListCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupManagersListCall) IfNoneMatch(entityTag string) *RegionInstanceGroupManagersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersListCall) Context(ctx context.Context) *RegionInstanceGroupManagersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupManagerList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersListCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupManagerList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupManagerList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupManagersListCall) Pages(ctx context.Context, f func(*RegionInstanceGroupManagerList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupManagersListErrorsCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// ListErrors: Lists all errors thrown by actions on instances for a given
// regional
// managed instance group. The filter andorderBy query parameters are not
// supported.
//
//   - instanceGroupManager: The name of the managed instance group.
//     It must be a string that meets the requirements in RFC1035, or an
//     unsigned long integer: must match regexp pattern:
//     (?:a-z (?:[-a-z0-9]{0,61}[a-z0-9])?)|1-9{0,19}.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
//     This should conform to RFC1035.
func (r *RegionInstanceGroupManagersService) ListErrors(project string, region string, instanceGroupManager string) *RegionInstanceGroupManagersListErrorsCall {
	c := &RegionInstanceGroupManagersListErrorsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupManagersListErrorsCall) Filter(filter string) *RegionInstanceGroupManagersListErrorsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupManagersListErrorsCall) MaxResults(maxResults int64) *RegionInstanceGroupManagersListErrorsCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupManagersListErrorsCall) OrderBy(orderBy string) *RegionInstanceGroupManagersListErrorsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupManagersListErrorsCall) PageToken(pageToken string) *RegionInstanceGroupManagersListErrorsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupManagersListErrorsCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupManagersListErrorsCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersListErrorsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersListErrorsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupManagersListErrorsCall) IfNoneMatch(entityTag string) *RegionInstanceGroupManagersListErrorsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersListErrorsCall) Context(ctx context.Context) *RegionInstanceGroupManagersListErrorsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersListErrorsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersListErrorsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listErrors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.listErrors", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.listErrors" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupManagersListErrorsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersListErrorsCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupManagersListErrorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupManagersListErrorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.listErrors", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupManagersListErrorsCall) Pages(ctx context.Context, f func(*RegionInstanceGroupManagersListErrorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupManagersListManagedInstancesCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// ListManagedInstances: Lists the instances in the managed instance group and
// instances that are
// scheduled to be created. The list includes any current actions
// that the group has scheduled for its instances. The orderBy
// query parameter is not supported.   The `pageToken` query parameter
// is
// supported only if the group's `listManagedInstancesResults` field is set
// to `PAGINATED`.
//
// - instanceGroupManager: The name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) ListManagedInstances(project string, region string, instanceGroupManager string) *RegionInstanceGroupManagersListManagedInstancesCall {
	c := &RegionInstanceGroupManagersListManagedInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) Filter(filter string) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupManagersListManagedInstancesCall) MaxResults(maxResults int64) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) OrderBy(orderBy string) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) PageToken(pageToken string) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersListManagedInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersListManagedInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.listManagedInstances", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.listManagedInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupManagersListInstancesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupManagersListInstancesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupManagersListInstancesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.listManagedInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupManagersListManagedInstancesCall) Pages(ctx context.Context, f func(*RegionInstanceGroupManagersListInstancesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupManagersListPerInstanceConfigsCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// ListPerInstanceConfigs: Lists all of the per-instance configurations defined
// for the managed
// instance group. The orderBy query parameter is not supported.
//
//   - instanceGroupManager: The name of the managed instance group. It should
//     conform to RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request, should conform to
//     RFC1035.
func (r *RegionInstanceGroupManagersService) ListPerInstanceConfigs(project string, region string, instanceGroupManager string) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c := &RegionInstanceGroupManagersListPerInstanceConfigsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) Filter(filter string) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) MaxResults(maxResults int64) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) OrderBy(orderBy string) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) PageToken(pageToken string) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) Context(ctx context.Context) *RegionInstanceGroupManagersListPerInstanceConfigsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listPerInstanceConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.listPerInstanceConfigs", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.listPerInstanceConfigs" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupManagersListInstanceConfigsResp.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupManagersListInstanceConfigsResp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupManagersListInstanceConfigsResp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.listPerInstanceConfigs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupManagersListPerInstanceConfigsCall) Pages(ctx context.Context, f func(*RegionInstanceGroupManagersListInstanceConfigsResp) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupManagersPatchCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	instancegroupmanager *InstanceGroupManager
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Patch: Updates a managed instance group using the information that you
// specify
// in the request.
// This operation is marked as DONE when the group is patched
// even if the instances in the group are still in the process of
// being
// patched. You must separately verify the status of the individual
// instances
// with the listmanagedinstances
// method. This method supportsPATCH
// semantics and uses theJSON merge
// patch format and processing rules.
//
// If you update your group to specify a new template or
// instance
// configuration, it's possible that your intended specification for each VM
// in the group is different from the current state of that VM. To learn how
// to apply an updated configuration to the VMs in a MIG, seeUpdating instances
// in
// a MIG.
//
// - instanceGroupManager: The name of the instance group manager.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) Patch(project string, region string, instanceGroupManager string, instancegroupmanager *InstanceGroupManager) *RegionInstanceGroupManagersPatchCall {
	c := &RegionInstanceGroupManagersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.instancegroupmanager = instancegroupmanager
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersPatchCall) RequestId(requestId string) *RegionInstanceGroupManagersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersPatchCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersPatchCall) Context(ctx context.Context) *RegionInstanceGroupManagersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancegroupmanager)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersPatchPerInstanceConfigsCall struct {
	s                                                *Service
	project                                          string
	region                                           string
	instanceGroupManager                             string
	regioninstancegroupmanagerpatchinstanceconfigreq *RegionInstanceGroupManagerPatchInstanceConfigReq
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// PatchPerInstanceConfigs: Inserts or patches per-instance configurations for
// the managed instance
// group. perInstanceConfig.name serves as a key used to
// distinguish whether to perform insert or patch.
//
//   - instanceGroupManager: The name of the managed instance group.
//     It should conform to RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request, should conform to
//     RFC1035.
func (r *RegionInstanceGroupManagersService) PatchPerInstanceConfigs(project string, region string, instanceGroupManager string, regioninstancegroupmanagerpatchinstanceconfigreq *RegionInstanceGroupManagerPatchInstanceConfigReq) *RegionInstanceGroupManagersPatchPerInstanceConfigsCall {
	c := &RegionInstanceGroupManagersPatchPerInstanceConfigsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerpatchinstanceconfigreq = regioninstancegroupmanagerpatchinstanceconfigreq
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersPatchPerInstanceConfigsCall) RequestId(requestId string) *RegionInstanceGroupManagersPatchPerInstanceConfigsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersPatchPerInstanceConfigsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersPatchPerInstanceConfigsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersPatchPerInstanceConfigsCall) Context(ctx context.Context) *RegionInstanceGroupManagersPatchPerInstanceConfigsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersPatchPerInstanceConfigsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersPatchPerInstanceConfigsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerpatchinstanceconfigreq)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/patchPerInstanceConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.patchPerInstanceConfigs", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.patchPerInstanceConfigs" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersPatchPerInstanceConfigsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.patchPerInstanceConfigs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersRecreateInstancesCall struct {
	s                                          *Service
	project                                    string
	region                                     string
	instanceGroupManager                       string
	regioninstancegroupmanagersrecreaterequest *RegionInstanceGroupManagersRecreateRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// RecreateInstances: Flags the specified VM instances in the managed instance
// group to be
// immediately recreated. Each instance is recreated using the group's
// current
// configuration. This operation is marked as DONE when the flag
// is set even if the instances have not yet been recreated. You
// must
// separately verify the status of each instance by checking itscurrentAction
// field; for more information, see Checking
// the status of managed instances.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is removed or
// deleted.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) RecreateInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersrecreaterequest *RegionInstanceGroupManagersRecreateRequest) *RegionInstanceGroupManagersRecreateInstancesCall {
	c := &RegionInstanceGroupManagersRecreateInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersrecreaterequest = regioninstancegroupmanagersrecreaterequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersRecreateInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersRecreateInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersRecreateInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersRecreateInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersRecreateInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersRecreateInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersRecreateInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersRecreateInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersrecreaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/recreateInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.recreateInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.recreateInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersRecreateInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.recreateInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersResizeCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Resize: Changes the intended size of the managed instance group. If you
// increase
// the size, the group creates new instances using the current
// instance
// template. If you decrease the size, the group deletes one or
// more
// instances.
//
// The resize operation is marked DONE if theresize request is successful. The
// underlying actions take
// additional time. You must separately verify the status of thecreating or
// deleting actions with thelistmanagedinstances
// method.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is removed or deleted.
//
//   - instanceGroupManager: Name of the managed instance group.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
//   - size: Number of instances that should exist in this instance
//     group
//
// manager.
func (r *RegionInstanceGroupManagersService) Resize(project string, region string, instanceGroupManager string, size int64) *RegionInstanceGroupManagersResizeCall {
	c := &RegionInstanceGroupManagersResizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.urlParams_.Set("size", fmt.Sprint(size))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersResizeCall) RequestId(requestId string) *RegionInstanceGroupManagersResizeCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersResizeCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersResizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersResizeCall) Context(ctx context.Context) *RegionInstanceGroupManagersResizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersResizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersResizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.resize", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.resize" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersResizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.resize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersResizeAdvancedCall struct {
	s                                                *Service
	project                                          string
	region                                           string
	instanceGroupManager                             string
	regioninstancegroupmanagersresizeadvancedrequest *RegionInstanceGroupManagersResizeAdvancedRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// ResizeAdvanced: Resizes the regional managed instance group with advanced
// configuration
// options like disabling creation retries. This is an extended version of
// theresize method.
//
// If you increase the size, the group creates new instances using the
// current
// instance template. If you decrease the size, the group deletes one or
// more
// instances.
//
// The resize operation is marked DONE if theresize request is successful. The
// underlying actions take
// additional time. You must separately verify the status of thecreating or
// deleting actions with the get
// orlistmanagedinstances
// method.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is removed or deleted.
//
//   - instanceGroupManager: The name of the managed instance group.
//     It must be a string that meets the requirements in RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
//     It must be a string that meets the requirements in RFC1035.
func (r *RegionInstanceGroupManagersService) ResizeAdvanced(project string, region string, instanceGroupManager string, regioninstancegroupmanagersresizeadvancedrequest *RegionInstanceGroupManagersResizeAdvancedRequest) *RegionInstanceGroupManagersResizeAdvancedCall {
	c := &RegionInstanceGroupManagersResizeAdvancedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersresizeadvancedrequest = regioninstancegroupmanagersresizeadvancedrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersResizeAdvancedCall) RequestId(requestId string) *RegionInstanceGroupManagersResizeAdvancedCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersResizeAdvancedCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersResizeAdvancedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersResizeAdvancedCall) Context(ctx context.Context) *RegionInstanceGroupManagersResizeAdvancedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersResizeAdvancedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersResizeAdvancedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersresizeadvancedrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeAdvanced")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.resizeAdvanced", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.resizeAdvanced" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersResizeAdvancedCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.resizeAdvanced", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersResumeInstancesCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	instanceGroupManager                              string
	regioninstancegroupmanagersresumeinstancesrequest *RegionInstanceGroupManagersResumeInstancesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// ResumeInstances: Flags the specified instances in the managed instance group
// to be
// resumed. This method increases thetargetSize and decreases the
// targetSuspendedSize
// of the managed instance group by the number of instances that you
// resume.
// The resumeInstances operation is marked DONE if
// the resumeInstances request is successful. The underlying
// actions take additional time. You must separately verify the status of
// theRESUMING action with thelistmanagedinstances
// method.
//
// In this request, you can only specify instances that are suspended.
// For
// example, if an instance was previously suspended using the
// suspendInstances
// method, it can be resumed using the resumeInstances method.
//
// If a health check is attached to the managed instance group, the
// specified
// instances will be verified as healthy after they are resumed.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) ResumeInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersresumeinstancesrequest *RegionInstanceGroupManagersResumeInstancesRequest) *RegionInstanceGroupManagersResumeInstancesCall {
	c := &RegionInstanceGroupManagersResumeInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersresumeinstancesrequest = regioninstancegroupmanagersresumeinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersResumeInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersResumeInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersResumeInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersResumeInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersResumeInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersResumeInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersResumeInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersResumeInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersresumeinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resumeInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.resumeInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.resumeInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersResumeInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.resumeInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersSetAutoHealingPoliciesCall struct {
	s                                                *Service
	project                                          string
	region                                           string
	instanceGroupManager                             string
	regioninstancegroupmanagerssetautohealingrequest *RegionInstanceGroupManagersSetAutoHealingRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// SetAutoHealingPolicies: Modifies the autohealing policy for the instances in
// this managed
// instance group.
// [Deprecated] This method is deprecated. UseregionInstanceGroupManagers.patch
// instead.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) SetAutoHealingPolicies(project string, region string, instanceGroupManager string, regioninstancegroupmanagerssetautohealingrequest *RegionInstanceGroupManagersSetAutoHealingRequest) *RegionInstanceGroupManagersSetAutoHealingPoliciesCall {
	c := &RegionInstanceGroupManagersSetAutoHealingPoliciesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerssetautohealingrequest = regioninstancegroupmanagerssetautohealingrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersSetAutoHealingPoliciesCall) RequestId(requestId string) *RegionInstanceGroupManagersSetAutoHealingPoliciesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersSetAutoHealingPoliciesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersSetAutoHealingPoliciesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersSetAutoHealingPoliciesCall) Context(ctx context.Context) *RegionInstanceGroupManagersSetAutoHealingPoliciesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersSetAutoHealingPoliciesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersSetAutoHealingPoliciesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerssetautohealingrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.setAutoHealingPolicies", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.setAutoHealingPolicies" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersSetAutoHealingPoliciesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.setAutoHealingPolicies", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersSetInstanceTemplateCall struct {
	s                                             *Service
	project                                       string
	region                                        string
	instanceGroupManager                          string
	regioninstancegroupmanagerssettemplaterequest *RegionInstanceGroupManagersSetTemplateRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// SetInstanceTemplate: Sets the instance template to use when creating new
// instances or recreating
// instances in this group. Existing instances are not affected.
//
// - instanceGroupManager: The name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) SetInstanceTemplate(project string, region string, instanceGroupManager string, regioninstancegroupmanagerssettemplaterequest *RegionInstanceGroupManagersSetTemplateRequest) *RegionInstanceGroupManagersSetInstanceTemplateCall {
	c := &RegionInstanceGroupManagersSetInstanceTemplateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerssettemplaterequest = regioninstancegroupmanagerssettemplaterequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersSetInstanceTemplateCall) RequestId(requestId string) *RegionInstanceGroupManagersSetInstanceTemplateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersSetInstanceTemplateCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersSetInstanceTemplateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersSetInstanceTemplateCall) Context(ctx context.Context) *RegionInstanceGroupManagersSetInstanceTemplateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersSetInstanceTemplateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersSetInstanceTemplateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerssettemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.setInstanceTemplate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.setInstanceTemplate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersSetInstanceTemplateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.setInstanceTemplate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersSetTargetPoolsCall struct {
	s                                                *Service
	project                                          string
	region                                           string
	instanceGroupManager                             string
	regioninstancegroupmanagerssettargetpoolsrequest *RegionInstanceGroupManagersSetTargetPoolsRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// SetTargetPools: Modifies the target pools to which all new instances in this
// group are
// assigned. Existing instances in the group are not affected.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) SetTargetPools(project string, region string, instanceGroupManager string, regioninstancegroupmanagerssettargetpoolsrequest *RegionInstanceGroupManagersSetTargetPoolsRequest) *RegionInstanceGroupManagersSetTargetPoolsCall {
	c := &RegionInstanceGroupManagersSetTargetPoolsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerssettargetpoolsrequest = regioninstancegroupmanagerssettargetpoolsrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersSetTargetPoolsCall) RequestId(requestId string) *RegionInstanceGroupManagersSetTargetPoolsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersSetTargetPoolsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersSetTargetPoolsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersSetTargetPoolsCall) Context(ctx context.Context) *RegionInstanceGroupManagersSetTargetPoolsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersSetTargetPoolsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersSetTargetPoolsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerssettargetpoolsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setTargetPools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.setTargetPools", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.setTargetPools" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersSetTargetPoolsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.setTargetPools", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersStartInstancesCall struct {
	s                                                *Service
	project                                          string
	region                                           string
	instanceGroupManager                             string
	regioninstancegroupmanagersstartinstancesrequest *RegionInstanceGroupManagersStartInstancesRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// StartInstances: Flags the specified instances in the managed instance group
// to be
// started. This method increases thetargetSize and decreases the
// targetStoppedSize
// of the managed instance group by the number of instances that you start.
// The startInstances operation is marked DONE if
// the startInstances request is successful. The underlying
// actions take additional time. You must separately verify the status of
// theSTARTING action with thelistmanagedinstances
// method.
//
// In this request, you can only specify instances that are stopped.
// For
// example, if an instance was previously stopped using the
// stopInstances
// method, it can be started using the startInstances method.
//
// If a health check is attached to the managed instance group, the
// specified
// instances will be verified as healthy after they are started.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) StartInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersstartinstancesrequest *RegionInstanceGroupManagersStartInstancesRequest) *RegionInstanceGroupManagersStartInstancesCall {
	c := &RegionInstanceGroupManagersStartInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersstartinstancesrequest = regioninstancegroupmanagersstartinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersStartInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersStartInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersStartInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersStartInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersStartInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersStartInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersStartInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersStartInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersstartinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/startInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.startInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.startInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersStartInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.startInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersStopInstancesCall struct {
	s                                               *Service
	project                                         string
	region                                          string
	instanceGroupManager                            string
	regioninstancegroupmanagersstopinstancesrequest *RegionInstanceGroupManagersStopInstancesRequest
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// StopInstances: Flags the specified instances in the managed instance group
// to be
// immediately stopped. You can only specify instances that are running in
// this request. This method reduces thetargetSize and increases the
// targetStoppedSize
// of the managed instance group by the number of instances that you stop.
// The stopInstances operation is marked DONE if
// the stopInstances request is successful. The underlying
// actions take additional time. You must separately verify the status of
// theSTOPPING action with thelistmanagedinstances
// method.
//
// If the standbyPolicy.initialDelaySec field is set, the group
// delays stopping the instances until initialDelaySec have
// passed from instance.creationTimestamp (that is, when the
// instance was created). This delay gives your application time to
// set itself up and initialize on the instance. If more thaninitialDelaySec
// seconds have passed sinceinstance.creationTimestamp when this method is
// called, there
// will be zero delay.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is stopped.
//
// Stopped instances can be started using the startInstances
// method.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: The name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) StopInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagersstopinstancesrequest *RegionInstanceGroupManagersStopInstancesRequest) *RegionInstanceGroupManagersStopInstancesCall {
	c := &RegionInstanceGroupManagersStopInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagersstopinstancesrequest = regioninstancegroupmanagersstopinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersStopInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersStopInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersStopInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersStopInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersStopInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersStopInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersStopInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersStopInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagersstopinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/stopInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.stopInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.stopInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersStopInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.stopInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersSuspendInstancesCall struct {
	s                                                  *Service
	project                                            string
	region                                             string
	instanceGroupManager                               string
	regioninstancegroupmanagerssuspendinstancesrequest *RegionInstanceGroupManagersSuspendInstancesRequest
	urlParams_                                         gensupport.URLParams
	ctx_                                               context.Context
	header_                                            http.Header
}

// SuspendInstances: Flags the specified instances in the managed instance
// group to be
// immediately suspended. You can only specify instances that are running
// in
// this request. This method reduces thetargetSize and increases the
// targetSuspendedSize
// of the managed instance group by the number of instances that you
// suspend.
// The suspendInstances operation is marked DONE if
// the suspendInstances request is successful. The underlying
// actions take additional time. You must separately verify the status of
// theSUSPENDING action with thelistmanagedinstances
// method.
//
// If the standbyPolicy.initialDelaySec field is set, the group
// delays suspension of the instances until initialDelaySec have
// passed from instance.creationTimestamp (that is, when the
// instance was created). This delay gives your application time to
// set itself up and initialize on the instance. If more thaninitialDelaySec
// seconds have passed sinceinstance.creationTimestamp when this method is
// called, there
// will be zero delay.
//
// If the group is part of a backend
// service that has enabled
// connection draining, it can take up to 60 seconds after the
// connection
// draining duration has elapsed before the VM instance is
// suspended.
//
// Suspended instances can be resumed using the resumeInstances
// method.
//
// You can specify a maximum of 1000 instances with this method per request.
//
// - instanceGroupManager: Name of the managed instance group.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) SuspendInstances(project string, region string, instanceGroupManager string, regioninstancegroupmanagerssuspendinstancesrequest *RegionInstanceGroupManagersSuspendInstancesRequest) *RegionInstanceGroupManagersSuspendInstancesCall {
	c := &RegionInstanceGroupManagersSuspendInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerssuspendinstancesrequest = regioninstancegroupmanagerssuspendinstancesrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersSuspendInstancesCall) RequestId(requestId string) *RegionInstanceGroupManagersSuspendInstancesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersSuspendInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersSuspendInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersSuspendInstancesCall) Context(ctx context.Context) *RegionInstanceGroupManagersSuspendInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersSuspendInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersSuspendInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerssuspendinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/suspendInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.suspendInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.suspendInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersSuspendInstancesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.suspendInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstanceGroupManagersService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionInstanceGroupManagersTestIamPermissionsCall {
	c := &RegionInstanceGroupManagersTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersTestIamPermissionsCall) Context(ctx context.Context) *RegionInstanceGroupManagersTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersUpdateCall struct {
	s                    *Service
	project              string
	region               string
	instanceGroupManager string
	instancegroupmanager *InstanceGroupManager
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Update: Updates a managed instance group using the information that you
// specify
// in the request.
// This operation is marked as DONE when the group is updated
// even if the instances in the group have not yet been updated. You
// must
// separately verify the status of the individual instances with
// thelistmanagedinstances
// method.
//
// If you update your group to specify a new template or
// instance
// configuration, it's possible that your intended specification for each VM
// in the group is different from the current state of that VM. To learn how
// to apply an updated configuration to the VMs in a MIG, seeUpdating instances
// in
// a MIG.
//
// - instanceGroupManager: The name of the instance group manager.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupManagersService) Update(project string, region string, instanceGroupManager string, instancegroupmanager *InstanceGroupManager) *RegionInstanceGroupManagersUpdateCall {
	c := &RegionInstanceGroupManagersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.instancegroupmanager = instancegroupmanager
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersUpdateCall) RequestId(requestId string) *RegionInstanceGroupManagersUpdateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersUpdateCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersUpdateCall) Context(ctx context.Context) *RegionInstanceGroupManagersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancegroupmanager)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupManagersUpdatePerInstanceConfigsCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	instanceGroupManager                              string
	regioninstancegroupmanagerupdateinstanceconfigreq *RegionInstanceGroupManagerUpdateInstanceConfigReq
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// UpdatePerInstanceConfigs: Inserts or updates per-instance configurations for
// the managed instance
// group. perInstanceConfig.name serves as a key used to
// distinguish whether to perform insert or patch.
//
//   - instanceGroupManager: The name of the managed instance group.
//     It should conform to RFC1035.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request, should conform to
//     RFC1035.
func (r *RegionInstanceGroupManagersService) UpdatePerInstanceConfigs(project string, region string, instanceGroupManager string, regioninstancegroupmanagerupdateinstanceconfigreq *RegionInstanceGroupManagerUpdateInstanceConfigReq) *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall {
	c := &RegionInstanceGroupManagersUpdatePerInstanceConfigsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroupManager = instanceGroupManager
	c.regioninstancegroupmanagerupdateinstanceconfigreq = regioninstancegroupmanagerupdateinstanceconfigreq
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall) RequestId(requestId string) *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall) Context(ctx context.Context) *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupmanagerupdateinstanceconfigreq)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/updatePerInstanceConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instanceGroupManager": c.instanceGroupManager,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.updatePerInstanceConfigs", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroupManagers.updatePerInstanceConfigs" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupManagersUpdatePerInstanceConfigsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroupManagers.updatePerInstanceConfigs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupsGetCall struct {
	s             *Service
	project       string
	region        string
	instanceGroup string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// Get: Returns the specified instance group resource.
//
// - instanceGroup: Name of the instance group resource to return.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupsService) Get(project string, region string, instanceGroup string) *RegionInstanceGroupsGetCall {
	c := &RegionInstanceGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroup = instanceGroup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupsGetCall) Fields(s ...googleapi.Field) *RegionInstanceGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupsGetCall) IfNoneMatch(entityTag string) *RegionInstanceGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupsGetCall) Context(ctx context.Context) *RegionInstanceGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroups/{instanceGroup}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"instanceGroup": c.instanceGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstanceGroup.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupsGetCall) Do(opts ...googleapi.CallOption) (*InstanceGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstanceGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of instance group resources contained within
// the specified region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupsService) List(project string, region string) *RegionInstanceGroupsListCall {
	c := &RegionInstanceGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupsListCall) Filter(filter string) *RegionInstanceGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupsListCall) MaxResults(maxResults int64) *RegionInstanceGroupsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupsListCall) OrderBy(orderBy string) *RegionInstanceGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupsListCall) PageToken(pageToken string) *RegionInstanceGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupsListCall) Fields(s ...googleapi.Field) *RegionInstanceGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceGroupsListCall) IfNoneMatch(entityTag string) *RegionInstanceGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupsListCall) Context(ctx context.Context) *RegionInstanceGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupsListCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupsListCall) Pages(ctx context.Context, f func(*RegionInstanceGroupList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupsListInstancesCall struct {
	s                                        *Service
	project                                  string
	region                                   string
	instanceGroup                            string
	regioninstancegroupslistinstancesrequest *RegionInstanceGroupsListInstancesRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// ListInstances: Lists the instances in the specified instance group and
// displays
// information about the named ports. Depending on the specified options,
// this
// method can list all instances or only the instances that are running.
// The orderBy query parameter is not supported.
//
//   - instanceGroup: Name of the regional instance group for which we want to
//     list the
//
// instances.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionInstanceGroupsService) ListInstances(project string, region string, instanceGroup string, regioninstancegroupslistinstancesrequest *RegionInstanceGroupsListInstancesRequest) *RegionInstanceGroupsListInstancesCall {
	c := &RegionInstanceGroupsListInstancesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroup = instanceGroup
	c.regioninstancegroupslistinstancesrequest = regioninstancegroupslistinstancesrequest
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceGroupsListInstancesCall) Filter(filter string) *RegionInstanceGroupsListInstancesCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceGroupsListInstancesCall) MaxResults(maxResults int64) *RegionInstanceGroupsListInstancesCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceGroupsListInstancesCall) OrderBy(orderBy string) *RegionInstanceGroupsListInstancesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceGroupsListInstancesCall) PageToken(pageToken string) *RegionInstanceGroupsListInstancesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceGroupsListInstancesCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceGroupsListInstancesCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupsListInstancesCall) Fields(s ...googleapi.Field) *RegionInstanceGroupsListInstancesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupsListInstancesCall) Context(ctx context.Context) *RegionInstanceGroupsListInstancesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupsListInstancesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupsListInstancesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupslistinstancesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/listInstances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"instanceGroup": c.instanceGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.listInstances", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroups.listInstances" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionInstanceGroupsListInstances.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupsListInstancesCall) Do(opts ...googleapi.CallOption) (*RegionInstanceGroupsListInstances, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionInstanceGroupsListInstances{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.listInstances", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceGroupsListInstancesCall) Pages(ctx context.Context, f func(*RegionInstanceGroupsListInstances) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstanceGroupsSetNamedPortsCall struct {
	s                                        *Service
	project                                  string
	region                                   string
	instanceGroup                            string
	regioninstancegroupssetnamedportsrequest *RegionInstanceGroupsSetNamedPortsRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// SetNamedPorts: Sets the named ports for the specified regional instance
// group.
//
//   - instanceGroup: The name of the regional instance group where the named
//     ports are updated.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
func (r *RegionInstanceGroupsService) SetNamedPorts(project string, region string, instanceGroup string, regioninstancegroupssetnamedportsrequest *RegionInstanceGroupsSetNamedPortsRequest) *RegionInstanceGroupsSetNamedPortsCall {
	c := &RegionInstanceGroupsSetNamedPortsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceGroup = instanceGroup
	c.regioninstancegroupssetnamedportsrequest = regioninstancegroupssetnamedportsrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceGroupsSetNamedPortsCall) RequestId(requestId string) *RegionInstanceGroupsSetNamedPortsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupsSetNamedPortsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupsSetNamedPortsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupsSetNamedPortsCall) Context(ctx context.Context) *RegionInstanceGroupsSetNamedPortsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupsSetNamedPortsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupsSetNamedPortsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regioninstancegroupssetnamedportsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/setNamedPorts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"instanceGroup": c.instanceGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.setNamedPorts", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroups.setNamedPorts" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceGroupsSetNamedPortsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.setNamedPorts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceGroupsTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstanceGroupsService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionInstanceGroupsTestIamPermissionsCall {
	c := &RegionInstanceGroupsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceGroupsTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionInstanceGroupsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceGroupsTestIamPermissionsCall) Context(ctx context.Context) *RegionInstanceGroupsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceGroupsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceGroupsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceGroups/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceGroups.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstanceGroupsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceGroups.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceTemplatesDeleteCall struct {
	s                *Service
	project          string
	region           string
	instanceTemplate string
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Delete: Deletes the specified instance template. Deleting an instance
// template is
// permanent and cannot be undone.
//
// - instanceTemplate: The name of the instance template to delete.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstanceTemplatesService) Delete(project string, region string, instanceTemplate string) *RegionInstanceTemplatesDeleteCall {
	c := &RegionInstanceTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceTemplate = instanceTemplate
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceTemplatesDeleteCall) RequestId(requestId string) *RegionInstanceTemplatesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceTemplatesDeleteCall) Fields(s ...googleapi.Field) *RegionInstanceTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceTemplatesDeleteCall) Context(ctx context.Context) *RegionInstanceTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceTemplates/{instanceTemplate}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":          c.project,
		"region":           c.region,
		"instanceTemplate": c.instanceTemplate,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceTemplatesGetCall struct {
	s                *Service
	project          string
	region           string
	instanceTemplate string
	urlParams_       gensupport.URLParams
	ifNoneMatch_     string
	ctx_             context.Context
	header_          http.Header
}

// Get: Returns the specified instance template.
//
// - instanceTemplate: The name of the instance template.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstanceTemplatesService) Get(project string, region string, instanceTemplate string) *RegionInstanceTemplatesGetCall {
	c := &RegionInstanceTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instanceTemplate = instanceTemplate
	return c
}

// View sets the optional parameter "view": View of the instance template.
//
// Possible values:
//
//	"BASIC" - Include everything except Partner Metadata.
//	"FULL" - Include everything.
//	"INSTANCE_VIEW_UNSPECIFIED" - The default / unset value. The API will
//
// default to the BASIC view.
func (c *RegionInstanceTemplatesGetCall) View(view string) *RegionInstanceTemplatesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceTemplatesGetCall) Fields(s ...googleapi.Field) *RegionInstanceTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceTemplatesGetCall) IfNoneMatch(entityTag string) *RegionInstanceTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceTemplatesGetCall) Context(ctx context.Context) *RegionInstanceTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceTemplates/{instanceTemplate}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":          c.project,
		"region":           c.region,
		"instanceTemplate": c.instanceTemplate,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstanceTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionInstanceTemplatesGetCall) Do(opts ...googleapi.CallOption) (*InstanceTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstanceTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceTemplatesInsertCall struct {
	s                *Service
	project          string
	region           string
	instancetemplate *InstanceTemplate
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Insert: Creates an instance template in the specified project and region
// using the
// global instance template whose URL is included in the request.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstanceTemplatesService) Insert(project string, region string, instancetemplate *InstanceTemplate) *RegionInstanceTemplatesInsertCall {
	c := &RegionInstanceTemplatesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instancetemplate = instancetemplate
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstanceTemplatesInsertCall) RequestId(requestId string) *RegionInstanceTemplatesInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceTemplatesInsertCall) Fields(s ...googleapi.Field) *RegionInstanceTemplatesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceTemplatesInsertCall) Context(ctx context.Context) *RegionInstanceTemplatesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceTemplatesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceTemplatesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancetemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceTemplates.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstanceTemplatesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstanceTemplatesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of instance templates that are contained within
// the
// specified project and region.
//
// - project: Project ID for this request.
// - region: The name of the regions for this request.
func (r *RegionInstanceTemplatesService) List(project string, region string) *RegionInstanceTemplatesListCall {
	c := &RegionInstanceTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstanceTemplatesListCall) Filter(filter string) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstanceTemplatesListCall) MaxResults(maxResults int64) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstanceTemplatesListCall) OrderBy(orderBy string) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstanceTemplatesListCall) PageToken(pageToken string) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstanceTemplatesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// View sets the optional parameter "view": View of the instance template.
//
// Possible values:
//
//	"BASIC" - Include everything except Partner Metadata.
//	"FULL" - Include everything.
//	"INSTANCE_VIEW_UNSPECIFIED" - The default / unset value. The API will
//
// default to the BASIC view.
func (c *RegionInstanceTemplatesListCall) View(view string) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstanceTemplatesListCall) Fields(s ...googleapi.Field) *RegionInstanceTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstanceTemplatesListCall) IfNoneMatch(entityTag string) *RegionInstanceTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstanceTemplatesListCall) Context(ctx context.Context) *RegionInstanceTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstanceTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstanceTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instanceTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstanceTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstanceTemplateList.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionInstanceTemplatesListCall) Do(opts ...googleapi.CallOption) (*InstanceTemplateList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstanceTemplateList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstanceTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstanceTemplatesListCall) Pages(ctx context.Context, f func(*InstanceTemplateList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstancesBulkInsertCall struct {
	s                          *Service
	project                    string
	region                     string
	bulkinsertinstanceresource *BulkInsertInstanceResource
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// BulkInsert: Creates multiple instances in a given region. Count specifies
// the number of
// instances to create.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstancesService) BulkInsert(project string, region string, bulkinsertinstanceresource *BulkInsertInstanceResource) *RegionInstancesBulkInsertCall {
	c := &RegionInstancesBulkInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.bulkinsertinstanceresource = bulkinsertinstanceresource
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstancesBulkInsertCall) RequestId(requestId string) *RegionInstancesBulkInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstancesBulkInsertCall) Fields(s ...googleapi.Field) *RegionInstancesBulkInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstancesBulkInsertCall) Context(ctx context.Context) *RegionInstancesBulkInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstancesBulkInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstancesBulkInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.bulkinsertinstanceresource)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instances/bulkInsert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstances.bulkInsert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstances.bulkInsert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstancesBulkInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstances.bulkInsert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotGroupsDeleteCall struct {
	s                    *Service
	project              string
	region               string
	instantSnapshotGroup string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Delete: deletes a Regional InstantSnapshotGroup resource
//
// - instantSnapshotGroup: Name of the InstantSnapshotGroup resource to delete.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstantSnapshotGroupsService) Delete(project string, region string, instantSnapshotGroup string) *RegionInstantSnapshotGroupsDeleteCall {
	c := &RegionInstantSnapshotGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instantSnapshotGroup = instantSnapshotGroup
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstantSnapshotGroupsDeleteCall) RequestId(requestId string) *RegionInstantSnapshotGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsDeleteCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsDeleteCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups/{instantSnapshotGroup}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instantSnapshotGroup": c.instantSnapshotGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotGroupsGetCall struct {
	s                    *Service
	project              string
	region               string
	instantSnapshotGroup string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// Get: returns the specified InstantSnapshotGroup resource in the
// specified
// region.
//
// - instantSnapshotGroup: Name of the InstantSnapshotGroup resource to return.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstantSnapshotGroupsService) Get(project string, region string, instantSnapshotGroup string) *RegionInstantSnapshotGroupsGetCall {
	c := &RegionInstantSnapshotGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instantSnapshotGroup = instantSnapshotGroup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsGetCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstantSnapshotGroupsGetCall) IfNoneMatch(entityTag string) *RegionInstantSnapshotGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsGetCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups/{instantSnapshotGroup}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"instantSnapshotGroup": c.instantSnapshotGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstantSnapshotGroup.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionInstantSnapshotGroupsGetCall) Do(opts ...googleapi.CallOption) (*InstantSnapshotGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstantSnapshotGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotGroupsGetIamPolicyCall struct {
	s            *Service
	project      string
	region       string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May be empty if
// no such
// policy or resource exists.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotGroupsService) GetIamPolicy(project string, region string, resource string) *RegionInstantSnapshotGroupsGetIamPolicyCall {
	c := &RegionInstantSnapshotGroupsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "optionsRequestedPolicyVersion": Requested IAM Policy version.
func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *RegionInstantSnapshotGroupsGetIamPolicyCall {
	c.urlParams_.Set("optionsRequestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) IfNoneMatch(entityTag string) *RegionInstantSnapshotGroupsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotGroupsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotGroupsInsertCall struct {
	s                    *Service
	project              string
	region               string
	instantsnapshotgroup *InstantSnapshotGroup
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Insert: creates a Regional InstantSnapshotGroup resource
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionInstantSnapshotGroupsService) Insert(project string, region string, instantsnapshotgroup *InstantSnapshotGroup) *RegionInstantSnapshotGroupsInsertCall {
	c := &RegionInstantSnapshotGroupsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instantsnapshotgroup = instantsnapshotgroup
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstantSnapshotGroupsInsertCall) RequestId(requestId string) *RegionInstantSnapshotGroupsInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SourceConsistencyGroup sets the optional parameter "sourceConsistencyGroup":
// begin_interface: MixerMutationRequestBuilder
func (c *RegionInstantSnapshotGroupsInsertCall) SourceConsistencyGroup(sourceConsistencyGroup string) *RegionInstantSnapshotGroupsInsertCall {
	c.urlParams_.Set("sourceConsistencyGroup", sourceConsistencyGroup)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsInsertCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsInsertCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instantsnapshotgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotGroupsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotGroupsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: retrieves the list of InstantSnapshotGroup resources contained
// within
// the specified region.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstantSnapshotGroupsService) List(project string, region string) *RegionInstantSnapshotGroupsListCall {
	c := &RegionInstantSnapshotGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstantSnapshotGroupsListCall) Filter(filter string) *RegionInstantSnapshotGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstantSnapshotGroupsListCall) MaxResults(maxResults int64) *RegionInstantSnapshotGroupsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstantSnapshotGroupsListCall) OrderBy(orderBy string) *RegionInstantSnapshotGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstantSnapshotGroupsListCall) PageToken(pageToken string) *RegionInstantSnapshotGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstantSnapshotGroupsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstantSnapshotGroupsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsListCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstantSnapshotGroupsListCall) IfNoneMatch(entityTag string) *RegionInstantSnapshotGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsListCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListInstantSnapshotGroups.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstantSnapshotGroupsListCall) Do(opts ...googleapi.CallOption) (*ListInstantSnapshotGroups, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListInstantSnapshotGroups{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstantSnapshotGroupsListCall) Pages(ctx context.Context, f func(*ListInstantSnapshotGroups) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstantSnapshotGroupsSetIamPolicyCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetpolicyrequest *RegionSetPolicyRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource.
// Replaces any existing policy.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotGroupsService) SetIamPolicy(project string, region string, resource string, regionsetpolicyrequest *RegionSetPolicyRequest) *RegionInstantSnapshotGroupsSetIamPolicyCall {
	c := &RegionInstantSnapshotGroupsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetpolicyrequest = regionsetpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsSetIamPolicyCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsSetIamPolicyCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotGroupsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotGroupsTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotGroupsService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionInstantSnapshotGroupsTestIamPermissionsCall {
	c := &RegionInstantSnapshotGroupsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotGroupsTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotGroupsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotGroupsTestIamPermissionsCall) Context(ctx context.Context) *RegionInstantSnapshotGroupsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotGroupsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotGroupsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshotGroups.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstantSnapshotGroupsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshotGroups.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsDeleteCall struct {
	s               *Service
	project         string
	region          string
	instantSnapshot string
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Delete: Deletes the specified InstantSnapshot resource. Keep in mind that
// deleting
// a single instantSnapshot might not necessarily delete all the data on
// that
// instantSnapshot. If any data on the instantSnapshot that is marked
// for
// deletion is needed for subsequent instantSnapshots, the data will be
// moved
// to the next corresponding instantSnapshot.
//
// For more information, seeDeleting
// instantSnapshots.
//
// - instantSnapshot: Name of the InstantSnapshot resource to delete.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstantSnapshotsService) Delete(project string, region string, instantSnapshot string) *RegionInstantSnapshotsDeleteCall {
	c := &RegionInstantSnapshotsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instantSnapshot = instantSnapshot
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstantSnapshotsDeleteCall) RequestId(requestId string) *RegionInstantSnapshotsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsDeleteCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsDeleteCall) Context(ctx context.Context) *RegionInstantSnapshotsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots/{instantSnapshot}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":         c.project,
		"region":          c.region,
		"instantSnapshot": c.instantSnapshot,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsGetCall struct {
	s               *Service
	project         string
	region          string
	instantSnapshot string
	urlParams_      gensupport.URLParams
	ifNoneMatch_    string
	ctx_            context.Context
	header_         http.Header
}

// Get: Returns the specified InstantSnapshot resource in the specified region.
//
// - instantSnapshot: Name of the InstantSnapshot resource to return.
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstantSnapshotsService) Get(project string, region string, instantSnapshot string) *RegionInstantSnapshotsGetCall {
	c := &RegionInstantSnapshotsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instantSnapshot = instantSnapshot
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsGetCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstantSnapshotsGetCall) IfNoneMatch(entityTag string) *RegionInstantSnapshotsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsGetCall) Context(ctx context.Context) *RegionInstantSnapshotsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots/{instantSnapshot}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":         c.project,
		"region":          c.region,
		"instantSnapshot": c.instantSnapshot,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstantSnapshot.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionInstantSnapshotsGetCall) Do(opts ...googleapi.CallOption) (*InstantSnapshot, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstantSnapshot{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsGetIamPolicyCall struct {
	s            *Service
	project      string
	region       string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May be empty if
// no such
// policy or resource exists.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotsService) GetIamPolicy(project string, region string, resource string) *RegionInstantSnapshotsGetIamPolicyCall {
	c := &RegionInstantSnapshotsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "optionsRequestedPolicyVersion": Requested IAM Policy version.
func (c *RegionInstantSnapshotsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *RegionInstantSnapshotsGetIamPolicyCall {
	c.urlParams_.Set("optionsRequestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsGetIamPolicyCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstantSnapshotsGetIamPolicyCall) IfNoneMatch(entityTag string) *RegionInstantSnapshotsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsGetIamPolicyCall) Context(ctx context.Context) *RegionInstantSnapshotsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots/{resource}/getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsInsertCall struct {
	s               *Service
	project         string
	region          string
	instantsnapshot *InstantSnapshot
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Insert: Creates an instant snapshot in the specified region.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionInstantSnapshotsService) Insert(project string, region string, instantsnapshot *InstantSnapshot) *RegionInstantSnapshotsInsertCall {
	c := &RegionInstantSnapshotsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.instantsnapshot = instantsnapshot
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstantSnapshotsInsertCall) RequestId(requestId string) *RegionInstantSnapshotsInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsInsertCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsInsertCall) Context(ctx context.Context) *RegionInstantSnapshotsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instantsnapshot)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of InstantSnapshot resources contained within
// the specified region.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
func (r *RegionInstantSnapshotsService) List(project string, region string) *RegionInstantSnapshotsListCall {
	c := &RegionInstantSnapshotsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionInstantSnapshotsListCall) Filter(filter string) *RegionInstantSnapshotsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionInstantSnapshotsListCall) MaxResults(maxResults int64) *RegionInstantSnapshotsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionInstantSnapshotsListCall) OrderBy(orderBy string) *RegionInstantSnapshotsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionInstantSnapshotsListCall) PageToken(pageToken string) *RegionInstantSnapshotsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionInstantSnapshotsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionInstantSnapshotsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsListCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionInstantSnapshotsListCall) IfNoneMatch(entityTag string) *RegionInstantSnapshotsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsListCall) Context(ctx context.Context) *RegionInstantSnapshotsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstantSnapshotList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionInstantSnapshotsListCall) Do(opts ...googleapi.CallOption) (*InstantSnapshotList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstantSnapshotList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionInstantSnapshotsListCall) Pages(ctx context.Context, f func(*InstantSnapshotList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionInstantSnapshotsSetIamPolicyCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetpolicyrequest *RegionSetPolicyRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource.
// Replaces any existing policy.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotsService) SetIamPolicy(project string, region string, resource string, regionsetpolicyrequest *RegionSetPolicyRequest) *RegionInstantSnapshotsSetIamPolicyCall {
	c := &RegionInstantSnapshotsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetpolicyrequest = regionsetpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsSetIamPolicyCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsSetIamPolicyCall) Context(ctx context.Context) *RegionInstantSnapshotsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots/{resource}/setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsSetLabelsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetlabelsrequest *RegionSetLabelsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetLabels: Sets the labels on a instantSnapshot in the given region. To
// learn more
// about labels, read the Labeling
// Resources documentation.
//
// - project: Project ID for this request.
// - region: The region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotsService) SetLabels(project string, region string, resource string, regionsetlabelsrequest *RegionSetLabelsRequest) *RegionInstantSnapshotsSetLabelsCall {
	c := &RegionInstantSnapshotsSetLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetlabelsrequest = regionsetlabelsrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionInstantSnapshotsSetLabelsCall) RequestId(requestId string) *RegionInstantSnapshotsSetLabelsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsSetLabelsCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsSetLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsSetLabelsCall) Context(ctx context.Context) *RegionInstantSnapshotsSetLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsSetLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsSetLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetlabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots/{resource}/setLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.setLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.setLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionInstantSnapshotsSetLabelsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.setLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionInstantSnapshotsTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionInstantSnapshotsService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionInstantSnapshotsTestIamPermissionsCall {
	c := &RegionInstantSnapshotsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionInstantSnapshotsTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionInstantSnapshotsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionInstantSnapshotsTestIamPermissionsCall) Context(ctx context.Context) *RegionInstantSnapshotsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionInstantSnapshotsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionInstantSnapshotsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/instantSnapshots/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionInstantSnapshots.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionInstantSnapshotsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionInstantSnapshots.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionMultiMigMembersGetCall struct {
	s              *Service
	project        string
	region         string
	multiMig       string
	multiMigMember string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// Get: Retrieves information about the specified multi-MIG member.
//
//   - multiMig: The name of the multi-MIG.
//     Name should conform to RFC1035 or be a resource ID.
//   - multiMigMember: The name of the multi-MIG member.
//     Name should conform to RFC1035 or be a resource ID.
//   - project: Project ID for this request.
//   - region: Name of the region for this request. Region name should conform to
//     RFC1035.
func (r *RegionMultiMigMembersService) Get(project string, region string, multiMig string, multiMigMember string) *RegionMultiMigMembersGetCall {
	c := &RegionMultiMigMembersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.multiMig = multiMig
	c.multiMigMember = multiMigMember
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionMultiMigMembersGetCall) Fields(s ...googleapi.Field) *RegionMultiMigMembersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionMultiMigMembersGetCall) IfNoneMatch(entityTag string) *RegionMultiMigMembersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionMultiMigMembersGetCall) Context(ctx context.Context) *RegionMultiMigMembersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionMultiMigMembersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionMultiMigMembersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/multiMigs/{multiMig}/multiMigMembers/{multiMigMember}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"multiMig":       c.multiMig,
		"multiMigMember": c.multiMigMember,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionMultiMigMembers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionMultiMigMembers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MultiMigMember.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionMultiMigMembersGetCall) Do(opts ...googleapi.CallOption) (*MultiMigMember, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MultiMigMember{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionMultiMigMembers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionMultiMigMembersListCall struct {
	s            *Service
	project      string
	region       string
	multiMig     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of members of a specific multi-MIG.
//
//   - multiMig: The name of the multi-MIG.
//     Name should conform to RFC1035 or be a resource ID.
//   - project: Project ID for this request.
//   - region: Name of the region for this request. Region name should conform to
//     RFC1035.
func (r *RegionMultiMigMembersService) List(project string, region string, multiMig string) *RegionMultiMigMembersListCall {
	c := &RegionMultiMigMembersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.multiMig = multiMig
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionMultiMigMembersListCall) Filter(filter string) *RegionMultiMigMembersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionMultiMigMembersListCall) MaxResults(maxResults int64) *RegionMultiMigMembersListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionMultiMigMembersListCall) OrderBy(orderBy string) *RegionMultiMigMembersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionMultiMigMembersListCall) PageToken(pageToken string) *RegionMultiMigMembersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionMultiMigMembersListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionMultiMigMembersListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionMultiMigMembersListCall) Fields(s ...googleapi.Field) *RegionMultiMigMembersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionMultiMigMembersListCall) IfNoneMatch(entityTag string) *RegionMultiMigMembersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionMultiMigMembersListCall) Context(ctx context.Context) *RegionMultiMigMembersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionMultiMigMembersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionMultiMigMembersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/multiMigs/{multiMig}/multiMigMembers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"multiMig": c.multiMig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionMultiMigMembers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionMultiMigMembers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *MultiMigMemberList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionMultiMigMembersListCall) Do(opts ...googleapi.CallOption) (*MultiMigMemberList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MultiMigMemberList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionMultiMigMembers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionMultiMigMembersListCall) Pages(ctx context.Context, f func(*MultiMigMemberList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionMultiMigsDeleteCall struct {
	s          *Service
	project    string
	region     string
	multiMig   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a multi-MIG in the specified project.
//
// - multiMig: Name of the multi-MIG to delete.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionMultiMigsService) Delete(project string, region string, multiMig string) *RegionMultiMigsDeleteCall {
	c := &RegionMultiMigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.multiMig = multiMig
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionMultiMigsDeleteCall) RequestId(requestId string) *RegionMultiMigsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionMultiMigsDeleteCall) Fields(s ...googleapi.Field) *RegionMultiMigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionMultiMigsDeleteCall) Context(ctx context.Context) *RegionMultiMigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionMultiMigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionMultiMigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/multiMigs/{multiMig}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"multiMig": c.multiMig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionMultiMigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionMultiMigsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionMultiMigsGetCall struct {
	s            *Service
	project      string
	region       string
	multiMig     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns all the details of a specific multi-MIG.
//
// - multiMig: Name of the multi-MIG resource to return.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionMultiMigsService) Get(project string, region string, multiMig string) *RegionMultiMigsGetCall {
	c := &RegionMultiMigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.multiMig = multiMig
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionMultiMigsGetCall) Fields(s ...googleapi.Field) *RegionMultiMigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionMultiMigsGetCall) IfNoneMatch(entityTag string) *RegionMultiMigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionMultiMigsGetCall) Context(ctx context.Context) *RegionMultiMigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionMultiMigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionMultiMigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/multiMigs/{multiMig}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"multiMig": c.multiMig,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionMultiMigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *MultiMig.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionMultiMigsGetCall) Do(opts ...googleapi.CallOption) (*MultiMig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MultiMig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionMultiMigsInsertCall struct {
	s          *Service
	project    string
	region     string
	multimig   *MultiMig
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a multi-MIG in the specified project.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionMultiMigsService) Insert(project string, region string, multimig *MultiMig) *RegionMultiMigsInsertCall {
	c := &RegionMultiMigsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.multimig = multimig
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents you from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionMultiMigsInsertCall) RequestId(requestId string) *RegionMultiMigsInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionMultiMigsInsertCall) Fields(s ...googleapi.Field) *RegionMultiMigsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionMultiMigsInsertCall) Context(ctx context.Context) *RegionMultiMigsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionMultiMigsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionMultiMigsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.multimig)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/multiMigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionMultiMigs.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionMultiMigsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionMultiMigsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of multi-MIGs in a project and region.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionMultiMigsService) List(project string, region string) *RegionMultiMigsListCall {
	c := &RegionMultiMigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionMultiMigsListCall) Filter(filter string) *RegionMultiMigsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionMultiMigsListCall) MaxResults(maxResults int64) *RegionMultiMigsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionMultiMigsListCall) OrderBy(orderBy string) *RegionMultiMigsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionMultiMigsListCall) PageToken(pageToken string) *RegionMultiMigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionMultiMigsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionMultiMigsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionMultiMigsListCall) Fields(s ...googleapi.Field) *RegionMultiMigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionMultiMigsListCall) IfNoneMatch(entityTag string) *RegionMultiMigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionMultiMigsListCall) Context(ctx context.Context) *RegionMultiMigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionMultiMigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionMultiMigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/multiMigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionMultiMigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *MultiMigsList.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionMultiMigsListCall) Do(opts ...googleapi.CallOption) (*MultiMigsList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &MultiMigsList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionMultiMigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionMultiMigsListCall) Pages(ctx context.Context, f func(*MultiMigsList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNetworkEndpointGroupsAttachNetworkEndpointsCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	networkEndpointGroup                              string
	regionnetworkendpointgroupsattachendpointsrequest *RegionNetworkEndpointGroupsAttachEndpointsRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// AttachNetworkEndpoints: Attach a list of network endpoints to the specified
// network endpoint group.
//
//   - networkEndpointGroup: The name of the network endpoint group where you are
//     attaching network
//
// endpoints to. It should comply with RFC1035.
//   - project: Project ID for this request.
//   - region: The name of the region where
//     you want to create the network endpoint group. It should comply
//     with
//
// RFC1035.
func (r *RegionNetworkEndpointGroupsService) AttachNetworkEndpoints(project string, region string, networkEndpointGroup string, regionnetworkendpointgroupsattachendpointsrequest *RegionNetworkEndpointGroupsAttachEndpointsRequest) *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall {
	c := &RegionNetworkEndpointGroupsAttachNetworkEndpointsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkEndpointGroup = networkEndpointGroup
	c.regionnetworkendpointgroupsattachendpointsrequest = regionnetworkendpointgroupsattachendpointsrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall) RequestId(requestId string) *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionnetworkendpointgroupsattachendpointsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"networkEndpointGroup": c.networkEndpointGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.attachNetworkEndpoints", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.attachNetworkEndpoints" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkEndpointGroupsAttachNetworkEndpointsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.attachNetworkEndpoints", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkEndpointGroupsDeleteCall struct {
	s                    *Service
	project              string
	region               string
	networkEndpointGroup string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Delete: Deletes the specified network endpoint group. Note that the NEG
// cannot be
// deleted if it is configured as a backend of a backend service.
//
//   - networkEndpointGroup: The name of the network endpoint group to delete. It
//     should comply with
//
// RFC1035.
//   - project: Project ID for this request.
//   - region: The name of the region where
//     the network endpoint group is located. It should comply with RFC1035.
func (r *RegionNetworkEndpointGroupsService) Delete(project string, region string, networkEndpointGroup string) *RegionNetworkEndpointGroupsDeleteCall {
	c := &RegionNetworkEndpointGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkEndpointGroup = networkEndpointGroup
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkEndpointGroupsDeleteCall) RequestId(requestId string) *RegionNetworkEndpointGroupsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsDeleteCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsDeleteCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"networkEndpointGroup": c.networkEndpointGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkEndpointGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkEndpointGroupsDetachNetworkEndpointsCall struct {
	s                                                 *Service
	project                                           string
	region                                            string
	networkEndpointGroup                              string
	regionnetworkendpointgroupsdetachendpointsrequest *RegionNetworkEndpointGroupsDetachEndpointsRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// DetachNetworkEndpoints: Detach the network endpoint from the specified
// network endpoint group.
//
//   - networkEndpointGroup: The name of the network endpoint group you are
//     detaching network
//
// endpoints from. It should comply with RFC1035.
//   - project: Project ID for this request.
//   - region: The name of the region where
//     the network endpoint group is located. It should comply with
//
// RFC1035.
func (r *RegionNetworkEndpointGroupsService) DetachNetworkEndpoints(project string, region string, networkEndpointGroup string, regionnetworkendpointgroupsdetachendpointsrequest *RegionNetworkEndpointGroupsDetachEndpointsRequest) *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall {
	c := &RegionNetworkEndpointGroupsDetachNetworkEndpointsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkEndpointGroup = networkEndpointGroup
	c.regionnetworkendpointgroupsdetachendpointsrequest = regionnetworkendpointgroupsdetachendpointsrequest
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
// end_interface: MixerMutationRequestBuilder
func (c *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall) RequestId(requestId string) *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionnetworkendpointgroupsdetachendpointsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"networkEndpointGroup": c.networkEndpointGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.detachNetworkEndpoints", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.detachNetworkEndpoints" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkEndpointGroupsDetachNetworkEndpointsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.detachNetworkEndpoints", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkEndpointGroupsGetCall struct {
	s                    *Service
	project              string
	region               string
	networkEndpointGroup string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// Get: Returns the specified network endpoint group.
//
//   - networkEndpointGroup: The name of the network endpoint group. It should
//     comply with RFC1035.
//   - project: Project ID for this request.
//   - region: The name of the region where
//     the network endpoint group is located. It should comply with RFC1035.
func (r *RegionNetworkEndpointGroupsService) Get(project string, region string, networkEndpointGroup string) *RegionNetworkEndpointGroupsGetCall {
	c := &RegionNetworkEndpointGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkEndpointGroup = networkEndpointGroup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsGetCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkEndpointGroupsGetCall) IfNoneMatch(entityTag string) *RegionNetworkEndpointGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsGetCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"networkEndpointGroup": c.networkEndpointGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkEndpointGroup.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionNetworkEndpointGroupsGetCall) Do(opts ...googleapi.CallOption) (*NetworkEndpointGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkEndpointGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkEndpointGroupsInsertCall struct {
	s                    *Service
	project              string
	region               string
	networkendpointgroup *NetworkEndpointGroup
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Insert: Creates a network endpoint group in the specified project using
// the
// parameters that are included in the request.
//
//   - project: Project ID for this request.
//   - region: The name of the region where
//     you want to create the network endpoint group. It should comply
//     with
//
// RFC1035.
func (r *RegionNetworkEndpointGroupsService) Insert(project string, region string, networkendpointgroup *NetworkEndpointGroup) *RegionNetworkEndpointGroupsInsertCall {
	c := &RegionNetworkEndpointGroupsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkendpointgroup = networkendpointgroup
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkEndpointGroupsInsertCall) RequestId(requestId string) *RegionNetworkEndpointGroupsInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsInsertCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsInsertCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.networkendpointgroup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkEndpointGroupsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkEndpointGroupsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of regional network endpoint groups available to
// the
// specified project in the given region.
//
//   - project: Project ID for this request.
//   - region: The name of theregion
//     where the network endpoint group is located. It should comply with
//     RFC1035.
func (r *RegionNetworkEndpointGroupsService) List(project string, region string) *RegionNetworkEndpointGroupsListCall {
	c := &RegionNetworkEndpointGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNetworkEndpointGroupsListCall) Filter(filter string) *RegionNetworkEndpointGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNetworkEndpointGroupsListCall) MaxResults(maxResults int64) *RegionNetworkEndpointGroupsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNetworkEndpointGroupsListCall) OrderBy(orderBy string) *RegionNetworkEndpointGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNetworkEndpointGroupsListCall) PageToken(pageToken string) *RegionNetworkEndpointGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNetworkEndpointGroupsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNetworkEndpointGroupsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsListCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkEndpointGroupsListCall) IfNoneMatch(entityTag string) *RegionNetworkEndpointGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsListCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkEndpointGroupList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkEndpointGroupsListCall) Do(opts ...googleapi.CallOption) (*NetworkEndpointGroupList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkEndpointGroupList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNetworkEndpointGroupsListCall) Pages(ctx context.Context, f func(*NetworkEndpointGroupList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNetworkEndpointGroupsListNetworkEndpointsCall struct {
	s                    *Service
	project              string
	region               string
	networkEndpointGroup string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// ListNetworkEndpoints: Lists the network endpoints in the specified network
// endpoint group.
//
//   - networkEndpointGroup: The name of the network endpoint group from which
//     you want to generate a
//     list of included network endpoints. It should comply with RFC1035.
//   - project: Project ID for this request.
//   - region: The name of theregion
//     where the network endpoint group is located. It should comply with
//     RFC1035.
func (r *RegionNetworkEndpointGroupsService) ListNetworkEndpoints(project string, region string, networkEndpointGroup string) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c := &RegionNetworkEndpointGroupsListNetworkEndpointsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkEndpointGroup = networkEndpointGroup
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) Filter(filter string) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) MaxResults(maxResults int64) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) OrderBy(orderBy string) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) PageToken(pageToken string) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) Fields(s ...googleapi.Field) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) Context(ctx context.Context) *RegionNetworkEndpointGroupsListNetworkEndpointsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"networkEndpointGroup": c.networkEndpointGroup,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.listNetworkEndpoints", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkEndpointGroups.listNetworkEndpoints" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkEndpointGroupsListNetworkEndpoints.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) Do(opts ...googleapi.CallOption) (*NetworkEndpointGroupsListNetworkEndpoints, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkEndpointGroupsListNetworkEndpoints{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkEndpointGroups.listNetworkEndpoints", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNetworkEndpointGroupsListNetworkEndpointsCall) Pages(ctx context.Context, f func(*NetworkEndpointGroupsListNetworkEndpoints) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNetworkFirewallPoliciesAddAssociationCall struct {
	s                         *Service
	project                   string
	region                    string
	firewallPolicy            string
	firewallpolicyassociation *FirewallPolicyAssociation
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// AddAssociation: Inserts an association for the specified network firewall
// policy.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) AddAssociation(project string, region string, firewallPolicy string, firewallpolicyassociation *FirewallPolicyAssociation) *RegionNetworkFirewallPoliciesAddAssociationCall {
	c := &RegionNetworkFirewallPoliciesAddAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	c.firewallpolicyassociation = firewallpolicyassociation
	return c
}

// AssociatedPolicyToBeReplaced sets the optional parameter
// "associatedPolicyToBeReplaced": Name of the firewall policy associated with
// the target network to swap
// association with. This field is mutually exclusive
// with
// 'replace_existing_association'.
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) AssociatedPolicyToBeReplaced(associatedPolicyToBeReplaced string) *RegionNetworkFirewallPoliciesAddAssociationCall {
	c.urlParams_.Set("associatedPolicyToBeReplaced", associatedPolicyToBeReplaced)
	return c
}

// ReplaceExistingAssociation sets the optional parameter
// "replaceExistingAssociation": Indicates whether or not to replace it if an
// association already exists.
// This is false by default, in which case an error will be returned if
// an
// association already exists.
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) ReplaceExistingAssociation(replaceExistingAssociation bool) *RegionNetworkFirewallPoliciesAddAssociationCall {
	c.urlParams_.Set("replaceExistingAssociation", fmt.Sprint(replaceExistingAssociation))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesAddAssociationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesAddAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesAddAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesAddAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallpolicyassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.addAssociation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.addAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesAddAssociationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.addAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesAddRuleCall struct {
	s                  *Service
	project            string
	region             string
	firewallPolicy     string
	firewallpolicyrule *FirewallPolicyRule
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// AddRule: Inserts a rule into a network firewall policy.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) AddRule(project string, region string, firewallPolicy string, firewallpolicyrule *FirewallPolicyRule) *RegionNetworkFirewallPoliciesAddRuleCall {
	c := &RegionNetworkFirewallPoliciesAddRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	c.firewallpolicyrule = firewallpolicyrule
	return c
}

// MaxPriority sets the optional parameter "maxPriority": When rule.priority is
// not specified, auto choose a unused priority betweenminPriority and
// maxPriority>.
// This field is exclusive with rule.priority.
func (c *RegionNetworkFirewallPoliciesAddRuleCall) MaxPriority(maxPriority int64) *RegionNetworkFirewallPoliciesAddRuleCall {
	c.urlParams_.Set("maxPriority", fmt.Sprint(maxPriority))
	return c
}

// MinPriority sets the optional parameter "minPriority": When rule.priority is
// not specified, auto choose a unused priority betweenminPriority and
// maxPriority>.
// This field is exclusive with rule.priority.
func (c *RegionNetworkFirewallPoliciesAddRuleCall) MinPriority(minPriority int64) *RegionNetworkFirewallPoliciesAddRuleCall {
	c.urlParams_.Set("minPriority", fmt.Sprint(minPriority))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesAddRuleCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesAddRuleCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesAddRuleCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesAddRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesAddRuleCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesAddRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesAddRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesAddRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallpolicyrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.addRule", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.addRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesAddRuleCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.addRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesCloneRulesCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// CloneRules: Copies rules to the specified network firewall policy.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) CloneRules(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesCloneRulesCall {
	c := &RegionNetworkFirewallPoliciesCloneRulesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesCloneRulesCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesCloneRulesCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SourceFirewallPolicy sets the optional parameter "sourceFirewallPolicy": The
// firewall policy from which to copy rules.
func (c *RegionNetworkFirewallPoliciesCloneRulesCall) SourceFirewallPolicy(sourceFirewallPolicy string) *RegionNetworkFirewallPoliciesCloneRulesCall {
	c.urlParams_.Set("sourceFirewallPolicy", sourceFirewallPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesCloneRulesCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesCloneRulesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesCloneRulesCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesCloneRulesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesCloneRulesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesCloneRulesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/cloneRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.cloneRules", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.cloneRules" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesCloneRulesCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.cloneRules", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesDeleteCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Delete: Deletes the specified network firewall policy.
//
// - firewallPolicy: Name of the firewall policy to delete.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) Delete(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesDeleteCall {
	c := &RegionNetworkFirewallPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesDeleteCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesDeleteCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesDeleteCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesGetCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// Get: Returns the specified network firewall policy.
//
// - firewallPolicy: Name of the firewall policy to get.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) Get(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesGetCall {
	c := &RegionNetworkFirewallPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesGetCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkFirewallPoliciesGetCall) IfNoneMatch(entityTag string) *RegionNetworkFirewallPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesGetCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirewallPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesGetCall) Do(opts ...googleapi.CallOption) (*FirewallPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirewallPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesGetAssociationCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// GetAssociation: Gets an association with the specified name.
//
//   - firewallPolicy: Name of the firewall policy to which the queried
//     association belongs.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) GetAssociation(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesGetAssociationCall {
	c := &RegionNetworkFirewallPoliciesGetAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// Name sets the optional parameter "name": The name of the association to get
// from the firewall policy.
func (c *RegionNetworkFirewallPoliciesGetAssociationCall) Name(name string) *RegionNetworkFirewallPoliciesGetAssociationCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesGetAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesGetAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkFirewallPoliciesGetAssociationCall) IfNoneMatch(entityTag string) *RegionNetworkFirewallPoliciesGetAssociationCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesGetAssociationCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesGetAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesGetAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesGetAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getAssociation", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.getAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirewallPolicyAssociation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesGetAssociationCall) Do(opts ...googleapi.CallOption) (*FirewallPolicyAssociation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirewallPolicyAssociation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEffectiveFirewalls: Returns the effective firewalls on a given network.
//
// - network: Network reference.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) GetEffectiveFirewalls(project string, region string, network string) *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall {
	c := &RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.urlParams_.Set("network", network)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall) IfNoneMatch(entityTag string) *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/getEffectiveFirewalls")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getEffectiveFirewalls", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.getEffectiveFirewalls" call.
// Any non-2xx status code is an error. Response headers are in either
// *RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesGetEffectiveFirewallsCall) Do(opts ...googleapi.CallOption) (*RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getEffectiveFirewalls", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesGetIamPolicyCall struct {
	s            *Service
	project      string
	region       string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May be empty if
// no such
// policy or resource exists.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionNetworkFirewallPoliciesService) GetIamPolicy(project string, region string, resource string) *RegionNetworkFirewallPoliciesGetIamPolicyCall {
	c := &RegionNetworkFirewallPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "optionsRequestedPolicyVersion": Requested IAM Policy version.
func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *RegionNetworkFirewallPoliciesGetIamPolicyCall {
	c.urlParams_.Set("optionsRequestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) IfNoneMatch(entityTag string) *RegionNetworkFirewallPoliciesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesGetRuleCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ifNoneMatch_   string
	ctx_           context.Context
	header_        http.Header
}

// GetRule: Gets a rule of the specified priority.
//
//   - firewallPolicy: Name of the firewall policy to which the queried rule
//     belongs.
//   - project: Project ID for this request.
//   - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) GetRule(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesGetRuleCall {
	c := &RegionNetworkFirewallPoliciesGetRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// Priority sets the optional parameter "priority": The priority of the rule to
// get from the firewall policy.
func (c *RegionNetworkFirewallPoliciesGetRuleCall) Priority(priority int64) *RegionNetworkFirewallPoliciesGetRuleCall {
	c.urlParams_.Set("priority", fmt.Sprint(priority))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesGetRuleCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesGetRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkFirewallPoliciesGetRuleCall) IfNoneMatch(entityTag string) *RegionNetworkFirewallPoliciesGetRuleCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesGetRuleCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesGetRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesGetRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesGetRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getRule", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.getRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirewallPolicyRule.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionNetworkFirewallPoliciesGetRuleCall) Do(opts ...googleapi.CallOption) (*FirewallPolicyRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirewallPolicyRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.getRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesInsertCall struct {
	s              *Service
	project        string
	region         string
	firewallpolicy *FirewallPolicy
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Insert: Creates a new network firewall policy in the specified project and
// region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) Insert(project string, region string, firewallpolicy *FirewallPolicy) *RegionNetworkFirewallPoliciesInsertCall {
	c := &RegionNetworkFirewallPoliciesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallpolicy = firewallpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID
// so that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesInsertCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesInsertCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesInsertCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the network firewall policies that have been configured
// for the specified project in the given region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) List(project string, region string) *RegionNetworkFirewallPoliciesListCall {
	c := &RegionNetworkFirewallPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNetworkFirewallPoliciesListCall) Filter(filter string) *RegionNetworkFirewallPoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNetworkFirewallPoliciesListCall) MaxResults(maxResults int64) *RegionNetworkFirewallPoliciesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNetworkFirewallPoliciesListCall) OrderBy(orderBy string) *RegionNetworkFirewallPoliciesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNetworkFirewallPoliciesListCall) PageToken(pageToken string) *RegionNetworkFirewallPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNetworkFirewallPoliciesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNetworkFirewallPoliciesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesListCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkFirewallPoliciesListCall) IfNoneMatch(entityTag string) *RegionNetworkFirewallPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesListCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *FirewallPolicyList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionNetworkFirewallPoliciesListCall) Do(opts ...googleapi.CallOption) (*FirewallPolicyList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FirewallPolicyList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNetworkFirewallPoliciesListCall) Pages(ctx context.Context, f func(*FirewallPolicyList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNetworkFirewallPoliciesPatchCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	firewallpolicy *FirewallPolicy
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Patch: Patches the specified network firewall policy.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) Patch(project string, region string, firewallPolicy string, firewallpolicy *FirewallPolicy) *RegionNetworkFirewallPoliciesPatchCall {
	c := &RegionNetworkFirewallPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	c.firewallpolicy = firewallpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesPatchCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesPatchCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesPatchCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesPatchAssociationCall struct {
	s                         *Service
	project                   string
	region                    string
	firewallPolicy            string
	firewallpolicyassociation *FirewallPolicyAssociation
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// PatchAssociation: Updates an association for the specified network firewall
// policy.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) PatchAssociation(project string, region string, firewallPolicy string, firewallpolicyassociation *FirewallPolicyAssociation) *RegionNetworkFirewallPoliciesPatchAssociationCall {
	c := &RegionNetworkFirewallPoliciesPatchAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	c.firewallpolicyassociation = firewallpolicyassociation
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesPatchAssociationCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesPatchAssociationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesPatchAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesPatchAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesPatchAssociationCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesPatchAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesPatchAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesPatchAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallpolicyassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/patchAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.patchAssociation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.patchAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesPatchAssociationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.patchAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesPatchRuleCall struct {
	s                  *Service
	project            string
	region             string
	firewallPolicy     string
	firewallpolicyrule *FirewallPolicyRule
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// PatchRule: Patches a rule of the specified priority.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) PatchRule(project string, region string, firewallPolicy string, firewallpolicyrule *FirewallPolicyRule) *RegionNetworkFirewallPoliciesPatchRuleCall {
	c := &RegionNetworkFirewallPoliciesPatchRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	c.firewallpolicyrule = firewallpolicyrule
	return c
}

// Priority sets the optional parameter "priority": The priority of the rule to
// patch.
func (c *RegionNetworkFirewallPoliciesPatchRuleCall) Priority(priority int64) *RegionNetworkFirewallPoliciesPatchRuleCall {
	c.urlParams_.Set("priority", fmt.Sprint(priority))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesPatchRuleCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesPatchRuleCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesPatchRuleCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesPatchRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesPatchRuleCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesPatchRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesPatchRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesPatchRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.firewallpolicyrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/patchRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.patchRule", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.patchRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesPatchRuleCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.patchRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesRemoveAssociationCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// RemoveAssociation: Removes an association for the specified network firewall
// policy.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) RemoveAssociation(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesRemoveAssociationCall {
	c := &RegionNetworkFirewallPoliciesRemoveAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// Name sets the optional parameter "name": Name for the association that will
// be removed.
func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) Name(name string) *RegionNetworkFirewallPoliciesRemoveAssociationCall {
	c.urlParams_.Set("name", name)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesRemoveAssociationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesRemoveAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesRemoveAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.removeAssociation", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.removeAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesRemoveAssociationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.removeAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesRemoveRuleCall struct {
	s              *Service
	project        string
	region         string
	firewallPolicy string
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// RemoveRule: Deletes a rule of the specified priority.
//
// - firewallPolicy: Name of the firewall policy to update.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNetworkFirewallPoliciesService) RemoveRule(project string, region string, firewallPolicy string) *RegionNetworkFirewallPoliciesRemoveRuleCall {
	c := &RegionNetworkFirewallPoliciesRemoveRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.firewallPolicy = firewallPolicy
	return c
}

// Priority sets the optional parameter "priority": The priority of the rule to
// remove from the firewall policy.
func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) Priority(priority int64) *RegionNetworkFirewallPoliciesRemoveRuleCall {
	c.urlParams_.Set("priority", fmt.Sprint(priority))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) RequestId(requestId string) *RegionNetworkFirewallPoliciesRemoveRuleCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesRemoveRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesRemoveRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":        c.project,
		"region":         c.region,
		"firewallPolicy": c.firewallPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.removeRule", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.removeRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesRemoveRuleCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.removeRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesSetIamPolicyCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetpolicyrequest *RegionSetPolicyRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource.
// Replaces any existing policy.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionNetworkFirewallPoliciesService) SetIamPolicy(project string, region string, resource string, regionsetpolicyrequest *RegionSetPolicyRequest) *RegionNetworkFirewallPoliciesSetIamPolicyCall {
	c := &RegionNetworkFirewallPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetpolicyrequest = regionsetpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesSetIamPolicyCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkFirewallPoliciesTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionNetworkFirewallPoliciesService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionNetworkFirewallPoliciesTestIamPermissionsCall {
	c := &RegionNetworkFirewallPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkFirewallPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionNetworkFirewallPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkFirewallPoliciesTestIamPermissionsCall) Context(ctx context.Context) *RegionNetworkFirewallPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkFirewallPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkFirewallPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/firewallPolicies/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkFirewallPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkFirewallPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkFirewallPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesAddAssociationCall struct {
	s                        *Service
	project                  string
	region                   string
	networkPolicy            string
	networkpolicyassociation *NetworkPolicyAssociation
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// AddAssociation: Inserts an association for the specified network policy.
//
// - networkPolicy: Name of the network policy resource to update.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) AddAssociation(project string, region string, networkPolicy string, networkpolicyassociation *NetworkPolicyAssociation) *RegionNetworkPoliciesAddAssociationCall {
	c := &RegionNetworkPoliciesAddAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	c.networkpolicyassociation = networkpolicyassociation
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesAddAssociationCall) RequestId(requestId string) *RegionNetworkPoliciesAddAssociationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesAddAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesAddAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesAddAssociationCall) Context(ctx context.Context) *RegionNetworkPoliciesAddAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesAddAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesAddAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.networkpolicyassociation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/addAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.addAssociation", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.addAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesAddAssociationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.addAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesAddTrafficClassificationRuleCall struct {
	s                                      *Service
	project                                string
	region                                 string
	networkPolicy                          string
	networkpolicytrafficclassificationrule *NetworkPolicyTrafficClassificationRule
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// AddTrafficClassificationRule: Inserts a rule into a network policy.
//
// - networkPolicy: Name of the network policy resource to update.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) AddTrafficClassificationRule(project string, region string, networkPolicy string, networkpolicytrafficclassificationrule *NetworkPolicyTrafficClassificationRule) *RegionNetworkPoliciesAddTrafficClassificationRuleCall {
	c := &RegionNetworkPoliciesAddTrafficClassificationRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	c.networkpolicytrafficclassificationrule = networkpolicytrafficclassificationrule
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesAddTrafficClassificationRuleCall) RequestId(requestId string) *RegionNetworkPoliciesAddTrafficClassificationRuleCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesAddTrafficClassificationRuleCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesAddTrafficClassificationRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesAddTrafficClassificationRuleCall) Context(ctx context.Context) *RegionNetworkPoliciesAddTrafficClassificationRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesAddTrafficClassificationRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesAddTrafficClassificationRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.networkpolicytrafficclassificationrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/addTrafficClassificationRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.addTrafficClassificationRule", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.addTrafficClassificationRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesAddTrafficClassificationRuleCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.addTrafficClassificationRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesAggregatedListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AggregatedList: Retrieves an aggregated list of network policies.
//
// To prevent failure, it's recommended that you set the
// `returnPartialSuccess` parameter to `true`.
//
// - project: Project ID for this request.
func (r *RegionNetworkPoliciesService) AggregatedList(project string) *RegionNetworkPoliciesAggregatedListCall {
	c := &RegionNetworkPoliciesAggregatedListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNetworkPoliciesAggregatedListCall) Filter(filter string) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IncludeAllScopes sets the optional parameter "includeAllScopes": Indicates
// whether every visible scope for each scope type (zone, region,
// global) should be included in the response. For new resource types
// added
// after this field, the flag has no effect as new resource types will
// always
// include every visible scope for each scope type in response. For
// resource
// types which predate this field, if this flag is omitted or false,
// only
// scopes of the scope types where the resource type is expected to be
// found
// will be included.
func (c *RegionNetworkPoliciesAggregatedListCall) IncludeAllScopes(includeAllScopes bool) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("includeAllScopes", fmt.Sprint(includeAllScopes))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNetworkPoliciesAggregatedListCall) MaxResults(maxResults int64) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNetworkPoliciesAggregatedListCall) OrderBy(orderBy string) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNetworkPoliciesAggregatedListCall) PageToken(pageToken string) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNetworkPoliciesAggregatedListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// ServiceProjectNumber sets the optional parameter "serviceProjectNumber": The
// Shared VPC service project id or service project number for which
// aggregated list request is invoked for subnetworks list-usable api.
func (c *RegionNetworkPoliciesAggregatedListCall) ServiceProjectNumber(serviceProjectNumber int64) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("serviceProjectNumber", fmt.Sprint(serviceProjectNumber))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesAggregatedListCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesAggregatedListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkPoliciesAggregatedListCall) IfNoneMatch(entityTag string) *RegionNetworkPoliciesAggregatedListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesAggregatedListCall) Context(ctx context.Context) *RegionNetworkPoliciesAggregatedListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesAggregatedListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesAggregatedListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/aggregated/networkPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.aggregatedList", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.aggregatedList" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkPolicyAggregatedList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesAggregatedListCall) Do(opts ...googleapi.CallOption) (*NetworkPolicyAggregatedList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPolicyAggregatedList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.aggregatedList", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNetworkPoliciesAggregatedListCall) Pages(ctx context.Context, f func(*NetworkPolicyAggregatedList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNetworkPoliciesDeleteCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Delete: Deletes the specified policy.
//
// - networkPolicy: Name of the network policy resource to delete.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) Delete(project string, region string, networkPolicy string) *RegionNetworkPoliciesDeleteCall {
	c := &RegionNetworkPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesDeleteCall) RequestId(requestId string) *RegionNetworkPoliciesDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesDeleteCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesDeleteCall) Context(ctx context.Context) *RegionNetworkPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesGetCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// Get: Returns the specified network policy.
//
// - networkPolicy: Name of the network policy resource to return.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) Get(project string, region string, networkPolicy string) *RegionNetworkPoliciesGetCall {
	c := &RegionNetworkPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesGetCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkPoliciesGetCall) IfNoneMatch(entityTag string) *RegionNetworkPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesGetCall) Context(ctx context.Context) *RegionNetworkPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesGetCall) Do(opts ...googleapi.CallOption) (*NetworkPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesGetAssociationCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// GetAssociation: Gets an association with the specified name.
//
//   - networkPolicy: Name of the network policy to which the queried association
//     belongs.
//   - project: Project ID for this request.
//   - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) GetAssociation(project string, region string, networkPolicy string) *RegionNetworkPoliciesGetAssociationCall {
	c := &RegionNetworkPoliciesGetAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	return c
}

// Name sets the optional parameter "name": The name of the association to get
// from the network policy.
func (c *RegionNetworkPoliciesGetAssociationCall) Name(name string) *RegionNetworkPoliciesGetAssociationCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesGetAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesGetAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkPoliciesGetAssociationCall) IfNoneMatch(entityTag string) *RegionNetworkPoliciesGetAssociationCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesGetAssociationCall) Context(ctx context.Context) *RegionNetworkPoliciesGetAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesGetAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesGetAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/getAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.getAssociation", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.getAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkPolicyAssociation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesGetAssociationCall) Do(opts ...googleapi.CallOption) (*NetworkPolicyAssociation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPolicyAssociation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.getAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesGetTrafficClassificationRuleCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	urlParams_    gensupport.URLParams
	ifNoneMatch_  string
	ctx_          context.Context
	header_       http.Header
}

// GetTrafficClassificationRule: Gets a rule of the specified priority.
//
//   - networkPolicy: Name of the network policy to which the queried rule
//     belongs.
//   - project: Project ID for this request.
//   - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) GetTrafficClassificationRule(project string, region string, networkPolicy string) *RegionNetworkPoliciesGetTrafficClassificationRuleCall {
	c := &RegionNetworkPoliciesGetTrafficClassificationRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	return c
}

// Priority sets the optional parameter "priority": The priority of the rule to
// get from the network policy.
func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) Priority(priority int64) *RegionNetworkPoliciesGetTrafficClassificationRuleCall {
	c.urlParams_.Set("priority", fmt.Sprint(priority))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesGetTrafficClassificationRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) IfNoneMatch(entityTag string) *RegionNetworkPoliciesGetTrafficClassificationRuleCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) Context(ctx context.Context) *RegionNetworkPoliciesGetTrafficClassificationRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/getTrafficClassificationRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.getTrafficClassificationRule", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.getTrafficClassificationRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkPolicyTrafficClassificationRule.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesGetTrafficClassificationRuleCall) Do(opts ...googleapi.CallOption) (*NetworkPolicyTrafficClassificationRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPolicyTrafficClassificationRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.getTrafficClassificationRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesInsertCall struct {
	s             *Service
	project       string
	region        string
	networkpolicy *NetworkPolicy
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Insert: Creates a new policy in the specified project using the data
// included in
// the request.
//
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) Insert(project string, region string, networkpolicy *NetworkPolicy) *RegionNetworkPoliciesInsertCall {
	c := &RegionNetworkPoliciesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkpolicy = networkpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID
// so that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesInsertCall) RequestId(requestId string) *RegionNetworkPoliciesInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesInsertCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesInsertCall) Context(ctx context.Context) *RegionNetworkPoliciesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.networkpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the policies that have been configured for the specified
// project
// in the given region.
//
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) List(project string, region string) *RegionNetworkPoliciesListCall {
	c := &RegionNetworkPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNetworkPoliciesListCall) Filter(filter string) *RegionNetworkPoliciesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNetworkPoliciesListCall) MaxResults(maxResults int64) *RegionNetworkPoliciesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNetworkPoliciesListCall) OrderBy(orderBy string) *RegionNetworkPoliciesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNetworkPoliciesListCall) PageToken(pageToken string) *RegionNetworkPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNetworkPoliciesListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNetworkPoliciesListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesListCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNetworkPoliciesListCall) IfNoneMatch(entityTag string) *RegionNetworkPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesListCall) Context(ctx context.Context) *RegionNetworkPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *NetworkPolicyList.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionNetworkPoliciesListCall) Do(opts ...googleapi.CallOption) (*NetworkPolicyList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NetworkPolicyList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNetworkPoliciesListCall) Pages(ctx context.Context, f func(*NetworkPolicyList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNetworkPoliciesPatchCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	networkpolicy *NetworkPolicy
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Patch: Patches the specified policy with the data included in the
// request.
//
// - networkPolicy: Name of the network policy resource to update.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) Patch(project string, region string, networkPolicy string, networkpolicy *NetworkPolicy) *RegionNetworkPoliciesPatchCall {
	c := &RegionNetworkPoliciesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	c.networkpolicy = networkpolicy
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesPatchCall) RequestId(requestId string) *RegionNetworkPoliciesPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesPatchCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesPatchCall) Context(ctx context.Context) *RegionNetworkPoliciesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.networkpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesPatchTrafficClassificationRuleCall struct {
	s                                      *Service
	project                                string
	region                                 string
	networkPolicy                          string
	networkpolicytrafficclassificationrule *NetworkPolicyTrafficClassificationRule
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// PatchTrafficClassificationRule: Patches a rule of the specified priority.
//
// - networkPolicy: Name of the network policy resource to update.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) PatchTrafficClassificationRule(project string, region string, networkPolicy string, networkpolicytrafficclassificationrule *NetworkPolicyTrafficClassificationRule) *RegionNetworkPoliciesPatchTrafficClassificationRuleCall {
	c := &RegionNetworkPoliciesPatchTrafficClassificationRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	c.networkpolicytrafficclassificationrule = networkpolicytrafficclassificationrule
	return c
}

// Priority sets the optional parameter "priority": The priority of the traffic
// classification rule to patch. Only rules with
// a priority value between 1 and 2147482647 (inclusive) can be patched.
func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) Priority(priority int64) *RegionNetworkPoliciesPatchTrafficClassificationRuleCall {
	c.urlParams_.Set("priority", fmt.Sprint(priority))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) RequestId(requestId string) *RegionNetworkPoliciesPatchTrafficClassificationRuleCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesPatchTrafficClassificationRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) Context(ctx context.Context) *RegionNetworkPoliciesPatchTrafficClassificationRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.networkpolicytrafficclassificationrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/patchTrafficClassificationRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.patchTrafficClassificationRule", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.patchTrafficClassificationRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesPatchTrafficClassificationRuleCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.patchTrafficClassificationRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesRemoveAssociationCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// RemoveAssociation: Removes an association for the specified network policy.
//
// - networkPolicy: Name of the network policy resource to update.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) RemoveAssociation(project string, region string, networkPolicy string) *RegionNetworkPoliciesRemoveAssociationCall {
	c := &RegionNetworkPoliciesRemoveAssociationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	return c
}

// Name sets the optional parameter "name": Name for the association that will
// be removed.
func (c *RegionNetworkPoliciesRemoveAssociationCall) Name(name string) *RegionNetworkPoliciesRemoveAssociationCall {
	c.urlParams_.Set("name", name)
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesRemoveAssociationCall) RequestId(requestId string) *RegionNetworkPoliciesRemoveAssociationCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesRemoveAssociationCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesRemoveAssociationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesRemoveAssociationCall) Context(ctx context.Context) *RegionNetworkPoliciesRemoveAssociationCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesRemoveAssociationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesRemoveAssociationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/removeAssociation")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.removeAssociation", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.removeAssociation" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesRemoveAssociationCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.removeAssociation", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNetworkPoliciesRemoveTrafficClassificationRuleCall struct {
	s             *Service
	project       string
	region        string
	networkPolicy string
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// RemoveTrafficClassificationRule: Deletes a rule of the specified priority.
//
// - networkPolicy: Name of the network policy resource to update.
// - project: Project ID for this request.
// - region: Name of the region of this request.
func (r *RegionNetworkPoliciesService) RemoveTrafficClassificationRule(project string, region string, networkPolicy string) *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall {
	c := &RegionNetworkPoliciesRemoveTrafficClassificationRuleCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.networkPolicy = networkPolicy
	return c
}

// Priority sets the optional parameter "priority": The priority of the rule to
// remove from the network policy.
func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) Priority(priority int64) *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall {
	c.urlParams_.Set("priority", fmt.Sprint(priority))
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) RequestId(requestId string) *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) Fields(s ...googleapi.Field) *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) Context(ctx context.Context) *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/networkPolicies/{networkPolicy}/removeTrafficClassificationRule")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":       c.project,
		"region":        c.region,
		"networkPolicy": c.networkPolicy,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.removeTrafficClassificationRule", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNetworkPolicies.removeTrafficClassificationRule" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNetworkPoliciesRemoveTrafficClassificationRuleCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNetworkPolicies.removeTrafficClassificationRule", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNotificationEndpointsAggregatedListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AggregatedList: Retrieves the list of all NotificationEndpoint
// resources,
// regional and global, available to the specified project.
//
// - project: Name of the project scoping this request.
func (r *RegionNotificationEndpointsService) AggregatedList(project string) *RegionNotificationEndpointsAggregatedListCall {
	c := &RegionNotificationEndpointsAggregatedListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNotificationEndpointsAggregatedListCall) Filter(filter string) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// IncludeAllScopes sets the optional parameter "includeAllScopes": Indicates
// whether every visible scope for each scope type (zone, region,
// global) should be included in the response. For new resource types
// added
// after this field, the flag has no effect as new resource types will
// always
// include every visible scope for each scope type in response. For
// resource
// types which predate this field, if this flag is omitted or false,
// only
// scopes of the scope types where the resource type is expected to be
// found
// will be included.
func (c *RegionNotificationEndpointsAggregatedListCall) IncludeAllScopes(includeAllScopes bool) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("includeAllScopes", fmt.Sprint(includeAllScopes))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNotificationEndpointsAggregatedListCall) MaxResults(maxResults int64) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNotificationEndpointsAggregatedListCall) OrderBy(orderBy string) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNotificationEndpointsAggregatedListCall) PageToken(pageToken string) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNotificationEndpointsAggregatedListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// ServiceProjectNumber sets the optional parameter "serviceProjectNumber": The
// Shared VPC service project id or service project number for which
// aggregated list request is invoked for subnetworks list-usable api.
func (c *RegionNotificationEndpointsAggregatedListCall) ServiceProjectNumber(serviceProjectNumber int64) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("serviceProjectNumber", fmt.Sprint(serviceProjectNumber))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNotificationEndpointsAggregatedListCall) Fields(s ...googleapi.Field) *RegionNotificationEndpointsAggregatedListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNotificationEndpointsAggregatedListCall) IfNoneMatch(entityTag string) *RegionNotificationEndpointsAggregatedListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNotificationEndpointsAggregatedListCall) Context(ctx context.Context) *RegionNotificationEndpointsAggregatedListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNotificationEndpointsAggregatedListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNotificationEndpointsAggregatedListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/aggregated/notificationEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.aggregatedList", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNotificationEndpoints.aggregatedList" call.
// Any non-2xx status code is an error. Response headers are in either
// *NotificationEndpointAggregatedList.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNotificationEndpointsAggregatedListCall) Do(opts ...googleapi.CallOption) (*NotificationEndpointAggregatedList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NotificationEndpointAggregatedList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.aggregatedList", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNotificationEndpointsAggregatedListCall) Pages(ctx context.Context, f func(*NotificationEndpointAggregatedList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNotificationEndpointsDeleteCall struct {
	s                    *Service
	project              string
	region               string
	notificationEndpoint string
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Delete: Deletes the specified NotificationEndpoint in the given region
//
// - notificationEndpoint: Name of the NotificationEndpoint resource to delete.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNotificationEndpointsService) Delete(project string, region string, notificationEndpoint string) *RegionNotificationEndpointsDeleteCall {
	c := &RegionNotificationEndpointsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.notificationEndpoint = notificationEndpoint
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNotificationEndpointsDeleteCall) RequestId(requestId string) *RegionNotificationEndpointsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNotificationEndpointsDeleteCall) Fields(s ...googleapi.Field) *RegionNotificationEndpointsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNotificationEndpointsDeleteCall) Context(ctx context.Context) *RegionNotificationEndpointsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNotificationEndpointsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNotificationEndpointsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"notificationEndpoint": c.notificationEndpoint,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNotificationEndpoints.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNotificationEndpointsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNotificationEndpointsGetCall struct {
	s                    *Service
	project              string
	region               string
	notificationEndpoint string
	urlParams_           gensupport.URLParams
	ifNoneMatch_         string
	ctx_                 context.Context
	header_              http.Header
}

// Get: Returns the specified NotificationEndpoint resource in the given
// region.
//
// - notificationEndpoint: Name of the NotificationEndpoint resource to return.
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNotificationEndpointsService) Get(project string, region string, notificationEndpoint string) *RegionNotificationEndpointsGetCall {
	c := &RegionNotificationEndpointsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.notificationEndpoint = notificationEndpoint
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNotificationEndpointsGetCall) Fields(s ...googleapi.Field) *RegionNotificationEndpointsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNotificationEndpointsGetCall) IfNoneMatch(entityTag string) *RegionNotificationEndpointsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNotificationEndpointsGetCall) Context(ctx context.Context) *RegionNotificationEndpointsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNotificationEndpointsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNotificationEndpointsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":              c.project,
		"region":               c.region,
		"notificationEndpoint": c.notificationEndpoint,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNotificationEndpoints.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *NotificationEndpoint.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionNotificationEndpointsGetCall) Do(opts ...googleapi.CallOption) (*NotificationEndpoint, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NotificationEndpoint{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNotificationEndpointsInsertCall struct {
	s                    *Service
	project              string
	region               string
	notificationendpoint *NotificationEndpoint
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Insert: Create a NotificationEndpoint in the specified project in the given
// region
// using the parameters that are included in the request.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNotificationEndpointsService) Insert(project string, region string, notificationendpoint *NotificationEndpoint) *RegionNotificationEndpointsInsertCall {
	c := &RegionNotificationEndpointsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.notificationendpoint = notificationendpoint
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionNotificationEndpointsInsertCall) RequestId(requestId string) *RegionNotificationEndpointsInsertCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNotificationEndpointsInsertCall) Fields(s ...googleapi.Field) *RegionNotificationEndpointsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNotificationEndpointsInsertCall) Context(ctx context.Context) *RegionNotificationEndpointsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNotificationEndpointsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNotificationEndpointsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.notificationendpoint)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/notificationEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNotificationEndpoints.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionNotificationEndpointsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionNotificationEndpointsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the NotificationEndpoints for a project in the given region.
//
// - project: Project ID for this request.
// - region: Name of the region scoping this request.
func (r *RegionNotificationEndpointsService) List(project string, region string) *RegionNotificationEndpointsListCall {
	c := &RegionNotificationEndpointsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionNotificationEndpointsListCall) Filter(filter string) *RegionNotificationEndpointsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionNotificationEndpointsListCall) MaxResults(maxResults int64) *RegionNotificationEndpointsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionNotificationEndpointsListCall) OrderBy(orderBy string) *RegionNotificationEndpointsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionNotificationEndpointsListCall) PageToken(pageToken string) *RegionNotificationEndpointsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionNotificationEndpointsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionNotificationEndpointsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNotificationEndpointsListCall) Fields(s ...googleapi.Field) *RegionNotificationEndpointsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionNotificationEndpointsListCall) IfNoneMatch(entityTag string) *RegionNotificationEndpointsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNotificationEndpointsListCall) Context(ctx context.Context) *RegionNotificationEndpointsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNotificationEndpointsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNotificationEndpointsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/notificationEndpoints")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNotificationEndpoints.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *NotificationEndpointList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNotificationEndpointsListCall) Do(opts ...googleapi.CallOption) (*NotificationEndpointList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &NotificationEndpointList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionNotificationEndpointsListCall) Pages(ctx context.Context, f func(*NotificationEndpointList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionNotificationEndpointsTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionNotificationEndpointsService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionNotificationEndpointsTestIamPermissionsCall {
	c := &RegionNotificationEndpointsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionNotificationEndpointsTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionNotificationEndpointsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionNotificationEndpointsTestIamPermissionsCall) Context(ctx context.Context) *RegionNotificationEndpointsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionNotificationEndpointsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionNotificationEndpointsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/notificationEndpoints/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionNotificationEndpoints.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionNotificationEndpointsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionNotificationEndpoints.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionOperationsDeleteCall struct {
	s           *Service
	project     string
	region      string
	operationid string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes the specified region-specific Operations resource.
//
//   - operation: Name of the Operations resource to delete, or its unique
//     numeric
//
// identifier.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionOperationsService) Delete(project string, region string, operationid string) *RegionOperationsDeleteCall {
	c := &RegionOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.operationid = operationid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionOperationsDeleteCall) Fields(s ...googleapi.Field) *RegionOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionOperationsDeleteCall) Context(ctx context.Context) *RegionOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/operations/{operation}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":   c.project,
		"region":    c.region,
		"operation": c.operationid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionOperations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionOperations.delete" call.
func (c *RegionOperationsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionOperations.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type RegionOperationsGetCall struct {
	s            *Service
	project      string
	region       string
	operationid  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified region-specific Operations resource.
//
//   - operation: Name of the Operations resource to return, or its unique
//     numeric
//
// identifier.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionOperationsService) Get(project string, region string, operationid string) *RegionOperationsGetCall {
	c := &RegionOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.operationid = operationid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionOperationsGetCall) Fields(s ...googleapi.Field) *RegionOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionOperationsGetCall) IfNoneMatch(entityTag string) *RegionOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionOperationsGetCall) Context(ctx context.Context) *RegionOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/operations/{operation}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":   c.project,
		"region":    c.region,
		"operation": c.operationid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionOperations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionOperations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionOperations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionOperationsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of Operation resources contained within
// the specified region.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionOperationsService) List(project string, region string) *RegionOperationsListCall {
	c := &RegionOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionOperationsListCall) Filter(filter string) *RegionOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionOperationsListCall) MaxResults(maxResults int64) *RegionOperationsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionOperationsListCall) OrderBy(orderBy string) *RegionOperationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionOperationsListCall) PageToken(pageToken string) *RegionOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionOperationsListCall) Fields(s ...googleapi.Field) *RegionOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionOperationsListCall) IfNoneMatch(entityTag string) *RegionOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionOperationsListCall) Context(ctx context.Context) *RegionOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionOperations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionOperations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *OperationList.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionOperationsListCall) Do(opts ...googleapi.CallOption) (*OperationList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OperationList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionOperations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionOperationsListCall) Pages(ctx context.Context, f func(*OperationList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionOperationsWaitCall struct {
	s           *Service
	project     string
	region      string
	operationid string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Wait: Waits for the specified Operation resource to return as `DONE`
// or for the request to approach the 2 minute deadline, and retrieves
// the
// specified Operation resource. This method differs from the
// `GET` method in that it waits for no more than the default
// deadline (2 minutes) and then returns the current state of the
// operation,
// which might be `DONE` or still in progress.
//
// This method is called on a best-effort basis. Specifically:
//
//   - In uncommon cases, when the server is overloaded, the request might
//     return before the default deadline is reached, or might return after
//
// zero
//
//	 seconds.
//	- If the default deadline is reached, there is no guarantee that the
//	 operation is actually done when the method returns. Be prepared to
//
// retry
//
//		if the operation is not `DONE`.
//
//	  - operation: Name of the Operations resource to return, or its unique
//	    numeric
//
// identifier.
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionOperationsService) Wait(project string, region string, operationid string) *RegionOperationsWaitCall {
	c := &RegionOperationsWaitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.operationid = operationid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionOperationsWaitCall) Fields(s ...googleapi.Field) *RegionOperationsWaitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionOperationsWaitCall) Context(ctx context.Context) *RegionOperationsWaitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionOperationsWaitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionOperationsWaitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/operations/{operation}/wait")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":   c.project,
		"region":    c.region,
		"operation": c.operationid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionOperations.wait", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionOperations.wait" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionOperationsWaitCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionOperations.wait", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionRecoverableSnapshotsDeleteCall struct {
	s                   *Service
	project             string
	region              string
	recoverableSnapshot string
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Delete: Deletes the specified RecoverableSnapshot. Deleting a recoverable
// snapshot
// will delete the underlying PD snapshot and is irreversible.
//
// - project: Project ID for this request.
// - recoverableSnapshot: Name of the recoverable Snapshot resource to delete.
// - region: Name of the region for this request.
func (r *RegionRecoverableSnapshotsService) Delete(project string, region string, recoverableSnapshot string) *RegionRecoverableSnapshotsDeleteCall {
	c := &RegionRecoverableSnapshotsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.recoverableSnapshot = recoverableSnapshot
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionRecoverableSnapshotsDeleteCall) RequestId(requestId string) *RegionRecoverableSnapshotsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsDeleteCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsDeleteCall) Context(ctx context.Context) *RegionRecoverableSnapshotsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots/{recoverableSnapshot}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":             c.project,
		"region":              c.region,
		"recoverableSnapshot": c.recoverableSnapshot,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionRecoverableSnapshotsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionRecoverableSnapshotsGetCall struct {
	s                   *Service
	project             string
	region              string
	recoverableSnapshot string
	urlParams_          gensupport.URLParams
	ifNoneMatch_        string
	ctx_                context.Context
	header_             http.Header
}

// Get: Returns the specified RecoverableSnapshot resource.
//
// - project: Project ID for this request.
// - recoverableSnapshot: Name of the Snapshot resource to return.
// - region: Name of the region for this request.
func (r *RegionRecoverableSnapshotsService) Get(project string, region string, recoverableSnapshot string) *RegionRecoverableSnapshotsGetCall {
	c := &RegionRecoverableSnapshotsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.recoverableSnapshot = recoverableSnapshot
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsGetCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionRecoverableSnapshotsGetCall) IfNoneMatch(entityTag string) *RegionRecoverableSnapshotsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsGetCall) Context(ctx context.Context) *RegionRecoverableSnapshotsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots/{recoverableSnapshot}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":             c.project,
		"region":              c.region,
		"recoverableSnapshot": c.recoverableSnapshot,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RecoverableSnapshot.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RegionRecoverableSnapshotsGetCall) Do(opts ...googleapi.CallOption) (*RecoverableSnapshot, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RecoverableSnapshot{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionRecoverableSnapshotsGetIamPolicyCall struct {
	s            *Service
	project      string
	region       string
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. May be empty if
// no such
// policy or resource exists.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionRecoverableSnapshotsService) GetIamPolicy(project string, region string, resource string) *RegionRecoverableSnapshotsGetIamPolicyCall {
	c := &RegionRecoverableSnapshotsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "optionsRequestedPolicyVersion": Requested IAM Policy version.
func (c *RegionRecoverableSnapshotsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *RegionRecoverableSnapshotsGetIamPolicyCall {
	c.urlParams_.Set("optionsRequestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsGetIamPolicyCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionRecoverableSnapshotsGetIamPolicyCall) IfNoneMatch(entityTag string) *RegionRecoverableSnapshotsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsGetIamPolicyCall) Context(ctx context.Context) *RegionRecoverableSnapshotsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots/{resource}/getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionRecoverableSnapshotsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionRecoverableSnapshotsListCall struct {
	s            *Service
	project      string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves the list of RecoverableSnapshot resources contained
// within
// the specified region.
//
// - project: Project ID for this request.
// - region: Name of the region for this request.
func (r *RegionRecoverableSnapshotsService) List(project string, region string) *RegionRecoverableSnapshotsListCall {
	c := &RegionRecoverableSnapshotsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. Most
// Compute resources support two types of filter expressions:
// expressions that support regular expressions and expressions that follow
// API improvement proposal AIP-160.
// These two types of filter expressions cannot be mixed in one request.
//
// If you want to use AIP-160, your expression must specify the field name,
// an
// operator, and the value that you want to use for filtering. The value
// must be a string, a number, or a boolean. The operator
// must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
//
// For example, if you are filtering Compute Engine instances, you can
// exclude instances named `example-instance` by specifying
// `name != example-instance`.
//
// The `:*` comparison can be used to test whether a key has been defined.
// For example, to find all objects with `owner` label
// use:
// ```
// labels.owner:*
// ```
//
// You can also filter nested fields. For example, you could
// specify
// `scheduling.automaticRestart = false` to include instances only
// if they are not scheduled for automatic restarts. You can use filtering
// on nested fields to filter based onresource labels.
//
// To filter on multiple expressions, provide each separate expression
// within
// parentheses. For example:
// ```
// (scheduling.automaticRestart = true)
// (cpuPlatform = "Intel Skylake")
// ```
// By default, each expression is an `AND` expression. However, you
// can include `AND` and `OR` expressions explicitly.
// For example:
// ```
// (cpuPlatform = "Intel Skylake") OR
// (cpuPlatform = "Intel Broadwell") AND
// (scheduling.automaticRestart = true)
// ```
//
// If you want to use a regular expression, use the `eq` (equal) or `ne`
// (not equal) operator against a single un-parenthesized expression with
// or
// without quotes or against multiple parenthesized expressions.
// Examples:
//
// `fieldname eq unquoted literal`
// `fieldname eq 'single quoted literal'`
// `fieldname eq "double quoted literal"
// `(fieldname1 eq literal) (fieldname2 ne "literal")`
//
// The literal value is interpreted as a regular expression using GoogleRE2
// library syntax.
// The literal value must match the entire field.
//
// For example, to filter for instances that do not end with name
// "instance",
// you would use `name ne .*instance`.
//
// You cannot combine constraints on multiple fields using regular
// expressions.
func (c *RegionRecoverableSnapshotsListCall) Filter(filter string) *RegionRecoverableSnapshotsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results per page that should be returned.
// If the number of available results is larger than `maxResults`,
// Compute Engine returns a `nextPageToken` that can be used to get
// the next page of results in subsequent list requests. Acceptable values
// are
// `0` to `500`, inclusive. (Default: `500`)
func (c *RegionRecoverableSnapshotsListCall) MaxResults(maxResults int64) *RegionRecoverableSnapshotsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// OrderBy sets the optional parameter "orderBy": Sorts list results by a
// certain order. By default, results
// are returned in alphanumerical order based on the resource name.
//
// You can also sort results in descending order based on the
// creation
// timestamp using `orderBy="creationTimestamp desc". This sorts
// results based on the `creationTimestamp` field in
// reverse chronological order (newest result first). Use this to
// sort
// resources like operations so that the newest operation is returned
// first.
//
// Currently, only sorting by `name` or
// `creationTimestamp desc` is supported.
func (c *RegionRecoverableSnapshotsListCall) OrderBy(orderBy string) *RegionRecoverableSnapshotsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageToken sets the optional parameter "pageToken": Specifies a page token to
// use. Set `pageToken` to the
// `nextPageToken` returned by a previous list request to get
// the next page of results.
func (c *RegionRecoverableSnapshotsListCall) PageToken(pageToken string) *RegionRecoverableSnapshotsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// Opt-in for partial success behavior which provides partial results in
// case
// of failure. The default value is false.
//
// For example, when partial success behavior is enabled, aggregatedList for
// a
// single zone scope either returns all resources in the zone or no
// resources,
// with an error code.
func (c *RegionRecoverableSnapshotsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *RegionRecoverableSnapshotsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsListCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RegionRecoverableSnapshotsListCall) IfNoneMatch(entityTag string) *RegionRecoverableSnapshotsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsListCall) Context(ctx context.Context) *RegionRecoverableSnapshotsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *RecoverableSnapshotList.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionRecoverableSnapshotsListCall) Do(opts ...googleapi.CallOption) (*RecoverableSnapshotList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RecoverableSnapshotList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RegionRecoverableSnapshotsListCall) Pages(ctx context.Context, f func(*RecoverableSnapshotList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RegionRecoverableSnapshotsRecoverCall struct {
	s                   *Service
	project             string
	region              string
	recoverableSnapshot string
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Recover: Recovers the specified RecoverableSnapshot.
//
// - project: Project Id of the request.
// - recoverableSnapshot: Name of the recoverable resource to recover.
// - region: Name of the region for this request.
func (r *RegionRecoverableSnapshotsService) Recover(project string, region string, recoverableSnapshot string) *RegionRecoverableSnapshotsRecoverCall {
	c := &RegionRecoverableSnapshotsRecoverCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.recoverableSnapshot = recoverableSnapshot
	return c
}

// RequestId sets the optional parameter "requestId": An optional request ID to
// identify requests. Specify a unique request ID so
// that if you must retry your request, the server will know to ignore
// the
// request if it has already been completed.
//
// For example, consider a situation where you make an initial request and
// the request times out. If you make the request again with the same
// request ID, the server can check if original operation with the same
// request ID was received, and if so, will ignore the second request.
// This
// prevents clients from accidentally creating duplicate commitments.
//
// The request ID must be
// a valid UUID with the exception that zero UUID is not
// supported
// (00000000-0000-0000-0000-000000000000).
func (c *RegionRecoverableSnapshotsRecoverCall) RequestId(requestId string) *RegionRecoverableSnapshotsRecoverCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SnapshotName sets the optional parameter "snapshotName": Name of the
// snapshot after the recovery
// The name will be 1-63 characters long, and comply withRFC1035.
// Specifically, the name will be 1-63 characters long and match the
// regular
// expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
// character will be a lowercase letter, and all following characters can be
// a dash, lowercase letter, or digit, except the last character, which
// cannot
// be a dash.
func (c *RegionRecoverableSnapshotsRecoverCall) SnapshotName(snapshotName string) *RegionRecoverableSnapshotsRecoverCall {
	c.urlParams_.Set("snapshotName", snapshotName)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsRecoverCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsRecoverCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsRecoverCall) Context(ctx context.Context) *RegionRecoverableSnapshotsRecoverCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsRecoverCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsRecoverCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots/{recoverableSnapshot}/recover")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":             c.project,
		"region":              c.region,
		"recoverableSnapshot": c.recoverableSnapshot,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.recover", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.recover" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionRecoverableSnapshotsRecoverCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.recover", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionRecoverableSnapshotsSetIamPolicyCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	regionsetpolicyrequest *RegionSetPolicyRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource.
// Replaces any existing policy.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionRecoverableSnapshotsService) SetIamPolicy(project string, region string, resource string, regionsetpolicyrequest *RegionSetPolicyRequest) *RegionRecoverableSnapshotsSetIamPolicyCall {
	c := &RegionRecoverableSnapshotsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.regionsetpolicyrequest = regionsetpolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsSetIamPolicyCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsSetIamPolicyCall) Context(ctx context.Context) *RegionRecoverableSnapshotsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.regionsetpolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots/{resource}/setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RegionRecoverableSnapshotsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RegionRecoverableSnapshotsTestIamPermissionsCall struct {
	s                      *Service
	project                string
	region                 string
	resource               string
	testpermissionsrequest *TestPermissionsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource.
//
// - project: Project ID for this request.
// - region: The name of the region for this request.
// - resource: Name or id of the resource for this request.
func (r *RegionRecoverableSnapshotsService) TestIamPermissions(project string, region string, resource string, testpermissionsrequest *TestPermissionsRequest) *RegionRecoverableSnapshotsTestIamPermissionsCall {
	c := &RegionRecoverableSnapshotsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.resource = resource
	c.testpermissionsrequest = testpermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RegionRecoverableSnapshotsTestIamPermissionsCall) Fields(s ...googleapi.Field) *RegionRecoverableSnapshotsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RegionRecoverableSnapshotsTestIamPermissionsCall) Context(ctx context.Context) *RegionRecoverableSnapshotsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RegionRecoverableSnapshotsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RegionRecoverableSnapshotsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testpermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{project}/regions/{region}/recoverableSnapshots/{resource}/testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"region":   c.region,
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "compute.regionRecoverableSnapshots.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "compute.regionRecoverableSnapshots.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RegionRecoverableSnapshotsTestIamPermission