// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package aiplatform provides access to the Vertex AI API.
//
// For product documentation, see: https://cloud.google.com/vertex-ai/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/aiplatform/v1"
//	...
//	ctx := context.Background()
//	aiplatformService, err := aiplatform.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithScopes(aiplatform.CloudPlatformReadOnlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package aiplatform // import "google.golang.org/api/aiplatform/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "aiplatform:v1"
const apiName = "aiplatform"
const apiVersion = "v1"
const basePath = "https://aiplatform.googleapis.com/"
const basePathTemplate = "https://aiplatform.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://aiplatform.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address of
	// your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.BatchPredictionJobs = NewBatchPredictionJobsService(s)
	s.CustomJobs = NewCustomJobsService(s)
	s.DataLabelingJobs = NewDataLabelingJobsService(s)
	s.Datasets = NewDatasetsService(s)
	s.DeploymentResourcePools = NewDeploymentResourcePoolsService(s)
	s.Endpoints = NewEndpointsService(s)
	s.FeatureGroups = NewFeatureGroupsService(s)
	s.FeatureOnlineStores = NewFeatureOnlineStoresService(s)
	s.Featurestores = NewFeaturestoresService(s)
	s.HyperparameterTuningJobs = NewHyperparameterTuningJobsService(s)
	s.IndexEndpoints = NewIndexEndpointsService(s)
	s.Indexes = NewIndexesService(s)
	s.Media = NewMediaService(s)
	s.MetadataStores = NewMetadataStoresService(s)
	s.MigratableResources = NewMigratableResourcesService(s)
	s.ModelDeploymentMonitoringJobs = NewModelDeploymentMonitoringJobsService(s)
	s.Models = NewModelsService(s)
	s.NotebookExecutionJobs = NewNotebookExecutionJobsService(s)
	s.NotebookRuntimeTemplates = NewNotebookRuntimeTemplatesService(s)
	s.NotebookRuntimes = NewNotebookRuntimesService(s)
	s.Operations = NewOperationsService(s)
	s.PersistentResources = NewPersistentResourcesService(s)
	s.PipelineJobs = NewPipelineJobsService(s)
	s.Projects = NewProjectsService(s)
	s.Publishers = NewPublishersService(s)
	s.RagCorpora = NewRagCorporaService(s)
	s.RagEngineConfig = NewRagEngineConfigService(s)
	s.ReasoningEngines = NewReasoningEnginesService(s)
	s.Schedules = NewSchedulesService(s)
	s.SpecialistPools = NewSpecialistPoolsService(s)
	s.Studies = NewStudiesService(s)
	s.Tensorboards = NewTensorboardsService(s)
	s.TrainingPipelines = NewTrainingPipelinesService(s)
	s.TuningJobs = NewTuningJobsService(s)
	s.V1 = NewV1Service(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	BatchPredictionJobs *BatchPredictionJobsService

	CustomJobs *CustomJobsService

	DataLabelingJobs *DataLabelingJobsService

	Datasets *DatasetsService

	DeploymentResourcePools *DeploymentResourcePoolsService

	Endpoints *EndpointsService

	FeatureGroups *FeatureGroupsService

	FeatureOnlineStores *FeatureOnlineStoresService

	Featurestores *FeaturestoresService

	HyperparameterTuningJobs *HyperparameterTuningJobsService

	IndexEndpoints *IndexEndpointsService

	Indexes *IndexesService

	Media *MediaService

	MetadataStores *MetadataStoresService

	MigratableResources *MigratableResourcesService

	ModelDeploymentMonitoringJobs *ModelDeploymentMonitoringJobsService

	Models *ModelsService

	NotebookExecutionJobs *NotebookExecutionJobsService

	NotebookRuntimeTemplates *NotebookRuntimeTemplatesService

	NotebookRuntimes *NotebookRuntimesService

	Operations *OperationsService

	PersistentResources *PersistentResourcesService

	PipelineJobs *PipelineJobsService

	Projects *ProjectsService

	Publishers *PublishersService

	RagCorpora *RagCorporaService

	RagEngineConfig *RagEngineConfigService

	ReasoningEngines *ReasoningEnginesService

	Schedules *SchedulesService

	SpecialistPools *SpecialistPoolsService

	Studies *StudiesService

	Tensorboards *TensorboardsService

	TrainingPipelines *TrainingPipelinesService

	TuningJobs *TuningJobsService

	V1 *V1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBatchPredictionJobsService(s *Service) *BatchPredictionJobsService {
	rs := &BatchPredictionJobsService{s: s}
	return rs
}

type BatchPredictionJobsService struct {
	s *Service
}

func NewCustomJobsService(s *Service) *CustomJobsService {
	rs := &CustomJobsService{s: s}
	rs.Operations = NewCustomJobsOperationsService(s)
	return rs
}

type CustomJobsService struct {
	s *Service

	Operations *CustomJobsOperationsService
}

func NewCustomJobsOperationsService(s *Service) *CustomJobsOperationsService {
	rs := &CustomJobsOperationsService{s: s}
	return rs
}

type CustomJobsOperationsService struct {
	s *Service
}

func NewDataLabelingJobsService(s *Service) *DataLabelingJobsService {
	rs := &DataLabelingJobsService{s: s}
	rs.Operations = NewDataLabelingJobsOperationsService(s)
	return rs
}

type DataLabelingJobsService struct {
	s *Service

	Operations *DataLabelingJobsOperationsService
}

func NewDataLabelingJobsOperationsService(s *Service) *DataLabelingJobsOperationsService {
	rs := &DataLabelingJobsOperationsService{s: s}
	return rs
}

type DataLabelingJobsOperationsService struct {
	s *Service
}

func NewDatasetsService(s *Service) *DatasetsService {
	rs := &DatasetsService{s: s}
	rs.AnnotationSpecs = NewDatasetsAnnotationSpecsService(s)
	rs.DataItems = NewDatasetsDataItemsService(s)
	rs.DatasetVersions = NewDatasetsDatasetVersionsService(s)
	rs.Operations = NewDatasetsOperationsService(s)
	rs.SavedQueries = NewDatasetsSavedQueriesService(s)
	return rs
}

type DatasetsService struct {
	s *Service

	AnnotationSpecs *DatasetsAnnotationSpecsService

	DataItems *DatasetsDataItemsService

	DatasetVersions *DatasetsDatasetVersionsService

	Operations *DatasetsOperationsService

	SavedQueries *DatasetsSavedQueriesService
}

func NewDatasetsAnnotationSpecsService(s *Service) *DatasetsAnnotationSpecsService {
	rs := &DatasetsAnnotationSpecsService{s: s}
	rs.Operations = NewDatasetsAnnotationSpecsOperationsService(s)
	return rs
}

type DatasetsAnnotationSpecsService struct {
	s *Service

	Operations *DatasetsAnnotationSpecsOperationsService
}

func NewDatasetsAnnotationSpecsOperationsService(s *Service) *DatasetsAnnotationSpecsOperationsService {
	rs := &DatasetsAnnotationSpecsOperationsService{s: s}
	return rs
}

type DatasetsAnnotationSpecsOperationsService struct {
	s *Service
}

func NewDatasetsDataItemsService(s *Service) *DatasetsDataItemsService {
	rs := &DatasetsDataItemsService{s: s}
	rs.Annotations = NewDatasetsDataItemsAnnotationsService(s)
	rs.Operations = NewDatasetsDataItemsOperationsService(s)
	return rs
}

type DatasetsDataItemsService struct {
	s *Service

	Annotations *DatasetsDataItemsAnnotationsService

	Operations *DatasetsDataItemsOperationsService
}

func NewDatasetsDataItemsAnnotationsService(s *Service) *DatasetsDataItemsAnnotationsService {
	rs := &DatasetsDataItemsAnnotationsService{s: s}
	rs.Operations = NewDatasetsDataItemsAnnotationsOperationsService(s)
	return rs
}

type DatasetsDataItemsAnnotationsService struct {
	s *Service

	Operations *DatasetsDataItemsAnnotationsOperationsService
}

func NewDatasetsDataItemsAnnotationsOperationsService(s *Service) *DatasetsDataItemsAnnotationsOperationsService {
	rs := &DatasetsDataItemsAnnotationsOperationsService{s: s}
	return rs
}

type DatasetsDataItemsAnnotationsOperationsService struct {
	s *Service
}

func NewDatasetsDataItemsOperationsService(s *Service) *DatasetsDataItemsOperationsService {
	rs := &DatasetsDataItemsOperationsService{s: s}
	return rs
}

type DatasetsDataItemsOperationsService struct {
	s *Service
}

func NewDatasetsDatasetVersionsService(s *Service) *DatasetsDatasetVersionsService {
	rs := &DatasetsDatasetVersionsService{s: s}
	return rs
}

type DatasetsDatasetVersionsService struct {
	s *Service
}

func NewDatasetsOperationsService(s *Service) *DatasetsOperationsService {
	rs := &DatasetsOperationsService{s: s}
	return rs
}

type DatasetsOperationsService struct {
	s *Service
}

func NewDatasetsSavedQueriesService(s *Service) *DatasetsSavedQueriesService {
	rs := &DatasetsSavedQueriesService{s: s}
	rs.Operations = NewDatasetsSavedQueriesOperationsService(s)
	return rs
}

type DatasetsSavedQueriesService struct {
	s *Service

	Operations *DatasetsSavedQueriesOperationsService
}

func NewDatasetsSavedQueriesOperationsService(s *Service) *DatasetsSavedQueriesOperationsService {
	rs := &DatasetsSavedQueriesOperationsService{s: s}
	return rs
}

type DatasetsSavedQueriesOperationsService struct {
	s *Service
}

func NewDeploymentResourcePoolsService(s *Service) *DeploymentResourcePoolsService {
	rs := &DeploymentResourcePoolsService{s: s}
	rs.Operations = NewDeploymentResourcePoolsOperationsService(s)
	return rs
}

type DeploymentResourcePoolsService struct {
	s *Service

	Operations *DeploymentResourcePoolsOperationsService
}

func NewDeploymentResourcePoolsOperationsService(s *Service) *DeploymentResourcePoolsOperationsService {
	rs := &DeploymentResourcePoolsOperationsService{s: s}
	return rs
}

type DeploymentResourcePoolsOperationsService struct {
	s *Service
}

func NewEndpointsService(s *Service) *EndpointsService {
	rs := &EndpointsService{s: s}
	rs.Chat = NewEndpointsChatService(s)
	rs.Operations = NewEndpointsOperationsService(s)
	return rs
}

type EndpointsService struct {
	s *Service

	Chat *EndpointsChatService

	Operations *EndpointsOperationsService
}

func NewEndpointsChatService(s *Service) *EndpointsChatService {
	rs := &EndpointsChatService{s: s}
	return rs
}

type EndpointsChatService struct {
	s *Service
}

func NewEndpointsOperationsService(s *Service) *EndpointsOperationsService {
	rs := &EndpointsOperationsService{s: s}
	return rs
}

type EndpointsOperationsService struct {
	s *Service
}

func NewFeatureGroupsService(s *Service) *FeatureGroupsService {
	rs := &FeatureGroupsService{s: s}
	rs.Features = NewFeatureGroupsFeaturesService(s)
	rs.Operations = NewFeatureGroupsOperationsService(s)
	return rs
}

type FeatureGroupsService struct {
	s *Service

	Features *FeatureGroupsFeaturesService

	Operations *FeatureGroupsOperationsService
}

func NewFeatureGroupsFeaturesService(s *Service) *FeatureGroupsFeaturesService {
	rs := &FeatureGroupsFeaturesService{s: s}
	rs.Operations = NewFeatureGroupsFeaturesOperationsService(s)
	return rs
}

type FeatureGroupsFeaturesService struct {
	s *Service

	Operations *FeatureGroupsFeaturesOperationsService
}

func NewFeatureGroupsFeaturesOperationsService(s *Service) *FeatureGroupsFeaturesOperationsService {
	rs := &FeatureGroupsFeaturesOperationsService{s: s}
	return rs
}

type FeatureGroupsFeaturesOperationsService struct {
	s *Service
}

func NewFeatureGroupsOperationsService(s *Service) *FeatureGroupsOperationsService {
	rs := &FeatureGroupsOperationsService{s: s}
	return rs
}

type FeatureGroupsOperationsService struct {
	s *Service
}

func NewFeatureOnlineStoresService(s *Service) *FeatureOnlineStoresService {
	rs := &FeatureOnlineStoresService{s: s}
	rs.FeatureViews = NewFeatureOnlineStoresFeatureViewsService(s)
	rs.Operations = NewFeatureOnlineStoresOperationsService(s)
	return rs
}

type FeatureOnlineStoresService struct {
	s *Service

	FeatureViews *FeatureOnlineStoresFeatureViewsService

	Operations *FeatureOnlineStoresOperationsService
}

func NewFeatureOnlineStoresFeatureViewsService(s *Service) *FeatureOnlineStoresFeatureViewsService {
	rs := &FeatureOnlineStoresFeatureViewsService{s: s}
	rs.Operations = NewFeatureOnlineStoresFeatureViewsOperationsService(s)
	return rs
}

type FeatureOnlineStoresFeatureViewsService struct {
	s *Service

	Operations *FeatureOnlineStoresFeatureViewsOperationsService
}

func NewFeatureOnlineStoresFeatureViewsOperationsService(s *Service) *FeatureOnlineStoresFeatureViewsOperationsService {
	rs := &FeatureOnlineStoresFeatureViewsOperationsService{s: s}
	return rs
}

type FeatureOnlineStoresFeatureViewsOperationsService struct {
	s *Service
}

func NewFeatureOnlineStoresOperationsService(s *Service) *FeatureOnlineStoresOperationsService {
	rs := &FeatureOnlineStoresOperationsService{s: s}
	return rs
}

type FeatureOnlineStoresOperationsService struct {
	s *Service
}

func NewFeaturestoresService(s *Service) *FeaturestoresService {
	rs := &FeaturestoresService{s: s}
	rs.EntityTypes = NewFeaturestoresEntityTypesService(s)
	rs.Operations = NewFeaturestoresOperationsService(s)
	return rs
}

type FeaturestoresService struct {
	s *Service

	EntityTypes *FeaturestoresEntityTypesService

	Operations *FeaturestoresOperationsService
}

func NewFeaturestoresEntityTypesService(s *Service) *FeaturestoresEntityTypesService {
	rs := &FeaturestoresEntityTypesService{s: s}
	rs.Features = NewFeaturestoresEntityTypesFeaturesService(s)
	rs.Operations = NewFeaturestoresEntityTypesOperationsService(s)
	return rs
}

type FeaturestoresEntityTypesService struct {
	s *Service

	Features *FeaturestoresEntityTypesFeaturesService

	Operations *FeaturestoresEntityTypesOperationsService
}

func NewFeaturestoresEntityTypesFeaturesService(s *Service) *FeaturestoresEntityTypesFeaturesService {
	rs := &FeaturestoresEntityTypesFeaturesService{s: s}
	rs.Operations = NewFeaturestoresEntityTypesFeaturesOperationsService(s)
	return rs
}

type FeaturestoresEntityTypesFeaturesService struct {
	s *Service

	Operations *FeaturestoresEntityTypesFeaturesOperationsService
}

func NewFeaturestoresEntityTypesFeaturesOperationsService(s *Service) *FeaturestoresEntityTypesFeaturesOperationsService {
	rs := &FeaturestoresEntityTypesFeaturesOperationsService{s: s}
	return rs
}

type FeaturestoresEntityTypesFeaturesOperationsService struct {
	s *Service
}

func NewFeaturestoresEntityTypesOperationsService(s *Service) *FeaturestoresEntityTypesOperationsService {
	rs := &FeaturestoresEntityTypesOperationsService{s: s}
	return rs
}

type FeaturestoresEntityTypesOperationsService struct {
	s *Service
}

func NewFeaturestoresOperationsService(s *Service) *FeaturestoresOperationsService {
	rs := &FeaturestoresOperationsService{s: s}
	return rs
}

type FeaturestoresOperationsService struct {
	s *Service
}

func NewHyperparameterTuningJobsService(s *Service) *HyperparameterTuningJobsService {
	rs := &HyperparameterTuningJobsService{s: s}
	rs.Operations = NewHyperparameterTuningJobsOperationsService(s)
	return rs
}

type HyperparameterTuningJobsService struct {
	s *Service

	Operations *HyperparameterTuningJobsOperationsService
}

func NewHyperparameterTuningJobsOperationsService(s *Service) *HyperparameterTuningJobsOperationsService {
	rs := &HyperparameterTuningJobsOperationsService{s: s}
	return rs
}

type HyperparameterTuningJobsOperationsService struct {
	s *Service
}

func NewIndexEndpointsService(s *Service) *IndexEndpointsService {
	rs := &IndexEndpointsService{s: s}
	rs.Operations = NewIndexEndpointsOperationsService(s)
	return rs
}

type IndexEndpointsService struct {
	s *Service

	Operations *IndexEndpointsOperationsService
}

func NewIndexEndpointsOperationsService(s *Service) *IndexEndpointsOperationsService {
	rs := &IndexEndpointsOperationsService{s: s}
	return rs
}

type IndexEndpointsOperationsService struct {
	s *Service
}

func NewIndexesService(s *Service) *IndexesService {
	rs := &IndexesService{s: s}
	rs.Operations = NewIndexesOperationsService(s)
	return rs
}

type IndexesService struct {
	s *Service

	Operations *IndexesOperationsService
}

func NewIndexesOperationsService(s *Service) *IndexesOperationsService {
	rs := &IndexesOperationsService{s: s}
	return rs
}

type IndexesOperationsService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewMetadataStoresService(s *Service) *MetadataStoresService {
	rs := &MetadataStoresService{s: s}
	rs.Artifacts = NewMetadataStoresArtifactsService(s)
	rs.Contexts = NewMetadataStoresContextsService(s)
	rs.Executions = NewMetadataStoresExecutionsService(s)
	rs.Operations = NewMetadataStoresOperationsService(s)
	return rs
}

type MetadataStoresService struct {
	s *Service

	Artifacts *MetadataStoresArtifactsService

	Contexts *MetadataStoresContextsService

	Executions *MetadataStoresExecutionsService

	Operations *MetadataStoresOperationsService
}

func NewMetadataStoresArtifactsService(s *Service) *MetadataStoresArtifactsService {
	rs := &MetadataStoresArtifactsService{s: s}
	rs.Operations = NewMetadataStoresArtifactsOperationsService(s)
	return rs
}

type MetadataStoresArtifactsService struct {
	s *Service

	Operations *MetadataStoresArtifactsOperationsService
}

func NewMetadataStoresArtifactsOperationsService(s *Service) *MetadataStoresArtifactsOperationsService {
	rs := &MetadataStoresArtifactsOperationsService{s: s}
	return rs
}

type MetadataStoresArtifactsOperationsService struct {
	s *Service
}

func NewMetadataStoresContextsService(s *Service) *MetadataStoresContextsService {
	rs := &MetadataStoresContextsService{s: s}
	rs.Operations = NewMetadataStoresContextsOperationsService(s)
	return rs
}

type MetadataStoresContextsService struct {
	s *Service

	Operations *MetadataStoresContextsOperationsService
}

func NewMetadataStoresContextsOperationsService(s *Service) *MetadataStoresContextsOperationsService {
	rs := &MetadataStoresContextsOperationsService{s: s}
	return rs
}

type MetadataStoresContextsOperationsService struct {
	s *Service
}

func NewMetadataStoresExecutionsService(s *Service) *MetadataStoresExecutionsService {
	rs := &MetadataStoresExecutionsService{s: s}
	rs.Operations = NewMetadataStoresExecutionsOperationsService(s)
	return rs
}

type MetadataStoresExecutionsService struct {
	s *Service

	Operations *MetadataStoresExecutionsOperationsService
}

func NewMetadataStoresExecutionsOperationsService(s *Service) *MetadataStoresExecutionsOperationsService {
	rs := &MetadataStoresExecutionsOperationsService{s: s}
	return rs
}

type MetadataStoresExecutionsOperationsService struct {
	s *Service
}

func NewMetadataStoresOperationsService(s *Service) *MetadataStoresOperationsService {
	rs := &MetadataStoresOperationsService{s: s}
	return rs
}

type MetadataStoresOperationsService struct {
	s *Service
}

func NewMigratableResourcesService(s *Service) *MigratableResourcesService {
	rs := &MigratableResourcesService{s: s}
	rs.Operations = NewMigratableResourcesOperationsService(s)
	return rs
}

type MigratableResourcesService struct {
	s *Service

	Operations *MigratableResourcesOperationsService
}

func NewMigratableResourcesOperationsService(s *Service) *MigratableResourcesOperationsService {
	rs := &MigratableResourcesOperationsService{s: s}
	return rs
}

type MigratableResourcesOperationsService struct {
	s *Service
}

func NewModelDeploymentMonitoringJobsService(s *Service) *ModelDeploymentMonitoringJobsService {
	rs := &ModelDeploymentMonitoringJobsService{s: s}
	rs.Operations = NewModelDeploymentMonitoringJobsOperationsService(s)
	return rs
}

type ModelDeploymentMonitoringJobsService struct {
	s *Service

	Operations *ModelDeploymentMonitoringJobsOperationsService
}

func NewModelDeploymentMonitoringJobsOperationsService(s *Service) *ModelDeploymentMonitoringJobsOperationsService {
	rs := &ModelDeploymentMonitoringJobsOperationsService{s: s}
	return rs
}

type ModelDeploymentMonitoringJobsOperationsService struct {
	s *Service
}

func NewModelsService(s *Service) *ModelsService {
	rs := &ModelsService{s: s}
	rs.Evaluations = NewModelsEvaluationsService(s)
	rs.Operations = NewModelsOperationsService(s)
	return rs
}

type ModelsService struct {
	s *Service

	Evaluations *ModelsEvaluationsService

	Operations *ModelsOperationsService
}

func NewModelsEvaluationsService(s *Service) *ModelsEvaluationsService {
	rs := &ModelsEvaluationsService{s: s}
	rs.Operations = NewModelsEvaluationsOperationsService(s)
	return rs
}

type ModelsEvaluationsService struct {
	s *Service

	Operations *ModelsEvaluationsOperationsService
}

func NewModelsEvaluationsOperationsService(s *Service) *ModelsEvaluationsOperationsService {
	rs := &ModelsEvaluationsOperationsService{s: s}
	return rs
}

type ModelsEvaluationsOperationsService struct {
	s *Service
}

func NewModelsOperationsService(s *Service) *ModelsOperationsService {
	rs := &ModelsOperationsService{s: s}
	return rs
}

type ModelsOperationsService struct {
	s *Service
}

func NewNotebookExecutionJobsService(s *Service) *NotebookExecutionJobsService {
	rs := &NotebookExecutionJobsService{s: s}
	rs.Operations = NewNotebookExecutionJobsOperationsService(s)
	return rs
}

type NotebookExecutionJobsService struct {
	s *Service

	Operations *NotebookExecutionJobsOperationsService
}

func NewNotebookExecutionJobsOperationsService(s *Service) *NotebookExecutionJobsOperationsService {
	rs := &NotebookExecutionJobsOperationsService{s: s}
	return rs
}

type NotebookExecutionJobsOperationsService struct {
	s *Service
}

func NewNotebookRuntimeTemplatesService(s *Service) *NotebookRuntimeTemplatesService {
	rs := &NotebookRuntimeTemplatesService{s: s}
	rs.Operations = NewNotebookRuntimeTemplatesOperationsService(s)
	return rs
}

type NotebookRuntimeTemplatesService struct {
	s *Service

	Operations *NotebookRuntimeTemplatesOperationsService
}

func NewNotebookRuntimeTemplatesOperationsService(s *Service) *NotebookRuntimeTemplatesOperationsService {
	rs := &NotebookRuntimeTemplatesOperationsService{s: s}
	return rs
}

type NotebookRuntimeTemplatesOperationsService struct {
	s *Service
}

func NewNotebookRuntimesService(s *Service) *NotebookRuntimesService {
	rs := &NotebookRuntimesService{s: s}
	rs.Operations = NewNotebookRuntimesOperationsService(s)
	return rs
}

type NotebookRuntimesService struct {
	s *Service

	Operations *NotebookRuntimesOperationsService
}

func NewNotebookRuntimesOperationsService(s *Service) *NotebookRuntimesOperationsService {
	rs := &NotebookRuntimesOperationsService{s: s}
	return rs
}

type NotebookRuntimesOperationsService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewPersistentResourcesService(s *Service) *PersistentResourcesService {
	rs := &PersistentResourcesService{s: s}
	rs.Operations = NewPersistentResourcesOperationsService(s)
	return rs
}

type PersistentResourcesService struct {
	s *Service

	Operations *PersistentResourcesOperationsService
}

func NewPersistentResourcesOperationsService(s *Service) *PersistentResourcesOperationsService {
	rs := &PersistentResourcesOperationsService{s: s}
	return rs
}

type PersistentResourcesOperationsService struct {
	s *Service
}

func NewPipelineJobsService(s *Service) *PipelineJobsService {
	rs := &PipelineJobsService{s: s}
	rs.Operations = NewPipelineJobsOperationsService(s)
	return rs
}

type PipelineJobsService struct {
	s *Service

	Operations *PipelineJobsOperationsService
}

func NewPipelineJobsOperationsService(s *Service) *PipelineJobsOperationsService {
	rs := &PipelineJobsOperationsService{s: s}
	return rs
}

type PipelineJobsOperationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.BatchPredictionJobs = NewProjectsLocationsBatchPredictionJobsService(s)
	rs.CachedContents = NewProjectsLocationsCachedContentsService(s)
	rs.CustomJobs = NewProjectsLocationsCustomJobsService(s)
	rs.DataLabelingJobs = NewProjectsLocationsDataLabelingJobsService(s)
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.DeploymentResourcePools = NewProjectsLocationsDeploymentResourcePoolsService(s)
	rs.Endpoints = NewProjectsLocationsEndpointsService(s)
	rs.EvaluationItems = NewProjectsLocationsEvaluationItemsService(s)
	rs.EvaluationRuns = NewProjectsLocationsEvaluationRunsService(s)
	rs.EvaluationSets = NewProjectsLocationsEvaluationSetsService(s)
	rs.FeatureGroups = NewProjectsLocationsFeatureGroupsService(s)
	rs.FeatureOnlineStores = NewProjectsLocationsFeatureOnlineStoresService(s)
	rs.Featurestores = NewProjectsLocationsFeaturestoresService(s)
	rs.HyperparameterTuningJobs = NewProjectsLocationsHyperparameterTuningJobsService(s)
	rs.IndexEndpoints = NewProjectsLocationsIndexEndpointsService(s)
	rs.Indexes = NewProjectsLocationsIndexesService(s)
	rs.MetadataStores = NewProjectsLocationsMetadataStoresService(s)
	rs.MigratableResources = NewProjectsLocationsMigratableResourcesService(s)
	rs.ModelDeploymentMonitoringJobs = NewProjectsLocationsModelDeploymentMonitoringJobsService(s)
	rs.Models = NewProjectsLocationsModelsService(s)
	rs.NasJobs = NewProjectsLocationsNasJobsService(s)
	rs.NotebookExecutionJobs = NewProjectsLocationsNotebookExecutionJobsService(s)
	rs.NotebookRuntimeTemplates = NewProjectsLocationsNotebookRuntimeTemplatesService(s)
	rs.NotebookRuntimes = NewProjectsLocationsNotebookRuntimesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PersistentResources = NewProjectsLocationsPersistentResourcesService(s)
	rs.PipelineJobs = NewProjectsLocationsPipelineJobsService(s)
	rs.Publishers = NewProjectsLocationsPublishersService(s)
	rs.RagCorpora = NewProjectsLocationsRagCorporaService(s)
	rs.RagEngineConfig = NewProjectsLocationsRagEngineConfigService(s)
	rs.ReasoningEngines = NewProjectsLocationsReasoningEnginesService(s)
	rs.Schedules = NewProjectsLocationsSchedulesService(s)
	rs.SpecialistPools = NewProjectsLocationsSpecialistPoolsService(s)
	rs.Studies = NewProjectsLocationsStudiesService(s)
	rs.Tensorboards = NewProjectsLocationsTensorboardsService(s)
	rs.TrainingPipelines = NewProjectsLocationsTrainingPipelinesService(s)
	rs.TuningJobs = NewProjectsLocationsTuningJobsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	BatchPredictionJobs *ProjectsLocationsBatchPredictionJobsService

	CachedContents *ProjectsLocationsCachedContentsService

	CustomJobs *ProjectsLocationsCustomJobsService

	DataLabelingJobs *ProjectsLocationsDataLabelingJobsService

	Datasets *ProjectsLocationsDatasetsService

	DeploymentResourcePools *ProjectsLocationsDeploymentResourcePoolsService

	Endpoints *ProjectsLocationsEndpointsService

	EvaluationItems *ProjectsLocationsEvaluationItemsService

	EvaluationRuns *ProjectsLocationsEvaluationRunsService

	EvaluationSets *ProjectsLocationsEvaluationSetsService

	FeatureGroups *ProjectsLocationsFeatureGroupsService

	FeatureOnlineStores *ProjectsLocationsFeatureOnlineStoresService

	Featurestores *ProjectsLocationsFeaturestoresService

	HyperparameterTuningJobs *ProjectsLocationsHyperparameterTuningJobsService

	IndexEndpoints *ProjectsLocationsIndexEndpointsService

	Indexes *ProjectsLocationsIndexesService

	MetadataStores *ProjectsLocationsMetadataStoresService

	MigratableResources *ProjectsLocationsMigratableResourcesService

	ModelDeploymentMonitoringJobs *ProjectsLocationsModelDeploymentMonitoringJobsService

	Models *ProjectsLocationsModelsService

	NasJobs *ProjectsLocationsNasJobsService

	NotebookExecutionJobs *ProjectsLocationsNotebookExecutionJobsService

	NotebookRuntimeTemplates *ProjectsLocationsNotebookRuntimeTemplatesService

	NotebookRuntimes *ProjectsLocationsNotebookRuntimesService

	Operations *ProjectsLocationsOperationsService

	PersistentResources *ProjectsLocationsPersistentResourcesService

	PipelineJobs *ProjectsLocationsPipelineJobsService

	Publishers *ProjectsLocationsPublishersService

	RagCorpora *ProjectsLocationsRagCorporaService

	RagEngineConfig *ProjectsLocationsRagEngineConfigService

	ReasoningEngines *ProjectsLocationsReasoningEnginesService

	Schedules *ProjectsLocationsSchedulesService

	SpecialistPools *ProjectsLocationsSpecialistPoolsService

	Studies *ProjectsLocationsStudiesService

	Tensorboards *ProjectsLocationsTensorboardsService

	TrainingPipelines *ProjectsLocationsTrainingPipelinesService

	TuningJobs *ProjectsLocationsTuningJobsService
}

func NewProjectsLocationsBatchPredictionJobsService(s *Service) *ProjectsLocationsBatchPredictionJobsService {
	rs := &ProjectsLocationsBatchPredictionJobsService{s: s}
	return rs
}

type ProjectsLocationsBatchPredictionJobsService struct {
	s *Service
}

func NewProjectsLocationsCachedContentsService(s *Service) *ProjectsLocationsCachedContentsService {
	rs := &ProjectsLocationsCachedContentsService{s: s}
	return rs
}

type ProjectsLocationsCachedContentsService struct {
	s *Service
}

func NewProjectsLocationsCustomJobsService(s *Service) *ProjectsLocationsCustomJobsService {
	rs := &ProjectsLocationsCustomJobsService{s: s}
	rs.Operations = NewProjectsLocationsCustomJobsOperationsService(s)
	return rs
}

type ProjectsLocationsCustomJobsService struct {
	s *Service

	Operations *ProjectsLocationsCustomJobsOperationsService
}

func NewProjectsLocationsCustomJobsOperationsService(s *Service) *ProjectsLocationsCustomJobsOperationsService {
	rs := &ProjectsLocationsCustomJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCustomJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataLabelingJobsService(s *Service) *ProjectsLocationsDataLabelingJobsService {
	rs := &ProjectsLocationsDataLabelingJobsService{s: s}
	rs.Operations = NewProjectsLocationsDataLabelingJobsOperationsService(s)
	return rs
}

type ProjectsLocationsDataLabelingJobsService struct {
	s *Service

	Operations *ProjectsLocationsDataLabelingJobsOperationsService
}

func NewProjectsLocationsDataLabelingJobsOperationsService(s *Service) *ProjectsLocationsDataLabelingJobsOperationsService {
	rs := &ProjectsLocationsDataLabelingJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataLabelingJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.AnnotationSpecs = NewProjectsLocationsDatasetsAnnotationSpecsService(s)
	rs.DataItems = NewProjectsLocationsDatasetsDataItemsService(s)
	rs.DatasetVersions = NewProjectsLocationsDatasetsDatasetVersionsService(s)
	rs.Operations = NewProjectsLocationsDatasetsOperationsService(s)
	rs.SavedQueries = NewProjectsLocationsDatasetsSavedQueriesService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	AnnotationSpecs *ProjectsLocationsDatasetsAnnotationSpecsService

	DataItems *ProjectsLocationsDatasetsDataItemsService

	DatasetVersions *ProjectsLocationsDatasetsDatasetVersionsService

	Operations *ProjectsLocationsDatasetsOperationsService

	SavedQueries *ProjectsLocationsDatasetsSavedQueriesService
}

func NewProjectsLocationsDatasetsAnnotationSpecsService(s *Service) *ProjectsLocationsDatasetsAnnotationSpecsService {
	rs := &ProjectsLocationsDatasetsAnnotationSpecsService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsAnnotationSpecsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsAnnotationSpecsService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsAnnotationSpecsOperationsService
}

func NewProjectsLocationsDatasetsAnnotationSpecsOperationsService(s *Service) *ProjectsLocationsDatasetsAnnotationSpecsOperationsService {
	rs := &ProjectsLocationsDatasetsAnnotationSpecsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsAnnotationSpecsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataItemsService(s *Service) *ProjectsLocationsDatasetsDataItemsService {
	rs := &ProjectsLocationsDatasetsDataItemsService{s: s}
	rs.Annotations = NewProjectsLocationsDatasetsDataItemsAnnotationsService(s)
	rs.Operations = NewProjectsLocationsDatasetsDataItemsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsDataItemsService struct {
	s *Service

	Annotations *ProjectsLocationsDatasetsDataItemsAnnotationsService

	Operations *ProjectsLocationsDatasetsDataItemsOperationsService
}

func NewProjectsLocationsDatasetsDataItemsAnnotationsService(s *Service) *ProjectsLocationsDatasetsDataItemsAnnotationsService {
	rs := &ProjectsLocationsDatasetsDataItemsAnnotationsService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsDataItemsAnnotationsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsDataItemsAnnotationsService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService
}

func NewProjectsLocationsDatasetsDataItemsAnnotationsOperationsService(s *Service) *ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService {
	rs := &ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataItemsOperationsService(s *Service) *ProjectsLocationsDatasetsDataItemsOperationsService {
	rs := &ProjectsLocationsDatasetsDataItemsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataItemsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDatasetVersionsService(s *Service) *ProjectsLocationsDatasetsDatasetVersionsService {
	rs := &ProjectsLocationsDatasetsDatasetVersionsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDatasetVersionsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsOperationsService(s *Service) *ProjectsLocationsDatasetsOperationsService {
	rs := &ProjectsLocationsDatasetsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsSavedQueriesService(s *Service) *ProjectsLocationsDatasetsSavedQueriesService {
	rs := &ProjectsLocationsDatasetsSavedQueriesService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsSavedQueriesOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsSavedQueriesService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsSavedQueriesOperationsService
}

func NewProjectsLocationsDatasetsSavedQueriesOperationsService(s *Service) *ProjectsLocationsDatasetsSavedQueriesOperationsService {
	rs := &ProjectsLocationsDatasetsSavedQueriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsSavedQueriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDeploymentResourcePoolsService(s *Service) *ProjectsLocationsDeploymentResourcePoolsService {
	rs := &ProjectsLocationsDeploymentResourcePoolsService{s: s}
	rs.Operations = NewProjectsLocationsDeploymentResourcePoolsOperationsService(s)
	return rs
}

type ProjectsLocationsDeploymentResourcePoolsService struct {
	s *Service

	Operations *ProjectsLocationsDeploymentResourcePoolsOperationsService
}

func NewProjectsLocationsDeploymentResourcePoolsOperationsService(s *Service) *ProjectsLocationsDeploymentResourcePoolsOperationsService {
	rs := &ProjectsLocationsDeploymentResourcePoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDeploymentResourcePoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsEndpointsService(s *Service) *ProjectsLocationsEndpointsService {
	rs := &ProjectsLocationsEndpointsService{s: s}
	rs.Chat = NewProjectsLocationsEndpointsChatService(s)
	rs.DeployedModels = NewProjectsLocationsEndpointsDeployedModelsService(s)
	rs.Google = NewProjectsLocationsEndpointsGoogleService(s)
	rs.Invoke = NewProjectsLocationsEndpointsInvokeService(s)
	rs.Openapi = NewProjectsLocationsEndpointsOpenapiService(s)
	rs.Operations = NewProjectsLocationsEndpointsOperationsService(s)
	return rs
}

type ProjectsLocationsEndpointsService struct {
	s *Service

	Chat *ProjectsLocationsEndpointsChatService

	DeployedModels *ProjectsLocationsEndpointsDeployedModelsService

	Google *ProjectsLocationsEndpointsGoogleService

	Invoke *ProjectsLocationsEndpointsInvokeService

	Openapi *ProjectsLocationsEndpointsOpenapiService

	Operations *ProjectsLocationsEndpointsOperationsService
}

func NewProjectsLocationsEndpointsChatService(s *Service) *ProjectsLocationsEndpointsChatService {
	rs := &ProjectsLocationsEndpointsChatService{s: s}
	return rs
}

type ProjectsLocationsEndpointsChatService struct {
	s *Service
}

func NewProjectsLocationsEndpointsDeployedModelsService(s *Service) *ProjectsLocationsEndpointsDeployedModelsService {
	rs := &ProjectsLocationsEndpointsDeployedModelsService{s: s}
	rs.Invoke = NewProjectsLocationsEndpointsDeployedModelsInvokeService(s)
	return rs
}

type ProjectsLocationsEndpointsDeployedModelsService struct {
	s *Service

	Invoke *ProjectsLocationsEndpointsDeployedModelsInvokeService
}

func NewProjectsLocationsEndpointsDeployedModelsInvokeService(s *Service) *ProjectsLocationsEndpointsDeployedModelsInvokeService {
	rs := &ProjectsLocationsEndpointsDeployedModelsInvokeService{s: s}
	return rs
}

type ProjectsLocationsEndpointsDeployedModelsInvokeService struct {
	s *Service
}

func NewProjectsLocationsEndpointsGoogleService(s *Service) *ProjectsLocationsEndpointsGoogleService {
	rs := &ProjectsLocationsEndpointsGoogleService{s: s}
	rs.Science = NewProjectsLocationsEndpointsGoogleScienceService(s)
	return rs
}

type ProjectsLocationsEndpointsGoogleService struct {
	s *Service

	Science *ProjectsLocationsEndpointsGoogleScienceService
}

func NewProjectsLocationsEndpointsGoogleScienceService(s *Service) *ProjectsLocationsEndpointsGoogleScienceService {
	rs := &ProjectsLocationsEndpointsGoogleScienceService{s: s}
	return rs
}

type ProjectsLocationsEndpointsGoogleScienceService struct {
	s *Service
}

func NewProjectsLocationsEndpointsInvokeService(s *Service) *ProjectsLocationsEndpointsInvokeService {
	rs := &ProjectsLocationsEndpointsInvokeService{s: s}
	return rs
}

type ProjectsLocationsEndpointsInvokeService struct {
	s *Service
}

func NewProjectsLocationsEndpointsOpenapiService(s *Service) *ProjectsLocationsEndpointsOpenapiService {
	rs := &ProjectsLocationsEndpointsOpenapiService{s: s}
	return rs
}

type ProjectsLocationsEndpointsOpenapiService struct {
	s *Service
}

func NewProjectsLocationsEndpointsOperationsService(s *Service) *ProjectsLocationsEndpointsOperationsService {
	rs := &ProjectsLocationsEndpointsOperationsService{s: s}
	return rs
}

type ProjectsLocationsEndpointsOperationsService struct {
	s *Service
}

func NewProjectsLocationsEvaluationItemsService(s *Service) *ProjectsLocationsEvaluationItemsService {
	rs := &ProjectsLocationsEvaluationItemsService{s: s}
	return rs
}

type ProjectsLocationsEvaluationItemsService struct {
	s *Service
}

func NewProjectsLocationsEvaluationRunsService(s *Service) *ProjectsLocationsEvaluationRunsService {
	rs := &ProjectsLocationsEvaluationRunsService{s: s}
	return rs
}

type ProjectsLocationsEvaluationRunsService struct {
	s *Service
}

func NewProjectsLocationsEvaluationSetsService(s *Service) *ProjectsLocationsEvaluationSetsService {
	rs := &ProjectsLocationsEvaluationSetsService{s: s}
	return rs
}

type ProjectsLocationsEvaluationSetsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsService(s *Service) *ProjectsLocationsFeatureGroupsService {
	rs := &ProjectsLocationsFeatureGroupsService{s: s}
	rs.Features = NewProjectsLocationsFeatureGroupsFeaturesService(s)
	rs.Operations = NewProjectsLocationsFeatureGroupsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsService struct {
	s *Service

	Features *ProjectsLocationsFeatureGroupsFeaturesService

	Operations *ProjectsLocationsFeatureGroupsOperationsService
}

func NewProjectsLocationsFeatureGroupsFeaturesService(s *Service) *ProjectsLocationsFeatureGroupsFeaturesService {
	rs := &ProjectsLocationsFeatureGroupsFeaturesService{s: s}
	rs.Operations = NewProjectsLocationsFeatureGroupsFeaturesOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsFeaturesService struct {
	s *Service

	Operations *ProjectsLocationsFeatureGroupsFeaturesOperationsService
}

func NewProjectsLocationsFeatureGroupsFeaturesOperationsService(s *Service) *ProjectsLocationsFeatureGroupsFeaturesOperationsService {
	rs := &ProjectsLocationsFeatureGroupsFeaturesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsFeaturesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsOperationsService(s *Service) *ProjectsLocationsFeatureGroupsOperationsService {
	rs := &ProjectsLocationsFeatureGroupsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresService(s *Service) *ProjectsLocationsFeatureOnlineStoresService {
	rs := &ProjectsLocationsFeatureOnlineStoresService{s: s}
	rs.FeatureViews = NewProjectsLocationsFeatureOnlineStoresFeatureViewsService(s)
	rs.Operations = NewProjectsLocationsFeatureOnlineStoresOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureOnlineStoresService struct {
	s *Service

	FeatureViews *ProjectsLocationsFeatureOnlineStoresFeatureViewsService

	Operations *ProjectsLocationsFeatureOnlineStoresOperationsService
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsService{s: s}
	rs.FeatureViewSyncs = NewProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService(s)
	rs.Operations = NewProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsService struct {
	s *Service

	FeatureViewSyncs *ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService

	Operations *ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresOperationsService(s *Service) *ProjectsLocationsFeatureOnlineStoresOperationsService {
	rs := &ProjectsLocationsFeatureOnlineStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresService(s *Service) *ProjectsLocationsFeaturestoresService {
	rs := &ProjectsLocationsFeaturestoresService{s: s}
	rs.EntityTypes = NewProjectsLocationsFeaturestoresEntityTypesService(s)
	rs.Operations = NewProjectsLocationsFeaturestoresOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresService struct {
	s *Service

	EntityTypes *ProjectsLocationsFeaturestoresEntityTypesService

	Operations *ProjectsLocationsFeaturestoresOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesService{s: s}
	rs.Features = NewProjectsLocationsFeaturestoresEntityTypesFeaturesService(s)
	rs.Operations = NewProjectsLocationsFeaturestoresEntityTypesOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesService struct {
	s *Service

	Features *ProjectsLocationsFeaturestoresEntityTypesFeaturesService

	Operations *ProjectsLocationsFeaturestoresEntityTypesOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesFeaturesService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesFeaturesService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesFeaturesService{s: s}
	rs.Operations = NewProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesFeaturesService struct {
	s *Service

	Operations *ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresEntityTypesOperationsService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesOperationsService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresOperationsService(s *Service) *ProjectsLocationsFeaturestoresOperationsService {
	rs := &ProjectsLocationsFeaturestoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsHyperparameterTuningJobsService(s *Service) *ProjectsLocationsHyperparameterTuningJobsService {
	rs := &ProjectsLocationsHyperparameterTuningJobsService{s: s}
	rs.Operations = NewProjectsLocationsHyperparameterTuningJobsOperationsService(s)
	return rs
}

type ProjectsLocationsHyperparameterTuningJobsService struct {
	s *Service

	Operations *ProjectsLocationsHyperparameterTuningJobsOperationsService
}

func NewProjectsLocationsHyperparameterTuningJobsOperationsService(s *Service) *ProjectsLocationsHyperparameterTuningJobsOperationsService {
	rs := &ProjectsLocationsHyperparameterTuningJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsHyperparameterTuningJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsIndexEndpointsService(s *Service) *ProjectsLocationsIndexEndpointsService {
	rs := &ProjectsLocationsIndexEndpointsService{s: s}
	rs.Operations = NewProjectsLocationsIndexEndpointsOperationsService(s)
	return rs
}

type ProjectsLocationsIndexEndpointsService struct {
	s *Service

	Operations *ProjectsLocationsIndexEndpointsOperationsService
}

func NewProjectsLocationsIndexEndpointsOperationsService(s *Service) *ProjectsLocationsIndexEndpointsOperationsService {
	rs := &ProjectsLocationsIndexEndpointsOperationsService{s: s}
	return rs
}

type ProjectsLocationsIndexEndpointsOperationsService struct {
	s *Service
}

func NewProjectsLocationsIndexesService(s *Service) *ProjectsLocationsIndexesService {
	rs := &ProjectsLocationsIndexesService{s: s}
	rs.Operations = NewProjectsLocationsIndexesOperationsService(s)
	return rs
}

type ProjectsLocationsIndexesService struct {
	s *Service

	Operations *ProjectsLocationsIndexesOperationsService
}

func NewProjectsLocationsIndexesOperationsService(s *Service) *ProjectsLocationsIndexesOperationsService {
	rs := &ProjectsLocationsIndexesOperationsService{s: s}
	return rs
}

type ProjectsLocationsIndexesOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresService(s *Service) *ProjectsLocationsMetadataStoresService {
	rs := &ProjectsLocationsMetadataStoresService{s: s}
	rs.Artifacts = NewProjectsLocationsMetadataStoresArtifactsService(s)
	rs.Contexts = NewProjectsLocationsMetadataStoresContextsService(s)
	rs.Executions = NewProjectsLocationsMetadataStoresExecutionsService(s)
	rs.MetadataSchemas = NewProjectsLocationsMetadataStoresMetadataSchemasService(s)
	rs.Operations = NewProjectsLocationsMetadataStoresOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresService struct {
	s *Service

	Artifacts *ProjectsLocationsMetadataStoresArtifactsService

	Contexts *ProjectsLocationsMetadataStoresContextsService

	Executions *ProjectsLocationsMetadataStoresExecutionsService

	MetadataSchemas *ProjectsLocationsMetadataStoresMetadataSchemasService

	Operations *ProjectsLocationsMetadataStoresOperationsService
}

func NewProjectsLocationsMetadataStoresArtifactsService(s *Service) *ProjectsLocationsMetadataStoresArtifactsService {
	rs := &ProjectsLocationsMetadataStoresArtifactsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresArtifactsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresArtifactsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresArtifactsOperationsService
}

func NewProjectsLocationsMetadataStoresArtifactsOperationsService(s *Service) *ProjectsLocationsMetadataStoresArtifactsOperationsService {
	rs := &ProjectsLocationsMetadataStoresArtifactsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresArtifactsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresContextsService(s *Service) *ProjectsLocationsMetadataStoresContextsService {
	rs := &ProjectsLocationsMetadataStoresContextsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresContextsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresContextsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresContextsOperationsService
}

func NewProjectsLocationsMetadataStoresContextsOperationsService(s *Service) *ProjectsLocationsMetadataStoresContextsOperationsService {
	rs := &ProjectsLocationsMetadataStoresContextsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresContextsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresExecutionsService(s *Service) *ProjectsLocationsMetadataStoresExecutionsService {
	rs := &ProjectsLocationsMetadataStoresExecutionsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresExecutionsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresExecutionsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresExecutionsOperationsService
}

func NewProjectsLocationsMetadataStoresExecutionsOperationsService(s *Service) *ProjectsLocationsMetadataStoresExecutionsOperationsService {
	rs := &ProjectsLocationsMetadataStoresExecutionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresExecutionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresMetadataSchemasService(s *Service) *ProjectsLocationsMetadataStoresMetadataSchemasService {
	rs := &ProjectsLocationsMetadataStoresMetadataSchemasService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresMetadataSchemasService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresOperationsService(s *Service) *ProjectsLocationsMetadataStoresOperationsService {
	rs := &ProjectsLocationsMetadataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsMigratableResourcesService(s *Service) *ProjectsLocationsMigratableResourcesService {
	rs := &ProjectsLocationsMigratableResourcesService{s: s}
	rs.Operations = NewProjectsLocationsMigratableResourcesOperationsService(s)
	return rs
}

type ProjectsLocationsMigratableResourcesService struct {
	s *Service

	Operations *ProjectsLocationsMigratableResourcesOperationsService
}

func NewProjectsLocationsMigratableResourcesOperationsService(s *Service) *ProjectsLocationsMigratableResourcesOperationsService {
	rs := &ProjectsLocationsMigratableResourcesOperationsService{s: s}
	return rs
}

type ProjectsLocationsMigratableResourcesOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelDeploymentMonitoringJobsService(s *Service) *ProjectsLocationsModelDeploymentMonitoringJobsService {
	rs := &ProjectsLocationsModelDeploymentMonitoringJobsService{s: s}
	rs.Operations = NewProjectsLocationsModelDeploymentMonitoringJobsOperationsService(s)
	return rs
}

type ProjectsLocationsModelDeploymentMonitoringJobsService struct {
	s *Service

	Operations *ProjectsLocationsModelDeploymentMonitoringJobsOperationsService
}

func NewProjectsLocationsModelDeploymentMonitoringJobsOperationsService(s *Service) *ProjectsLocationsModelDeploymentMonitoringJobsOperationsService {
	rs := &ProjectsLocationsModelDeploymentMonitoringJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelDeploymentMonitoringJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelsService(s *Service) *ProjectsLocationsModelsService {
	rs := &ProjectsLocationsModelsService{s: s}
	rs.Evaluations = NewProjectsLocationsModelsEvaluationsService(s)
	rs.Operations = NewProjectsLocationsModelsOperationsService(s)
	return rs
}

type ProjectsLocationsModelsService struct {
	s *Service

	Evaluations *ProjectsLocationsModelsEvaluationsService

	Operations *ProjectsLocationsModelsOperationsService
}

func NewProjectsLocationsModelsEvaluationsService(s *Service) *ProjectsLocationsModelsEvaluationsService {
	rs := &ProjectsLocationsModelsEvaluationsService{s: s}
	rs.Operations = NewProjectsLocationsModelsEvaluationsOperationsService(s)
	rs.Slices = NewProjectsLocationsModelsEvaluationsSlicesService(s)
	return rs
}

type ProjectsLocationsModelsEvaluationsService struct {
	s *Service

	Operations *ProjectsLocationsModelsEvaluationsOperationsService

	Slices *ProjectsLocationsModelsEvaluationsSlicesService
}

func NewProjectsLocationsModelsEvaluationsOperationsService(s *Service) *ProjectsLocationsModelsEvaluationsOperationsService {
	rs := &ProjectsLocationsModelsEvaluationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelsEvaluationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelsEvaluationsSlicesService(s *Service) *ProjectsLocationsModelsEvaluationsSlicesService {
	rs := &ProjectsLocationsModelsEvaluationsSlicesService{s: s}
	return rs
}

type ProjectsLocationsModelsEvaluationsSlicesService struct {
	s *Service
}

func NewProjectsLocationsModelsOperationsService(s *Service) *ProjectsLocationsModelsOperationsService {
	rs := &ProjectsLocationsModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsNasJobsService(s *Service) *ProjectsLocationsNasJobsService {
	rs := &ProjectsLocationsNasJobsService{s: s}
	rs.NasTrialDetails = NewProjectsLocationsNasJobsNasTrialDetailsService(s)
	return rs
}

type ProjectsLocationsNasJobsService struct {
	s *Service

	NasTrialDetails *ProjectsLocationsNasJobsNasTrialDetailsService
}

func NewProjectsLocationsNasJobsNasTrialDetailsService(s *Service) *ProjectsLocationsNasJobsNasTrialDetailsService {
	rs := &ProjectsLocationsNasJobsNasTrialDetailsService{s: s}
	return rs
}

type ProjectsLocationsNasJobsNasTrialDetailsService struct {
	s *Service
}

func NewProjectsLocationsNotebookExecutionJobsService(s *Service) *ProjectsLocationsNotebookExecutionJobsService {
	rs := &ProjectsLocationsNotebookExecutionJobsService{s: s}
	rs.Operations = NewProjectsLocationsNotebookExecutionJobsOperationsService(s)
	return rs
}

type ProjectsLocationsNotebookExecutionJobsService struct {
	s *Service

	Operations *ProjectsLocationsNotebookExecutionJobsOperationsService
}

func NewProjectsLocationsNotebookExecutionJobsOperationsService(s *Service) *ProjectsLocationsNotebookExecutionJobsOperationsService {
	rs := &ProjectsLocationsNotebookExecutionJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsNotebookExecutionJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsNotebookRuntimeTemplatesService(s *Service) *ProjectsLocationsNotebookRuntimeTemplatesService {
	rs := &ProjectsLocationsNotebookRuntimeTemplatesService{s: s}
	rs.Operations = NewProjectsLocationsNotebookRuntimeTemplatesOperationsService(s)
	return rs
}

type ProjectsLocationsNotebookRuntimeTemplatesService struct {
	s *Service

	Operations *ProjectsLocationsNotebookRuntimeTemplatesOperationsService
}

func NewProjectsLocationsNotebookRuntimeTemplatesOperationsService(s *Service) *ProjectsLocationsNotebookRuntimeTemplatesOperationsService {
	rs := &ProjectsLocationsNotebookRuntimeTemplatesOperationsService{s: s}
	return rs
}

type ProjectsLocationsNotebookRuntimeTemplatesOperationsService struct {
	s *Service
}

func NewProjectsLocationsNotebookRuntimesService(s *Service) *ProjectsLocationsNotebookRuntimesService {
	rs := &ProjectsLocationsNotebookRuntimesService{s: s}
	rs.Operations = NewProjectsLocationsNotebookRuntimesOperationsService(s)
	return rs
}

type ProjectsLocationsNotebookRuntimesService struct {
	s *Service

	Operations *ProjectsLocationsNotebookRuntimesOperationsService
}

func NewProjectsLocationsNotebookRuntimesOperationsService(s *Service) *ProjectsLocationsNotebookRuntimesOperationsService {
	rs := &ProjectsLocationsNotebookRuntimesOperationsService{s: s}
	return rs
}

type ProjectsLocationsNotebookRuntimesOperationsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPersistentResourcesService(s *Service) *ProjectsLocationsPersistentResourcesService {
	rs := &ProjectsLocationsPersistentResourcesService{s: s}
	rs.Operations = NewProjectsLocationsPersistentResourcesOperationsService(s)
	return rs
}

type ProjectsLocationsPersistentResourcesService struct {
	s *Service

	Operations *ProjectsLocationsPersistentResourcesOperationsService
}

func NewProjectsLocationsPersistentResourcesOperationsService(s *Service) *ProjectsLocationsPersistentResourcesOperationsService {
	rs := &ProjectsLocationsPersistentResourcesOperationsService{s: s}
	return rs
}

type ProjectsLocationsPersistentResourcesOperationsService struct {
	s *Service
}

func NewProjectsLocationsPipelineJobsService(s *Service) *ProjectsLocationsPipelineJobsService {
	rs := &ProjectsLocationsPipelineJobsService{s: s}
	rs.Operations = NewProjectsLocationsPipelineJobsOperationsService(s)
	return rs
}

type ProjectsLocationsPipelineJobsService struct {
	s *Service

	Operations *ProjectsLocationsPipelineJobsOperationsService
}

func NewProjectsLocationsPipelineJobsOperationsService(s *Service) *ProjectsLocationsPipelineJobsOperationsService {
	rs := &ProjectsLocationsPipelineJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsPipelineJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPublishersService(s *Service) *ProjectsLocationsPublishersService {
	rs := &ProjectsLocationsPublishersService{s: s}
	rs.Models = NewProjectsLocationsPublishersModelsService(s)
	return rs
}

type ProjectsLocationsPublishersService struct {
	s *Service

	Models *ProjectsLocationsPublishersModelsService
}

func NewProjectsLocationsPublishersModelsService(s *Service) *ProjectsLocationsPublishersModelsService {
	rs := &ProjectsLocationsPublishersModelsService{s: s}
	return rs
}

type ProjectsLocationsPublishersModelsService struct {
	s *Service
}

func NewProjectsLocationsRagCorporaService(s *Service) *ProjectsLocationsRagCorporaService {
	rs := &ProjectsLocationsRagCorporaService{s: s}
	rs.Operations = NewProjectsLocationsRagCorporaOperationsService(s)
	rs.RagFiles = NewProjectsLocationsRagCorporaRagFilesService(s)
	return rs
}

type ProjectsLocationsRagCorporaService struct {
	s *Service

	Operations *ProjectsLocationsRagCorporaOperationsService

	RagFiles *ProjectsLocationsRagCorporaRagFilesService
}

func NewProjectsLocationsRagCorporaOperationsService(s *Service) *ProjectsLocationsRagCorporaOperationsService {
	rs := &ProjectsLocationsRagCorporaOperationsService{s: s}
	return rs
}

type ProjectsLocationsRagCorporaOperationsService struct {
	s *Service
}

func NewProjectsLocationsRagCorporaRagFilesService(s *Service) *ProjectsLocationsRagCorporaRagFilesService {
	rs := &ProjectsLocationsRagCorporaRagFilesService{s: s}
	rs.Operations = NewProjectsLocationsRagCorporaRagFilesOperationsService(s)
	return rs
}

type ProjectsLocationsRagCorporaRagFilesService struct {
	s *Service

	Operations *ProjectsLocationsRagCorporaRagFilesOperationsService
}

func NewProjectsLocationsRagCorporaRagFilesOperationsService(s *Service) *ProjectsLocationsRagCorporaRagFilesOperationsService {
	rs := &ProjectsLocationsRagCorporaRagFilesOperationsService{s: s}
	return rs
}

type ProjectsLocationsRagCorporaRagFilesOperationsService struct {
	s *Service
}

func NewProjectsLocationsRagEngineConfigService(s *Service) *ProjectsLocationsRagEngineConfigService {
	rs := &ProjectsLocationsRagEngineConfigService{s: s}
	rs.Operations = NewProjectsLocationsRagEngineConfigOperationsService(s)
	return rs
}

type ProjectsLocationsRagEngineConfigService struct {
	s *Service

	Operations *ProjectsLocationsRagEngineConfigOperationsService
}

func NewProjectsLocationsRagEngineConfigOperationsService(s *Service) *ProjectsLocationsRagEngineConfigOperationsService {
	rs := &ProjectsLocationsRagEngineConfigOperationsService{s: s}
	return rs
}

type ProjectsLocationsRagEngineConfigOperationsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesService(s *Service) *ProjectsLocationsReasoningEnginesService {
	rs := &ProjectsLocationsReasoningEnginesService{s: s}
	rs.Memories = NewProjectsLocationsReasoningEnginesMemoriesService(s)
	rs.Operations = NewProjectsLocationsReasoningEnginesOperationsService(s)
	rs.SandboxEnvironments = NewProjectsLocationsReasoningEnginesSandboxEnvironmentsService(s)
	rs.Sessions = NewProjectsLocationsReasoningEnginesSessionsService(s)
	return rs
}

type ProjectsLocationsReasoningEnginesService struct {
	s *Service

	Memories *ProjectsLocationsReasoningEnginesMemoriesService

	Operations *ProjectsLocationsReasoningEnginesOperationsService

	SandboxEnvironments *ProjectsLocationsReasoningEnginesSandboxEnvironmentsService

	Sessions *ProjectsLocationsReasoningEnginesSessionsService
}

func NewProjectsLocationsReasoningEnginesMemoriesService(s *Service) *ProjectsLocationsReasoningEnginesMemoriesService {
	rs := &ProjectsLocationsReasoningEnginesMemoriesService{s: s}
	rs.Operations = NewProjectsLocationsReasoningEnginesMemoriesOperationsService(s)
	rs.Revisions = NewProjectsLocationsReasoningEnginesMemoriesRevisionsService(s)
	return rs
}

type ProjectsLocationsReasoningEnginesMemoriesService struct {
	s *Service

	Operations *ProjectsLocationsReasoningEnginesMemoriesOperationsService

	Revisions *ProjectsLocationsReasoningEnginesMemoriesRevisionsService
}

func NewProjectsLocationsReasoningEnginesMemoriesOperationsService(s *Service) *ProjectsLocationsReasoningEnginesMemoriesOperationsService {
	rs := &ProjectsLocationsReasoningEnginesMemoriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesMemoriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesMemoriesRevisionsService(s *Service) *ProjectsLocationsReasoningEnginesMemoriesRevisionsService {
	rs := &ProjectsLocationsReasoningEnginesMemoriesRevisionsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesMemoriesRevisionsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesOperationsService(s *Service) *ProjectsLocationsReasoningEnginesOperationsService {
	rs := &ProjectsLocationsReasoningEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesSandboxEnvironmentsService(s *Service) *ProjectsLocationsReasoningEnginesSandboxEnvironmentsService {
	rs := &ProjectsLocationsReasoningEnginesSandboxEnvironmentsService{s: s}
	rs.Operations = NewProjectsLocationsReasoningEnginesSandboxEnvironmentsOperationsService(s)
	return rs
}

type ProjectsLocationsReasoningEnginesSandboxEnvironmentsService struct {
	s *Service

	Operations *ProjectsLocationsReasoningEnginesSandboxEnvironmentsOperationsService
}

func NewProjectsLocationsReasoningEnginesSandboxEnvironmentsOperationsService(s *Service) *ProjectsLocationsReasoningEnginesSandboxEnvironmentsOperationsService {
	rs := &ProjectsLocationsReasoningEnginesSandboxEnvironmentsOperationsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesSandboxEnvironmentsOperationsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesSessionsService(s *Service) *ProjectsLocationsReasoningEnginesSessionsService {
	rs := &ProjectsLocationsReasoningEnginesSessionsService{s: s}
	rs.Events = NewProjectsLocationsReasoningEnginesSessionsEventsService(s)
	rs.Operations = NewProjectsLocationsReasoningEnginesSessionsOperationsService(s)
	return rs
}

type ProjectsLocationsReasoningEnginesSessionsService struct {
	s *Service

	Events *ProjectsLocationsReasoningEnginesSessionsEventsService

	Operations *ProjectsLocationsReasoningEnginesSessionsOperationsService
}

func NewProjectsLocationsReasoningEnginesSessionsEventsService(s *Service) *ProjectsLocationsReasoningEnginesSessionsEventsService {
	rs := &ProjectsLocationsReasoningEnginesSessionsEventsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesSessionsEventsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesSessionsOperationsService(s *Service) *ProjectsLocationsReasoningEnginesSessionsOperationsService {
	rs := &ProjectsLocationsReasoningEnginesSessionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesSessionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSchedulesService(s *Service) *ProjectsLocationsSchedulesService {
	rs := &ProjectsLocationsSchedulesService{s: s}
	rs.Operations = NewProjectsLocationsSchedulesOperationsService(s)
	return rs
}

type ProjectsLocationsSchedulesService struct {
	s *Service

	Operations *ProjectsLocationsSchedulesOperationsService
}

func NewProjectsLocationsSchedulesOperationsService(s *Service) *ProjectsLocationsSchedulesOperationsService {
	rs := &ProjectsLocationsSchedulesOperationsService{s: s}
	return rs
}

type ProjectsLocationsSchedulesOperationsService struct {
	s *Service
}

func NewProjectsLocationsSpecialistPoolsService(s *Service) *ProjectsLocationsSpecialistPoolsService {
	rs := &ProjectsLocationsSpecialistPoolsService{s: s}
	rs.Operations = NewProjectsLocationsSpecialistPoolsOperationsService(s)
	return rs
}

type ProjectsLocationsSpecialistPoolsService struct {
	s *Service

	Operations *ProjectsLocationsSpecialistPoolsOperationsService
}

func NewProjectsLocationsSpecialistPoolsOperationsService(s *Service) *ProjectsLocationsSpecialistPoolsOperationsService {
	rs := &ProjectsLocationsSpecialistPoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsSpecialistPoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsStudiesService(s *Service) *ProjectsLocationsStudiesService {
	rs := &ProjectsLocationsStudiesService{s: s}
	rs.Operations = NewProjectsLocationsStudiesOperationsService(s)
	rs.Trials = NewProjectsLocationsStudiesTrialsService(s)
	return rs
}

type ProjectsLocationsStudiesService struct {
	s *Service

	Operations *ProjectsLocationsStudiesOperationsService

	Trials *ProjectsLocationsStudiesTrialsService
}

func NewProjectsLocationsStudiesOperationsService(s *Service) *ProjectsLocationsStudiesOperationsService {
	rs := &ProjectsLocationsStudiesOperationsService{s: s}
	return rs
}

type ProjectsLocationsStudiesOperationsService struct {
	s *Service
}

func NewProjectsLocationsStudiesTrialsService(s *Service) *ProjectsLocationsStudiesTrialsService {
	rs := &ProjectsLocationsStudiesTrialsService{s: s}
	rs.Operations = NewProjectsLocationsStudiesTrialsOperationsService(s)
	return rs
}

type ProjectsLocationsStudiesTrialsService struct {
	s *Service

	Operations *ProjectsLocationsStudiesTrialsOperationsService
}

func NewProjectsLocationsStudiesTrialsOperationsService(s *Service) *ProjectsLocationsStudiesTrialsOperationsService {
	rs := &ProjectsLocationsStudiesTrialsOperationsService{s: s}
	return rs
}

type ProjectsLocationsStudiesTrialsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsService(s *Service) *ProjectsLocationsTensorboardsService {
	rs := &ProjectsLocationsTensorboardsService{s: s}
	rs.Experiments = NewProjectsLocationsTensorboardsExperimentsService(s)
	rs.Operations = NewProjectsLocationsTensorboardsOperationsService(s)
	return rs
}

type ProjectsLocationsTensorboardsService struct {
	s *Service

	Experiments *ProjectsLocationsTensorboardsExperimentsService

	Operations *ProjectsLocationsTensorboardsOperationsService
}

func NewProjectsLocationsTensorboardsExperimentsService(s *Service) *ProjectsLocationsTensorboardsExperimentsService {
	rs := &ProjectsLocationsTensorboardsExperimentsService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsOperationsService(s)
	rs.Runs = NewProjectsLocationsTensorboardsExperimentsRunsService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsOperationsService

	Runs *ProjectsLocationsTensorboardsExperimentsRunsService
}

func NewProjectsLocationsTensorboardsExperimentsOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsExperimentsRunsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsRunsOperationsService(s)
	rs.TimeSeries = NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsRunsOperationsService

	TimeSeries *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService
}

func NewProjectsLocationsTensorboardsExperimentsRunsOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService
}

func NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsOperationsService(s *Service) *ProjectsLocationsTensorboardsOperationsService {
	rs := &ProjectsLocationsTensorboardsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTrainingPipelinesService(s *Service) *ProjectsLocationsTrainingPipelinesService {
	rs := &ProjectsLocationsTrainingPipelinesService{s: s}
	rs.Operations = NewProjectsLocationsTrainingPipelinesOperationsService(s)
	return rs
}

type ProjectsLocationsTrainingPipelinesService struct {
	s *Service

	Operations *ProjectsLocationsTrainingPipelinesOperationsService
}

func NewProjectsLocationsTrainingPipelinesOperationsService(s *Service) *ProjectsLocationsTrainingPipelinesOperationsService {
	rs := &ProjectsLocationsTrainingPipelinesOperationsService{s: s}
	return rs
}

type ProjectsLocationsTrainingPipelinesOperationsService struct {
	s *Service
}

func NewProjectsLocationsTuningJobsService(s *Service) *ProjectsLocationsTuningJobsService {
	rs := &ProjectsLocationsTuningJobsService{s: s}
	rs.Operations = NewProjectsLocationsTuningJobsOperationsService(s)
	return rs
}

type ProjectsLocationsTuningJobsService struct {
	s *Service

	Operations *ProjectsLocationsTuningJobsOperationsService
}

func NewProjectsLocationsTuningJobsOperationsService(s *Service) *ProjectsLocationsTuningJobsOperationsService {
	rs := &ProjectsLocationsTuningJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTuningJobsOperationsService struct {
	s *Service
}

func NewPublishersService(s *Service) *PublishersService {
	rs := &PublishersService{s: s}
	rs.Models = NewPublishersModelsService(s)
	return rs
}

type PublishersService struct {
	s *Service

	Models *PublishersModelsService
}

func NewPublishersModelsService(s *Service) *PublishersModelsService {
	rs := &PublishersModelsService{s: s}
	return rs
}

type PublishersModelsService struct {
	s *Service
}

func NewRagCorporaService(s *Service) *RagCorporaService {
	rs := &RagCorporaService{s: s}
	rs.Operations = NewRagCorporaOperationsService(s)
	rs.RagFiles = NewRagCorporaRagFilesService(s)
	return rs
}

type RagCorporaService struct {
	s *Service

	Operations *RagCorporaOperationsService

	RagFiles *RagCorporaRagFilesService
}

func NewRagCorporaOperationsService(s *Service) *RagCorporaOperationsService {
	rs := &RagCorporaOperationsService{s: s}
	return rs
}

type RagCorporaOperationsService struct {
	s *Service
}

func NewRagCorporaRagFilesService(s *Service) *RagCorporaRagFilesService {
	rs := &RagCorporaRagFilesService{s: s}
	rs.Operations = NewRagCorporaRagFilesOperationsService(s)
	return rs
}

type RagCorporaRagFilesService struct {
	s *Service

	Operations *RagCorporaRagFilesOperationsService
}

func NewRagCorporaRagFilesOperationsService(s *Service) *RagCorporaRagFilesOperationsService {
	rs := &RagCorporaRagFilesOperationsService{s: s}
	return rs
}

type RagCorporaRagFilesOperationsService struct {
	s *Service
}

func NewRagEngineConfigService(s *Service) *RagEngineConfigService {
	rs := &RagEngineConfigService{s: s}
	rs.Operations = NewRagEngineConfigOperationsService(s)
	return rs
}

type RagEngineConfigService struct {
	s *Service

	Operations *RagEngineConfigOperationsService
}

func NewRagEngineConfigOperationsService(s *Service) *RagEngineConfigOperationsService {
	rs := &RagEngineConfigOperationsService{s: s}
	return rs
}

type RagEngineConfigOperationsService struct {
	s *Service
}

func NewReasoningEnginesService(s *Service) *ReasoningEnginesService {
	rs := &ReasoningEnginesService{s: s}
	rs.Memories = NewReasoningEnginesMemoriesService(s)
	rs.Operations = NewReasoningEnginesOperationsService(s)
	rs.SandboxEnvironments = NewReasoningEnginesSandboxEnvironmentsService(s)
	rs.Sessions = NewReasoningEnginesSessionsService(s)
	return rs
}

type ReasoningEnginesService struct {
	s *Service

	Memories *ReasoningEnginesMemoriesService

	Operations *ReasoningEnginesOperationsService

	SandboxEnvironments *ReasoningEnginesSandboxEnvironmentsService

	Sessions *ReasoningEnginesSessionsService
}

func NewReasoningEnginesMemoriesService(s *Service) *ReasoningEnginesMemoriesService {
	rs := &ReasoningEnginesMemoriesService{s: s}
	rs.Operations = NewReasoningEnginesMemoriesOperationsService(s)
	return rs
}

type ReasoningEnginesMemoriesService struct {
	s *Service

	Operations *ReasoningEnginesMemoriesOperationsService
}

func NewReasoningEnginesMemoriesOperationsService(s *Service) *ReasoningEnginesMemoriesOperationsService {
	rs := &ReasoningEnginesMemoriesOperationsService{s: s}
	return rs
}

type ReasoningEnginesMemoriesOperationsService struct {
	s *Service
}

func NewReasoningEnginesOperationsService(s *Service) *ReasoningEnginesOperationsService {
	rs := &ReasoningEnginesOperationsService{s: s}
	return rs
}

type ReasoningEnginesOperationsService struct {
	s *Service
}

func NewReasoningEnginesSandboxEnvironmentsService(s *Service) *ReasoningEnginesSandboxEnvironmentsService {
	rs := &ReasoningEnginesSandboxEnvironmentsService{s: s}
	rs.Operations = NewReasoningEnginesSandboxEnvironmentsOperationsService(s)
	return rs
}

type ReasoningEnginesSandboxEnvironmentsService struct {
	s *Service

	Operations *ReasoningEnginesSandboxEnvironmentsOperationsService
}

func NewReasoningEnginesSandboxEnvironmentsOperationsService(s *Service) *ReasoningEnginesSandboxEnvironmentsOperationsService {
	rs := &ReasoningEnginesSandboxEnvironmentsOperationsService{s: s}
	return rs
}

type ReasoningEnginesSandboxEnvironmentsOperationsService struct {
	s *Service
}

func NewReasoningEnginesSessionsService(s *Service) *ReasoningEnginesSessionsService {
	rs := &ReasoningEnginesSessionsService{s: s}
	rs.Operations = NewReasoningEnginesSessionsOperationsService(s)
	return rs
}

type ReasoningEnginesSessionsService struct {
	s *Service

	Operations *ReasoningEnginesSessionsOperationsService
}

func NewReasoningEnginesSessionsOperationsService(s *Service) *ReasoningEnginesSessionsOperationsService {
	rs := &ReasoningEnginesSessionsOperationsService{s: s}
	return rs
}

type ReasoningEnginesSessionsOperationsService struct {
	s *Service
}

func NewSchedulesService(s *Service) *SchedulesService {
	rs := &SchedulesService{s: s}
	rs.Operations = NewSchedulesOperationsService(s)
	return rs
}

type SchedulesService struct {
	s *Service

	Operations *SchedulesOperationsService
}

func NewSchedulesOperationsService(s *Service) *SchedulesOperationsService {
	rs := &SchedulesOperationsService{s: s}
	return rs
}

type SchedulesOperationsService struct {
	s *Service
}

func NewSpecialistPoolsService(s *Service) *SpecialistPoolsService {
	rs := &SpecialistPoolsService{s: s}
	rs.Operations = NewSpecialistPoolsOperationsService(s)
	return rs
}

type SpecialistPoolsService struct {
	s *Service

	Operations *SpecialistPoolsOperationsService
}

func NewSpecialistPoolsOperationsService(s *Service) *SpecialistPoolsOperationsService {
	rs := &SpecialistPoolsOperationsService{s: s}
	return rs
}

type SpecialistPoolsOperationsService struct {
	s *Service
}

func NewStudiesService(s *Service) *StudiesService {
	rs := &StudiesService{s: s}
	rs.Operations = NewStudiesOperationsService(s)
	rs.Trials = NewStudiesTrialsService(s)
	return rs
}

type StudiesService struct {
	s *Service

	Operations *StudiesOperationsService

	Trials *StudiesTrialsService
}

func NewStudiesOperationsService(s *Service) *StudiesOperationsService {
	rs := &StudiesOperationsService{s: s}
	return rs
}

type StudiesOperationsService struct {
	s *Service
}

func NewStudiesTrialsService(s *Service) *StudiesTrialsService {
	rs := &StudiesTrialsService{s: s}
	rs.Operations = NewStudiesTrialsOperationsService(s)
	return rs
}

type StudiesTrialsService struct {
	s *Service

	Operations *StudiesTrialsOperationsService
}

func NewStudiesTrialsOperationsService(s *Service) *StudiesTrialsOperationsService {
	rs := &StudiesTrialsOperationsService{s: s}
	return rs
}

type StudiesTrialsOperationsService struct {
	s *Service
}

func NewTensorboardsService(s *Service) *TensorboardsService {
	rs := &TensorboardsService{s: s}
	rs.Experiments = NewTensorboardsExperimentsService(s)
	rs.Operations = NewTensorboardsOperationsService(s)
	return rs
}

type TensorboardsService struct {
	s *Service

	Experiments *TensorboardsExperimentsService

	Operations *TensorboardsOperationsService
}

func NewTensorboardsExperimentsService(s *Service) *TensorboardsExperimentsService {
	rs := &TensorboardsExperimentsService{s: s}
	rs.Operations = NewTensorboardsExperimentsOperationsService(s)
	rs.Runs = NewTensorboardsExperimentsRunsService(s)
	return rs
}

type TensorboardsExperimentsService struct {
	s *Service

	Operations *TensorboardsExperimentsOperationsService

	Runs *TensorboardsExperimentsRunsService
}

func NewTensorboardsExperimentsOperationsService(s *Service) *TensorboardsExperimentsOperationsService {
	rs := &TensorboardsExperimentsOperationsService{s: s}
	return rs
}

type TensorboardsExperimentsOperationsService struct {
	s *Service
}

func NewTensorboardsExperimentsRunsService(s *Service) *TensorboardsExperimentsRunsService {
	rs := &TensorboardsExperimentsRunsService{s: s}
	rs.Operations = NewTensorboardsExperimentsRunsOperationsService(s)
	rs.TimeSeries = NewTensorboardsExperimentsRunsTimeSeriesService(s)
	return rs
}

type TensorboardsExperimentsRunsService struct {
	s *Service

	Operations *TensorboardsExperimentsRunsOperationsService

	TimeSeries *TensorboardsExperimentsRunsTimeSeriesService
}

func NewTensorboardsExperimentsRunsOperationsService(s *Service) *TensorboardsExperimentsRunsOperationsService {
	rs := &TensorboardsExperimentsRunsOperationsService{s: s}
	return rs
}

type TensorboardsExperimentsRunsOperationsService struct {
	s *Service
}

func NewTensorboardsExperimentsRunsTimeSeriesService(s *Service) *TensorboardsExperimentsRunsTimeSeriesService {
	rs := &TensorboardsExperimentsRunsTimeSeriesService{s: s}
	rs.Operations = NewTensorboardsExperimentsRunsTimeSeriesOperationsService(s)
	return rs
}

type TensorboardsExperimentsRunsTimeSeriesService struct {
	s *Service

	Operations *TensorboardsExperimentsRunsTimeSeriesOperationsService
}

func NewTensorboardsExperimentsRunsTimeSeriesOperationsService(s *Service) *TensorboardsExperimentsRunsTimeSeriesOperationsService {
	rs := &TensorboardsExperimentsRunsTimeSeriesOperationsService{s: s}
	return rs
}

type TensorboardsExperimentsRunsTimeSeriesOperationsService struct {
	s *Service
}

func NewTensorboardsOperationsService(s *Service) *TensorboardsOperationsService {
	rs := &TensorboardsOperationsService{s: s}
	return rs
}

type TensorboardsOperationsService struct {
	s *Service
}

func NewTrainingPipelinesService(s *Service) *TrainingPipelinesService {
	rs := &TrainingPipelinesService{s: s}
	rs.Operations = NewTrainingPipelinesOperationsService(s)
	return rs
}

type TrainingPipelinesService struct {
	s *Service

	Operations *TrainingPipelinesOperationsService
}

func NewTrainingPipelinesOperationsService(s *Service) *TrainingPipelinesOperationsService {
	rs := &TrainingPipelinesOperationsService{s: s}
	return rs
}

type TrainingPipelinesOperationsService struct {
	s *Service
}

func NewTuningJobsService(s *Service) *TuningJobsService {
	rs := &TuningJobsService{s: s}
	rs.Operations = NewTuningJobsOperationsService(s)
	return rs
}

type TuningJobsService struct {
	s *Service

	Operations *TuningJobsOperationsService
}

func NewTuningJobsOperationsService(s *Service) *TuningJobsOperationsService {
	rs := &TuningJobsOperationsService{s: s}
	return rs
}

type TuningJobsOperationsService struct {
	s *Service
}

func NewV1Service(s *Service) *V1Service {
	rs := &V1Service{s: s}
	return rs
}

type V1Service struct {
	s *Service
}

// CloudAiLargeModelsVisionGenerateVideoResponse: Generate video response.
type CloudAiLargeModelsVisionGenerateVideoResponse struct {
	// GeneratedSamples: The generates samples.
	GeneratedSamples []*CloudAiLargeModelsVisionMedia `json:"generatedSamples,omitempty"`
	// RaiMediaFilteredCount: Returns if any videos were filtered due to RAI
	// policies.
	RaiMediaFilteredCount int64 `json:"raiMediaFilteredCount,omitempty"`
	// RaiMediaFilteredReasons: Returns rai failure reasons if any.
	RaiMediaFilteredReasons []string `json:"raiMediaFilteredReasons,omitempty"`
	// Videos: List of videos, used to align naming with the external response.
	Videos []*CloudAiLargeModelsVisionGenerateVideoResponseVideo `json:"videos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratedSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratedSamples") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionGenerateVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionGenerateVideoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiLargeModelsVisionGenerateVideoResponseVideo struct {
	// BytesBase64Encoded: Base64 encoded bytes string representing the video.
	BytesBase64Encoded string `json:"bytesBase64Encoded,omitempty"`
	// GcsUri: Cloud Storage URI where the generated video is written.
	GcsUri string `json:"gcsUri,omitempty"`
	// MimeType: The MIME type of the content of the video. - video/mp4
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesBase64Encoded") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesBase64Encoded") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionGenerateVideoResponseVideo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionGenerateVideoResponseVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImage: Image.
type CloudAiLargeModelsVisionImage struct {
	// Encoding: Image encoding, encoded as "image/png" or "image/jpg".
	Encoding string `json:"encoding,omitempty"`
	// GenerationSeed: Generation seed for the sampled image. This parameter is
	// exposed to the user only if one of the following is true: 1. The user
	// specified per-example seeds in the request. 2. The user doesn't specify the
	// generation seed in the request.
	GenerationSeed int64 `json:"generationSeed,omitempty"`
	// Image: Raw bytes.
	Image string `json:"image,omitempty"`
	// ImageRaiScores: RAI scores for generated image.
	ImageRaiScores *CloudAiLargeModelsVisionImageRAIScores `json:"imageRaiScores,omitempty"`
	// ImageSize: Image size. The size of the image. Can be self reported, or
	// computed from the image bytes.
	ImageSize *CloudAiLargeModelsVisionImageImageSize `json:"imageSize,omitempty"`
	// RaiInfo: RAI info for image.
	RaiInfo *CloudAiLargeModelsVisionRaiInfo `json:"raiInfo,omitempty"`
	// SemanticFilterResponse: Semantic filter info for image.
	SemanticFilterResponse *CloudAiLargeModelsVisionSemanticFilterResponse `json:"semanticFilterResponse,omitempty"`
	// Text: Text/Expanded text input for imagen.
	Text string `json:"text,omitempty"`
	// Uri: Path to another storage (typically Google Cloud Storage).
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionImage) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImageImageSize: Image size.
type CloudAiLargeModelsVisionImageImageSize struct {
	Channels int64 `json:"channels,omitempty"`
	Height   int64 `json:"height,omitempty"`
	Width    int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionImageImageSize) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImageImageSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImageRAIScores: RAI scores for generated image
// returned.
type CloudAiLargeModelsVisionImageRAIScores struct {
	// AgileWatermarkDetectionScore: Agile watermark score for image.
	AgileWatermarkDetectionScore float64 `json:"agileWatermarkDetectionScore,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AgileWatermarkDetectionScore") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgileWatermarkDetectionScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionImageRAIScores) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImageRAIScores
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionImageRAIScores) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionImageRAIScores
	var s1 struct {
		AgileWatermarkDetectionScore gensupport.JSONFloat64 `json:"agileWatermarkDetectionScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AgileWatermarkDetectionScore = float64(s1.AgileWatermarkDetectionScore)
	return nil
}

// CloudAiLargeModelsVisionMedia: Media.
type CloudAiLargeModelsVisionMedia struct {
	// Image: Image.
	Image *CloudAiLargeModelsVisionImage `json:"image,omitempty"`
	// Video: Video
	Video *CloudAiLargeModelsVisionVideo `json:"video,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionMedia) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiLargeModelsVisionNamedBoundingBox struct {
	Classes  []string  `json:"classes,omitempty"`
	Entities []string  `json:"entities,omitempty"`
	Scores   []float64 `json:"scores,omitempty"`
	X1       float64   `json:"x1,omitempty"`
	X2       float64   `json:"x2,omitempty"`
	Y1       float64   `json:"y1,omitempty"`
	Y2       float64   `json:"y2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Classes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Classes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionNamedBoundingBox) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionNamedBoundingBox
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionNamedBoundingBox) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionNamedBoundingBox
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		X1     gensupport.JSONFloat64   `json:"x1"`
		X2     gensupport.JSONFloat64   `json:"x2"`
		Y1     gensupport.JSONFloat64   `json:"y1"`
		Y2     gensupport.JSONFloat64   `json:"y2"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	s.X1 = float64(s1.X1)
	s.X2 = float64(s1.X2)
	s.Y1 = float64(s1.Y1)
	s.Y2 = float64(s1.Y2)
	return nil
}

// CloudAiLargeModelsVisionRaiInfo: Next ID: 6
type CloudAiLargeModelsVisionRaiInfo struct {
	// BlockedEntities: List of blocked entities from the blocklist if it is
	// detected.
	BlockedEntities []string `json:"blockedEntities,omitempty"`
	// DetectedLabels: The list of detected labels for different rai categories.
	DetectedLabels []*CloudAiLargeModelsVisionRaiInfoDetectedLabels `json:"detectedLabels,omitempty"`
	// ModelName: The model name used to indexing into the RaiFilterConfig map.
	// Would either be one of imagegeneration@002-006, imagen-3.0-... api endpoint
	// names, or internal names used for mapping to different filter configs
	// (genselfie, ai_watermark) than its api endpoint.
	ModelName string `json:"modelName,omitempty"`
	// RaiCategories: List of rai categories' information to return
	RaiCategories []string `json:"raiCategories,omitempty"`
	// Scores: List of rai scores mapping to the rai categories. Rounded to 1
	// decimal place.
	Scores []float64 `json:"scores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockedEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockedEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionRaiInfo) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionRaiInfo
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	return nil
}

// CloudAiLargeModelsVisionRaiInfoDetectedLabels: Filters returning list of
// deteceted labels, scores, and bounding boxes.
type CloudAiLargeModelsVisionRaiInfoDetectedLabels struct {
	// Entities: The list of detected entities for the rai signal.
	Entities []*CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity `json:"entities,omitempty"`
	// RaiCategory: The RAI category for the deteceted labels.
	RaiCategory string `json:"raiCategory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfoDetectedLabels) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabels
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox: An integer
// bounding box of original pixels of the image for the detected labels.
type CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox struct {
	// X1: The X coordinate of the top-left corner, in pixels.
	X1 int64 `json:"x1,omitempty"`
	// X2: The X coordinate of the bottom-right corner, in pixels.
	X2 int64 `json:"x2,omitempty"`
	// Y1: The Y coordinate of the top-left corner, in pixels.
	Y1 int64 `json:"y1,omitempty"`
	// Y2: The Y coordinate of the bottom-right corner, in pixels.
	Y2 int64 `json:"y2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X1") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X1") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity: The properties for a
// detected entity from the rai signal.
type CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity struct {
	// BoundingBox: Bounding box of the label
	BoundingBox *CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox `json:"boundingBox,omitempty"`
	// Description: Description of the label
	Description string `json:"description,omitempty"`
	// IouScore: The intersection ratio between the detection bounding box and the
	// mask.
	IouScore float64 `json:"iouScore,omitempty"`
	// Mid: MID of the label
	Mid string `json:"mid,omitempty"`
	// Score: Confidence score of the label
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingBox") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingBox") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity
	var s1 struct {
		IouScore gensupport.JSONFloat64 `json:"iouScore"`
		Score    gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IouScore = float64(s1.IouScore)
	s.Score = float64(s1.Score)
	return nil
}

type CloudAiLargeModelsVisionSemanticFilterResponse struct {
	// NamedBoundingBoxes: Class labels of the bounding boxes that failed the
	// semantic filtering. Bounding box coordinates.
	NamedBoundingBoxes []*CloudAiLargeModelsVisionNamedBoundingBox `json:"namedBoundingBoxes,omitempty"`
	// PassedSemanticFilter: This response is added when semantic filter config is
	// turned on in EditConfig. It reports if this image is passed semantic filter
	// response. If passed_semantic_filter is false, the bounding box information
	// will be populated for user to check what caused the semantic filter to fail.
	PassedSemanticFilter bool `json:"passedSemanticFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamedBoundingBoxes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamedBoundingBoxes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionSemanticFilterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionSemanticFilterResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionVideo: Video
type CloudAiLargeModelsVisionVideo struct {
	// EncodedVideo: Base 64 encoded video bytes.
	EncodedVideo string `json:"encodedVideo,omitempty"`
	// Encoding: Video encoding, for example "video/mp4".
	Encoding string `json:"encoding,omitempty"`
	// Text: Text/Expanded text input for Help Me Write.
	Text string `json:"text,omitempty"`
	// Uri: Path to another storage (typically Google Cloud Storage).
	Uri string `json:"uri,omitempty"`
	// Video: Raw bytes.
	Video string `json:"video,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncodedVideo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncodedVideo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionVideo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformCommonCreatePipelineJobApiErrorDetail: Create API error
// message for Vertex Pipeline.
type CloudAiPlatformCommonCreatePipelineJobApiErrorDetail struct {
	// ErrorCause: The error root cause returned by CreatePipelineJob API.
	//
	// Possible values:
	//   "ERROR_CAUSE_UNSPECIFIED" - Should never be used.
	//   "INVALID_PIPELINE_SPEC_FORMAT" - IR Pipeline Spec can not been parsed to
	// yaml or json format.
	//   "INVALID_PIPELINE_SPEC" - A pipeline spec is invalid.
	//   "INVALID_DEPLOYMENT_CONFIG" - A deployment config is invalid.
	//   "INVALID_DEPLOYMENT_SPEC" - A deployment spec is invalid.
	//   "INVALID_INSTANCE_SCHEMA" - An instance schema is invalid.
	//   "INVALID_CUSTOM_JOB" - A custom job is invalid.
	//   "INVALID_CONTAINER_SPEC" - A container spec is invalid.
	//   "INVALID_NOTIFICATION_EMAIL_SETUP" - Notification email setup is invalid.
	//   "INVALID_SERVICE_ACCOUNT_SETUP" - Service account setup is invalid.
	//   "INVALID_KMS_SETUP" - KMS setup is invalid.
	//   "INVALID_NETWORK_SETUP" - Network setup is invalid.
	//   "INVALID_PIPELINE_TASK_SPEC" - Task spec is invalid.
	//   "INVALID_PIPELINE_TASK_ARTIFACT" - Task artifact is invalid.
	//   "INVALID_IMPORTER_SPEC" - Importer spec is invalid.
	//   "INVALID_RESOLVER_SPEC" - Resolver spec is invalid.
	//   "INVALID_RUNTIME_PARAMETERS" - Runtime Parameters are invalid.
	//   "CLOUD_API_NOT_ENABLED" - Cloud API not enabled.
	//   "INVALID_GCS_INPUT_URI" - Invalid Cloud Storage input uri
	//   "INVALID_GCS_OUTPUT_URI" - Invalid Cloud Storage output uri
	//   "INVALID_COMPONENT_SPEC" - Component spec of pipeline is invalid.
	//   "INVALID_DAG_OUTPUTS_SPEC" - DagOutputsSpec is invalid.
	//   "INVALID_DAG_SPEC" - DagSpec is invalid.
	//   "INSUFFICIENT_QUOTA" - Project does not have enough quota.
	//   "INTERNAL" - An internal error with unknown cause.
	ErrorCause string `json:"errorCause,omitempty"`
	// PublicMessage: Public messages contains actionable items for the error
	// cause.
	PublicMessage string `json:"publicMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorCause") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorCause") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformCommonCreatePipelineJobApiErrorDetail) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformCommonCreatePipelineJobApiErrorDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON, such as
// raw binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ActiveLearningConfig: Parameters that configure the
// active learning pipeline. Active learning will label the data incrementally
// by several iterations. For every iteration, it will select a batch of data
// based on the sampling strategy.
type GoogleCloudAiplatformV1ActiveLearningConfig struct {
	// MaxDataItemCount: Max number of human labeled DataItems.
	MaxDataItemCount int64 `json:"maxDataItemCount,omitempty,string"`
	// MaxDataItemPercentage: Max percent of total DataItems for human labeling.
	MaxDataItemPercentage int64 `json:"maxDataItemPercentage,omitempty"`
	// SampleConfig: Active learning data sampling config. For every active
	// learning labeling iteration, it will select a batch of data based on the
	// sampling strategy.
	SampleConfig *GoogleCloudAiplatformV1SampleConfig `json:"sampleConfig,omitempty"`
	// TrainingConfig: CMLE training config. For every active learning labeling
	// iteration, system will train a machine learning model on CMLE. The trained
	// model will be used by data sampling algorithm to select DataItems.
	TrainingConfig *GoogleCloudAiplatformV1TrainingConfig `json:"trainingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxDataItemCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxDataItemCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ActiveLearningConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ActiveLearningConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest: Request
// message for MetadataService.AddContextArtifactsAndExecutions.
type GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest struct {
	// Artifacts: The resource names of the Artifacts to attribute to the Context.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artif
	// acts/{artifact}`
	Artifacts []string `json:"artifacts,omitempty"`
	// Executions: The resource names of the Executions to associate with the
	// Context. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/execu
	// tions/{execution}`
	Executions []string `json:"executions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifacts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse: Response
// message for MetadataService.AddContextArtifactsAndExecutions.
type GoogleCloudAiplatformV1AddContextArtifactsAndExecutionsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1AddContextChildrenRequest: Request message for
// MetadataService.AddContextChildren.
type GoogleCloudAiplatformV1AddContextChildrenRequest struct {
	// ChildContexts: The resource names of the child Contexts.
	ChildContexts []string `json:"childContexts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChildContexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChildContexts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AddContextChildrenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddContextChildrenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddContextChildrenResponse: Response message for
// MetadataService.AddContextChildren.
type GoogleCloudAiplatformV1AddContextChildrenResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1AddExecutionEventsRequest: Request message for
// MetadataService.AddExecutionEvents.
type GoogleCloudAiplatformV1AddExecutionEventsRequest struct {
	// Events: The Events to create and add.
	Events []*GoogleCloudAiplatformV1Event `json:"events,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Events") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Events") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AddExecutionEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddExecutionEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AddExecutionEventsResponse: Response message for
// MetadataService.AddExecutionEvents.
type GoogleCloudAiplatformV1AddExecutionEventsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1AddTrialMeasurementRequest: Request message for
// VizierService.AddTrialMeasurement.
type GoogleCloudAiplatformV1AddTrialMeasurementRequest struct {
	// Measurement: Required. The measurement to be added to a Trial.
	Measurement *GoogleCloudAiplatformV1Measurement `json:"measurement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Measurement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Measurement") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AddTrialMeasurementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AddTrialMeasurementRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AggregationOutput: The aggregation result for the
// entire dataset and all metrics.
type GoogleCloudAiplatformV1AggregationOutput struct {
	// AggregationResults: One AggregationResult per metric.
	AggregationResults []*GoogleCloudAiplatformV1AggregationResult `json:"aggregationResults,omitempty"`
	// Dataset: The dataset used for evaluation & aggregation.
	Dataset *GoogleCloudAiplatformV1EvaluationDataset `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationResults") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AggregationOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AggregationOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AggregationResult: The aggregation result for a
// single metric.
type GoogleCloudAiplatformV1AggregationResult struct {
	// AggregationMetric: Aggregation metric.
	//
	// Possible values:
	//   "AGGREGATION_METRIC_UNSPECIFIED" - Unspecified aggregation metric.
	//   "AVERAGE" - Average aggregation metric. Not supported for Pairwise metric.
	//   "MODE" - Mode aggregation metric.
	//   "STANDARD_DEVIATION" - Standard deviation aggregation metric. Not
	// supported for pairwise metric.
	//   "VARIANCE" - Variance aggregation metric. Not supported for pairwise
	// metric.
	//   "MINIMUM" - Minimum aggregation metric. Not supported for pairwise metric.
	//   "MAXIMUM" - Maximum aggregation metric. Not supported for pairwise metric.
	//   "MEDIAN" - Median aggregation metric. Not supported for pairwise metric.
	//   "PERCENTILE_P90" - 90th percentile aggregation metric. Not supported for
	// pairwise metric.
	//   "PERCENTILE_P95" - 95th percentile aggregation metric. Not supported for
	// pairwise metric.
	//   "PERCENTILE_P99" - 99th percentile aggregation metric. Not supported for
	// pairwise metric.
	AggregationMetric string `json:"aggregationMetric,omitempty"`
	// BleuMetricValue: Results for bleu metric.
	BleuMetricValue *GoogleCloudAiplatformV1BleuMetricValue `json:"bleuMetricValue,omitempty"`
	// CustomCodeExecutionResult: Result for code execution metric.
	CustomCodeExecutionResult *GoogleCloudAiplatformV1CustomCodeExecutionResult `json:"customCodeExecutionResult,omitempty"`
	// ExactMatchMetricValue: Results for exact match metric.
	ExactMatchMetricValue *GoogleCloudAiplatformV1ExactMatchMetricValue `json:"exactMatchMetricValue,omitempty"`
	// PairwiseMetricResult: Result for pairwise metric.
	PairwiseMetricResult *GoogleCloudAiplatformV1PairwiseMetricResult `json:"pairwiseMetricResult,omitempty"`
	// PointwiseMetricResult: Result for pointwise metric.
	PointwiseMetricResult *GoogleCloudAiplatformV1PointwiseMetricResult `json:"pointwiseMetricResult,omitempty"`
	// RougeMetricValue: Results for rouge metric.
	RougeMetricValue *GoogleCloudAiplatformV1RougeMetricValue `json:"rougeMetricValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationMetric") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationMetric") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AggregationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AggregationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Annotation: Used to assign specific AnnotationSpec to
// a particular area of a DataItem or the whole part of the DataItem.
type GoogleCloudAiplatformV1Annotation struct {
	// AnnotationSource: Output only. The source of the Annotation.
	AnnotationSource *GoogleCloudAiplatformV1UserActionReference `json:"annotationSource,omitempty"`
	// CreateTime: Output only. Timestamp when this Annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Annotations. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed. No
	// more than 64 user labels can be associated with one Annotation(System labels
	// are excluded). See https://goo.gl/xmQnxf for more information and examples
	// of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable. Following system labels
	// exist for each Annotation: *
	// "aiplatform.googleapis.com/annotation_set_name": optional, name of the UI's
	// annotation set this Annotation belongs to. If not set, the Annotation is not
	// visible in the UI. * "aiplatform.googleapis.com/payload_schema": output
	// only, its value is the payload_schema's title.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Resource name of the Annotation.
	Name string `json:"name,omitempty"`
	// Payload: Required. The schema of the payload can be found in payload_schema.
	Payload interface{} `json:"payload,omitempty"`
	// PayloadSchemaUri: Required. Google Cloud Storage URI points to a YAML file
	// describing payload. The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/, note that the
	// chosen schema must be consistent with the parent Dataset's metadata.
	PayloadSchemaUri string `json:"payloadSchemaUri,omitempty"`
	// UpdateTime: Output only. Timestamp when this Annotation was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Annotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Annotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AnnotationSpec: Identifies a concept with which
// DataItems may be annotated with.
type GoogleCloudAiplatformV1AnnotationSpec struct {
	// CreateTime: Output only. Timestamp when this AnnotationSpec was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The user-defined name of the AnnotationSpec. The name
	// can be up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Name: Output only. Resource name of the AnnotationSpec.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when AnnotationSpec was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AnnotationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AnnotationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ApiAuth: The generic reusable api auth config.
// Deprecated. Please use AuthConfig
// (google/cloud/aiplatform/master/auth.proto) instead.
type GoogleCloudAiplatformV1ApiAuth struct {
	// ApiKeyConfig: The API secret.
	ApiKeyConfig *GoogleCloudAiplatformV1ApiAuthApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ApiAuth) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ApiAuth
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ApiAuthApiKeyConfig: The API secret.
type GoogleCloudAiplatformV1ApiAuthApiKeyConfig struct {
	// ApiKeySecretVersion: Required. The SecretManager secret version resource
	// name storing API key. e.g.
	// projects/{project}/secrets/{secret}/versions/{version}
	ApiKeySecretVersion string `json:"apiKeySecretVersion,omitempty"`
	// ApiKeyString: The API key string. Either this or `api_key_secret_version`
	// must be set.
	ApiKeyString string `json:"apiKeyString,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecretVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ApiAuthApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ApiAuthApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AppendEventResponse: Response message for
// SessionService.AppendEvent.
type GoogleCloudAiplatformV1AppendEventResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1Artifact: Instance of a general artifact.
type GoogleCloudAiplatformV1Artifact struct {
	// CreateTime: Output only. Timestamp when this Artifact was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Artifact
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Artifact. May be up to 128
	// Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An eTag used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Artifacts.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Artifact (System labels are
	// excluded).
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Properties of the Artifact. Top level metadata keys' heading and
	// trailing spaces will be trimmed. The size of this field should not exceed
	// 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Output only. The resource name of the Artifact.
	Name string `json:"name,omitempty"`
	// SchemaTitle: The title of the schema describing the metadata. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaVersion: The version of the schema in schema_name to use. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// State: The state of this Artifact. This is a property of the Artifact, and
	// does not imply or capture any ongoing process. This property is managed by
	// clients (such as Vertex AI Pipelines), and the system does not prescribe or
	// check the validity of state transitions.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state for the Artifact.
	//   "PENDING" - A state used by systems like Vertex AI Pipelines to indicate
	// that the underlying data item represented by this Artifact is being created.
	//   "LIVE" - A state indicating that the Artifact should exist, unless
	// something external to the system deletes it.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this Artifact was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Uri: The uniform resource identifier of the artifact file. May be empty if
	// there is no actual artifact file.
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Artifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Artifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata: Metadata
// information for NotebookService.AssignNotebookRuntime.
type GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ProgressMessage: A human-readable message that shows the intermediate
	// progress details of NotebookRuntime.
	ProgressMessage string `json:"progressMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AssignNotebookRuntimeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AssignNotebookRuntimeRequest: Request message for
// NotebookService.AssignNotebookRuntime.
type GoogleCloudAiplatformV1AssignNotebookRuntimeRequest struct {
	// NotebookRuntime: Required. Provide runtime specific information (e.g.
	// runtime owner, notebook id) used for NotebookRuntime assignment.
	NotebookRuntime *GoogleCloudAiplatformV1NotebookRuntime `json:"notebookRuntime,omitempty"`
	// NotebookRuntimeId: Optional. User specified ID for the notebook runtime.
	NotebookRuntimeId string `json:"notebookRuntimeId,omitempty"`
	// NotebookRuntimeTemplate: Required. The resource name of the
	// NotebookRuntimeTemplate based on which a NotebookRuntime will be assigned
	// (reuse or create a new one).
	NotebookRuntimeTemplate string `json:"notebookRuntimeTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotebookRuntime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotebookRuntime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AssignNotebookRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AssignNotebookRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Attribution: Attribution that explains a particular
// prediction output.
type GoogleCloudAiplatformV1Attribution struct {
	// ApproximationError: Output only. Error of feature_attributions caused by
	// approximation used in the explanation method. Lower value means more precise
	// attributions. * For Sampled Shapley attribution, increasing path_count might
	// reduce the error. * For Integrated Gradients attribution, increasing
	// step_count might reduce the error. * For XRAI attribution, increasing
	// step_count might reduce the error. See this introduction
	// (/vertex-ai/docs/explainable-ai/overview) for more information.
	ApproximationError float64 `json:"approximationError,omitempty"`
	// BaselineOutputValue: Output only. Model predicted output if the input
	// instance is constructed from the baselines of all the features defined in
	// ExplanationMetadata.inputs. The field name of the output is determined by
	// the key in ExplanationMetadata.outputs. If the Model's predicted output has
	// multiple dimensions (rank > 1), this is the value in the output located by
	// output_index. If there are multiple baselines, their output values are
	// averaged.
	BaselineOutputValue float64 `json:"baselineOutputValue,omitempty"`
	// FeatureAttributions: Output only. Attributions of each explained feature.
	// Features are extracted from the prediction instances according to
	// explanation metadata for inputs. The value is a struct, whose keys are the
	// name of the feature. The values are how much the feature in the instance
	// contributed to the predicted result. The format of the value is determined
	// by the feature's input format: * If the feature is a scalar value, the
	// attribution value is a floating number. * If the feature is an array of
	// scalar values, the attribution value is an array. * If the feature is a
	// struct, the attribution value is a struct. The keys in the attribution value
	// struct are the same as the keys in the feature struct. The formats of the
	// values in the attribution struct are determined by the formats of the values
	// in the feature struct. The
	// ExplanationMetadata.feature_attributions_schema_uri field, pointed to by the
	// ExplanationSpec field of the Endpoint.deployed_models object, points to the
	// schema file that describes the features and their attribution values (if it
	// is populated).
	FeatureAttributions interface{} `json:"featureAttributions,omitempty"`
	// InstanceOutputValue: Output only. Model predicted output on the
	// corresponding explanation instance. The field name of the output is
	// determined by the key in ExplanationMetadata.outputs. If the Model predicted
	// output has multiple dimensions, this is the value in the output located by
	// output_index.
	InstanceOutputValue float64 `json:"instanceOutputValue,omitempty"`
	// OutputDisplayName: Output only. The display name of the output identified by
	// output_index. For example, the predicted class name by a
	// multi-classification Model. This field is only populated iff the Model
	// predicts display names as a separate field along with the explained output.
	// The predicted display name must has the same shape of the explained output,
	// and can be located using output_index.
	OutputDisplayName string `json:"outputDisplayName,omitempty"`
	// OutputIndex: Output only. The index that locates the explained prediction
	// output. If the prediction output is a scalar value, output_index is not
	// populated. If the prediction output has multiple dimensions, the length of
	// the output_index list is the same as the number of dimensions of the output.
	// The i-th element in output_index is the element index of the i-th dimension
	// of the output vector. Indices start from 0.
	OutputIndex []int64 `json:"outputIndex,omitempty"`
	// OutputName: Output only. Name of the explain output. Specified as the key in
	// ExplanationMetadata.outputs.
	OutputName string `json:"outputName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApproximationError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApproximationError") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Attribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Attribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1Attribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1Attribution
	var s1 struct {
		ApproximationError  gensupport.JSONFloat64 `json:"approximationError"`
		BaselineOutputValue gensupport.JSONFloat64 `json:"baselineOutputValue"`
		InstanceOutputValue gensupport.JSONFloat64 `json:"instanceOutputValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ApproximationError = float64(s1.ApproximationError)
	s.BaselineOutputValue = float64(s1.BaselineOutputValue)
	s.InstanceOutputValue = float64(s1.InstanceOutputValue)
	return nil
}

// GoogleCloudAiplatformV1AugmentPromptRequest: Request message for
// AugmentPrompt.
type GoogleCloudAiplatformV1AugmentPromptRequest struct {
	// Contents: Optional. Input content to augment, only text format is supported
	// for now.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// Model: Optional. Metadata of the backend deployed model.
	Model *GoogleCloudAiplatformV1AugmentPromptRequestModel `json:"model,omitempty"`
	// VertexRagStore: Optional. Retrieves contexts from the Vertex RagStore.
	VertexRagStore *GoogleCloudAiplatformV1VertexRagStore `json:"vertexRagStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AugmentPromptRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AugmentPromptRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AugmentPromptRequestModel: Metadata of the backend
// deployed model.
type GoogleCloudAiplatformV1AugmentPromptRequestModel struct {
	// Model: Optional. The model that the user will send the augmented prompt for
	// content generation.
	Model string `json:"model,omitempty"`
	// ModelVersion: Optional. The model version of the backend deployed model.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AugmentPromptRequestModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AugmentPromptRequestModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AugmentPromptResponse: Response message for
// AugmentPrompt.
type GoogleCloudAiplatformV1AugmentPromptResponse struct {
	// AugmentedPrompt: Augmented prompt, only text format is supported for now.
	AugmentedPrompt []*GoogleCloudAiplatformV1Content `json:"augmentedPrompt,omitempty"`
	// Facts: Retrieved facts from RAG data sources.
	Facts []*GoogleCloudAiplatformV1Fact `json:"facts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AugmentedPrompt") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AugmentedPrompt") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AugmentPromptResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AugmentPromptResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AuthConfig: Auth configuration to run the extension.
type GoogleCloudAiplatformV1AuthConfig struct {
	// ApiKeyConfig: Config for API key auth.
	ApiKeyConfig *GoogleCloudAiplatformV1AuthConfigApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// AuthType: Type of auth scheme.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED"
	//   "NO_AUTH" - No Auth.
	//   "API_KEY_AUTH" - API Key Auth.
	//   "HTTP_BASIC_AUTH" - HTTP Basic Auth.
	//   "GOOGLE_SERVICE_ACCOUNT_AUTH" - Google Service Account Auth.
	//   "OAUTH" - OAuth auth.
	//   "OIDC_AUTH" - OpenID Connect (OIDC) Auth.
	AuthType string `json:"authType,omitempty"`
	// GoogleServiceAccountConfig: Config for Google Service Account auth.
	GoogleServiceAccountConfig *GoogleCloudAiplatformV1AuthConfigGoogleServiceAccountConfig `json:"googleServiceAccountConfig,omitempty"`
	// HttpBasicAuthConfig: Config for HTTP Basic auth.
	HttpBasicAuthConfig *GoogleCloudAiplatformV1AuthConfigHttpBasicAuthConfig `json:"httpBasicAuthConfig,omitempty"`
	// OauthConfig: Config for user oauth.
	OauthConfig *GoogleCloudAiplatformV1AuthConfigOauthConfig `json:"oauthConfig,omitempty"`
	// OidcConfig: Config for user OIDC auth.
	OidcConfig *GoogleCloudAiplatformV1AuthConfigOidcConfig `json:"oidcConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AuthConfigApiKeyConfig: Config for authentication
// with API key.
type GoogleCloudAiplatformV1AuthConfigApiKeyConfig struct {
	// ApiKeySecret: Optional. The name of the SecretManager secret version
	// resource storing the API key. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}` - If both
	// `api_key_secret` and `api_key_string` are specified, this field takes
	// precedence over `api_key_string`. - If specified, the
	// `secretmanager.versions.access` permission should be granted to Vertex AI
	// Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	ApiKeySecret string `json:"apiKeySecret,omitempty"`
	// ApiKeyString: Optional. The API key to be used in the request directly.
	ApiKeyString string `json:"apiKeyString,omitempty"`
	// HttpElementLocation: Optional. The location of the API key.
	//
	// Possible values:
	//   "HTTP_IN_UNSPECIFIED"
	//   "HTTP_IN_QUERY" - Element is in the HTTP request query.
	//   "HTTP_IN_HEADER" - Element is in the HTTP request header.
	//   "HTTP_IN_PATH" - Element is in the HTTP request path.
	//   "HTTP_IN_BODY" - Element is in the HTTP request body.
	//   "HTTP_IN_COOKIE" - Element is in the HTTP request cookie.
	HttpElementLocation string `json:"httpElementLocation,omitempty"`
	// Name: Optional. The parameter name of the API key. E.g. If the API request
	// is "https://example.com/act?api_key=", "api_key" would be the parameter
	// name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecret") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AuthConfigApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AuthConfigApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AuthConfigGoogleServiceAccountConfig: Config for
// Google Service Account Authentication.
type GoogleCloudAiplatformV1AuthConfigGoogleServiceAccountConfig struct {
	// ServiceAccount: Optional. The service account that the extension execution
	// service runs as. - If the service account is specified, the
	// `iam.serviceAccounts.getAccessToken` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified service account. - If not specified, the Vertex AI
	// Extension Service Agent will be used to execute the Extension.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AuthConfigGoogleServiceAccountConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AuthConfigGoogleServiceAccountConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AuthConfigHttpBasicAuthConfig: Config for HTTP Basic
// Authentication.
type GoogleCloudAiplatformV1AuthConfigHttpBasicAuthConfig struct {
	// CredentialSecret: Required. The name of the SecretManager secret version
	// resource storing the base64 encoded credentials. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}` - If specified,
	// the `secretmanager.versions.access` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	CredentialSecret string `json:"credentialSecret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CredentialSecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CredentialSecret") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AuthConfigHttpBasicAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AuthConfigHttpBasicAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AuthConfigOauthConfig: Config for user oauth.
type GoogleCloudAiplatformV1AuthConfigOauthConfig struct {
	// AccessToken: Access token for extension endpoint. Only used to propagate
	// token from [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
	AccessToken string `json:"accessToken,omitempty"`
	// ServiceAccount: The service account used to generate access tokens for
	// executing the Extension. - If the service account is specified, the
	// `iam.serviceAccounts.getAccessToken` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the provided service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AuthConfigOauthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AuthConfigOauthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AuthConfigOidcConfig: Config for user OIDC auth.
type GoogleCloudAiplatformV1AuthConfigOidcConfig struct {
	// IdToken: OpenID Connect formatted ID token for extension endpoint. Only used
	// to propagate token from [[ExecuteExtensionRequest.runtime_auth_config]] at
	// request time.
	IdToken string `json:"idToken,omitempty"`
	// ServiceAccount: The service account used to generate an OpenID Connect
	// (OIDC)-compatible JWT token signed by the Google OIDC Provider
	// (accounts.google.com) for extension endpoint
	// (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
	// - The audience for the token will be set to the URL in the server url
	// defined in the OpenApi spec. - If the service account is provided, the
	// service account should grant `iam.serviceAccounts.getOpenIdToken` permission
	// to Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdToken") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AuthConfigOidcConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AuthConfigOidcConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AutomaticResources: A description of resources that
// to large degree are decided by Vertex AI, and require only a modest
// additional configuration. Each Model supporting these resources documents
// its specific guidelines.
type GoogleCloudAiplatformV1AutomaticResources struct {
	// MaxReplicaCount: Immutable. The maximum number of replicas that may be
	// deployed on when the traffic against it increases. If the requested value is
	// too large, the deployment will error, but if deployment succeeds then the
	// ability to scale to that many replicas is guaranteed (barring service
	// outages). If traffic increases beyond what its replicas at maximum may
	// handle, a portion of the traffic will be dropped. If this value is not
	// provided, a no upper bound for scaling under heavy traffic will be assume,
	// though Vertex AI may be unable to scale beyond certain replica number.
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`
	// MinReplicaCount: Immutable. The minimum number of replicas that will be
	// always deployed on. If traffic against it increases, it may dynamically be
	// deployed onto more replicas up to max_replica_count, and as traffic
	// decreases, some of these extra replicas may be freed. If the requested value
	// is too large, the deployment will error.
	MinReplicaCount int64 `json:"minReplicaCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxReplicaCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxReplicaCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AutomaticResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AutomaticResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AutoraterConfig: The configs for autorater. This is
// applicable to both EvaluateInstances and EvaluateDataset.
type GoogleCloudAiplatformV1AutoraterConfig struct {
	// AutoraterModel: Optional. The fully qualified name of the publisher model or
	// tuned autorater endpoint to use. Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*` Tuned model
	// endpoint format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	AutoraterModel string `json:"autoraterModel,omitempty"`
	// FlipEnabled: Optional. Default is true. Whether to flip the candidate and
	// baseline responses. This is only applicable to the pairwise metric. If
	// enabled, also provide PairwiseMetricSpec.candidate_response_field_name and
	// PairwiseMetricSpec.baseline_response_field_name. When rendering
	// PairwiseMetricSpec.metric_prompt_template, the candidate and baseline fields
	// will be flipped for half of the samples to reduce bias.
	FlipEnabled bool `json:"flipEnabled,omitempty"`
	// GenerationConfig: Optional. Configuration options for model generation and
	// outputs.
	GenerationConfig *GoogleCloudAiplatformV1GenerationConfig `json:"generationConfig,omitempty"`
	// SamplingCount: Optional. Number of samples for each instance in the dataset.
	// If not specified, the default is 4. Minimum value is 1, maximum value is 32.
	SamplingCount int64 `json:"samplingCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AutoraterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AutoraterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AutoscalingMetricSpec: The metric specification that
// defines the target resource utilization (CPU utilization, accelerator's duty
// cycle, and so on) for calculating the desired replica count.
type GoogleCloudAiplatformV1AutoscalingMetricSpec struct {
	// MetricName: Required. The resource metric name. Supported metrics: * For
	// Online Prediction: *
	// `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` *
	// `aiplatform.googleapis.com/prediction/online/cpu/utilization` *
	// `aiplatform.googleapis.com/prediction/online/request_count` *
	// `pubsub.googleapis.com/subscription/num_undelivered_messages` *
	// `prometheus.googleapis.com/vertex_dcgm_fi_dev_gpu_util` *
	// `prometheus.googleapis.com/vertex_vllm_gpu_cache_usage_perc` *
	// `prometheus.googleapis.com/vertex_vllm_num_requests_waiting`
	MetricName string `json:"metricName,omitempty"`
	// Target: The target resource utilization in percentage (1% - 100%) for the
	// given metric; once the real usage deviates from the target by a certain
	// percentage, the machine replicas change. The default value is 60
	// (representing 60%) if not provided.
	Target int64 `json:"target,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AutoscalingMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AutoscalingMetricSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1AvroSource: The storage details for Avro input
// content.
type GoogleCloudAiplatformV1AvroSource struct {
	// GcsSource: Required. Google Cloud Storage location.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1AvroSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1AvroSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest: Request message for
// PipelineService.BatchCancelPipelineJobs.
type GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest struct {
	// Names: Required. The names of the PipelineJobs to cancel. A maximum of 32
	// PipelineJobs can be cancelled in a batch. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCancelPipelineJobsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata: Details of
// operations that perform batch create Features.
type GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateFeaturesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateFeaturesRequest: Request message for
// FeaturestoreService.BatchCreateFeatures. Request message for
// FeatureRegistryService.BatchCreateFeatures.
type GoogleCloudAiplatformV1BatchCreateFeaturesRequest struct {
	// Requests: Required. The request message specifying the Features to create.
	// All Features must be created under the same parent EntityType /
	// FeatureGroup. The `parent` field in each child request message can be
	// omitted. If `parent` is set in a child request, then the value must match
	// the `parent` value in this request message.
	Requests []*GoogleCloudAiplatformV1CreateFeatureRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateFeaturesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateFeaturesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateFeaturesResponse: Response message for
// FeaturestoreService.BatchCreateFeatures.
type GoogleCloudAiplatformV1BatchCreateFeaturesResponse struct {
	// Features: The Features created.
	Features []*GoogleCloudAiplatformV1Feature `json:"features,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateFeaturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateFeaturesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest: Request message
// for TensorboardService.BatchCreateTensorboardRuns.
type GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest struct {
	// Requests: Required. The request message specifying the TensorboardRuns to
	// create. A maximum of 1000 TensorboardRuns can be created in a batch.
	Requests []*GoogleCloudAiplatformV1CreateTensorboardRunRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardRunsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse: Response message
// for TensorboardService.BatchCreateTensorboardRuns.
type GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse struct {
	// TensorboardRuns: The created TensorboardRuns.
	TensorboardRuns []*GoogleCloudAiplatformV1TensorboardRun `json:"tensorboardRuns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TensorboardRuns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TensorboardRuns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardRunsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest: Request
// message for TensorboardService.BatchCreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest struct {
	// Requests: Required. The request message specifying the TensorboardTimeSeries
	// to create. A maximum of 1000 TensorboardTimeSeries can be created in a
	// batch.
	Requests []*GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse: Response
// message for TensorboardService.BatchCreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse struct {
	// TensorboardTimeSeries: The created TensorboardTimeSeries.
	TensorboardTimeSeries []*GoogleCloudAiplatformV1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TensorboardTimeSeries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TensorboardTimeSeries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchCreateTensorboardTimeSeriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchDedicatedResources: A description of resources
// that are used for performing batch operations, are dedicated to a Model, and
// need manual configuration.
type GoogleCloudAiplatformV1BatchDedicatedResources struct {
	// MachineSpec: Required. Immutable. The specification of a single machine.
	MachineSpec *GoogleCloudAiplatformV1MachineSpec `json:"machineSpec,omitempty"`
	// MaxReplicaCount: Immutable. The maximum number of machine replicas the batch
	// operation may be scaled to. The default value is 10.
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`
	// StartingReplicaCount: Immutable. The number of machine replicas used at the
	// start of the batch operation. If not set, Vertex AI decides starting number,
	// not greater than max_replica_count
	StartingReplicaCount int64 `json:"startingReplicaCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchDedicatedResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchDedicatedResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest: Request message for
// PipelineService.BatchDeletePipelineJobs.
type GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest struct {
	// Names: Required. The names of the PipelineJobs to delete. A maximum of 32
	// PipelineJobs can be deleted in a batch. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchDeletePipelineJobsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest: Request
// message for ModelService.BatchImportEvaluatedAnnotations
type GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest struct {
	// EvaluatedAnnotations: Required. Evaluated annotations resource to be
	// imported.
	EvaluatedAnnotations []*GoogleCloudAiplatformV1EvaluatedAnnotation `json:"evaluatedAnnotations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluatedAnnotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluatedAnnotations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse: Response
// message for ModelService.BatchImportEvaluatedAnnotations
type GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse struct {
	// ImportedEvaluatedAnnotationsCount: Output only. Number of
	// EvaluatedAnnotations imported.
	ImportedEvaluatedAnnotationsCount int64 `json:"importedEvaluatedAnnotationsCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ImportedEvaluatedAnnotationsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ImportedEvaluatedAnnotationsCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportEvaluatedAnnotationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest: Request
// message for ModelService.BatchImportModelEvaluationSlices
type GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest struct {
	// ModelEvaluationSlices: Required. Model evaluation slice resource to be
	// imported.
	ModelEvaluationSlices []*GoogleCloudAiplatformV1ModelEvaluationSlice `json:"modelEvaluationSlices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse: Response
// message for ModelService.BatchImportModelEvaluationSlices
type GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse struct {
	// ImportedModelEvaluationSlices: Output only. List of imported
	// ModelEvaluationSlice.name.
	ImportedModelEvaluationSlices []string `json:"importedModelEvaluationSlices,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ImportedModelEvaluationSlices") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportedModelEvaluationSlices")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchImportModelEvaluationSlicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata: Runtime
// operation information for MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// PartialResults: Partial results that reflect the latest migration operation
	// progress.
	PartialResults []*GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult `json:"partialResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult:
// Represents a partial result in batch migration operation for one
// MigrateResourceRequest.
type GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult struct {
	// Dataset: Migrated dataset resource name.
	Dataset string `json:"dataset,omitempty"`
	// Error: The error result of the migration request in case of failure.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Model: Migrated model resource name.
	Model string `json:"model,omitempty"`
	// Request: It's the same as the value in
	// BatchMigrateResourcesRequest.migrate_resource_requests.
	Request *GoogleCloudAiplatformV1MigrateResourceRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesOperationMetadataPartialResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesRequest: Request message for
// MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1BatchMigrateResourcesRequest struct {
	// MigrateResourceRequests: Required. The request messages specifying the
	// resources to migrate. They must be in the same location as the destination.
	// Up to 50 resources can be migrated in one batch.
	MigrateResourceRequests []*GoogleCloudAiplatformV1MigrateResourceRequest `json:"migrateResourceRequests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrateResourceRequests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrateResourceRequests") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchMigrateResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchMigrateResourcesResponse: Response message for
// MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1BatchMigrateResourcesResponse struct {
	// MigrateResourceResponses: Successfully migrated resources.
	MigrateResourceResponses []*GoogleCloudAiplatformV1MigrateResourceResponse `json:"migrateResourceResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrateResourceResponses")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrateResourceResponses") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchMigrateResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchMigrateResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJob: A job that uses a Model to
// produce predictions on multiple input instances. If predictions for
// significant portion of the instances fail, the job may finish without
// attempting predictions for all remaining instances.
type GoogleCloudAiplatformV1BatchPredictionJob struct {
	// CompletionStats: Output only. Statistics on completed and failed prediction
	// instances.
	CompletionStats *GoogleCloudAiplatformV1CompletionStats `json:"completionStats,omitempty"`
	// CreateTime: Output only. Time when the BatchPredictionJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: The config of resources used by the Model during the
	// batch prediction. If the Model supports DEDICATED_RESOURCES this config may
	// be provided (and the job will use these resources), if the Model doesn't
	// support AUTOMATIC_RESOURCES, this config must be provided.
	DedicatedResources *GoogleCloudAiplatformV1BatchDedicatedResources `json:"dedicatedResources,omitempty"`
	// DisableContainerLogging: For custom-trained Models and AutoML Tabular
	// Models, the container of the DeployedModel instances will send `stderr` and
	// `stdout` streams to Cloud Logging by default. Please note that the logs
	// incur cost, which are subject to Cloud Logging pricing
	// (https://cloud.google.com/logging/pricing). User can disable container
	// logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`
	// DisplayName: Required. The user-defined name of this BatchPredictionJob.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key options for a
	// BatchPredictionJob. If this is set, then all resources created by the
	// BatchPredictionJob will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// EndTime: Output only. Time when the BatchPredictionJob entered any of the
	// following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. Only populated when the job's state is JOB_STATE_FAILED
	// or JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// ExplanationSpec: Explanation configuration for this BatchPredictionJob. Can
	// be specified only if generate_explanation is set to `true`. This value
	// overrides the value of Model.explanation_spec. All fields of
	// explanation_spec are optional in the request. If a field of the
	// explanation_spec object is not populated, the corresponding field of the
	// Model.explanation_spec object is inherited.
	ExplanationSpec *GoogleCloudAiplatformV1ExplanationSpec `json:"explanationSpec,omitempty"`
	// GenerateExplanation: Generate explanation with the batch prediction results.
	// When set to `true`, the batch prediction output changes based on the
	// `predictions_format` field of the BatchPredictionJob.output_config object: *
	// `bigquery`: output includes a column named `explanation`. The value is a
	// struct that conforms to the Explanation object. * `jsonl`: The JSON objects
	// on each line include an additional entry keyed `explanation`. The value of
	// the entry is a JSON object that conforms to the Explanation object. * `csv`:
	// Generating explanations for CSV format is not supported. If this field is
	// set to true, either the Model.explanation_spec or explanation_spec must be
	// populated.
	GenerateExplanation bool `json:"generateExplanation,omitempty"`
	// InputConfig: Required. Input configuration of the instances on which
	// predictions are performed. The schema of any single instance may be
	// specified via the Model's PredictSchemata's instance_schema_uri.
	InputConfig *GoogleCloudAiplatformV1BatchPredictionJobInputConfig `json:"inputConfig,omitempty"`
	// InstanceConfig: Configuration for how to convert batch prediction input
	// instances to the prediction instances that are sent to the Model.
	InstanceConfig *GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig `json:"instanceConfig,omitempty"`
	// Labels: The labels with user-defined metadata to organize
	// BatchPredictionJobs. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// ManualBatchTuningParameters: Immutable. Parameters configuring the batch
	// behavior. Currently only applicable when dedicated_resources are used (in
	// other cases Vertex AI does the tuning itself).
	ManualBatchTuningParameters *GoogleCloudAiplatformV1ManualBatchTuningParameters `json:"manualBatchTuningParameters,omitempty"`
	// Model: The name of the Model resource that produces the predictions via this
	// job, must share the same ancestor Location. Starting this job has no impact
	// on any existing deployments of the Model and their resources. Exactly one of
	// model, unmanaged_container_model, or endpoint must be set. The model
	// resource name may contain version id or version alias to specify the
	// version. Example: `projects/{project}/locations/{location}/models/{model}@2`
	// or `projects/{project}/locations/{location}/models/{model}@golden` if no
	// version is specified, the default version will be deployed. The model
	// resource could also be a publisher model. Example:
	// `publishers/{publisher}/models/{model}` or
	// `projects/{project}/locations/{location}/publishers/{publisher}/models/{model
	// }`
	Model string `json:"model,omitempty"`
	// ModelParameters: The parameters that govern the predictions. The schema of
	// the parameters may be specified via the Model's PredictSchemata's
	// parameters_schema_uri.
	ModelParameters interface{} `json:"modelParameters,omitempty"`
	// ModelVersionId: Output only. The version ID of the Model that produces the
	// predictions via this job.
	ModelVersionId string `json:"modelVersionId,omitempty"`
	// Name: Output only. Resource name of the BatchPredictionJob.
	Name string `json:"name,omitempty"`
	// OutputConfig: Required. The Configuration specifying where output
	// predictions should be written. The schema of any single prediction may be
	// specified as a concatenation of Model's PredictSchemata's
	// instance_schema_uri and prediction_schema_uri.
	OutputConfig *GoogleCloudAiplatformV1BatchPredictionJobOutputConfig `json:"outputConfig,omitempty"`
	// OutputInfo: Output only. Information further describing the output of this
	// job.
	OutputInfo *GoogleCloudAiplatformV1BatchPredictionJobOutputInfo `json:"outputInfo,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. For example,
	// single files that can't be read. This field never exceeds 20 entries. Status
	// details fields contain standard Google Cloud error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ResourcesConsumed: Output only. Information about resources that had been
	// consumed by this job. Provided in real time at best effort basis, as well as
	// a final value once the job completes. Note: This field currently may be not
	// populated for batch predictions that use AutoML Models.
	ResourcesConsumed *GoogleCloudAiplatformV1ResourcesConsumed `json:"resourcesConsumed,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceAccount: The service account that the DeployedModel's container runs
	// as. If not specified, a system generated one will be used, which has minimal
	// permissions and the custom container, if used, may not have enough
	// permission to access other Google Cloud resources. Users deploying the Model
	// must have the `iam.serviceAccounts.actAs` permission on this service
	// account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// StartTime: Output only. Time when the BatchPredictionJob for the first time
	// entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// UnmanagedContainerModel: Contains model information necessary to perform
	// batch prediction without requiring uploading to model registry. Exactly one
	// of model, unmanaged_container_model, or endpoint must be set.
	UnmanagedContainerModel *GoogleCloudAiplatformV1UnmanagedContainerModel `json:"unmanagedContainerModel,omitempty"`
	// UpdateTime: Output only. Time when the BatchPredictionJob was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompletionStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchPredictionJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobInputConfig: Configures the input
// to BatchPredictionJob. See Model.supported_input_storage_formats for Model's
// supported input formats, and how instances should be expressed via any of
// them.
type GoogleCloudAiplatformV1BatchPredictionJobInputConfig struct {
	// BigquerySource: The BigQuery location of the input table. The schema of the
	// table should be in the format described by the given context OpenAPI Schema,
	// if one is provided. The table may contain additional columns that are not
	// described by the schema, and they will be ignored.
	BigquerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigquerySource,omitempty"`
	// GcsSource: The Cloud Storage location for the input instances.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// InstancesFormat: Required. The format in which instances are given, must be
	// one of the Model's supported_input_storage_formats.
	InstancesFormat string `json:"instancesFormat,omitempty"`
	// VertexMultimodalDatasetSource: A Vertex Managed Dataset. Currently, only
	// datasets of type Multimodal are supported.
	VertexMultimodalDatasetSource *GoogleCloudAiplatformV1VertexMultimodalDatasetSource `json:"vertexMultimodalDatasetSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchPredictionJobInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig: Configuration
// defining how to transform batch prediction input instances to the instances
// that the Model accepts.
type GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig struct {
	// ExcludedFields: Fields that will be excluded in the prediction instance that
	// is sent to the Model. Excluded will be attached to the batch prediction
	// output if key_field is not specified. When excluded_fields is populated,
	// included_fields must be empty. The input must be JSONL with objects at each
	// line, BigQuery or TfRecord.
	ExcludedFields []string `json:"excludedFields,omitempty"`
	// IncludedFields: Fields that will be included in the prediction instance that
	// is sent to the Model. If instance_type is `array`, the order of field names
	// in included_fields also determines the order of the values in the array.
	// When included_fields is populated, excluded_fields must be empty. The input
	// must be JSONL with objects at each line, BigQuery or TfRecord.
	IncludedFields []string `json:"includedFields,omitempty"`
	// InstanceType: The format of the instance that the Model accepts. Vertex AI
	// will convert compatible batch prediction input instance formats to the
	// specified format. Supported values are: * `object`: Each input is converted
	// to JSON object format. * For `bigquery`, each row is converted to an object.
	// * For `jsonl`, each line of the JSONL input must be an object. * Does not
	// apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. * `array`:
	// Each input is converted to JSON array format. * For `bigquery`, each row is
	// converted to an array. The order of columns is determined by the BigQuery
	// column order, unless included_fields is populated. included_fields must be
	// populated for specifying field orders. * For `jsonl`, if each line of the
	// JSONL input is an object, included_fields must be populated for specifying
	// field orders. * Does not apply to `csv`, `file-list`, `tf-record`, or
	// `tf-record-gzip`. If not specified, Vertex AI converts the batch prediction
	// input as follows: * For `bigquery` and `csv`, the behavior is the same as
	// `array`. The order of columns is the same as defined in the file or table,
	// unless included_fields is populated. * For `jsonl`, the prediction instance
	// format is determined by each line of the input. * For
	// `tf-record`/`tf-record-gzip`, each record will be converted to an object in
	// the format of `{"b64": }`, where `` is the Base64-encoded string of the
	// content of the record. * For `file-list`, each file in the list will be
	// converted to an object in the format of `{"b64": }`, where `` is the
	// Base64-encoded string of the content of the file.
	InstanceType string `json:"instanceType,omitempty"`
	// KeyField: The name of the field that is considered as a key. The values
	// identified by the key field is not included in the transformed instances
	// that is sent to the Model. This is similar to specifying this name of the
	// field in excluded_fields. In addition, the batch prediction output will not
	// include the instances. Instead the output will only include the value of the
	// key field, in a field named `key` in the output: * For `jsonl` output
	// format, the output will have a `key` field instead of the `instance` field.
	// * For `csv`/`bigquery` output format, the output will have have a `key`
	// column instead of the instance feature columns. The input must be JSONL with
	// objects at each line, CSV, BigQuery or TfRecord.
	KeyField string `json:"keyField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedFields") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobOutputConfig: Configures the output
// of BatchPredictionJob. See Model.supported_output_storage_formats for
// supported output formats, and how predictions are expressed via any of them.
type GoogleCloudAiplatformV1BatchPredictionJobOutputConfig struct {
	// BigqueryDestination: The BigQuery project or dataset location where the
	// output is to be written to. If project is provided, a new dataset is created
	// with name `prediction__` where is made BigQuery-dataset-name compatible (for
	// example, most special characters become underscores), and timestamp is in
	// YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset two
	// tables will be created, `predictions`, and `errors`. If the Model has both
	// instance and prediction schemata defined then the tables have columns as
	// follows: The `predictions` table contains instances for which the prediction
	// succeeded, it has columns as per a concatenation of the Model's instance and
	// prediction schemata. The `errors` table contains rows for which the
	// prediction has failed, it has instance columns, as per the instance schema,
	// followed by a single "errors" column, which as values has google.rpc.Status
	// represented as a STRUCT, and containing only `code` and `message`.
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Cloud Storage location of the directory where the output
	// is to be written to. In the given directory a new directory is created. Its
	// name is `prediction--`, where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
	// ISO-8601 format. Inside of it files `predictions_0001.`,
	// `predictions_0002.`, ..., `predictions_N.` are created where `` depends on
	// chosen predictions_format, and N may equal 0001 and depends on the total
	// number of successfully predicted instances. If the Model has both instance
	// and prediction schemata defined then each such file contains predictions as
	// per the predictions_format. If prediction for any instance failed (partially
	// or completely), then an additional `errors_0001.`, `errors_0002.`,...,
	// `errors_N.` files are created (N depends on total number of failed
	// predictions). These files contain the failed instances, as per their schema,
	// followed by an additional `error` field which as value has google.rpc.Status
	// containing only `code` and `message` fields.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`
	// PredictionsFormat: Required. The format in which Vertex AI gives the
	// predictions, must be one of the Model's supported_output_storage_formats.
	PredictionsFormat string `json:"predictionsFormat,omitempty"`
	// VertexMultimodalDatasetDestination: The details for a Vertex Multimodal
	// Dataset that will be created for the output.
	VertexMultimodalDatasetDestination *GoogleCloudAiplatformV1VertexMultimodalDatasetDestination `json:"vertexMultimodalDatasetDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchPredictionJobOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchPredictionJobOutputInfo: Further describes this
// job's output. Supplements output_config.
type GoogleCloudAiplatformV1BatchPredictionJobOutputInfo struct {
	// BigqueryOutputDataset: Output only. The path of the BigQuery dataset
	// created, in `bq://projectId.bqDatasetId` format, into which the prediction
	// output is written.
	BigqueryOutputDataset string `json:"bigqueryOutputDataset,omitempty"`
	// BigqueryOutputTable: Output only. The name of the BigQuery table created, in
	// `predictions_` format, into which the prediction output is written. Can be
	// used by UI to generate the BigQuery output path, for example.
	BigqueryOutputTable string `json:"bigqueryOutputTable,omitempty"`
	// GcsOutputDirectory: Output only. The full path of the Cloud Storage
	// directory created, into which the prediction output is written.
	GcsOutputDirectory string `json:"gcsOutputDirectory,omitempty"`
	// VertexMultimodalDatasetName: Output only. The resource name of the Vertex
	// Managed Dataset created, into which the prediction output is written.
	// Format: `projects/{project}/locations/{location}/datasets/{dataset}`
	VertexMultimodalDatasetName string `json:"vertexMultimodalDatasetName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryOutputDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryOutputDataset") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchPredictionJobOutputInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchPredictionJobOutputInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata: Details of
// operations that batch reads Feature values.
type GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore batch read Features
	// values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesRequest: Request message for
// FeaturestoreService.BatchReadFeatureValues.
type GoogleCloudAiplatformV1BatchReadFeatureValuesRequest struct {
	// BigqueryReadInstances: Similar to csv_read_instances, but from BigQuery
	// source.
	BigqueryReadInstances *GoogleCloudAiplatformV1BigQuerySource `json:"bigqueryReadInstances,omitempty"`
	// CsvReadInstances: Each read instance consists of exactly one read timestamp
	// and one or more entity IDs identifying entities of the corresponding
	// EntityTypes whose Features are requested. Each output instance contains
	// Feature values of requested entities concatenated together as of the read
	// time. An example read instance may be `foo_entity_id, bar_entity_id,
	// 2020-01-01T10:00:00.123Z`. An example output instance may be `foo_entity_id,
	// bar_entity_id, 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
	// bar_entity_feature2_value`. Timestamp in each read instance must be
	// millisecond-aligned. `csv_read_instances` are read instances stored in a
	// plain-text CSV file. The header should be: [ENTITY_TYPE_ID1],
	// [ENTITY_TYPE_ID2], ..., timestamp The columns can be in any order. Values in
	// the timestamp column must use the RFC 3339 format, e.g.
	// `2012-07-30T10:43:17.123Z`.
	CsvReadInstances *GoogleCloudAiplatformV1CsvSource `json:"csvReadInstances,omitempty"`
	// Destination: Required. Specifies output location and format.
	Destination *GoogleCloudAiplatformV1FeatureValueDestination `json:"destination,omitempty"`
	// EntityTypeSpecs: Required. Specifies EntityType grouping Features to read
	// values of and settings.
	EntityTypeSpecs []*GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec `json:"entityTypeSpecs,omitempty"`
	// PassThroughFields: When not empty, the specified fields in the
	// *_read_instances source will be joined as-is in the output, in addition to
	// those fields from the Featurestore Entity. For BigQuery source, the type of
	// the pass-through values will be automatically inferred. For CSV source, the
	// pass-through values will be passed as opaque bytes.
	PassThroughFields []*GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField `json:"passThroughFields,omitempty"`
	// StartTime: Optional. Excludes Feature values with feature generation
	// timestamp before this timestamp. If not set, retrieve oldest values kept in
	// Feature Store. Timestamp, if present, must not have higher than millisecond
	// precision.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryReadInstances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryReadInstances") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchReadFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec: Selects
// Features of an EntityType to read values of and specifies read settings.
type GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec struct {
	// EntityTypeId: Required. ID of the EntityType to select Features. The
	// EntityType id is the entity_type_id specified during EntityType creation.
	EntityTypeId string `json:"entityTypeId,omitempty"`
	// FeatureSelector: Required. Selectors choosing which Feature values to read
	// from the EntityType.
	FeatureSelector *GoogleCloudAiplatformV1FeatureSelector `json:"featureSelector,omitempty"`
	// Settings: Per-Feature settings for the batch read.
	Settings []*GoogleCloudAiplatformV1DestinationFeatureSetting `json:"settings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypeId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypeId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesRequestEntityTypeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField:
// Describe pass-through fields in read_instance source.
type GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField struct {
	// FieldName: Required. The name of the field in the CSV header or the name of
	// the column in BigQuery table. The naming restriction is the same as
	// Feature.name.
	FieldName string `json:"fieldName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadFeatureValuesRequestPassThroughField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BatchReadFeatureValuesResponse: Response message for
// FeaturestoreService.BatchReadFeatureValues.
type GoogleCloudAiplatformV1BatchReadFeatureValuesResponse struct {
}

// GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse: Response
// message for TensorboardService.BatchReadTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse struct {
	// TimeSeriesData: The returned time series data.
	TimeSeriesData []*GoogleCloudAiplatformV1TimeSeriesData `json:"timeSeriesData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TimeSeriesData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimeSeriesData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BatchReadTensorboardTimeSeriesDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BigQueryDestination: The BigQuery location for the
// output content.
type GoogleCloudAiplatformV1BigQueryDestination struct {
	// OutputUri: Required. BigQuery URI to a project or table, up to 2000
	// characters long. When only the project is specified, the Dataset and Table
	// is created. When the full table reference is specified, the Dataset must
	// exist and table must not exist. Accepted forms: * BigQuery path. For
	// example: `bq://projectId` or `bq://projectId.bqDatasetId` or
	// `bq://projectId.bqDatasetId.bqTableId`.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BigQueryRequestSet: The request set for the
// evaluation run.
type GoogleCloudAiplatformV1BigQueryRequestSet struct {
	// CandidateResponseColumns: Optional. Map of candidate name to candidate
	// response column name. The column will be in
	// evaluation_item.CandidateResponse format.
	CandidateResponseColumns map[string]string `json:"candidateResponseColumns,omitempty"`
	// PromptColumn: Optional. The name of the column that contains the requests to
	// evaluate. This will be in evaluation_item.EvalPrompt format.
	PromptColumn string `json:"promptColumn,omitempty"`
	// RubricsColumn: Optional. The name of the column that contains the rubrics.
	// This is in evaluation_rubric.RubricGroup format.
	RubricsColumn string `json:"rubricsColumn,omitempty"`
	// SamplingConfig: Optional. The sampling config for the bigquery resource.
	SamplingConfig *GoogleCloudAiplatformV1BigQueryRequestSetSamplingConfig `json:"samplingConfig,omitempty"`
	// Uri: Required. The URI of a BigQuery table. e.g.
	// bq://projectId.bqDatasetId.bqTableId
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateResponseColumns")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateResponseColumns") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BigQueryRequestSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BigQueryRequestSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BigQueryRequestSetSamplingConfig: The sampling
// config.
type GoogleCloudAiplatformV1BigQueryRequestSetSamplingConfig struct {
	// SamplingCount: Optional. The total number of logged data to import. If
	// available data is less than the sampling count, all data will be imported.
	// Default is 100.
	SamplingCount int64 `json:"samplingCount,omitempty"`
	// SamplingDuration: Optional. How long to wait before sampling data from the
	// BigQuery table. If not specified, defaults to 0.
	SamplingDuration string `json:"samplingDuration,omitempty"`
	// SamplingMethod: Optional. The sampling method to use.
	//
	// Possible values:
	//   "SAMPLING_METHOD_UNSPECIFIED" - Unspecified sampling method.
	//   "RANDOM" - Random sampling.
	SamplingMethod string `json:"samplingMethod,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SamplingCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SamplingCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BigQueryRequestSetSamplingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BigQueryRequestSetSamplingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BigQuerySource: The BigQuery location for the input
// content.
type GoogleCloudAiplatformV1BigQuerySource struct {
	// InputUri: Required. BigQuery URI to a table, up to 2000 characters long.
	// Accepted forms: * BigQuery path. For example:
	// `bq://projectId.bqDatasetId.bqTableId`.
	InputUri string `json:"inputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BleuInput: Input for bleu metric.
type GoogleCloudAiplatformV1BleuInput struct {
	// Instances: Required. Repeated bleu instances.
	Instances []*GoogleCloudAiplatformV1BleuInstance `json:"instances,omitempty"`
	// MetricSpec: Required. Spec for bleu score metric.
	MetricSpec *GoogleCloudAiplatformV1BleuSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BleuInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BleuInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BleuInstance: Spec for bleu instance.
type GoogleCloudAiplatformV1BleuInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// Reference: Required. Ground truth used to compare against the prediction.
	Reference string `json:"reference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BleuInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BleuInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BleuMetricValue: Bleu metric value for an instance.
type GoogleCloudAiplatformV1BleuMetricValue struct {
	// Score: Output only. Bleu score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BleuMetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BleuMetricValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1BleuMetricValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1BleuMetricValue
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1BleuResults: Results for bleu metric.
type GoogleCloudAiplatformV1BleuResults struct {
	// BleuMetricValues: Output only. Bleu metric values.
	BleuMetricValues []*GoogleCloudAiplatformV1BleuMetricValue `json:"bleuMetricValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BleuMetricValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BleuMetricValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BleuResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BleuResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BleuSpec: Spec for bleu score metric - calculates the
// precision of n-grams in the prediction as compared to reference - returns a
// score ranging between 0 to 1.
type GoogleCloudAiplatformV1BleuSpec struct {
	// UseEffectiveOrder: Optional. Whether to use_effective_order to compute bleu
	// score.
	UseEffectiveOrder bool `json:"useEffectiveOrder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UseEffectiveOrder") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UseEffectiveOrder") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BleuSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BleuSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Blob: A content blob. A Blob contains data of a
// specific media type. It is used to represent images, audio, and video.
type GoogleCloudAiplatformV1Blob struct {
	// Data: Required. The raw bytes of the data.
	Data string `json:"data,omitempty"`
	// DisplayName: Optional. The display name of the blob. Used to provide a label
	// or filename to distinguish blobs. This field is only returned in
	// `PromptMessage` for prompt management. It is used in the Gemini calls only
	// when server-side tools (`code_execution`, `google_search`, and
	// `url_context`) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Blob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Blob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1BlurBaselineConfig: Config for blur baseline. When
// enabled, a linear path from the maximally blurred image to the input image
// is created. Using a blurred baseline instead of zero (black image) is
// motivated by the BlurIG approach explained here:
// https://arxiv.org/abs/2004.03383
type GoogleCloudAiplatformV1BlurBaselineConfig struct {
	// MaxBlurSigma: The standard deviation of the blur kernel for the blurred
	// baseline. The same blurring parameter is used for both the height and the
	// width dimension. If not set, the method defaults to the zero (i.e. black for
	// images) baseline.
	MaxBlurSigma float64 `json:"maxBlurSigma,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxBlurSigma") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxBlurSigma") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BlurBaselineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BlurBaselineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1BlurBaselineConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1BlurBaselineConfig
	var s1 struct {
		MaxBlurSigma gensupport.JSONFloat64 `json:"maxBlurSigma"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxBlurSigma = float64(s1.MaxBlurSigma)
	return nil
}

// GoogleCloudAiplatformV1BoolArray: A list of boolean values.
type GoogleCloudAiplatformV1BoolArray struct {
	// Values: A list of bool values.
	Values []bool `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1BoolArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1BoolArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CacheConfig: Config of GenAI caching features. This
// is a singleton resource.
type GoogleCloudAiplatformV1CacheConfig struct {
	// DisableCache: If set to true, disables GenAI caching. Otherwise caching is
	// enabled.
	DisableCache bool `json:"disableCache,omitempty"`
	// Name: Identifier. Name of the cache config. Format: -
	// `projects/{project}/cacheConfig`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisableCache") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableCache") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CacheConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CacheConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CachedContent: A resource used in LLM queries for
// users to explicitly specify what to cache and how to cache.
type GoogleCloudAiplatformV1CachedContent struct {
	// Contents: Optional. Input only. Immutable. The content to cache
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// CreateTime: Output only. Creation time of the cache entry.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. Immutable. The user-generated meaningful display name
	// of the cached content.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Input only. Immutable. Customer-managed encryption key spec
	// for a `CachedContent`. If set, this `CachedContent` and all its
	// sub-resources will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ExpireTime: Timestamp of when this resource is considered expired. This is
	// *always* provided on output, regardless of what was sent on input.
	ExpireTime string `json:"expireTime,omitempty"`
	// Model: Immutable. The name of the `Model` to use for cached content.
	// Currently, only the published Gemini base models are supported, in form of
	// projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}
	Model string `json:"model,omitempty"`
	// Name: Immutable. Identifier. The server-generated resource name of the
	// cached content Format:
	// projects/{project}/locations/{location}/cachedContents/{cached_content}
	Name string `json:"name,omitempty"`
	// SystemInstruction: Optional. Input only. Immutable. Developer set system
	// instruction. Currently, text only
	SystemInstruction *GoogleCloudAiplatformV1Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Input only. Immutable. Tool config. This config is
	// shared for all tools
	ToolConfig *GoogleCloudAiplatformV1ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. Input only. Immutable. A list of `Tools` the model may use
	// to generate the next response
	Tools []*GoogleCloudAiplatformV1Tool `json:"tools,omitempty"`
	// Ttl: Input only. The TTL for this resource. The expiration time is computed:
	// now + TTL.
	Ttl string `json:"ttl,omitempty"`
	// UpdateTime: Output only. When the cache entry was last updated in UTC time.
	UpdateTime string `json:"updateTime,omitempty"`
	// UsageMetadata: Output only. Metadata on the usage of the cached content.
	UsageMetadata *GoogleCloudAiplatformV1CachedContentUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CachedContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CachedContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CachedContentUsageMetadata: Metadata on the usage of
// the cached content.
type GoogleCloudAiplatformV1CachedContentUsageMetadata struct {
	// AudioDurationSeconds: Duration of audio in seconds.
	AudioDurationSeconds int64 `json:"audioDurationSeconds,omitempty"`
	// ImageCount: Number of images.
	ImageCount int64 `json:"imageCount,omitempty"`
	// TextCount: Number of text characters.
	TextCount int64 `json:"textCount,omitempty"`
	// TotalTokenCount: Total number of tokens that the cached content consumes.
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// VideoDurationSeconds: Duration of video in seconds.
	VideoDurationSeconds int64 `json:"videoDurationSeconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioDurationSeconds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioDurationSeconds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CachedContentUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CachedContentUsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CancelBatchPredictionJobRequest: Request message for
// JobService.CancelBatchPredictionJob.
type GoogleCloudAiplatformV1CancelBatchPredictionJobRequest struct {
}

// GoogleCloudAiplatformV1CancelCustomJobRequest: Request message for
// JobService.CancelCustomJob.
type GoogleCloudAiplatformV1CancelCustomJobRequest struct {
}

// GoogleCloudAiplatformV1CancelDataLabelingJobRequest: Request message for
// JobService.CancelDataLabelingJob.
type GoogleCloudAiplatformV1CancelDataLabelingJobRequest struct {
}

// GoogleCloudAiplatformV1CancelEvaluationRunRequest: Request message for
// EvaluationManagementService.CancelEvaluationRun.
type GoogleCloudAiplatformV1CancelEvaluationRunRequest struct {
}

// GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest: Request message
// for JobService.CancelHyperparameterTuningJob.
type GoogleCloudAiplatformV1CancelHyperparameterTuningJobRequest struct {
}

// GoogleCloudAiplatformV1CancelNasJobRequest: Request message for
// JobService.CancelNasJob.
type GoogleCloudAiplatformV1CancelNasJobRequest struct {
}

// GoogleCloudAiplatformV1CancelPipelineJobRequest: Request message for
// PipelineService.CancelPipelineJob.
type GoogleCloudAiplatformV1CancelPipelineJobRequest struct {
}

// GoogleCloudAiplatformV1CancelTrainingPipelineRequest: Request message for
// PipelineService.CancelTrainingPipeline.
type GoogleCloudAiplatformV1CancelTrainingPipelineRequest struct {
}

// GoogleCloudAiplatformV1CancelTuningJobRequest: Request message for
// GenAiTuningService.CancelTuningJob.
type GoogleCloudAiplatformV1CancelTuningJobRequest struct {
}

// GoogleCloudAiplatformV1Candidate: A response candidate generated from the
// model.
type GoogleCloudAiplatformV1Candidate struct {
	// AvgLogprobs: Output only. The average log probability of the tokens in this
	// candidate. This is a length-normalized score that can be used to compare the
	// quality of candidates of different lengths. A higher average log probability
	// suggests a more confident and coherent response.
	AvgLogprobs float64 `json:"avgLogprobs,omitempty"`
	// CitationMetadata: Output only. A collection of citations that apply to the
	// generated content.
	CitationMetadata *GoogleCloudAiplatformV1CitationMetadata `json:"citationMetadata,omitempty"`
	// Content: Output only. The content of the candidate.
	Content *GoogleCloudAiplatformV1Content `json:"content,omitempty"`
	// FinishMessage: Output only. Describes the reason the model stopped
	// generating tokens in more detail. This field is returned only when
	// `finish_reason` is set.
	FinishMessage string `json:"finishMessage,omitempty"`
	// FinishReason: Output only. The reason why the model stopped generating
	// tokens. If empty, the model has not stopped generating.
	//
	// Possible values:
	//   "FINISH_REASON_UNSPECIFIED" - The finish reason is unspecified.
	//   "STOP" - The model reached a natural stopping point or a configured stop
	// sequence.
	//   "MAX_TOKENS" - The model generated the maximum number of tokens allowed by
	// the `max_output_tokens` parameter.
	//   "SAFETY" - The model stopped generating because the content potentially
	// violates safety policies. NOTE: When streaming, the `content` field is empty
	// if content filters block the output.
	//   "RECITATION" - The model stopped generating because the content may be a
	// recitation from a source.
	//   "OTHER" - The model stopped generating for a reason not otherwise
	// specified.
	//   "BLOCKLIST" - The model stopped generating because the content contains a
	// term from a configured blocklist.
	//   "PROHIBITED_CONTENT" - The model stopped generating because the content
	// may be prohibited.
	//   "SPII" - The model stopped generating because the content may contain
	// sensitive personally identifiable information (SPII).
	//   "MALFORMED_FUNCTION_CALL" - The model generated a function call that is
	// syntactically invalid and can't be parsed.
	//   "MODEL_ARMOR" - The model response was blocked by Model Armor.
	//   "IMAGE_SAFETY" - The generated image potentially violates safety policies.
	//   "IMAGE_PROHIBITED_CONTENT" - The generated image may contain prohibited
	// content.
	//   "IMAGE_RECITATION" - The generated image may be a recitation from a
	// source.
	//   "IMAGE_OTHER" - The image generation stopped for a reason not otherwise
	// specified.
	//   "UNEXPECTED_TOOL_CALL" - The model generated a function call that is
	// semantically invalid. This can happen, for example, if function calling is
	// not enabled or the generated function is not in the function declaration.
	//   "NO_IMAGE" - The model was expected to generate an image, but didn't.
	FinishReason string `json:"finishReason,omitempty"`
	// GroundingMetadata: Output only. Metadata returned when grounding is enabled.
	// It contains the sources used to ground the generated content.
	GroundingMetadata *GoogleCloudAiplatformV1GroundingMetadata `json:"groundingMetadata,omitempty"`
	// Index: Output only. The 0-based index of this candidate in the list of
	// generated responses. This is useful for distinguishing between multiple
	// candidates when `candidate_count` > 1.
	Index int64 `json:"index,omitempty"`
	// LogprobsResult: Output only. The detailed log probability information for
	// the tokens in this candidate. This is useful for debugging, understanding
	// model uncertainty, and identifying potential "hallucinations".
	LogprobsResult *GoogleCloudAiplatformV1LogprobsResult `json:"logprobsResult,omitempty"`
	// SafetyRatings: Output only. A list of ratings for the safety of a response
	// candidate. There is at most one rating per category.
	SafetyRatings []*GoogleCloudAiplatformV1SafetyRating `json:"safetyRatings,omitempty"`
	// UrlContextMetadata: Output only. Metadata returned when the model uses the
	// `url_context` tool to get information from a user-provided URL.
	UrlContextMetadata *GoogleCloudAiplatformV1UrlContextMetadata `json:"urlContextMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvgLogprobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvgLogprobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Candidate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Candidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1Candidate) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1Candidate
	var s1 struct {
		AvgLogprobs gensupport.JSONFloat64 `json:"avgLogprobs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AvgLogprobs = float64(s1.AvgLogprobs)
	return nil
}

// GoogleCloudAiplatformV1CandidateResponse: Responses from model or agent.
type GoogleCloudAiplatformV1CandidateResponse struct {
	// Candidate: Required. The name of the candidate that produced the response.
	Candidate string `json:"candidate,omitempty"`
	// Text: Text response.
	Text string `json:"text,omitempty"`
	// Value: Fields and values that can be used to populate the response template.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CandidateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CandidateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CandidateResult: Result for a single candidate.
type GoogleCloudAiplatformV1CandidateResult struct {
	// AdditionalResults: Optional. Additional results for the metric.
	AdditionalResults interface{} `json:"additionalResults,omitempty"`
	// Candidate: Required. The candidate that is being evaluated. The value is the
	// same as the candidate name in the EvaluationRequest.
	Candidate string `json:"candidate,omitempty"`
	// Explanation: Optional. The explanation for the metric.
	Explanation string `json:"explanation,omitempty"`
	// Metric: Required. The metric that was evaluated.
	Metric string `json:"metric,omitempty"`
	// RubricVerdicts: Optional. The rubric verdicts for the metric.
	RubricVerdicts []*GoogleCloudAiplatformV1RubricVerdict `json:"rubricVerdicts,omitempty"`
	// Score: Optional. The score for the metric.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CandidateResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CandidateResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1CandidateResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1CandidateResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata: This message
// will be placed in the metadata field of a google.longrunning.Operation
// associated with a CheckTrialEarlyStoppingState request.
type GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata struct {
	// GenericMetadata: Operation metadata for suggesting Trials.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// Study: The name of the Study that the Trial belongs to.
	Study string `json:"study,omitempty"`
	// Trial: The Trial name.
	Trial string `json:"trial,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateMetatdata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest: Request message
// for VizierService.CheckTrialEarlyStoppingState.
type GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateRequest struct {
}

// GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse: Response
// message for VizierService.CheckTrialEarlyStoppingState.
type GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse struct {
	// ShouldStop: True if the Trial should stop.
	ShouldStop bool `json:"shouldStop,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ShouldStop") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShouldStop") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CheckTrialEarlyStoppingStateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Checkpoint: Describes the machine learning model
// version checkpoint.
type GoogleCloudAiplatformV1Checkpoint struct {
	// CheckpointId: The ID of the checkpoint.
	CheckpointId string `json:"checkpointId,omitempty"`
	// Epoch: The epoch of the checkpoint.
	Epoch int64 `json:"epoch,omitempty,string"`
	// Step: The step of the checkpoint.
	Step int64 `json:"step,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CheckpointId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckpointId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Checkpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Checkpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Chunk: Container for bytes-encoded data such as video
// frame, audio sample, or a complete binary/text data.
type GoogleCloudAiplatformV1Chunk struct {
	// Data: Required. The data in the chunk.
	Data string `json:"data,omitempty"`
	// Metadata: Optional. Metadata that is associated with the data in the
	// payload.
	Metadata *GoogleCloudAiplatformV1Metadata `json:"metadata,omitempty"`
	// MimeType: Required. Mime type of the chunk data. See
	// https://www.iana.org/assignments/media-types/media-types.xhtml for the full
	// list.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Chunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Chunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Citation: A citation for a piece of generatedcontent.
type GoogleCloudAiplatformV1Citation struct {
	// EndIndex: Output only. The end index of the citation in the content.
	EndIndex int64 `json:"endIndex,omitempty"`
	// License: Output only. The license of the source of the citation.
	License string `json:"license,omitempty"`
	// PublicationDate: Output only. The publication date of the source of the
	// citation.
	PublicationDate *GoogleTypeDate `json:"publicationDate,omitempty"`
	// StartIndex: Output only. The start index of the citation in the content.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Title: Output only. The title of the source of the citation.
	Title string `json:"title,omitempty"`
	// Uri: Output only. The URI of the source of the citation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Citation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Citation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CitationMetadata: A collection of citations that
// apply to a piece of generated content.
type GoogleCloudAiplatformV1CitationMetadata struct {
	// Citations: Output only. A list of citations for the content.
	Citations []*GoogleCloudAiplatformV1Citation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Claim: Claim that is extracted from the input text
// and facts that support it.
type GoogleCloudAiplatformV1Claim struct {
	// EndIndex: Index in the input text where the claim ends (exclusive).
	EndIndex int64 `json:"endIndex,omitempty"`
	// FactIndexes: Indexes of the facts supporting this claim.
	FactIndexes []int64 `json:"factIndexes,omitempty"`
	// Score: Confidence score of this corroboration.
	Score float64 `json:"score,omitempty"`
	// StartIndex: Index in the input text where the claim starts (inclusive).
	StartIndex int64 `json:"startIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Claim) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Claim
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1Claim) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1Claim
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1ClientConnectionConfig: Configurations (e.g.
// inference timeout) that are applied on your endpoints.
type GoogleCloudAiplatformV1ClientConnectionConfig struct {
	// InferenceTimeout: Customizable online prediction request timeout.
	InferenceTimeout string `json:"inferenceTimeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InferenceTimeout") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InferenceTimeout") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ClientConnectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ClientConnectionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CodeExecutionResult: Result of executing the
// [ExecutableCode]. Only generated when using the [CodeExecution] tool, and
// always follows a `part` containing the [ExecutableCode].
type GoogleCloudAiplatformV1CodeExecutionResult struct {
	// Outcome: Required. Outcome of the code execution.
	//
	// Possible values:
	//   "OUTCOME_UNSPECIFIED" - Unspecified status. This value should not be used.
	//   "OUTCOME_OK" - Code execution completed successfully.
	//   "OUTCOME_FAILED" - Code execution finished but with a failure. `stderr`
	// should contain the reason.
	//   "OUTCOME_DEADLINE_EXCEEDED" - Code execution ran for too long, and was
	// cancelled. There may or may not be a partial output present.
	Outcome string `json:"outcome,omitempty"`
	// Output: Optional. Contains stdout when code execution is successful, stderr
	// or other description otherwise.
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Outcome") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outcome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CoherenceInput: Input for coherence metric.
type GoogleCloudAiplatformV1CoherenceInput struct {
	// Instance: Required. Coherence instance.
	Instance *GoogleCloudAiplatformV1CoherenceInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for coherence score metric.
	MetricSpec *GoogleCloudAiplatformV1CoherenceSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CoherenceInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CoherenceInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CoherenceInstance: Spec for coherence instance.
type GoogleCloudAiplatformV1CoherenceInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CoherenceInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CoherenceInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CoherenceResult: Spec for coherence result.
type GoogleCloudAiplatformV1CoherenceResult struct {
	// Confidence: Output only. Confidence for coherence score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for coherence score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Coherence score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CoherenceResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CoherenceResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1CoherenceResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1CoherenceResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1CoherenceSpec: Spec for coherence score metric.
type GoogleCloudAiplatformV1CoherenceSpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CoherenceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CoherenceSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ColabImage: Colab image of the runtime.
type GoogleCloudAiplatformV1ColabImage struct {
	// Description: Output only. A human-readable description of the specified
	// colab image release, populated by the system. Example: "Python 3.10",
	// "Latest - current Python 3.11"
	Description string `json:"description,omitempty"`
	// ReleaseName: Optional. The release name of the NotebookRuntime Colab image,
	// e.g. "py310". If not specified, detault to the latest release.
	ReleaseName string `json:"releaseName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ColabImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ColabImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CometInput: Input for Comet metric.
type GoogleCloudAiplatformV1CometInput struct {
	// Instance: Required. Comet instance.
	Instance *GoogleCloudAiplatformV1CometInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for comet metric.
	MetricSpec *GoogleCloudAiplatformV1CometSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CometInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CometInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CometInstance: Spec for Comet instance - The fields
// used for evaluation are dependent on the comet version.
type GoogleCloudAiplatformV1CometInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// Reference: Optional. Ground truth used to compare against the prediction.
	Reference string `json:"reference,omitempty"`
	// Source: Optional. Source text in original language.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CometInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CometInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CometResult: Spec for Comet result - calculates the
// comet score for the given instance using the version specified in the spec.
type GoogleCloudAiplatformV1CometResult struct {
	// Score: Output only. Comet score. Range depends on version.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CometResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CometResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1CometResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1CometResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1CometSpec: Spec for Comet metric.
type GoogleCloudAiplatformV1CometSpec struct {
	// SourceLanguage: Optional. Source language in BCP-47 format.
	SourceLanguage string `json:"sourceLanguage,omitempty"`
	// TargetLanguage: Optional. Target language in BCP-47 format. Covers both
	// prediction and reference.
	TargetLanguage string `json:"targetLanguage,omitempty"`
	// Version: Required. Which version to use for evaluation.
	//
	// Possible values:
	//   "COMET_VERSION_UNSPECIFIED" - Comet version unspecified.
	//   "COMET_22_SRC_REF" - Comet 22 for translation + source + reference
	// (source-reference-combined).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CometSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CometSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CompleteTrialRequest: Request message for
// VizierService.CompleteTrial.
type GoogleCloudAiplatformV1CompleteTrialRequest struct {
	// FinalMeasurement: Optional. If provided, it will be used as the completed
	// Trial's final_measurement; Otherwise, the service will auto-select a
	// previously reported measurement as the final-measurement
	FinalMeasurement *GoogleCloudAiplatformV1Measurement `json:"finalMeasurement,omitempty"`
	// InfeasibleReason: Optional. A human readable reason why the trial was
	// infeasible. This should only be provided if `trial_infeasible` is true.
	InfeasibleReason string `json:"infeasibleReason,omitempty"`
	// TrialInfeasible: Optional. True if the Trial cannot be run with the given
	// Parameter, and final_measurement will be ignored.
	TrialInfeasible bool `json:"trialInfeasible,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FinalMeasurement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FinalMeasurement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CompleteTrialRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CompleteTrialRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CompletionStats: Success and error statistics of
// processing multiple entities (for example, DataItems or structured data
// rows) in batch.
type GoogleCloudAiplatformV1CompletionStats struct {
	// FailedCount: Output only. The number of entities for which any error was
	// encountered.
	FailedCount int64 `json:"failedCount,omitempty,string"`
	// IncompleteCount: Output only. In cases when enough errors are encountered a
	// job, pipeline, or operation may be failed as a whole. Below is the number of
	// entities for which the processing had not been finished (either in
	// successful or failed state). Set to -1 if the number is unknown (for
	// example, the operation failed before the total entity number could be
	// collected).
	IncompleteCount int64 `json:"incompleteCount,omitempty,string"`
	// SuccessfulCount: Output only. The number of entities that had been processed
	// successfully.
	SuccessfulCount int64 `json:"successfulCount,omitempty,string"`
	// SuccessfulForecastPointCount: Output only. The number of the successful
	// forecast points that are generated by the forecasting model. This is ONLY
	// used by the forecasting batch prediction.
	SuccessfulForecastPointCount int64 `json:"successfulForecastPointCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FailedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CompletionStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CompletionStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ComputeTokensRequest: Request message for
// ComputeTokens RPC call.
type GoogleCloudAiplatformV1ComputeTokensRequest struct {
	// Contents: Optional. Input content.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// Instances: Optional. The instances that are the input to token computing API
	// call. Schema is identical to the prediction schema of the text model, even
	// for the non-text models, like chat models, or Codey models.
	Instances []interface{} `json:"instances,omitempty"`
	// Model: Optional. The name of the publisher model requested to serve the
	// prediction. Format:
	// projects/{project}/locations/{location}/publishers/*/models/*
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ComputeTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ComputeTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ComputeTokensResponse: Response message for
// ComputeTokens RPC call.
type GoogleCloudAiplatformV1ComputeTokensResponse struct {
	// TokensInfo: Lists of tokens info from the input. A ComputeTokensRequest
	// could have multiple instances with a prompt in each instance. We also need
	// to return lists of tokens info for the request with multiple instances.
	TokensInfo []*GoogleCloudAiplatformV1TokensInfo `json:"tokensInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TokensInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TokensInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ComputeTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ComputeTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ContainerRegistryDestination: The Container Registry
// location for the container image.
type GoogleCloudAiplatformV1ContainerRegistryDestination struct {
	// OutputUri: Required. Container Registry URI of a container image. Only
	// Google Container Registry and Artifact Registry are supported now. Accepted
	// forms: * Google Container Registry path. For example:
	// `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example:
	// `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag is
	// not specified, "latest" will be used as the default tag.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ContainerRegistryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ContainerRegistryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ContainerSpec: The spec of a Container.
type GoogleCloudAiplatformV1ContainerSpec struct {
	// Args: The arguments to be passed when starting the container.
	Args []string `json:"args,omitempty"`
	// Command: The command to be invoked when the container is started. It
	// overrides the entrypoint instruction in Dockerfile when provided.
	Command []string `json:"command,omitempty"`
	// Env: Environment variables to be passed to the container. Maximum limit is
	// 100.
	Env []*GoogleCloudAiplatformV1EnvVar `json:"env,omitempty"`
	// ImageUri: Required. The URI of a container image in the Container Registry
	// that is to be run on each worker replica.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ContainerSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ContainerSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Content: The structured data content of a message. A
// Content message contains a `role` field, which indicates the producer of the
// content, and a `parts` field, which contains the multi-part data of the
// message.
type GoogleCloudAiplatformV1Content struct {
	// Parts: Required. A list of Part objects that make up a single message. Parts
	// of a message can have different MIME types. A Content message must have at
	// least one Part.
	Parts []*GoogleCloudAiplatformV1Part `json:"parts,omitempty"`
	// Role: Optional. The producer of the content. Must be either 'user' or
	// 'model'. If not set, the service will default to 'user'.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Content) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Content
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ContentMap: Map of placeholder in metric prompt
// template to contents of model input.
type GoogleCloudAiplatformV1ContentMap struct {
	// Values: Optional. Map of placeholder to contents.
	Values map[string]GoogleCloudAiplatformV1ContentMapContents `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ContentMap) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ContentMap
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ContentMapContents: Repeated Content type.
type GoogleCloudAiplatformV1ContentMapContents struct {
	// Contents: Optional. Repeated contents.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ContentMapContents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ContentMapContents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Context: Instance of a general context.
type GoogleCloudAiplatformV1Context struct {
	// CreateTime: Output only. Timestamp when this Context was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Context
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Context. May be up to 128
	// Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An eTag used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Contexts.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Context (System labels are
	// excluded).
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Properties of the Context. Top level metadata keys' heading and
	// trailing spaces will be trimmed. The size of this field should not exceed
	// 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Immutable. The resource name of the Context.
	Name string `json:"name,omitempty"`
	// ParentContexts: Output only. A list of resource names of Contexts that are
	// parents of this Context. A Context may have at most 10 parent_contexts.
	ParentContexts []string `json:"parentContexts,omitempty"`
	// SchemaTitle: The title of the schema describing the metadata. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaVersion: The version of the schema in schema_name to use. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// UpdateTime: Output only. Timestamp when this Context was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CopyModelOperationMetadata: Details of
// ModelService.CopyModel operation.
type GoogleCloudAiplatformV1CopyModelOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CopyModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CopyModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CopyModelRequest: Request message for
// ModelService.CopyModel.
type GoogleCloudAiplatformV1CopyModelRequest struct {
	// EncryptionSpec: Customer-managed encryption key options. If this is set,
	// then the Model copy will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ModelId: Optional. Copy source_model into a new Model with this ID. The ID
	// will become the final component of the model resource name. This value may
	// be up to 63 characters, and valid characters are `[a-z0-9_-]`. The first
	// character cannot be a number or hyphen.
	ModelId string `json:"modelId,omitempty"`
	// ParentModel: Optional. Specify this field to copy source_model into this
	// existing Model as a new version. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	ParentModel string `json:"parentModel,omitempty"`
	// SourceModel: Required. The resource name of the Model to copy. That Model
	// must be in the same Project. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	SourceModel string `json:"sourceModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CopyModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CopyModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CopyModelResponse: Response message of
// ModelService.CopyModel operation.
type GoogleCloudAiplatformV1CopyModelResponse struct {
	// Model: The name of the copied Model resource. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	Model string `json:"model,omitempty"`
	// ModelVersionId: Output only. The version ID of the model that is copied.
	ModelVersionId string `json:"modelVersionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CopyModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CopyModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CorpusStatus: RagCorpus status.
type GoogleCloudAiplatformV1CorpusStatus struct {
	// ErrorStatus: Output only. Only when the `state` field is ERROR.
	ErrorStatus string `json:"errorStatus,omitempty"`
	// State: Output only. RagCorpus life state.
	//
	// Possible values:
	//   "UNKNOWN" - This state is not supposed to happen.
	//   "INITIALIZED" - RagCorpus resource entry is initialized, but hasn't done
	// validation.
	//   "ACTIVE" - RagCorpus is provisioned successfully and is ready to serve.
	//   "ERROR" - RagCorpus is in a problematic situation. See `error_message`
	// field for details.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CorpusStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CorpusStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CorroborateContentRequest: Request message for
// CorroborateContent.
type GoogleCloudAiplatformV1CorroborateContentRequest struct {
	// Content: Optional. Input content to corroborate, only text format is
	// supported for now.
	Content *GoogleCloudAiplatformV1Content `json:"content,omitempty"`
	// Facts: Optional. Facts used to generate the text can also be used to
	// corroborate the text.
	Facts []*GoogleCloudAiplatformV1Fact `json:"facts,omitempty"`
	// Parameters: Optional. Parameters that can be set to override default
	// settings per request.
	Parameters *GoogleCloudAiplatformV1CorroborateContentRequestParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CorroborateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CorroborateContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CorroborateContentRequestParameters: Parameters that
// can be overrided per request.
type GoogleCloudAiplatformV1CorroborateContentRequestParameters struct {
	// CitationThreshold: Optional. Only return claims with citation score larger
	// than the threshold.
	CitationThreshold float64 `json:"citationThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CorroborateContentRequestParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CorroborateContentRequestParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1CorroborateContentRequestParameters) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1CorroborateContentRequestParameters
	var s1 struct {
		CitationThreshold gensupport.JSONFloat64 `json:"citationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CitationThreshold = float64(s1.CitationThreshold)
	return nil
}

// GoogleCloudAiplatformV1CorroborateContentResponse: Response message for
// CorroborateContent.
type GoogleCloudAiplatformV1CorroborateContentResponse struct {
	// Claims: Claims that are extracted from the input content and facts that
	// support the claims.
	Claims []*GoogleCloudAiplatformV1Claim `json:"claims,omitempty"`
	// CorroborationScore: Confidence score of corroborating content. Value is
	// [0,1] with 1 is the most confidence.
	CorroborationScore float64 `json:"corroborationScore,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Claims") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Claims") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CorroborateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CorroborateContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1CorroborateContentResponse) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1CorroborateContentResponse
	var s1 struct {
		CorroborationScore gensupport.JSONFloat64 `json:"corroborationScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CorroborationScore = float64(s1.CorroborationScore)
	return nil
}

// GoogleCloudAiplatformV1CountTokensRequest: Request message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1CountTokensRequest struct {
	// Contents: Optional. Input content.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config that the model will use to
	// generate the response.
	GenerationConfig *GoogleCloudAiplatformV1GenerationConfig `json:"generationConfig,omitempty"`
	// Instances: Optional. The instances that are the input to token counting
	// call. Schema is identical to the prediction schema of the underlying model.
	Instances []interface{} `json:"instances,omitempty"`
	// Model: Optional. The name of the publisher model requested to serve the
	// prediction. Format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	Model string `json:"model,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1Content `json:"systemInstruction,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CountTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CountTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CountTokensResponse: Response message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1CountTokensResponse struct {
	// PromptTokensDetails: Output only. List of modalities that were processed in
	// the request input.
	PromptTokensDetails []*GoogleCloudAiplatformV1ModalityTokenCount `json:"promptTokensDetails,omitempty"`
	// TotalBillableCharacters: The total number of billable characters counted
	// across all instances from the request.
	TotalBillableCharacters int64 `json:"totalBillableCharacters,omitempty"`
	// TotalTokens: The total number of tokens counted across all instances from
	// the request.
	TotalTokens int64 `json:"totalTokens,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PromptTokensDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTokensDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CountTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CountTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDatasetOperationMetadata: Runtime operation
// information for DatasetService.CreateDataset.
type GoogleCloudAiplatformV1CreateDatasetOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata: Runtime
// operation information for DatasetService.CreateDatasetVersion.
type GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDatasetVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata:
// Runtime operation information for CreateDeploymentResourcePool method.
type GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDeploymentResourcePoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest: Request message
// for CreateDeploymentResourcePool method.
type GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest struct {
	// DeploymentResourcePool: Required. The DeploymentResourcePool to create.
	DeploymentResourcePool *GoogleCloudAiplatformV1DeploymentResourcePool `json:"deploymentResourcePool,omitempty"`
	// DeploymentResourcePoolId: Required. The ID to use for the
	// DeploymentResourcePool, which will become the final component of the
	// DeploymentResourcePool's resource name. The maximum length is 63 characters,
	// and valid characters are `/^a-z ([a-z0-9-]{0,61}[a-z0-9])?$/`.
	DeploymentResourcePoolId string `json:"deploymentResourcePoolId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentResourcePool") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentResourcePool") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateDeploymentResourcePoolRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateEndpointOperationMetadata: Runtime operation
// information for EndpointService.CreateEndpoint.
type GoogleCloudAiplatformV1CreateEndpointOperationMetadata struct {
	// DeploymentStage: Output only. The deployment stage of the model. Only
	// populated if this CreateEndpoint request deploys a model at the same time.
	//
	// Possible values:
	//   "DEPLOYMENT_STAGE_UNSPECIFIED" - Default value. This value is unused.
	//   "STARTING_DEPLOYMENT" - The deployment is initializing and setting up the
	// environment.
	//   "PREPARING_MODEL" - The deployment is preparing the model assets.
	//   "CREATING_SERVING_CLUSTER" - The deployment is creating the underlying
	// serving cluster.
	//   "ADDING_NODES_TO_CLUSTER" - The deployment is adding nodes to the serving
	// cluster.
	//   "GETTING_CONTAINER_IMAGE" - The deployment is getting the container image
	// for the model server.
	//   "STARTING_MODEL_SERVER" - The deployment is starting the model server.
	//   "FINISHING_UP" - The deployment is performing finalization steps.
	//   "DEPLOYMENT_TERMINATED" - The deployment has terminated.
	//   "SUCCESSFULLY_DEPLOYED" - The deployment has succeeded.
	//   "FAILED_TO_DEPLOY" - The deployment has failed.
	DeploymentStage string `json:"deploymentStage,omitempty"`
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentStage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentStage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateEndpointOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateEndpointOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata: Details of
// operations that perform create EntityType.
type GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata struct {
	// GenericMetadata: Operation metadata for EntityType.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateEntityTypeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata: Details of
// operations that perform create FeatureGroup.
type GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureGroup.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureGroupOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata: Details of
// operations that perform create FeatureOnlineStore.
type GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureOnlineStore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureOnlineStoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureOperationMetadata: Details of operations
// that perform create Feature.
type GoogleCloudAiplatformV1CreateFeatureOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateFeatureOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureRequest: Request message for
// FeaturestoreService.CreateFeature. Request message for
// FeatureRegistryService.CreateFeature.
type GoogleCloudAiplatformV1CreateFeatureRequest struct {
	// Feature: Required. The Feature to create.
	Feature *GoogleCloudAiplatformV1Feature `json:"feature,omitempty"`
	// FeatureId: Required. The ID to use for the Feature, which will become the
	// final component of the Feature's resource name. This value may be up to 128
	// characters, and valid characters are `[a-z0-9_]`. The first character cannot
	// be a number. The value must be unique within an EntityType/FeatureGroup.
	FeatureId string `json:"featureId,omitempty"`
	// Parent: Required. The resource name of the EntityType or FeatureGroup to
	// create a Feature. Format for entity_type as parent:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityT
	// ypes/{entity_type}` Format for feature_group as parent:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Feature") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Feature") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateFeatureRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata: Details of
// operations that perform create FeatureView.
type GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureView Create.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeatureViewOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata: Details of
// operations that perform create Featurestore.
type GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateFeaturestoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata: Runtime
// operation information for IndexEndpointService.CreateIndexEndpoint.
type GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateIndexEndpointOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateIndexOperationMetadata: Runtime operation
// information for IndexService.CreateIndex.
type GoogleCloudAiplatformV1CreateIndexOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// NearestNeighborSearchOperationMetadata: The operation metadata with regard
	// to Matching Engine Index operation.
	NearestNeighborSearchOperationMetadata *GoogleCloudAiplatformV1NearestNeighborSearchOperationMetadata `json:"nearestNeighborSearchOperationMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateIndexOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata: Details of
// operations that perform MetadataService.CreateMetadataStore.
type GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for creating a MetadataStore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateMetadataStoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateNotebookExecutionJobOperationMetadata: Metadata
// information for NotebookService.CreateNotebookExecutionJob.
type GoogleCloudAiplatformV1CreateNotebookExecutionJobOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ProgressMessage: A human-readable message that shows the intermediate
	// progress details of NotebookRuntime.
	ProgressMessage string `json:"progressMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateNotebookExecutionJobOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateNotebookExecutionJobOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateNotebookExecutionJobRequest: Request message
// for [NotebookService.CreateNotebookExecutionJob]
type GoogleCloudAiplatformV1CreateNotebookExecutionJobRequest struct {
	// NotebookExecutionJob: Required. The NotebookExecutionJob to create.
	NotebookExecutionJob *GoogleCloudAiplatformV1NotebookExecutionJob `json:"notebookExecutionJob,omitempty"`
	// NotebookExecutionJobId: Optional. User specified ID for the
	// NotebookExecutionJob.
	NotebookExecutionJobId string `json:"notebookExecutionJobId,omitempty"`
	// Parent: Required. The resource name of the Location to create the
	// NotebookExecutionJob. Format: `projects/{project}/locations/{location}`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotebookExecutionJob") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotebookExecutionJob") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateNotebookExecutionJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateNotebookExecutionJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata:
// Metadata information for NotebookService.CreateNotebookRuntimeTemplate.
type GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateNotebookRuntimeTemplateOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreatePersistentResourceOperationMetadata: Details of
// operations that perform create PersistentResource.
type GoogleCloudAiplatformV1CreatePersistentResourceOperationMetadata struct {
	// GenericMetadata: Operation metadata for PersistentResource.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ProgressMessage: Progress Message for Create LRO
	ProgressMessage string `json:"progressMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreatePersistentResourceOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreatePersistentResourceOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreatePipelineJobRequest: Request message for
// PipelineService.CreatePipelineJob.
type GoogleCloudAiplatformV1CreatePipelineJobRequest struct {
	// Parent: Required. The resource name of the Location to create the
	// PipelineJob in. Format: `projects/{project}/locations/{location}`
	Parent string `json:"parent,omitempty"`
	// PipelineJob: Required. The PipelineJob to create.
	PipelineJob *GoogleCloudAiplatformV1PipelineJob `json:"pipelineJob,omitempty"`
	// PipelineJobId: The ID to use for the PipelineJob, which will become the
	// final component of the PipelineJob name. If not provided, an ID will be
	// automatically generated. This value should be less than 128 characters, and
	// valid characters are `/a-z-/`.
	PipelineJobId string `json:"pipelineJobId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreatePipelineJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreatePipelineJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata: Details of
// operations that perform create FeatureGroup.
type GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateRegistryFeatureOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata: Runtime
// operation information for SpecialistPoolService.CreateSpecialistPool.
type GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateSpecialistPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateTensorboardOperationMetadata: Details of
// operations that perform create Tensorboard.
type GoogleCloudAiplatformV1CreateTensorboardOperationMetadata struct {
	// GenericMetadata: Operation metadata for Tensorboard.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateTensorboardOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateTensorboardOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateTensorboardRunRequest: Request message for
// TensorboardService.CreateTensorboardRun.
type GoogleCloudAiplatformV1CreateTensorboardRunRequest struct {
	// Parent: Required. The resource name of the TensorboardExperiment to create
	// the TensorboardRun in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experimen
	// ts/{experiment}`
	Parent string `json:"parent,omitempty"`
	// TensorboardRun: Required. The TensorboardRun to create.
	TensorboardRun *GoogleCloudAiplatformV1TensorboardRun `json:"tensorboardRun,omitempty"`
	// TensorboardRunId: Required. The ID to use for the Tensorboard run, which
	// becomes the final component of the Tensorboard run's resource name. This
	// value should be 1-128 characters, and valid characters are `/a-z-/`.
	TensorboardRunId string `json:"tensorboardRunId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateTensorboardRunRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateTensorboardRunRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest: Request message
// for TensorboardService.CreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest struct {
	// Parent: Required. The resource name of the TensorboardRun to create the
	// TensorboardTimeSeries in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experimen
	// ts/{experiment}/runs/{run}`
	Parent string `json:"parent,omitempty"`
	// TensorboardTimeSeries: Required. The TensorboardTimeSeries to create.
	TensorboardTimeSeries *GoogleCloudAiplatformV1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`
	// TensorboardTimeSeriesId: Optional. The user specified unique ID to use for
	// the TensorboardTimeSeries, which becomes the final component of the
	// TensorboardTimeSeries's resource name. This value should match "a-z0-9{0,
	// 127}"
	TensorboardTimeSeriesId string `json:"tensorboardTimeSeriesId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CreateTensorboardTimeSeriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CsvDestination: The storage details for CSV output
// content.
type GoogleCloudAiplatformV1CsvDestination struct {
	// GcsDestination: Required. Google Cloud Storage location.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CsvDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CsvDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CsvSource: The storage details for CSV input content.
type GoogleCloudAiplatformV1CsvSource struct {
	// GcsSource: Required. Google Cloud Storage location.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CsvSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CsvSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomCodeExecutionResult: Result for custom code
// execution metric.
type GoogleCloudAiplatformV1CustomCodeExecutionResult struct {
	// Score: Output only. Custom code execution score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CustomCodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomCodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1CustomCodeExecutionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1CustomCodeExecutionResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1CustomCodeExecutionSpec: Specificies a metric that is
// populated by evaluating user-defined Python code.
type GoogleCloudAiplatformV1CustomCodeExecutionSpec struct {
	// EvaluationFunction: Required. Python function. Expected user to define the
	// following function, e.g.: def evaluate(instance: dict[str, Any]) -> float:
	// Please include this function signature in the code snippet. Instance is the
	// evaluation instance, any fields populated in the instance are available to
	// the function as instance[field_name]. Example: Example input: ``` instance=
	// EvaluationInstance( response=EvaluationInstance.InstanceData(text="The
	// answer is 4."), reference=EvaluationInstance.InstanceData(text="4") ) ```
	// Example converted input: ``` { 'response': {'text': 'The answer is 4.'},
	// 'reference': {'text': '4'} } ``` Example python function: ``` def
	// evaluate(instance: dict[str, Any]) -> float: if instance'response' ==
	// instance'reference': return 1.0 return 0.0 ``` CustomCodeExecutionSpec is
	// also supported in Batch Evaluation (EvalDataset RPC) and Tuning Evaluation.
	// Each line in the input jsonl file will be converted to dict[str, Any] and
	// passed to the evaluation function.
	EvaluationFunction string `json:"evaluationFunction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationFunction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationFunction") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CustomCodeExecutionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomCodeExecutionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomJob: Represents a job that runs custom
// workloads such as a Docker container or a Python package. A CustomJob can
// have multiple worker pools and each worker pool can have its own machine and
// input spec. A CustomJob will be cleaned up once the job enters terminal
// state (failed or succeeded).
type GoogleCloudAiplatformV1CustomJob struct {
	// CreateTime: Output only. Time when the CustomJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the CustomJob. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key options for a CustomJob. If
	// this is set, then all resources created by the CustomJob will be encrypted
	// with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// EndTime: Output only. Time when the CustomJob entered any of the following
	// states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. Only populated when job's state is `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// JobSpec: Required. Job spec.
	JobSpec *GoogleCloudAiplatformV1CustomJobSpec `json:"jobSpec,omitempty"`
	// Labels: The labels with user-defined metadata to organize CustomJobs. Label
	// keys and values can be no longer than 64 characters (Unicode codepoints),
	// can only contain lowercase letters, numeric characters, underscores and
	// dashes. International characters are allowed. See https://goo.gl/xmQnxf for
	// more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Resource name of a CustomJob.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// StartTime: Output only. Time when the CustomJob for the first time entered
	// the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Time when the CustomJob was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WebAccessUris: Output only. URIs for accessing interactive shells
	// (https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// (one URI for each training node). Only available if
	// job_spec.enable_web_access is `true`. The keys are names of each node in the
	// training job; for example, `workerpool0-0` for the primary node,
	// `workerpool1-0` for the first node in the second worker pool, and
	// `workerpool1-1` for the second node in the second worker pool. The values
	// are the URIs for each node's interactive shell.
	WebAccessUris map[string]string `json:"webAccessUris,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CustomJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomJobSpec: Represents the spec of a CustomJob.
type GoogleCloudAiplatformV1CustomJobSpec struct {
	// BaseOutputDirectory: The Cloud Storage location to store the output of this
	// CustomJob or HyperparameterTuningJob. For HyperparameterTuningJob, the
	// baseOutputDirectory of each child CustomJob backing a Trial is set to a
	// subdirectory of name id under its parent HyperparameterTuningJob's
	// baseOutputDirectory. The following Vertex AI environment variables will be
	// passed to containers or python modules when this field is set: For
	// CustomJob: * AIP_MODEL_DIR = `/model/` * AIP_CHECKPOINT_DIR =
	// `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `/logs/` For CustomJob backing a
	// Trial of HyperparameterTuningJob: * AIP_MODEL_DIR = `//model/` *
	// AIP_CHECKPOINT_DIR = `//checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `//logs/`
	BaseOutputDirectory *GoogleCloudAiplatformV1GcsDestination `json:"baseOutputDirectory,omitempty"`
	// EnableDashboardAccess: Optional. Whether you want Vertex AI to enable access
	// to the customized dashboard in training chief container. If set to `true`,
	// you can access the dashboard at the URIs given by CustomJob.web_access_uris
	// or Trial.web_access_uris (within HyperparameterTuningJob.trials).
	EnableDashboardAccess bool `json:"enableDashboardAccess,omitempty"`
	// EnableWebAccess: Optional. Whether you want Vertex AI to enable interactive
	// shell access
	// (https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// to training containers. If set to `true`, you can access interactive shells
	// at the URIs given by CustomJob.web_access_uris or Trial.web_access_uris
	// (within HyperparameterTuningJob.trials).
	EnableWebAccess bool `json:"enableWebAccess,omitempty"`
	// Experiment: Optional. The Experiment associated with this job. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadataStores}/cont
	// exts/{experiment-name}`
	Experiment string `json:"experiment,omitempty"`
	// ExperimentRun: Optional. The Experiment Run associated with this job.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadataStores}/cont
	// exts/{experiment-name}-{experiment-run-name}`
	ExperimentRun string `json:"experimentRun,omitempty"`
	// Models: Optional. The name of the Model resources for which to generate a
	// mapping to artifact URIs. Applicable only to some of the Google-provided
	// custom jobs. Format:
	// `projects/{project}/locations/{location}/models/{model}` In order to
	// retrieve a specific version of the model, also provide the version ID or
	// version alias. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` If no
	// version ID or alias is specified, the "default" version will be returned.
	// The "default" version alias is created for the first version of the model,
	// and can be moved to other versions later on. There will be exactly one
	// default version.
	Models []string `json:"models,omitempty"`
	// Network: Optional. The full name of the Compute Engine network
	// (/compute/docs/networks-and-firewalls#networks) to which the Job should be
	// peered. For example, `projects/12345/global/networks/myVPC`. Format
	// (/compute/docs/reference/rest/v1/networks/insert) is of the form
	// `projects/{project}/global/networks/{network}`. Where {project} is a project
	// number, as in `12345`, and {network} is a network name. To specify this
	// field, you must have already configured VPC Network Peering for Vertex AI
	// (https://cloud.google.com/vertex-ai/docs/general/vpc-peering). If this field
	// is left unspecified, the job is not peered with any network.
	Network string `json:"network,omitempty"`
	// PersistentResourceId: Optional. The ID of the PersistentResource in the same
	// Project and Location which to run If this is specified, the job will be run
	// on existing machines held by the PersistentResource instead of on-demand
	// short-live machines. The network and CMEK configs on the job should be
	// consistent with those on the PersistentResource, otherwise, the job will be
	// rejected.
	PersistentResourceId string `json:"persistentResourceId,omitempty"`
	// ProtectedArtifactLocationId: The ID of the location to store protected
	// artifacts. e.g. us-central1. Populate only when the location is different
	// than CustomJob location. List of supported locations:
	// https://cloud.google.com/vertex-ai/docs/general/locations
	ProtectedArtifactLocationId string `json:"protectedArtifactLocationId,omitempty"`
	// PscInterfaceConfig: Optional. Configuration for PSC-I for CustomJob.
	PscInterfaceConfig *GoogleCloudAiplatformV1PscInterfaceConfig `json:"pscInterfaceConfig,omitempty"`
	// ReservedIpRanges: Optional. A list of names for the reserved ip ranges under
	// the VPC network that can be used for this job. If set, we will deploy the
	// job within the provided ip ranges. Otherwise, the job will be deployed to
	// any ip ranges under the provided VPC network. Example:
	// ['vertex-ai-ip-range'].
	ReservedIpRanges []string `json:"reservedIpRanges,omitempty"`
	// Scheduling: Scheduling options for a CustomJob.
	Scheduling *GoogleCloudAiplatformV1Scheduling `json:"scheduling,omitempty"`
	// ServiceAccount: Specifies the service account for workload run-as account.
	// Users submitting jobs must have act-as permission on this run-as account. If
	// unspecified, the Vertex AI Custom Code Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// for the CustomJob's project is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Tensorboard: Optional. The name of a Vertex AI Tensorboard resource to which
	// this CustomJob will upload Tensorboard logs. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard string `json:"tensorboard,omitempty"`
	// WorkerPoolSpecs: Required. The spec of the worker pools including machine
	// type and Docker image. All worker pools except the first one are optional
	// and can be skipped by providing an empty value.
	WorkerPoolSpecs []*GoogleCloudAiplatformV1WorkerPoolSpec `json:"workerPoolSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseOutputDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseOutputDirectory") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CustomJobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomJobSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomOutput: Spec for custom output.
type GoogleCloudAiplatformV1CustomOutput struct {
	// RawOutputs: Output only. List of raw output strings.
	RawOutputs *GoogleCloudAiplatformV1RawOutput `json:"rawOutputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RawOutputs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RawOutputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CustomOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1CustomOutputFormatConfig: Spec for custom output
// format configuration.
type GoogleCloudAiplatformV1CustomOutputFormatConfig struct {
	// ReturnRawOutput: Optional. Whether to return raw output.
	ReturnRawOutput bool `json:"returnRawOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReturnRawOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReturnRawOutput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1CustomOutputFormatConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1CustomOutputFormatConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DataItem: A piece of data in a Dataset. Could be an
// image, a video, a document or plain text.
type GoogleCloudAiplatformV1DataItem struct {
	// CreateTime: Output only. Timestamp when this DataItem was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// DataItems. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed. No
	// more than 64 user labels can be associated with one DataItem(System labels
	// are excluded). See https://goo.gl/xmQnxf for more information and examples
	// of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name of the DataItem.
	Name string `json:"name,omitempty"`
	// Payload: Required. The data that the DataItem represents (for example, an
	// image or a text snippet). The schema of the payload is stored in the parent
	// Dataset's metadata schema's dataItemSchemaUri field.
	Payload interface{} `json:"payload,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this DataItem was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DataItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DataItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DataItemView: A container for a single DataItem and
// Annotations on it.
type GoogleCloudAiplatformV1DataItemView struct {
	// Annotations: The Annotations on the DataItem. If too many Annotations should
	// be returned for the DataItem, this field will be truncated per
	// annotations_limit in request. If it was, then the has_truncated_annotations
	// will be set to true.
	Annotations []*GoogleCloudAiplatformV1Annotation `json:"annotations,omitempty"`
	// DataItem: The DataItem.
	DataItem *GoogleCloudAiplatformV1DataItem `json:"dataItem,omitempty"`
	// HasTruncatedAnnotations: True if and only if the Annotations field has been
	// truncated. It happens if more Annotations for this DataItem met the
	// request's annotation_filter than are allowed to be returned by
	// annotations_limit. Note that if Annotations field is not being returned due
	// to field mask, then this field will not be set to true no matter how many
	// Annotations are there.
	HasTruncatedAnnotations bool `json:"hasTruncatedAnnotations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DataItemView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DataItemView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DataLabelingJob: DataLabelingJob is used to trigger a
// human labeling job on unlabeled data from the following Dataset:
type GoogleCloudAiplatformV1DataLabelingJob struct {
	// ActiveLearningConfig: Parameters that configure the active learning
	// pipeline. Active learning will label the data incrementally via several
	// iterations. For every iteration, it will select a batch of data based on the
	// sampling strategy.
	ActiveLearningConfig *GoogleCloudAiplatformV1ActiveLearningConfig `json:"activeLearningConfig,omitempty"`
	// AnnotationLabels: Labels to assign to annotations generated by this
	// DataLabelingJob. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable.
	AnnotationLabels map[string]string `json:"annotationLabels,omitempty"`
	// CreateTime: Output only. Timestamp when this DataLabelingJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// CurrentSpend: Output only. Estimated cost(in US dollars) that the
	// DataLabelingJob has incurred to date.
	CurrentSpend *GoogleTypeMoney `json:"currentSpend,omitempty"`
	// Datasets: Required. Dataset resource names. Right now we only support
	// labeling from a single Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Datasets []string `json:"datasets,omitempty"`
	// DisplayName: Required. The user-defined name of the DataLabelingJob. The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters. Display name of a DataLabelingJob.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for a DataLabelingJob.
	// If set, this DataLabelingJob will be secured by this key. Note: Annotations
	// created in the DataLabelingJob are associated with the EncryptionSpec of the
	// Dataset they are exported to.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Error: Output only. DataLabelingJob errors. It is only populated when job's
	// state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Inputs: Required. Input config parameters for the DataLabelingJob.
	Inputs interface{} `json:"inputs,omitempty"`
	// InputsSchemaUri: Required. Points to a YAML file stored on Google Cloud
	// Storage describing the config for a specific type of DataLabelingJob. The
	// schema files that can be used here are found in the
	// https://storage.googleapis.com/google-cloud-aiplatform bucket in the
	// /schema/datalabelingjob/inputs/ folder.
	InputsSchemaUri string `json:"inputsSchemaUri,omitempty"`
	// InstructionUri: Required. The Google Cloud Storage location of the
	// instruction pdf. This pdf is shared with labelers, and provides detailed
	// description on how to label DataItems in Datasets.
	InstructionUri string `json:"instructionUri,omitempty"`
	// LabelerCount: Required. Number of labelers to work on each DataItem.
	LabelerCount int64 `json:"labelerCount,omitempty"`
	// LabelingProgress: Output only. Current labeling job progress percentage
	// scaled in interval [0, 100], indicating the percentage of DataItems that has
	// been finished.
	LabelingProgress int64 `json:"labelingProgress,omitempty"`
	// Labels: The labels with user-defined metadata to organize your
	// DataLabelingJobs. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable. Following system labels exist for each DataLabelingJob: *
	// "aiplatform.googleapis.com/schema": output only, its value is the
	// inputs_schema's title.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Resource name of the DataLabelingJob.
	Name string `json:"name,omitempty"`
	// SpecialistPools: The SpecialistPools' resource names associated with this
	// job.
	SpecialistPools []string `json:"specialistPools,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this DataLabelingJob was updated
	// most recently.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveLearningConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveLearningConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DataLabelingJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DataLabelingJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Dataset: A collection of DataItems and Annotations on
// them.
type GoogleCloudAiplatformV1Dataset struct {
	// CreateTime: Output only. Timestamp when this Dataset was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataItemCount: Output only. The number of DataItems in this Dataset. Only
	// apply for non-structured Dataset.
	DataItemCount int64 `json:"dataItemCount,omitempty,string"`
	// Description: The description of the Dataset.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The user-defined name of the Dataset. The name can be
	// up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for a Dataset. If set,
	// this Dataset and all sub-resources of this Dataset will be secured by this
	// key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Datasets.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Dataset (System labels are
	// excluded). See https://goo.gl/xmQnxf for more information and examples of
	// labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable. Following system labels
	// exist for each Dataset: *
	// "aiplatform.googleapis.com/dataset_metadata_schema": output only, its value
	// is the metadata_schema's title.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Required. Additional information about the Dataset.
	Metadata interface{} `json:"metadata,omitempty"`
	// MetadataArtifact: Output only. The resource name of the Artifact that was
	// created in MetadataStore when creating the Dataset. The Artifact resource
	// name pattern is
	// `projects/{project}/locations/{location}/metadataStores/{metadata_store}/arti
	// facts/{artifact}`.
	MetadataArtifact string `json:"metadataArtifact,omitempty"`
	// MetadataSchemaUri: Required. Points to a YAML file stored on Google Cloud
	// Storage describing additional information about the Dataset. The schema is
	// defined as an OpenAPI 3.0.2 Schema Object. The schema files that can be used
	// here are found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`
	// ModelReference: Optional. Reference to the public base model last used by
	// the dataset. Only set for prompt datasets.
	ModelReference string `json:"modelReference,omitempty"`
	// Name: Output only. Identifier. The resource name of the Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SavedQueries: All SavedQueries belong to the Dataset will be returned in
	// List/Get Dataset response. The annotation_specs field will not be populated
	// except for UI cases which will only use annotation_spec_count. In
	// CreateDataset request, a SavedQuery is created together if this field is
	// set, up to one SavedQuery can be set in CreateDatasetRequest. The SavedQuery
	// should not contain any AnnotationSpec.
	SavedQueries []*GoogleCloudAiplatformV1SavedQuery `json:"savedQueries,omitempty"`
	// UpdateTime: Output only. Timestamp when this Dataset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DatasetDistribution: Distribution computed over a
// tuning dataset.
type GoogleCloudAiplatformV1DatasetDistribution struct {
	// Buckets: Output only. Defines the histogram bucket.
	Buckets []*GoogleCloudAiplatformV1DatasetDistributionDistributionBucket `json:"buckets,omitempty"`
	// Max: Output only. The maximum of the population values.
	Max float64 `json:"max,omitempty"`
	// Mean: Output only. The arithmetic mean of the values in the population.
	Mean float64 `json:"mean,omitempty"`
	// Median: Output only. The median of the values in the population.
	Median float64 `json:"median,omitempty"`
	// Min: Output only. The minimum of the population values.
	Min float64 `json:"min,omitempty"`
	// P5: Output only. The 5th percentile of the values in the population.
	P5 float64 `json:"p5,omitempty"`
	// P95: Output only. The 95th percentile of the values in the population.
	P95 float64 `json:"p95,omitempty"`
	// Sum: Output only. Sum of a given population of values.
	Sum float64 `json:"sum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buckets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buckets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DatasetDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DatasetDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1DatasetDistribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1DatasetDistribution
	var s1 struct {
		Max    gensupport.JSONFloat64 `json:"max"`
		Mean   gensupport.JSONFloat64 `json:"mean"`
		Median gensupport.JSONFloat64 `json:"median"`
		Min    gensupport.JSONFloat64 `json:"min"`
		P5     gensupport.JSONFloat64 `json:"p5"`
		P95    gensupport.JSONFloat64 `json:"p95"`
		Sum    gensupport.JSONFloat64 `json:"sum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Max = float64(s1.Max)
	s.Mean = float64(s1.Mean)
	s.Median = float64(s1.Median)
	s.Min = float64(s1.Min)
	s.P5 = float64(s1.P5)
	s.P95 = float64(s1.P95)
	s.Sum = float64(s1.Sum)
	return nil
}

// GoogleCloudAiplatformV1DatasetDistributionDistributionBucket: Dataset bucket
// used to create a histogram for the distribution given a population of
// values.
type GoogleCloudAiplatformV1DatasetDistributionDistributionBucket struct {
	// Count: Output only. Number of values in the bucket.
	Count int64 `json:"count,omitempty,string"`
	// Left: Output only. Left bound of the bucket.
	Left float64 `json:"left,omitempty"`
	// Right: Output only. Right bound of the bucket.
	Right float64 `json:"right,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DatasetDistributionDistributionBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DatasetDistributionDistributionBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1DatasetDistributionDistributionBucket) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1DatasetDistributionDistributionBucket
	var s1 struct {
		Left  gensupport.JSONFloat64 `json:"left"`
		Right gensupport.JSONFloat64 `json:"right"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Left = float64(s1.Left)
	s.Right = float64(s1.Right)
	return nil
}

// GoogleCloudAiplatformV1DatasetVersion: Describes the dataset version.
type GoogleCloudAiplatformV1DatasetVersion struct {
	// BigQueryDatasetName: Output only. Name of the associated BigQuery dataset.
	BigQueryDatasetName string `json:"bigQueryDatasetName,omitempty"`
	// CreateTime: Output only. Timestamp when this DatasetVersion was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The user-defined name of the DatasetVersion. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Metadata: Required. Output only. Additional information about the
	// DatasetVersion.
	Metadata interface{} `json:"metadata,omitempty"`
	// ModelReference: Output only. Reference to the public base model last used by
	// the dataset version. Only set for prompt dataset versions.
	ModelReference string `json:"modelReference,omitempty"`
	// Name: Output only. Identifier. The resource name of the DatasetVersion.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{
	// dataset_version}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this DatasetVersion was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDatasetName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDatasetName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DatasetVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DatasetVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DedicatedResources: A description of resources that
// are dedicated to a DeployedModel or DeployedIndex, and that need a higher
// degree of manual configuration.
type GoogleCloudAiplatformV1DedicatedResources struct {
	// AutoscalingMetricSpecs: Immutable. The metric specifications that overrides
	// a resource utilization metric (CPU utilization, accelerator's duty cycle,
	// and so on) target value (default to 60 if not set). At most one entry is
	// allowed per metric. If machine_spec.accelerator_count is above 0, the
	// autoscaling will be based on both CPU utilization and accelerator's duty
	// cycle metrics and scale up when either metrics exceeds its target value
	// while scale down if both metrics are under their target value. The default
	// target value is 60 for both metrics. If machine_spec.accelerator_count is 0,
	// the autoscaling will be based on CPU utilization metric only with default
	// target value 60 if not explicitly set. For example, in the case of Online
	// Prediction, if you want to override target CPU utilization to 80, you should
	// set autoscaling_metric_specs.metric_name to
	// `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
	// autoscaling_metric_specs.target to `80`.
	AutoscalingMetricSpecs []*GoogleCloudAiplatformV1AutoscalingMetricSpec `json:"autoscalingMetricSpecs,omitempty"`
	// MachineSpec: Required. Immutable. The specification of a single machine
	// being used.
	MachineSpec *GoogleCloudAiplatformV1MachineSpec `json:"machineSpec,omitempty"`
	// MaxReplicaCount: Immutable. The maximum number of replicas that may be
	// deployed on when the traffic against it increases. If the requested value is
	// too large, the deployment will error, but if deployment succeeds then the
	// ability to scale to that many replicas is guaranteed (barring service
	// outages). If traffic increases beyond what its replicas at maximum may
	// handle, a portion of the traffic will be dropped. If this value is not
	// provided, will use min_replica_count as the default value. The value of this
	// field impacts the charge against Vertex CPU and GPU quotas. Specifically,
	// you will be charged for (max_replica_count * number of cores in the selected
	// machine type) and (max_replica_count * number of GPUs per replica in the
	// selected machine type).
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`
	// MinReplicaCount: Required. Immutable. The minimum number of machine replicas
	// that will be always deployed on. This value must be greater than or equal to
	// 1. If traffic increases, it may dynamically be deployed onto more replicas,
	// and as traffic decreases, some of these extra replicas may be freed.
	MinReplicaCount int64 `json:"minReplicaCount,omitempty"`
	// RequiredReplicaCount: Optional. Number of required available replicas for
	// the deployment to succeed. This field is only needed when partial
	// deployment/mutation is desired. If set, the deploy/mutate operation will
	// succeed once available_replica_count reaches required_replica_count, and the
	// rest of the replicas will be retried. If not set, the default
	// required_replica_count will be min_replica_count.
	RequiredReplicaCount int64 `json:"requiredReplicaCount,omitempty"`
	// Spot: Optional. If true, schedule the deployment workload on spot VMs
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/spot-vms).
	Spot bool `json:"spot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoscalingMetricSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoscalingMetricSpecs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DedicatedResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DedicatedResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata: Details of
// operations that delete Feature values.
type GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore delete Features values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesRequest: Request message for
// FeaturestoreService.DeleteFeatureValues.
type GoogleCloudAiplatformV1DeleteFeatureValuesRequest struct {
	// SelectEntity: Select feature values to be deleted by specifying entities.
	SelectEntity *GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity `json:"selectEntity,omitempty"`
	// SelectTimeRangeAndFeature: Select feature values to be deleted by specifying
	// time range and features.
	SelectTimeRangeAndFeature *GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature `json:"selectTimeRangeAndFeature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectEntity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectEntity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity: Message to
// select entity. If an entity id is selected, all the feature values
// corresponding to the entity id will be deleted, including the entityId.
type GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity struct {
	// EntityIdSelector: Required. Selectors choosing feature values of which
	// entity id to be deleted from the EntityType.
	EntityIdSelector *GoogleCloudAiplatformV1EntityIdSelector `json:"entityIdSelector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityIdSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityIdSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature:
// Message to select time range and feature. Values of the selected feature
// generated within an inclusive time range will be deleted. Using this option
// permanently deletes the feature values from the specified feature IDs within
// the specified time range. This might include data from the online storage.
// If you want to retain any deleted historical data in the online storage, you
// must re-ingest it.
type GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature struct {
	// FeatureSelector: Required. Selectors choosing which feature values to be
	// deleted from the EntityType.
	FeatureSelector *GoogleCloudAiplatformV1FeatureSelector `json:"featureSelector,omitempty"`
	// SkipOnlineStorageDelete: If set, data will not be deleted from online
	// storage. When time range is older than the data in online storage, setting
	// this to be true will make the deletion have no impact on online serving.
	SkipOnlineStorageDelete bool `json:"skipOnlineStorageDelete,omitempty"`
	// TimeRange: Required. Select feature generated within a half-inclusive time
	// range. The time range is lower inclusive and upper exclusive.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesRequestSelectTimeRangeAndFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesResponse: Response message for
// FeaturestoreService.DeleteFeatureValues.
type GoogleCloudAiplatformV1DeleteFeatureValuesResponse struct {
	// SelectEntity: Response for request specifying the entities to delete
	SelectEntity *GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity `json:"selectEntity,omitempty"`
	// SelectTimeRangeAndFeature: Response for request specifying time range and
	// feature
	SelectTimeRangeAndFeature *GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature `json:"selectTimeRangeAndFeature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectEntity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectEntity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity: Response
// message if the request uses the SelectEntity option.
type GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity struct {
	// OfflineStorageDeletedEntityRowCount: The count of deleted entity rows in the
	// offline storage. Each row corresponds to the combination of an entity ID and
	// a timestamp. One entity ID can have multiple rows in the offline storage.
	OfflineStorageDeletedEntityRowCount int64 `json:"offlineStorageDeletedEntityRowCount,omitempty,string"`
	// OnlineStorageDeletedEntityCount: The count of deleted entities in the online
	// storage. Each entity ID corresponds to one entity.
	OnlineStorageDeletedEntityCount int64 `json:"onlineStorageDeletedEntityCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g.
	// "OfflineStorageDeletedEntityRowCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "OfflineStorageDeletedEntityRowCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature:
// Response message if the request uses the SelectTimeRangeAndFeature option.
type GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature struct {
	// ImpactedFeatureCount: The count of the features or columns impacted. This is
	// the same as the feature count in the request.
	ImpactedFeatureCount int64 `json:"impactedFeatureCount,omitempty,string"`
	// OfflineStorageModifiedEntityRowCount: The count of modified entity rows in
	// the offline storage. Each row corresponds to the combination of an entity ID
	// and a timestamp. One entity ID can have multiple rows in the offline
	// storage. Within each row, only the features specified in the request are
	// deleted.
	OfflineStorageModifiedEntityRowCount int64 `json:"offlineStorageModifiedEntityRowCount,omitempty,string"`
	// OnlineStorageModifiedEntityCount: The count of modified entities in the
	// online storage. Each entity ID corresponds to one entity. Within each
	// entity, only the features specified in the request are deleted.
	OnlineStorageModifiedEntityCount int64 `json:"onlineStorageModifiedEntityCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ImpactedFeatureCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImpactedFeatureCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteFeatureValuesResponseSelectTimeRangeAndFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata: Details of
// operations that perform MetadataService.DeleteMetadataStore.
type GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for deleting a MetadataStore.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteMetadataStoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeleteOperationMetadata: Details of operations that
// perform deletes of any entities.
type GoogleCloudAiplatformV1DeleteOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeleteOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeleteOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployIndexOperationMetadata: Runtime operation
// information for IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1DeployIndexOperationMetadata struct {
	// DeployedIndexId: The unique index id specified by user
	DeployedIndexId string `json:"deployedIndexId,omitempty"`
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndexId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployIndexOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployIndexRequest: Request message for
// IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1DeployIndexRequest struct {
	// DeployedIndex: Required. The DeployedIndex to be created within the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployIndexRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployIndexRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployIndexResponse: Response message for
// IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1DeployIndexResponse struct {
	// DeployedIndex: The DeployedIndex that had been deployed in the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployIndexResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployIndexResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployModelOperationMetadata: Runtime operation
// information for EndpointService.DeployModel.
type GoogleCloudAiplatformV1DeployModelOperationMetadata struct {
	// DeploymentStage: Output only. The deployment stage of the model.
	//
	// Possible values:
	//   "DEPLOYMENT_STAGE_UNSPECIFIED" - Default value. This value is unused.
	//   "STARTING_DEPLOYMENT" - The deployment is initializing and setting up the
	// environment.
	//   "PREPARING_MODEL" - The deployment is preparing the model assets.
	//   "CREATING_SERVING_CLUSTER" - The deployment is creating the underlying
	// serving cluster.
	//   "ADDING_NODES_TO_CLUSTER" - The deployment is adding nodes to the serving
	// cluster.
	//   "GETTING_CONTAINER_IMAGE" - The deployment is getting the container image
	// for the model server.
	//   "STARTING_MODEL_SERVER" - The deployment is starting the model server.
	//   "FINISHING_UP" - The deployment is performing finalization steps.
	//   "DEPLOYMENT_TERMINATED" - The deployment has terminated.
	//   "SUCCESSFULLY_DEPLOYED" - The deployment has succeeded.
	//   "FAILED_TO_DEPLOY" - The deployment has failed.
	DeploymentStage string `json:"deploymentStage,omitempty"`
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentStage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentStage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployModelRequest: Request message for
// EndpointService.DeployModel.
type GoogleCloudAiplatformV1DeployModelRequest struct {
	// DeployedModel: Required. The DeployedModel to be created within the
	// Endpoint. Note that Endpoint.traffic_split must be updated for the
	// DeployedModel to start receiving traffic, either as part of this call, or
	// via EndpointService.UpdateEndpoint.
	DeployedModel *GoogleCloudAiplatformV1DeployedModel `json:"deployedModel,omitempty"`
	// TrafficSplit: A map from a DeployedModel's ID to the percentage of this
	// Endpoint's traffic that should be forwarded to that DeployedModel. If this
	// field is non-empty, then the Endpoint's traffic_split will be overwritten
	// with it. To refer to the ID of the just being deployed Model, a "0" should
	// be used, and the actual ID of the new DeployedModel will be filled in its
	// place by this method. The traffic percentage values must add up to 100. If
	// this field is empty, then the Endpoint's traffic_split is not updated.
	TrafficSplit map[string]int64 `json:"trafficSplit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployModelResponse: Response message for
// EndpointService.DeployModel.
type GoogleCloudAiplatformV1DeployModelResponse struct {
	// DeployedModel: The DeployedModel that had been deployed in the Endpoint.
	DeployedModel *GoogleCloudAiplatformV1DeployedModel `json:"deployedModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployOperationMetadata: Runtime operation
// information for ModelGardenService.Deploy.
type GoogleCloudAiplatformV1DeployOperationMetadata struct {
	// Destination: Output only. The resource name of the Location to deploy the
	// model in. Format: `projects/{project}/locations/{location}`
	Destination string `json:"destination,omitempty"`
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ModelId: Output only. The model id to be used at query time.
	ModelId string `json:"modelId,omitempty"`
	// ProjectNumber: Output only. The project number where the deploy model
	// request is sent.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`
	// PublisherModel: Output only. The name of the model resource.
	PublisherModel string `json:"publisherModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployRequest: Request message for
// ModelGardenService.Deploy.
type GoogleCloudAiplatformV1DeployRequest struct {
	// DeployConfig: Optional. The deploy config to use for the deployment. If not
	// specified, the default deploy config will be used.
	DeployConfig *GoogleCloudAiplatformV1DeployRequestDeployConfig `json:"deployConfig,omitempty"`
	// EndpointConfig: Optional. The endpoint config to use for the deployment. If
	// not specified, the default endpoint config will be used.
	EndpointConfig *GoogleCloudAiplatformV1DeployRequestEndpointConfig `json:"endpointConfig,omitempty"`
	// HuggingFaceModelId: The Hugging Face model to deploy. Format: Hugging Face
	// model ID like `google/gemma-2-2b-it`.
	HuggingFaceModelId string `json:"huggingFaceModelId,omitempty"`
	// ModelConfig: Optional. The model config to use for the deployment. If not
	// specified, the default model config will be used.
	ModelConfig *GoogleCloudAiplatformV1DeployRequestModelConfig `json:"modelConfig,omitempty"`
	// PublisherModelName: The Model Garden model to deploy. Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
	PublisherModelName string `json:"publisherModelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployRequestDeployConfig: The deploy config to use
// for the deployment.
type GoogleCloudAiplatformV1DeployRequestDeployConfig struct {
	// DedicatedResources: Optional. The dedicated resources to use for the
	// endpoint. If not set, the default resources will be used.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`
	// FastTryoutEnabled: Optional. If true, enable the QMT fast tryout feature for
	// this model if possible.
	FastTryoutEnabled bool `json:"fastTryoutEnabled,omitempty"`
	// SystemLabels: Optional. System labels for Model Garden deployments. These
	// labels are managed by Google and for tracking purposes only.
	SystemLabels map[string]string `json:"systemLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DedicatedResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DedicatedResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployRequestDeployConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployRequestDeployConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployRequestEndpointConfig: The endpoint config to
// use for the deployment.
type GoogleCloudAiplatformV1DeployRequestEndpointConfig struct {
	// DedicatedEndpointDisabled: Optional. By default, if dedicated endpoint is
	// enabled and private service connect config is not set, the endpoint will be
	// exposed through a dedicated DNS [Endpoint.dedicated_endpoint_dns]. If
	// private service connect config is set, the endpoint will be exposed through
	// private service connect. Your request to the dedicated DNS will be isolated
	// from other users' traffic and will have better performance and reliability.
	// Note: Once you enabled dedicated endpoint, you won't be able to send request
	// to the shared DNS {region}-aiplatform.googleapis.com. The limitations will
	// be removed soon. If this field is set to true, the dedicated endpoint will
	// be disabled and the deployed model will be exposed through the shared DNS
	// {region}-aiplatform.googleapis.com.
	DedicatedEndpointDisabled bool `json:"dedicatedEndpointDisabled,omitempty"`
	// DedicatedEndpointEnabled: Optional. Deprecated. Use
	// dedicated_endpoint_disabled instead. If true, the endpoint will be exposed
	// through a dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to
	// the dedicated DNS will be isolated from other users' traffic and will have
	// better performance and reliability. Note: Once you enabled dedicated
	// endpoint, you won't be able to send request to the shared DNS
	// {region}-aiplatform.googleapis.com. The limitations will be removed soon.
	DedicatedEndpointEnabled bool `json:"dedicatedEndpointEnabled,omitempty"`
	// EndpointDisplayName: Optional. The user-specified display name of the
	// endpoint. If not set, a default name will be used.
	EndpointDisplayName string `json:"endpointDisplayName,omitempty"`
	// EndpointUserId: Optional. Immutable. The ID to use for endpoint, which will
	// become the final component of the endpoint resource name. If not provided,
	// Vertex AI will generate a value for this ID. If the first character is a
	// letter, this value may be up to 63 characters, and valid characters are
	// `[a-z0-9-]`. The last character must be a letter or number. If the first
	// character is a number, this value may be up to 9 characters, and valid
	// characters are `[0-9]` with no leading zeros. When using HTTP/JSON, this
	// field is populated based on a query string argument, such as
	// `?endpoint_id=12345`. This is the fallback for fields that are not included
	// in either the URI or the body.
	EndpointUserId string `json:"endpointUserId,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Endpoints. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// PrivateServiceConnectConfig: Optional. Configuration for private service
	// connect. If set, the endpoint will be exposed through private service
	// connect.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DedicatedEndpointDisabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DedicatedEndpointDisabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployRequestEndpointConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployRequestEndpointConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployRequestModelConfig: The model config to use for
// the deployment.
type GoogleCloudAiplatformV1DeployRequestModelConfig struct {
	// AcceptEula: Optional. Whether the user accepts the End User License
	// Agreement (EULA) for the model.
	AcceptEula bool `json:"acceptEula,omitempty"`
	// ContainerSpec: Optional. The specification of the container that is to be
	// used when deploying. If not set, the default container spec will be used.
	ContainerSpec *GoogleCloudAiplatformV1ModelContainerSpec `json:"containerSpec,omitempty"`
	// HuggingFaceAccessToken: Optional. The Hugging Face read access token used to
	// access the model artifacts of gated models.
	HuggingFaceAccessToken string `json:"huggingFaceAccessToken,omitempty"`
	// HuggingFaceCacheEnabled: Optional. If true, the model will deploy with a
	// cached version instead of directly downloading the model artifacts from
	// Hugging Face. This is suitable for VPC-SC users with limited internet
	// access.
	HuggingFaceCacheEnabled bool `json:"huggingFaceCacheEnabled,omitempty"`
	// ModelDisplayName: Optional. The user-specified display name of the uploaded
	// model. If not set, a default name will be used.
	ModelDisplayName string `json:"modelDisplayName,omitempty"`
	// ModelUserId: Optional. The ID to use for the uploaded Model, which will
	// become the final component of the model resource name. When not provided,
	// Vertex AI will generate a value for this ID. When Model Registry model is
	// provided, this field will be ignored. This value may be up to 63 characters,
	// and valid characters are `[a-z0-9_-]`. The first character cannot be a
	// number or hyphen.
	ModelUserId string `json:"modelUserId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptEula") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptEula") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployRequestModelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployRequestModelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployResponse: Response message for
// ModelGardenService.Deploy.
type GoogleCloudAiplatformV1DeployResponse struct {
	// Endpoint: Output only. The name of the Endpoint created. Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `json:"endpoint,omitempty"`
	// Model: Output only. The name of the Model created. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	Model string `json:"model,omitempty"`
	// PublisherModel: Output only. The name of the PublisherModel resource.
	// Format: `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`
	PublisherModel string `json:"publisherModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Endpoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Endpoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndex: A deployment of an Index.
// IndexEndpoints contain one or more DeployedIndexes.
type GoogleCloudAiplatformV1DeployedIndex struct {
	// AutomaticResources: Optional. A description of resources that the
	// DeployedIndex uses, which to large degree are decided by Vertex AI, and
	// optionally allows only a modest additional configuration. If
	// min_replica_count is not set, the default value is 2 (we don't provide SLA
	// when min_replica_count=1). If max_replica_count is not set, the default
	// value is min_replica_count. The max allowed replica count is 1000.
	AutomaticResources *GoogleCloudAiplatformV1AutomaticResources `json:"automaticResources,omitempty"`
	// CreateTime: Output only. Timestamp when the DeployedIndex was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: Optional. A description of resources that are dedicated
	// to the DeployedIndex, and that need a higher degree of manual configuration.
	// The field min_replica_count must be set to a value strictly greater than 0,
	// or else validation will fail. We don't provide SLA when min_replica_count=1.
	// If max_replica_count is not set, the default value is min_replica_count. The
	// max allowed replica count is 1000. Available machine types for SMALL shard:
	// e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
	// Available machine types for MEDIUM shard: e2-standard-16 and all machine
	// types available for LARGE shard. Available machine types for LARGE shard:
	// e2-highmem-16, n2d-standard-32. n1-standard-16 and n1-standard-32 are still
	// available, but we recommend e2-standard-16 and e2-highmem-16 for cost
	// efficiency.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`
	// DeployedIndexAuthConfig: Optional. If set, the authentication is enabled for
	// the private endpoint.
	DeployedIndexAuthConfig *GoogleCloudAiplatformV1DeployedIndexAuthConfig `json:"deployedIndexAuthConfig,omitempty"`
	// DeploymentGroup: Optional. The deployment group can be no longer than 64
	// characters (eg: 'test', 'prod'). If not set, we will use the 'default'
	// deployment group. Creating `deployment_groups` with `reserved_ip_ranges` is
	// a recommended practice when the peered network has multiple peering ranges.
	// This creates your deployments from predictable IP spaces for easier traffic
	// administration. Also, one deployment_group (except 'default') can only be
	// used with the same reserved_ip_ranges which means if the deployment_group
	// has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
	// [d, e] is disallowed. Note: we only support up to 5 deployment groups(not
	// including 'default').
	DeploymentGroup string `json:"deploymentGroup,omitempty"`
	// DeploymentTier: Optional. The deployment tier that the index is deployed to.
	// DEPLOYMENT_TIER_UNSPECIFIED will use a system-chosen default tier.
	//
	// Possible values:
	//   "DEPLOYMENT_TIER_UNSPECIFIED" - Default deployment tier.
	//   "STORAGE" - Optimized for costs.
	DeploymentTier string `json:"deploymentTier,omitempty"`
	// DisplayName: The display name of the DeployedIndex. If not provided upon
	// creation, the Index's display_name is used.
	DisplayName string `json:"displayName,omitempty"`
	// EnableAccessLogging: Optional. If true, private endpoint's access logs are
	// sent to Cloud Logging. These logs are like standard server access logs,
	// containing information like timestamp and latency for each MatchRequest.
	// Note that logs may incur a cost, especially if the deployed index receives a
	// high queries per second rate (QPS). Estimate your costs before enabling this
	// option.
	EnableAccessLogging bool `json:"enableAccessLogging,omitempty"`
	// EnableDatapointUpsertLogging: Optional. If true, logs to Cloud Logging
	// errors relating to datapoint upserts. Under normal operation conditions,
	// these log entries should be very rare. However, if incompatible datapoint
	// updates are being uploaded to an index, a high volume of log entries may be
	// generated in a short period of time. Note that logs may incur a cost,
	// especially if the deployed index receives a high volume of datapoint
	// upserts. Estimate your costs before enabling this option.
	EnableDatapointUpsertLogging bool `json:"enableDatapointUpsertLogging,omitempty"`
	// Id: Required. The user specified ID of the DeployedIndex. The ID can be up
	// to 128 characters long and must start with a letter and only contain
	// letters, numbers, and underscores. The ID must be unique within the project
	// it is created in.
	Id string `json:"id,omitempty"`
	// Index: Required. The name of the Index this is the deployment of. We may
	// refer to this Index as the DeployedIndex's "original" Index.
	Index string `json:"index,omitempty"`
	// IndexSyncTime: Output only. The DeployedIndex may depend on various data on
	// its original Index. Additionally when certain changes to the original Index
	// are being done (e.g. when what the Index contains is being changed) the
	// DeployedIndex may be asynchronously updated in the background to reflect
	// these changes. If this timestamp's value is at least the Index.update_time
	// of the original Index, it means that this DeployedIndex and the original
	// Index are in sync. If this timestamp is older, then to see which updates
	// this DeployedIndex already contains (and which it does not), one must list
	// the operations that are running on the original Index. Only the successfully
	// completed Operations with update_time equal or before this sync time are
	// contained in this DeployedIndex.
	IndexSyncTime string `json:"indexSyncTime,omitempty"`
	// PrivateEndpoints: Output only. Provides paths for users to send requests
	// directly to the deployed index services running on Cloud via private
	// services access. This field is populated if network is configured.
	PrivateEndpoints *GoogleCloudAiplatformV1IndexPrivateEndpoints `json:"privateEndpoints,omitempty"`
	// PscAutomationConfigs: Optional. If set for PSC deployed index, PSC
	// connection will be automatically created after deployment is done and the
	// endpoint information is populated in
	// private_endpoints.psc_automated_endpoints.
	PscAutomationConfigs []*GoogleCloudAiplatformV1PSCAutomationConfig `json:"pscAutomationConfigs,omitempty"`
	// ReservedIpRanges: Optional. A list of reserved ip ranges under the VPC
	// network that can be used for this DeployedIndex. If set, we will deploy the
	// index within the provided ip ranges. Otherwise, the index might be deployed
	// to any ip ranges under the provided VPC network. The value should be the
	// name of the address
	// (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example:
	// ['vertex-ai-ip-range']. For more information about subnets and network IP
	// ranges, please see
	// https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
	ReservedIpRanges []string `json:"reservedIpRanges,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomaticResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomaticResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedIndex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndexAuthConfig: Used to set up the auth on
// the DeployedIndex's private endpoint.
type GoogleCloudAiplatformV1DeployedIndexAuthConfig struct {
	// AuthProvider: Defines the authentication provider that the DeployedIndex
	// uses.
	AuthProvider *GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider `json:"authProvider,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthProvider") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthProvider") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedIndexAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndexAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider: Configuration
// for an authentication provider, including support for JSON Web Token (JWT)
// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider struct {
	// AllowedIssuers: A list of allowed JWT issuers. Each entry must be a valid
	// Google service account, in the following format:
	// `service-account-name@project-id.iam.gserviceaccount.com`
	AllowedIssuers []string `json:"allowedIssuers,omitempty"`
	// Audiences: The list of JWT audiences
	// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences will be
	// accepted.
	Audiences []string `json:"audiences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedIssuers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedIssuers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndexAuthConfigAuthProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedIndexRef: Points to a DeployedIndex.
type GoogleCloudAiplatformV1DeployedIndexRef struct {
	// DeployedIndexId: Immutable. The ID of the DeployedIndex in the above
	// IndexEndpoint.
	DeployedIndexId string `json:"deployedIndexId,omitempty"`
	// DisplayName: Output only. The display name of the DeployedIndex.
	DisplayName string `json:"displayName,omitempty"`
	// IndexEndpoint: Immutable. A resource name of the IndexEndpoint.
	IndexEndpoint string `json:"indexEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndexId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedIndexRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedIndexRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedModel: A deployment of a Model. Endpoints
// contain one or more DeployedModels.
type GoogleCloudAiplatformV1DeployedModel struct {
	// AutomaticResources: A description of resources that to large degree are
	// decided by Vertex AI, and require only a modest additional configuration.
	AutomaticResources *GoogleCloudAiplatformV1AutomaticResources `json:"automaticResources,omitempty"`
	// CheckpointId: The checkpoint id of the model.
	CheckpointId string `json:"checkpointId,omitempty"`
	// CreateTime: Output only. Timestamp when the DeployedModel was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: A description of resources that are dedicated to the
	// DeployedModel, and that need a higher degree of manual configuration.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`
	// DisableContainerLogging: For custom-trained Models and AutoML Tabular
	// Models, the container of the DeployedModel instances will send `stderr` and
	// `stdout` streams to Cloud Logging by default. Please note that the logs
	// incur cost, which are subject to Cloud Logging pricing
	// (https://cloud.google.com/logging/pricing). User can disable container
	// logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`
	// DisableExplanations: If true, deploy the model without explainable feature,
	// regardless the existence of Model.explanation_spec or explanation_spec.
	DisableExplanations bool `json:"disableExplanations,omitempty"`
	// DisplayName: The display name of the DeployedModel. If not provided upon
	// creation, the Model's display_name is used.
	DisplayName string `json:"displayName,omitempty"`
	// EnableAccessLogging: If true, online prediction access logs are sent to
	// Cloud Logging. These logs are like standard server access logs, containing
	// information like timestamp and latency for each prediction request. Note
	// that logs may incur a cost, especially if your project receives prediction
	// requests at a high queries per second rate (QPS). Estimate your costs before
	// enabling this option.
	EnableAccessLogging bool `json:"enableAccessLogging,omitempty"`
	// ExplanationSpec: Explanation configuration for this DeployedModel. When
	// deploying a Model using EndpointService.DeployModel, this value overrides
	// the value of Model.explanation_spec. All fields of explanation_spec are
	// optional in the request. If a field of explanation_spec is not populated,
	// the value of the same field of Model.explanation_spec is inherited. If the
	// corresponding Model.explanation_spec is not populated, all fields of the
	// explanation_spec will be used for the explanation configuration.
	ExplanationSpec *GoogleCloudAiplatformV1ExplanationSpec `json:"explanationSpec,omitempty"`
	// FasterDeploymentConfig: Configuration for faster model deployment.
	FasterDeploymentConfig *GoogleCloudAiplatformV1FasterDeploymentConfig `json:"fasterDeploymentConfig,omitempty"`
	// GdcConnectedModel: GDC pretrained / Gemini model name. The model name is a
	// plain model name, e.g. gemini-1.5-flash-002.
	GdcConnectedModel string `json:"gdcConnectedModel,omitempty"`
	// Id: Immutable. The ID of the DeployedModel. If not provided upon deployment,
	// Vertex AI will generate a value for this ID. This value should be 1-10
	// characters, and valid characters are `/[0-9]/`.
	Id string `json:"id,omitempty"`
	// Model: The resource name of the Model that this is the deployment of. Note
	// that the Model may be in a different location than the DeployedModel's
	// Endpoint. The resource name may contain version id or version alias to
	// specify the version. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` if no
	// version is specified, the default version will be deployed.
	Model string `json:"model,omitempty"`
	// ModelVersionId: Output only. The version ID of the model that is deployed.
	ModelVersionId string `json:"modelVersionId,omitempty"`
	// PrivateEndpoints: Output only. Provide paths for users to send
	// predict/explain/health requests directly to the deployed model services
	// running on Cloud via private services access. This field is populated if
	// network is configured.
	PrivateEndpoints *GoogleCloudAiplatformV1PrivateEndpoints `json:"privateEndpoints,omitempty"`
	// ServiceAccount: The service account that the DeployedModel's container runs
	// as. Specify the email address of the service account. If this service
	// account is not specified, the container runs as a service account that
	// doesn't have access to the resource project. Users deploying the Model must
	// have the `iam.serviceAccounts.actAs` permission on this service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// SharedResources: The resource name of the shared DeploymentResourcePool to
	// deploy on. Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_
	// resource_pool}`
	SharedResources string `json:"sharedResources,omitempty"`
	// SpeculativeDecodingSpec: Optional. Spec for configuring speculative
	// decoding.
	SpeculativeDecodingSpec *GoogleCloudAiplatformV1SpeculativeDecodingSpec `json:"speculativeDecodingSpec,omitempty"`
	// Status: Output only. Runtime status of the deployed model.
	Status *GoogleCloudAiplatformV1DeployedModelStatus `json:"status,omitempty"`
	// SystemLabels: System labels to apply to Model Garden deployments. System
	// labels are managed by Google for internal use only.
	SystemLabels map[string]string `json:"systemLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomaticResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomaticResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedModelRef: Points to a DeployedModel.
type GoogleCloudAiplatformV1DeployedModelRef struct {
	// CheckpointId: Immutable. The ID of the Checkpoint deployed in the
	// DeployedModel.
	CheckpointId string `json:"checkpointId,omitempty"`
	// DeployedModelId: Immutable. An ID of a DeployedModel in the above Endpoint.
	DeployedModelId string `json:"deployedModelId,omitempty"`
	// Endpoint: Immutable. A resource name of an Endpoint.
	Endpoint string `json:"endpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckpointId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckpointId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedModelRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedModelRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeployedModelStatus: Runtime status of the deployed
// model.
type GoogleCloudAiplatformV1DeployedModelStatus struct {
	// AvailableReplicaCount: Output only. The number of available replicas of the
	// deployed model.
	AvailableReplicaCount int64 `json:"availableReplicaCount,omitempty"`
	// LastUpdateTime: Output only. The time at which the status was last updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Message: Output only. The latest deployed model's status message (if any).
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableReplicaCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableReplicaCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeployedModelStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeployedModelStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DeploymentResourcePool: A description of resources
// that can be shared by multiple DeployedModels, whose underlying
// specification consists of a DedicatedResources.
type GoogleCloudAiplatformV1DeploymentResourcePool struct {
	// CreateTime: Output only. Timestamp when this DeploymentResourcePool was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: Required. The underlying DedicatedResources that the
	// DeploymentResourcePool uses.
	DedicatedResources *GoogleCloudAiplatformV1DedicatedResources `json:"dedicatedResources,omitempty"`
	// DisableContainerLogging: If the DeploymentResourcePool is deployed with
	// custom-trained Models or AutoML Tabular Models, the container(s) of the
	// DeploymentResourcePool will send `stderr` and `stdout` streams to Cloud
	// Logging by default. Please note that the logs incur cost, which are subject
	// to Cloud Logging pricing (https://cloud.google.com/logging/pricing). User
	// can disable container logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for a
	// DeploymentResourcePool. If set, this DeploymentResourcePool will be secured
	// by this key. Endpoints and the DeploymentResourcePool they deploy in need to
	// have the same EncryptionSpec.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Name: Immutable. The resource name of the DeploymentResourcePool. Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_
	// resource_pool}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceAccount: The service account that the DeploymentResourcePool's
	// container(s) run as. Specify the email address of the service account. If
	// this service account is not specified, the container(s) run as a service
	// account that doesn't have access to the resource project. Users deploying
	// the Models to this DeploymentResourcePool must have the
	// `iam.serviceAccounts.actAs` permission on this service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DeploymentResourcePool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DeploymentResourcePool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1DestinationFeatureSetting struct {
	// DestinationField: Specify the field name in the export destination. If not
	// specified, Feature ID is used.
	DestinationField string `json:"destinationField,omitempty"`
	// FeatureId: Required. The ID of the Feature to apply the setting to.
	FeatureId string `json:"featureId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationField") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DestinationFeatureSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DestinationFeatureSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectPredictRequest: Request message for
// PredictionService.DirectPredict.
type GoogleCloudAiplatformV1DirectPredictRequest struct {
	// Inputs: The prediction input.
	Inputs []*GoogleCloudAiplatformV1Tensor `json:"inputs,omitempty"`
	// Parameters: The parameters that govern the prediction.
	Parameters *GoogleCloudAiplatformV1Tensor `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DirectPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectPredictRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectPredictResponse: Response message for
// PredictionService.DirectPredict.
type GoogleCloudAiplatformV1DirectPredictResponse struct {
	// Outputs: The prediction output.
	Outputs []*GoogleCloudAiplatformV1Tensor `json:"outputs,omitempty"`
	// Parameters: The parameters that govern the prediction.
	Parameters *GoogleCloudAiplatformV1Tensor `json:"parameters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Outputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DirectPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectPredictResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectRawPredictRequest: Request message for
// PredictionService.DirectRawPredict.
type GoogleCloudAiplatformV1DirectRawPredictRequest struct {
	// Input: The prediction input.
	Input string `json:"input,omitempty"`
	// MethodName: Fully qualified name of the API method being invoked to perform
	// predictions. Format: `/namespace.Service/Method/` Example:
	// `/tensorflow.serving.PredictionService/Predict`
	MethodName string `json:"methodName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Input") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Input") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DirectRawPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectRawPredictRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectRawPredictResponse: Response message for
// PredictionService.DirectRawPredict.
type GoogleCloudAiplatformV1DirectRawPredictResponse struct {
	// Output: The prediction output.
	Output string `json:"output,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Output") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Output") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DirectRawPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DirectRawPredictResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DirectUploadSource: The input content is encapsulated
// and uploaded in the request.
type GoogleCloudAiplatformV1DirectUploadSource struct {
}

// GoogleCloudAiplatformV1DiskSpec: Represents the spec of disk options.
type GoogleCloudAiplatformV1DiskSpec struct {
	// BootDiskSizeGb: Size in GB of the boot disk (default is 100GB).
	BootDiskSizeGb int64 `json:"bootDiskSizeGb,omitempty"`
	// BootDiskType: Type of the boot disk. For non-A3U machines, the default value
	// is "pd-ssd", for A3U machines, the default value is "hyperdisk-balanced".
	// Valid values: "pd-ssd" (Persistent Disk Solid State Drive), "pd-standard"
	// (Persistent Disk Hard Disk Drive) or "hyperdisk-balanced".
	BootDiskType string `json:"bootDiskType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootDiskSizeGb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootDiskSizeGb") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DiskSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DiskSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DnsPeeringConfig: DNS peering configuration. These
// configurations are used to create DNS peering zones in the Vertex tenant
// project VPC, enabling resolution of records within the specified domain
// hosted in the target network's Cloud DNS.
type GoogleCloudAiplatformV1DnsPeeringConfig struct {
	// Domain: Required. The DNS name suffix of the zone being peered to, e.g.,
	// "my-internal-domain.corp.". Must end with a dot.
	Domain string `json:"domain,omitempty"`
	// TargetNetwork: Required. The VPC network name in the target_project where
	// the DNS zone specified by 'domain' is visible.
	TargetNetwork string `json:"targetNetwork,omitempty"`
	// TargetProject: Required. The project ID hosting the Cloud DNS managed zone
	// that contains the 'domain'. The Vertex AI Service Agent requires the
	// dns.peer role on this project.
	TargetProject string `json:"targetProject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DnsPeeringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DnsPeeringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1DoubleArray: A list of double values.
type GoogleCloudAiplatformV1DoubleArray struct {
	// Values: A list of double values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DoubleArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DoubleArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1DoubleArray) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1DoubleArray
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudAiplatformV1DynamicRetrievalConfig: Describes the options to
// customize dynamic retrieval.
type GoogleCloudAiplatformV1DynamicRetrievalConfig struct {
	// DynamicThreshold: Optional. The threshold to be used in dynamic retrieval.
	// If not set, a system default value is used.
	DynamicThreshold float64 `json:"dynamicThreshold,omitempty"`
	// Mode: The mode of the predictor to be used in dynamic retrieval.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Always trigger retrieval.
	//   "MODE_DYNAMIC" - Run retrieval only when system decides it is necessary.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1DynamicRetrievalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1DynamicRetrievalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1DynamicRetrievalConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1DynamicRetrievalConfig
	var s1 struct {
		DynamicThreshold gensupport.JSONFloat64 `json:"dynamicThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DynamicThreshold = float64(s1.DynamicThreshold)
	return nil
}

// GoogleCloudAiplatformV1EmbedContentRequest: Request message for
// PredictionService.EmbedContent.
type GoogleCloudAiplatformV1EmbedContentRequest struct {
	// AutoTruncate: Optional. Whether to silently truncate the input content if
	// it's longer than the maximum sequence length.
	AutoTruncate bool `json:"autoTruncate,omitempty"`
	// Content: Required. Input content to be embedded. Required.
	Content *GoogleCloudAiplatformV1Content `json:"content,omitempty"`
	// OutputDimensionality: Optional. Optional reduced dimension for the output
	// embedding. If set, excessive values in the output embedding are truncated
	// from the end.
	OutputDimensionality int64 `json:"outputDimensionality,omitempty"`
	// TaskType: Optional. The task type of the embedding.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unset value, which will default to one of the other enum
	// values.
	//   "RETRIEVAL_QUERY" - Specifies the given text is a query in a
	// search/retrieval setting.
	//   "RETRIEVAL_DOCUMENT" - Specifies the given text is a document from the
	// corpus being searched.
	//   "SEMANTIC_SIMILARITY" - Specifies the given text will be used for STS.
	//   "CLASSIFICATION" - Specifies that the given text will be classified.
	//   "CLUSTERING" - Specifies that the embeddings will be used for clustering.
	//   "QUESTION_ANSWERING" - Specifies that the embeddings will be used for
	// question answering.
	//   "FACT_VERIFICATION" - Specifies that the embeddings will be used for fact
	// verification.
	//   "CODE_RETRIEVAL_QUERY" - Specifies that the embeddings will be used for
	// code retrieval.
	TaskType string `json:"taskType,omitempty"`
	// Title: Optional. An optional title for the text.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoTruncate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoTruncate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EmbedContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EmbedContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EmbedContentResponse: Response message for
// PredictionService.EmbedContent.
type GoogleCloudAiplatformV1EmbedContentResponse struct {
	// Embedding: The embedding generated from the input content.
	Embedding *GoogleCloudAiplatformV1EmbedContentResponseEmbedding `json:"embedding,omitempty"`
	// Truncated: Whether the input content was truncated before generating the
	// embedding.
	Truncated bool `json:"truncated,omitempty"`
	// UsageMetadata: Metadata about the response(s).
	UsageMetadata *GoogleCloudAiplatformV1UsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Embedding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Embedding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EmbedContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EmbedContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EmbedContentResponseEmbedding: A list of floats
// representing an embedding.
type GoogleCloudAiplatformV1EmbedContentResponseEmbedding struct {
	// Values: Embedding vector values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EmbedContentResponseEmbedding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EmbedContentResponseEmbedding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1EmbedContentResponseEmbedding) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1EmbedContentResponseEmbedding
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudAiplatformV1EncryptionSpec: Represents a customer-managed
// encryption key specification that can be applied to a Vertex AI resource.
type GoogleCloudAiplatformV1EncryptionSpec struct {
	// KmsKeyName: Required. Resource name of the Cloud KMS key used to protect the
	// resource. The Cloud KMS key must be in the same region as the resource. It
	// must have the format
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryp
	// to_key}`.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Endpoint: Models are deployed into it, and afterwards
// Endpoint is called to obtain predictions and explanations.
type GoogleCloudAiplatformV1Endpoint struct {
	// ClientConnectionConfig: Configurations that are applied to the endpoint for
	// online prediction.
	ClientConnectionConfig *GoogleCloudAiplatformV1ClientConnectionConfig `json:"clientConnectionConfig,omitempty"`
	// CreateTime: Output only. Timestamp when this Endpoint was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedEndpointDns: Output only. DNS of the dedicated endpoint. Will only
	// be populated if dedicated_endpoint_enabled is true. Depending on the
	// features enabled, uid might be a random number or a string. For example, if
	// fast_tryout is enabled, uid will be fasttryout. Format:
	// `https://{endpoint_id}.{region}-{uid}.prediction.vertexai.goog`.
	DedicatedEndpointDns string `json:"dedicatedEndpointDns,omitempty"`
	// DedicatedEndpointEnabled: If true, the endpoint will be exposed through a
	// dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to the
	// dedicated DNS will be isolated from other users' traffic and will have
	// better performance and reliability. Note: Once you enabled dedicated
	// endpoint, you won't be able to send request to the shared DNS
	// {region}-aiplatform.googleapis.com. The limitation will be removed soon.
	DedicatedEndpointEnabled bool `json:"dedicatedEndpointEnabled,omitempty"`
	// DeployedModels: Output only. The models deployed in this Endpoint. To add or
	// remove DeployedModels use EndpointService.DeployModel and
	// EndpointService.UndeployModel respectively.
	DeployedModels []*GoogleCloudAiplatformV1DeployedModel `json:"deployedModels,omitempty"`
	// Description: The description of the Endpoint.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the Endpoint. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EnablePrivateServiceConnect: Deprecated: If true, expose the Endpoint via
	// private service connect. Only one of the fields, network or
	// enable_private_service_connect, can be set.
	EnablePrivateServiceConnect bool `json:"enablePrivateServiceConnect,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for an Endpoint. If
	// set, this Endpoint and all sub-resources of this Endpoint will be secured by
	// this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// GdcConfig: Configures the Google Distributed Cloud (GDC) environment for
	// online prediction. Only set this field when the Endpoint is to be deployed
	// in a GDC environment.
	GdcConfig *GoogleCloudAiplatformV1GdcConfig `json:"gdcConfig,omitempty"`
	// GenAiAdvancedFeaturesConfig: Optional. Configuration for
	// GenAiAdvancedFeatures. If the endpoint is serving GenAI models, advanced
	// features like native RAG integration can be configured. Currently, only
	// Model Garden models are supported.
	GenAiAdvancedFeaturesConfig *GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig `json:"genAiAdvancedFeaturesConfig,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Endpoints.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// ModelDeploymentMonitoringJob: Output only. Resource name of the Model
	// Monitoring job associated with this Endpoint if monitoring is enabled by
	// JobService.CreateModelDeploymentMonitoringJob. Format:
	// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model
	// _deployment_monitoring_job}`
	ModelDeploymentMonitoringJob string `json:"modelDeploymentMonitoringJob,omitempty"`
	// Name: Identifier. The resource name of the Endpoint.
	Name string `json:"name,omitempty"`
	// Network: Optional. The full name of the Google Compute Engine network
	// (https://cloud.google.com//compute/docs/networks-and-firewalls#networks) to
	// which the Endpoint should be peered. Private services access must already be
	// configured for the network. If left unspecified, the Endpoint is not peered
	// with any network. Only one of the fields, network or
	// enable_private_service_connect, can be set. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`. Where `{project}` is a
	// project number, as in `12345`, and `{network}` is network name.
	Network string `json:"network,omitempty"`
	// PredictRequestResponseLoggingConfig: Configures the request-response logging
	// for online prediction.
	PredictRequestResponseLoggingConfig *GoogleCloudAiplatformV1PredictRequestResponseLoggingConfig `json:"predictRequestResponseLoggingConfig,omitempty"`
	// PrivateServiceConnectConfig: Optional. Configuration for private service
	// connect. network and private_service_connect_config are mutually exclusive.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// TrafficSplit: A map from a DeployedModel's ID to the percentage of this
	// Endpoint's traffic that should be forwarded to that DeployedModel. If a
	// DeployedModel's ID is not listed in this map, then it receives no traffic.
	// The traffic percentage values must add up to 100, or map must be empty if
	// the Endpoint is to not accept any traffic at a moment.
	TrafficSplit map[string]int64 `json:"trafficSplit,omitempty"`
	// UpdateTime: Output only. Timestamp when this Endpoint was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientConnectionConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientConnectionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Endpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EnterpriseWebSearch: Tool to search public web data,
// powered by Vertex AI Search and Sec4 compliance.
type GoogleCloudAiplatformV1EnterpriseWebSearch struct {
	// BlockingConfidence: Optional. Sites with confidence level chosen & above
	// this value will be blocked from the search results.
	//
	// Possible values:
	//   "PHISH_BLOCK_THRESHOLD_UNSPECIFIED" - Defaults to unspecified.
	//   "BLOCK_LOW_AND_ABOVE" - Blocks Low and above confidence URL that is risky.
	//   "BLOCK_MEDIUM_AND_ABOVE" - Blocks Medium and above confidence URL that is
	// risky.
	//   "BLOCK_HIGH_AND_ABOVE" - Blocks High and above confidence URL that is
	// risky.
	//   "BLOCK_HIGHER_AND_ABOVE" - Blocks Higher and above confidence URL that is
	// risky.
	//   "BLOCK_VERY_HIGH_AND_ABOVE" - Blocks Very high and above confidence URL
	// that is risky.
	//   "BLOCK_ONLY_EXTREMELY_HIGH" - Blocks Extremely high confidence URL that is
	// risky.
	BlockingConfidence string `json:"blockingConfidence,omitempty"`
	// ExcludeDomains: Optional. List of domains to be excluded from the search
	// results. The default limit is 2000 domains.
	ExcludeDomains []string `json:"excludeDomains,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockingConfidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingConfidence") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EnterpriseWebSearch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EnterpriseWebSearch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EntityIdSelector: Selector for entityId. Getting ids
// from the given source.
type GoogleCloudAiplatformV1EntityIdSelector struct {
	// CsvSource: Source of Csv
	CsvSource *GoogleCloudAiplatformV1CsvSource `json:"csvSource,omitempty"`
	// EntityIdField: Source column that holds entity IDs. If not provided, entity
	// IDs are extracted from the column named entity_id.
	EntityIdField string `json:"entityIdField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CsvSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CsvSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EntityIdSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EntityIdSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EntityType: An entity type is a type of object in a
// system that needs to be modeled and have stored information about. For
// example, driver is an entity type, and driver0 is an instance of an entity
// type driver.
type GoogleCloudAiplatformV1EntityType struct {
	// CreateTime: Output only. Timestamp when this EntityType was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the EntityType.
	Description string `json:"description,omitempty"`
	// Etag: Optional. Used to perform a consistent read-modify-write updates. If
	// not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// EntityTypes. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one EntityType (System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// MonitoringConfig: Optional. The default monitoring configuration for all
	// Features with value type (Feature.ValueType) BOOL, STRING, DOUBLE or INT64
	// under this EntityType. If this is populated with
	// [FeaturestoreMonitoringConfig.monitoring_interval] specified, snapshot
	// analysis monitoring is enabled. Otherwise, snapshot analysis monitoring is
	// disabled.
	MonitoringConfig *GoogleCloudAiplatformV1FeaturestoreMonitoringConfig `json:"monitoringConfig,omitempty"`
	// Name: Immutable. Name of the EntityType. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityT
	// ypes/{entity_type}` The last part entity_type is assigned by the client. The
	// entity_type can be up to 64 characters long and can consist only of ASCII
	// Latin letters A-Z and a-z and underscore(_), and ASCII digits 0-9 starting
	// with a letter. The value will be unique given a featurestore.
	Name string `json:"name,omitempty"`
	// OfflineStorageTtlDays: Optional. Config for data retention policy in offline
	// storage. TTL in days for feature values that will be stored in offline
	// storage. The Feature Store offline storage periodically removes obsolete
	// feature values older than `offline_storage_ttl_days` since the feature
	// generation time. If unset (or explicitly set to 0), default to 4000 days
	// TTL.
	OfflineStorageTtlDays int64 `json:"offlineStorageTtlDays,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this EntityType was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EnvVar: Represents an environment variable present in
// a Container or Python Module.
type GoogleCloudAiplatformV1EnvVar struct {
	// Name: Required. Name of the environment variable. Must be a valid C
	// identifier.
	Name string `json:"name,omitempty"`
	// Value: Required. Variables that reference a $(VAR_NAME) are expanded using
	// the previous defined environment variables in the container and any service
	// environment variables. If a variable cannot be resolved, the reference in
	// the input string will be unchanged. The $(VAR_NAME) syntax can be escaped
	// with a double $$, ie: $$(VAR_NAME). Escaped references will never be
	// expanded, regardless of whether the variable exists or not.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EnvVar
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ErrorAnalysisAnnotation: Model error analysis for
// each annotation.
type GoogleCloudAiplatformV1ErrorAnalysisAnnotation struct {
	// AttributedItems: Attributed items for a given annotation, typically
	// representing neighbors from the training sets constrained by the query type.
	AttributedItems []*GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem `json:"attributedItems,omitempty"`
	// OutlierScore: The outlier score of this annotated item. Usually defined as
	// the min of all distances from attributed items.
	OutlierScore float64 `json:"outlierScore,omitempty"`
	// OutlierThreshold: The threshold used to determine if this annotation is an
	// outlier or not.
	OutlierThreshold float64 `json:"outlierThreshold,omitempty"`
	// QueryType: The query type used for finding the attributed items.
	//
	// Possible values:
	//   "QUERY_TYPE_UNSPECIFIED" - Unspecified query type for model error
	// analysis.
	//   "ALL_SIMILAR" - Query similar samples across all classes in the dataset.
	//   "SAME_CLASS_SIMILAR" - Query similar samples from the same class of the
	// input sample.
	//   "SAME_CLASS_DISSIMILAR" - Query dissimilar samples from the same class of
	// the input sample.
	QueryType string `json:"queryType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributedItems") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributedItems") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ErrorAnalysisAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ErrorAnalysisAnnotation) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotation
	var s1 struct {
		OutlierScore     gensupport.JSONFloat64 `json:"outlierScore"`
		OutlierThreshold gensupport.JSONFloat64 `json:"outlierThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.OutlierScore = float64(s1.OutlierScore)
	s.OutlierThreshold = float64(s1.OutlierThreshold)
	return nil
}

// GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem: Attributed
// items for a given annotation, typically representing neighbors from the
// training sets constrained by the query type.
type GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem struct {
	// AnnotationResourceName: The unique ID for each annotation. Used by FE to
	// allocate the annotation in DB.
	AnnotationResourceName string `json:"annotationResourceName,omitempty"`
	// Distance: The distance of this item to the annotation.
	Distance float64 `json:"distance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationResourceName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ErrorAnalysisAnnotationAttributedItem
	var s1 struct {
		Distance gensupport.JSONFloat64 `json:"distance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	return nil
}

// GoogleCloudAiplatformV1EvaluateDatasetRequest: Request message for
// EvaluationService.EvaluateDataset.
type GoogleCloudAiplatformV1EvaluateDatasetRequest struct {
	// AutoraterConfig: Optional. Autorater config used for evaluation. Currently
	// only publisher Gemini models are supported. Format:
	// `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
	AutoraterConfig *GoogleCloudAiplatformV1AutoraterConfig `json:"autoraterConfig,omitempty"`
	// Dataset: Required. The dataset used for evaluation.
	Dataset *GoogleCloudAiplatformV1EvaluationDataset `json:"dataset,omitempty"`
	// Location: Required. The resource name of the Location to evaluate the
	// dataset. Format: `projects/{project}/locations/{location}`
	Location string `json:"location,omitempty"`
	// Metrics: Required. The metrics used for evaluation.
	Metrics []*GoogleCloudAiplatformV1Metric `json:"metrics,omitempty"`
	// OutputConfig: Required. Config for evaluation output.
	OutputConfig *GoogleCloudAiplatformV1OutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluateDatasetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluateDatasetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluateDatasetResponse: The results from an
// evaluation run performed by the EvaluationService.
type GoogleCloudAiplatformV1EvaluateDatasetResponse struct {
	// AggregationOutput: Output only. Aggregation statistics derived from results
	// of EvaluationService.
	AggregationOutput *GoogleCloudAiplatformV1AggregationOutput `json:"aggregationOutput,omitempty"`
	// OutputInfo: Output only. Output info for EvaluationService.
	OutputInfo *GoogleCloudAiplatformV1OutputInfo `json:"outputInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationOutput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluateDatasetResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluateDatasetResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluateInstancesRequest: Request message for
// EvaluationService.EvaluateInstances.
type GoogleCloudAiplatformV1EvaluateInstancesRequest struct {
	// AutoraterConfig: Optional. Autorater config used for evaluation.
	AutoraterConfig *GoogleCloudAiplatformV1AutoraterConfig `json:"autoraterConfig,omitempty"`
	// BleuInput: Instances and metric spec for bleu metric.
	BleuInput *GoogleCloudAiplatformV1BleuInput `json:"bleuInput,omitempty"`
	// CoherenceInput: Input for coherence metric.
	CoherenceInput *GoogleCloudAiplatformV1CoherenceInput `json:"coherenceInput,omitempty"`
	// CometInput: Translation metrics. Input for Comet metric.
	CometInput *GoogleCloudAiplatformV1CometInput `json:"cometInput,omitempty"`
	// ExactMatchInput: Auto metric instances. Instances and metric spec for exact
	// match metric.
	ExactMatchInput *GoogleCloudAiplatformV1ExactMatchInput `json:"exactMatchInput,omitempty"`
	// FluencyInput: LLM-based metric instance. General text generation metrics,
	// applicable to other categories. Input for fluency metric.
	FluencyInput *GoogleCloudAiplatformV1FluencyInput `json:"fluencyInput,omitempty"`
	// FulfillmentInput: Input for fulfillment metric.
	FulfillmentInput *GoogleCloudAiplatformV1FulfillmentInput `json:"fulfillmentInput,omitempty"`
	// GroundednessInput: Input for groundedness metric.
	GroundednessInput *GoogleCloudAiplatformV1GroundednessInput `json:"groundednessInput,omitempty"`
	// Instance: The instance to be evaluated.
	Instance *GoogleCloudAiplatformV1EvaluationInstance `json:"instance,omitempty"`
	// Location: Required. The resource name of the Location to evaluate the
	// instances. Format: `projects/{project}/locations/{location}`
	Location string `json:"location,omitempty"`
	// Metrics: The metrics used for evaluation. Currently, we only support
	// evaluating a single metric. If multiple metrics are provided, only the first
	// one will be evaluated.
	Metrics []*GoogleCloudAiplatformV1Metric `json:"metrics,omitempty"`
	// MetricxInput: Input for Metricx metric.
	MetricxInput *GoogleCloudAiplatformV1MetricxInput `json:"metricxInput,omitempty"`
	// PairwiseMetricInput: Input for pairwise metric.
	PairwiseMetricInput *GoogleCloudAiplatformV1PairwiseMetricInput `json:"pairwiseMetricInput,omitempty"`
	// PairwiseQuestionAnsweringQualityInput: Input for pairwise question answering
	// quality metric.
	PairwiseQuestionAnsweringQualityInput *GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityInput `json:"pairwiseQuestionAnsweringQualityInput,omitempty"`
	// PairwiseSummarizationQualityInput: Input for pairwise summarization quality
	// metric.
	PairwiseSummarizationQualityInput *GoogleCloudAiplatformV1PairwiseSummarizationQualityInput `json:"pairwiseSummarizationQualityInput,omitempty"`
	// PointwiseMetricInput: Input for pointwise metric.
	PointwiseMetricInput *GoogleCloudAiplatformV1PointwiseMetricInput `json:"pointwiseMetricInput,omitempty"`
	// QuestionAnsweringCorrectnessInput: Input for question answering correctness
	// metric.
	QuestionAnsweringCorrectnessInput *GoogleCloudAiplatformV1QuestionAnsweringCorrectnessInput `json:"questionAnsweringCorrectnessInput,omitempty"`
	// QuestionAnsweringHelpfulnessInput: Input for question answering helpfulness
	// metric.
	QuestionAnsweringHelpfulnessInput *GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessInput `json:"questionAnsweringHelpfulnessInput,omitempty"`
	// QuestionAnsweringQualityInput: Input for question answering quality metric.
	QuestionAnsweringQualityInput *GoogleCloudAiplatformV1QuestionAnsweringQualityInput `json:"questionAnsweringQualityInput,omitempty"`
	// QuestionAnsweringRelevanceInput: Input for question answering relevance
	// metric.
	QuestionAnsweringRelevanceInput *GoogleCloudAiplatformV1QuestionAnsweringRelevanceInput `json:"questionAnsweringRelevanceInput,omitempty"`
	// RougeInput: Instances and metric spec for rouge metric.
	RougeInput *GoogleCloudAiplatformV1RougeInput `json:"rougeInput,omitempty"`
	// RubricBasedInstructionFollowingInput: Rubric Based Instruction Following
	// metric.
	RubricBasedInstructionFollowingInput *GoogleCloudAiplatformV1RubricBasedInstructionFollowingInput `json:"rubricBasedInstructionFollowingInput,omitempty"`
	// SafetyInput: Input for safety metric.
	SafetyInput *GoogleCloudAiplatformV1SafetyInput `json:"safetyInput,omitempty"`
	// SummarizationHelpfulnessInput: Input for summarization helpfulness metric.
	SummarizationHelpfulnessInput *GoogleCloudAiplatformV1SummarizationHelpfulnessInput `json:"summarizationHelpfulnessInput,omitempty"`
	// SummarizationQualityInput: Input for summarization quality metric.
	SummarizationQualityInput *GoogleCloudAiplatformV1SummarizationQualityInput `json:"summarizationQualityInput,omitempty"`
	// SummarizationVerbosityInput: Input for summarization verbosity metric.
	SummarizationVerbosityInput *GoogleCloudAiplatformV1SummarizationVerbosityInput `json:"summarizationVerbosityInput,omitempty"`
	// ToolCallValidInput: Tool call metric instances. Input for tool call valid
	// metric.
	ToolCallValidInput *GoogleCloudAiplatformV1ToolCallValidInput `json:"toolCallValidInput,omitempty"`
	// ToolNameMatchInput: Input for tool name match metric.
	ToolNameMatchInput *GoogleCloudAiplatformV1ToolNameMatchInput `json:"toolNameMatchInput,omitempty"`
	// ToolParameterKeyMatchInput: Input for tool parameter key match metric.
	ToolParameterKeyMatchInput *GoogleCloudAiplatformV1ToolParameterKeyMatchInput `json:"toolParameterKeyMatchInput,omitempty"`
	// ToolParameterKvMatchInput: Input for tool parameter key value match metric.
	ToolParameterKvMatchInput *GoogleCloudAiplatformV1ToolParameterKVMatchInput `json:"toolParameterKvMatchInput,omitempty"`
	// TrajectoryAnyOrderMatchInput: Input for trajectory match any order metric.
	TrajectoryAnyOrderMatchInput *GoogleCloudAiplatformV1TrajectoryAnyOrderMatchInput `json:"trajectoryAnyOrderMatchInput,omitempty"`
	// TrajectoryExactMatchInput: Input for trajectory exact match metric.
	TrajectoryExactMatchInput *GoogleCloudAiplatformV1TrajectoryExactMatchInput `json:"trajectoryExactMatchInput,omitempty"`
	// TrajectoryInOrderMatchInput: Input for trajectory in order match metric.
	TrajectoryInOrderMatchInput *GoogleCloudAiplatformV1TrajectoryInOrderMatchInput `json:"trajectoryInOrderMatchInput,omitempty"`
	// TrajectoryPrecisionInput: Input for trajectory precision metric.
	TrajectoryPrecisionInput *GoogleCloudAiplatformV1TrajectoryPrecisionInput `json:"trajectoryPrecisionInput,omitempty"`
	// TrajectoryRecallInput: Input for trajectory recall metric.
	TrajectoryRecallInput *GoogleCloudAiplatformV1TrajectoryRecallInput `json:"trajectoryRecallInput,omitempty"`
	// TrajectorySingleToolUseInput: Input for trajectory single tool use metric.
	TrajectorySingleToolUseInput *GoogleCloudAiplatformV1TrajectorySingleToolUseInput `json:"trajectorySingleToolUseInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluateInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluateInstancesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluateInstancesResponse: Response message for
// EvaluationService.EvaluateInstances.
type GoogleCloudAiplatformV1EvaluateInstancesResponse struct {
	// BleuResults: Results for bleu metric.
	BleuResults *GoogleCloudAiplatformV1BleuResults `json:"bleuResults,omitempty"`
	// CoherenceResult: Result for coherence metric.
	CoherenceResult *GoogleCloudAiplatformV1CoherenceResult `json:"coherenceResult,omitempty"`
	// CometResult: Translation metrics. Result for Comet metric.
	CometResult *GoogleCloudAiplatformV1CometResult `json:"cometResult,omitempty"`
	// ExactMatchResults: Auto metric evaluation results. Results for exact match
	// metric.
	ExactMatchResults *GoogleCloudAiplatformV1ExactMatchResults `json:"exactMatchResults,omitempty"`
	// FluencyResult: LLM-based metric evaluation result. General text generation
	// metrics, applicable to other categories. Result for fluency metric.
	FluencyResult *GoogleCloudAiplatformV1FluencyResult `json:"fluencyResult,omitempty"`
	// FulfillmentResult: Result for fulfillment metric.
	FulfillmentResult *GoogleCloudAiplatformV1FulfillmentResult `json:"fulfillmentResult,omitempty"`
	// GroundednessResult: Result for groundedness metric.
	GroundednessResult *GoogleCloudAiplatformV1GroundednessResult `json:"groundednessResult,omitempty"`
	// MetricResults: Metric results for each instance. The order of the metric
	// results is guaranteed to be the same as the order of the instances in the
	// request.
	MetricResults []*GoogleCloudAiplatformV1MetricResult `json:"metricResults,omitempty"`
	// MetricxResult: Result for Metricx metric.
	MetricxResult *GoogleCloudAiplatformV1MetricxResult `json:"metricxResult,omitempty"`
	// PairwiseMetricResult: Result for pairwise metric.
	PairwiseMetricResult *GoogleCloudAiplatformV1PairwiseMetricResult `json:"pairwiseMetricResult,omitempty"`
	// PairwiseQuestionAnsweringQualityResult: Result for pairwise question
	// answering quality metric.
	PairwiseQuestionAnsweringQualityResult *GoogleCloudAiplatformV1PairwiseQuestionAnsweringQualityResult `json:"pairwiseQuestionAnsweringQualityResult,omitempty"`
	// PairwiseSummarizationQualityResult: Result for pairwise summarization
	// quality metric.
	PairwiseSummarizationQualityResult *GoogleCloudAiplatformV1PairwiseSummarizationQualityResult `json:"pairwiseSummarizationQualityResult,omitempty"`
	// PointwiseMetricResult: Generic metrics. Result for pointwise metric.
	PointwiseMetricResult *GoogleCloudAiplatformV1PointwiseMetricResult `json:"pointwiseMetricResult,omitempty"`
	// QuestionAnsweringCorrectnessResult: Result for question answering
	// correctness metric.
	QuestionAnsweringCorrectnessResult *GoogleCloudAiplatformV1QuestionAnsweringCorrectnessResult `json:"questionAnsweringCorrectnessResult,omitempty"`
	// QuestionAnsweringHelpfulnessResult: Result for question answering
	// helpfulness metric.
	QuestionAnsweringHelpfulnessResult *GoogleCloudAiplatformV1QuestionAnsweringHelpfulnessResult `json:"questionAnsweringHelpfulnessResult,omitempty"`
	// QuestionAnsweringQualityResult: Question answering only metrics. Result for
	// question answering quality metric.
	QuestionAnsweringQualityResult *GoogleCloudAiplatformV1QuestionAnsweringQualityResult `json:"questionAnsweringQualityResult,omitempty"`
	// QuestionAnsweringRelevanceResult: Result for question answering relevance
	// metric.
	QuestionAnsweringRelevanceResult *GoogleCloudAiplatformV1QuestionAnsweringRelevanceResult `json:"questionAnsweringRelevanceResult,omitempty"`
	// RougeResults: Results for rouge metric.
	RougeResults *GoogleCloudAiplatformV1RougeResults `json:"rougeResults,omitempty"`
	// RubricBasedInstructionFollowingResult: Result for rubric based instruction
	// following metric.
	RubricBasedInstructionFollowingResult *GoogleCloudAiplatformV1RubricBasedInstructionFollowingResult `json:"rubricBasedInstructionFollowingResult,omitempty"`
	// SafetyResult: Result for safety metric.
	SafetyResult *GoogleCloudAiplatformV1SafetyResult `json:"safetyResult,omitempty"`
	// SummarizationHelpfulnessResult: Result for summarization helpfulness metric.
	SummarizationHelpfulnessResult *GoogleCloudAiplatformV1SummarizationHelpfulnessResult `json:"summarizationHelpfulnessResult,omitempty"`
	// SummarizationQualityResult: Summarization only metrics. Result for
	// summarization quality metric.
	SummarizationQualityResult *GoogleCloudAiplatformV1SummarizationQualityResult `json:"summarizationQualityResult,omitempty"`
	// SummarizationVerbosityResult: Result for summarization verbosity metric.
	SummarizationVerbosityResult *GoogleCloudAiplatformV1SummarizationVerbosityResult `json:"summarizationVerbosityResult,omitempty"`
	// ToolCallValidResults: Tool call metrics. Results for tool call valid metric.
	ToolCallValidResults *GoogleCloudAiplatformV1ToolCallValidResults `json:"toolCallValidResults,omitempty"`
	// ToolNameMatchResults: Results for tool name match metric.
	ToolNameMatchResults *GoogleCloudAiplatformV1ToolNameMatchResults `json:"toolNameMatchResults,omitempty"`
	// ToolParameterKeyMatchResults: Results for tool parameter key match metric.
	ToolParameterKeyMatchResults *GoogleCloudAiplatformV1ToolParameterKeyMatchResults `json:"toolParameterKeyMatchResults,omitempty"`
	// ToolParameterKvMatchResults: Results for tool parameter key value match
	// metric.
	ToolParameterKvMatchResults *GoogleCloudAiplatformV1ToolParameterKVMatchResults `json:"toolParameterKvMatchResults,omitempty"`
	// TrajectoryAnyOrderMatchResults: Result for trajectory any order match
	// metric.
	TrajectoryAnyOrderMatchResults *GoogleCloudAiplatformV1TrajectoryAnyOrderMatchResults `json:"trajectoryAnyOrderMatchResults,omitempty"`
	// TrajectoryExactMatchResults: Result for trajectory exact match metric.
	TrajectoryExactMatchResults *GoogleCloudAiplatformV1TrajectoryExactMatchResults `json:"trajectoryExactMatchResults,omitempty"`
	// TrajectoryInOrderMatchResults: Result for trajectory in order match metric.
	TrajectoryInOrderMatchResults *GoogleCloudAiplatformV1TrajectoryInOrderMatchResults `json:"trajectoryInOrderMatchResults,omitempty"`
	// TrajectoryPrecisionResults: Result for trajectory precision metric.
	TrajectoryPrecisionResults *GoogleCloudAiplatformV1TrajectoryPrecisionResults `json:"trajectoryPrecisionResults,omitempty"`
	// TrajectoryRecallResults: Results for trajectory recall metric.
	TrajectoryRecallResults *GoogleCloudAiplatformV1TrajectoryRecallResults `json:"trajectoryRecallResults,omitempty"`
	// TrajectorySingleToolUseResults: Results for trajectory single tool use
	// metric.
	TrajectorySingleToolUseResults *GoogleCloudAiplatformV1TrajectorySingleToolUseResults `json:"trajectorySingleToolUseResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BleuResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BleuResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluateInstancesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluateInstancesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluatedAnnotation: True positive, false positive,
// or false negative. EvaluatedAnnotation is only available under
// ModelEvaluationSlice with slice of `annotationSpec` dimension.
type GoogleCloudAiplatformV1EvaluatedAnnotation struct {
	// DataItemPayload: Output only. The data item payload that the Model predicted
	// this EvaluatedAnnotation on.
	DataItemPayload interface{} `json:"dataItemPayload,omitempty"`
	// ErrorAnalysisAnnotations: Annotations of model error analysis results.
	ErrorAnalysisAnnotations []*GoogleCloudAiplatformV1ErrorAnalysisAnnotation `json:"errorAnalysisAnnotations,omitempty"`
	// EvaluatedDataItemViewId: Output only. ID of the EvaluatedDataItemView under
	// the same ancestor ModelEvaluation. The EvaluatedDataItemView consists of all
	// ground truths and predictions on data_item_payload.
	EvaluatedDataItemViewId string `json:"evaluatedDataItemViewId,omitempty"`
	// Explanations: Explanations of predictions. Each element of the explanations
	// indicates the explanation for one explanation Method. The attributions list
	// in the EvaluatedAnnotationExplanation.explanation object corresponds to the
	// predictions list. For example, the second element in the attributions list
	// explains the second element in the predictions list.
	Explanations []*GoogleCloudAiplatformV1EvaluatedAnnotationExplanation `json:"explanations,omitempty"`
	// GroundTruths: Output only. The ground truth Annotations, i.e. the
	// Annotations that exist in the test data the Model is evaluated on. For true
	// positive, there is one and only one ground truth annotation, which matches
	// the only prediction in predictions. For false positive, there are zero or
	// more ground truth annotations that are similar to the only prediction in
	// predictions, but not enough for a match. For false negative, there is one
	// and only one ground truth annotation, which doesn't match any predictions
	// created by the model. The schema of the ground truth is stored in
	// ModelEvaluation.annotation_schema_uri
	GroundTruths []interface{} `json:"groundTruths,omitempty"`
	// Predictions: Output only. The model predicted annotations. For true
	// positive, there is one and only one prediction, which matches the only one
	// ground truth annotation in ground_truths. For false positive, there is one
	// and only one prediction, which doesn't match any ground truth annotation of
	// the corresponding data_item_view_id. For false negative, there are zero or
	// more predictions which are similar to the only ground truth annotation in
	// ground_truths but not enough for a match. The schema of the prediction is
	// stored in ModelEvaluation.annotation_schema_uri
	Predictions []interface{} `json:"predictions,omitempty"`
	// Type: Output only. Type of the EvaluatedAnnotation.
	//
	// Possible values:
	//   "EVALUATED_ANNOTATION_TYPE_UNSPECIFIED" - Invalid value.
	//   "TRUE_POSITIVE" - The EvaluatedAnnotation is a true positive. It has a
	// prediction created by the Model and a ground truth Annotation which the
	// prediction matches.
	//   "FALSE_POSITIVE" - The EvaluatedAnnotation is false positive. It has a
	// prediction created by the Model which does not match any ground truth
	// annotation.
	//   "FALSE_NEGATIVE" - The EvaluatedAnnotation is false negative. It has a
	// ground truth annotation which is not matched by any of the model created
	// predictions.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataItemPayload") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataItemPayload") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluatedAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluatedAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluatedAnnotationExplanation: Explanation result of
// the prediction produced by the Model.
type GoogleCloudAiplatformV1EvaluatedAnnotationExplanation struct {
	// Explanation: Explanation attribution response details.
	Explanation *GoogleCloudAiplatformV1Explanation `json:"explanation,omitempty"`
	// ExplanationType: Explanation type. For AutoML Image Classification models,
	// possible values are: * `image-integrated-gradients` * `image-xrai`
	ExplanationType string `json:"explanationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Explanation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Explanation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluatedAnnotationExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluatedAnnotationExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationDataset: The dataset used for evaluation.
type GoogleCloudAiplatformV1EvaluationDataset struct {
	// BigquerySource: BigQuery source holds the dataset.
	BigquerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigquerySource,omitempty"`
	// GcsSource: Cloud storage source holds the dataset. Currently only one Cloud
	// Storage file path is supported.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstance: A single instance to be
// evaluated. Instances are used to specify the input data for evaluation, from
// simple string comparisons to complex, multi-turn model evaluations
type GoogleCloudAiplatformV1EvaluationInstance struct {
	// AgentData: Optional. Data used for agent evaluation.
	AgentData *GoogleCloudAiplatformV1EvaluationInstanceAgentData `json:"agentData,omitempty"`
	// OtherData: Optional. Other data used to populate placeholders based on their
	// key.
	OtherData *GoogleCloudAiplatformV1EvaluationInstanceMapInstance `json:"otherData,omitempty"`
	// Prompt: Optional. Data used to populate placeholder `prompt` in a metric
	// prompt template.
	Prompt *GoogleCloudAiplatformV1EvaluationInstanceInstanceData `json:"prompt,omitempty"`
	// Reference: Optional. Data used to populate placeholder `reference` in a
	// metric prompt template.
	Reference *GoogleCloudAiplatformV1EvaluationInstanceInstanceData `json:"reference,omitempty"`
	// Response: Optional. Data used to populate placeholder `response` in a metric
	// prompt template.
	Response *GoogleCloudAiplatformV1EvaluationInstanceInstanceData `json:"response,omitempty"`
	// RubricGroups: Optional. Named groups of rubrics associated with the prompt.
	// This is used for rubric-based evaluations where rubrics can be referenced by
	// a key. The key could represent versions, associated metrics, etc.
	RubricGroups map[string]GoogleCloudAiplatformV1RubricGroup `json:"rubricGroups,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceAgentConfig: Configuration for an
// Agent.
type GoogleCloudAiplatformV1EvaluationInstanceAgentConfig struct {
	// DeveloperInstruction: Optional. A field containing instructions from the
	// developer for the agent.
	DeveloperInstruction *GoogleCloudAiplatformV1EvaluationInstanceInstanceData `json:"developerInstruction,omitempty"`
	// Tools: List of tools.
	Tools *GoogleCloudAiplatformV1EvaluationInstanceAgentConfigTools `json:"tools,omitempty"`
	// ToolsText: A JSON string containing a list of tools available to an agent
	// with info such as name, description, parameters and required parameters.
	ToolsText string `json:"toolsText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeveloperInstruction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeveloperInstruction") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceAgentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceAgentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceAgentConfigTools: Represents a list
// of tools for an agent.
type GoogleCloudAiplatformV1EvaluationInstanceAgentConfigTools struct {
	// Tool: Optional. List of tools: each tool can have multiple function
	// declarations.
	Tool []*GoogleCloudAiplatformV1Tool `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tool") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tool") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceAgentConfigTools) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceAgentConfigTools
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceAgentData: Contains data specific
// to agent evaluations.
type GoogleCloudAiplatformV1EvaluationInstanceAgentData struct {
	// AgentConfig: Optional. Agent configuration.
	AgentConfig *GoogleCloudAiplatformV1EvaluationInstanceAgentConfig `json:"agentConfig,omitempty"`
	// DeveloperInstruction: Optional. A field containing instructions from the
	// developer for the agent.
	DeveloperInstruction *GoogleCloudAiplatformV1EvaluationInstanceInstanceData `json:"developerInstruction,omitempty"`
	// Events: A list of events.
	Events *GoogleCloudAiplatformV1EvaluationInstanceAgentDataEvents `json:"events,omitempty"`
	// Tools: List of tools.
	Tools *GoogleCloudAiplatformV1EvaluationInstanceAgentDataTools `json:"tools,omitempty"`
	// ToolsText: A JSON string containing a list of tools available to an agent
	// with info such as name, description, parameters and required parameters.
	// Example: [ { "name": "search_actors", "description": "Search for actors in a
	// movie. Returns a list of actors, their roles, their birthdate, and their
	// place of birth.", "parameters": [ { "name": "movie_name", "description":
	// "The name of the movie." }, { "name": "character_name", "description": "The
	// name of the character." } ], "required": ["movie_name", "character_name"] }
	// ]
	ToolsText string `json:"toolsText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceAgentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceAgentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceAgentDataEvents: Represents a list
// of events for an agent.
type GoogleCloudAiplatformV1EvaluationInstanceAgentDataEvents struct {
	// Event: Optional. A list of events.
	Event []*GoogleCloudAiplatformV1Content `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceAgentDataEvents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceAgentDataEvents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceAgentDataTools: Represents a list
// of tools for an agent.
type GoogleCloudAiplatformV1EvaluationInstanceAgentDataTools struct {
	// Tool: Optional. List of tools: each tool can have multiple function
	// declarations.
	Tool []*GoogleCloudAiplatformV1Tool `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tool") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tool") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceAgentDataTools) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceAgentDataTools
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceInstanceData: Instance data used to
// populate placeholders in a metric prompt template.
type GoogleCloudAiplatformV1EvaluationInstanceInstanceData struct {
	// Contents: List of Gemini content data.
	Contents *GoogleCloudAiplatformV1EvaluationInstanceInstanceDataContents `json:"contents,omitempty"`
	// Text: Text data.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceInstanceData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceInstanceData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceInstanceDataContents: List of
// standard Content messages from Gemini API.
type GoogleCloudAiplatformV1EvaluationInstanceInstanceDataContents struct {
	// Contents: Optional. Repeated contents.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceInstanceDataContents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceInstanceDataContents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationInstanceMapInstance: Instance data
// specified as a map.
type GoogleCloudAiplatformV1EvaluationInstanceMapInstance struct {
	// MapInstance: Optional. Map of instance data.
	MapInstance map[string]GoogleCloudAiplatformV1EvaluationInstanceInstanceData `json:"mapInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MapInstance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MapInstance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationInstanceMapInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationInstanceMapInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationItem: EvaluationItem is a single evaluation
// request or result. The content of an EvaluationItem is immutable - it cannot
// be updated once created. EvaluationItems can be deleted when no longer
// needed.
type GoogleCloudAiplatformV1EvaluationItem struct {
	// CreateTime: Output only. Timestamp when this item was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the EvaluationItem.
	DisplayName string `json:"displayName,omitempty"`
	// Error: Output only. Error for the evaluation item.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// EvaluationItemType: Required. The type of the EvaluationItem.
	//
	// Possible values:
	//   "EVALUATION_ITEM_TYPE_UNSPECIFIED" - The default value. This value is
	// unused.
	//   "REQUEST" - The EvaluationItem is a request to evaluate.
	//   "RESULT" - The EvaluationItem is the result of evaluation.
	EvaluationItemType string `json:"evaluationItemType,omitempty"`
	// EvaluationRequest: The request to evaluate.
	EvaluationRequest *GoogleCloudAiplatformV1EvaluationRequest `json:"evaluationRequest,omitempty"`
	// EvaluationResponse: Output only. The response from evaluation.
	EvaluationResponse *GoogleCloudAiplatformV1EvaluationResult `json:"evaluationResponse,omitempty"`
	// GcsUri: The Cloud Storage object where the request or response is stored.
	GcsUri string `json:"gcsUri,omitempty"`
	// Labels: Optional. Labels for the EvaluationItem.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Optional. Metadata for the EvaluationItem.
	Metadata interface{} `json:"metadata,omitempty"`
	// Name: Identifier. The resource name of the EvaluationItem. Format:
	// `projects/{project}/locations/{location}/evaluationItems/{evaluation_item}`
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationPrompt: Prompt to be evaluated.
type GoogleCloudAiplatformV1EvaluationPrompt struct {
	// PromptTemplateData: Prompt template data.
	PromptTemplateData *GoogleCloudAiplatformV1EvaluationPromptPromptTemplateData `json:"promptTemplateData,omitempty"`
	// Text: Text prompt.
	Text string `json:"text,omitempty"`
	// Value: Fields and values that can be used to populate the prompt template.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PromptTemplateData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTemplateData") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationPrompt) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationPrompt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationPromptPromptTemplateData: Message to hold a
// prompt template and the values to populate the template.
type GoogleCloudAiplatformV1EvaluationPromptPromptTemplateData struct {
	// Values: The values for fields in the prompt template.
	Values map[string]GoogleCloudAiplatformV1Content `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationPromptPromptTemplateData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationPromptPromptTemplateData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRequest: Single evaluation request.
type GoogleCloudAiplatformV1EvaluationRequest struct {
	// CandidateResponses: Optional. Responses from model under test and other
	// baseline models for comparison.
	CandidateResponses []*GoogleCloudAiplatformV1CandidateResponse `json:"candidateResponses,omitempty"`
	// GoldenResponse: Optional. The Ideal response or ground truth.
	GoldenResponse *GoogleCloudAiplatformV1CandidateResponse `json:"goldenResponse,omitempty"`
	// Prompt: Required. The request/prompt to evaluate.
	Prompt *GoogleCloudAiplatformV1EvaluationPrompt `json:"prompt,omitempty"`
	// Rubrics: Optional. Named groups of rubrics associated with this prompt. The
	// key is a user-defined name for the rubric group.
	Rubrics map[string]GoogleCloudAiplatformV1RubricGroup `json:"rubrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateResponses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationResult: Evaluation result.
type GoogleCloudAiplatformV1EvaluationResult struct {
	// CandidateResults: Optional. The results for the metric.
	CandidateResults []*GoogleCloudAiplatformV1CandidateResult `json:"candidateResults,omitempty"`
	// EvaluationRequest: Required. The request item that was evaluated. Format:
	// projects/{project}/locations/{location}/evaluationItems/{evaluation_item}
	EvaluationRequest string `json:"evaluationRequest,omitempty"`
	// EvaluationRun: Required. The evaluation run that was used to generate the
	// result. Format:
	// projects/{project}/locations/{location}/evaluationRuns/{evaluation_run}
	EvaluationRun string `json:"evaluationRun,omitempty"`
	// Metadata: Optional. Metadata about the evaluation result.
	Metadata interface{} `json:"metadata,omitempty"`
	// Metric: Required. The metric that was evaluated.
	Metric string `json:"metric,omitempty"`
	// Request: Required. The request that was evaluated.
	Request *GoogleCloudAiplatformV1EvaluationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CandidateResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CandidateResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationResults: The results of the evaluation run.
type GoogleCloudAiplatformV1EvaluationResults struct {
	// EvaluationSet: The evaluation set where item level results are stored.
	EvaluationSet string `json:"evaluationSet,omitempty"`
	// SummaryMetrics: Optional. The summary metrics for the evaluation run.
	SummaryMetrics *GoogleCloudAiplatformV1SummaryMetrics `json:"summaryMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRubricConfig: Configuration for a rubric
// group to be generated/saved for evaluation.
type GoogleCloudAiplatformV1EvaluationRubricConfig struct {
	// PredefinedRubricGenerationSpec: Dynamically generate rubrics using a
	// predefined spec.
	PredefinedRubricGenerationSpec *GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec `json:"predefinedRubricGenerationSpec,omitempty"`
	// RubricGenerationSpec: Dynamically generate rubrics using this specification.
	RubricGenerationSpec *GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec `json:"rubricGenerationSpec,omitempty"`
	// RubricGroupKey: Required. The key used to save the generated rubrics. If a
	// generation spec is provided, this key will be used for the name of the
	// generated rubric group. Otherwise, this key will be used to look up the
	// existing rubric group on the evaluation item. Note that if a rubric group
	// key is specified on both a rubric config and an evaluation metric, the key
	// from the metric will be used to select the rubrics for evaluation.
	RubricGroupKey string `json:"rubricGroupKey,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PredefinedRubricGenerationSpec") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PredefinedRubricGenerationSpec")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRubricConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRubricConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRun: EvaluationRun is a resource that
// represents a single evaluation run, which includes a set of prompts, model
// responses, evaluation configuration and the resulting metrics.
type GoogleCloudAiplatformV1EvaluationRun struct {
	// CompletionTime: Output only. Time when the evaluation run was completed.
	CompletionTime string `json:"completionTime,omitempty"`
	// CreateTime: Output only. Time when the evaluation run was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: Required. The data source for the evaluation run.
	DataSource *GoogleCloudAiplatformV1EvaluationRunDataSource `json:"dataSource,omitempty"`
	// DisplayName: Required. The display name of the Evaluation Run.
	DisplayName string `json:"displayName,omitempty"`
	// Error: Output only. Only populated when the evaluation run's state is FAILED
	// or CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// EvaluationConfig: Required. The configuration used for the evaluation.
	EvaluationConfig *GoogleCloudAiplatformV1EvaluationRunEvaluationConfig `json:"evaluationConfig,omitempty"`
	// EvaluationResults: Output only. The results of the evaluation run. Only
	// populated when the evaluation run's state is SUCCEEDED.
	EvaluationResults *GoogleCloudAiplatformV1EvaluationResults `json:"evaluationResults,omitempty"`
	// EvaluationSetSnapshot: Output only. The specific evaluation set of the
	// evaluation run. For runs with an evaluation set input, this will be that
	// same set. For runs with BigQuery input, it's the sampled BigQuery dataset.
	EvaluationSetSnapshot string `json:"evaluationSetSnapshot,omitempty"`
	// InferenceConfigs: Optional. The candidate to inference config map for the
	// evaluation run. The candidate can be up to 128 characters long and can
	// consist of any UTF-8 characters.
	InferenceConfigs map[string]GoogleCloudAiplatformV1EvaluationRunInferenceConfig `json:"inferenceConfigs,omitempty"`
	// Labels: Optional. Labels for the evaluation run.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Optional. Metadata about the evaluation run, can be used by the
	// caller to store additional tracking information about the evaluation run.
	Metadata interface{} `json:"metadata,omitempty"`
	// Name: Identifier. The resource name of the EvaluationRun. This is a unique
	// identifier. Format:
	// `projects/{project}/locations/{location}/evaluationRuns/{evaluation_run}`
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the evaluation run.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "PENDING" - The evaluation run is pending.
	//   "RUNNING" - The evaluation run is running.
	//   "SUCCEEDED" - The evaluation run has succeeded.
	//   "FAILED" - The evaluation run has failed.
	//   "CANCELLED" - The evaluation run has been cancelled.
	//   "INFERENCE" - The evaluation run is performing inference.
	//   "GENERATING_RUBRICS" - The evaluation run is performing rubric generation.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompletionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRun) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRun
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunDataSource: The data source for the
// evaluation run.
type GoogleCloudAiplatformV1EvaluationRunDataSource struct {
	// BigqueryRequestSet: Evaluation data in bigquery.
	BigqueryRequestSet *GoogleCloudAiplatformV1BigQueryRequestSet `json:"bigqueryRequestSet,omitempty"`
	// EvaluationSet: The EvaluationSet resource name. Format:
	// `projects/{project}/locations/{location}/evaluationSets/{evaluation_set}`
	EvaluationSet string `json:"evaluationSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryRequestSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryRequestSet") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunEvaluationConfig: The Evalution
// configuration used for the evaluation run.
type GoogleCloudAiplatformV1EvaluationRunEvaluationConfig struct {
	// AutoraterConfig: Optional. The autorater config for the evaluation run.
	AutoraterConfig *GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig `json:"autoraterConfig,omitempty"`
	// Metrics: Required. The metrics to be calculated in the evaluation run.
	Metrics []*GoogleCloudAiplatformV1EvaluationRunMetric `json:"metrics,omitempty"`
	// OutputConfig: Optional. The output config for the evaluation run.
	OutputConfig *GoogleCloudAiplatformV1EvaluationRunEvaluationConfigOutputConfig `json:"outputConfig,omitempty"`
	// PromptTemplate: The prompt template used for inference. The values for
	// variables in the prompt template are defined in
	// EvaluationItem.EvaluationPrompt.PromptTemplateData.values.
	PromptTemplate *GoogleCloudAiplatformV1EvaluationRunEvaluationConfigPromptTemplate `json:"promptTemplate,omitempty"`
	// RubricConfigs: Optional. The rubric configs for the evaluation run. They are
	// used to generate rubrics which can be used by rubric-based metrics. Multiple
	// rubric configs can be specified for rubric generation but only one rubric
	// config can be used for a rubric-based metric. If more than one rubric config
	// is provided, the evaluation metric must specify a rubric group key. Note
	// that if a generation spec is specified on both a rubric config and an
	// evaluation metric, the rubrics generated for the metric will be used for
	// evaluation.
	RubricConfigs []*GoogleCloudAiplatformV1EvaluationRubricConfig `json:"rubricConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunEvaluationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunEvaluationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig: The
// autorater config used for the evaluation run.
type GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig struct {
	// AutoraterModel: Optional. The fully qualified name of the publisher model or
	// tuned autorater endpoint to use. Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*` Tuned model
	// endpoint format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	AutoraterModel string `json:"autoraterModel,omitempty"`
	// GenerationConfig: Optional. Configuration options for model generation and
	// outputs.
	GenerationConfig *GoogleCloudAiplatformV1GenerationConfig `json:"generationConfig,omitempty"`
	// SampleCount: Optional. Number of samples for each instance in the dataset.
	// If not specified, the default is 4. Minimum value is 1, maximum value is 32.
	SampleCount int64 `json:"sampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunEvaluationConfigOutputConfig: The output
// config for the evaluation run.
type GoogleCloudAiplatformV1EvaluationRunEvaluationConfigOutputConfig struct {
	// BigqueryDestination: BigQuery destination for evaluation output.
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: Cloud Storage destination for evaluation output.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunEvaluationConfigOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunEvaluationConfigOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunEvaluationConfigPromptTemplate: Prompt
// template used for inference.
type GoogleCloudAiplatformV1EvaluationRunEvaluationConfigPromptTemplate struct {
	// GcsUri: Prompt template stored in Cloud Storage. Format:
	// "gs://my-bucket/file-name.txt".
	GcsUri string `json:"gcsUri,omitempty"`
	// PromptTemplate: Inline prompt template. Template variables should be in the
	// format "{var_name}". Example: "Translate the following from {source_lang} to
	// {target_lang}: {text}"
	PromptTemplate string `json:"promptTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunEvaluationConfigPromptTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunEvaluationConfigPromptTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunInferenceConfig: An inference config
// used for model inference during the evaluation run.
type GoogleCloudAiplatformV1EvaluationRunInferenceConfig struct {
	// GenerationConfig: Optional. Generation config.
	GenerationConfig *GoogleCloudAiplatformV1GenerationConfig `json:"generationConfig,omitempty"`
	// Model: Optional. The fully qualified name of the publisher model or endpoint
	// to use. Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*` Endpoint
	// format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerationConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunInferenceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunInferenceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunMetric: The metric used for evaluation
// runs.
type GoogleCloudAiplatformV1EvaluationRunMetric struct {
	// LlmBasedMetricSpec: Spec for an LLM based metric.
	LlmBasedMetricSpec *GoogleCloudAiplatformV1EvaluationRunMetricLLMBasedMetricSpec `json:"llmBasedMetricSpec,omitempty"`
	// Metric: Required. The name of the metric.
	Metric string `json:"metric,omitempty"`
	// MetricConfig: The metric config.
	MetricConfig *GoogleCloudAiplatformV1Metric `json:"metricConfig,omitempty"`
	// PredefinedMetricSpec: Spec for a pre-defined metric.
	PredefinedMetricSpec *GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec `json:"predefinedMetricSpec,omitempty"`
	// RubricBasedMetricSpec: Spec for rubric based metric.
	RubricBasedMetricSpec *GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpec `json:"rubricBasedMetricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LlmBasedMetricSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LlmBasedMetricSpec") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunMetricLLMBasedMetricSpec: Specification
// for an LLM based metric.
type GoogleCloudAiplatformV1EvaluationRunMetricLLMBasedMetricSpec struct {
	// AdditionalConfig: Optional. Optional additional configuration for the
	// metric.
	AdditionalConfig googleapi.RawMessage `json:"additionalConfig,omitempty"`
	// JudgeAutoraterConfig: Optional. Optional configuration for the judge LLM
	// (Autorater).
	JudgeAutoraterConfig *GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig `json:"judgeAutoraterConfig,omitempty"`
	// MetricPromptTemplate: Required. Template for the prompt sent to the judge
	// model.
	MetricPromptTemplate string `json:"metricPromptTemplate,omitempty"`
	// PredefinedRubricGenerationSpec: Dynamically generate rubrics using a
	// predefined spec.
	PredefinedRubricGenerationSpec *GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec `json:"predefinedRubricGenerationSpec,omitempty"`
	// RubricGenerationSpec: Dynamically generate rubrics using this specification.
	RubricGenerationSpec *GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec `json:"rubricGenerationSpec,omitempty"`
	// RubricGroupKey: Use a pre-defined group of rubrics associated with the
	// input. Refers to a key in the rubric_groups map of EvaluationInstance.
	RubricGroupKey string `json:"rubricGroupKey,omitempty"`
	// SystemInstruction: Optional. System instructions for the judge model.
	SystemInstruction string `json:"systemInstruction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunMetricLLMBasedMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunMetricLLMBasedMetricSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec:
// Specification for a pre-defined metric.
type GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec struct {
	// MetricSpecName: Required. The name of a pre-defined metric, such as
	// "instruction_following_v1" or "text_quality_v1".
	MetricSpecName string `json:"metricSpecName,omitempty"`
	// Parameters: Optional. The parameters needed to run the pre-defined metric.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricSpecName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricSpecName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunMetricPredefinedMetricSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpec:
// Specification for a metric that is based on rubrics.
type GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpec struct {
	// InlineRubrics: Use rubrics provided directly in the spec.
	InlineRubrics *GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpecRepeatedRubrics `json:"inlineRubrics,omitempty"`
	// JudgeAutoraterConfig: Optional. Optional configuration for the judge LLM
	// (Autorater). The definition of AutoraterConfig needs to be provided.
	JudgeAutoraterConfig *GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig `json:"judgeAutoraterConfig,omitempty"`
	// MetricPromptTemplate: Optional. Template for the prompt used by the judge
	// model to evaluate against rubrics.
	MetricPromptTemplate string `json:"metricPromptTemplate,omitempty"`
	// RubricGenerationSpec: Dynamically generate rubrics for evaluation using this
	// specification.
	RubricGenerationSpec *GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec `json:"rubricGenerationSpec,omitempty"`
	// RubricGroupKey: Use a pre-defined group of rubrics associated with the input
	// content. This refers to a key in the `rubric_groups` map of
	// `RubricEnhancedContents`.
	RubricGroupKey string `json:"rubricGroupKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InlineRubrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InlineRubrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpecRepeatedRubric
// s: Defines a list of rubrics, used when providing rubrics inline.
type GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpecRepeatedRubrics struct {
	// Rubrics: The list of rubrics.
	Rubrics []*GoogleCloudAiplatformV1Rubric `json:"rubrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Rubrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Rubrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpecRepeatedRubrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunMetricRubricBasedMetricSpecRepeatedRubrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec:
// Specification for how rubrics should be generated.
type GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec struct {
	// ModelConfig: Optional. Configuration for the model used in rubric
	// generation. Configs including sampling count and base model can be specified
	// here. Flipping is not supported for rubric generation.
	ModelConfig *GoogleCloudAiplatformV1EvaluationRunEvaluationConfigAutoraterConfig `json:"modelConfig,omitempty"`
	// PromptTemplate: Optional. Template for the prompt used to generate rubrics.
	// The details should be updated based on the most-recent recipe requirements.
	PromptTemplate string `json:"promptTemplate,omitempty"`
	// RubricContentType: Optional. The type of rubric content to be generated.
	//
	// Possible values:
	//   "RUBRIC_CONTENT_TYPE_UNSPECIFIED" - The content type to generate is not
	// specified.
	//   "PROPERTY" - Generate rubrics based on properties.
	//   "NL_QUESTION_ANSWER" - Generate rubrics in an NL question answer format.
	//   "PYTHON_CODE_ASSERTION" - Generate rubrics in a unit test format.
	RubricContentType string `json:"rubricContentType,omitempty"`
	// RubricTypeOntology: Optional. An optional, pre-defined list of allowed types
	// for generated rubrics. If this field is provided, it implies
	// `include_rubric_type` should be true, and the generated rubric types should
	// be chosen from this ontology.
	RubricTypeOntology []string `json:"rubricTypeOntology,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationRunMetricRubricGenerationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EvaluationSet: EvaluationSet is a collection of
// related EvaluationItems that are evaluated together.
type GoogleCloudAiplatformV1EvaluationSet struct {
	// CreateTime: Output only. Timestamp when this item was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the EvaluationSet.
	DisplayName string `json:"displayName,omitempty"`
	// EvaluationItems: Required. The EvaluationItems that are part of this
	// dataset.
	EvaluationItems []string `json:"evaluationItems,omitempty"`
	// Metadata: Optional. Metadata for the EvaluationSet.
	Metadata interface{} `json:"metadata,omitempty"`
	// Name: Identifier. The resource name of the EvaluationSet. Format:
	// `projects/{project}/locations/{location}/evaluationSets/{evaluation_set}`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when this item was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EvaluationSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EvaluationSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Event: An edge describing the relationship between an
// Artifact and an Execution in a lineage graph.
type GoogleCloudAiplatformV1Event struct {
	// Artifact: Required. The relative resource name of the Artifact in the Event.
	Artifact string `json:"artifact,omitempty"`
	// EventTime: Output only. Time the Event occurred.
	EventTime string `json:"eventTime,omitempty"`
	// Execution: Output only. The relative resource name of the Execution in the
	// Event.
	Execution string `json:"execution,omitempty"`
	// Labels: The labels with user-defined metadata to annotate Events. Label keys
	// and values can be no longer than 64 characters (Unicode codepoints), can
	// only contain lowercase letters, numeric characters, underscores and dashes.
	// International characters are allowed. No more than 64 user labels can be
	// associated with one Event (System labels are excluded). See
	// https://goo.gl/xmQnxf for more information and examples of labels. System
	// reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
	// immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Type: Required. The type of the Event.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified whether input or output of the Execution.
	//   "INPUT" - An input of the Execution.
	//   "OUTPUT" - An output of the Execution.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Artifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifact") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Event) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Event
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EventActions: Actions are parts of events that are
// executed by the agent.
type GoogleCloudAiplatformV1EventActions struct {
	// ArtifactDelta: Optional. Indicates that the event is updating an artifact.
	// key is the filename, value is the version.
	ArtifactDelta map[string]int64 `json:"artifactDelta,omitempty"`
	// Escalate: Optional. The agent is escalating to a higher level agent.
	Escalate bool `json:"escalate,omitempty"`
	// RequestedAuthConfigs: Optional. Will only be set by a tool response
	// indicating tool request euc. Struct key is the function call id since one
	// function call response (from model) could correspond to multiple function
	// calls. Struct value is the required auth config, which can be another
	// struct.
	RequestedAuthConfigs googleapi.RawMessage `json:"requestedAuthConfigs,omitempty"`
	// SkipSummarization: Optional. If true, it won't call model to summarize
	// function response. Only used for function_response event.
	SkipSummarization bool `json:"skipSummarization,omitempty"`
	// StateDelta: Optional. Indicates that the event is updating the state with
	// the given delta.
	StateDelta googleapi.RawMessage `json:"stateDelta,omitempty"`
	// TransferAgent: Optional. If set, the event transfers to the specified agent.
	TransferAgent string `json:"transferAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactDelta") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactDelta") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EventActions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EventActions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1EventMetadata: Metadata relating to a LLM response
// event.
type GoogleCloudAiplatformV1EventMetadata struct {
	// Branch: Optional. The branch of the event. The format is like
	// agent_1.agent_2.agent_3, where agent_1 is the parent of agent_2, and agent_2
	// is the parent of agent_3. Branch is used when multiple child agents
	// shouldn't see their siblings' conversation history.
	Branch string `json:"branch,omitempty"`
	// CustomMetadata: The custom metadata of the LlmResponse.
	CustomMetadata googleapi.RawMessage `json:"customMetadata,omitempty"`
	// GroundingMetadata: Optional. Metadata returned to client when grounding is
	// enabled.
	GroundingMetadata *GoogleCloudAiplatformV1GroundingMetadata `json:"groundingMetadata,omitempty"`
	// Interrupted: Optional. Flag indicating that LLM was interrupted when
	// generating the content. Usually it's due to user interruption during a bidi
	// streaming.
	Interrupted bool `json:"interrupted,omitempty"`
	// LongRunningToolIds: Optional. Set of ids of the long running function calls.
	// Agent client will know from this field about which function call is long
	// running. Only valid for function call event.
	LongRunningToolIds []string `json:"longRunningToolIds,omitempty"`
	// Partial: Optional. Indicates whether the text content is part of a
	// unfinished text stream. Only used for streaming mode and when the content is
	// plain text.
	Partial bool `json:"partial,omitempty"`
	// TurnComplete: Optional. Indicates whether the response from the model is
	// complete. Only used for streaming mode.
	TurnComplete bool `json:"turnComplete,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Branch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Branch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1EventMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1EventMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExactMatchInput: Input for exact match metric.
type GoogleCloudAiplatformV1ExactMatchInput struct {
	// Instances: Required. Repeated exact match instances.
	Instances []*GoogleCloudAiplatformV1ExactMatchInstance `json:"instances,omitempty"`
	// MetricSpec: Required. Spec for exact match metric.
	MetricSpec *GoogleCloudAiplatformV1ExactMatchSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExactMatchInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExactMatchInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExactMatchInstance: Spec for exact match instance.
type GoogleCloudAiplatformV1ExactMatchInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// Reference: Required. Ground truth used to compare against the prediction.
	Reference string `json:"reference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExactMatchInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExactMatchInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExactMatchMetricValue: Exact match metric value for
// an instance.
type GoogleCloudAiplatformV1ExactMatchMetricValue struct {
	// Score: Output only. Exact match score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExactMatchMetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExactMatchMetricValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExactMatchMetricValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExactMatchMetricValue
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1ExactMatchResults: Results for exact match metric.
type GoogleCloudAiplatformV1ExactMatchResults struct {
	// ExactMatchMetricValues: Output only. Exact match metric values.
	ExactMatchMetricValues []*GoogleCloudAiplatformV1ExactMatchMetricValue `json:"exactMatchMetricValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatchMetricValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatchMetricValues") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExactMatchResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExactMatchResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExactMatchSpec: Spec for exact match metric - returns
// 1 if prediction and reference exactly matches, otherwise 0.
type GoogleCloudAiplatformV1ExactMatchSpec struct {
}

// GoogleCloudAiplatformV1Examples: Example-based explainability that returns
// the nearest neighbors from the provided dataset.
type GoogleCloudAiplatformV1Examples struct {
	// ExampleGcsSource: The Cloud Storage input instances.
	ExampleGcsSource *GoogleCloudAiplatformV1ExamplesExampleGcsSource `json:"exampleGcsSource,omitempty"`
	// NearestNeighborSearchConfig: The full configuration for the generated index,
	// the semantics are the same as metadata and should match
	// NearestNeighborSearchConfig
	// (https://cloud.google.com/vertex-ai/docs/explainable-ai/configuring-explanations-example-based#nearest-neighbor-search-config).
	NearestNeighborSearchConfig interface{} `json:"nearestNeighborSearchConfig,omitempty"`
	// NeighborCount: The number of neighbors to return when querying for examples.
	NeighborCount int64 `json:"neighborCount,omitempty"`
	// Presets: Simplified preset configuration, which automatically sets
	// configuration values based on the desired query speed-precision trade-off
	// and modality.
	Presets *GoogleCloudAiplatformV1Presets `json:"presets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Examples) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Examples
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExamplesExampleGcsSource: The Cloud Storage input
// instances.
type GoogleCloudAiplatformV1ExamplesExampleGcsSource struct {
	// DataFormat: The format in which instances are given, if not specified,
	// assume it's JSONL format. Currently only JSONL format is supported.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Format unspecified, used when unset.
	//   "JSONL" - Examples are stored in JSONL files.
	DataFormat string `json:"dataFormat,omitempty"`
	// GcsSource: The Cloud Storage location for the input instances.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExamplesExampleGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExamplesExampleGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExamplesOverride: Overrides for example-based
// explanations.
type GoogleCloudAiplatformV1ExamplesOverride struct {
	// CrowdingCount: The number of neighbors to return that have the same crowding
	// tag.
	CrowdingCount int64 `json:"crowdingCount,omitempty"`
	// DataFormat: The format of the data being provided with each call.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format. Must not be used.
	//   "INSTANCES" - Provided data is a set of model inputs.
	//   "EMBEDDINGS" - Provided data is a set of embeddings.
	DataFormat string `json:"dataFormat,omitempty"`
	// NeighborCount: The number of neighbors to return.
	NeighborCount int64 `json:"neighborCount,omitempty"`
	// Restrictions: Restrict the resulting nearest neighbors to respect these
	// constraints.
	Restrictions []*GoogleCloudAiplatformV1ExamplesRestrictionsNamespace `json:"restrictions,omitempty"`
	// ReturnEmbeddings: If true, return the embeddings instead of neighbors.
	ReturnEmbeddings bool `json:"returnEmbeddings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrowdingCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrowdingCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExamplesOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExamplesOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExamplesRestrictionsNamespace: Restrictions namespace
// for example-based explanations overrides.
type GoogleCloudAiplatformV1ExamplesRestrictionsNamespace struct {
	// Allow: The list of allowed tags.
	Allow []string `json:"allow,omitempty"`
	// Deny: The list of deny tags.
	Deny []string `json:"deny,omitempty"`
	// NamespaceName: The namespace name.
	NamespaceName string `json:"namespaceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Allow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Allow") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExamplesRestrictionsNamespace) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExamplesRestrictionsNamespace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExecutableCode: Code generated by the model that is
// meant to be executed, and the result returned to the model. Generated when
// using the [CodeExecution] tool, in which the code will be automatically
// executed, and a corresponding [CodeExecutionResult] will also be generated.
type GoogleCloudAiplatformV1ExecutableCode struct {
	// Code: Required. The code to be executed.
	Code string `json:"code,omitempty"`
	// Language: Required. Programming language of the `code`.
	//
	// Possible values:
	//   "LANGUAGE_UNSPECIFIED" - Unspecified language. This value should not be
	// used.
	//   "PYTHON" - Python >= 3.10, with numpy and simpy available.
	Language string `json:"language,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExecutableCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExecutableCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExecuteCodeRequest: Request message for
// SandboxEnvironmentExecutionService.ExecuteCode.
type GoogleCloudAiplatformV1ExecuteCodeRequest struct {
	// Inputs: Required. The inputs used for the stateless code execution.
	Inputs []*GoogleCloudAiplatformV1Chunk `json:"inputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExecuteCodeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExecuteCodeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExecuteCodeResponse: Response message for
// SandboxEnvironmentExecutionService.ExecuteCode.
type GoogleCloudAiplatformV1ExecuteCodeResponse struct {
	// Outputs: The outputs from the sandbox environment.
	Outputs []*GoogleCloudAiplatformV1Chunk `json:"outputs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Outputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExecuteCodeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExecuteCodeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExecuteSandboxEnvironmentRequest: Request message for
// SandboxEnvironmentExecutionService.Execute.
type GoogleCloudAiplatformV1ExecuteSandboxEnvironmentRequest struct {
	// Inputs: Required. The inputs to the sandbox environment.
	Inputs []*GoogleCloudAiplatformV1Chunk `json:"inputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExecuteSandboxEnvironmentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExecuteSandboxEnvironmentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExecuteSandboxEnvironmentResponse: Response message
// for SandboxEnvironmentExecutionService.Execute.
type GoogleCloudAiplatformV1ExecuteSandboxEnvironmentResponse struct {
	// Outputs: The outputs from the sandbox environment.
	Outputs []*GoogleCloudAiplatformV1Chunk `json:"outputs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Outputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExecuteSandboxEnvironmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExecuteSandboxEnvironmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Execution: Instance of a general execution.
type GoogleCloudAiplatformV1Execution struct {
	// CreateTime: Output only. Timestamp when this Execution was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Execution
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Execution. May be up to 128
	// Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An eTag used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Executions.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Execution (System labels are
	// excluded).
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Properties of the Execution. Top level metadata keys' heading and
	// trailing spaces will be trimmed. The size of this field should not exceed
	// 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Output only. The resource name of the Execution.
	Name string `json:"name,omitempty"`
	// SchemaTitle: The title of the schema describing the metadata. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaVersion: The version of the schema in `schema_title` to use. Schema
	// title and version is expected to be registered in earlier Create Schema
	// calls. And both are used together as unique identifiers to identify schemas
	// within the local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// State: The state of this Execution. This is a property of the Execution, and
	// does not imply or capture any ongoing process. This property is managed by
	// clients (such as Vertex AI Pipelines) and the system does not prescribe or
	// check the validity of state transitions.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Execution state
	//   "NEW" - The Execution is new
	//   "RUNNING" - The Execution is running
	//   "COMPLETE" - The Execution has finished running
	//   "FAILED" - The Execution has failed
	//   "CACHED" - The Execution completed through Cache hit.
	//   "CANCELLED" - The Execution was cancelled.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this Execution was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Execution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Execution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplainRequest: Request message for
// PredictionService.Explain.
type GoogleCloudAiplatformV1ExplainRequest struct {
	// DeployedModelId: If specified, this ExplainRequest will be served by the
	// chosen DeployedModel, overriding Endpoint.traffic_split.
	DeployedModelId string `json:"deployedModelId,omitempty"`
	// ExplanationSpecOverride: If specified, overrides the explanation_spec of the
	// DeployedModel. Can be used for explaining prediction results with different
	// configurations, such as: - Explaining top-5 predictions results as opposed
	// to top-1; - Increasing path count or step count of the attribution methods
	// to reduce approximate errors; - Using different baselines for explaining the
	// prediction results.
	ExplanationSpecOverride *GoogleCloudAiplatformV1ExplanationSpecOverride `json:"explanationSpecOverride,omitempty"`
	// Instances: Required. The instances that are the input to the explanation
	// call. A DeployedModel may have an upper limit on the number of instances it
	// supports per request, and when it is exceeded the explanation call errors in
	// case of AutoML Models, or, in case of customer created Models, the behaviour
	// is as documented by that Model. The schema of any single instance may be
	// specified via Endpoint's DeployedModels' Model's PredictSchemata's
	// instance_schema_uri.
	Instances []interface{} `json:"instances,omitempty"`
	// Parameters: The parameters that govern the prediction. The schema of the
	// parameters may be specified via Endpoint's DeployedModels' Model's
	// PredictSchemata's parameters_schema_uri.
	Parameters interface{} `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModelId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplainRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplainRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplainResponse: Response message for
// PredictionService.Explain.
type GoogleCloudAiplatformV1ExplainResponse struct {
	// DeployedModelId: ID of the Endpoint's DeployedModel that served this
	// explanation.
	DeployedModelId string `json:"deployedModelId,omitempty"`
	// Explanations: The explanations of the Model's PredictResponse.predictions.
	// It has the same number of elements as instances to be explained.
	Explanations []*GoogleCloudAiplatformV1Explanation `json:"explanations,omitempty"`
	// Predictions: The predictions that are the output of the predictions call.
	// Same as PredictResponse.predictions.
	Predictions []interface{} `json:"predictions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModelId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplainResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplainResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Explanation: Explanation of a prediction (provided in
// PredictResponse.predictions) produced by the Model on a given instance.
type GoogleCloudAiplatformV1Explanation struct {
	// Attributions: Output only. Feature attributions grouped by predicted
	// outputs. For Models that predict only one output, such as regression Models
	// that predict only one score, there is only one attibution that explains the
	// predicted output. For Models that predict multiple outputs, such as
	// multiclass Models that predict multiple classes, each element explains one
	// specific item. Attribution.output_index can be used to identify which output
	// this attribution is explaining. By default, we provide Shapley values for
	// the predicted class. However, you can configure the explanation request to
	// generate Shapley values for any other classes too. For example, if a model
	// predicts a probability of `0.4` for approving a loan application, the
	// model's decision is to reject the application since `p(reject) = 0.6 >
	// p(approve) = 0.4`, and the default Shapley values would be computed for
	// rejection decision and not approval, even though the latter might be the
	// positive class. If users set ExplanationParameters.top_k, the attributions
	// are sorted by instance_output_value in descending order. If
	// ExplanationParameters.output_indices is specified, the attributions are
	// stored by Attribution.output_index in the same order as they appear in the
	// output_indices.
	Attributions []*GoogleCloudAiplatformV1Attribution `json:"attributions,omitempty"`
	// Neighbors: Output only. List of the nearest neighbors for example-based
	// explanations. For models deployed with the examples explanations feature
	// enabled, the attributions field is empty and instead the neighbors field is
	// populated.
	Neighbors []*GoogleCloudAiplatformV1Neighbor `json:"neighbors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Explanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Explanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadata: Metadata describing the Model's
// input and output for explanation.
type GoogleCloudAiplatformV1ExplanationMetadata struct {
	// FeatureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
	// Storage describing the format of the feature attributions. The schema is
	// defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// AutoML tabular Models always have this field populated by Vertex AI. Note:
	// The URI given on output may be different, including the URI scheme, than the
	// one given on input. The output URI will point to a location where the user
	// only has a read access.
	FeatureAttributionsSchemaUri string `json:"featureAttributionsSchemaUri,omitempty"`
	// Inputs: Required. Map from feature names to feature input metadata. Keys are
	// the name of the features. Values are the specification of the feature. An
	// empty InputMetadata is valid. It describes a text feature which has the name
	// specified as the key in ExplanationMetadata.inputs. The baseline of the
	// empty feature is chosen by Vertex AI. For Vertex AI-provided Tensorflow
	// images, the key can be any friendly name of the feature. Once specified,
	// featureAttributions are keyed by this key (if not grouped with another
	// feature). For custom images, the key must match with the key in instance.
	Inputs map[string]GoogleCloudAiplatformV1ExplanationMetadataInputMetadata `json:"inputs,omitempty"`
	// LatentSpaceSource: Name of the source to generate embeddings for example
	// based explanations.
	LatentSpaceSource string `json:"latentSpaceSource,omitempty"`
	// Outputs: Required. Map from output names to output metadata. For Vertex
	// AI-provided Tensorflow images, keys can be any user defined string that
	// consists of any UTF-8 characters. For custom images, keys are the name of
	// the output field in the prediction to be explained. Currently only one key
	// is allowed.
	Outputs map[string]GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata `json:"outputs,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FeatureAttributionsSchemaUri") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureAttributionsSchemaUri") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataInputMetadata: Metadata of the
// input of a feature. Fields other than InputMetadata.input_baselines are
// applicable only for Models that are using Vertex AI-provided images for
// Tensorflow.
type GoogleCloudAiplatformV1ExplanationMetadataInputMetadata struct {
	// DenseShapeTensorName: Specifies the shape of the values of the input if the
	// input is a sparse representation. Refer to Tensorflow documentation for more
	// details: https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	DenseShapeTensorName string `json:"denseShapeTensorName,omitempty"`
	// EncodedBaselines: A list of baselines for the encoded tensor. The shape of
	// each baseline should match the shape of the encoded tensor. If a scalar is
	// provided, Vertex AI broadcasts to the same shape as the encoded tensor.
	EncodedBaselines []interface{} `json:"encodedBaselines,omitempty"`
	// EncodedTensorName: Encoded tensor is a transformation of the input tensor.
	// Must be provided if choosing Integrated Gradients attribution or XRAI
	// attribution and the input tensor is not differentiable. An encoded tensor is
	// generated if the input tensor is encoded by a lookup table.
	EncodedTensorName string `json:"encodedTensorName,omitempty"`
	// Encoding: Defines how the feature is encoded into the input tensor. Defaults
	// to IDENTITY.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - Default value. This is the same as IDENTITY.
	//   "IDENTITY" - The tensor represents one feature.
	//   "BAG_OF_FEATURES" - The tensor represents a bag of features where each
	// index maps to a feature. InputMetadata.index_feature_mapping must be
	// provided for this encoding. For example: ``` input = [27, 6.0, 150]
	// index_feature_mapping = ["age", "height", "weight"] ```
	//   "BAG_OF_FEATURES_SPARSE" - The tensor represents a bag of features where
	// each index maps to a feature. Zero values in the tensor indicates feature
	// being non-existent. InputMetadata.index_feature_mapping must be provided for
	// this encoding. For example: ``` input = [2, 0, 5, 0, 1]
	// index_feature_mapping = ["a", "b", "c", "d", "e"] ```
	//   "INDICATOR" - The tensor is a list of binaries representing whether a
	// feature exists or not (1 indicates existence).
	// InputMetadata.index_feature_mapping must be provided for this encoding. For
	// example: ``` input = [1, 0, 1, 0, 1] index_feature_mapping = ["a", "b", "c",
	// "d", "e"] ```
	//   "COMBINED_EMBEDDING" - The tensor is encoded into a 1-dimensional array
	// represented by an encoded tensor. InputMetadata.encoded_tensor_name must be
	// provided for this encoding. For example: ``` input = ["This", "is", "a",
	// "test", "."] encoded = [0.1, 0.2, 0.3, 0.4, 0.5] ```
	//   "CONCAT_EMBEDDING" - Select this encoding when the input tensor is encoded
	// into a 2-dimensional array represented by an encoded tensor.
	// InputMetadata.encoded_tensor_name must be provided for this encoding. The
	// first dimension of the encoded tensor's shape is the same as the input
	// tensor's shape. For example: ``` input = ["This", "is", "a", "test", "."]
	// encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4, 0.3, 0.5], [0.5, 0.1,
	// 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4], [0.4, 0.3, 0.2, 0.5, 0.1]] ```
	Encoding string `json:"encoding,omitempty"`
	// FeatureValueDomain: The domain details of the input feature value. Like
	// min/max, original mean or standard deviation if normalized.
	FeatureValueDomain *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain `json:"featureValueDomain,omitempty"`
	// GroupName: Name of the group that the input belongs to. Features with the
	// same group name will be treated as one feature when computing attributions.
	// Features grouped together can have different shapes in value. If provided,
	// there will be one single attribution generated in
	// Attribution.feature_attributions, keyed by the group name.
	GroupName string `json:"groupName,omitempty"`
	// IndexFeatureMapping: A list of feature names for each index in the input
	// tensor. Required when the input InputMetadata.encoding is BAG_OF_FEATURES,
	// BAG_OF_FEATURES_SPARSE, INDICATOR.
	IndexFeatureMapping []string `json:"indexFeatureMapping,omitempty"`
	// IndicesTensorName: Specifies the index of the values of the input tensor.
	// Required when the input tensor is a sparse representation. Refer to
	// Tensorflow documentation for more details:
	// https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	IndicesTensorName string `json:"indicesTensorName,omitempty"`
	// InputBaselines: Baseline inputs for this feature. If no baseline is
	// specified, Vertex AI chooses the baseline for this feature. If multiple
	// baselines are specified, Vertex AI returns the average attributions across
	// them in Attribution.feature_attributions. For Vertex AI-provided Tensorflow
	// images (both 1.x and 2.x), the shape of each baseline must match the shape
	// of the input tensor. If a scalar is provided, we broadcast to the same shape
	// as the input tensor. For custom images, the element of the baselines must be
	// in the same format as the feature's input in the instance[]. The schema of
	// any single instance may be specified via Endpoint's DeployedModels' Model's
	// PredictSchemata's instance_schema_uri.
	InputBaselines []interface{} `json:"inputBaselines,omitempty"`
	// InputTensorName: Name of the input tensor for this feature. Required and is
	// only applicable to Vertex AI-provided images for Tensorflow.
	InputTensorName string `json:"inputTensorName,omitempty"`
	// Modality: Modality of the feature. Valid values are: numeric, image.
	// Defaults to numeric.
	Modality string `json:"modality,omitempty"`
	// Visualization: Visualization configurations for image explanation.
	Visualization *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization `json:"visualization,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenseShapeTensorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenseShapeTensorName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadataInputMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain:
// Domain details of the input feature value. Provides numeric information
// about the feature, such as its range (min, max). If the feature has been
// pre-processed, for example with z-scoring, then it provides information
// about how to recover the original feature. For example, if the input feature
// is an image and it has been pre-processed to obtain 0-mean and stddev = 1
// values, then original_mean, and original_stddev refer to the mean and stddev
// of the original feature (e.g. image tensor) from which input feature (with
// mean = 0 and stddev = 1) was obtained.
type GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain struct {
	// MaxValue: The maximum permissible value for this feature.
	MaxValue float64 `json:"maxValue,omitempty"`
	// MinValue: The minimum permissible value for this feature.
	MinValue float64 `json:"minValue,omitempty"`
	// OriginalMean: If this input feature has been normalized to a mean value of
	// 0, the original_mean specifies the mean value of the domain prior to
	// normalization.
	OriginalMean float64 `json:"originalMean,omitempty"`
	// OriginalStddev: If this input feature has been normalized to a standard
	// deviation of 1.0, the original_stddev specifies the standard deviation of
	// the domain prior to normalization.
	OriginalStddev float64 `json:"originalStddev,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataFeatureValueDomain
	var s1 struct {
		MaxValue       gensupport.JSONFloat64 `json:"maxValue"`
		MinValue       gensupport.JSONFloat64 `json:"minValue"`
		OriginalMean   gensupport.JSONFloat64 `json:"originalMean"`
		OriginalStddev gensupport.JSONFloat64 `json:"originalStddev"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxValue = float64(s1.MaxValue)
	s.MinValue = float64(s1.MinValue)
	s.OriginalMean = float64(s1.OriginalMean)
	s.OriginalStddev = float64(s1.OriginalStddev)
	return nil
}

// GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization:
// Visualization configurations for image explanation.
type GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization struct {
	// ClipPercentLowerbound: Excludes attributions below the specified percentile,
	// from the highlighted areas. Defaults to 62.
	ClipPercentLowerbound float64 `json:"clipPercentLowerbound,omitempty"`
	// ClipPercentUpperbound: Excludes attributions above the specified percentile
	// from the highlighted areas. Using the clip_percent_upperbound and
	// clip_percent_lowerbound together can be useful for filtering out noise and
	// making it easier to see areas of strong attribution. Defaults to 99.9.
	ClipPercentUpperbound float64 `json:"clipPercentUpperbound,omitempty"`
	// ColorMap: The color scheme used for the highlighted areas. Defaults to
	// PINK_GREEN for Integrated Gradients attribution, which shows positive
	// attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
	// attribution, which highlights the most influential regions in yellow and the
	// least influential in blue.
	//
	// Possible values:
	//   "COLOR_MAP_UNSPECIFIED" - Should not be used.
	//   "PINK_GREEN" - Positive: green. Negative: pink.
	//   "VIRIDIS" - Viridis color map: A perceptually uniform color mapping which
	// is easier to see by those with colorblindness and progresses from yellow to
	// green to blue. Positive: yellow. Negative: blue.
	//   "RED" - Positive: red. Negative: red.
	//   "GREEN" - Positive: green. Negative: green.
	//   "RED_GREEN" - Positive: green. Negative: red.
	//   "PINK_WHITE_GREEN" - PiYG palette.
	ColorMap string `json:"colorMap,omitempty"`
	// OverlayType: How the original image is displayed in the visualization.
	// Adjusting the overlay can help increase visual clarity if the original image
	// makes it difficult to view the visualization. Defaults to NONE.
	//
	// Possible values:
	//   "OVERLAY_TYPE_UNSPECIFIED" - Default value. This is the same as NONE.
	//   "NONE" - No overlay.
	//   "ORIGINAL" - The attributions are shown on top of the original image.
	//   "GRAYSCALE" - The attributions are shown on top of grayscaled version of
	// the original image.
	//   "MASK_BLACK" - The attributions are used as a mask to reveal predictive
	// parts of the image and hide the un-predictive parts.
	OverlayType string `json:"overlayType,omitempty"`
	// Polarity: Whether to only highlight pixels with positive contributions,
	// negative or both. Defaults to POSITIVE.
	//
	// Possible values:
	//   "POLARITY_UNSPECIFIED" - Default value. This is the same as POSITIVE.
	//   "POSITIVE" - Highlights the pixels/outlines that were most influential to
	// the model's prediction.
	//   "NEGATIVE" - Setting polarity to negative highlights areas that does not
	// lead to the models's current prediction.
	//   "BOTH" - Shows both positive and negative attributions.
	Polarity string `json:"polarity,omitempty"`
	// Type: Type of the image visualization. Only applicable to Integrated
	// Gradients attribution. OUTLINES shows regions of attribution, while PIXELS
	// shows per-pixel attribution. Defaults to OUTLINES.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Should not be used.
	//   "PIXELS" - Shows which pixel contributed to the image prediction.
	//   "OUTLINES" - Shows which region contributed to the image prediction by
	// outlining the region.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClipPercentLowerbound") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClipPercentLowerbound") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataInputMetadataVisualization
	var s1 struct {
		ClipPercentLowerbound gensupport.JSONFloat64 `json:"clipPercentLowerbound"`
		ClipPercentUpperbound gensupport.JSONFloat64 `json:"clipPercentUpperbound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClipPercentLowerbound = float64(s1.ClipPercentLowerbound)
	s.ClipPercentUpperbound = float64(s1.ClipPercentUpperbound)
	return nil
}

// GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata: Metadata of the
// prediction output to be explained.
type GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata struct {
	// DisplayNameMappingKey: Specify a field name in the prediction to look for
	// the display name. Use this if the prediction contains the display names for
	// the outputs. The display names in the prediction must have the same shape of
	// the outputs, so that it can be located by Attribution.output_index for a
	// specific output.
	DisplayNameMappingKey string `json:"displayNameMappingKey,omitempty"`
	// IndexDisplayNameMapping: Static mapping between the index and display name.
	// Use this if the outputs are a deterministic n-dimensional array, e.g. a list
	// of scores of all the classes in a pre-defined order for a
	// multi-classification Model. It's not feasible if the outputs are
	// non-deterministic, e.g. the Model produces top-k classes or sort the outputs
	// by their values. The shape of the value must be an n-dimensional array of
	// strings. The number of dimensions must match that of the outputs to be
	// explained. The Attribution.output_display_name is populated by locating in
	// the mapping with Attribution.output_index.
	IndexDisplayNameMapping interface{} `json:"indexDisplayNameMapping,omitempty"`
	// OutputTensorName: Name of the output tensor. Required and is only applicable
	// to Vertex AI provided images for Tensorflow.
	OutputTensorName string `json:"outputTensorName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayNameMappingKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayNameMappingKey") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataOutputMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataOverride: The ExplanationMetadata
// entries that can be overridden at online explanation time.
type GoogleCloudAiplatformV1ExplanationMetadataOverride struct {
	// Inputs: Required. Overrides the input metadata of the features. The key is
	// the name of the feature to be overridden. The keys specified here must exist
	// in the input metadata to be overridden. If a feature is not specified here,
	// the corresponding feature's input metadata is not overridden.
	Inputs map[string]GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride `json:"inputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadataOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride: The
// input metadata entries to be overridden.
type GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride struct {
	// InputBaselines: Baseline inputs for this feature. This overrides the
	// `input_baseline` field of the ExplanationMetadata.InputMetadata object of
	// the corresponding feature's input metadata. If it's not specified, the
	// original baselines are not overridden.
	InputBaselines []interface{} `json:"inputBaselines,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputBaselines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputBaselines") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationMetadataOverrideInputMetadataOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationParameters: Parameters to configure
// explaining for Model's predictions.
type GoogleCloudAiplatformV1ExplanationParameters struct {
	// Examples: Example-based explanations that returns the nearest neighbors from
	// the provided dataset.
	Examples *GoogleCloudAiplatformV1Examples `json:"examples,omitempty"`
	// IntegratedGradientsAttribution: An attribution method that computes
	// Aumann-Shapley values taking advantage of the model's fully differentiable
	// structure. Refer to this paper for more details:
	// https://arxiv.org/abs/1703.01365
	IntegratedGradientsAttribution *GoogleCloudAiplatformV1IntegratedGradientsAttribution `json:"integratedGradientsAttribution,omitempty"`
	// OutputIndices: If populated, only returns attributions that have
	// output_index contained in output_indices. It must be an ndarray of integers,
	// with the same shape of the output it's explaining. If not populated, returns
	// attributions for top_k indices of outputs. If neither top_k nor
	// output_indices is populated, returns the argmax index of the outputs. Only
	// applicable to Models that predict multiple outputs (e,g, multi-class Models
	// that predict multiple classes).
	OutputIndices []interface{} `json:"outputIndices,omitempty"`
	// SampledShapleyAttribution: An attribution method that approximates Shapley
	// values for features that contribute to the label being predicted. A sampling
	// strategy is used to approximate the value rather than considering all
	// subsets of features. Refer to this paper for model details:
	// https://arxiv.org/abs/1306.4265.
	SampledShapleyAttribution *GoogleCloudAiplatformV1SampledShapleyAttribution `json:"sampledShapleyAttribution,omitempty"`
	// TopK: If populated, returns attributions for top K indices of outputs
	// (defaults to 1). Only applies to Models that predicts more than one outputs
	// (e,g, multi-class Models). When set to -1, returns explanations for all
	// outputs.
	TopK int64 `json:"topK,omitempty"`
	// XraiAttribution: An attribution method that redistributes Integrated
	// Gradients attribution to segmented regions, taking advantage of the model's
	// fully differentiable structure. Refer to this paper for more details:
	// https://arxiv.org/abs/1906.02825 XRAI currently performs better on natural
	// images, like a picture of a house or an animal. If the images are taken in
	// artificial environments, like a lab or manufacturing line, or from
	// diagnostic equipment, like x-rays or quality-control cameras, use Integrated
	// Gradients instead.
	XraiAttribution *GoogleCloudAiplatformV1XraiAttribution `json:"xraiAttribution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationSpec: Specification of Model explanation.
type GoogleCloudAiplatformV1ExplanationSpec struct {
	// Metadata: Optional. Metadata describing the Model's input and output for
	// explanation.
	Metadata *GoogleCloudAiplatformV1ExplanationMetadata `json:"metadata,omitempty"`
	// Parameters: Required. Parameters that configure explaining of the Model's
	// predictions.
	Parameters *GoogleCloudAiplatformV1ExplanationParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExplanationSpecOverride: The ExplanationSpec entries
// that can be overridden at online explanation time.
type GoogleCloudAiplatformV1ExplanationSpecOverride struct {
	// ExamplesOverride: The example-based explanations parameter overrides.
	ExamplesOverride *GoogleCloudAiplatformV1ExamplesOverride `json:"examplesOverride,omitempty"`
	// Metadata: The metadata to be overridden. If not specified, no metadata is
	// overridden.
	Metadata *GoogleCloudAiplatformV1ExplanationMetadataOverride `json:"metadata,omitempty"`
	// Parameters: The parameters to be overridden. Note that the attribution
	// method cannot be changed. If not specified, no parameter is overridden.
	Parameters *GoogleCloudAiplatformV1ExplanationParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExamplesOverride") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExamplesOverride") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExplanationSpecOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExplanationSpecOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataConfig: Describes what part of the Dataset
// is to be exported, the destination of the export and how to export.
type GoogleCloudAiplatformV1ExportDataConfig struct {
	// AnnotationSchemaUri: The Cloud Storage URI that points to a YAML file
	// describing the annotation schema. The schema is defined as an OpenAPI 3.0.2
	// Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/, note that the
	// chosen schema must be consistent with metadata of the Dataset specified by
	// ExportDataRequest.name. Only used for custom training data export use cases.
	// Only applicable to Datasets that have DataItems and Annotations. Only
	// Annotations that both match this schema and belong to DataItems not ignored
	// by the split method are used in respectively training, validation or test
	// role, depending on the role of the DataItem they are on. When used in
	// conjunction with annotations_filter, the Annotations used for training are
	// filtered by both annotations_filter and annotation_schema_uri.
	AnnotationSchemaUri string `json:"annotationSchemaUri,omitempty"`
	// AnnotationsFilter: An expression for filtering what part of the Dataset is
	// to be exported. Only Annotations that match this filter will be exported.
	// The filter syntax is the same as in ListAnnotations.
	AnnotationsFilter string `json:"annotationsFilter,omitempty"`
	// ExportUse: Indicates the usage of the exported files.
	//
	// Possible values:
	//   "EXPORT_USE_UNSPECIFIED" - Regular user export.
	//   "CUSTOM_CODE_TRAINING" - Export for custom code training.
	ExportUse string `json:"exportUse,omitempty"`
	// FilterSplit: Split based on the provided filters for each set.
	FilterSplit *GoogleCloudAiplatformV1ExportFilterSplit `json:"filterSplit,omitempty"`
	// FractionSplit: Split based on fractions defining the size of each set.
	FractionSplit *GoogleCloudAiplatformV1ExportFractionSplit `json:"fractionSplit,omitempty"`
	// GcsDestination: The Google Cloud Storage location where the output is to be
	// written to. In the given directory a new directory will be created with
	// name: `export-data--` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
	// ISO-8601 format. All export output will be written into that directory.
	// Inside that directory, annotations with the same schema will be grouped into
	// sub directories which are named with the corresponding annotations' schema
	// title. Inside these sub directories, a schema.yaml will be created to
	// describe the output format.
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`
	// SavedQueryId: The ID of a SavedQuery (annotation set) under the Dataset
	// specified by ExportDataRequest.name used for filtering Annotations for
	// training. Only used for custom training data export use cases. Only
	// applicable to Datasets that have SavedQueries. Only Annotations that are
	// associated with this SavedQuery are used in respectively training. When used
	// in conjunction with annotations_filter, the Annotations used for training
	// are filtered by both saved_query_id and annotations_filter. Only one of
	// saved_query_id and annotation_schema_uri should be specified as both of them
	// represent the same thing: problem type.
	SavedQueryId string `json:"savedQueryId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSchemaUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSchemaUri") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataOperationMetadata: Runtime operation
// information for DatasetService.ExportData.
type GoogleCloudAiplatformV1ExportDataOperationMetadata struct {
	// GcsOutputDirectory: A Google Cloud Storage directory which path ends with
	// '/'. The exported data is stored in the directory.
	GcsOutputDirectory string `json:"gcsOutputDirectory,omitempty"`
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsOutputDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsOutputDirectory") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataRequest: Request message for
// DatasetService.ExportData.
type GoogleCloudAiplatformV1ExportDataRequest struct {
	// ExportConfig: Required. The desired output location.
	ExportConfig *GoogleCloudAiplatformV1ExportDataConfig `json:"exportConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportDataResponse: Response message for
// DatasetService.ExportData.
type GoogleCloudAiplatformV1ExportDataResponse struct {
	// DataStats: Only present for custom code training export use case. Records
	// data stats, i.e., train/validation/test item/annotation counts calculated
	// during the export operation.
	DataStats *GoogleCloudAiplatformV1ModelDataStats `json:"dataStats,omitempty"`
	// ExportedFiles: All of the files that are exported in this export operation.
	// For custom code training export, only three (training, validation and test)
	// Cloud Storage paths in wildcard format are populated (for example,
	// gs://.../training-*).
	ExportedFiles []string `json:"exportedFiles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata: Details of
// operations that exports Features values.
type GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore export Feature values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesRequest: Request message for
// FeaturestoreService.ExportFeatureValues.
type GoogleCloudAiplatformV1ExportFeatureValuesRequest struct {
	// Destination: Required. Specifies destination location and format.
	Destination *GoogleCloudAiplatformV1FeatureValueDestination `json:"destination,omitempty"`
	// FeatureSelector: Required. Selects Features to export values of.
	FeatureSelector *GoogleCloudAiplatformV1FeatureSelector `json:"featureSelector,omitempty"`
	// FullExport: Exports all historical values of all entities of the EntityType
	// within a time range
	FullExport *GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport `json:"fullExport,omitempty"`
	// Settings: Per-Feature export settings.
	Settings []*GoogleCloudAiplatformV1DestinationFeatureSetting `json:"settings,omitempty"`
	// SnapshotExport: Exports the latest Feature values of all entities of the
	// EntityType within a time range.
	SnapshotExport *GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport `json:"snapshotExport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport: Describes
// exporting all historical Feature values of all entities of the EntityType
// between [start_time, end_time].
type GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport struct {
	// EndTime: Exports Feature values as of this timestamp. If not set, retrieve
	// values as of now. Timestamp, if present, must not have higher than
	// millisecond precision.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Excludes Feature values with feature generation timestamp before
	// this timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesRequestFullExport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport: Describes
// exporting the latest Feature values of all entities of the EntityType
// between [start_time, snapshot_time].
type GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport struct {
	// SnapshotTime: Exports Feature values as of this timestamp. If not set,
	// retrieve values as of now. Timestamp, if present, must not have higher than
	// millisecond precision.
	SnapshotTime string `json:"snapshotTime,omitempty"`
	// StartTime: Excludes Feature values with feature generation timestamp before
	// this timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SnapshotTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SnapshotTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFeatureValuesRequestSnapshotExport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFeatureValuesResponse: Response message for
// FeaturestoreService.ExportFeatureValues.
type GoogleCloudAiplatformV1ExportFeatureValuesResponse struct {
}

// GoogleCloudAiplatformV1ExportFilterSplit: Assigns input data to training,
// validation, and test sets based on the given filters, data pieces not
// matched by any filter are ignored. Currently only supported for Datasets
// containing DataItems. If any of the filters in this message are to match
// nothing, then they can be set as '-' (the minus sign). Supported only for
// unstructured Datasets.
type GoogleCloudAiplatformV1ExportFilterSplit struct {
	// TestFilter: Required. A filter on DataItems of the Dataset. DataItems that
	// match this filter are used to test the Model. A filter with same syntax as
	// the one used in DatasetService.ListDataItems may be used. If a single
	// DataItem is matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training, validation,
	// test order.
	TestFilter string `json:"testFilter,omitempty"`
	// TrainingFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to train the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used. If a
	// single DataItem is matched by more than one of the FilterSplit filters, then
	// it is assigned to the first set that applies to it in the training,
	// validation, test order.
	TrainingFilter string `json:"trainingFilter,omitempty"`
	// ValidationFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to validate the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used. If a
	// single DataItem is matched by more than one of the FilterSplit filters, then
	// it is assigned to the first set that applies to it in the training,
	// validation, test order.
	ValidationFilter string `json:"validationFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFilter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportFilterSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFilterSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportFractionSplit: Assigns the input data to
// training, validation, and test sets as per the given fractions. Any of
// `training_fraction`, `validation_fraction` and `test_fraction` may
// optionally be provided, they must sum to up to 1. If the provided ones sum
// to less than 1, the remainder is assigned to sets as decided by Vertex AI.
// If none of the fractions are set, by default roughly 80% of data is used for
// training, 10% for validation, and 10% for test.
type GoogleCloudAiplatformV1ExportFractionSplit struct {
	// TestFraction: The fraction of the input data that is to be used to evaluate
	// the Model.
	TestFraction float64 `json:"testFraction,omitempty"`
	// TrainingFraction: The fraction of the input data that is to be used to train
	// the Model.
	TrainingFraction float64 `json:"trainingFraction,omitempty"`
	// ValidationFraction: The fraction of the input data that is to be used to
	// validate the Model.
	ValidationFraction float64 `json:"validationFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFraction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportFractionSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportFractionSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1ExportFractionSplit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1ExportFractionSplit
	var s1 struct {
		TestFraction       gensupport.JSONFloat64 `json:"testFraction"`
		TrainingFraction   gensupport.JSONFloat64 `json:"trainingFraction"`
		ValidationFraction gensupport.JSONFloat64 `json:"validationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestFraction = float64(s1.TestFraction)
	s.TrainingFraction = float64(s1.TrainingFraction)
	s.ValidationFraction = float64(s1.ValidationFraction)
	return nil
}

// GoogleCloudAiplatformV1ExportModelOperationMetadata: Details of
// ModelService.ExportModel operation.
type GoogleCloudAiplatformV1ExportModelOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// OutputInfo: Output only. Information further describing the output of this
	// Model export.
	OutputInfo *GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo `json:"outputInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo: Further
// describes the output of the ExportModel. Supplements
// ExportModelRequest.OutputConfig.
type GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo struct {
	// ArtifactOutputUri: Output only. If the Model artifact is being exported to
	// Google Cloud Storage this is the full path of the directory created, into
	// which the Model files are being written to.
	ArtifactOutputUri string `json:"artifactOutputUri,omitempty"`
	// ImageOutputUri: Output only. If the Model image is being exported to Google
	// Container Registry or Artifact Registry this is the full path of the image
	// created.
	ImageOutputUri string `json:"imageOutputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactOutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactOutputUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelOperationMetadataOutputInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelRequest: Request message for
// ModelService.ExportModel.
type GoogleCloudAiplatformV1ExportModelRequest struct {
	// OutputConfig: Required. The desired output location and configuration.
	OutputConfig *GoogleCloudAiplatformV1ExportModelRequestOutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelRequestOutputConfig: Output configuration
// for the Model export.
type GoogleCloudAiplatformV1ExportModelRequestOutputConfig struct {
	// ArtifactDestination: The Cloud Storage location where the Model artifact is
	// to be written to. Under the directory given as the destination a new one
	// with name "model-export--", where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
	// ISO-8601 format, will be created. Inside, the Model and any of its
	// supporting files will be written. This field should only be set when the
	// `exportableContent` field of the [Model.supported_export_formats] object
	// contains `ARTIFACT`.
	ArtifactDestination *GoogleCloudAiplatformV1GcsDestination `json:"artifactDestination,omitempty"`
	// ExportFormatId: The ID of the format in which the Model must be exported.
	// Each Model lists the export formats it supports. If no value is provided
	// here, then the first from the list of the Model's supported formats is used
	// by default.
	ExportFormatId string `json:"exportFormatId,omitempty"`
	// ImageDestination: The Google Container Registry or Artifact Registry uri
	// where the Model container image will be copied to. This field should only be
	// set when the `exportableContent` field of the
	// [Model.supported_export_formats] object contains `IMAGE`.
	ImageDestination *GoogleCloudAiplatformV1ContainerRegistryDestination `json:"imageDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportModelRequestOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportModelRequestOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportModelResponse: Response message of
// ModelService.ExportModel operation.
type GoogleCloudAiplatformV1ExportModelResponse struct {
}

// GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest: Request
// message for TensorboardService.ExportTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest struct {
	// Filter: Exports the TensorboardTimeSeries' data that match the filter
	// expression.
	Filter string `json:"filter,omitempty"`
	// OrderBy: Field to use to sort the TensorboardTimeSeries' data. By default,
	// TensorboardTimeSeries' data is returned in a pseudo random order.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: The maximum number of data points to return per page. The default
	// page_size is 1000. Values must be between 1 and 10000. Values above 10000
	// are coerced to 10000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token, received from a previous
	// ExportTensorboardTimeSeriesData call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// ExportTensorboardTimeSeriesData must match the call that provided the page
	// token.
	PageToken string `json:"pageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse: Response
// message for TensorboardService.ExportTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse struct {
	// NextPageToken: A token, which can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TimeSeriesDataPoints: The returned time series data points.
	TimeSeriesDataPoints []*GoogleCloudAiplatformV1TimeSeriesDataPoint `json:"timeSeriesDataPoints,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExportTensorboardTimeSeriesDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExternalApi: Retrieve from data source powered by
// external API for grounding. The external API is not owned by Google, but
// need to follow the pre-defined API spec.
type GoogleCloudAiplatformV1ExternalApi struct {
	// ApiAuth: The authentication config to access the API. Deprecated. Please use
	// auth_config instead.
	ApiAuth *GoogleCloudAiplatformV1ApiAuth `json:"apiAuth,omitempty"`
	// ApiSpec: The API spec that the external API implements.
	//
	// Possible values:
	//   "API_SPEC_UNSPECIFIED" - Unspecified API spec. This value should not be
	// used.
	//   "SIMPLE_SEARCH" - Simple search API spec.
	//   "ELASTIC_SEARCH" - Elastic search API spec.
	ApiSpec string `json:"apiSpec,omitempty"`
	// AuthConfig: The authentication config to access the API.
	AuthConfig *GoogleCloudAiplatformV1AuthConfig `json:"authConfig,omitempty"`
	// ElasticSearchParams: Parameters for the elastic search API.
	ElasticSearchParams *GoogleCloudAiplatformV1ExternalApiElasticSearchParams `json:"elasticSearchParams,omitempty"`
	// Endpoint: The endpoint of the external API. The system will call the API at
	// this endpoint to retrieve the data for grounding. Example:
	// https://acme.com:443/search
	Endpoint string `json:"endpoint,omitempty"`
	// SimpleSearchParams: Parameters for the simple search API.
	SimpleSearchParams *GoogleCloudAiplatformV1ExternalApiSimpleSearchParams `json:"simpleSearchParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiAuth") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiAuth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExternalApi) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExternalApi
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExternalApiElasticSearchParams: The search parameters
// to use for the ELASTIC_SEARCH spec.
type GoogleCloudAiplatformV1ExternalApiElasticSearchParams struct {
	// Index: The ElasticSearch index to use.
	Index string `json:"index,omitempty"`
	// NumHits: Optional. Number of hits (chunks) to request. When specified, it is
	// passed to Elasticsearch as the `num_hits` param.
	NumHits int64 `json:"numHits,omitempty"`
	// SearchTemplate: The ElasticSearch search template to use.
	SearchTemplate string `json:"searchTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Index") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ExternalApiElasticSearchParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ExternalApiElasticSearchParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ExternalApiSimpleSearchParams: The search parameters
// to use for SIMPLE_SEARCH spec.
type GoogleCloudAiplatformV1ExternalApiSimpleSearchParams struct {
}

// GoogleCloudAiplatformV1Fact: The fact used in grounding.
type GoogleCloudAiplatformV1Fact struct {
	// Chunk: If present, chunk properties.
	Chunk *GoogleCloudAiplatformV1RagChunk `json:"chunk,omitempty"`
	// Query: Query that is used to retrieve this fact.
	Query string `json:"query,omitempty"`
	// Score: If present, according to the underlying Vector DB and the selected
	// metric type, the score can be either the distance or the similarity between
	// the query and the fact and its range depends on the metric type. For
	// example, if the metric type is COSINE_DISTANCE, it represents the distance
	// between the query and the fact. The larger the distance, the less relevant
	// the fact is to the query. The range is [0, 2], while 0 means the most
	// relevant and 2 means the least relevant.
	Score float64 `json:"score,omitempty"`
	// Summary: If present, the summary/snippet of the fact.
	Summary string `json:"summary,omitempty"`
	// Title: If present, it refers to the title of this fact.
	Title string `json:"title,omitempty"`
	// Uri: If present, this uri links to the source of the fact.
	Uri string `json:"uri,omitempty"`
	// VectorDistance: If present, the distance between the query vector and this
	// fact vector.
	VectorDistance float64 `json:"vectorDistance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chunk") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chunk") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Fact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Fact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1Fact) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1Fact
	var s1 struct {
		Score          gensupport.JSONFloat64 `json:"score"`
		VectorDistance gensupport.JSONFloat64 `json:"vectorDistance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	s.VectorDistance = float64(s1.VectorDistance)
	return nil
}

// GoogleCloudAiplatformV1FasterDeploymentConfig: Configuration for faster
// model deployment.
type GoogleCloudAiplatformV1FasterDeploymentConfig struct {
	// FastTryoutEnabled: If true, enable fast tryout feature for this deployed
	// model.
	FastTryoutEnabled bool `json:"fastTryoutEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FastTryoutEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FastTryoutEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FasterDeploymentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FasterDeploymentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Feature: Feature Metadata information. For example,
// color is a feature that describes an apple.
type GoogleCloudAiplatformV1Feature struct {
	// CreateTime: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). Timestamp when this EntityType was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Feature.
	Description string `json:"description,omitempty"`
	// DisableMonitoring: Optional. Only applicable for Vertex AI Feature Store
	// (Legacy). If not set, use the monitoring_config defined for the EntityType
	// this Feature belongs to. Only Features with type (Feature.ValueType) BOOL,
	// STRING, DOUBLE or INT64 can enable monitoring. If set to true, all types of
	// data monitoring are disabled despite the config on EntityType.
	DisableMonitoring bool `json:"disableMonitoring,omitempty"`
	// Etag: Used to perform a consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Features. Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one Feature (System labels
	// are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// MonitoringStatsAnomalies: Output only. Only applicable for Vertex AI Feature
	// Store (Legacy). The list of historical stats and anomalies with specified
	// objectives.
	MonitoringStatsAnomalies []*GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly `json:"monitoringStatsAnomalies,omitempty"`
	// Name: Immutable. Name of the Feature. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityT
	// ypes/{entity_type}/features/{feature}`
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}/featur
	// es/{feature}` The last part feature is assigned by the client. The feature
	// can be up to 64 characters long and can consist only of ASCII Latin letters
	// A-Z and a-z, underscore(_), and ASCII digits 0-9 starting with a letter. The
	// value will be unique given an entity type.
	Name string `json:"name,omitempty"`
	// PointOfContact: Entity responsible for maintaining this feature. Can be
	// comma separated list of email addresses or URIs.
	PointOfContact string `json:"pointOfContact,omitempty"`
	// UpdateTime: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). Timestamp when this EntityType was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValueType: Immutable. Only applicable for Vertex AI Feature Store (Legacy).
	// Type of Feature value.
	//
	// Possible values:
	//   "VALUE_TYPE_UNSPECIFIED" - The value type is unspecified.
	//   "BOOL" - Used for Feature that is a boolean.
	//   "BOOL_ARRAY" - Used for Feature that is a list of boolean.
	//   "DOUBLE" - Used for Feature that is double.
	//   "DOUBLE_ARRAY" - Used for Feature that is a list of double.
	//   "INT64" - Used for Feature that is INT64.
	//   "INT64_ARRAY" - Used for Feature that is a list of INT64.
	//   "STRING" - Used for Feature that is string.
	//   "STRING_ARRAY" - Used for Feature that is a list of String.
	//   "BYTES" - Used for Feature that is bytes.
	//   "STRUCT" - Used for Feature that is struct.
	ValueType string `json:"valueType,omitempty"`
	// VersionColumnName: Only applicable for Vertex AI Feature Store. The name of
	// the BigQuery Table/View column hosting data for this version. If no value is
	// provided, will use feature_id.
	VersionColumnName string `json:"versionColumnName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Feature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Feature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureGroup: Vertex AI Feature Group.
type GoogleCloudAiplatformV1FeatureGroup struct {
	// BigQuery: Indicates that features for this group come from BigQuery
	// Table/View. By default treats the source as a sparse time series source. The
	// BigQuery source table or view must have at least one entity ID column and a
	// column named `feature_timestamp`.
	BigQuery *GoogleCloudAiplatformV1FeatureGroupBigQuery `json:"bigQuery,omitempty"`
	// CreateTime: Output only. Timestamp when this FeatureGroup was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the FeatureGroup.
	Description string `json:"description,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureGroup. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one FeatureGroup(System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureGroup. Format:
	// `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
	Name string `json:"name,omitempty"`
	// ServiceAccountEmail: Output only. A Service Account unique to this
	// FeatureGroup. The role bigquery.dataViewer should be granted to this service
	// account to allow Vertex AI Feature Store to access source data while running
	// jobs under this FeatureGroup.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// ServiceAgentType: Optional. Service agent type used during jobs under a
	// FeatureGroup. By default, the Vertex AI Service Agent is used. When using an
	// IAM Policy to isolate this FeatureGroup within a project, a separate service
	// account should be provisioned by setting this field to
	// `SERVICE_AGENT_TYPE_FEATURE_GROUP`. This will generate a separate service
	// account to access the BigQuery source table.
	//
	// Possible values:
	//   "SERVICE_AGENT_TYPE_UNSPECIFIED" - By default, the project-level Vertex AI
	// Service Agent is enabled.
	//   "SERVICE_AGENT_TYPE_PROJECT" - Specifies the project-level Vertex AI
	// Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	//   "SERVICE_AGENT_TYPE_FEATURE_GROUP" - Enable a FeatureGroup service account
	// to be created by Vertex AI and output in the field `service_account_email`.
	// This service account will be used to read from the source BigQuery table
	// during jobs under a FeatureGroup.
	ServiceAgentType string `json:"serviceAgentType,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureGroup was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureGroupBigQuery: Input source type for BigQuery
// Tables and Views.
type GoogleCloudAiplatformV1FeatureGroupBigQuery struct {
	// BigQuerySource: Required. Immutable. The BigQuery source URI that points to
	// either a BigQuery Table or View.
	BigQuerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigQuerySource,omitempty"`
	// Dense: Optional. If set, all feature values will be fetched from a single
	// row per unique entityId including nulls. If not set, will collapse all rows
	// for each unique entityId into a singe row with any non-null values if
	// present, if no non-null values are present will sync null. ex: If source has
	// schema `(entity_id, feature_timestamp, f0, f1)` and the following rows:
	// `(e1, 2020-01-01T10:00:00.123Z, 10, 15)` `(e1, 2020-02-01T10:00:00.123Z, 20,
	// null)` If dense is set, `(e1, 20, null)` is synced to online stores. If
	// dense is not set, `(e1, 20, 15)` is synced to online stores.
	Dense bool `json:"dense,omitempty"`
	// EntityIdColumns: Optional. Columns to construct entity_id / row keys. If not
	// provided defaults to `entity_id`.
	EntityIdColumns []string `json:"entityIdColumns,omitempty"`
	// StaticDataSource: Optional. Set if the data source is not a time-series.
	StaticDataSource bool `json:"staticDataSource,omitempty"`
	// TimeSeries: Optional. If the source is a time-series source, this can be set
	// to control how downstream sources (ex: FeatureView ) will treat time-series
	// sources. If not set, will treat the source as a time-series source with
	// `feature_timestamp` as timestamp column and no scan boundary.
	TimeSeries *GoogleCloudAiplatformV1FeatureGroupBigQueryTimeSeries `json:"timeSeries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureGroupBigQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureGroupBigQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureGroupBigQueryTimeSeries struct {
	// TimestampColumn: Optional. Column hosting timestamp values for a time-series
	// source. Will be used to determine the latest `feature_values` for each
	// entity. Optional. If not provided, column named `feature_timestamp` of type
	// `TIMESTAMP` will be used.
	TimestampColumn string `json:"timestampColumn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TimestampColumn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimestampColumn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureGroupBigQueryTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureGroupBigQueryTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly: A list of historical
// SnapshotAnalysis or ImportFeaturesAnalysis stats requested by user, sorted
// by FeatureStatsAnomaly.start_time descending.
type GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly struct {
	// FeatureStatsAnomaly: Output only. The stats and anomalies generated at
	// specific timestamp.
	FeatureStatsAnomaly *GoogleCloudAiplatformV1FeatureStatsAnomaly `json:"featureStatsAnomaly,omitempty"`
	// Objective: Output only. The objective for each stats.
	//
	// Possible values:
	//   "OBJECTIVE_UNSPECIFIED" - If it's OBJECTIVE_UNSPECIFIED, monitoring_stats
	// will be empty.
	//   "IMPORT_FEATURE_ANALYSIS" - Stats are generated by Import Feature
	// Analysis.
	//   "SNAPSHOT_ANALYSIS" - Stats are generated by Snapshot Analysis.
	Objective string `json:"objective,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureStatsAnomaly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureStatsAnomaly") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureMonitoringStatsAnomaly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureNoiseSigma: Noise sigma by features. Noise
// sigma represents the standard deviation of the gaussian kernel that will be
// used to add noise to interpolated inputs prior to computing gradients.
type GoogleCloudAiplatformV1FeatureNoiseSigma struct {
	// NoiseSigma: Noise sigma per feature. No noise is added to features that are
	// not set.
	NoiseSigma []*GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature `json:"noiseSigma,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoiseSigma") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoiseSigma") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureNoiseSigma) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureNoiseSigma
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature: Noise sigma
// for a single feature.
type GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature struct {
	// Name: The name of the input feature for which noise sigma is provided. The
	// features are defined in explanation metadata inputs.
	Name string `json:"name,omitempty"`
	// Sigma: This represents the standard deviation of the Gaussian kernel that
	// will be used to add noise to the feature prior to computing gradients.
	// Similar to noise_sigma but represents the noise added to the current
	// feature. Defaults to 0.1.
	Sigma float64 `json:"sigma,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeatureNoiseSigmaNoiseSigmaForFeature
	var s1 struct {
		Sigma gensupport.JSONFloat64 `json:"sigma"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Sigma = float64(s1.Sigma)
	return nil
}

// GoogleCloudAiplatformV1FeatureOnlineStore: Vertex AI Feature Online Store
// provides a centralized repository for serving ML features and embedding
// indexes at low latency. The Feature Online Store is a top-level container.
type GoogleCloudAiplatformV1FeatureOnlineStore struct {
	// Bigtable: Contains settings for the Cloud Bigtable instance that will be
	// created to serve featureValues for all FeatureViews under this
	// FeatureOnlineStore.
	Bigtable *GoogleCloudAiplatformV1FeatureOnlineStoreBigtable `json:"bigtable,omitempty"`
	// CreateTime: Output only. Timestamp when this FeatureOnlineStore was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedServingEndpoint: Optional. The dedicated serving endpoint for this
	// FeatureOnlineStore, which is different from common Vertex service endpoint.
	DedicatedServingEndpoint *GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint `json:"dedicatedServingEndpoint,omitempty"`
	// EncryptionSpec: Optional. Customer-managed encryption key spec for data
	// storage. If set, online store will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureOnlineStore. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one
	// FeatureOnlineStore(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureOnlineStore. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineSt
	// ore}`
	Name string `json:"name,omitempty"`
	// Optimized: Contains settings for the Optimized store that will be created to
	// serve featureValues for all FeatureViews under this FeatureOnlineStore. When
	// choose Optimized storage type, need to set
	// PrivateServiceConnectConfig.enable_private_service_connect to use private
	// endpoint. Otherwise will use public endpoint by default.
	Optimized *GoogleCloudAiplatformV1FeatureOnlineStoreOptimized `json:"optimized,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. State of the featureOnlineStore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STABLE" - State when the featureOnlineStore configuration is not being
	// updated and the fields reflect the current configuration of the
	// featureOnlineStore. The featureOnlineStore is usable in this state.
	//   "UPDATING" - The state of the featureOnlineStore configuration when it is
	// being updated. During an update, the fields reflect either the original
	// configuration or the updated configuration of the featureOnlineStore. The
	// featureOnlineStore is still usable in this state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureOnlineStore was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bigtable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bigtable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureOnlineStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureOnlineStoreBigtable struct {
	// AutoScaling: Required. Autoscaling config applied to Bigtable Instance.
	AutoScaling *GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling `json:"autoScaling,omitempty"`
	// BigtableMetadata: Output only. Metadata of the Bigtable instance. Output
	// only.
	BigtableMetadata *GoogleCloudAiplatformV1FeatureOnlineStoreBigtableBigtableMetadata `json:"bigtableMetadata,omitempty"`
	// EnableDirectBigtableAccess: Optional. It true, enable direct access to the
	// Bigtable instance.
	EnableDirectBigtableAccess bool `json:"enableDirectBigtableAccess,omitempty"`
	// Zone: Optional. The zone where the underlying Bigtable cluster for the
	// primary Bigtable instance will be provisioned. Only the zone must be
	// provided. For example, only "us-central1-a" should be provided.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoScaling") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoScaling") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureOnlineStoreBigtable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStoreBigtable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling struct {
	// CpuUtilizationTarget: Optional. A percentage of the cluster's CPU capacity.
	// Can be from 10% to 80%. When a cluster's CPU utilization exceeds the target
	// that you have set, Bigtable immediately adds nodes to the cluster. When CPU
	// utilization is substantially lower than the target, Bigtable removes nodes.
	// If not set will default to 50%.
	CpuUtilizationTarget int64 `json:"cpuUtilizationTarget,omitempty"`
	// MaxNodeCount: Required. The maximum number of nodes to scale up to. Must be
	// greater than or equal to min_node_count, and less than or equal to 10 times
	// of 'min_node_count'.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: Required. The minimum number of nodes to scale down to. Must
	// be greater than or equal to 1.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuUtilizationTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuUtilizationTarget") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStoreBigtableAutoScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureOnlineStoreBigtableBigtableMetadata: Metadata
// of the Bigtable instance. This is used by direct read access to the Bigtable
// in tenant project.
type GoogleCloudAiplatformV1FeatureOnlineStoreBigtableBigtableMetadata struct {
	// InstanceId: The Cloud Bigtable instance id.
	InstanceId string `json:"instanceId,omitempty"`
	// TableId: The Cloud Bigtable table id.
	TableId string `json:"tableId,omitempty"`
	// TenantProjectId: Tenant project ID.
	TenantProjectId string `json:"tenantProjectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureOnlineStoreBigtableBigtableMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStoreBigtableBigtableMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint: The
// dedicated serving endpoint for this FeatureOnlineStore. Only need to set
// when you choose Optimized storage type. Public endpoint is provisioned by
// default.
type GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint struct {
	// PrivateServiceConnectConfig: Optional. Private service connect config. The
	// private service connection is available only for Optimized storage type, not
	// for embedding management now. If
	// PrivateServiceConnectConfig.enable_private_service_connect set to true,
	// customers will use private service connection to send request. Otherwise,
	// the connection will set to public endpoint.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// PublicEndpointDomainName: Output only. This field will be populated with the
	// domain name to use for this FeatureOnlineStore
	PublicEndpointDomainName string `json:"publicEndpointDomainName,omitempty"`
	// ServiceAttachment: Output only. The name of the service attachment resource.
	// Populated if private service connect is enabled and after FeatureViewSync is
	// created.
	ServiceAttachment string `json:"serviceAttachment,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PrivateServiceConnectConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrivateServiceConnectConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureOnlineStoreDedicatedServingEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureOnlineStoreOptimized: Optimized storage type
type GoogleCloudAiplatformV1FeatureOnlineStoreOptimized struct {
}

// GoogleCloudAiplatformV1FeatureSelector: Selector for Features of an
// EntityType.
type GoogleCloudAiplatformV1FeatureSelector struct {
	// IdMatcher: Required. Matches Features based on ID.
	IdMatcher *GoogleCloudAiplatformV1IdMatcher `json:"idMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdMatcher") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdMatcher") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureStatsAnomaly: Stats and Anomaly generated at
// specific timestamp for specific Feature. The start_time and end_time are
// used to define the time range of the dataset that current stats belongs to,
// e.g. prediction traffic is bucketed into prediction datasets by time window.
// If the Dataset is not defined by time window, start_time = end_time.
// Timestamp of the stats and anomalies always refers to end_time. Raw stats
// and anomalies are stored in stats_uri or anomaly_uri in the tensorflow
// defined protos. Field data_stats contains almost identical information with
// the raw stats in Vertex AI defined proto, for UI to display.
type GoogleCloudAiplatformV1FeatureStatsAnomaly struct {
	// AnomalyDetectionThreshold: This is the threshold used when detecting
	// anomalies. The threshold can be changed by user, so this one might be
	// different from ThresholdConfig.value.
	AnomalyDetectionThreshold float64 `json:"anomalyDetectionThreshold,omitempty"`
	// AnomalyUri: Path of the anomaly file for current feature values in Cloud
	// Storage bucket. Format: gs:////anomalies. Example:
	// gs://monitoring_bucket/feature_name/anomalies. Stats are stored as binary
	// format with Protobuf message Anoamlies are stored as binary format with
	// Protobuf message [tensorflow.metadata.v0.AnomalyInfo]
	// (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
	AnomalyUri string `json:"anomalyUri,omitempty"`
	// DistributionDeviation: Deviation from the current stats to baseline stats.
	// 1. For categorical feature, the distribution distance is calculated by
	// L-inifinity norm. 2. For numerical feature, the distribution distance is
	// calculated by Jensen–Shannon divergence.
	DistributionDeviation float64 `json:"distributionDeviation,omitempty"`
	// EndTime: The end timestamp of window where stats were generated. For
	// objectives where time window doesn't make sense (e.g. Featurestore Snapshot
	// Monitoring), end_time indicates the timestamp of the data used to generate
	// stats (e.g. timestamp we take snapshots for feature values).
	EndTime string `json:"endTime,omitempty"`
	// Score: Feature importance score, only populated when cross-feature
	// monitoring is enabled. For now only used to represent feature attribution
	// score within range [0, 1] for
	// ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW and
	// ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT.
	Score float64 `json:"score,omitempty"`
	// StartTime: The start timestamp of window where stats were generated. For
	// objectives where time window doesn't make sense (e.g. Featurestore Snapshot
	// Monitoring), start_time is only used to indicate the monitoring intervals,
	// so it always equals to (end_time - monitoring_interval).
	StartTime string `json:"startTime,omitempty"`
	// StatsUri: Path of the stats file for current feature values in Cloud Storage
	// bucket. Format: gs:////stats. Example:
	// gs://monitoring_bucket/feature_name/stats. Stats are stored as binary format
	// with Protobuf message tensorflow.metadata.v0.FeatureNameStatistics
	// (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
	StatsUri string `json:"statsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnomalyDetectionThreshold")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnomalyDetectionThreshold") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureStatsAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureStatsAnomaly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeatureStatsAnomaly) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeatureStatsAnomaly
	var s1 struct {
		AnomalyDetectionThreshold gensupport.JSONFloat64 `json:"anomalyDetectionThreshold"`
		DistributionDeviation     gensupport.JSONFloat64 `json:"distributionDeviation"`
		Score                     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnomalyDetectionThreshold = float64(s1.AnomalyDetectionThreshold)
	s.DistributionDeviation = float64(s1.DistributionDeviation)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1FeatureValue: Value for a feature.
type GoogleCloudAiplatformV1FeatureValue struct {
	// BoolArrayValue: A list of bool type feature value.
	BoolArrayValue *GoogleCloudAiplatformV1BoolArray `json:"boolArrayValue,omitempty"`
	// BoolValue: Bool type feature value.
	BoolValue bool `json:"boolValue,omitempty"`
	// BytesValue: Bytes feature value.
	BytesValue string `json:"bytesValue,omitempty"`
	// DoubleArrayValue: A list of double type feature value.
	DoubleArrayValue *GoogleCloudAiplatformV1DoubleArray `json:"doubleArrayValue,omitempty"`
	// DoubleValue: Double type feature value.
	DoubleValue float64 `json:"doubleValue,omitempty"`
	// Int64ArrayValue: A list of int64 type feature value.
	Int64ArrayValue *GoogleCloudAiplatformV1Int64Array `json:"int64ArrayValue,omitempty"`
	// Int64Value: Int64 feature value.
	Int64Value int64 `json:"int64Value,omitempty,string"`
	// Metadata: Metadata of feature value.
	Metadata *GoogleCloudAiplatformV1FeatureValueMetadata `json:"metadata,omitempty"`
	// StringArrayValue: A list of string type feature value.
	StringArrayValue *GoogleCloudAiplatformV1StringArray `json:"stringArrayValue,omitempty"`
	// StringValue: String feature value.
	StringValue string `json:"stringValue,omitempty"`
	// StructValue: A struct type feature value.
	StructValue *GoogleCloudAiplatformV1StructValue `json:"structValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolArrayValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolArrayValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeatureValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeatureValue
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// GoogleCloudAiplatformV1FeatureValueDestination: A destination location for
// Feature values and format.
type GoogleCloudAiplatformV1FeatureValueDestination struct {
	// BigqueryDestination: Output in BigQuery format.
	// BigQueryDestination.output_uri in
	// FeatureValueDestination.bigquery_destination must refer to a table.
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// CsvDestination: Output in CSV format. Array Feature value types are not
	// allowed in CSV format.
	CsvDestination *GoogleCloudAiplatformV1CsvDestination `json:"csvDestination,omitempty"`
	// TfrecordDestination: Output in TFRecord format. Below are the mapping from
	// Feature value type in Featurestore to Feature value type in TFRecord: Value
	// type in Featurestore | Value type in TFRecord DOUBLE, DOUBLE_ARRAY |
	// FLOAT_LIST INT64, INT64_ARRAY | INT64_LIST STRING, STRING_ARRAY, BYTES |
	// BYTES_LIST true -> byte_string("true"), false -> byte_string("false") BOOL,
	// BOOL_ARRAY (true, false) | BYTES_LIST
	TfrecordDestination *GoogleCloudAiplatformV1TFRecordDestination `json:"tfrecordDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureValueDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValueDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureValueList: Container for list of values.
type GoogleCloudAiplatformV1FeatureValueList struct {
	// Values: A list of feature values. All of them should be the same data type.
	Values []*GoogleCloudAiplatformV1FeatureValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureValueList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValueList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureValueMetadata: Metadata of feature value.
type GoogleCloudAiplatformV1FeatureValueMetadata struct {
	// GenerateTime: Feature generation timestamp. Typically, it is provided by
	// user at feature ingestion time. If not, feature store will use the system
	// timestamp when the data is ingested into feature store. Legacy Feature
	// Store: For streaming ingestion, the time, aligned by days, must be no older
	// than five years (1825 days) and no later than one year (366 days) in the
	// future.
	GenerateTime string `json:"generateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureValueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureValueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureView: FeatureView is representation of values
// that the FeatureOnlineStore will serve based on its syncConfig.
type GoogleCloudAiplatformV1FeatureView struct {
	// BigQuerySource: Optional. Configures how data is supposed to be extracted
	// from a BigQuery source to be loaded onto the FeatureOnlineStore.
	BigQuerySource *GoogleCloudAiplatformV1FeatureViewBigQuerySource `json:"bigQuerySource,omitempty"`
	// BigtableMetadata: Output only. Metadata containing information about the
	// Cloud Bigtable.
	BigtableMetadata *GoogleCloudAiplatformV1FeatureViewBigtableMetadata `json:"bigtableMetadata,omitempty"`
	// CreateTime: Output only. Timestamp when this FeatureView was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// FeatureRegistrySource: Optional. Configures the features from a Feature
	// Registry source that need to be loaded onto the FeatureOnlineStore.
	FeatureRegistrySource *GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource `json:"featureRegistrySource,omitempty"`
	// IndexConfig: Optional. Configuration for index preparation for vector
	// search. It contains the required configurations to create an index from
	// source data, so that approximate nearest neighbor (a.k.a ANN) algorithms
	// search can be performed during online serving.
	IndexConfig *GoogleCloudAiplatformV1FeatureViewIndexConfig `json:"indexConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureViews. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one
	// FeatureOnlineStore(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureView. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_
	// store}/featureViews/{feature_view}`
	Name string `json:"name,omitempty"`
	// OptimizedConfig: Optional. Configuration for FeatureView created under
	// Optimized FeatureOnlineStore.
	OptimizedConfig *GoogleCloudAiplatformV1FeatureViewOptimizedConfig `json:"optimizedConfig,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceAccountEmail: Output only. A Service Account unique to this
	// FeatureView. The role bigquery.dataViewer should be granted to this service
	// account to allow Vertex AI Feature Store to sync data to the online store.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// ServiceAgentType: Optional. Service agent type used during data sync. By
	// default, the Vertex AI Service Agent is used. When using an IAM Policy to
	// isolate this FeatureView within a project, a separate service account should
	// be provisioned by setting this field to `SERVICE_AGENT_TYPE_FEATURE_VIEW`.
	// This will generate a separate service account to access the BigQuery source
	// table.
	//
	// Possible values:
	//   "SERVICE_AGENT_TYPE_UNSPECIFIED" - By default, the project-level Vertex AI
	// Service Agent is enabled.
	//   "SERVICE_AGENT_TYPE_PROJECT" - Indicates the project-level Vertex AI
	// Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// will be used during sync jobs.
	//   "SERVICE_AGENT_TYPE_FEATURE_VIEW" - Enable a FeatureView service account
	// to be created by Vertex AI and output in the field `service_account_email`.
	// This service account will be used to read from the source BigQuery table
	// during sync.
	ServiceAgentType string `json:"serviceAgentType,omitempty"`
	// SyncConfig: Configures when data is to be synced/updated for this
	// FeatureView. At the end of the sync the latest featureValues for each
	// entityId of this FeatureView are made ready for online serving.
	SyncConfig *GoogleCloudAiplatformV1FeatureViewSyncConfig `json:"syncConfig,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureView was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VertexRagSource: Optional. The Vertex RAG Source that the FeatureView is
	// linked to.
	VertexRagSource *GoogleCloudAiplatformV1FeatureViewVertexRagSource `json:"vertexRagSource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1FeatureViewBigQuerySource struct {
	// EntityIdColumns: Required. Columns to construct entity_id / row keys.
	EntityIdColumns []string `json:"entityIdColumns,omitempty"`
	// Uri: Required. The BigQuery view URI that will be materialized on each sync
	// trigger based on FeatureView.SyncConfig.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityIdColumns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityIdColumns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewBigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewBigtableMetadata: Metadata for the Cloud
// Bigtable that supports directly interacting Bigtable instances.
type GoogleCloudAiplatformV1FeatureViewBigtableMetadata struct {
	// ReadAppProfile: Output only. The Bigtable App Profile to use for reading
	// from Bigtable.
	ReadAppProfile string `json:"readAppProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReadAppProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReadAppProfile") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewBigtableMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewBigtableMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDataKey: Lookup key for a feature view.
type GoogleCloudAiplatformV1FeatureViewDataKey struct {
	// CompositeKey: The actual Entity ID will be composed from this struct. This
	// should match with the way ID is defined in the FeatureView spec.
	CompositeKey *GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey `json:"compositeKey,omitempty"`
	// Key: String key to use for lookup.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompositeKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompositeKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDataKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDataKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey: ID that is comprised
// from several parts (columns).
type GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey struct {
	// Parts: Parts to construct Entity ID. Should match with the same ID columns
	// as defined in FeatureView in the same order.
	Parts []string `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDataKeyCompositeKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDirectWriteRequest: Request message for
// FeatureOnlineStoreService.FeatureViewDirectWrite.
type GoogleCloudAiplatformV1FeatureViewDirectWriteRequest struct {
	// DataKeyAndFeatureValues: Required. The data keys and associated feature
	// values.
	DataKeyAndFeatureValues []*GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValues `json:"dataKeyAndFeatureValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataKeyAndFeatureValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKeyAndFeatureValues") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDirectWriteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDirectWriteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValues:
// A data key and associated feature values to write to the feature view.
type GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValues struct {
	// DataKey: The data key.
	DataKey *GoogleCloudAiplatformV1FeatureViewDataKey `json:"dataKey,omitempty"`
	// Features: List of features to write.
	Features []*GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature `json:"features,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFe
// ature: Feature name & value pair.
type GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature struct {
	// Name: Feature short name.
	Name string `json:"name,omitempty"`
	// Value: Feature value. A user provided timestamp may be set in the
	// `FeatureValue.metadata.generate_time` field.
	Value *GoogleCloudAiplatformV1FeatureValue `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDirectWriteResponse: Response message for
// FeatureOnlineStoreService.FeatureViewDirectWrite.
type GoogleCloudAiplatformV1FeatureViewDirectWriteResponse struct {
	// Status: Response status for the keys listed in
	// FeatureViewDirectWriteResponse.write_responses. The error only applies to
	// the listed data keys - the stream will remain open for further
	// FeatureOnlineStoreService.FeatureViewDirectWriteRequest requests. Partial
	// failures (e.g. if the first 10 keys of a request fail, but the rest succeed)
	// from a single request may result in multiple responses - there will be one
	// response for the successful request keys and one response for the failing
	// request keys.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// WriteResponses: Details about write for each key. If status is not OK,
	// WriteResponse.data_key will have the key with error, but
	// WriteResponse.online_store_write_time will not be present.
	WriteResponses []*GoogleCloudAiplatformV1FeatureViewDirectWriteResponseWriteResponse `json:"writeResponses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDirectWriteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDirectWriteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewDirectWriteResponseWriteResponse: Details
// about the write for each key.
type GoogleCloudAiplatformV1FeatureViewDirectWriteResponseWriteResponse struct {
	// DataKey: What key is this write response associated with.
	DataKey *GoogleCloudAiplatformV1FeatureViewDataKey `json:"dataKey,omitempty"`
	// OnlineStoreWriteTime: When the feature values were written to the online
	// store. If FeatureViewDirectWriteResponse.status is not OK, this field is not
	// populated.
	OnlineStoreWriteTime string `json:"onlineStoreWriteTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewDirectWriteResponseWriteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewDirectWriteResponseWriteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource: A Feature Registry
// source for features that need to be synced to Online Store.
type GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource struct {
	// FeatureGroups: Required. List of features that need to be synced to Online
	// Store.
	FeatureGroups []*GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup `json:"featureGroups,omitempty"`
	// ProjectNumber: Optional. The project number of the parent project of the
	// Feature Groups.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FeatureGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureGroups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewFeatureRegistrySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup:
// Features belonging to a single feature group that will be synced to Online
// Store.
type GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup struct {
	// FeatureGroupId: Required. Identifier of the feature group.
	FeatureGroupId string `json:"featureGroupId,omitempty"`
	// FeatureIds: Required. Identifiers of features under the feature group.
	FeatureIds []string `json:"featureIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureGroupId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureGroupId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewFeatureRegistrySourceFeatureGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewIndexConfig: Configuration for vector
// indexing.
type GoogleCloudAiplatformV1FeatureViewIndexConfig struct {
	// BruteForceConfig: Optional. Configuration options for using brute force
	// search, which simply implements the standard linear search in the database
	// for each query. It is primarily meant for benchmarking and to generate the
	// ground truth for approximate search.
	BruteForceConfig *GoogleCloudAiplatformV1FeatureViewIndexConfigBruteForceConfig `json:"bruteForceConfig,omitempty"`
	// CrowdingColumn: Optional. Column of crowding. This column contains crowding
	// attribute which is a constraint on a neighbor list produced by
	// FeatureOnlineStoreService.SearchNearestEntities to diversify search results.
	// If NearestNeighborQuery.per_crowding_attribute_neighbor_count is set to K in
	// SearchNearestEntitiesRequest, it's guaranteed that no more than K entities
	// of the same crowding attribute are returned in the response.
	CrowdingColumn string `json:"crowdingColumn,omitempty"`
	// DistanceMeasureType: Optional. The distance measure used in nearest neighbor
	// search.
	//
	// Possible values:
	//   "DISTANCE_MEASURE_TYPE_UNSPECIFIED" - Should not be set.
	//   "SQUARED_L2_DISTANCE" - Euclidean (L_2) Distance.
	//   "COSINE_DISTANCE" - Cosine Distance. Defined as 1 - cosine similarity. We
	// strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead of COSINE
	// distance. Our algorithms have been more optimized for DOT_PRODUCT distance
	// which, when combined with UNIT_L2_NORM, is mathematically equivalent to
	// COSINE distance and results in the same ranking.
	//   "DOT_PRODUCT_DISTANCE" - Dot Product Distance. Defined as a negative of
	// the dot product.
	DistanceMeasureType string `json:"distanceMeasureType,omitempty"`
	// EmbeddingColumn: Optional. Column of embedding. This column contains the
	// source data to create index for vector search. embedding_column must be set
	// when using vector search.
	EmbeddingColumn string `json:"embeddingColumn,omitempty"`
	// EmbeddingDimension: Optional. The number of dimensions of the input
	// embedding.
	EmbeddingDimension int64 `json:"embeddingDimension,omitempty"`
	// FilterColumns: Optional. Columns of features that're used to filter vector
	// search results.
	FilterColumns []string `json:"filterColumns,omitempty"`
	// TreeAhConfig: Optional. Configuration options for the tree-AH algorithm
	// (Shallow tree + Asymmetric Hashing). Please refer to this paper for more
	// details: https://arxiv.org/abs/1908.10396
	TreeAhConfig *GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig `json:"treeAhConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BruteForceConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BruteForceConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewIndexConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewIndexConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewIndexConfigBruteForceConfig: Configuration
// options for using brute force search.
type GoogleCloudAiplatformV1FeatureViewIndexConfigBruteForceConfig struct {
}

// GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig: Configuration
// options for the tree-AH algorithm.
type GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig struct {
	// LeafNodeEmbeddingCount: Optional. Number of embeddings on each leaf node.
	// The default value is 1000 if not set.
	LeafNodeEmbeddingCount int64 `json:"leafNodeEmbeddingCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "LeafNodeEmbeddingCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LeafNodeEmbeddingCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewIndexConfigTreeAHConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewOptimizedConfig: Configuration for
// FeatureViews created in Optimized FeatureOnlineStore.
type GoogleCloudAiplatformV1FeatureViewOptimizedConfig struct {
	// AutomaticResources: Optional. A description of resources that the
	// FeatureView uses, which to large degree are decided by Vertex AI, and
	// optionally allows only a modest additional configuration. If
	// min_replica_count is not set, the default value is 2. If max_replica_count
	// is not set, the default value is 6. The max allowed replica count is 1000.
	AutomaticResources *GoogleCloudAiplatformV1AutomaticResources `json:"automaticResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomaticResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomaticResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewOptimizedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewOptimizedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewSync: FeatureViewSync is a representation
// of sync operation which copies data from data source to Feature View in
// Online Store.
type GoogleCloudAiplatformV1FeatureViewSync struct {
	// CreateTime: Output only. Time when this FeatureViewSync is created. Creation
	// of a FeatureViewSync means that the job is pending / waiting for sufficient
	// resources but may not have started the actual data transfer yet.
	CreateTime string `json:"createTime,omitempty"`
	// FinalStatus: Output only. Final status of the FeatureViewSync.
	FinalStatus *GoogleRpcStatus `json:"finalStatus,omitempty"`
	// Name: Identifier. Name of the FeatureViewSync. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_
	// store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
	Name string `json:"name,omitempty"`
	// RunTime: Output only. Time when this FeatureViewSync is finished.
	RunTime *GoogleTypeInterval `json:"runTime,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SyncSummary: Output only. Summary of the sync job.
	SyncSummary *GoogleCloudAiplatformV1FeatureViewSyncSyncSummary `json:"syncSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewSync) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewSync
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewSyncConfig: Configuration for Sync. Only
// one option is set.
type GoogleCloudAiplatformV1FeatureViewSyncConfig struct {
	// Continuous: Optional. If true, syncs the FeatureView in a continuous manner
	// to Online Store.
	Continuous bool `json:"continuous,omitempty"`
	// Cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
	// runs. To explicitly set a timezone to the cron tab, apply a prefix in the
	// cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The
	// ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database.
	// For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1
	// * * * *".
	Cron string `json:"cron,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Continuous") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Continuous") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewSyncConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewSyncConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewSyncSyncSummary: Summary from the Sync
// job. For continuous syncs, the summary is updated periodically. For batch
// syncs, it gets updated on completion of the sync.
type GoogleCloudAiplatformV1FeatureViewSyncSyncSummary struct {
	// RowSynced: Output only. Total number of rows synced.
	RowSynced int64 `json:"rowSynced,omitempty,string"`
	// SystemWatermarkTime: Lower bound of the system time watermark for the sync
	// job. This is only set for continuously syncing feature views.
	SystemWatermarkTime string `json:"systemWatermarkTime,omitempty"`
	// TotalSlot: Output only. BigQuery slot milliseconds consumed for the sync
	// job.
	TotalSlot int64 `json:"totalSlot,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "RowSynced") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowSynced") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewSyncSyncSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewSyncSyncSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeatureViewVertexRagSource: A Vertex Rag source for
// features that need to be synced to Online Store.
type GoogleCloudAiplatformV1FeatureViewVertexRagSource struct {
	// RagCorpusId: Optional. The RAG corpus id corresponding to this FeatureView.
	RagCorpusId int64 `json:"ragCorpusId,omitempty,string"`
	// Uri: Required. The BigQuery view/table URI that will be materialized on each
	// manual sync trigger. The table/view is expected to have the following
	// columns and types at least: - `corpus_id` (STRING, NULLABLE/REQUIRED) -
	// `file_id` (STRING, NULLABLE/REQUIRED) - `chunk_id` (STRING,
	// NULLABLE/REQUIRED) - `chunk_data_type` (STRING, NULLABLE/REQUIRED) -
	// `chunk_data` (STRING, NULLABLE/REQUIRED) - `embeddings` (FLOAT, REPEATED) -
	// `file_original_uri` (STRING, NULLABLE/REQUIRED)
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RagCorpusId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RagCorpusId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeatureViewVertexRagSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeatureViewVertexRagSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Featurestore: Vertex AI Feature Store provides a
// centralized repository for organizing, storing, and serving ML features. The
// Featurestore is a top-level container for your features and their values.
type GoogleCloudAiplatformV1Featurestore struct {
	// CreateTime: Output only. Timestamp when this Featurestore was created.
	CreateTime string `json:"createTime,omitempty"`
	// EncryptionSpec: Optional. Customer-managed encryption key spec for data
	// storage. If set, both of the online and offline data storage will be secured
	// by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Featurestore. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one Featurestore(System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Name of the Featurestore. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Name string `json:"name,omitempty"`
	// OnlineServingConfig: Optional. Config for online storage resources. The
	// field should not co-exist with the field of `OnlineStoreReplicationConfig`.
	// If both of it and OnlineStoreReplicationConfig are unset, the feature store
	// will not have an online store and cannot be used for online serving.
	OnlineServingConfig *GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig `json:"onlineServingConfig,omitempty"`
	// OnlineStorageTtlDays: Optional. TTL in days for feature values that will be
	// stored in online serving storage. The Feature Store online storage
	// periodically removes obsolete feature values older than
	// `online_storage_ttl_days` since the feature generation time. Note that
	// `online_storage_ttl_days` should be less than or equal to
	// `offline_storage_ttl_days` for each EntityType under a featurestore. If not
	// set, default to 4000 days
	OnlineStorageTtlDays int64 `json:"onlineStorageTtlDays,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. State of the featurestore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STABLE" - State when the featurestore configuration is not being updated
	// and the fields reflect the current configuration of the featurestore. The
	// featurestore is usable in this state.
	//   "UPDATING" - The state of the featurestore configuration when it is being
	// updated. During an update, the fields reflect either the original
	// configuration or the updated configuration of the featurestore. For example,
	// `online_serving_config.fixed_node_count` can take minutes to update. While
	// the update is in progress, the featurestore is in the UPDATING state, and
	// the value of `fixed_node_count` can be the original value or the updated
	// value, depending on the progress of the operation. Until the update
	// completes, the actual number of nodes can still be the original value of
	// `fixed_node_count`. The featurestore is still usable in this state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this Featurestore was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Featurestore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Featurestore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfig: Configuration of how
// features in Featurestore are monitored.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfig struct {
	// CategoricalThresholdConfig: Threshold for categorical features of anomaly
	// detection. This is shared by all types of Featurestore Monitoring for
	// categorical features (i.e. Features with type (Feature.ValueType) BOOL or
	// STRING).
	CategoricalThresholdConfig *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig `json:"categoricalThresholdConfig,omitempty"`
	// ImportFeaturesAnalysis: The config for ImportFeatures Analysis Based Feature
	// Monitoring.
	ImportFeaturesAnalysis *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis `json:"importFeaturesAnalysis,omitempty"`
	// NumericalThresholdConfig: Threshold for numerical features of anomaly
	// detection. This is shared by all objectives of Featurestore Monitoring for
	// numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or
	// INT64).
	NumericalThresholdConfig *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig `json:"numericalThresholdConfig,omitempty"`
	// SnapshotAnalysis: The config for Snapshot Analysis Based Feature Monitoring.
	SnapshotAnalysis *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis `json:"snapshotAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoricalThresholdConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoricalThresholdConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeaturestoreMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis:
// Configuration of the Featurestore's ImportFeature Analysis Based Monitoring.
// This type of analysis generates statistics for values of each Feature
// imported by every ImportFeatureValues operation.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis struct {
	// AnomalyDetectionBaseline: The baseline used to do anomaly detection for the
	// statistics generated by import features analysis.
	//
	// Possible values:
	//   "BASELINE_UNSPECIFIED" - Should not be used.
	//   "LATEST_STATS" - Choose the later one statistics generated by either most
	// recent snapshot analysis or previous import features analysis. If non of
	// them exists, skip anomaly detection and only generate a statistics.
	//   "MOST_RECENT_SNAPSHOT_STATS" - Use the statistics generated by the most
	// recent snapshot analysis if exists.
	//   "PREVIOUS_IMPORT_FEATURES_STATS" - Use the statistics generated by the
	// previous import features analysis if exists.
	AnomalyDetectionBaseline string `json:"anomalyDetectionBaseline,omitempty"`
	// State: Whether to enable / disable / inherite default hebavior for import
	// features analysis.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should not be used.
	//   "DEFAULT" - The default behavior of whether to enable the monitoring.
	// EntityType-level config: disabled. Feature-level config: inherited from the
	// configuration of EntityType this Feature belongs to.
	//   "ENABLED" - Explicitly enables import features analysis. EntityType-level
	// config: by default enables import features analysis for all Features under
	// it. Feature-level config: enables import features analysis regardless of the
	// EntityType-level config.
	//   "DISABLED" - Explicitly disables import features analysis.
	// EntityType-level config: by default disables import features analysis for
	// all Features under it. Feature-level config: disables import features
	// analysis regardless of the EntityType-level config.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnomalyDetectionBaseline")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnomalyDetectionBaseline") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis:
// Configuration of the Featurestore's Snapshot Analysis Based Monitoring. This
// type of analysis generates statistics for each Feature based on a snapshot
// of the latest feature value of each entities every monitoring_interval.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis struct {
	// Disabled: The monitoring schedule for snapshot analysis. For
	// EntityType-level config: unset / disabled = true indicates disabled by
	// default for Features under it; otherwise by default enable snapshot analysis
	// monitoring with monitoring_interval for Features under it. Feature-level
	// config: disabled = true indicates disabled regardless of the
	// EntityType-level config; unset monitoring_interval indicates going with
	// EntityType-level config; otherwise run snapshot analysis monitoring with
	// monitoring_interval regardless of the EntityType-level config. Explicitly
	// Disable the snapshot analysis based monitoring.
	Disabled bool `json:"disabled,omitempty"`
	// MonitoringIntervalDays: Configuration of the snapshot analysis based
	// monitoring pipeline running interval. The value indicates number of days.
	MonitoringIntervalDays int64 `json:"monitoringIntervalDays,omitempty"`
	// StalenessDays: Customized export features time window for snapshot analysis.
	// Unit is one day. Default value is 3 weeks. Minimum value is 1 day. Maximum
	// value is 4000 days.
	StalenessDays int64 `json:"stalenessDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigSnapshotAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig: The
// config for Featurestore Monitoring threshold.
type GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig struct {
	// Value: Specify a threshold value that can trigger the alert. 1. For
	// categorical feature, the distribution distance is calculated by L-inifinity
	// norm. 2. For numerical feature, the distribution distance is calculated by
	// Jensen–Shannon divergence. Each feature must have a non-zero threshold if
	// they need to be monitored. Otherwise no alert will be triggered for that
	// feature.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreMonitoringConfigThresholdConfig
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig: OnlineServingConfig
// specifies the details for provisioning online serving resources.
type GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig struct {
	// FixedNodeCount: The number of nodes for the online store. The number of
	// nodes doesn't scale automatically, but you can manually update the number of
	// nodes. If set to 0, the featurestore will not have an online store and
	// cannot be used for online serving.
	FixedNodeCount int64 `json:"fixedNodeCount,omitempty"`
	// Scaling: Online serving scaling configuration. Only one of
	// `fixed_node_count` and `scaling` can be set. Setting one will reset the
	// other.
	Scaling *GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling `json:"scaling,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedNodeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedNodeCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreOnlineServingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling: Online
// serving scaling configuration. If min_node_count and max_node_count are set
// to the same value, the cluster will be configured with the fixed number of
// node (no auto-scaling).
type GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling struct {
	// CpuUtilizationTarget: Optional. The cpu utilization that the Autoscaler
	// should be trying to achieve. This number is on a scale from 0 (no
	// utilization) to 100 (total utilization), and is limited between 10 and 80.
	// When a cluster's CPU utilization exceeds the target that you have set,
	// Bigtable immediately adds nodes to the cluster. When CPU utilization is
	// substantially lower than the target, Bigtable removes nodes. If not set or
	// set to 0, default to 50.
	CpuUtilizationTarget int64 `json:"cpuUtilizationTarget,omitempty"`
	// MaxNodeCount: The maximum number of nodes to scale up to. Must be greater
	// than min_node_count, and less than or equal to 10 times of 'min_node_count'.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: Required. The minimum number of nodes to scale down to. Must
	// be greater than or equal to 1.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuUtilizationTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuUtilizationTarget") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FeaturestoreOnlineServingConfigScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesRequest: Request message for
// FeatureOnlineStoreService.FetchFeatureValues. All the features under the
// requested feature view will be returned.
type GoogleCloudAiplatformV1FetchFeatureValuesRequest struct {
	// DataFormat: Optional. Response data format. If not set,
	// FeatureViewDataFormat.KEY_VALUE will be used.
	//
	// Possible values:
	//   "FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED" - Not set. Will be treated as the
	// KeyValue format.
	//   "KEY_VALUE" - Return response data in key-value format.
	//   "PROTO_STRUCT" - Return response data in proto Struct format.
	DataFormat string `json:"dataFormat,omitempty"`
	// DataKey: Optional. The request key to fetch feature values for.
	DataKey *GoogleCloudAiplatformV1FeatureViewDataKey `json:"dataKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FetchFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesResponse: Response message for
// FeatureOnlineStoreService.FetchFeatureValues
type GoogleCloudAiplatformV1FetchFeatureValuesResponse struct {
	// DataKey: The data key associated with this response. Will only be populated
	// for FeatureOnlineStoreService.StreamingFetchFeatureValues RPCs.
	DataKey *GoogleCloudAiplatformV1FeatureViewDataKey `json:"dataKey,omitempty"`
	// KeyValues: Feature values in KeyValue format.
	KeyValues *GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList `json:"keyValues,omitempty"`
	// ProtoStruct: Feature values in proto Struct format.
	ProtoStruct googleapi.RawMessage `json:"protoStruct,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FetchFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList:
// Response structure in the format of key (feature name) and (feature) value
// pair.
type GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList struct {
	// Features: List of feature names and values.
	Features []*GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair `json:"features,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeat
// ureNameValuePair: Feature name & value pair.
type GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair struct {
	// Name: Feature short name.
	Name string `json:"name,omitempty"`
	// Value: Feature value.
	Value *GoogleCloudAiplatformV1FeatureValue `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FetchPredictOperationRequest: Request message for
// PredictionService.FetchPredictOperation.
type GoogleCloudAiplatformV1FetchPredictOperationRequest struct {
	// OperationName: Required. The server-assigned name for the operation.
	OperationName string `json:"operationName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FetchPredictOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FetchPredictOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FileData: URI-based data. A FileData message contains
// a URI pointing to data of a specific media type. It is used to represent
// images, audio, and video stored in Google Cloud Storage.
type GoogleCloudAiplatformV1FileData struct {
	// DisplayName: Optional. The display name of the file. Used to provide a label
	// or filename to distinguish files. This field is only returned in
	// `PromptMessage` for prompt management. It is used in the Gemini calls only
	// when server side tools (`code_execution`, `google_search`, and
	// `url_context`) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// FileUri: Required. The URI of the file in Google Cloud Storage.
	FileUri string `json:"fileUri,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FileData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FileData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FileStatus: RagFile status.
type GoogleCloudAiplatformV1FileStatus struct {
	// ErrorStatus: Output only. Only when the `state` field is ERROR.
	ErrorStatus string `json:"errorStatus,omitempty"`
	// State: Output only. RagFile state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - RagFile state is unspecified.
	//   "ACTIVE" - RagFile resource has been created and indexed successfully.
	//   "ERROR" - RagFile resource is in a problematic state. See `error_message`
	// field for details.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FileStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FileStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FilterSplit: Assigns input data to training,
// validation, and test sets based on the given filters, data pieces not
// matched by any filter are ignored. Currently only supported for Datasets
// containing DataItems. If any of the filters in this message are to match
// nothing, then they can be set as '-' (the minus sign). Supported only for
// unstructured Datasets.
type GoogleCloudAiplatformV1FilterSplit struct {
	// TestFilter: Required. A filter on DataItems of the Dataset. DataItems that
	// match this filter are used to test the Model. A filter with same syntax as
	// the one used in DatasetService.ListDataItems may be used. If a single
	// DataItem is matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training, validation,
	// test order.
	TestFilter string `json:"testFilter,omitempty"`
	// TrainingFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to train the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used. If a
	// single DataItem is matched by more than one of the FilterSplit filters, then
	// it is assigned to the first set that applies to it in the training,
	// validation, test order.
	TrainingFilter string `json:"trainingFilter,omitempty"`
	// ValidationFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to validate the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used. If a
	// single DataItem is matched by more than one of the FilterSplit filters, then
	// it is assigned to the first set that applies to it in the training,
	// validation, test order.
	ValidationFilter string `json:"validationFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFilter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FilterSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FilterSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsRequest: The request message for
// MatchService.FindNeighbors.
type GoogleCloudAiplatformV1FindNeighborsRequest struct {
	// DeployedIndexId: The ID of the DeployedIndex that will serve the request.
	// This request is sent to a specific IndexEndpoint, as per the
	// IndexEndpoint.network. That IndexEndpoint also has
	// IndexEndpoint.deployed_indexes, and each such index has a DeployedIndex.id
	// field. The value of the field below must equal one of the DeployedIndex.id
	// fields of the IndexEndpoint that is being called for this request.
	DeployedIndexId string `json:"deployedIndexId,omitempty"`
	// Queries: The list of queries.
	Queries []*GoogleCloudAiplatformV1FindNeighborsRequestQuery `json:"queries,omitempty"`
	// ReturnFullDatapoint: If set to true, the full datapoints (including all
	// vector values and restricts) of the nearest neighbors are returned. Note
	// that returning full datapoint will significantly increase the latency and
	// cost of the query.
	ReturnFullDatapoint bool `json:"returnFullDatapoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndexId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FindNeighborsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsRequestQuery: A query to find a number
// of the nearest neighbors (most similar vectors) of a vector.
type GoogleCloudAiplatformV1FindNeighborsRequestQuery struct {
	// ApproximateNeighborCount: The number of neighbors to find via approximate
	// search before exact reordering is performed. If not set, the default value
	// from scam config is used; if set, this value must be > 0.
	ApproximateNeighborCount int64 `json:"approximateNeighborCount,omitempty"`
	// Datapoint: Required. The datapoint/vector whose nearest neighbors should be
	// searched for.
	Datapoint *GoogleCloudAiplatformV1IndexDatapoint `json:"datapoint,omitempty"`
	// FractionLeafNodesToSearchOverride: The fraction of the number of leaves to
	// search, set at query time allows user to tune search performance. This value
	// increase result in both search accuracy and latency increase. The value
	// should be between 0.0 and 1.0. If not set or set to 0.0, query uses the
	// default value specified in
	// NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
	FractionLeafNodesToSearchOverride float64 `json:"fractionLeafNodesToSearchOverride,omitempty"`
	// NeighborCount: The number of nearest neighbors to be retrieved from database
	// for each query. If not set, will use the default from the service
	// configuration
	// (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
	NeighborCount int64 `json:"neighborCount,omitempty"`
	// PerCrowdingAttributeNeighborCount: Crowding is a constraint on a neighbor
	// list produced by nearest neighbor search requiring that no more than some
	// value k' of the k neighbors returned have the same value of
	// crowding_attribute. It's used for improving result diversity. This field is
	// the maximum number of matches with the same crowding tag.
	PerCrowdingAttributeNeighborCount int64 `json:"perCrowdingAttributeNeighborCount,omitempty"`
	// Rrf: Optional. Represents RRF algorithm that combines search results.
	Rrf *GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF `json:"rrf,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApproximateNeighborCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApproximateNeighborCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FindNeighborsRequestQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequestQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FindNeighborsRequestQuery) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequestQuery
	var s1 struct {
		FractionLeafNodesToSearchOverride gensupport.JSONFloat64 `json:"fractionLeafNodesToSearchOverride"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FractionLeafNodesToSearchOverride = float64(s1.FractionLeafNodesToSearchOverride)
	return nil
}

// GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF: Parameters for RRF
// algorithm that combines search results.
type GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF struct {
	// Alpha: Required. Users can provide an alpha value to give more weight to
	// dense vs sparse results. For example, if the alpha is 0, we only return
	// sparse and if the alpha is 1, we only return dense.
	Alpha float64 `json:"alpha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpha") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsRequestQueryRRF
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	return nil
}

// GoogleCloudAiplatformV1FindNeighborsResponse: The response message for
// MatchService.FindNeighbors.
type GoogleCloudAiplatformV1FindNeighborsResponse struct {
	// NearestNeighbors: The nearest neighbors of the query datapoints.
	NearestNeighbors []*GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors `json:"nearestNeighbors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NearestNeighbors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NearestNeighbors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FindNeighborsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors: Nearest
// neighbors for one query.
type GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors struct {
	// Id: The ID of the query datapoint.
	Id string `json:"id,omitempty"`
	// Neighbors: All its neighbors.
	Neighbors []*GoogleCloudAiplatformV1FindNeighborsResponseNeighbor `json:"neighbors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponseNearestNeighbors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FindNeighborsResponseNeighbor: A neighbor of the
// query vector.
type GoogleCloudAiplatformV1FindNeighborsResponseNeighbor struct {
	// Datapoint: The datapoint of the neighbor. Note that full datapoints are
	// returned only when "return_full_datapoint" is set to true. Otherwise, only
	// the "datapoint_id" and "crowding_tag" fields are populated.
	Datapoint *GoogleCloudAiplatformV1IndexDatapoint `json:"datapoint,omitempty"`
	// Distance: The distance between the neighbor and the dense embedding query.
	Distance float64 `json:"distance,omitempty"`
	// SparseDistance: The distance between the neighbor and the query
	// sparse_embedding.
	SparseDistance float64 `json:"sparseDistance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Datapoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datapoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FindNeighborsResponseNeighbor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponseNeighbor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FindNeighborsResponseNeighbor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FindNeighborsResponseNeighbor
	var s1 struct {
		Distance       gensupport.JSONFloat64 `json:"distance"`
		SparseDistance gensupport.JSONFloat64 `json:"sparseDistance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	s.SparseDistance = float64(s1.SparseDistance)
	return nil
}

// GoogleCloudAiplatformV1FluencyInput: Input for fluency metric.
type GoogleCloudAiplatformV1FluencyInput struct {
	// Instance: Required. Fluency instance.
	Instance *GoogleCloudAiplatformV1FluencyInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for fluency score metric.
	MetricSpec *GoogleCloudAiplatformV1FluencySpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FluencyInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FluencyInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FluencyInstance: Spec for fluency instance.
type GoogleCloudAiplatformV1FluencyInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FluencyInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FluencyInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FluencyResult: Spec for fluency result.
type GoogleCloudAiplatformV1FluencyResult struct {
	// Confidence: Output only. Confidence for fluency score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for fluency score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Fluency score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FluencyResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FluencyResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FluencyResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FluencyResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1FluencySpec: Spec for fluency score metric.
type GoogleCloudAiplatformV1FluencySpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FluencySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FluencySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FractionSplit: Assigns the input data to training,
// validation, and test sets as per the given fractions. Any of
// `training_fraction`, `validation_fraction` and `test_fraction` may
// optionally be provided, they must sum to up to 1. If the provided ones sum
// to less than 1, the remainder is assigned to sets as decided by Vertex AI.
// If none of the fractions are set, by default roughly 80% of data is used for
// training, 10% for validation, and 10% for test.
type GoogleCloudAiplatformV1FractionSplit struct {
	// TestFraction: The fraction of the input data that is to be used to evaluate
	// the Model.
	TestFraction float64 `json:"testFraction,omitempty"`
	// TrainingFraction: The fraction of the input data that is to be used to train
	// the Model.
	TrainingFraction float64 `json:"trainingFraction,omitempty"`
	// ValidationFraction: The fraction of the input data that is to be used to
	// validate the Model.
	ValidationFraction float64 `json:"validationFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFraction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FractionSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FractionSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FractionSplit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FractionSplit
	var s1 struct {
		TestFraction       gensupport.JSONFloat64 `json:"testFraction"`
		TrainingFraction   gensupport.JSONFloat64 `json:"trainingFraction"`
		ValidationFraction gensupport.JSONFloat64 `json:"validationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestFraction = float64(s1.TestFraction)
	s.TrainingFraction = float64(s1.TrainingFraction)
	s.ValidationFraction = float64(s1.ValidationFraction)
	return nil
}

// GoogleCloudAiplatformV1FulfillmentInput: Input for fulfillment metric.
type GoogleCloudAiplatformV1FulfillmentInput struct {
	// Instance: Required. Fulfillment instance.
	Instance *GoogleCloudAiplatformV1FulfillmentInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for fulfillment score metric.
	MetricSpec *GoogleCloudAiplatformV1FulfillmentSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FulfillmentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FulfillmentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FulfillmentInstance: Spec for fulfillment instance.
type GoogleCloudAiplatformV1FulfillmentInstance struct {
	// Instruction: Required. Inference instruction prompt to compare prediction
	// with.
	Instruction string `json:"instruction,omitempty"`
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instruction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instruction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FulfillmentInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FulfillmentInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FulfillmentResult: Spec for fulfillment result.
type GoogleCloudAiplatformV1FulfillmentResult struct {
	// Confidence: Output only. Confidence for fulfillment score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for fulfillment score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Fulfillment score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FulfillmentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FulfillmentResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1FulfillmentResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1FulfillmentResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1FulfillmentSpec: Spec for fulfillment metric.
type GoogleCloudAiplatformV1FulfillmentSpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FulfillmentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FulfillmentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionCall: A predicted [FunctionCall] returned
// from the model that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing the
// parameters and their values.
type GoogleCloudAiplatformV1FunctionCall struct {
	// Args: Optional. The function parameters and values in JSON object format.
	// See [FunctionDeclaration.parameters] for parameter details.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// Name: Optional. The name of the function to call. Matches
	// [FunctionDeclaration.name].
	Name string `json:"name,omitempty"`
	// PartialArgs: Optional. The partial argument value of the function call. If
	// provided, represents the arguments/fields that are streamed incrementally.
	PartialArgs []*GoogleCloudAiplatformV1PartialArg `json:"partialArgs,omitempty"`
	// WillContinue: Optional. Whether this is the last part of the FunctionCall.
	// If true, another partial message for the current FunctionCall is expected to
	// follow.
	WillContinue bool `json:"willContinue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionCallingConfig: Function calling config.
type GoogleCloudAiplatformV1FunctionCallingConfig struct {
	// AllowedFunctionNames: Optional. Function names to call. Only set when the
	// Mode is ANY. Function names should match [FunctionDeclaration.name]. With
	// mode set to ANY, model will predict a function call from the set of function
	// names provided.
	AllowedFunctionNames []string `json:"allowedFunctionNames,omitempty"`
	// Mode: Optional. Function calling mode.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified function calling mode. This value should
	// not be used.
	//   "AUTO" - Default model behavior, model decides to predict either function
	// calls or natural language response.
	//   "ANY" - Model is constrained to always predicting function calls only. If
	// "allowed_function_names" are set, the predicted function calls will be
	// limited to any one of "allowed_function_names", else the predicted function
	// calls will be any one of the provided "function_declarations".
	//   "NONE" - Model will not predict any function calls. Model behavior is same
	// as when not passing any function declarations.
	Mode string `json:"mode,omitempty"`
	// StreamFunctionCallArguments: Optional. When set to true, arguments of a
	// single function call will be streamed out in multiple
	// parts/contents/responses. Partial parameter results will be returned in the
	// [FunctionCall.partial_args] field.
	StreamFunctionCallArguments bool `json:"streamFunctionCallArguments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedFunctionNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedFunctionNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionCallingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionCallingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionDeclaration: Structured representation of a
// function declaration as defined by the OpenAPI 3.0 specification
// (https://spec.openapis.org/oas/v3.0.3). Included in this declaration are the
// function name, description, parameters and response type. This
// FunctionDeclaration is a representation of a block of code that can be used
// as a `Tool` by the model and executed by the client.
type GoogleCloudAiplatformV1FunctionDeclaration struct {
	// Description: Optional. Description and purpose of the function. Model uses
	// it to decide how and whether to call the function.
	Description string `json:"description,omitempty"`
	// Name: Required. The name of the function to call. Must start with a letter
	// or an underscore. Must be a-z, A-Z, 0-9, or contain underscores, dots,
	// colons and dashes, with a maximum length of 64.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. Describes the parameters to this function in JSON
	// Schema Object format. Reflects the Open API 3.03 Parameter Object. string
	// Key: the name of the parameter. Parameter names are case sensitive. Schema
	// Value: the Schema defining the type used for the parameter. For function
	// with no parameters, this can be left unset. Parameter names must start with
	// a letter or an underscore and must only contain chars a-z, A-Z, 0-9, or
	// underscores with a maximum length of 64. Example with 1 required and 1
	// optional parameter: type: OBJECT properties: param1: type: STRING param2:
	// type: INTEGER required: - param1
	Parameters *GoogleCloudAiplatformV1Schema `json:"parameters,omitempty"`
	// ParametersJsonSchema: Optional. Describes the parameters to the function in
	// JSON Schema format. The schema must describe an object where the properties
	// are the parameters to the function. For example: ``` { "type": "object",
	// "properties": { "name": { "type": "string" }, "age": { "type": "integer" }
	// }, "additionalProperties": false, "required": ["name", "age"],
	// "propertyOrdering": ["name", "age"] } ``` This field is mutually exclusive
	// with `parameters`.
	ParametersJsonSchema interface{} `json:"parametersJsonSchema,omitempty"`
	// Response: Optional. Describes the output from this function in JSON Schema
	// format. Reflects the Open API 3.03 Response Object. The Schema defines the
	// type used for the response value of the function.
	Response *GoogleCloudAiplatformV1Schema `json:"response,omitempty"`
	// ResponseJsonSchema: Optional. Describes the output from this function in
	// JSON Schema format. The value specified by the schema is the response value
	// of the function. This field is mutually exclusive with `response`.
	ResponseJsonSchema interface{} `json:"responseJsonSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionDeclaration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionDeclaration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionResponse: The result output from a
// [FunctionCall] that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing any
// output from the function is used as context to the model. This should
// contain the result of a [FunctionCall] made based on model prediction.
type GoogleCloudAiplatformV1FunctionResponse struct {
	// Name: Required. The name of the function to call. Matches
	// [FunctionDeclaration.name] and [FunctionCall.name].
	Name string `json:"name,omitempty"`
	// Parts: Optional. Ordered `Parts` that constitute a function response. Parts
	// may have different IANA MIME types.
	Parts []*GoogleCloudAiplatformV1FunctionResponsePart `json:"parts,omitempty"`
	// Response: Required. The function response in JSON object format. Use
	// "output" key to specify function output and "error" key to specify error
	// details (if any). If "output" and "error" keys are not specified, then whole
	// "response" is treated as function output.
	Response googleapi.RawMessage `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionResponseBlob: Raw media bytes for function
// response. Text should not be sent as raw bytes, use the 'text' field.
type GoogleCloudAiplatformV1FunctionResponseBlob struct {
	// Data: Required. Raw bytes.
	Data string `json:"data,omitempty"`
	// DisplayName: Optional. Display name of the blob. Used to provide a label or
	// filename to distinguish blobs. This field is only returned in PromptMessage
	// for prompt management. It is currently used in the Gemini GenerateContent
	// calls only when server side tools (code_execution, google_search, and
	// url_context) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionResponseBlob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionResponseBlob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionResponseFileData: URI based data for function
// response.
type GoogleCloudAiplatformV1FunctionResponseFileData struct {
	// DisplayName: Optional. Display name of the file data. Used to provide a
	// label or filename to distinguish file datas. This field is only returned in
	// PromptMessage for prompt management. It is currently used in the Gemini
	// GenerateContent calls only when server side tools (code_execution,
	// google_search, and url_context) are enabled.
	DisplayName string `json:"displayName,omitempty"`
	// FileUri: Required. URI.
	FileUri string `json:"fileUri,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionResponseFileData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionResponseFileData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1FunctionResponsePart: A datatype containing media
// that is part of a `FunctionResponse` message. A `FunctionResponsePart`
// consists of data which has an associated datatype. A `FunctionResponsePart`
// can only contain one of the accepted types in `FunctionResponsePart.data`. A
// `FunctionResponsePart` must have a fixed IANA MIME type identifying the type
// and subtype of the media if the `inline_data` field is filled with raw
// bytes.
type GoogleCloudAiplatformV1FunctionResponsePart struct {
	// FileData: URI based data.
	FileData *GoogleCloudAiplatformV1FunctionResponseFileData `json:"fileData,omitempty"`
	// InlineData: Inline media bytes.
	InlineData *GoogleCloudAiplatformV1FunctionResponseBlob `json:"inlineData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1FunctionResponsePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1FunctionResponsePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GcsDestination: The Google Cloud Storage location
// where the output is to be written to.
type GoogleCloudAiplatformV1GcsDestination struct {
	// OutputUriPrefix: Required. Google Cloud Storage URI to output directory. If
	// the uri doesn't end with '/', a '/' will be automatically appended. The
	// directory is created if it doesn't exist.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUriPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GcsSource: The Google Cloud Storage location for the
// input content.
type GoogleCloudAiplatformV1GcsSource struct {
	// Uris: Required. Google Cloud Storage URI(-s) to the input file(s). May
	// contain wildcards. For more information on wildcards, see
	// https://cloud.google.com/storage/docs/wildcards.
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uris") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GdcConfig: Google Distributed Cloud (GDC) config.
type GoogleCloudAiplatformV1GdcConfig struct {
	// Zone: GDC zone. A cluster will be designated for the Vertex AI workload in
	// this zone.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Zone") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Zone") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GdcConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GdcConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GeminiPreferenceExample: Input example for preference
// optimization.
type GoogleCloudAiplatformV1GeminiPreferenceExample struct {
	// Completions: List of completions for a given prompt.
	Completions []*GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion `json:"completions,omitempty"`
	// Contents: Multi-turn contents that represents the Prompt.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Completions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Completions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GeminiPreferenceExample) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GeminiPreferenceExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion: Completion and its
// preference score.
type GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion struct {
	// Completion: Single turn completion for the given prompt.
	Completion *GoogleCloudAiplatformV1Content `json:"completion,omitempty"`
	// Score: The score for the given completion.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Completion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Completion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1GeminiPreferenceExampleCompletion
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig: Configuration for
// GenAiAdvancedFeatures.
type GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig struct {
	// RagConfig: Configuration for Retrieval Augmented Generation feature.
	RagConfig *GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig `json:"ragConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RagConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RagConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig: Configuration
// for Retrieval Augmented Generation feature.
type GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig struct {
	// EnableRag: If true, enable Retrieval Augmented Generation in ChatCompletion
	// request. Once enabled, the endpoint will be identified as GenAI endpoint and
	// Arthedain router will be used.
	EnableRag bool `json:"enableRag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableRag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableRag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenAiAdvancedFeaturesConfigRagConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentRequest: Request message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1GenerateContentRequest struct {
	// CachedContent: Optional. The name of the cached content used as context to
	// serve the prediction. Note: only used in explicit caching, where users can
	// have control over caching (e.g. what content to cache) and enjoy guaranteed
	// cost savings. Format:
	// `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
	CachedContent string `json:"cachedContent,omitempty"`
	// Contents: Required. The content of the current conversation with the model.
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config.
	GenerationConfig *GoogleCloudAiplatformV1GenerationConfig `json:"generationConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request. It
	// is used for billing and reporting only. Label keys and values can be no
	// longer than 63 characters (Unicode codepoints) and can only contain
	// lowercase letters, numeric characters, underscores, and dashes.
	// International characters are allowed. Label values are optional. Label keys
	// must start with a letter.
	Labels map[string]string `json:"labels,omitempty"`
	// ModelArmorConfig: Optional. Settings for prompt and response sanitization
	// using the Model Armor service. If supplied, safety_settings must not be
	// supplied.
	ModelArmorConfig *GoogleCloudAiplatformV1ModelArmorConfig `json:"modelArmorConfig,omitempty"`
	// SafetySettings: Optional. Per request settings for blocking unsafe content.
	// Enforced on GenerateContentResponse.candidates.
	SafetySettings []*GoogleCloudAiplatformV1SafetySetting `json:"safetySettings,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Tool config. This config is shared for all tools
	// provided in the request.
	ToolConfig *GoogleCloudAiplatformV1ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CachedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentResponse: Response message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1GenerateContentResponse struct {
	// Candidates: Output only. Generated candidates.
	Candidates []*GoogleCloudAiplatformV1Candidate `json:"candidates,omitempty"`
	// CreateTime: Output only. Timestamp when the request is made to the server.
	CreateTime string `json:"createTime,omitempty"`
	// ModelVersion: Output only. The model version used to generate the response.
	ModelVersion string `json:"modelVersion,omitempty"`
	// PromptFeedback: Output only. Content filter results for a prompt sent in the
	// request. Note: Sent only in the first stream chunk. Only happens when no
	// candidates were generated due to content violations.
	PromptFeedback *GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback `json:"promptFeedback,omitempty"`
	// ResponseId: Output only. response_id is used to identify each response. It
	// is the encoding of the event_id.
	ResponseId string `json:"responseId,omitempty"`
	// UsageMetadata: Usage metadata about the response(s).
	UsageMetadata *GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback: Content filter
// results for a prompt sent in the request. Note: This is sent only in the
// first stream chunk and only if no candidates were generated due to content
// violations.
type GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback struct {
	// BlockReason: Output only. The reason why the prompt was blocked.
	//
	// Possible values:
	//   "BLOCKED_REASON_UNSPECIFIED" - The blocked reason is unspecified.
	//   "SAFETY" - The prompt was blocked for safety reasons.
	//   "OTHER" - The prompt was blocked for other reasons. For example, it may be
	// due to the prompt's language, or because it contains other harmful content.
	//   "BLOCKLIST" - The prompt was blocked because it contains a term from the
	// terminology blocklist.
	//   "PROHIBITED_CONTENT" - The prompt was blocked because it contains
	// prohibited content.
	//   "MODEL_ARMOR" - The prompt was blocked by Model Armor.
	//   "IMAGE_SAFETY" - The prompt was blocked because it contains content that
	// is unsafe for image generation.
	//   "JAILBREAK" - The prompt was blocked as a jailbreak attempt.
	BlockReason string `json:"blockReason,omitempty"`
	// BlockReasonMessage: Output only. A readable message that explains the reason
	// why the prompt was blocked.
	BlockReasonMessage string `json:"blockReasonMessage,omitempty"`
	// SafetyRatings: Output only. A list of safety ratings for the prompt. There
	// is one rating per category.
	SafetyRatings []*GoogleCloudAiplatformV1SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentResponsePromptFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata: Usage metadata
// about the content generation request and response. This message provides a
// detailed breakdown of token usage and other relevant metrics.
type GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata struct {
	// CacheTokensDetails: Output only. A detailed breakdown of the token count for
	// each modality in the cached content.
	CacheTokensDetails []*GoogleCloudAiplatformV1ModalityTokenCount `json:"cacheTokensDetails,omitempty"`
	// CachedContentTokenCount: Output only. The number of tokens in the cached
	// content that was used for this request.
	CachedContentTokenCount int64 `json:"cachedContentTokenCount,omitempty"`
	// CandidatesTokenCount: The total number of tokens in the generated
	// candidates.
	CandidatesTokenCount int64 `json:"candidatesTokenCount,omitempty"`
	// CandidatesTokensDetails: Output only. A detailed breakdown of the token
	// count for each modality in the generated candidates.
	CandidatesTokensDetails []*GoogleCloudAiplatformV1ModalityTokenCount `json:"candidatesTokensDetails,omitempty"`
	// PromptTokenCount: The total number of tokens in the prompt. This includes
	// any text, images, or other media provided in the request. When
	// `cached_content` is set, this also includes the number of tokens in the
	// cached content.
	PromptTokenCount int64 `json:"promptTokenCount,omitempty"`
	// PromptTokensDetails: Output only. A detailed breakdown of the token count
	// for each modality in the prompt.
	PromptTokensDetails []*GoogleCloudAiplatformV1ModalityTokenCount `json:"promptTokensDetails,omitempty"`
	// ThoughtsTokenCount: Output only. The number of tokens that were part of the
	// model's generated "thoughts" output, if applicable.
	ThoughtsTokenCount int64 `json:"thoughtsTokenCount,omitempty"`
	// ToolUsePromptTokenCount: Output only. The number of tokens in the results
	// from tool executions, which are provided back to the model as input, if
	// applicable.
	ToolUsePromptTokenCount int64 `json:"toolUsePromptTokenCount,omitempty"`
	// ToolUsePromptTokensDetails: Output only. A detailed breakdown by modality of
	// the token counts from the results of tool executions, which are provided
	// back to the model as input.
	ToolUsePromptTokensDetails []*GoogleCloudAiplatformV1ModalityTokenCount `json:"toolUsePromptTokensDetails,omitempty"`
	// TotalTokenCount: The total number of tokens for the entire request. This is
	// the sum of `prompt_token_count`, `candidates_token_count`,
	// `tool_use_prompt_token_count`, and `thoughts_token_count`.
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// TrafficType: Output only. The traffic type for this request.
	//
	// Possible values:
	//   "TRAFFIC_TYPE_UNSPECIFIED" - Unspecified request traffic type.
	//   "ON_DEMAND" - The request was processed using Pay-As-You-Go quota.
	//   "PROVISIONED_THROUGHPUT" - Type for Provisioned Throughput traffic.
	TrafficType string `json:"trafficType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CacheTokensDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheTokensDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateContentResponseUsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateFetchAccessTokenRequest: Request message for
// FeatureOnlineStoreService.GenerateFetchAccessToken.
type GoogleCloudAiplatformV1GenerateFetchAccessTokenRequest struct {
}

// GoogleCloudAiplatformV1GenerateFetchAccessTokenResponse: Response message
// for FeatureOnlineStoreService.GenerateFetchAccessToken.
type GoogleCloudAiplatformV1GenerateFetchAccessTokenResponse struct {
	// AccessToken: The OAuth 2.0 access token.
	AccessToken string `json:"accessToken,omitempty"`
	// ExpireTime: Token expiration time. This is always set
	ExpireTime string `json:"expireTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateFetchAccessTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateFetchAccessTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateInstanceRubricsRequest: Request message for
// EvaluationService.GenerateInstanceRubrics.
type GoogleCloudAiplatformV1GenerateInstanceRubricsRequest struct {
	// AgentConfig: Optional. Agent configuration, required for agent-based rubric
	// generation.
	AgentConfig *GoogleCloudAiplatformV1EvaluationInstanceAgentConfig `json:"agentConfig,omitempty"`
	// Contents: Required. The prompt to generate rubrics from. For single-turn
	// queries, this is a single instance. For multi-turn queries, this is a
	// repeated field that contains conversation history + latest request.
	Contents []*GoogleCloudAiplatformV1Content `json:"contents,omitempty"`
	// Location: Required. The resource name of the Location to generate rubrics
	// from. Format: `projects/{project}/locations/{location}`
	Location string `json:"location,omitempty"`
	// PredefinedRubricGenerationSpec: Optional. Specification for using the rubric
	// generation configs of a pre-defined metric, e.g. "generic_quality_v1" and
	// "instruction_following_v1". Some of the configs may be only used in rubric
	// generation and not supporting evaluation, e.g.
	// "fully_customized_generic_quality_v1". If this field is set, the
	// `rubric_generation_spec` field will be ignored.
	PredefinedRubricGenerationSpec *GoogleCloudAiplatformV1PredefinedMetricSpec `json:"predefinedRubricGenerationSpec,omitempty"`
	// RubricGenerationSpec: Optional. Specification for how the rubrics should be
	// generated.
	RubricGenerationSpec *GoogleCloudAiplatformV1RubricGenerationSpec `json:"rubricGenerationSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateInstanceRubricsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateInstanceRubricsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateInstanceRubricsResponse: Response message for
// EvaluationService.GenerateInstanceRubrics.
type GoogleCloudAiplatformV1GenerateInstanceRubricsResponse struct {
	// GeneratedRubrics: Output only. A list of generated rubrics.
	GeneratedRubrics []*GoogleCloudAiplatformV1Rubric `json:"generatedRubrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "GeneratedRubrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratedRubrics") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateInstanceRubricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateInstanceRubricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateMemoriesRequest: Request message for
// MemoryBankService.GenerateMemories. Maximum size is 8 MB.
type GoogleCloudAiplatformV1GenerateMemoriesRequest struct {
	// DirectContentsSource: Defines a direct source of content as the source
	// content from which to generate memories.
	DirectContentsSource *GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSource `json:"directContentsSource,omitempty"`
	// DirectMemoriesSource: Defines a direct source of memories that should be
	// uploaded to Memory Bank. This is similar to `CreateMemory`, but it allows
	// for consolidation between these new memories and existing memories for the
	// same scope.
	DirectMemoriesSource *GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSource `json:"directMemoriesSource,omitempty"`
	// DisableConsolidation: Optional. If true, generated memories will not be
	// consolidated with existing memories; all generated memories will be added as
	// new memories regardless of whether they are duplicates of or contradictory
	// to existing memories. By default, memory consolidation is enabled.
	DisableConsolidation bool `json:"disableConsolidation,omitempty"`
	// DisableMemoryRevisions: Optional. If true, no revisions will be created for
	// this request.
	DisableMemoryRevisions bool `json:"disableMemoryRevisions,omitempty"`
	// Metadata: Optional. User-provided metadata for the generated memories. This
	// is not generated by Memory Bank.
	Metadata map[string]GoogleCloudAiplatformV1MemoryMetadataValue `json:"metadata,omitempty"`
	// MetadataMergeStrategy: Optional. The strategy to use when applying metadata
	// to existing memories.
	//
	// Possible values:
	//   "METADATA_MERGE_STRATEGY_UNSPECIFIED" - Unspecified metadata merge
	// strategy. If unspecified, the default behavior is to overwrite existing
	// metadata (`OVERWRITE`).
	//   "OVERWRITE" - Replace the metadata of the updated memories with the new
	// metadata.
	//   "MERGE" - Append new metadata to the existing metadata. If there are
	// duplicate keys, the existing values will be overwritten.
	//   "REQUIRE_EXACT_MATCH" - Restrict consolidation to memories that have
	// exactly the same metadata as the request. If a memory doesn't have the same
	// metadata, it is not eligible for consolidation.
	MetadataMergeStrategy string `json:"metadataMergeStrategy,omitempty"`
	// RevisionExpireTime: Optional. Timestamp of when the revision is considered
	// expired. If not set, the memory revision will be kept until manually
	// deleted.
	RevisionExpireTime string `json:"revisionExpireTime,omitempty"`
	// RevisionLabels: Optional. Labels to be applied to the generated memory
	// revisions. For example, you can use this to label a revision with its data
	// source.
	RevisionLabels map[string]string `json:"revisionLabels,omitempty"`
	// RevisionTtl: Optional. The TTL for the revision. The expiration time is
	// computed: now + TTL.
	RevisionTtl string `json:"revisionTtl,omitempty"`
	// Scope: Optional. The scope of the memories that should be generated.
	// Memories will be consolidated across memories with the same scope. Must be
	// provided unless the scope is defined in the source content. If `scope` is
	// provided, it will override the scope defined in the source content. Scope
	// values cannot contain the wildcard character '*'.
	Scope map[string]string `json:"scope,omitempty"`
	// VertexSessionSource: Defines a Vertex Session as the source content from
	// which to generate memories.
	VertexSessionSource *GoogleCloudAiplatformV1GenerateMemoriesRequestVertexSessionSource `json:"vertexSessionSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DirectContentsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DirectContentsSource") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateMemoriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateMemoriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSource: Defines
// a direct source of content from which to generate the memories.
type GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSource struct {
	// Events: Required. The source content (i.e. chat history) to generate
	// memories from.
	Events []*GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSourceEvent `json:"events,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Events") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Events") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSourceEvent: A
// single piece of conversation from which to generate memories.
type GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSourceEvent struct {
	// Content: Required. A single piece of content from which to generate
	// memories.
	Content *GoogleCloudAiplatformV1Content `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSourceEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateMemoriesRequestDirectContentsSourceEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSource: Defines
// a direct source of memories that should be uploaded to Memory Bank with
// consolidation.
type GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSource struct {
	// DirectMemories: Required. The direct memories to upload to Memory Bank. At
	// most 5 direct memories are allowed per request.
	DirectMemories []*GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSourceDirectMemory `json:"directMemories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DirectMemories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DirectMemories") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSourceDirectMemor
// y: A direct memory to upload to Memory Bank.
type GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSourceDirectMemory struct {
	// Fact: Required. The fact to consolidate with existing memories.
	Fact string `json:"fact,omitempty"`
	// Topics: Optional. The topics that the consolidated memories should be
	// associated with.
	Topics []*GoogleCloudAiplatformV1MemoryTopicId `json:"topics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fact") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fact") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSourceDirectMemory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateMemoriesRequestDirectMemoriesSourceDirectMemory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateMemoriesRequestVertexSessionSource: Defines
// an Agent Engine Session from which to generate the memories. If `scope` is
// not provided, the scope will be extracted from the Session (i.e. {"user_id":
// sesison.user_id}).
type GoogleCloudAiplatformV1GenerateMemoriesRequestVertexSessionSource struct {
	// EndTime: Optional. End time (exclusive) of the time range. If not set, the
	// end time is unbounded.
	EndTime string `json:"endTime,omitempty"`
	// Session: Required. The resource name of the Session to generate memories
	// for. Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/
	// sessions/{session}`
	Session string `json:"session,omitempty"`
	// StartTime: Optional. Time range to define which session events should be
	// used to generate memories. Start time (inclusive) of the time range. If not
	// set, the start time is unbounded.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateMemoriesRequestVertexSessionSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateMemoriesRequestVertexSessionSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateSyntheticDataRequest: Request message for
// DataFoundryService.GenerateSyntheticData.
type GoogleCloudAiplatformV1GenerateSyntheticDataRequest struct {
	// Count: Required. The number of synthetic examples to generate. For this
	// stateless API, the count is limited to a small number.
	Count int64 `json:"count,omitempty"`
	// Examples: Optional. A list of few-shot examples to guide the model's output
	// style and format.
	Examples []*GoogleCloudAiplatformV1SyntheticExample `json:"examples,omitempty"`
	// OutputFieldSpecs: Required. The schema of the desired output, defined by a
	// list of fields.
	OutputFieldSpecs []*GoogleCloudAiplatformV1OutputFieldSpec `json:"outputFieldSpecs,omitempty"`
	// TaskDescription: Generate data from a high-level task description.
	TaskDescription *GoogleCloudAiplatformV1TaskDescriptionStrategy `json:"taskDescription,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateSyntheticDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateSyntheticDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateSyntheticDataResponse: The response
// containing the generated data.
type GoogleCloudAiplatformV1GenerateSyntheticDataResponse struct {
	// SyntheticExamples: A list of generated synthetic examples.
	SyntheticExamples []*GoogleCloudAiplatformV1SyntheticExample `json:"syntheticExamples,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SyntheticExamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SyntheticExamples") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateSyntheticDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateSyntheticDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateVideoResponse: Generate video response.
type GoogleCloudAiplatformV1GenerateVideoResponse struct {
	// GeneratedSamples: The cloud storage uris of the generated videos.
	GeneratedSamples []string `json:"generatedSamples,omitempty"`
	// RaiMediaFilteredCount: Returns if any videos were filtered due to RAI
	// policies.
	RaiMediaFilteredCount int64 `json:"raiMediaFilteredCount,omitempty"`
	// RaiMediaFilteredReasons: Returns rai failure reasons if any.
	RaiMediaFilteredReasons []string `json:"raiMediaFilteredReasons,omitempty"`
	// Videos: List of video bytes or Cloud Storage URIs of the generated videos.
	Videos []*GoogleCloudAiplatformV1GenerateVideoResponseVideo `json:"videos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratedSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratedSamples") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateVideoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerateVideoResponseVideo: A generated video.
type GoogleCloudAiplatformV1GenerateVideoResponseVideo struct {
	// BytesBase64Encoded: Base64 encoded bytes string representing the video.
	BytesBase64Encoded string `json:"bytesBase64Encoded,omitempty"`
	// GcsUri: Cloud Storage URI where the generated video is written.
	GcsUri string `json:"gcsUri,omitempty"`
	// MimeType: The MIME type of the content of the video. - video/mp4
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesBase64Encoded") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesBase64Encoded") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerateVideoResponseVideo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerateVideoResponseVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerationConfig: Configuration for content
// generation. This message contains all the parameters that control how the
// model generates content. It allows you to influence the randomness, length,
// and structure of the output.
type GoogleCloudAiplatformV1GenerationConfig struct {
	// AudioTimestamp: Optional. If enabled, audio timestamps will be included in
	// the request to the model. This can be useful for synchronizing audio with
	// other modalities in the response.
	AudioTimestamp bool `json:"audioTimestamp,omitempty"`
	// CandidateCount: Optional. The number of candidate responses to generate. A
	// higher `candidate_count` can provide more options to choose from, but it
	// also consumes more resources. This can be useful for generating a variety of
	// responses and selecting the best one.
	CandidateCount int64 `json:"candidateCount,omitempty"`
	// EnableAffectiveDialog: Optional. If enabled, the model will detect emotions
	// and adapt its responses accordingly. For example, if the model detects that
	// the user is frustrated, it may provide a more empathetic response.
	EnableAffectiveDialog bool `json:"enableAffectiveDialog,omitempty"`
	// FrequencyPenalty: Optional. Penalizes tokens based on their frequency in the
	// generated text. A positive value helps to reduce the repetition of words and
	// phrases. Valid values can range from [-2.0, 2.0].
	FrequencyPenalty float64 `json:"frequencyPenalty,omitempty"`
	// ImageConfig: Optional. Config for image generation features.
	ImageConfig *GoogleCloudAiplatformV1ImageConfig `json:"imageConfig,omitempty"`
	// Logprobs: Optional. The number of top log probabilities to return for each
	// token. This can be used to see which other tokens were considered likely
	// candidates for a given position. A higher value will return more options,
	// but it will also increase the size of the response.
	Logprobs int64 `json:"logprobs,omitempty"`
	// MaxOutputTokens: Optional. The maximum number of tokens to generate in the
	// response. A token is approximately four characters. The default value varies
	// by model. This parameter can be used to control the length of the generated
	// text and prevent overly long responses.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`
	// MediaResolution: Optional. The token resolution at which input media content
	// is sampled. This is used to control the trade-off between the quality of the
	// response and the number of tokens used to represent the media. A higher
	// resolution allows the model to perceive more detail, which can lead to a
	// more nuanced response, but it will also use more tokens. This does not
	// affect the image dimensions sent to the model.
	//
	// Possible values:
	//   "MEDIA_RESOLUTION_UNSPECIFIED" - Media resolution has not been set.
	//   "MEDIA_RESOLUTION_LOW" - Media resolution set to low (64 tokens).
	//   "MEDIA_RESOLUTION_MEDIUM" - Media resolution set to medium (256 tokens).
	//   "MEDIA_RESOLUTION_HIGH" - Media resolution set to high (zoomed reframing
	// with 256 tokens).
	MediaResolution string `json:"mediaResolution,omitempty"`
	// PresencePenalty: Optional. Penalizes tokens that have already appeared in
	// the generated text. A positive value encourages the model to generate more
	// diverse and less repetitive text. Valid values can range from [-2.0, 2.0].
	PresencePenalty float64 `json:"presencePenalty,omitempty"`
	// ResponseJsonSchema: Optional. When this field is set, response_schema must
	// be omitted and response_mime_type must be set to `application/json`.
	ResponseJsonSchema interface{} `json:"responseJsonSchema,omitempty"`
	// ResponseLogprobs: Optional. If set to true, the log probabilities of the
	// output tokens are returned. Log probabilities are the logarithm of the
	// probability of a token appearing in the output. A higher log probability
	// means the token is more likely to be generated. This can be useful for
	// analyzing the model's confidence in its own output and for debugging.
	ResponseLogprobs bool `json:"responseLogprobs,omitempty"`
	// ResponseMimeType: Optional. The IANA standard MIME type of the response. The
	// model will generate output that conforms to this MIME type. Supported values
	// include 'text/plain' (default) and 'application/json'. The model needs to be
	// prompted to output the appropriate response type, otherwise the behavior is
	// undefined. This is a preview feature.
	ResponseMimeType string `json:"responseMimeType,omitempty"`
	// ResponseModalities: Optional. The modalities of the response. The model will
	// generate a response that includes all the specified modalities. For example,
	// if this is set to `[TEXT, IMAGE]`, the response will include both text and
	// an image.
	//
	// Possible values:
	//   "MODALITY_UNSPECIFIED" - Unspecified modality. Will be processed as text.
	//   "TEXT" - Text modality.
	//   "IMAGE" - Image modality.
	//   "AUDIO" - Audio modality.
	ResponseModalities []string `json:"responseModalities,omitempty"`
	// ResponseSchema: Optional. Lets you to specify a schema for the model's
	// response, ensuring that the output conforms to a particular structure. This
	// is useful for generating structured data such as JSON. The schema is a
	// subset of the OpenAPI 3.0 schema object
	// (https://spec.openapis.org/oas/v3.0.3#schema) object. When this field is
	// set, you must also set the `response_mime_type` to `application/json`.
	ResponseSchema *GoogleCloudAiplatformV1Schema `json:"responseSchema,omitempty"`
	// RoutingConfig: Optional. Routing configuration.
	RoutingConfig *GoogleCloudAiplatformV1GenerationConfigRoutingConfig `json:"routingConfig,omitempty"`
	// Seed: Optional. A seed for the random number generator. By setting a seed,
	// you can make the model's output mostly deterministic. For a given prompt and
	// parameters (like temperature, top_p, etc.), the model will produce the same
	// response every time. However, it's not a guaranteed absolute deterministic
	// behavior. This is different from parameters like `temperature`, which
	// control the *level* of randomness. `seed` ensures that the "random" choices
	// the model makes are the same on every run, making it essential for testing
	// and ensuring reproducible results.
	Seed int64 `json:"seed,omitempty"`
	// SpeechConfig: Optional. The speech generation config.
	SpeechConfig *GoogleCloudAiplatformV1SpeechConfig `json:"speechConfig,omitempty"`
	// StopSequences: Optional. A list of character sequences that will stop the
	// model from generating further tokens. If a stop sequence is generated, the
	// output will end at that point. This is useful for controlling the length and
	// structure of the output. For example, you can use ["\n", "###"] to stop
	// generation at a new line or a specific marker.
	StopSequences []string `json:"stopSequences,omitempty"`
	// Temperature: Optional. Controls the randomness of the output. A higher
	// temperature results in more creative and diverse responses, while a lower
	// temperature makes the output more predictable and focused. The valid range
	// is (0.0, 2.0].
	Temperature float64 `json:"temperature,omitempty"`
	// ThinkingConfig: Optional. Configuration for thinking features. An error will
	// be returned if this field is set for models that don't support thinking.
	ThinkingConfig *GoogleCloudAiplatformV1GenerationConfigThinkingConfig `json:"thinkingConfig,omitempty"`
	// TopK: Optional. Specifies the top-k sampling threshold. The model considers
	// only the top k most probable tokens for the next token. This can be useful
	// for generating more coherent and less random text. For example, a `top_k` of
	// 40 means the model will choose the next word from the 40 most likely words.
	TopK float64 `json:"topK,omitempty"`
	// TopP: Optional. Specifies the nucleus sampling threshold. The model
	// considers only the smallest set of tokens whose cumulative probability is at
	// least `top_p`. This helps generate more diverse and less repetitive
	// responses. For example, a `top_p` of 0.9 means the model considers tokens
	// until the cumulative probability of the tokens to select from reaches 0.9.
	// It's recommended to adjust either temperature or `top_p`, but not both.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioTimestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioTimestamp") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1GenerationConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1GenerationConfig
	var s1 struct {
		FrequencyPenalty gensupport.JSONFloat64 `json:"frequencyPenalty"`
		PresencePenalty  gensupport.JSONFloat64 `json:"presencePenalty"`
		Temperature      gensupport.JSONFloat64 `json:"temperature"`
		TopK             gensupport.JSONFloat64 `json:"topK"`
		TopP             gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FrequencyPenalty = float64(s1.FrequencyPenalty)
	s.PresencePenalty = float64(s1.PresencePenalty)
	s.Temperature = float64(s1.Temperature)
	s.TopK = float64(s1.TopK)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudAiplatformV1GenerationConfigRoutingConfig: The configuration for
// routing the request to a specific model. This can be used to control which
// model is used for the generation, either automatically or by specifying a
// model name.
type GoogleCloudAiplatformV1GenerationConfigRoutingConfig struct {
	// AutoMode: In this mode, the model is selected automatically based on the
	// content of the request.
	AutoMode *GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode `json:"autoMode,omitempty"`
	// ManualMode: In this mode, the model is specified manually.
	ManualMode *GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode `json:"manualMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerationConfigRoutingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerationConfigRoutingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode: The
// configuration for automated routing. When automated routing is specified,
// the routing will be determined by the pretrained routing model and customer
// provided model routing preference.
type GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode struct {
	// ModelRoutingPreference: The model routing preference.
	//
	// Possible values:
	//   "UNKNOWN" - Unspecified model routing preference.
	//   "PRIORITIZE_QUALITY" - The model will be selected to prioritize the
	// quality of the response.
	//   "BALANCED" - The model will be selected to balance quality and cost.
	//   "PRIORITIZE_COST" - The model will be selected to prioritize the cost of
	// the request.
	ModelRoutingPreference string `json:"modelRoutingPreference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelRoutingPreference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelRoutingPreference") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerationConfigRoutingConfigAutoRoutingMode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode: The
// configuration for manual routing. When manual routing is specified, the
// model will be selected based on the model name provided.
type GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode struct {
	// ModelName: The name of the model to use. Only public LLM models are
	// accepted.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerationConfigRoutingConfigManualRoutingMode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenerationConfigThinkingConfig: Configuration for the
// model's thinking features. "Thinking" is a process where the model breaks
// down a complex task into smaller, manageable steps. This allows the model to
// reason about the task, plan its approach, and execute the plan to generate a
// high-quality response.
type GoogleCloudAiplatformV1GenerationConfigThinkingConfig struct {
	// IncludeThoughts: Optional. If true, the model will include its thoughts in
	// the response. "Thoughts" are the intermediate steps the model takes to
	// arrive at the final response. They can provide insights into the model's
	// reasoning process and help with debugging. If this is true, thoughts are
	// returned only when available.
	IncludeThoughts bool `json:"includeThoughts,omitempty"`
	// ThinkingBudget: Optional. The token budget for the model's thinking process.
	// The model will make a best effort to stay within this budget. This can be
	// used to control the trade-off between response quality and latency.
	ThinkingBudget int64 `json:"thinkingBudget,omitempty"`
	// ThinkingLevel: Optional. The number of thoughts tokens that the model should
	// generate.
	//
	// Possible values:
	//   "THINKING_LEVEL_UNSPECIFIED" - Unspecified thinking level.
	//   "LOW" - Low thinking level.
	//   "MEDIUM" - Medium thinking level.
	//   "HIGH" - High thinking level.
	//   "MINIMAL" - MINIMAL thinking level.
	ThinkingLevel string `json:"thinkingLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeThoughts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeThoughts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenerationConfigThinkingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenerationConfigThinkingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenericOperationMetadata: Generic Metadata shared by
// all operations.
type GoogleCloudAiplatformV1GenericOperationMetadata struct {
	// CreateTime: Output only. Time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. This field should never exceed 20 entries.
	// Status details field will contain standard Google Cloud error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// UpdateTime: Output only. Time when the operation was updated for the last
	// time. If the operation has finished (successfully or not), this is the
	// finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenericOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenericOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GenieSource: Contains information about the source of
// the models generated from Generative AI Studio.
type GoogleCloudAiplatformV1GenieSource struct {
	// BaseModelUri: Required. The public base model URI.
	BaseModelUri string `json:"baseModelUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseModelUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseModelUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GenieSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GenieSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GoogleDriveSource: The Google Drive location for the
// input content.
type GoogleCloudAiplatformV1GoogleDriveSource struct {
	// ResourceIds: Required. Google Drive resource IDs.
	ResourceIds []*GoogleCloudAiplatformV1GoogleDriveSourceResourceId `json:"resourceIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GoogleDriveSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GoogleDriveSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GoogleDriveSourceResourceId: The type and ID of the
// Google Drive resource.
type GoogleCloudAiplatformV1GoogleDriveSourceResourceId struct {
	// ResourceId: Required. The ID of the Google Drive resource.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: Required. The type of the Google Drive resource.
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Unspecified resource type.
	//   "RESOURCE_TYPE_FILE" - File resource type.
	//   "RESOURCE_TYPE_FOLDER" - Folder resource type.
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GoogleDriveSourceResourceId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GoogleDriveSourceResourceId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GoogleMaps: Tool to retrieve public maps data for
// grounding, powered by Google.
type GoogleCloudAiplatformV1GoogleMaps struct {
	// EnableWidget: Optional. If true, include the widget context token in the
	// response.
	EnableWidget bool `json:"enableWidget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableWidget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableWidget") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GoogleMaps) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GoogleMaps
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GoogleSearchRetrieval: Tool to retrieve public web
// data for grounding, powered by Google.
type GoogleCloudAiplatformV1GoogleSearchRetrieval struct {
	// DynamicRetrievalConfig: Specifies the dynamic retrieval configuration for
	// the given source.
	DynamicRetrievalConfig *GoogleCloudAiplatformV1DynamicRetrievalConfig `json:"dynamicRetrievalConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicRetrievalConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicRetrievalConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GoogleSearchRetrieval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GoogleSearchRetrieval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundednessInput: Input for groundedness metric.
type GoogleCloudAiplatformV1GroundednessInput struct {
	// Instance: Required. Groundedness instance.
	Instance *GoogleCloudAiplatformV1GroundednessInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for groundedness metric.
	MetricSpec *GoogleCloudAiplatformV1GroundednessSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundednessInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundednessInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundednessInstance: Spec for groundedness instance.
type GoogleCloudAiplatformV1GroundednessInstance struct {
	// Context: Required. Background information provided in context used to
	// compare against the prediction.
	Context string `json:"context,omitempty"`
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundednessInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundednessInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundednessResult: Spec for groundedness result.
type GoogleCloudAiplatformV1GroundednessResult struct {
	// Confidence: Output only. Confidence for groundedness score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for groundedness score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Groundedness score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundednessResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundednessResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1GroundednessResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1GroundednessResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1GroundednessSpec: Spec for groundedness metric.
type GoogleCloudAiplatformV1GroundednessSpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundednessSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundednessSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingChunk: A piece of evidence that supports a
// claim made by the model. This is used to show a citation for a claim made by
// the model. When grounding is enabled, the model returns a `GroundingChunk`
// that contains a reference to the source of the information.
type GoogleCloudAiplatformV1GroundingChunk struct {
	// Maps: A grounding chunk from Google Maps. See the `Maps` message for
	// details.
	Maps *GoogleCloudAiplatformV1GroundingChunkMaps `json:"maps,omitempty"`
	// RetrievedContext: A grounding chunk from a data source retrieved by a
	// retrieval tool, such as Vertex AI Search. See the `RetrievedContext` message
	// for details
	RetrievedContext *GoogleCloudAiplatformV1GroundingChunkRetrievedContext `json:"retrievedContext,omitempty"`
	// Web: A grounding chunk from a web page, typically from Google Search. See
	// the `Web` message for details.
	Web *GoogleCloudAiplatformV1GroundingChunkWeb `json:"web,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Maps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Maps") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingChunkMaps: A `Maps` chunk is a piece of
// evidence that comes from Google Maps. It contains information about a place,
// such as its name, address, and reviews. This is used to provide the user
// with rich, location-based information.
type GoogleCloudAiplatformV1GroundingChunkMaps struct {
	// PlaceAnswerSources: The sources that were used to generate the place answer.
	// This includes review snippets and photos that were used to generate the
	// answer, as well as URIs to flag content.
	PlaceAnswerSources *GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSources `json:"placeAnswerSources,omitempty"`
	// PlaceId: This Place's resource name, in `places/{place_id}` format. This can
	// be used to look up the place in the Google Maps API.
	PlaceId string `json:"placeId,omitempty"`
	// Text: The text of the place answer.
	Text string `json:"text,omitempty"`
	// Title: The title of the place.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the place.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlaceAnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlaceAnswerSources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingChunkMaps) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingChunkMaps
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSources: The sources
// that were used to generate the place answer. This includes review snippets
// and photos that were used to generate the answer, as well as URIs to flag
// content.
type GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSources struct {
	// ReviewSnippets: Snippets of reviews that were used to generate the answer.
	ReviewSnippets []*GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet `json:"reviewSnippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReviewSnippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReviewSnippets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet: A
// review snippet that is used to generate the answer.
type GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet struct {
	// GoogleMapsUri: A link to show the review on Google Maps.
	GoogleMapsUri string `json:"googleMapsUri,omitempty"`
	// ReviewId: The ID of the review that is being referenced.
	ReviewId string `json:"reviewId,omitempty"`
	// Title: The title of the review.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoogleMapsUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleMapsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingChunkMapsPlaceAnswerSourcesReviewSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingChunkRetrievedContext: Context retrieved
// from a data source to ground the model's response. This is used when a
// retrieval tool fetches information from a user-provided corpus or a public
// dataset.
type GoogleCloudAiplatformV1GroundingChunkRetrievedContext struct {
	// DocumentName: Output only. The full resource name of the referenced Vertex
	// AI Search document. This is used to identify the specific document that was
	// retrieved. The format is
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}/branches/{branch}/documents/{document}`.
	DocumentName string `json:"documentName,omitempty"`
	// RagChunk: Additional context for a Retrieval-Augmented Generation (RAG)
	// retrieval result. This is populated only when the RAG retrieval tool is
	// used.
	RagChunk *GoogleCloudAiplatformV1RagChunk `json:"ragChunk,omitempty"`
	// Text: The content of the retrieved data source.
	Text string `json:"text,omitempty"`
	// Title: The title of the retrieved data source.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the retrieved data source.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingChunkRetrievedContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingChunkRetrievedContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingChunkWeb: A `Web` chunk is a piece of
// evidence that comes from a web page. It contains the URI of the web page,
// the title of the page, and the domain of the page. This is used to provide
// the user with a link to the source of the information.
type GoogleCloudAiplatformV1GroundingChunkWeb struct {
	// Domain: The domain of the web page that contains the evidence. This can be
	// used to filter out low-quality sources.
	Domain string `json:"domain,omitempty"`
	// Title: The title of the web page that contains the evidence.
	Title string `json:"title,omitempty"`
	// Uri: The URI of the web page that contains the evidence.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingChunkWeb) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingChunkWeb
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingMetadata: Information about the sources that
// support the content of a response. When grounding is enabled, the model
// returns citations for claims in the response. This object contains the
// retrieved sources.
type GoogleCloudAiplatformV1GroundingMetadata struct {
	// GoogleMapsWidgetContextToken: Optional. Output only. A token that can be
	// used to render a Google Maps widget with the contextual data. This field is
	// populated only when the grounding source is Google Maps.
	GoogleMapsWidgetContextToken string `json:"googleMapsWidgetContextToken,omitempty"`
	// GroundingChunks: A list of supporting references retrieved from the
	// grounding source. This field is populated when the grounding source is
	// Google Search, Vertex AI Search, or Google Maps.
	GroundingChunks []*GoogleCloudAiplatformV1GroundingChunk `json:"groundingChunks,omitempty"`
	// GroundingSupports: Optional. A list of grounding supports that connect the
	// generated content to the grounding chunks. This field is populated when the
	// grounding source is Google Search or Vertex AI Search.
	GroundingSupports []*GoogleCloudAiplatformV1GroundingSupport `json:"groundingSupports,omitempty"`
	// RetrievalMetadata: Optional. Output only. Metadata related to the retrieval
	// grounding source.
	RetrievalMetadata *GoogleCloudAiplatformV1RetrievalMetadata `json:"retrievalMetadata,omitempty"`
	// SearchEntryPoint: Optional. A web search entry point that can be used to
	// display search results. This field is populated only when the grounding
	// source is Google Search.
	SearchEntryPoint *GoogleCloudAiplatformV1SearchEntryPoint `json:"searchEntryPoint,omitempty"`
	// SourceFlaggingUris: Optional. Output only. A list of URIs that can be used
	// to flag a place or review for inappropriate content. This field is populated
	// only when the grounding source is Google Maps.
	SourceFlaggingUris []*GoogleCloudAiplatformV1GroundingMetadataSourceFlaggingUri `json:"sourceFlaggingUris,omitempty"`
	// WebSearchQueries: Optional. The web search queries that were used to
	// generate the content. This field is populated only when the grounding source
	// is Google Search.
	WebSearchQueries []string `json:"webSearchQueries,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GoogleMapsWidgetContextToken") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoogleMapsWidgetContextToken") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingMetadataSourceFlaggingUri: A URI that can be
// used to flag a place or review for inappropriate content. This is populated
// only when the grounding source is Google Maps.
type GoogleCloudAiplatformV1GroundingMetadataSourceFlaggingUri struct {
	// FlagContentUri: The URI that can be used to flag the content.
	FlagContentUri string `json:"flagContentUri,omitempty"`
	// SourceId: The ID of the place or review.
	SourceId string `json:"sourceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlagContentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlagContentUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingMetadataSourceFlaggingUri) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingMetadataSourceFlaggingUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1GroundingSupport: A collection of supporting
// references for a segment of the model's response.
type GoogleCloudAiplatformV1GroundingSupport struct {
	// ConfidenceScores: The confidence scores for the support references. This
	// list is parallel to the `grounding_chunk_indices` list. A score is a value
	// between 0.0 and 1.0, with a higher score indicating a higher confidence that
	// the reference supports the claim. For Gemini 2.0 and before, this list has
	// the same size as `grounding_chunk_indices`. For Gemini 2.5 and later, this
	// list is empty and should be ignored.
	ConfidenceScores []float64 `json:"confidenceScores,omitempty"`
	// GroundingChunkIndices: A list of indices into the `grounding_chunks` field
	// of the `GroundingMetadata` message. These indices specify which grounding
	// chunks support the claim made in the content segment. For example, if this
	// field has the values `[1, 3]`, it means that `grounding_chunks[1]` and
	// `grounding_chunks[3]` are the sources for the claim in the content segment.
	GroundingChunkIndices []int64 `json:"groundingChunkIndices,omitempty"`
	// Segment: The content segment that this support message applies to.
	Segment *GoogleCloudAiplatformV1Segment `json:"segment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScores") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1GroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1GroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1GroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1GroundingSupport
	var s1 struct {
		ConfidenceScores []gensupport.JSONFloat64 `json:"confidenceScores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScores = make([]float64, len(s1.ConfidenceScores))
	for i := range s1.ConfidenceScores {
		s.ConfidenceScores[i] = float64(s1.ConfidenceScores[i])
	}
	return nil
}

// GoogleCloudAiplatformV1HyperparameterTuningJob: Represents a
// HyperparameterTuningJob. A HyperparameterTuningJob has a Study specification
// and multiple CustomJobs with identical CustomJob specification.
type GoogleCloudAiplatformV1HyperparameterTuningJob struct {
	// CreateTime: Output only. Time when the HyperparameterTuningJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the HyperparameterTuningJob. The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key options for a
	// HyperparameterTuningJob. If this is set, then all resources created by the
	// HyperparameterTuningJob will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// EndTime: Output only. Time when the HyperparameterTuningJob entered any of
	// the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. Only populated when job's state is JOB_STATE_FAILED or
	// JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Labels: The labels with user-defined metadata to organize
	// HyperparameterTuningJobs. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// MaxFailedTrialCount: The number of failed Trials that need to be seen before
	// failing the HyperparameterTuningJob. If set to 0, Vertex AI decides how many
	// Trials must fail before the whole job fails.
	MaxFailedTrialCount int64 `json:"maxFailedTrialCount,omitempty"`
	// MaxTrialCount: Required. The desired total number of Trials.
	MaxTrialCount int64 `json:"maxTrialCount,omitempty"`
	// Name: Output only. Resource name of the HyperparameterTuningJob.
	Name string `json:"name,omitempty"`
	// ParallelTrialCount: Required. The desired number of Trials to run in
	// parallel.
	ParallelTrialCount int64 `json:"parallelTrialCount,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// StartTime: Output only. Time when the HyperparameterTuningJob for the first
	// time entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// StudySpec: Required. Study configuration of the HyperparameterTuningJob.
	StudySpec *GoogleCloudAiplatformV1StudySpec `json:"studySpec,omitempty"`
	// TrialJobSpec: Required. The spec of a trial job. The same spec applies to
	// the CustomJobs created in all the trials.
	TrialJobSpec *GoogleCloudAiplatformV1CustomJobSpec `json:"trialJobSpec,omitempty"`
	// Trials: Output only. Trials of the HyperparameterTuningJob.
	Trials []*GoogleCloudAiplatformV1Trial `json:"trials,omitempty"`
	// UpdateTime: Output only. Time when the HyperparameterTuningJob was most
	// recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1HyperparameterTuningJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1HyperparameterTuningJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IdMatcher: Matcher for Features of an EntityType by
// Feature ID.
type GoogleCloudAiplatformV1IdMatcher struct {
	// Ids: Required. The following are accepted as `ids`: * A single-element list
	// containing only `*`, which selects all Features in the target EntityType, or
	// * A list containing only Feature IDs, which selects only Features with those
	// IDs in the target EntityType.
	Ids []string `json:"ids,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ids") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ids") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IdMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IdMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImageConfig: Configuration for image generation. This
// message allows you to control various aspects of image generation, such as
// the output format, aspect ratio, and whether the model can generate images
// of people.
type GoogleCloudAiplatformV1ImageConfig struct {
	// AspectRatio: Optional. The desired aspect ratio for the generated images.
	// The following aspect ratios are supported: "1:1" "2:3", "3:2" "3:4", "4:3"
	// "4:5", "5:4" "9:16", "16:9" "21:9"
	AspectRatio string `json:"aspectRatio,omitempty"`
	// ImageOutputOptions: Optional. The image output format for generated images.
	ImageOutputOptions *GoogleCloudAiplatformV1ImageConfigImageOutputOptions `json:"imageOutputOptions,omitempty"`
	// ImageSize: Optional. Specifies the size of generated images. Supported
	// values are `1K`, `2K`, `4K`. If not specified, the model will use default
	// value `1K`.
	ImageSize string `json:"imageSize,omitempty"`
	// PersonGeneration: Optional. Controls whether the model can generate people.
	//
	// Possible values:
	//   "PERSON_GENERATION_UNSPECIFIED" - The default behavior is unspecified. The
	// model will decide whether to generate images of people.
	//   "ALLOW_ALL" - Allows the model to generate images of people, including
	// adults and children.
	//   "ALLOW_ADULT" - Allows the model to generate images of adults, but not
	// children.
	//   "ALLOW_NONE" - Prevents the model from generating images of people.
	PersonGeneration string `json:"personGeneration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AspectRatio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AspectRatio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImageConfigImageOutputOptions: The image output
// format for generated images.
type GoogleCloudAiplatformV1ImageConfigImageOutputOptions struct {
	// CompressionQuality: Optional. The compression quality of the output image.
	CompressionQuality int64 `json:"compressionQuality,omitempty"`
	// MimeType: Optional. The image format that the output should be saved as.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompressionQuality") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompressionQuality") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImageConfigImageOutputOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImageConfigImageOutputOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataConfig: Describes the location from where
// we import data into a Dataset, together with the labels that will be applied
// to the DataItems and the Annotations.
type GoogleCloudAiplatformV1ImportDataConfig struct {
	// AnnotationLabels: Labels that will be applied to newly imported Annotations.
	// If two Annotations are identical, one of them will be deduped. Two
	// Annotations are considered identical if their payload, payload_schema_uri
	// and all of their labels are the same. These labels will be overridden by
	// Annotation labels specified inside index file referenced by
	// import_schema_uri, e.g. jsonl file.
	AnnotationLabels map[string]string `json:"annotationLabels,omitempty"`
	// DataItemLabels: Labels that will be applied to newly imported DataItems. If
	// an identical DataItem as one being imported already exists in the Dataset,
	// then these labels will be appended to these of the already existing one, and
	// if labels with identical key is imported before, the old label value will be
	// overwritten. If two DataItems are identical in the same import data
	// operation, the labels will be combined and if key collision happens in this
	// case, one of the values will be picked randomly. Two DataItems are
	// considered identical if their content bytes are identical (e.g. image bytes
	// or pdf bytes). These labels will be overridden by Annotation labels
	// specified inside index file referenced by import_schema_uri, e.g. jsonl
	// file.
	DataItemLabels map[string]string `json:"dataItemLabels,omitempty"`
	// GcsSource: The Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// ImportSchemaUri: Required. Points to a YAML file stored on Google Cloud
	// Storage describing the import format. Validation will be done against the
	// schema. The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	ImportSchemaUri string `json:"importSchemaUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataOperationMetadata: Runtime operation
// information for DatasetService.ImportData.
type GoogleCloudAiplatformV1ImportDataOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataRequest: Request message for
// DatasetService.ImportData.
type GoogleCloudAiplatformV1ImportDataRequest struct {
	// ImportConfigs: Required. The desired input locations. The contents of all
	// input locations will be imported in one batch.
	ImportConfigs []*GoogleCloudAiplatformV1ImportDataConfig `json:"importConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportDataResponse: Response message for
// DatasetService.ImportData.
type GoogleCloudAiplatformV1ImportDataResponse struct {
}

// GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata: Details of
// operations that perform import Feature values.
type GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata struct {
	// BlockingOperationIds: List of ImportFeatureValues operations running under a
	// single EntityType that are blocking this operation.
	BlockingOperationIds googleapi.Int64s `json:"blockingOperationIds,omitempty"`
	// GenericMetadata: Operation metadata for Featurestore import Feature values.
	GenericMetadata *GoogleCloudAiplatformV1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ImportedEntityCount: Number of entities that have been imported by the
	// operation.
	ImportedEntityCount int64 `json:"importedEntityCount,omitempty,string"`
	// ImportedFeatureValueCount: Number of Feature values that have been imported
	// by the operation.
	ImportedFeatureValueCount int64 `json:"importedFeatureValueCount,omitempty,string"`
	// InvalidRowCount: The number of rows in input source that weren't imported
	// due to either * Not having any featureValues. * Having a null entityId. *
	// Having a null timestamp. * Not being parsable (applicable for CSV sources).
	InvalidRowCount int64 `json:"invalidRowCount,omitempty,string"`
	// SourceUris: The source URI from where Feature values are imported.
	SourceUris []string `json:"sourceUris,omitempty"`
	// TimestampOutsideRetentionRowsCount: The number rows that weren't ingested
	// due to having timestamps outside the retention boundary.
	TimestampOutsideRetentionRowsCount int64 `json:"timestampOutsideRetentionRowsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BlockingOperationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingOperationIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportFeatureValuesRequest: Request message for
// FeaturestoreService.ImportFeatureValues.
type GoogleCloudAiplatformV1ImportFeatureValuesRequest struct {
	AvroSource     *GoogleCloudAiplatformV1AvroSource     `json:"avroSource,omitempty"`
	BigquerySource *GoogleCloudAiplatformV1BigQuerySource `json:"bigquerySource,omitempty"`
	CsvSource      *GoogleCloudAiplatformV1CsvSource      `json:"csvSource,omitempty"`
	// DisableIngestionAnalysis: If true, API doesn't start ingestion analysis
	// pipeline.
	DisableIngestionAnalysis bool `json:"disableIngestionAnalysis,omitempty"`
	// DisableOnlineServing: If set, data will not be imported for online serving.
	// This is typically used for backfilling, where Feature generation timestamps
	// are not in the timestamp range needed for online serving.
	DisableOnlineServing bool `json:"disableOnlineServing,omitempty"`
	// EntityIdField: Source column that holds entity IDs. If not provided, entity
	// IDs are extracted from the column named entity_id.
	EntityIdField string `json:"entityIdField,omitempty"`
	// FeatureSpecs: Required. Specifications defining which Feature values to
	// import from the entity. The request fails if no feature_specs are provided,
	// and having multiple feature_specs for one Feature is not allowed.
	FeatureSpecs []*GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec `json:"featureSpecs,omitempty"`
	// FeatureTime: Single Feature timestamp for all entities being imported. The
	// timestamp must not have higher than millisecond precision.
	FeatureTime string `json:"featureTime,omitempty"`
	// FeatureTimeField: Source column that holds the Feature timestamp for all
	// Feature values in each entity.
	FeatureTimeField string `json:"featureTimeField,omitempty"`
	// WorkerCount: Specifies the number of workers that are used to write data to
	// the Featurestore. Consider the online serving capacity that you require to
	// achieve the desired import throughput without interfering with online
	// serving. The value must be positive, and less than or equal to 100. If not
	// set, defaults to using 1 worker. The low count ensures minimal impact on
	// online serving performance.
	WorkerCount int64 `json:"workerCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvroSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvroSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec: Defines the
// Feature value(s) to import.
type GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec struct {
	// Id: Required. ID of the Feature to import values of. This Feature must exist
	// in the target EntityType, or the request will fail.
	Id string `json:"id,omitempty"`
	// SourceField: Source column to get the Feature values from. If not set, uses
	// the column with the same name as the Feature ID.
	SourceField string `json:"sourceField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesRequestFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportFeatureValuesResponse: Response message for
// FeaturestoreService.ImportFeatureValues.
type GoogleCloudAiplatformV1ImportFeatureValuesResponse struct {
	// ImportedEntityCount: Number of entities that have been imported by the
	// operation.
	ImportedEntityCount int64 `json:"importedEntityCount,omitempty,string"`
	// ImportedFeatureValueCount: Number of Feature values that have been imported
	// by the operation.
	ImportedFeatureValueCount int64 `json:"importedFeatureValueCount,omitempty,string"`
	// InvalidRowCount: The number of rows in input source that weren't imported
	// due to either * Not having any featureValues. * Having a null entityId. *
	// Having a null timestamp. * Not being parsable (applicable for CSV sources).
	InvalidRowCount int64 `json:"invalidRowCount,omitempty,string"`
	// TimestampOutsideRetentionRowsCount: The number rows that weren't ingested
	// due to having feature timestamps outside the retention boundary.
	TimestampOutsideRetentionRowsCount int64 `json:"timestampOutsideRetentionRowsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ImportedEntityCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportedEntityCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportFeatureValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportModelEvaluationRequest: Request message for
// ModelService.ImportModelEvaluation
type GoogleCloudAiplatformV1ImportModelEvaluationRequest struct {
	// ModelEvaluation: Required. Model evaluation resource to be imported.
	ModelEvaluation *GoogleCloudAiplatformV1ModelEvaluation `json:"modelEvaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelEvaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelEvaluation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportModelEvaluationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportModelEvaluationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportRagFilesConfig: Config for importing RagFiles.
type GoogleCloudAiplatformV1ImportRagFilesConfig struct {
	// GcsSource: Google Cloud Storage location. Supports importing individual
	// files as well as entire Google Cloud Storage directories. Sample formats: -
	// `gs://bucket_name/my_directory/object_name/my_file.txt` -
	// `gs://bucket_name/my_directory`
	GcsSource *GoogleCloudAiplatformV1GcsSource `json:"gcsSource,omitempty"`
	// GoogleDriveSource: Google Drive location. Supports importing individual
	// files as well as Google Drive folders.
	GoogleDriveSource *GoogleCloudAiplatformV1GoogleDriveSource `json:"googleDriveSource,omitempty"`
	// ImportResultBigquerySink: The BigQuery destination to write import result
	// to. It should be a bigquery table resource name (e.g.
	// "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
	// table does not exist, it will be created with the expected schema. If the
	// table exists, the schema will be validated and data will be added to this
	// existing table.
	ImportResultBigquerySink *GoogleCloudAiplatformV1BigQueryDestination `json:"importResultBigquerySink,omitempty"`
	// ImportResultGcsSink: The Cloud Storage path to write import result to.
	ImportResultGcsSink *GoogleCloudAiplatformV1GcsDestination `json:"importResultGcsSink,omitempty"`
	// JiraSource: Jira queries with their corresponding authentication.
	JiraSource *GoogleCloudAiplatformV1JiraSource `json:"jiraSource,omitempty"`
	// MaxEmbeddingRequestsPerMin: Optional. The max number of queries per minute
	// that this job is allowed to make to the embedding model specified on the
	// corpus. This value is specific to this job and not shared across other
	// import jobs. Consult the Quotas page on the project to set an appropriate
	// value here. If unspecified, a default value of 1,000 QPM would be used.
	MaxEmbeddingRequestsPerMin int64 `json:"maxEmbeddingRequestsPerMin,omitempty"`
	// PartialFailureBigquerySink: The BigQuery destination to write partial
	// failures to. It should be a bigquery table resource name (e.g.
	// "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
	// table does not exist, it will be created with the expected schema. If the
	// table exists, the schema will be validated and data will be added to this
	// existing table. Deprecated. Prefer to use `import_result_bq_sink`.
	PartialFailureBigquerySink *GoogleCloudAiplatformV1BigQueryDestination `json:"partialFailureBigquerySink,omitempty"`
	// PartialFailureGcsSink: The Cloud Storage path to write partial failures to.
	// Deprecated. Prefer to use `import_result_gcs_sink`.
	PartialFailureGcsSink *GoogleCloudAiplatformV1GcsDestination `json:"partialFailureGcsSink,omitempty"`
	// RagFileParsingConfig: Optional. Specifies the parsing config for RagFiles.
	// RAG will use the default parser if this field is not set.
	RagFileParsingConfig *GoogleCloudAiplatformV1RagFileParsingConfig `json:"ragFileParsingConfig,omitempty"`
	// RagFileTransformationConfig: Specifies the transformation config for
	// RagFiles.
	RagFileTransformationConfig *GoogleCloudAiplatformV1RagFileTransformationConfig `json:"ragFileTransformationConfig,omitempty"`
	// RebuildAnnIndex: Rebuilds the ANN index to optimize for recall on the
	// imported data. Only applicable for RagCorpora running on RagManagedDb with
	// `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
	// existing ANN config set on the RagCorpus. To change the ANN config, please
	// use the UpdateRagCorpus API. Default is false, i.e., index is not rebuilt.
	RebuildAnnIndex bool `json:"rebuildAnnIndex,omitempty"`
	// SharePointSources: SharePoint sources.
	SharePointSources *GoogleCloudAiplatformV1SharePointSources `json:"sharePointSources,omitempty"`
	// SlackSource: Slack channels with their corresponding access tokens.
	SlackSource *GoogleCloudAiplatformV1SlackSource `json:"slackSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportRagFilesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportRagFilesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1ImportRagFilesRequest: Request message for
// VertexRagDataService.ImportRagFiles.
type GoogleCloudAiplatformV1ImportRagFilesRequest struct {
	// ImportRagFilesConfig: Required. The config for the RagFiles to be synced and
	// imported into the RagCorpus. VertexRagDataService.ImportRagFiles.
	ImportRagFilesConfig *GoogleCloudAiplatformV1ImportRagFilesConfig `json:"importRagFilesConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportRagFilesConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportRagFilesConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1ImportRagFilesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1ImportRagFilesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Index: A representation of a collection of database
// items organized in a way that allows for approximate nearest neighbor (a.k.a
// ANN) algorithms search.
type GoogleCloudAiplatformV1Index struct {
	// CreateTime: Output only. Timestamp when this Index was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeployedIndexes: Output only. The pointers to DeployedIndexes created from
	// this Index. An Index can be only deleted if all its DeployedIndexes had been
	// undeployed first.
	DeployedIndexes []*GoogleCloudAiplatformV1DeployedIndexRef `json:"deployedIndexes,omitempty"`
	// Description: The description of the Index.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the Index. The name can be up to
	// 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Immutable. Customer-managed encryption key spec for an
	// Index. If set, this Index and all sub-resources of this Index will be
	// secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// IndexStats: Output only. Stats of the index resource.
	IndexStats *GoogleCloudAiplatformV1IndexStats `json:"indexStats,omitempty"`
	// IndexUpdateMethod: Immutable. The update method to use with this Index. If
	// not set, BATCH_UPDATE will be used by default.
	//
	// Possible values:
	//   "INDEX_UPDATE_METHOD_UNSPECIFIED" - Should not be used.
	//   "BATCH_UPDATE" - BatchUpdate: user can call UpdateIndex with files on
	// Cloud Storage of Datapoints to update.
	//   "STREAM_UPDATE" - StreamUpdate: user can call
	// UpsertDatapoints/DeleteDatapoints to update the Index and the updates will
	// be applied in corresponding DeployedIndexes in nearly real-time.
	IndexUpdateMethod string `json:"indexUpdateMethod,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Indexes.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: An additional information about the Index; the schema of the
	// metadata can be found in metadata_schema.
	Metadata interface{} `json:"metadata,omitempty"`
	// MetadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
	// Storage describing additional information about the Index, that is specific
	// to it. Unset if the Index does not have any additional information. The
	// schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`
	// Name: Output only. The resource name of the Index.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this Index was most recently
	// updated. This also includes any update to the contents of the Index. Note
	// that Operations working on this Index may have their
	// Operations.metadata.generic_metadata.update_time a little after the value of
	// this timestamp, yet that does not mean their results are not already
	// reflected in the Index. Result of any successfully completed Operation on
	// the Index is reflected in it.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Index) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Index
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexDatapoint: A datapoint of Index.
type GoogleCloudAiplatformV1IndexDatapoint struct {
	// CrowdingTag: Optional. CrowdingTag of the datapoint, the number of neighbors
	// to return in each crowding can be configured during query.
	CrowdingTag *GoogleCloudAiplatformV1IndexDatapointCrowdingTag `json:"crowdingTag,omitempty"`
	// DatapointId: Required. Unique identifier of the datapoint.
	DatapointId string `json:"datapointId,omitempty"`
	// EmbeddingMetadata: Optional. The key-value map of additional metadata for
	// the datapoint.
	EmbeddingMetadata googleapi.RawMessage `json:"embeddingMetadata,omitempty"`
	// FeatureVector: Required. Feature embedding vector for dense index. An array
	// of numbers with the length of [NearestNeighborSearchConfig.dimensions].
	FeatureVector []float64 `json:"featureVector,omitempty"`
	// NumericRestricts: Optional. List of Restrict of the datapoint, used to
	// perform "restricted searches" where boolean rule are used to filter the
	// subset of the database eligible for matching. This uses numeric comparisons.
	NumericRestricts []*GoogleCloudAiplatformV1IndexDatapointNumericRestriction `json:"numericRestricts,omitempty"`
	// Restricts: Optional. List of Restrict of the datapoint, used to perform
	// "restricted searches" where boolean rule are used to filter the subset of
	// the database eligible for matching. This uses categorical tokens. See:
	// https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
	Restricts []*GoogleCloudAiplatformV1IndexDatapointRestriction `json:"restricts,omitempty"`
	// SparseEmbedding: Optional. Feature embedding vector for sparse index.
	SparseEmbedding *GoogleCloudAiplatformV1IndexDatapointSparseEmbedding `json:"sparseEmbedding,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrowdingTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrowdingTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexDatapoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1IndexDatapoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1IndexDatapoint
	var s1 struct {
		FeatureVector []gensupport.JSONFloat64 `json:"featureVector"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FeatureVector = make([]float64, len(s1.FeatureVector))
	for i := range s1.FeatureVector {
		s.FeatureVector[i] = float64(s1.FeatureVector[i])
	}
	return nil
}

// GoogleCloudAiplatformV1IndexDatapointCrowdingTag: Crowding tag is a
// constraint on a neighbor list produced by nearest neighbor search requiring
// that no more than some value k' of the k neighbors returned have the same
// value of crowding_attribute.
type GoogleCloudAiplatformV1IndexDatapointCrowdingTag struct {
	// CrowdingAttribute: The attribute value used for crowding. The maximum number
	// of neighbors to return per crowding attribute value
	// (per_crowding_attribute_num_neighbors) is configured per-query. This field
	// is ignored if per_crowding_attribute_num_neighbors is larger than the total
	// number of neighbors to return for a given query.
	CrowdingAttribute string `json:"crowdingAttribute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrowdingAttribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrowdingAttribute") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexDatapointCrowdingTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointCrowdingTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexDatapointNumericRestriction: This field allows
// restricts to be based on numeric comparisons rather than categorical tokens.
type GoogleCloudAiplatformV1IndexDatapointNumericRestriction struct {
	// Namespace: The namespace of this restriction. e.g.: cost.
	Namespace string `json:"namespace,omitempty"`
	// Op: This MUST be specified for queries and must NOT be specified for
	// datapoints.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Default value of the enum.
	//   "LESS" - Datapoints are eligible iff their value is < the query's.
	//   "LESS_EQUAL" - Datapoints are eligible iff their value is <= the query's.
	//   "EQUAL" - Datapoints are eligible iff their value is == the query's.
	//   "GREATER_EQUAL" - Datapoints are eligible iff their value is >= the
	// query's.
	//   "GREATER" - Datapoints are eligible iff their value is > the query's.
	//   "NOT_EQUAL" - Datapoints are eligible iff their value is != the query's.
	Op string `json:"op,omitempty"`
	// ValueDouble: Represents 64 bit float.
	ValueDouble float64 `json:"valueDouble,omitempty"`
	// ValueFloat: Represents 32 bit float.
	ValueFloat float64 `json:"valueFloat,omitempty"`
	// ValueInt: Represents 64 bit integer.
	ValueInt int64 `json:"valueInt,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Namespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Namespace") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexDatapointNumericRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointNumericRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1IndexDatapointNumericRestriction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointNumericRestriction
	var s1 struct {
		ValueDouble gensupport.JSONFloat64 `json:"valueDouble"`
		ValueFloat  gensupport.JSONFloat64 `json:"valueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ValueDouble = float64(s1.ValueDouble)
	s.ValueFloat = float64(s1.ValueFloat)
	return nil
}

// GoogleCloudAiplatformV1IndexDatapointRestriction: Restriction of a datapoint
// which describe its attributes(tokens) from each of several attribute
// categories(namespaces).
type GoogleCloudAiplatformV1IndexDatapointRestriction struct {
	// AllowList: The attributes to allow in this namespace. e.g.: 'red'
	AllowList []string `json:"allowList,omitempty"`
	// DenyList: The attributes to deny in this namespace. e.g.: 'blue'
	DenyList []string `json:"denyList,omitempty"`
	// Namespace: The namespace of this restriction. e.g.: color.
	Namespace string `json:"namespace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexDatapointRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexDatapointSparseEmbedding: Feature embedding
// vector for sparse index. An array of numbers whose values are located in the
// specified dimensions.
type GoogleCloudAiplatformV1IndexDatapointSparseEmbedding struct {
	// Dimensions: Required. The list of indexes for the embedding values of the
	// sparse vector.
	Dimensions googleapi.Int64s `json:"dimensions,omitempty"`
	// Values: Required. The list of embedding values of the sparse vector.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexDatapointSparseEmbedding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointSparseEmbedding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1IndexDatapointSparseEmbedding) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1IndexDatapointSparseEmbedding
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudAiplatformV1IndexEndpoint: Indexes are deployed into it. An
// IndexEndpoint can have multiple DeployedIndexes.
type GoogleCloudAiplatformV1IndexEndpoint struct {
	// CreateTime: Output only. Timestamp when this IndexEndpoint was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeployedIndexes: Output only. The indexes deployed in this endpoint.
	DeployedIndexes []*GoogleCloudAiplatformV1DeployedIndex `json:"deployedIndexes,omitempty"`
	// Description: The description of the IndexEndpoint.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the IndexEndpoint. The name can
	// be up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EnablePrivateServiceConnect: Optional. Deprecated: If true, expose the
	// IndexEndpoint via private service connect. Only one of the fields, network
	// or enable_private_service_connect, can be set.
	EnablePrivateServiceConnect bool `json:"enablePrivateServiceConnect,omitempty"`
	// EncryptionSpec: Immutable. Customer-managed encryption key spec for an
	// IndexEndpoint. If set, this IndexEndpoint and all sub-resources of this
	// IndexEndpoint will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your
	// IndexEndpoints. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name of the IndexEndpoint.
	Name string `json:"name,omitempty"`
	// Network: Optional. The full name of the Google Compute Engine network
	// (https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to
	// which the IndexEndpoint should be peered. Private services access must
	// already be configured for the network. If left unspecified, the Endpoint is
	// not peered with any network. network and private_service_connect_config are
	// mutually exclusive. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`. Where {project} is a project
	// number, as in '12345', and {network} is network name.
	Network string `json:"network,omitempty"`
	// PrivateServiceConnectConfig: Optional. Configuration for private service
	// connect. network and private_service_connect_config are mutually exclusive.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// PublicEndpointDomainName: Output only. If public_endpoint_enabled is true,
	// this field will be populated with the domain name to use for this index
	// endpoint.
	PublicEndpointDomainName string `json:"publicEndpointDomainName,omitempty"`
	// PublicEndpointEnabled: Optional. If true, the deployed index will be
	// accessible through public endpoint.
	PublicEndpointEnabled bool `json:"publicEndpointEnabled,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this IndexEndpoint was last updated.
	// This timestamp is not updated when the endpoint's DeployedIndexes are
	// updated, e.g. due to updates of the original Indexes they are the
	// deployments of.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexPrivateEndpoints: IndexPrivateEndpoints proto is
// used to provide paths for users to send requests via private endpoints (e.g.
// private service access, private service connect). To send request via
// private service access, use match_grpc_address. To send request via private
// service connect, use service_attachment.
type GoogleCloudAiplatformV1IndexPrivateEndpoints struct {
	// MatchGrpcAddress: Output only. The ip address used to send match gRPC
	// requests.
	MatchGrpcAddress string `json:"matchGrpcAddress,omitempty"`
	// PscAutomatedEndpoints: Output only. PscAutomatedEndpoints is populated if
	// private service connect is enabled if PscAutomatedConfig is set.
	PscAutomatedEndpoints []*GoogleCloudAiplatformV1PscAutomatedEndpoints `json:"pscAutomatedEndpoints,omitempty"`
	// ServiceAttachment: Output only. The name of the service attachment resource.
	// Populated if private service connect is enabled.
	ServiceAttachment string `json:"serviceAttachment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MatchGrpcAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MatchGrpcAddress") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexPrivateEndpoints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexPrivateEndpoints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IndexStats: Stats of the Index.
type GoogleCloudAiplatformV1IndexStats struct {
	// ShardsCount: Output only. The number of shards in the Index.
	ShardsCount int64 `json:"shardsCount,omitempty"`
	// SparseVectorsCount: Output only. The number of sparse vectors in the Index.
	SparseVectorsCount int64 `json:"sparseVectorsCount,omitempty,string"`
	// VectorsCount: Output only. The number of dense vectors in the Index.
	VectorsCount int64 `json:"vectorsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ShardsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShardsCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IndexStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IndexStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1InputDataConfig: Specifies Vertex AI owned input data
// to be used for training, and possibly evaluating, the Model.
type GoogleCloudAiplatformV1InputDataConfig struct {
	// AnnotationSchemaUri: Applicable only to custom training with Datasets that
	// have DataItems and Annotations. Cloud Storage URI that points to a YAML file
	// describing the annotation schema. The schema is defined as an OpenAPI 3.0.2
	// Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
	// chosen schema must be consistent with metadata of the Dataset specified by
	// dataset_id. Only Annotations that both match this schema and belong to
	// DataItems not ignored by the split method are used in respectively training,
	// validation or test role, depending on the role of the DataItem they are on.
	// When used in conjunction with annotations_filter, the Annotations used for
	// training are filtered by both annotations_filter and annotation_schema_uri.
	AnnotationSchemaUri string `json:"annotationSchemaUri,omitempty"`
	// AnnotationsFilter: Applicable only to Datasets that have DataItems and
	// Annotations. A filter on Annotations of the Dataset. Only Annotations that
	// both match this filter and belong to DataItems not ignored by the split
	// method are used in respectively training, validation or test role, depending
	// on the role of the DataItem they are on (for the auto-assigned that role is
	// decided by Vertex AI). A filter with same syntax as the one used in
	// ListAnnotations may be used, but note here it filters across all Annotations
	// of the Dataset, and not just within a single DataItem.
	AnnotationsFilter string `json:"annotationsFilter,omitempty"`
	// BigqueryDestination: Only applicable to custom training with tabular Dataset
	// with BigQuery source. The BigQuery project location where the training data
	// is to be written to. In the given project a new dataset is created with name
	// `dataset___` where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All
	// training input data is written into that dataset. In the dataset three
	// tables are created, `training`, `validation` and `test`. * AIP_DATA_FORMAT =
	// "bigquery". * AIP_TRAINING_DATA_URI =
	// "bigquery_destination.dataset___.training" * AIP_VALIDATION_DATA_URI =
	// "bigquery_destination.dataset___.validation" * AIP_TEST_DATA_URI =
	// "bigquery_destination.dataset___.test"
	BigqueryDestination *GoogleCloudAiplatformV1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// DatasetId: Required. The ID of the Dataset in the same Project and Location
	// which data will be used to train the Model. The Dataset must use schema
	// compatible with Model being trained, and what is compatible should be
	// described in the used TrainingPipeline's training_task_definition. For
	// tabular Datasets, all their data is exported to training, to pick and choose
	// from.
	DatasetId string `json:"datasetId,omitempty"`
	// FilterSplit: Split based on the provided filters for each set.
	FilterSplit *GoogleCloudAiplatformV1FilterSplit `json:"filterSplit,omitempty"`
	// FractionSplit: Split based on fractions defining the size of each set.
	FractionSplit *GoogleCloudAiplatformV1FractionSplit `json:"fractionSplit,omitempty"`
	// GcsDestination: The Cloud Storage location where the training data is to be
	// written to. In the given directory a new directory is created with name:
	// `dataset---` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
	// All training input data is written into that directory. The Vertex AI
	// environment variables representing Cloud Storage data URIs are represented
	// in the Cloud Storage wildcard format to support sharded data. e.g.:
	// "gs://.../training-*.jsonl" * AIP_DATA_FORMAT = "jsonl" for non-tabular
	// data, "csv" for tabular data * AIP_TRAINING_DATA_URI =
	// "gcs_destination/dataset---/training-*.${AIP_DATA_FORMAT}" *
	// AIP_VALIDATION_DATA_URI =
	// "gcs_destination/dataset---/validation-*.${AIP_DATA_FORMAT}" *
	// AIP_TEST_DATA_URI = "gcs_destination/dataset---/test-*.${AIP_DATA_FORMAT}"
	GcsDestination *GoogleCloudAiplatformV1GcsDestination `json:"gcsDestination,omitempty"`
	// PersistMlUseAssignment: Whether to persist the ML use assignment to data
	// item system labels.
	PersistMlUseAssignment bool `json:"persistMlUseAssignment,omitempty"`
	// PredefinedSplit: Supported only for tabular Datasets. Split based on a
	// predefined key.
	PredefinedSplit *GoogleCloudAiplatformV1PredefinedSplit `json:"predefinedSplit,omitempty"`
	// SavedQueryId: Only applicable to Datasets that have SavedQueries. The ID of
	// a SavedQuery (annotation set) under the Dataset specified by dataset_id used
	// for filtering Annotations for training. Only Annotations that are associated
	// with this SavedQuery are used in respectively training. When used in
	// conjunction with annotations_filter, the Annotations used for training are
	// filtered by both saved_query_id and annotations_filter. Only one of
	// saved_query_id and annotation_schema_uri should be specified as both of them
	// represent the same thing: problem type.
	SavedQueryId string `json:"savedQueryId,omitempty"`
	// StratifiedSplit: Supported only for tabular Datasets. Split based on the
	// distribution of the specified column.
	StratifiedSplit *GoogleCloudAiplatformV1StratifiedSplit `json:"stratifiedSplit,omitempty"`
	// TimestampSplit: Supported only for tabular Datasets. Split based on the
	// timestamp of the input data pieces.
	TimestampSplit *GoogleCloudAiplatformV1TimestampSplit `json:"timestampSplit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSchemaUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSchemaUri") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1InputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1InputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1Int64Array: A list of int64 values.
type GoogleCloudAiplatformV1Int64Array struct {
	// Values: A list of int64 values.
	Values googleapi.Int64s `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1Int64Array) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1Int64Array
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IntegratedGradientsAttribution: An attribution method
// that computes the Aumann-Shapley value taking advantage of the model's fully
// differentiable structure. Refer to this paper for more details:
// https://arxiv.org/abs/1703.01365
type GoogleCloudAiplatformV1IntegratedGradientsAttribution struct {
	// BlurBaselineConfig: Config for IG with blur baseline. When enabled, a linear
	// path from the maximally blurred image to the input image is created. Using a
	// blurred baseline instead of zero (black image) is motivated by the BlurIG
	// approach explained here: https://arxiv.org/abs/2004.03383
	BlurBaselineConfig *GoogleCloudAiplatformV1BlurBaselineConfig `json:"blurBaselineConfig,omitempty"`
	// SmoothGradConfig: Config for SmoothGrad approximation of gradients. When
	// enabled, the gradients are approximated by averaging the gradients from
	// noisy samples in the vicinity of the inputs. Adding noise can help improve
	// the computed gradients. Refer to this paper for more details:
	// https://arxiv.org/pdf/1706.03825.pdf
	SmoothGradConfig *GoogleCloudAiplatformV1SmoothGradConfig `json:"smoothGradConfig,omitempty"`
	// StepCount: Required. The number of steps for approximating the path
	// integral. A good value to start is 50 and gradually increase until the sum
	// to diff property is within the desired error range. Valid range of its value
	// is [1, 100], inclusively.
	StepCount int64 `json:"stepCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlurBaselineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlurBaselineConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1IntegratedGradientsAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1IntegratedGradientsAttribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1IntermediateExtractedMemory: An extracted memory that
// is the intermediate result before consolidation.
type GoogleCloudAiplatformV1IntermediateExtractedMemory struct {
	// Fact: Output only. The fact of the extracted memory.
	Fact string `json:"fact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fact") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fact") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API reque