// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Database Management API
//
// Use the Database Management API to monitor and manage resources such as
// Oracle Databases, MySQL Databases, and External Database Systems.
// For more information, see Database Management (https://docs.oracle.com/iaas/database-management/home.htm).
//

package databasemanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// MySqlDatabaseUsageMetrics The list of aggregated metrics for Managed MySQL Databases in the fleet.
type MySqlDatabaseUsageMetrics struct {

	// The OCID of the compartment where the Managed MySQL Database resides.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The display name of the Managed MySQL Database.
	DatabaseName *string `mandatory:"true" json:"databaseName"`

	// Indicates MySQL Database type, ONPREMISE or MySQL Database System.
	DatabaseType *string `mandatory:"true" json:"databaseType"`

	// The type of MySQL Database System.
	MdsDeploymentType *string `mandatory:"true" json:"mdsDeploymentType"`

	// The lifecycle state of the MySQL Database System.
	MdslifecycleState *string `mandatory:"true" json:"mdslifecycleState"`

	// The version of the MySQL Database.
	DatabaseVersion *string `mandatory:"true" json:"databaseVersion"`

	// The OCID of the Managed MySQL Database.
	DbId *string `mandatory:"true" json:"dbId"`

	// The status of the MySQL Database. Indicates whether the status of the database
	// is UP, DOWN, or UNKNOWN at the current time.
	DatabaseStatus MySqlDatabaseStatusEnum `mandatory:"true" json:"databaseStatus"`

	// A list of the database health metrics like CPU, Storage, and Memory.
	Metrics []MySqlFleetMetricDefinition `mandatory:"true" json:"metrics"`

	// The customer's selected type for HeatWave management.
	HeatWaveManagementType ManagedMySqlDatabaseHeatWaveManagementTypeEnum `mandatory:"false" json:"heatWaveManagementType,omitempty"`

	// Indicates whether HeatWave is enabled for the MySQL Database System or not.
	IsHeatWaveEnabled *bool `mandatory:"false" json:"isHeatWaveEnabled"`

	// The name of the HeatWave cluster.
	HeatWaveClusterDisplayName *string `mandatory:"false" json:"heatWaveClusterDisplayName"`

	// The number of nodes in the HeatWave cluster.
	HeatWaveNodeCount *int `mandatory:"false" json:"heatWaveNodeCount"`
}

func (m MySqlDatabaseUsageMetrics) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m MySqlDatabaseUsageMetrics) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingMySqlDatabaseStatusEnum(string(m.DatabaseStatus)); !ok && m.DatabaseStatus != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for DatabaseStatus: %s. Supported values are: %s.", m.DatabaseStatus, strings.Join(GetMySqlDatabaseStatusEnumStringValues(), ",")))
	}

	if _, ok := GetMappingManagedMySqlDatabaseHeatWaveManagementTypeEnum(string(m.HeatWaveManagementType)); !ok && m.HeatWaveManagementType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HeatWaveManagementType: %s. Supported values are: %s.", m.HeatWaveManagementType, strings.Join(GetManagedMySqlDatabaseHeatWaveManagementTypeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
