// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Generative AI Agents Client API
//
// OCI Generative AI Agents is a fully managed service that combines the power of large language models (LLMs) with an intelligent retrieval system to create contextually relevant answers by searching your knowledge base, making your AI applications smart and efficient.
// OCI Generative AI Agents supports several ways to onboard your data and then allows you and your customers to interact with your data using a chat interface or API.
// Use the Generative AI Agents Client API to create and manage client chat sessions. A session represents an interactive conversation initiated by a user through an API to engage with an agent. It involves a series of exchanges where the user sends queries or prompts, and the agent responds with relevant information, actions, or assistance based on the user's input. The session persists for the duration of the interaction, maintaining context and continuity to provide coherent and meaningful responses throughout the conversation.
// For creating and managing agents, knowledge bases, data sources, endpoints, and data ingestion jobs see the /EN/generative-ai-agents/latest/.
// To learn more about the service, see the Generative AI Agents documentation (https://docs.oracle.com/iaas/Content/generative-ai-agents/home.htm).
//

package generativeaiagentruntime

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ChatResult The response of a chat request.
type ChatResult struct {
	Message *Message `mandatory:"false" json:"message"`

	// The trace that displays the internal progression, such as reasoning and actions during an execution.
	Traces []Trace `mandatory:"false" json:"traces"`

	// A map where each key is a toolId and the value contains tool type and additional dynamic results.
	ToolResults map[string]string `mandatory:"false" json:"toolResults"`

	// A list of actions the agent requires the user or agent client to perform.
	RequiredActions []RequiredAction `mandatory:"false" json:"requiredActions"`

	// Captures the result of guardrail evaluations as JSON string performed on either the input to the agent or the output generated by the agent.
	GuardrailResult *string `mandatory:"false" json:"guardrailResult"`
}

func (m ChatResult) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ChatResult) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *ChatResult) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		Message         *Message          `json:"message"`
		Traces          []trace           `json:"traces"`
		ToolResults     map[string]string `json:"toolResults"`
		RequiredActions []requiredaction  `json:"requiredActions"`
		GuardrailResult *string           `json:"guardrailResult"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	m.Message = model.Message

	m.Traces = make([]Trace, len(model.Traces))
	for i, n := range model.Traces {
		nn, e = n.UnmarshalPolymorphicJSON(n.JsonData)
		if e != nil {
			return e
		}
		if nn != nil {
			m.Traces[i] = nn.(Trace)
		} else {
			m.Traces[i] = nil
		}
	}
	m.ToolResults = model.ToolResults

	m.RequiredActions = make([]RequiredAction, len(model.RequiredActions))
	for i, n := range model.RequiredActions {
		nn, e = n.UnmarshalPolymorphicJSON(n.JsonData)
		if e != nil {
			return e
		}
		if nn != nil {
			m.RequiredActions[i] = nn.(RequiredAction)
		} else {
			m.RequiredActions[i] = nil
		}
	}
	m.GuardrailResult = model.GuardrailResult

	return
}
