// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Ops Insights API
//
// Use the Ops Insights API to perform data extraction operations to obtain database
// resource utilization, performance statistics, and reference information. For more information,
// see About Oracle Cloud Infrastructure Ops Insights (https://docs.oracle.com/iaas/en-us/iaas/operations-insights/doc/operations-insights.html).
//

package opsi

import (
	"strings"
)

// ConfigurationItemAllowedValueTypeEnum Enum with underlying type: string
type ConfigurationItemAllowedValueTypeEnum string

// Set of constants representing the allowable values for ConfigurationItemAllowedValueTypeEnum
const (
	ConfigurationItemAllowedValueTypeLimit    ConfigurationItemAllowedValueTypeEnum = "LIMIT"
	ConfigurationItemAllowedValueTypePick     ConfigurationItemAllowedValueTypeEnum = "PICK"
	ConfigurationItemAllowedValueTypeFreeText ConfigurationItemAllowedValueTypeEnum = "FREE_TEXT"
)

var mappingConfigurationItemAllowedValueTypeEnum = map[string]ConfigurationItemAllowedValueTypeEnum{
	"LIMIT":     ConfigurationItemAllowedValueTypeLimit,
	"PICK":      ConfigurationItemAllowedValueTypePick,
	"FREE_TEXT": ConfigurationItemAllowedValueTypeFreeText,
}

var mappingConfigurationItemAllowedValueTypeEnumLowerCase = map[string]ConfigurationItemAllowedValueTypeEnum{
	"limit":     ConfigurationItemAllowedValueTypeLimit,
	"pick":      ConfigurationItemAllowedValueTypePick,
	"free_text": ConfigurationItemAllowedValueTypeFreeText,
}

// GetConfigurationItemAllowedValueTypeEnumValues Enumerates the set of values for ConfigurationItemAllowedValueTypeEnum
func GetConfigurationItemAllowedValueTypeEnumValues() []ConfigurationItemAllowedValueTypeEnum {
	values := make([]ConfigurationItemAllowedValueTypeEnum, 0)
	for _, v := range mappingConfigurationItemAllowedValueTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetConfigurationItemAllowedValueTypeEnumStringValues Enumerates the set of values in String for ConfigurationItemAllowedValueTypeEnum
func GetConfigurationItemAllowedValueTypeEnumStringValues() []string {
	return []string{
		"LIMIT",
		"PICK",
		"FREE_TEXT",
	}
}

// GetMappingConfigurationItemAllowedValueTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingConfigurationItemAllowedValueTypeEnum(val string) (ConfigurationItemAllowedValueTypeEnum, bool) {
	enum, ok := mappingConfigurationItemAllowedValueTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
