// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package dblm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListVulnerabilityScansRequest wrapper for the ListVulnerabilityScans operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/dblm/ListVulnerabilityScans.go.html to see an example of how to use ListVulnerabilityScansRequest.
type ListVulnerabilityScansRequest struct {

	// The ID of the vulnerability scan.
	VulnerabilityScanId *string `mandatory:"false" contributesTo:"query" name:"vulnerabilityScanId"`

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"false" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListVulnerabilityScansSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is descending.
	SortBy ListVulnerabilityScansSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The created greater than.
	TimeCreatedGreaterThan *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeCreatedGreaterThan"`

	// The time ended less than.
	TimeEndedLessThan *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeEndedLessThan"`

	// Filter by one or more vulnerability scan status.
	// Possible values are completed, running, completed with error, aborted.
	VulnerabilityScanStatus []ListVulnerabilityScansVulnerabilityScanStatusEnum `contributesTo:"query" name:"vulnerabilityScanStatus" omitEmpty:"true" collectionFormat:"multi"`

	// The scan type to use is 'CVE', 'PATCH' or 'IMAGE_PATCH'.
	VulnerabilityScanType ListVulnerabilityScansVulnerabilityScanTypeEnum `mandatory:"false" contributesTo:"query" name:"vulnerabilityScanType" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListVulnerabilityScansRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListVulnerabilityScansRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListVulnerabilityScansRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListVulnerabilityScansRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListVulnerabilityScansRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListVulnerabilityScansSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListVulnerabilityScansSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityScansSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListVulnerabilityScansSortByEnumStringValues(), ",")))
	}
	for _, val := range request.VulnerabilityScanStatus {
		if _, ok := GetMappingListVulnerabilityScansVulnerabilityScanStatusEnum(string(val)); !ok && val != "" {
			errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityScanStatus: %s. Supported values are: %s.", val, strings.Join(GetListVulnerabilityScansVulnerabilityScanStatusEnumStringValues(), ",")))
		}
	}

	if _, ok := GetMappingListVulnerabilityScansVulnerabilityScanTypeEnum(string(request.VulnerabilityScanType)); !ok && request.VulnerabilityScanType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityScanType: %s. Supported values are: %s.", request.VulnerabilityScanType, strings.Join(GetListVulnerabilityScansVulnerabilityScanTypeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListVulnerabilityScansResponse wrapper for the ListVulnerabilityScans operation
type ListVulnerabilityScansResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of VulnerabilityScanCollection instances
	VulnerabilityScanCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListVulnerabilityScansResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListVulnerabilityScansResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListVulnerabilityScansSortOrderEnum Enum with underlying type: string
type ListVulnerabilityScansSortOrderEnum string

// Set of constants representing the allowable values for ListVulnerabilityScansSortOrderEnum
const (
	ListVulnerabilityScansSortOrderAsc  ListVulnerabilityScansSortOrderEnum = "ASC"
	ListVulnerabilityScansSortOrderDesc ListVulnerabilityScansSortOrderEnum = "DESC"
)

var mappingListVulnerabilityScansSortOrderEnum = map[string]ListVulnerabilityScansSortOrderEnum{
	"ASC":  ListVulnerabilityScansSortOrderAsc,
	"DESC": ListVulnerabilityScansSortOrderDesc,
}

var mappingListVulnerabilityScansSortOrderEnumLowerCase = map[string]ListVulnerabilityScansSortOrderEnum{
	"asc":  ListVulnerabilityScansSortOrderAsc,
	"desc": ListVulnerabilityScansSortOrderDesc,
}

// GetListVulnerabilityScansSortOrderEnumValues Enumerates the set of values for ListVulnerabilityScansSortOrderEnum
func GetListVulnerabilityScansSortOrderEnumValues() []ListVulnerabilityScansSortOrderEnum {
	values := make([]ListVulnerabilityScansSortOrderEnum, 0)
	for _, v := range mappingListVulnerabilityScansSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityScansSortOrderEnumStringValues Enumerates the set of values in String for ListVulnerabilityScansSortOrderEnum
func GetListVulnerabilityScansSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListVulnerabilityScansSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityScansSortOrderEnum(val string) (ListVulnerabilityScansSortOrderEnum, bool) {
	enum, ok := mappingListVulnerabilityScansSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityScansSortByEnum Enum with underlying type: string
type ListVulnerabilityScansSortByEnum string

// Set of constants representing the allowable values for ListVulnerabilityScansSortByEnum
const (
	ListVulnerabilityScansSortById          ListVulnerabilityScansSortByEnum = "id"
	ListVulnerabilityScansSortByDisplayname ListVulnerabilityScansSortByEnum = "displayName"
	ListVulnerabilityScansSortByTimecreated ListVulnerabilityScansSortByEnum = "timeCreated"
	ListVulnerabilityScansSortByTimeended   ListVulnerabilityScansSortByEnum = "timeEnded"
)

var mappingListVulnerabilityScansSortByEnum = map[string]ListVulnerabilityScansSortByEnum{
	"id":          ListVulnerabilityScansSortById,
	"displayName": ListVulnerabilityScansSortByDisplayname,
	"timeCreated": ListVulnerabilityScansSortByTimecreated,
	"timeEnded":   ListVulnerabilityScansSortByTimeended,
}

var mappingListVulnerabilityScansSortByEnumLowerCase = map[string]ListVulnerabilityScansSortByEnum{
	"id":          ListVulnerabilityScansSortById,
	"displayname": ListVulnerabilityScansSortByDisplayname,
	"timecreated": ListVulnerabilityScansSortByTimecreated,
	"timeended":   ListVulnerabilityScansSortByTimeended,
}

// GetListVulnerabilityScansSortByEnumValues Enumerates the set of values for ListVulnerabilityScansSortByEnum
func GetListVulnerabilityScansSortByEnumValues() []ListVulnerabilityScansSortByEnum {
	values := make([]ListVulnerabilityScansSortByEnum, 0)
	for _, v := range mappingListVulnerabilityScansSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityScansSortByEnumStringValues Enumerates the set of values in String for ListVulnerabilityScansSortByEnum
func GetListVulnerabilityScansSortByEnumStringValues() []string {
	return []string{
		"id",
		"displayName",
		"timeCreated",
		"timeEnded",
	}
}

// GetMappingListVulnerabilityScansSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityScansSortByEnum(val string) (ListVulnerabilityScansSortByEnum, bool) {
	enum, ok := mappingListVulnerabilityScansSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityScansVulnerabilityScanStatusEnum Enum with underlying type: string
type ListVulnerabilityScansVulnerabilityScanStatusEnum string

// Set of constants representing the allowable values for ListVulnerabilityScansVulnerabilityScanStatusEnum
const (
	ListVulnerabilityScansVulnerabilityScanStatusCompleted ListVulnerabilityScansVulnerabilityScanStatusEnum = "COMPLETED"
	ListVulnerabilityScansVulnerabilityScanStatusError     ListVulnerabilityScansVulnerabilityScanStatusEnum = "ERROR"
	ListVulnerabilityScansVulnerabilityScanStatusRunning   ListVulnerabilityScansVulnerabilityScanStatusEnum = "RUNNING"
	ListVulnerabilityScansVulnerabilityScanStatusAborted   ListVulnerabilityScansVulnerabilityScanStatusEnum = "ABORTED"
)

var mappingListVulnerabilityScansVulnerabilityScanStatusEnum = map[string]ListVulnerabilityScansVulnerabilityScanStatusEnum{
	"COMPLETED": ListVulnerabilityScansVulnerabilityScanStatusCompleted,
	"ERROR":     ListVulnerabilityScansVulnerabilityScanStatusError,
	"RUNNING":   ListVulnerabilityScansVulnerabilityScanStatusRunning,
	"ABORTED":   ListVulnerabilityScansVulnerabilityScanStatusAborted,
}

var mappingListVulnerabilityScansVulnerabilityScanStatusEnumLowerCase = map[string]ListVulnerabilityScansVulnerabilityScanStatusEnum{
	"completed": ListVulnerabilityScansVulnerabilityScanStatusCompleted,
	"error":     ListVulnerabilityScansVulnerabilityScanStatusError,
	"running":   ListVulnerabilityScansVulnerabilityScanStatusRunning,
	"aborted":   ListVulnerabilityScansVulnerabilityScanStatusAborted,
}

// GetListVulnerabilityScansVulnerabilityScanStatusEnumValues Enumerates the set of values for ListVulnerabilityScansVulnerabilityScanStatusEnum
func GetListVulnerabilityScansVulnerabilityScanStatusEnumValues() []ListVulnerabilityScansVulnerabilityScanStatusEnum {
	values := make([]ListVulnerabilityScansVulnerabilityScanStatusEnum, 0)
	for _, v := range mappingListVulnerabilityScansVulnerabilityScanStatusEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityScansVulnerabilityScanStatusEnumStringValues Enumerates the set of values in String for ListVulnerabilityScansVulnerabilityScanStatusEnum
func GetListVulnerabilityScansVulnerabilityScanStatusEnumStringValues() []string {
	return []string{
		"COMPLETED",
		"ERROR",
		"RUNNING",
		"ABORTED",
	}
}

// GetMappingListVulnerabilityScansVulnerabilityScanStatusEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityScansVulnerabilityScanStatusEnum(val string) (ListVulnerabilityScansVulnerabilityScanStatusEnum, bool) {
	enum, ok := mappingListVulnerabilityScansVulnerabilityScanStatusEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityScansVulnerabilityScanTypeEnum Enum with underlying type: string
type ListVulnerabilityScansVulnerabilityScanTypeEnum string

// Set of constants representing the allowable values for ListVulnerabilityScansVulnerabilityScanTypeEnum
const (
	ListVulnerabilityScansVulnerabilityScanTypeCve        ListVulnerabilityScansVulnerabilityScanTypeEnum = "CVE"
	ListVulnerabilityScansVulnerabilityScanTypePatch      ListVulnerabilityScansVulnerabilityScanTypeEnum = "PATCH"
	ListVulnerabilityScansVulnerabilityScanTypeImagePatch ListVulnerabilityScansVulnerabilityScanTypeEnum = "IMAGE_PATCH"
)

var mappingListVulnerabilityScansVulnerabilityScanTypeEnum = map[string]ListVulnerabilityScansVulnerabilityScanTypeEnum{
	"CVE":         ListVulnerabilityScansVulnerabilityScanTypeCve,
	"PATCH":       ListVulnerabilityScansVulnerabilityScanTypePatch,
	"IMAGE_PATCH": ListVulnerabilityScansVulnerabilityScanTypeImagePatch,
}

var mappingListVulnerabilityScansVulnerabilityScanTypeEnumLowerCase = map[string]ListVulnerabilityScansVulnerabilityScanTypeEnum{
	"cve":         ListVulnerabilityScansVulnerabilityScanTypeCve,
	"patch":       ListVulnerabilityScansVulnerabilityScanTypePatch,
	"image_patch": ListVulnerabilityScansVulnerabilityScanTypeImagePatch,
}

// GetListVulnerabilityScansVulnerabilityScanTypeEnumValues Enumerates the set of values for ListVulnerabilityScansVulnerabilityScanTypeEnum
func GetListVulnerabilityScansVulnerabilityScanTypeEnumValues() []ListVulnerabilityScansVulnerabilityScanTypeEnum {
	values := make([]ListVulnerabilityScansVulnerabilityScanTypeEnum, 0)
	for _, v := range mappingListVulnerabilityScansVulnerabilityScanTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityScansVulnerabilityScanTypeEnumStringValues Enumerates the set of values in String for ListVulnerabilityScansVulnerabilityScanTypeEnum
func GetListVulnerabilityScansVulnerabilityScanTypeEnumStringValues() []string {
	return []string{
		"CVE",
		"PATCH",
		"IMAGE_PATCH",
	}
}

// GetMappingListVulnerabilityScansVulnerabilityScanTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityScansVulnerabilityScanTypeEnum(val string) (ListVulnerabilityScansVulnerabilityScanTypeEnum, bool) {
	enum, ok := mappingListVulnerabilityScansVulnerabilityScanTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
