---
title: Contributing to OPA
sidebar_label: Introduction
---

Thanks for your interest in contributing to the Open Policy Agent project!
There are all sorts of ways to get involved, whether you are a user of OPA or
interested in contributing.

:::info
Most of the discussions about OPA take place on Slack, if you haven't already,
you can [sign up here](https://slack.openpolicyagent.org/).
:::

## I'd like to help OPA users

Most users ask in the [#help](https://openpolicyagent.slack.com/archives/CBR63TK2A)
channel in Slack, hang out in there and see if there are any questions you
can help with.

You might also want to keep an eye on the
[OPA Discussion Board](https://github.com/orgs/open-policy-agent/discussions) or
on the [`#rego`](https://stackoverflow.com/questions/tagged/rego) tag on Stack
Overflow.

## I'd like to contribute code

If you have found a bug and would like to work on a fix, **we always encourage you
file a [GitHub Issue](https://github.com/open-policy-agent/opa/issues)** to talk
about the problem and the solution you have in mind. This allows you to get
feedback from maintainers before committing time to something that might already
have a solution or might not be the right approach.

If you have an idea for a new feature, we also **request that you file an
issue** to discuss it first. This again allows you to get feedback from
the maintainer team and the community before you start working on it.

If you'd like to work on an existing issue that's been stale for quite some time,
it's a good idea to comment on the issue first to check if it's still relevant, and
if there are additional details that might have emerged since it was last updated.

If you want to chat to the maintainers before opening an issue or about anything
else, head over to
[#contributors](https://openpolicyagent.slack.com/archives/C02L1TLPN59) in
Slack. This is also a great place to ask for ideas if you want to contribute, but
aren't sure what to work on!

If you are ready to start contributing code, please see our
[Contributing Code](./contrib-code/) guide for pointers on how to get
started. Please note we have some restrictions around the use of AI tooling
which are documented here.

## I'd like to help improve the documentation

Great! Please see our [Contributing Documentation](./contrib-docs) guide for
more details.

## I have an OPA project or talk I'd like to share

Awesome! For OPA-based projects, we have our [Ecosystem page](/ecosystem/).
This is a great place to showcase your project and how it uses OPA.

You can create a markdown file in:
[`docs/src/data/ecosystem/entries`](https://github.com/open-policy-agent/opa/tree/main/docs/src/data/ecosystem/entries)
and add an icon in
[`/docs/static/img/ecosystem-entry-logos`](https://github.com/open-policy-agent/opa/tree/main/docs/static/img/ecosystem-entry-logos)
to have your project listed on the ecosystem page.

If you have a talk or blog you'd like to share please feel free to post in:

- [#ecosystem](https://openpolicyagent.slack.com/archives/C02J6LBL6GH) in Slack.
- [Ecosystem Discussions](https://github.com/orgs/open-policy-agent/discussions/categories/ecosystem) on GitHub.

## I'm interested in something else...

Sounds interesting, we'd love to hear all about it,
[sign up for our Slack](https://slack.openpolicyagent.org/) and
drop a message in the
[#contributors](https://openpolicyagent.slack.com/archives/C02L1TLPN59)
channel.
