# Change Log

## [0.8.0](https://github.com/go-swagger/go-swagger/tree/0.8.0) (2016-12-23)
[Full Changelog](https://github.com/go-swagger/go-swagger/compare/0.7.4...0.8.0)

**Implemented enhancements:**

- Add server-side support for mutual tls [\#802](https://github.com/go-swagger/go-swagger/issues/802)
- Add support for pflag as alternative to go-flags [\#797](https://github.com/go-swagger/go-swagger/issues/797)
- Maintain parameter sequence in parameters scanner [\#768](https://github.com/go-swagger/go-swagger/issues/768)
- Configure TLS [\#685](https://github.com/go-swagger/go-swagger/issues/685)
- validate failing with interface is spec.Schema, not spec.Response while generate succeeds [\#594](https://github.com/go-swagger/go-swagger/issues/594)
- Support enum in parameters scanner [\#245](https://github.com/go-swagger/go-swagger/issues/245)
- Support default value in parameters scanner [\#244](https://github.com/go-swagger/go-swagger/issues/244)
- add oauth2 support in the client [\#185](https://github.com/go-swagger/go-swagger/issues/185)
- optimize tls config for server [\#799](https://github.com/go-swagger/go-swagger/pull/799) ([casualjim](https://github.com/casualjim))

**Fixed bugs:**

- client uuid/string type mismatch [\#789](https://github.com/go-swagger/go-swagger/issues/789)
- Definition field name not showing when string pattern validation failed, if use $ref to reference another one in defintions  [\#767](https://github.com/go-swagger/go-swagger/issues/767)
- If Swagger spec doesn't include a definition schema reference in a response, the generated client returns nil [\#749](https://github.com/go-swagger/go-swagger/issues/749)
- The reverse routing doesn't support basePath [\#742](https://github.com/go-swagger/go-swagger/issues/742)
- Generator makes consts generated from a swagger enum as internal to a package [\#739](https://github.com/go-swagger/go-swagger/issues/739)
- Client Generator - uuid to string [\#731](https://github.com/go-swagger/go-swagger/issues/731)
-  illegal byte order mark [\#727](https://github.com/go-swagger/go-swagger/issues/727)
- `validate` failing with out of memory error [\#605](https://github.com/go-swagger/go-swagger/issues/605)
- Log message for unsupported type is misleading. [\#600](https://github.com/go-swagger/go-swagger/issues/600)
- Possible unintended result of inheritance [\#541](https://github.com/go-swagger/go-swagger/issues/541)
- stack overflow on recursive circular ancestors [\#537](https://github.com/go-swagger/go-swagger/issues/537)
- duplicate operationId not detected [\#536](https://github.com/go-swagger/go-swagger/issues/536)
- master gets parsing error where 0.5.0 handles correctly [\#535](https://github.com/go-swagger/go-swagger/issues/535)
- Validation: invalid patterns in parameters are not detected [\#530](https://github.com/go-swagger/go-swagger/issues/530)
- invalid character 'ï' looking for beginning of value [\#496](https://github.com/go-swagger/go-swagger/issues/496)
- Code generation fails for definition with allOf and local schema [\#436](https://github.com/go-swagger/go-swagger/issues/436)
- Struct parsing cause an error: unable to resolve embedded struct for... [\#390](https://github.com/go-swagger/go-swagger/issues/390)
- generate spec for embedded struct: unknown primitive  [\#241](https://github.com/go-swagger/go-swagger/issues/241)
- Code gen: how to return empty json array [\#718](https://github.com/go-swagger/go-swagger/pull/718) ([cmhakkim](https://github.com/cmhakkim))

**Closed issues:**

- Support array type validation for $ref definitions [\#805](https://github.com/go-swagger/go-swagger/issues/805)
- Invalid enum validation check [\#804](https://github.com/go-swagger/go-swagger/issues/804)
- Question: How to include all operations? [\#800](https://github.com/go-swagger/go-swagger/issues/800)
- Some links on readme are broken [\#794](https://github.com/go-swagger/go-swagger/issues/794)
- Error types are not correctly generated \(should not use pointer\) [\#783](https://github.com/go-swagger/go-swagger/issues/783)
- NSwag is generating strange types [\#764](https://github.com/go-swagger/go-swagger/issues/764)
- Possible conflicts with vendor'ed code? [\#756](https://github.com/go-swagger/go-swagger/issues/756)
- Should generate strfmt.DateTime as a pointer?  [\#746](https://github.com/go-swagger/go-swagger/issues/746)
- Partial response with generated server using discriminator [\#743](https://github.com/go-swagger/go-swagger/issues/743)
- Is it possible to suppress the default value for a date-time filed? [\#736](https://github.com/go-swagger/go-swagger/issues/736)
- \[Question\] How to set cookies from server side [\#728](https://github.com/go-swagger/go-swagger/issues/728)

**Merged pull requests:**

- fix 805-support-array-type-validation-for-aliased-definition [\#808](https://github.com/go-swagger/go-swagger/pull/808) ([Simon-Li](https://github.com/Simon-Li))
- add test for issue 789 [\#806](https://github.com/go-swagger/go-swagger/pull/806) ([casualjim](https://github.com/casualjim))
- add support for mutual tls auth [\#803](https://github.com/go-swagger/go-swagger/pull/803) ([casualjim](https://github.com/casualjim))
- Revert "fix \#767: field-name-not-showing-if-using-ref" [\#801](https://github.com/go-swagger/go-swagger/pull/801) ([casualjim](https://github.com/casualjim))
- support pflag in addition to go-flags for the server [\#798](https://github.com/go-swagger/go-swagger/pull/798) ([casualjim](https://github.com/casualjim))
- fix \#767: field-name-not-showing-if-using-ref [\#792](https://github.com/go-swagger/go-swagger/pull/792) ([Simon-Li](https://github.com/Simon-Li))
- Support description tags in responses and support description as the … [\#788](https://github.com/go-swagger/go-swagger/pull/788) ([clawconduce](https://github.com/clawconduce))
- Added hook to configure servers on user side. [\#784](https://github.com/go-swagger/go-swagger/pull/784) ([vburenin](https://github.com/vburenin))
- Generate ReadCloser for request parameters instead of Writer. [\#780](https://github.com/go-swagger/go-swagger/pull/780) ([vburenin](https://github.com/vburenin))
- Issue \#738: Support descriptions on responses that use definitions [\#777](https://github.com/go-swagger/go-swagger/pull/777) ([clawconduce](https://github.com/clawconduce))
- 244 245 enums defaults for parameters \[quick implementation\] [\#772](https://github.com/go-swagger/go-swagger/pull/772) ([McSwitch](https://github.com/McSwitch))
- fixed parameters sequence issue [\#771](https://github.com/go-swagger/go-swagger/pull/771) ([McSwitch](https://github.com/McSwitch))
- Adds support for `\[\]\*Foo` to the other types [\#766](https://github.com/go-swagger/go-swagger/pull/766) ([jredville](https://github.com/jredville))
- Adds support for parsing `\[\]\*Foo` in parameters [\#765](https://github.com/go-swagger/go-swagger/pull/765) ([jredville](https://github.com/jredville))
- fixes a number of issues with allOf [\#760](https://github.com/go-swagger/go-swagger/pull/760) ([casualjim](https://github.com/casualjim))
- dedupe properties in discriminated types [\#759](https://github.com/go-swagger/go-swagger/pull/759) ([casualjim](https://github.com/casualjim))
- strip BOM from descriptions [\#758](https://github.com/go-swagger/go-swagger/pull/758) ([casualjim](https://github.com/casualjim))
- expose more configuration options for generated server [\#757](https://github.com/go-swagger/go-swagger/pull/757) ([casualjim](https://github.com/casualjim))
- allow for complete config of tls config outside of arguments [\#755](https://github.com/go-swagger/go-swagger/pull/755) ([casualjim](https://github.com/casualjim))
- take base path into account for the url builder [\#750](https://github.com/go-swagger/go-swagger/pull/750) ([casualjim](https://github.com/casualjim))
- Export enums [\#741](https://github.com/go-swagger/go-swagger/pull/741) ([casualjim](https://github.com/casualjim))
- client-path-param custom format fix [\#737](https://github.com/go-swagger/go-swagger/pull/737) ([casualjim](https://github.com/casualjim))
- add support for overriding http client per request [\#735](https://github.com/go-swagger/go-swagger/pull/735) ([casualjim](https://github.com/casualjim))


\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*
