// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"bytes"
	"context"
	"encoding/json"
	httpext "net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TupleWithNoValidate A tuple of NoValidateExternal external types.
//
// If the "noValidation" hint is omitted in the definition above, this code won't build because `http.Request` has no `Validate` method.
//
// Notice that "additionalItems" is not a construct that pass swagger validation,
// but is supported by go-swagger.
//
// swagger:model TupleWithNoValidate
type TupleWithNoValidate struct {

	// p0
	// Required: true
	P0 *httpext.Request `json:"-"` // custom serializer

	// p1
	// Required: true
	P1 *httpext.Request `json:"-"` // custom serializer

	// tuple with no validate items
	TupleWithNoValidateItems []httpext.Request `json:"-"`
}

// UnmarshalJSON unmarshals this tuple type from a JSON array
func (m *TupleWithNoValidate) UnmarshalJSON(raw []byte) error {
	// stage 1, get the array but just the array
	var stage1 []json.RawMessage
	buf := bytes.NewBuffer(raw)
	dec := json.NewDecoder(buf)
	dec.UseNumber()

	if err := dec.Decode(&stage1); err != nil {
		return err
	}

	// stage 2: hydrates struct members with tuple elements
	var lastIndex int

	if len(stage1) > 0 {
		var dataP0 httpext.Request
		buf = bytes.NewBuffer(stage1[0])
		dec := json.NewDecoder(buf)
		dec.UseNumber()
		if err := dec.Decode(&dataP0); err != nil {
			return err
		}
		m.P0 = &dataP0

		lastIndex = 0

	}
	if len(stage1) > 1 {
		var dataP1 httpext.Request
		buf = bytes.NewBuffer(stage1[1])
		dec := json.NewDecoder(buf)
		dec.UseNumber()
		if err := dec.Decode(&dataP1); err != nil {
			return err
		}
		m.P1 = &dataP1

		lastIndex = 1

	}

	// stage 3: hydrates AdditionalItems
	if len(stage1) > lastIndex+1 {
		for _, val := range stage1[lastIndex+1:] {
			var toadd httpext.Request
			buf = bytes.NewBuffer(val)
			dec := json.NewDecoder(buf)
			dec.UseNumber()
			if err := dec.Decode(&toadd); err != nil {
				return err
			}
			m.TupleWithNoValidateItems = append(m.TupleWithNoValidateItems, toadd)
		}
	}
	return nil
}

// MarshalJSON marshals this tuple type into a JSON array
func (m TupleWithNoValidate) MarshalJSON() ([]byte, error) {
	data := []interface{}{
		m.P0, m.P1,
	}

	for _, v := range m.TupleWithNoValidateItems {
		data = append(data, v)
	}
	return json.Marshal(data)
}

// Validate validates this tuple with no validate
func (m *TupleWithNoValidate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateP0(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateP1(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTupleWithNoValidateItems(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TupleWithNoValidate) validateP0(formats strfmt.Registry) error {

	if err := validate.Required("0", "body", m.P0); err != nil {
		return err
	}

	return nil
}

func (m *TupleWithNoValidate) validateP1(formats strfmt.Registry) error {

	if err := validate.Required("1", "body", m.P1); err != nil {
		return err
	}

	return nil
}

func (m *TupleWithNoValidate) validateTupleWithNoValidateItems(formats strfmt.Registry) error {

	return nil
}

// ContextValidate validates this tuple with no validate based on context it is used
func (m *TupleWithNoValidate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TupleWithNoValidate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TupleWithNoValidate) UnmarshalBinary(b []byte) error {
	var res TupleWithNoValidate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
