package performance

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// Metric run-time execution metric.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Performance#type-Metric
type Metric struct {
	Name  string  `json:"name"`  // Metric name.
	Value float64 `json:"value"` // Metric value.
}

// EnableTimeDomain time domain to use for collecting and reporting duration
// metrics.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Performance#method-enable
type EnableTimeDomain string

// String returns the EnableTimeDomain as string value.
func (t EnableTimeDomain) String() string {
	return string(t)
}

// EnableTimeDomain values.
const (
	EnableTimeDomainTimeTicks   EnableTimeDomain = "timeTicks"
	EnableTimeDomainThreadTicks EnableTimeDomain = "threadTicks"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *EnableTimeDomain) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch EnableTimeDomain(s) {
	case EnableTimeDomainTimeTicks:
		*t = EnableTimeDomainTimeTicks
	case EnableTimeDomainThreadTicks:
		*t = EnableTimeDomainThreadTicks
	default:
		return fmt.Errorf("unknown EnableTimeDomain value: %v", s)
	}
	return nil
}
