// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/censys/censys-sdk-go/internal/utils"
	"github.com/censys/censys-sdk-go/models/components"
	"time"
)

type V3GlobaldataAssetHostTimelineGlobals struct {
	OrganizationID *string `queryParam:"style=form,explode=true,name=organization_id"`
}

func (o *V3GlobaldataAssetHostTimelineGlobals) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

type V3GlobaldataAssetHostTimelineRequest struct {
	// The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information.
	OrganizationID *string `queryParam:"style=form,explode=false,name=organization_id"`
	// The IP address of a host.
	HostID string `pathParam:"style=simple,explode=false,name=host_id"`
	// Start time of the host timeline. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time.
	StartTime time.Time `queryParam:"style=form,explode=false,name=start_time"`
	// End time of the host timeline. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time.
	EndTime time.Time `queryParam:"style=form,explode=false,name=end_time"`
}

func (v V3GlobaldataAssetHostTimelineRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V3GlobaldataAssetHostTimelineRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V3GlobaldataAssetHostTimelineRequest) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

func (o *V3GlobaldataAssetHostTimelineRequest) GetHostID() string {
	if o == nil {
		return ""
	}
	return o.HostID
}

func (o *V3GlobaldataAssetHostTimelineRequest) GetStartTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.StartTime
}

func (o *V3GlobaldataAssetHostTimelineRequest) GetEndTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.EndTime
}

type V3GlobaldataAssetHostTimelineResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	ResponseEnvelopeHostTimeline *components.ResponseEnvelopeHostTimeline
	Headers                      map[string][]string
}

func (o *V3GlobaldataAssetHostTimelineResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V3GlobaldataAssetHostTimelineResponse) GetResponseEnvelopeHostTimeline() *components.ResponseEnvelopeHostTimeline {
	if o == nil {
		return nil
	}
	return o.ResponseEnvelopeHostTimeline
}

func (o *V3GlobaldataAssetHostTimelineResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
