// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type RejectType string

const (
	RejectTypeUnknown           RejectType = ""
	RejectTypeWrongVersion      RejectType = "wrong_version"
	RejectTypeInvalidUsername   RejectType = "invalid_username"
	RejectTypeWrongUserPw       RejectType = "wrong_user_pw"
	RejectTypeWrongServerPw     RejectType = "wrong_server_pw"
	RejectTypeUsernameInUse     RejectType = "username_in_use"
	RejectTypeServerFull        RejectType = "server_full"
	RejectTypeNoCertificate     RejectType = "no_certificate"
	RejectTypeAuthenticatorFail RejectType = "authenticator_fail"
)

func (e RejectType) ToPointer() *RejectType {
	return &e
}
func (e *RejectType) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "wrong_version":
		fallthrough
	case "invalid_username":
		fallthrough
	case "wrong_user_pw":
		fallthrough
	case "wrong_server_pw":
		fallthrough
	case "username_in_use":
		fallthrough
	case "server_full":
		fallthrough
	case "no_certificate":
		fallthrough
	case "authenticator_fail":
		*e = RejectType(v)
		return nil
	default:
		return fmt.Errorf("invalid value for RejectType: %v", v)
	}
}

type Reject struct {
	Reason *string     `json:"reason,omitempty"`
	Type   *RejectType `json:"type,omitempty"`
}

func (o *Reject) GetReason() *string {
	if o == nil {
		return nil
	}
	return o.Reason
}

func (o *Reject) GetType() *RejectType {
	if o == nil {
		return nil
	}
	return o.Type
}
