// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
	"github.com/censys/censys-sdk-go/internal/utils"
	"time"
)

type NewStatus string

const (
	NewStatusActive     NewStatus = "active"
	NewStatusPopulating NewStatus = "populating"
	NewStatusPaused     NewStatus = "paused"
	NewStatusArchived   NewStatus = "archived"
)

func (e NewStatus) ToPointer() *NewStatus {
	return &e
}
func (e *NewStatus) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "active":
		fallthrough
	case "populating":
		fallthrough
	case "paused":
		fallthrough
	case "archived":
		*e = NewStatus(v)
		return nil
	default:
		return fmt.Errorf("invalid value for NewStatus: %v", v)
	}
}

type OldStatus string

const (
	OldStatusActive     OldStatus = "active"
	OldStatusPopulating OldStatus = "populating"
	OldStatusPaused     OldStatus = "paused"
	OldStatusArchived   OldStatus = "archived"
)

func (e OldStatus) ToPointer() *OldStatus {
	return &e
}
func (e *OldStatus) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "active":
		fallthrough
	case "populating":
		fallthrough
	case "paused":
		fallthrough
	case "archived":
		*e = OldStatus(v)
		return nil
	default:
		return fmt.Errorf("invalid value for OldStatus: %v", v)
	}
}

type EventStatusChange struct {
	EventTime time.Time  `json:"event_time"`
	NewStatus NewStatus  `json:"new_status"`
	OldStatus *OldStatus `json:"old_status,omitempty"`
	Reason    *string    `json:"reason,omitempty"`
}

func (e EventStatusChange) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(e, "", false)
}

func (e *EventStatusChange) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &e, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *EventStatusChange) GetEventTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.EventTime
}

func (o *EventStatusChange) GetNewStatus() NewStatus {
	if o == nil {
		return NewStatus("")
	}
	return o.NewStatus
}

func (o *EventStatusChange) GetOldStatus() *OldStatus {
	if o == nil {
		return nil
	}
	return o.OldStatus
}

func (o *EventStatusChange) GetReason() *string {
	if o == nil {
		return nil
	}
	return o.Reason
}
